import React, { useContext } from "react";
import PropTypes from "prop-types";
import InputPresentationStyle, { StyledInputPresentationContainer } from "./input-presentation.style";
import { InputContext, InputGroupContext } from "../input-behaviour";
import { NewValidationContext } from "../../components/carbon-provider/carbon-provider.component";
const InputPresentation = ({
  align,
  borderRadius = "borderRadius050",
  children,
  disabled,
  error,
  hasIcon,
  hideBorders = false,
  info,
  inputWidth,
  maxWidth,
  positionedChildren,
  prefix,
  readOnly,
  size = "medium",
  warning
}) => {
  const {
    hasFocus,
    onMouseDown,
    onMouseEnter,
    onMouseLeave
  } = useContext(InputContext);
  const {
    validationRedesignOptIn
  } = useContext(NewValidationContext);
  const {
    onMouseEnter: onGroupMouseEnter,
    onMouseLeave: onGroupMouseLeave
  } = useContext(InputGroupContext);
  const handleMouseEnter = () => {
    if (onMouseEnter) onMouseEnter();
    if (onGroupMouseEnter) onGroupMouseEnter();
  };
  const handleMouseLeave = () => {
    if (onMouseLeave) onMouseLeave();
    if (onGroupMouseLeave) onGroupMouseLeave();
  };
  return /*#__PURE__*/React.createElement(StyledInputPresentationContainer, {
    inputWidth: inputWidth,
    maxWidth: maxWidth
  }, positionedChildren, /*#__PURE__*/React.createElement(InputPresentationStyle, {
    hasFocus: hasFocus,
    role: "presentation",
    onMouseDown: onMouseDown,
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    align: align,
    prefix: prefix,
    disabled: disabled,
    readOnly: readOnly,
    size: size,
    warning: warning,
    error: error,
    info: info,
    validationRedesignOptIn: validationRedesignOptIn,
    hasIcon: hasIcon,
    borderRadius: borderRadius,
    hideBorders: hideBorders
  }, children));
};
if (process.env.NODE_ENV !== "production") {
  InputPresentation.propTypes = {
    "align": PropTypes.string,
    "borderRadius": PropTypes.any,
    "children": PropTypes.node,
    "disabled": PropTypes.bool,
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "hasIcon": PropTypes.bool,
    "hideBorders": PropTypes.bool,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inputWidth": PropTypes.number,
    "maxWidth": PropTypes.string,
    "positionedChildren": PropTypes.node,
    "prefix": PropTypes.string,
    "readOnly": PropTypes.bool,
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool])
  };
}
export default InputPresentation;