import styled, { css } from "styled-components";
import sizes from "../input/input-sizes.style";
import addFocusStyling from "../../style/utils/add-focus-styling";
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const InputIconToggleStyle = styled.span.attrs(({
  onClick
}) => ({
  onKeyDown: event => {
    if (onClick && (event.key === " " || event.key === "Enter")) {
      event.preventDefault();
      return onClick(event);
    }
    return event;
  }
}))`
  align-items: center;
  cursor: pointer;
  display: flex;
  justify-content: center;

  ${({
  size = "medium"
}) => css`
    width: ${sizes[size].height};
  `}

  ${({
  disabled
}) => disabled && css`
      cursor: not-allowed;
    `}
  
  ${({
  readOnly
}) => readOnly && css`
      cursor: default;
    `}

  ${({
  theme
}) => `
    &:focus {
      ${!theme.focusRedesignOptOut ? addFocusStyling() : /* istanbul ignore next */oldFocusStyling}
    }  
  `}
`;
export default InputIconToggleStyle;