import React from "react";
import PropTypes from "prop-types";
import Icon from "../../components/icon";
import InputIconToggleStyle from "./input-icon-toggle.style";
import ValidationIcon from "../validations/validation-icon.component";
const shouldDisplayValidationIcon = ({
  error,
  warning,
  info
}) => {
  const validation = error || warning || info || null;
  return typeof validation === "string";
};
const InputIconToggle = ({
  disabled,
  readOnly,
  size,
  inputIcon: type,
  onClick,
  onFocus,
  onBlur,
  onMouseDown,
  error,
  warning,
  info,
  useValidationIcon,
  align,
  iconTabIndex,
  validationIconId
}) => {
  if (useValidationIcon && !disabled && shouldDisplayValidationIcon({
    error,
    warning,
    info
  })) {
    return /*#__PURE__*/React.createElement(InputIconToggleStyle, {
      size: size
    }, /*#__PURE__*/React.createElement(ValidationIcon, {
      error: error,
      warning: warning,
      info: info,
      size: size,
      onClick: onClick,
      onFocus: onFocus,
      onBlur: onBlur,
      isPartOfInput: true,
      tabIndex: iconTabIndex,
      tooltipId: validationIconId,
      tooltipPosition: align === "right" ? "left" : "right"
    }));
  }
  if (type) {
    return /*#__PURE__*/React.createElement(InputIconToggleStyle, {
      size: size,
      onClick: onClick,
      onFocus: onFocus,
      onBlur: onBlur,
      onMouseDown: onMouseDown,
      tabIndex: iconTabIndex,
      "data-element": "input-icon-toggle",
      disabled: disabled,
      readOnly: readOnly
    }, /*#__PURE__*/React.createElement(Icon, {
      disabled: disabled || readOnly,
      type: type
    }));
  }
  return null;
};
export default InputIconToggle;