import React from "react";
import { IconType } from "../../components/icon";
import { InputIconToggleStyleProps } from "./input-icon-toggle.style";
import { ValidationProps } from "../validations/validation-icon.component";
export interface InputIconToggleProps extends InputIconToggleStyleProps, ValidationProps {
    align?: "left" | "right";
    disabled?: boolean;
    iconTabIndex?: number;
    inputIcon?: IconType;
    onBlur?: (ev: React.FocusEvent<HTMLElement>) => void;
    onFocus?: (ev: React.FocusEvent<HTMLElement>) => void;
    onMouseDown?: (ev: React.MouseEvent<HTMLElement>) => void;
    readOnly?: boolean;
    tooltipId?: string;
    useValidationIcon?: boolean;
    /** Id of the validation icon */
    validationIconId?: string;
}
declare const InputIconToggle: ({ disabled, readOnly, size, inputIcon: type, onClick, onFocus, onBlur, onMouseDown, error, warning, info, useValidationIcon, align, iconTabIndex, validationIconId, }: InputIconToggleProps) => React.JSX.Element | null;
export default InputIconToggle;
