function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../utils/helpers/tags/tags";
import StyledFullScreenHeading, { StyledHeaderContainer } from "./full-screen-heading.style";
const FullScreenHeading = /*#__PURE__*/React.forwardRef((props, ref) => {
  const {
    children,
    hasContent
  } = props;
  return /*#__PURE__*/React.createElement(StyledFullScreenHeading, _extends({
    hasContent: hasContent
  }, tagComponent("full-screen-heading", props), {
    ref: ref
  }), /*#__PURE__*/React.createElement(StyledHeaderContainer, null, children));
});
if (process.env.NODE_ENV !== "production") {
  FullScreenHeading.propTypes = {
    "children": PropTypes.node,
    "hasContent": PropTypes.bool
  };
}
FullScreenHeading.displayName = "FullScreenHeading";
export default FullScreenHeading;