function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useEffect, useLayoutEffect, useMemo, useRef } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import FormFieldStyle, { FieldLineStyle } from "./form-field.style";
import Label from "../label";
import FieldHelp from "../field-help";
import tagComponent from "../utils/helpers/tags/tags";
import { TabContext } from "../../components/tabs/tab";
import useIsAboveBreakpoint from "../../hooks/__internal__/useIsAboveBreakpoint";
import useFormSpacing from "../../hooks/__internal__/useFormSpacing";
const FormField = ({
  children,
  "data-component": dataComponent,
  disabled,
  loading,
  fieldHelp: fieldHelpContent,
  fieldHelpInline,
  error,
  warning,
  info,
  tooltipId,
  fieldHelpId,
  label,
  labelId,
  labelAlign,
  labelHelp,
  labelHelpIcon,
  labelInline,
  labelSpacing = 2,
  labelWidth,
  labelAs,
  id,
  reverse,
  isOptional,
  useValidationIcon,
  adaptiveLabelBreakpoint,
  isRequired,
  validationIconId,
  validationRedesignOptIn,
  ...rest
}) => {
  const invalidValidationProp = useMemo(() => {
    const validationProps = {
      error: !!error,
      warning: !!warning,
      info: !!info
    };
    if (!(disabled && !loading)) return undefined;
    return Object.keys(validationProps).find(propName => validationProps[propName]);
  }, [error, warning, info, disabled]);
  !(invalidValidationProp === undefined) ? process.env.NODE_ENV !== "production" ? invariant(false, `Prop \`${invalidValidationProp}\` cannot be used in conjunction with \`disabled\`. ` + "Use `readOnly` if you require users to see validations with a non-interactive field") : invariant(false) : void 0;
  !!(isRequired && isOptional) ? process.env.NODE_ENV !== "production" ? invariant(false, "an input cannot be set to both required and optional at the same time") : invariant(false) : void 0;
  const largeScreen = useIsAboveBreakpoint(adaptiveLabelBreakpoint);
  let inlineLabel = labelInline;
  if (adaptiveLabelBreakpoint) {
    inlineLabel = largeScreen;
  }
  const {
    setError,
    setWarning,
    setInfo
  } = useContext(TabContext);
  const marginProps = useFormSpacing(rest);
  const isMounted = useRef(false);
  useLayoutEffect(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  useEffect(() => {
    if (setError) setError(id, error);
    if (setWarning) setWarning(id, warning);
    if (setInfo) setInfo(id, info);
    return () => {
      if (!isMounted.current) {
        if (setError && error) setError(id, false);
        if (setWarning && warning) setWarning(id, false);
        if (setInfo && info) setInfo(id, false);
      }
    };
  }, [id, setError, setWarning, setInfo, error, warning, info]);
  const fieldHelp = fieldHelpContent ? /*#__PURE__*/React.createElement(FieldHelp, {
    labelInline: inlineLabel,
    labelWidth: labelWidth,
    id: fieldHelpId
  }, fieldHelpContent) : null;
  return /*#__PURE__*/React.createElement(FormFieldStyle, _extends({}, tagComponent(dataComponent, rest), marginProps), /*#__PURE__*/React.createElement(FieldLineStyle, {
    inline: inlineLabel
  }, reverse && children, label && /*#__PURE__*/React.createElement(Label, {
    labelId: labelId,
    align: labelAlign,
    disabled: disabled,
    error: !validationRedesignOptIn && error,
    warning: !validationRedesignOptIn && warning,
    info: !validationRedesignOptIn && info,
    help: labelHelp,
    tooltipId: tooltipId,
    htmlFor: id,
    helpIcon: labelHelpIcon,
    inline: inlineLabel,
    width: labelWidth,
    optional: isOptional,
    useValidationIcon: useValidationIcon,
    pr: !reverse ? labelSpacing : undefined,
    pl: reverse ? labelSpacing : undefined,
    isRequired: isRequired,
    validationIconId: validationIconId,
    as: labelAs
  }, label), fieldHelpInline && fieldHelp, !reverse && children), !fieldHelpInline && fieldHelp);
};
FormField.displayName = "FormField";
export default FormField;