import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../validations";
import { LabelProps } from "../label";
import { TagProps } from "../utils/helpers/tags/tags";
import { IconType } from "../../components/icon";
interface CommonFormFieldProps extends MarginProps, ValidationProps {
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** @private @ignore */
    loading?: boolean;
    /** Help content to be displayed under an input */
    fieldHelp?: React.ReactNode;
    /** The unique id of the Help component tooltip, used for accessibility */
    tooltipId?: string;
    /** The unique id of the FieldHelp component */
    fieldHelpId?: string;
    /** Label content */
    label?: React.ReactNode;
    /** Text alignment of the label */
    labelAlign?: "left" | "right";
    /** A message that the Help component will display */
    labelHelp?: React.ReactNode;
    /** Help Icon type */
    labelHelpIcon?: IconType;
    /** The unique id of the label element */
    labelId?: string;
    /** When true label is inline */
    labelInline?: boolean;
    /** Spacing between label and a field for inline label, given number will be multiplied by base spacing unit (8) */
    labelSpacing?: 1 | 2;
    /** Label width */
    labelWidth?: number;
    labelAs?: LabelProps["as"];
    /** If true the label switches position with the input */
    reverse?: boolean;
    /** Id of the validation icon */
    validationIconId?: string;
    /**
     * @private @ignore
     * Flag dedicating if latest validation design should be used */
    validationRedesignOptIn?: boolean;
}
export interface FormFieldProps extends CommonFormFieldProps, TagProps {
    /** Breakpoint for adaptive label (inline labels change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Content to be rendered inside the FormField */
    children?: React.ReactNode;
    /**
     * If true, the FieldHelp will be displayed inline
     * To be used with labelInline prop set to true
     */
    fieldHelpInline?: boolean;
    /** Id of the element a label should be bound to */
    id: string;
    /** Flag to configure component as optional in Form */
    isOptional?: boolean;
    /** Flag to configure component as mandatory */
    isRequired?: boolean;
    /** Whether to show the validation icon */
    useValidationIcon?: boolean;
}
declare const FormField: {
    ({ children, "data-component": dataComponent, disabled, loading, fieldHelp: fieldHelpContent, fieldHelpInline, error, warning, info, tooltipId, fieldHelpId, label, labelId, labelAlign, labelHelp, labelHelpIcon, labelInline, labelSpacing, labelWidth, labelAs, id, reverse, isOptional, useValidationIcon, adaptiveLabelBreakpoint, isRequired, validationIconId, validationRedesignOptIn, ...rest }: FormFieldProps): React.JSX.Element;
    displayName: string;
};
export default FormField;
