import styled, { css } from "styled-components";
import { margin } from "styled-system";
import BaseTheme from "../../style/themes/base";
const StyledFieldset = styled.fieldset`
  margin: 0;
  ${margin}
  border: none;
  padding: 0;
  min-width: 0;
  min-inline-size: 0;
  ${({
  width
}) => width && `width: ${width};`}
`;
StyledFieldset.defaultProps = {
  theme: BaseTheme
};
const StyledLegendContent = styled.span`
  display: flex;
  align-items: center;
  line-height: 24px;
  ${({
  isRequired
}) => isRequired && css`
      ::after {
        content: "*";
        line-height: 24px;
        color: var(--colorsSemanticNegative500);
        font-weight: var(--fontWeights700);
        margin-left: var(--spacing050);
        position: relative;
        top: 1px;
      }
    `}

  ${({
  isOptional
}) => isOptional && css`
      ::after {
        content: "(optional)";
        color: var(--colorsUtilityYin055);
        font-weight: var(--fontWeights400);
        margin-left: var(--spacing050);
      }
    `}

  ${({
  isDisabled
}) => isDisabled && css`
      color: var(--colorsUtilityYin030);
      ::after {
        color: var(--colorsUtilityYin030);
      }
    `}
`;
const StyledLegend = styled.legend`
  display: flex;
  align-items: center;
  margin-bottom: var(--spacing100);
  padding: 0;
  font-weight: var(--fontWeights700);
  color: var(--colorsUtilityYin090);
  ${({
  inline,
  width,
  align,
  rightPadding
}) => inline && css`
      float: left;
      box-sizing: border-box;
      margin: 0;
      ${width && `width: ${width}%`};
      justify-content: ${align === "right" ? "flex-end" : "flex-start"};
      padding-right: ${rightPadding === 1 ? "var(--spacing100)" : "var(--spacing200)"};
    `}
  ${margin}
`;
export { StyledFieldset, StyledLegend, StyledLegendContent };