function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useEffect, useState } from "react";
import PropTypes from "prop-types";
import { StyledFieldset, StyledLegend, StyledLegendContent } from "./fieldset.style";
import ValidationIcon from "../validations/validation-icon.component";
import { NewValidationContext } from "../../components/carbon-provider/carbon-provider.component";
import { InputGroupBehaviour, InputGroupContext } from "../input-behaviour";
import useFormSpacing from "../../hooks/__internal__/useFormSpacing";
const Fieldset = ({
  legend,
  children,
  inline = false,
  legendWidth,
  legendAlign = "right",
  legendSpacing = 2,
  error,
  warning,
  info,
  isRequired,
  blockGroupBehaviour,
  legendMargin = {},
  isDisabled,
  isOptional,
  ...rest
}) => {
  const {
    validationRedesignOptIn
  } = useContext(NewValidationContext);
  const marginProps = useFormSpacing(rest);
  const [ref, setRef] = useState(null);
  useEffect(() => {
    if (ref && isRequired) {
      Array.from(ref.querySelectorAll("input") || /* istanbul ignore next */[]).forEach(el => {
        el.setAttribute("required", "");
      });
    }
  }, [ref, isRequired]);
  return /*#__PURE__*/React.createElement(InputGroupBehaviour, {
    blockGroupBehaviour: blockGroupBehaviour
  }, /*#__PURE__*/React.createElement(StyledFieldset, _extends({
    ref: setRef,
    "data-component": "fieldset"
  }, rest, marginProps), legend && /*#__PURE__*/React.createElement(InputGroupContext.Consumer, null, ({
    onMouseEnter,
    onMouseLeave
  }) => /*#__PURE__*/React.createElement(StyledLegend, _extends({
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    inline: inline,
    width: legendWidth,
    align: legendAlign,
    rightPadding: legendSpacing
  }, legendMargin, {
    "data-element": "legend"
  }), /*#__PURE__*/React.createElement(StyledLegendContent, {
    isRequired: isRequired,
    isOptional: isOptional,
    isDisabled: isDisabled
  }, legend, !validationRedesignOptIn && /*#__PURE__*/React.createElement(ValidationIcon, {
    error: error,
    warning: warning,
    info: info,
    tooltipFlipOverrides: ["top", "bottom"]
  })))), children));
};
export default Fieldset;