function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import { StyledCheckableInput, StyledCheckableInputWrapper } from "./checkable-input.style";
import { InputBehaviour } from "../input-behaviour";
import FormField from "../form-field";
import HiddenCheckableInput from "./hidden-checkable-input.component";
import guid from "../utils/helpers/guid";
import useInputAccessibility from "../../hooks/__internal__/useInputAccessibility";
const CheckableInput = /*#__PURE__*/React.forwardRef(({
  ariaLabelledBy,
  autoFocus,
  checked,
  children,
  disabled,
  loading,
  error,
  fieldHelp,
  fieldHelpInline,
  info,
  id: inputId,
  type,
  value,
  inputWidth,
  label,
  labelHelp,
  labelInline = true,
  labelSpacing = 1,
  labelWidth,
  name,
  onBlur,
  onChange,
  onFocus,
  required,
  isOptional,
  reverse = false,
  validationOnLabel,
  warning,
  ...props
}, ref) => {
  const {
    current: id
  } = useRef(inputId || guid());
  const {
    labelId,
    fieldHelpId,
    validationId,
    ariaDescribedBy
  } = useInputAccessibility({
    id,
    error,
    warning,
    info,
    label,
    fieldHelp
  });
  const formFieldProps = {
    disabled,
    loading,
    error,
    fieldHelp,
    fieldHelpInline,
    fieldHelpId,
    id,
    info,
    label,
    labelHelp,
    labelHelpIcon: "info",
    labelId,
    labelInline,
    labelSpacing,
    reverse,
    warning,
    validationIconId: validationId,
    // We don't want an asterisk on each radio control, only the legend
    // However, we still want the input element to receive the required prop
    isRequired: required,
    isOptional,
    useValidationIcon: validationOnLabel
  };
  const inputProps = {
    ariaDescribedBy,
    "aria-labelledby": ariaLabelledBy,
    "aria-invalid": !!error,
    autoFocus,
    checked,
    disabled,
    id,
    type,
    value,
    name,
    onBlur,
    onChange,
    onFocus,
    required,
    ref,
    validationIconId: validationId,
    ...props
  };
  return /*#__PURE__*/React.createElement(StyledCheckableInputWrapper, {
    disabled: disabled,
    fieldHelpInline: fieldHelpInline,
    inputWidth: inputWidth,
    labelWidth: labelWidth,
    labelInline: labelInline,
    reverse: reverse
  }, /*#__PURE__*/React.createElement(InputBehaviour, null, /*#__PURE__*/React.createElement(FormField, _extends({}, formFieldProps, {
    my: 0
  }), /*#__PURE__*/React.createElement(StyledCheckableInput, null, /*#__PURE__*/React.createElement(HiddenCheckableInput, inputProps), children))));
});
if (process.env.NODE_ENV !== "production") {
  CheckableInput.propTypes = {
    "about": PropTypes.string,
    "accept": PropTypes.string,
    "accessKey": PropTypes.string,
    "alt": PropTypes.string,
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaDescribedBy": PropTypes.string,
    "ariaLabelledBy": PropTypes.string,
    "autoCapitalize": PropTypes.string,
    "autoComplete": PropTypes.string,
    "autoCorrect": PropTypes.string,
    "autoFocus": PropTypes.bool,
    "autoSave": PropTypes.string,
    "capture": PropTypes.oneOfType([PropTypes.oneOf(["environment", "user"]), PropTypes.bool]),
    "checked": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "content": PropTypes.string,
    "contentEditable": PropTypes.oneOfType([PropTypes.oneOf(["false", "inherit", "true"]), PropTypes.bool]),
    "contextMenu": PropTypes.string,
    "dangerouslySetInnerHTML": PropTypes.shape({
      "__html": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
    }),
    "datatype": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "defaultValue": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.number, PropTypes.string]),
    "dir": PropTypes.string,
    "disabled": PropTypes.bool,
    "draggable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "enterKeyHint": PropTypes.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "fieldHelp": PropTypes.node,
    "fieldHelpInline": PropTypes.bool,
    "form": PropTypes.string,
    "formAction": PropTypes.string,
    "formEncType": PropTypes.string,
    "formMethod": PropTypes.string,
    "formNoValidate": PropTypes.bool,
    "formTarget": PropTypes.string,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "hidden": PropTypes.bool,
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inlist": PropTypes.any,
    "inputMode": PropTypes.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": PropTypes.number,
    "is": PropTypes.string,
    "isOptional": PropTypes.bool,
    "itemID": PropTypes.string,
    "itemProp": PropTypes.string,
    "itemRef": PropTypes.string,
    "itemScope": PropTypes.bool,
    "itemType": PropTypes.string,
    "label": PropTypes.node,
    "labelHelp": PropTypes.node,
    "labelInline": PropTypes.bool,
    "labelSpacing": PropTypes.oneOf([1, 2]),
    "labelWidth": PropTypes.number,
    "lang": PropTypes.string,
    "list": PropTypes.string,
    "loading": PropTypes.bool,
    "max": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "maxLength": PropTypes.number,
    "min": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "minLength": PropTypes.number,
    "multiple": PropTypes.bool,
    "name": PropTypes.string,
    "nonce": PropTypes.string,
    "onAbort": PropTypes.func,
    "onAbortCapture": PropTypes.func,
    "onAnimationEnd": PropTypes.func,
    "onAnimationEndCapture": PropTypes.func,
    "onAnimationIteration": PropTypes.func,
    "onAnimationIterationCapture": PropTypes.func,
    "onAnimationStart": PropTypes.func,
    "onAnimationStartCapture": PropTypes.func,
    "onAuxClick": PropTypes.func,
    "onAuxClickCapture": PropTypes.func,
    "onBeforeInput": PropTypes.func,
    "onBeforeInputCapture": PropTypes.func,
    "onBlur": PropTypes.func,
    "onBlurCapture": PropTypes.func,
    "onCanPlay": PropTypes.func,
    "onCanPlayCapture": PropTypes.func,
    "onCanPlayThrough": PropTypes.func,
    "onCanPlayThroughCapture": PropTypes.func,
    "onChange": PropTypes.func,
    "onChangeCapture": PropTypes.func,
    "onClick": PropTypes.func,
    "onClickCapture": PropTypes.func,
    "onCompositionEnd": PropTypes.func,
    "onCompositionEndCapture": PropTypes.func,
    "onCompositionStart": PropTypes.func,
    "onCompositionStartCapture": PropTypes.func,
    "onCompositionUpdate": PropTypes.func,
    "onCompositionUpdateCapture": PropTypes.func,
    "onContextMenu": PropTypes.func,
    "onContextMenuCapture": PropTypes.func,
    "onCopy": PropTypes.func,
    "onCopyCapture": PropTypes.func,
    "onCut": PropTypes.func,
    "onCutCapture": PropTypes.func,
    "onDoubleClick": PropTypes.func,
    "onDoubleClickCapture": PropTypes.func,
    "onDrag": PropTypes.func,
    "onDragCapture": PropTypes.func,
    "onDragEnd": PropTypes.func,
    "onDragEndCapture": PropTypes.func,
    "onDragEnter": PropTypes.func,
    "onDragEnterCapture": PropTypes.func,
    "onDragExit": PropTypes.func,
    "onDragExitCapture": PropTypes.func,
    "onDragLeave": PropTypes.func,
    "onDragLeaveCapture": PropTypes.func,
    "onDragOver": PropTypes.func,
    "onDragOverCapture": PropTypes.func,
    "onDragStart": PropTypes.func,
    "onDragStartCapture": PropTypes.func,
    "onDrop": PropTypes.func,
    "onDropCapture": PropTypes.func,
    "onDurationChange": PropTypes.func,
    "onDurationChangeCapture": PropTypes.func,
    "onEmptied": PropTypes.func,
    "onEmptiedCapture": PropTypes.func,
    "onEncrypted": PropTypes.func,
    "onEncryptedCapture": PropTypes.func,
    "onEnded": PropTypes.func,
    "onEndedCapture": PropTypes.func,
    "onError": PropTypes.func,
    "onErrorCapture": PropTypes.func,
    "onFocus": PropTypes.func,
    "onFocusCapture": PropTypes.func,
    "onGotPointerCapture": PropTypes.func,
    "onGotPointerCaptureCapture": PropTypes.func,
    "onInput": PropTypes.func,
    "onInputCapture": PropTypes.func,
    "onInvalid": PropTypes.func,
    "onInvalidCapture": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onKeyDownCapture": PropTypes.func,
    "onKeyPress": PropTypes.func,
    "onKeyPressCapture": PropTypes.func,
    "onKeyUp": PropTypes.func,
    "onKeyUpCapture": PropTypes.func,
    "onLoad": PropTypes.func,
    "onLoadCapture": PropTypes.func,
    "onLoadedData": PropTypes.func,
    "onLoadedDataCapture": PropTypes.func,
    "onLoadedMetadata": PropTypes.func,
    "onLoadedMetadataCapture": PropTypes.func,
    "onLoadStart": PropTypes.func,
    "onLoadStartCapture": PropTypes.func,
    "onLostPointerCapture": PropTypes.func,
    "onLostPointerCaptureCapture": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "onMouseDownCapture": PropTypes.func,
    "onMouseEnter": PropTypes.func,
    "onMouseLeave": PropTypes.func,
    "onMouseMove": PropTypes.func,
    "onMouseMoveCapture": PropTypes.func,
    "onMouseOut": PropTypes.func,
    "onMouseOutCapture": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "onMouseOverCapture": PropTypes.func,
    "onMouseUp": PropTypes.func,
    "onMouseUpCapture": PropTypes.func,
    "onPaste": PropTypes.func,
    "onPasteCapture": PropTypes.func,
    "onPause": PropTypes.func,
    "onPauseCapture": PropTypes.func,
    "onPlay": PropTypes.func,
    "onPlayCapture": PropTypes.func,
    "onPlaying": PropTypes.func,
    "onPlayingCapture": PropTypes.func,
    "onPointerCancel": PropTypes.func,
    "onPointerCancelCapture": PropTypes.func,
    "onPointerDown": PropTypes.func,
    "onPointerDownCapture": PropTypes.func,
    "onPointerEnter": PropTypes.func,
    "onPointerEnterCapture": PropTypes.func,
    "onPointerLeave": PropTypes.func,
    "onPointerLeaveCapture": PropTypes.func,
    "onPointerMove": PropTypes.func,
    "onPointerMoveCapture": PropTypes.func,
    "onPointerOut": PropTypes.func,
    "onPointerOutCapture": PropTypes.func,
    "onPointerOver": PropTypes.func,
    "onPointerOverCapture": PropTypes.func,
    "onPointerUp": PropTypes.func,
    "onPointerUpCapture": PropTypes.func,
    "onProgress": PropTypes.func,
    "onProgressCapture": PropTypes.func,
    "onRateChange": PropTypes.func,
    "onRateChangeCapture": PropTypes.func,
    "onReset": PropTypes.func,
    "onResetCapture": PropTypes.func,
    "onScroll": PropTypes.func,
    "onScrollCapture": PropTypes.func,
    "onSeeked": PropTypes.func,
    "onSeekedCapture": PropTypes.func,
    "onSeeking": PropTypes.func,
    "onSeekingCapture": PropTypes.func,
    "onSelect": PropTypes.func,
    "onSelectCapture": PropTypes.func,
    "onStalled": PropTypes.func,
    "onStalledCapture": PropTypes.func,
    "onSubmit": PropTypes.func,
    "onSubmitCapture": PropTypes.func,
    "onSuspend": PropTypes.func,
    "onSuspendCapture": PropTypes.func,
    "onTimeUpdate": PropTypes.func,
    "onTimeUpdateCapture": PropTypes.func,
    "onTouchCancel": PropTypes.func,
    "onTouchCancelCapture": PropTypes.func,
    "onTouchEnd": PropTypes.func,
    "onTouchEndCapture": PropTypes.func,
    "onTouchMove": PropTypes.func,
    "onTouchMoveCapture": PropTypes.func,
    "onTouchStart": PropTypes.func,
    "onTouchStartCapture": PropTypes.func,
    "onTransitionEnd": PropTypes.func,
    "onTransitionEndCapture": PropTypes.func,
    "onVolumeChange": PropTypes.func,
    "onVolumeChangeCapture": PropTypes.func,
    "onWaiting": PropTypes.func,
    "onWaitingCapture": PropTypes.func,
    "onWheel": PropTypes.func,
    "onWheelCapture": PropTypes.func,
    "pattern": PropTypes.string,
    "placeholder": PropTypes.string,
    "prefix": PropTypes.string,
    "property": PropTypes.string,
    "radioGroup": PropTypes.string,
    "readOnly": PropTypes.bool,
    "rel": PropTypes.string,
    "required": PropTypes.bool,
    "resource": PropTypes.string,
    "results": PropTypes.number,
    "rev": PropTypes.string,
    "reverse": PropTypes.bool,
    "role": PropTypes.oneOfType([PropTypes.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "security": PropTypes.string,
    "size": PropTypes.oneOf(["large", "small"]),
    "slot": PropTypes.string,
    "spellCheck": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "src": PropTypes.string,
    "step": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "style": PropTypes.object,
    "suppressContentEditableWarning": PropTypes.bool,
    "suppressHydrationWarning": PropTypes.bool,
    "tabIndex": PropTypes.number,
    "title": PropTypes.string,
    "translate": PropTypes.oneOf(["no", "yes"]),
    "type": PropTypes.string.isRequired,
    "typeof": PropTypes.string,
    "unselectable": PropTypes.oneOf(["off", "on"]),
    "validationIconId": PropTypes.string,
    "validationOnLabel": PropTypes.bool,
    "value": PropTypes.string,
    "vocab": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "width": PropTypes.oneOfType([PropTypes.number, PropTypes.string])
  };
}
CheckableInput.displayName = "CheckableInput";
export default CheckableInput;