import React from "react";
import PropTypes from "prop-types";
import { StyledCharacterCountWrapper, StyledCharacterCount, VisuallyHiddenCharacterCount, VisuallyHiddenHint } from "./character-count.style";
import useLocale from "../../hooks/__internal__/useLocale";
const CharacterCount = ({
  value,
  debouncedValue = value,
  limit,
  isDebouncedOverLimit,
  isOverLimit,
  visuallyHiddenHintId
}) => {
  const limitMinusValue = +limit - +value;
  const valueMinusLimit = +value - +limit;
  const debouncedLimitMinusValue = +limit - +debouncedValue;
  const debouncedValueMinusLimit = debouncedValue - +limit;
  const l = useLocale();
  const getFormatNumber = (rawValue, locale) => new Intl.NumberFormat(locale).format(rawValue);
  return /*#__PURE__*/React.createElement(StyledCharacterCountWrapper, null, /*#__PURE__*/React.createElement(VisuallyHiddenHint, {
    "data-element": "visually-hidden-hint",
    id: visuallyHiddenHintId
  }, l.characterCount.visuallyHiddenHint(getFormatNumber(limit, l.locale()))), /*#__PURE__*/React.createElement(StyledCharacterCount, {
    "aria-hidden": "true",
    isOverLimit: isOverLimit,
    "data-element": "character-count"
  }, !isOverLimit ? l.characterCount.charactersLeft(limitMinusValue, getFormatNumber(limitMinusValue, l.locale())) : l.characterCount.tooManyCharacters(valueMinusLimit, getFormatNumber(valueMinusLimit, l.locale()))), /*#__PURE__*/React.createElement(VisuallyHiddenCharacterCount, {
    "data-element": "visually-hidden-character-count",
    "aria-live": "polite"
  }, !isDebouncedOverLimit ? l.characterCount.charactersLeft(debouncedLimitMinusValue, getFormatNumber(debouncedLimitMinusValue, l.locale())) : l.characterCount.tooManyCharacters(debouncedValueMinusLimit, getFormatNumber(debouncedValueMinusLimit, l.locale()))));
};
export default CharacterCount;