import type { ModuleContext } from '../module/moduleContext';
import type { ChartOptions } from '../module/optionsModule';
import type { AgChartInstance, AgChartOptions } from '../options/chart/chartBuilderOptions';
import { BBox } from '../scene/bbox';
import { Group } from '../scene/group';
import { Scene } from '../scene/scene';
import type { PlacedLabel } from '../scene/util/labelPlacement';
import { Observable } from '../util/observable';
import { Padding } from '../util/padding';
import { BaseProperties } from '../util/properties';
import { Caption } from './caption';
import type { ChartAnimationPhase } from './chartAnimationPhase';
import type { ChartAxis } from './chartAxis';
import { ChartContext } from './chartContext';
import { ChartHighlight } from './chartHighlight';
import type { ChartMode } from './chartMode';
import { ChartUpdateType } from './chartUpdateType';
import type { HighlightChangeEvent } from './interaction/highlightManager';
import type { PointerInteractionEvent, PointerOffsets } from './interaction/interactionManager';
import { ZoomManager } from './interaction/zoomManager';
import { Keyboard } from './keyboard';
import { type SeriesOptionsTypes } from './mapping/types';
import { ModulesManager } from './modulesManager';
import { ChartOverlays } from './overlay/chartOverlays';
import { type Series } from './series/series';
import { SeriesLayerManager } from './series/seriesLayerManager';
import { Tooltip, TooltipPointerEvent } from './tooltip/tooltip';
import type { UpdateOpts } from './updateService';
export type TransferableResources = {
    container?: HTMLElement;
    scene: Scene;
    element: HTMLElement;
};
export interface ChartSpecialOverrides {
    document?: Document;
    window?: Window;
    overrideDevicePixelRatio?: number;
    sceneMode?: 'simple';
}
export type ChartExtendedOptions = AgChartOptions & ChartSpecialOverrides;
type PointerOffsetsAndHistory = PointerOffsets & {
    pointerHistory?: PointerOffsets[];
};
declare class SeriesArea extends BaseProperties {
    clip?: boolean;
    padding: Padding;
}
export declare abstract class Chart extends Observable implements AgChartInstance {
    private static readonly chartsInstances;
    static getInstance(element: HTMLElement): Chart | undefined;
    readonly id: string;
    className?: string;
    readonly seriesRoot: Group;
    readonly highlightRoot: Group;
    readonly annotationRoot: Group;
    readonly tooltip: Tooltip;
    readonly overlays: ChartOverlays;
    readonly highlight: ChartHighlight;
    private readonly debug;
    private extraDebugStats;
    container?: HTMLElement;
    data: any;
    width?: number;
    height?: number;
    autoSize: boolean;
    /** NOTE: This is exposed for use by Integrated charts only. */
    get canvasElement(): HTMLCanvasElement;
    /** NOTE: This is exposed for use by Integrated charts only. */
    getCanvasDataURL(fileFormat?: string): string;
    private _lastAutoSize?;
    private _firstAutoSize;
    private onAutoSizeChange;
    download(fileName?: string, fileFormat?: string): void;
    readonly padding: Padding;
    readonly seriesArea: SeriesArea;
    readonly title: Caption;
    readonly subtitle: Caption;
    readonly footnote: Caption;
    readonly keyboard: Keyboard;
    mode: ChartMode;
    destroyed: boolean;
    private _skipSync;
    private readonly _destroyFns;
    chartAnimationPhase: ChartAnimationPhase;
    readonly modulesManager: ModulesManager;
    readonly zoomManager: ZoomManager;
    readonly ctx: ChartContext;
    protected readonly axisGridGroup: Group;
    protected readonly axisGroup: Group;
    protected readonly seriesLayerManager: SeriesLayerManager;
    private readonly sizeMonitor;
    private readonly processors;
    processedOptions: AgChartOptions & {
        type?: SeriesOptionsTypes['type'];
    };
    userOptions: AgChartOptions;
    queuedUserOptions: AgChartOptions[];
    chartOptions: ChartOptions;
    getOptions(): AgChartOptions;
    protected constructor(options: ChartOptions, resources?: TransferableResources);
    getModuleContext(): ModuleContext;
    getAriaLabel(): string;
    resetAnimations(): void;
    skipAnimations(): void;
    destroy(opts?: {
        keepTransferableResources: boolean;
    }): TransferableResources | undefined;
    resetPointer(highlightOnly?: boolean): void;
    requestFactoryUpdate(cb: (chart: Chart) => Promise<void> | void): void;
    private _pendingFactoryUpdatesCount;
    private _performUpdateNoRenderCount;
    private _performUpdateSkipAnimations;
    private performUpdateType;
    private updateShortcutCount;
    private seriesToUpdate;
    private updateMutex;
    private updateRequestors;
    private performUpdateTrigger;
    update(type?: ChartUpdateType, opts?: UpdateOpts): void;
    private _performUpdateSplits;
    private performUpdate;
    private updateThemeClassName;
    private updateDOM;
    private checkUpdateShortcut;
    private checkFirstAutoSize;
    readonly element: HTMLElement;
    axes: ChartAxis[];
    series: Series<any, any>[];
    protected onAxisChange(newValue: ChartAxis[], oldValue?: ChartAxis[]): void;
    protected onSeriesChange(newValue: Series<any, any>[], oldValue?: Series<any, any>[]): void;
    protected destroySeries(allSeries: Series<any, any>[]): void;
    private addSeriesListeners;
    updateAllSeriesListeners(): void;
    protected assignSeriesToAxes(): void;
    protected assignAxesToSeries(): void;
    private rawResize;
    private resize;
    updateData(): Promise<void>;
    processData(): Promise<void>;
    placeLabels(): Map<Series<any, any>, PlacedLabel[]>;
    private getLegendData;
    private processLayout;
    protected performLayout(): Promise<BBox>;
    protected hoverRect?: BBox;
    protected seriesRect?: BBox;
    protected animationRect?: BBox;
    private pickSeriesNode;
    private lastPick?;
    protected onMouseMove(event: PointerInteractionEvent<'hover'>): void;
    protected onLeave(event: PointerInteractionEvent<'leave'>): void;
    private onBrowserFocus;
    private onAnimationStart;
    private onBlur;
    private onTab;
    private onNavVert;
    private onNavHori;
    private onSubmit;
    private onContextMenu;
    private focus;
    private handleFocus;
    private handleSeriesFocus;
    private lastInteractionEvent?;
    private static isHoverEvent;
    private pointerScheduler;
    protected handlePointer(event: TooltipPointerEvent<'hover' | 'keyboard'>, redisplay: boolean): void;
    protected handlePointerTooltip(event: TooltipPointerEvent<'hover'>, disablePointer: (highlightOnly?: boolean) => void): void;
    protected handlePointerNode(event: PointerOffsetsAndHistory): void;
    protected onClick(event: PointerInteractionEvent<'click'>): void;
    protected onDoubleClick(event: PointerInteractionEvent<'dblclick'>): void;
    private checkSeriesNodeClick;
    private checkSeriesNodeDoubleClick;
    private checkSeriesNodeRange;
    private onSeriesNodeClick;
    private onSeriesNodeDoubleClick;
    private seriesGroupingChanged;
    changeHighlightDatum(event: HighlightChangeEvent): void;
    waitForUpdate(timeoutMs?: number, failOnTimeout?: boolean): Promise<void>;
    private dataProcessListeners;
    waitForDataProcess(timeout?: number): Promise<void>;
    protected getMinRects(): {
        minRect: BBox;
        minVisibleRect: BBox;
    } | undefined;
    private filterMiniChartSeries;
    applyOptions(chartOptions: ChartOptions): void;
    private maybeResetAnimations;
    private shouldForceNodeDataRefresh;
    private applyMiniChartOptions;
    private applyModules;
    private applySeries;
    private applyAxes;
    private createSeries;
    private applySeriesOptionModules;
    private applySeriesValues;
    private createAxis;
    private applyAxisModules;
    private registerListeners;
}
export {};
