// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/index.d.ts
declare module '@sage/xtrem-x3-system-utils/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/index' {
	import * as datatypes from '@sage/xtrem-x3-system-utils/lib/data-types/index';
	import * as enums from '@sage/xtrem-x3-system-utils/lib/enums/index';
	import * as nodes from '@sage/xtrem-x3-system-utils/lib/nodes/index';
	import * as serviceOptions from '@sage/xtrem-x3-system-utils/lib/service-options/index';
	import { UserAccessCode, allowedAccessCodes, getSizingFromActivityCode } from '@sage/xtrem-x3-system-utils/lib/services/index';
	export { UserAccessCode, allowedAccessCodes, datatypes, enums, getSizingFromActivityCode, nodes, serviceOptions };
	export function updateContext(): void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/services/x3-service-option-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-service-option-manager' {
	import { Context, ServiceOption, ServiceOptionManager } from '@sage/xtrem-core';
	export class XtremX3ServiceOptionManager extends ServiceOptionManager {
	    isServiceOptionEnabled(context: Context, serviceOption: ServiceOption): Promise<boolean>;
	    setServiceOptionActiveState(): Promise<void>;
	    private getLanguageFromLocale;
	    /**
	     * Get the activity code etag from the database (max UPDDATTIM_0)
	     * @param context
	     * @returns
	     */
	    private static getActivityCodeEtag;
	    private static activityCodeEtag;
	    /**
	     * Verify the activity code etag from the database
	     * @param context
	     * @returns
	     */
	    private static verifyActivityCodeEtag;
	    private static lastCacheCheck;
	    /**
	     * Verify the activity code cache is still valid
	     * @param context
	     * @returns
	     */
	    private static verifyActivityCodeCache;
	    private loadCurrentLanguageCode;
	    private loadSizingActivityCodes;
	    getEnabledServiceOptions(context: Context): Promise<ServiceOption[]>;
	}
	/**
	 * Get maxRepeat of denormalized node based on sizing activity code
	 * @param context
	 * @param activityCode
	 * @returns
	 */
	export function getSizingFromActivityCode(context: Context, activityCode: string): number;
	//# sourceMappingURL=x3-service-option-manager.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/services/x3-package-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-package-manager' {
	import { Application, Context, Package, PackageManager } from '@sage/xtrem-core';
	export class X3PackageManager extends PackageManager {
	    readonly application: Application;
	    constructor(application: Application);
	    /**
	     * Get the package etag from the database (max UPDDATTIM_0)
	     * @param context
	     * @returns
	     */
	    private static getPackageEtag;
	    private static packageEtag;
	    /**
	     * Verify the package etag from the database
	     * @param context
	     * @returns
	     */
	    private static verifyPackageEtag;
	    private static lastCacheCheck;
	    /**
	     * Verify the package cache is still valid
	     * @param context
	     * @returns
	     */
	    private static verifyPackageCache;
	    getActivePackageNames(context: Context): Promise<string[]>;
	    getCurrentVersion(pack: Package, _context?: Context): Promise<string | undefined>;
	    validatePackageVersions(): Promise<void>;
	    createSqlSchemaAndTables(): Promise<boolean>;
	    ensureSchemaExists(): Promise<void>;
	    createOrUpgradePackageAllocations(_context: Context, _activePackageNames?: string[]): Promise<void>;
	}
	//# sourceMappingURL=x3-package-manager.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/services/x3-localization-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-localization-manager' {
	import { Context } from '@sage/xtrem-core';
	import { X3LocalizationManager } from '@sage/xtrem-x3-gateway';
	export class XtremX3LocalizationManager implements X3LocalizationManager {
	    private localeLangMap;
	    private folderDefaultLangMap;
	    initializeManager(): void;
	    getDefaultTenantLocale(): string;
	    isMasterLocale(): boolean;
	    createTenantLocale(): void;
	    getLanguageFromLocale(context: Context, locale: string, folderName: string): Promise<string>;
	    getFolderDefaultLanguage(context: Context): Promise<string>;
	}
	//# sourceMappingURL=x3-localization-manager.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/services/x3-access-rights-manager.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/x3-access-rights-manager' {
	import { AccessRightsManager, ActivityInfo, Context, UserAccess, UserInfo } from '@sage/xtrem-core';
	import { UserAccessCode } from '@sage/xtrem-x3-gateway';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	export { UserAccessCode };
	export class XtremX3AccessRightsManager implements AccessRightsManager {
	    private static _getUserAccessCodes;
	    private static _getOptionsByFunctionCode;
	    static getUsername(context: Context): Promise<string>;
	    private static _loadRightsFromDb;
	    /**
	     * Get the rights etag from the database (RIGHTSETAG parameter value)
	     * @param context
	     * @returns
	     */
	    private static getRightsEtag;
	    private static rightsEtag;
	    /**
	     * Verify the rights etag from the database
	     * @param context
	     * @returns
	     */
	    private static verifyRightsEtag;
	    private static lastCacheCheck;
	    /**
	     * Verify the user cache is still valid
	     * @param context
	     * @returns
	     */
	    private static verifyUserCache;
	    private static _getAccessRights;
	    private static getSiteCodes;
	    /**
	     * Returns whether a user (from his/her user code) can access a function (from its code)
	     *
	     * @param context
	     * @param nodeName
	     * @param option the access context (''/undefined=read, C=create, M=Modify, S=Delete, ...)
	     */
	    getUserAccessFor(context: Context, nodeName: string, propertyOrOperation?: string, options?: {
	        authorizationCode?: string;
	    }): Promise<UserAccess>;
	    /**
	     * Gets the list of access codes that the user is allowed to access
	     *
	     * @param context
	     * @returns the list of access codes if controlled, null if the user can see all access codes.
	     */
	    getUserAccessCodes(context: Context): Promise<UserAccessCode[] | null>;
	    /**
	     * Returns whether a user (from his/her user code) can access a property (from its accessCode)
	     *
	     * @param {Context} context
	     * @param {string} accessCode
	     * @returns {boolean}
	     * @memberof X3AccessRightsManager
	     */
	    isAccessCodeAvailable(context: Context, accessCode: string): Promise<boolean>;
	    /**
	     * Returns the user code for a given login
	     *
	     * @param {Context} context
	     * @param {string} code
	     */
	    getUser(context: Context, code: string): Promise<UserInfo>;
	    createAdminUser(): Promise<void>;
	    createRequiredUsers(): void;
	    ensureAdminPersonaCreated(): UserInfo;
	    private static transformUserToUserInfo;
	    getCurrentUser(context: Context): Promise<UserInfo>;
	    getUserNode(): typeof x3SystemUtils.nodes.SysUser;
	    getPermissions(context: Context, activity: string): Promise<string[]>;
	    createActivities(): Promise<void>;
	    updateActivities(): Promise<void>;
	    deleteActivities(): Promise<void>;
	    getActivityNode(): typeof x3SystemUtils.nodes.SysActivityCode;
	    getActivitiesInfo(): ActivityInfo[];
	    supportsPersona(): boolean;
	    getPersonaUser(): UserInfo | null;
	    getDemoPersonas(): UserInfo[];
	    invalidateAuthorizationCache(context: Context): Promise<void>;
	}
	export const accessRightsManager: XtremX3AccessRightsManager;
	export function allowedAccessCodes(context: Context): Promise<string[] | null>;
	//# sourceMappingURL=x3-access-rights-manager.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/services/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/services/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-access-rights-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-localization-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-package-manager';
	export * from '@sage/xtrem-x3-system-utils/lib/services/x3-service-option-manager';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/service-options/sys-business-intelligence.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/service-options/sys-business-intelligence' {
	import { ServiceOption } from '@sage/xtrem-core';
	export const sysBusinessIntelligenceActivityCode: ServiceOption;
	//# sourceMappingURL=sys-business-intelligence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/service-options/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/service-options/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/service-options/sys-business-intelligence';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-user.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user' {
	import { BinaryStream, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL columnName: AUTILIS */
	export class SysUser extends Node {
	    /** 4GL columnName: ENAFLG */
	    readonly activeInSelec: Promise<boolean | null>;
	    /** 4GL columnName: NOMUSR */
	    readonly name: Promise<string>;
	    /** 4GL columnName: INTUSR */
	    readonly nameDescription: Promise<string>;
	    /** 4GL columnName: USR */
	    readonly code: Promise<string>;
	    /** 4GL columnName: ALLACS */
	    readonly allAccessCodes: Promise<boolean | null>;
	    /** 4GL columnName: USREXT */
	    readonly externalUser: Promise<boolean | null>;
	    /** 4GL columnName: FNCCOD */
	    readonly functions: Promise<string>;
	    /** 4GL columnName: CODMET */
	    readonly profession: Reference<x3SystemUtils.nodes.SysSyracusMethod | null>;
	    /** 4GL columnName: PRFFCT */
	    readonly functionProfile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile | null>;
	    /** 4GL columnName: ADDEML */
	    readonly email: Promise<string>;
	    readonly displayName: Promise<string>;
	    /** 4GL columnName: LOGIN */
	    readonly login: Promise<string>;
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
	    /** 4GL columnName: ARCPRF */
	    readonly profile: Promise<string>;
	    /** 4GL columnName: AUSPIC */
	    readonly _image: Reference<x3SystemUtils.nodes.SysImage | null>;
	    readonly photo: Promise<BinaryStream | null>;
	}
	//# sourceMappingURL=sys-user.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-user-parameter-value.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-parameter-value' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ADOVALAUS */
	export class SysUserParameterValue extends Node {
	    /** 4GL code: CODUSR */
	    readonly user: Reference<x3SystemUtils.nodes.SysUser | null>;
	    /** 4GL code: PARAM */
	    readonly description: Promise<string>;
	    /** 4GL code: VALEUR */
	    readonly value: Promise<string>;
	    /** 4GL code: JEU */
	    readonly defaultSetOfValues: Reference<x3SystemUtils.nodes.SysMiscellaneousTable | null>;
	}
	//# sourceMappingURL=sys-user-parameter-value.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-user-function-profile.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-function-profile' {
	import { Node } from '@sage/xtrem-core';
	/** 4GL code: AFCTFCT */
	export class SysUserFunctionProfile extends Node {
	    /** 4GL code: PRFCOD */
	    readonly profile: Promise<string>;
	    /** 4GL code: INTPRF */
	    readonly description: Promise<string>;
	    /** 4GL code: ALLACS */
	    readonly allAccessAllowed: Promise<boolean | null>;
	    /** 4GL code: DIFIMP */
	    readonly deferredPrint: Promise<boolean | null>;
	    /** 4GL code: FILTRE */
	    readonly reportFilters: Promise<string>;
	    /** 4GL code: ALLFCT */
	    readonly allAuthorizedFunctions: Promise<boolean | null>;
	    /** 4GL code: FLGPOR */
	    readonly fixedDashboard: Promise<boolean | null>;
	}
	//# sourceMappingURL=sys-user-function-profile.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-user-access.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-access' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ACCES */
	export class SysUserAccess extends Node {
	    /** 4GL code: CODACC */
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess>;
	    /** 4GL columnName: USR */
	    readonly user: Reference<x3SystemUtils.nodes.SysUser>;
	    /** 4GL columnName: CONSUL */
	    readonly inquiry: Promise<boolean | null>;
	    /** 4GL columnName: EXEC */
	    readonly execution: Promise<boolean | null>;
	    /** 4GL columnName: MODIF */
	    readonly modification: Promise<boolean | null>;
	    /** 4GL columnName: PRFCOD */
	    readonly profile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile | null>;
	}
	//# sourceMappingURL=sys-user-access.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-syracus-method.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-syracus-method' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ASYRMET */
	export class SysSyracusMethod extends Node {
	    /** 4GL code: CODMET */
	    readonly profession: Promise<string>;
	    /** 4GL code: INTMET */
	    readonly description: Promise<string>;
	    /** 4GL code: PRFFCT */
	    readonly functionProfile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile>;
	    /** 4GL code: USRBI */
	    readonly biUserProfile: Promise<string>;
	}
	//# sourceMappingURL=sys-syracus-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-site.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-site' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: FACILITY */
	export class SysSite extends Node {
	    /** 4GL code: FCY */
	    readonly code: Promise<string>;
	    /** 4GL code: FCYNAM */
	    readonly name: Promise<string>;
	    /** 4GL code: WRHFLG */
	    readonly isStockSite: Promise<boolean>;
	    /** 4GL code: LEGCPY */
	    readonly legalCompany: Reference<x3SystemUtils.nodes.SysCompany>;
	}
	//# sourceMappingURL=sys-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-miscellaneous-tables.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables' {
	import { Collection, integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL columnName: ATABTAB */
	export class SysMiscellaneousTables extends Node {
	    /** 4GL columnName: NUMTAB */
	    readonly glossaryId: Promise<integer>;
	    /** 4GL columnName: NUMCAR */
	    readonly tableNumber: Promise<string>;
	    /** 4GL columnName: LNGDES */
	    readonly description: Promise<string>;
	    /** 4GL columnName: SHODES */
	    readonly shortDescription: Promise<string>;
	    /** 4GL columnName: CODACT */
	    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
	    /** 4GL columnName: ACS */
	    readonly access: Reference<x3SystemUtils.nodes.SysAccess | null>;
	    /** 4GL columnName: MODULE */
	    readonly module: Promise<x3SystemUtils.enums.SysModuleTable | null>;
	    /** 4GL columnName: DEPNUM */
	    readonly dependency: Reference<SysMiscellaneousTables | null>;
	    /** 4GL columnName: LNGFLG */
	    readonly modifiableLength: Promise<boolean | null>;
	    /** 4GL columnName: LNG */
	    readonly length: Promise<integer>;
	    /** 4GL columnName: FLGSOC */
	    readonly companyFilter: Promise<boolean | null>;
	    /** 4GL columnName: FLGLEG */
	    readonly filterLegislation: Promise<boolean | null>;
	    /** 4GL columnName: FLGENA */
	    readonly activeFlag: Promise<boolean | null>;
	    /** 4GL columnName: ALPDES1 */
	    readonly alpha1: Promise<string>;
	    /** 4GL columnName: CODTYP1 */
	    readonly type1: Promise<string>;
	    /** 4GL columnName: SUP1 */
	    readonly option1: Promise<string>;
	    /** 4GL columnName: ALPDES2 */
	    readonly alpha2: Promise<string>;
	    /** 4GL columnName: CODTYP2 */
	    readonly type2: Promise<string>;
	    /** 4GL columnName: SUP2 */
	    readonly option2: Promise<string>;
	    /** 4GL columnName: NUMDES1 */
	    readonly numeric1: Promise<string>;
	    /** 4GL columnName: CODTYP3 */
	    readonly type3: Promise<string>;
	    /** 4GL columnName: SUP3 */
	    readonly option3: Promise<string>;
	    /** 4GL columnName: NUMDES2 */
	    readonly numeric2: Promise<string>;
	    /** 4GL columnName: CODTYP4 */
	    readonly type4: Promise<string>;
	    /** 4GL columnName: SUP4 */
	    readonly option4: Promise<string>;
	    /** 4GL code: NBCOL */
	    readonly number: Promise<integer>;
	    readonly columns: Collection<x3SystemUtils.nodes.SysMiscellaneousTablesColumns>;
	    /** 4GL columnName: OBLLEG */
	    readonly legislationMandatory: Promise<boolean>;
	}
	//# sourceMappingURL=sys-miscellaneous-tables.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-miscellaneous-tables-columns.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables-columns' {
	import { integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	import { SysMiscellaneousTables } from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables';
	/** 4GL columnName: ATABTAB */
	export class SysMiscellaneousTablesColumns extends Node {
	    /** 4GL columnName: NUMTAB */
	    readonly glossaryId: Promise<integer>;
	    readonly _denormalizedParent: Reference<SysMiscellaneousTables | null>;
	    readonly denormalizedIndex: Promise<integer>;
	    /** 4GL code: COLTYPTYP */
	    readonly columnType: Promise<x3SystemUtils.enums.SysSequenceNumberType>;
	    /** 4GL code: COLDES */
	    readonly description1: Promise<string>;
	    /** 4GL code: COLTYP */
	    readonly dataType: Promise<string>;
	    /** 4GL columnName: COLSUP */
	    readonly option: Promise<string>;
	}
	//# sourceMappingURL=sys-miscellaneous-tables-columns.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-miscellaneous-table.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-table' {
	import { decimal, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: ATABDIV */
	export class SysMiscellaneousTable extends Node {
	    /** 4GL code: NUMTAB */
	    readonly glossaryId: Reference<x3SystemUtils.nodes.SysMiscellaneousTables>;
	    /** 4GL code: CODE */
	    readonly code: Promise<string>;
	    /** 4GL code: LNGDES */
	    readonly description: Promise<string>;
	    /** 4GL code: SHODES */
	    readonly shortDescription: Promise<string>;
	    /** 4GL code: DEFVAL */
	    readonly defaultValue: Promise<boolean | null>;
	    /** 4GL code: DEPCOD */
	    readonly dependency: Reference<SysMiscellaneousTable | null>;
	    /** 4GL code: SOC */
	    readonly groupOfCompany: Promise<string>;
	    /** 4GL code: LEG */
	    readonly legislation: Reference<x3SystemUtils.nodes.SysMiscellaneousTable | null>;
	    /** 4GL code: ENAFLG */
	    readonly activeFlag: Promise<boolean | null>;
	    /** 4GL code: A1 */
	    readonly alpha1: Promise<string>;
	    /** 4GL code: A2 */
	    readonly alpha2: Promise<string>;
	    /** 4GL code: A3 */
	    readonly alpha3: Promise<string>;
	    /** 4GL code: A4 */
	    readonly alpha4: Promise<string>;
	    /** 4GL code: A5 */
	    readonly alpha5: Promise<string>;
	    /** 4GL code: A6 */
	    readonly alpha6: Promise<string>;
	    /** 4GL code: A7 */
	    readonly alpha7: Promise<string>;
	    /** 4GL code: A8 */
	    readonly alpha8: Promise<string>;
	    /** 4GL code: A9 */
	    readonly alpha9: Promise<string>;
	    /** 4GL code: A10 */
	    readonly alpha10: Promise<string>;
	    /** 4GL code: A11 */
	    readonly alpha11: Promise<string>;
	    /** 4GL code: A12 */
	    readonly alpha12: Promise<string>;
	    /** 4GL code: A13 */
	    readonly alpha13: Promise<string>;
	    /** 4GL code: A14 */
	    readonly alpha14: Promise<string>;
	    /** 4GL code: A15 */
	    readonly alpha15: Promise<string>;
	    /** 4GL code: N1 */
	    readonly numeric1: Promise<decimal>;
	    /** 4GL code: N2 */
	    readonly numeric2: Promise<decimal>;
	    /** 4GL code: N3 */
	    readonly numeric3: Promise<decimal>;
	    /** 4GL code: N4 */
	    readonly numeric4: Promise<decimal>;
	    /** 4GL code: N5 */
	    readonly numeric5: Promise<decimal>;
	    /** 4GL code: N6 */
	    readonly numeric6: Promise<decimal>;
	    /** 4GL code: N7 */
	    readonly numeric7: Promise<decimal>;
	    /** 4GL code: N8 */
	    readonly numeric8: Promise<decimal>;
	    /** 4GL code: N9 */
	    readonly numeric9: Promise<decimal>;
	    /** 4GL code: N10 */
	    readonly numeric10: Promise<decimal>;
	    /** 4GL code: N11 */
	    readonly numeric11: Promise<decimal>;
	    /** 4GL code: N12 */
	    readonly numeric12: Promise<decimal>;
	    /** 4GL code: N13 */
	    readonly numeric13: Promise<decimal>;
	    /** 4GL code: N14 */
	    readonly numeric14: Promise<decimal>;
	    /** 4GL code: N15 */
	    readonly numeric15: Promise<decimal>;
	}
	//# sourceMappingURL=sys-miscellaneous-table.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-language.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-language' {
	import { Node, Reference } from '@sage/xtrem-core';
	/** 4GL code: TABLAN */
	export class SysLanguage extends Node {
	    /** 4GL code: LAN */
	    readonly code: Promise<string>;
	    /** 4GL code: LANSTD */
	    readonly standardLanguage: Promise<boolean | null>;
	    /** 4GL code: LANISO */
	    readonly iso: Promise<string>;
	    /** 4GL code: LANUNI */
	    readonly unicodeLanguage: Promise<boolean | null>;
	    /** 4GL code: LANCON */
	    readonly connectionLanguage: Promise<boolean | null>;
	    /** 4GL code: LANRPL */
	    readonly backupLanguage: Reference<SysLanguage | null>;
	    /** 4GL code: INTSHO */
	    readonly shortDescription: Promise<string>;
	    /** 4GL code: INTDES */
	    readonly description: Promise<string>;
	    /** 4GL code: LANMAIN */
	    readonly primaryLanguage: Promise<string>;
	}
	//# sourceMappingURL=sys-language.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-image.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-image' {
	import { BinaryStream, Node } from '@sage/xtrem-core';
	export class SysImage extends Node {
	    readonly code: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly identifier3: Promise<string>;
	    readonly fileName: Promise<string>;
	    readonly data: Promise<BinaryStream>;
	    readonly specialFileType: Promise<number>;
	}
	//# sourceMappingURL=sys-image.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-functional-profile.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: AFCTPRF */
	export class SysFunctionalProfile extends Node {
	    /** 4GL code: PRFCOD */
	    readonly profile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile>;
	    /** 4GL code: FNC */
	    readonly function: Reference<x3SystemUtils.nodes.SysFunction>;
	    /** 4GL code: OPT */
	    readonly options: Promise<string>;
	    /** 4GL code: ACS */
	    readonly access: Promise<boolean>;
	    /** 4GL code: FCYGRUCOD */
	    readonly menu: Promise<boolean>;
	    /** 4GL code: FCYGRU */
	    readonly siteGrouping: Promise<string>;
	    readonly profileForAllSites: Reference<x3SystemUtils.nodes.SysFunctionalProfilePerSite | null>;
	}
	//# sourceMappingURL=sys-functional-profile.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-functional-profile-per-site.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile-per-site' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: AFCTFCY */
	export class SysFunctionalProfilePerSite extends Node {
	    /** 4GL code: FCY */
	    readonly site: Reference<x3SystemUtils.nodes.SysSite | null>;
	    /** 4GL code: PRFCOD */
	    readonly profile: Reference<x3SystemUtils.nodes.SysUserFunctionProfile>;
	    /** 4GL code: FNC */
	    readonly function: Reference<x3SystemUtils.nodes.SysFunction>;
	    /** 4GL code: OPT */
	    readonly options: Promise<string>;
	}
	//# sourceMappingURL=sys-functional-profile-per-site.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-function.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-function' {
	import { integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: EDIFNC */
	export class SysFunction extends Node {
	    /** 4GL code: MODULE */
	    readonly module: Promise<x3SystemUtils.enums.SysModuleTable | null>;
	    /** 4GL code: CODINT */
	    readonly internal: Promise<string>;
	    /** 4GL code: CODACT */
	    readonly activityCode: Reference<x3SystemUtils.nodes.SysActivityCode | null>;
	    /** 4GL code: CODEXT */
	    readonly external: Promise<string>;
	    /** 4GL code: NUMFNC */
	    readonly number: Promise<integer>;
	    /** 4GL code: LIBMENU */
	    readonly menuTitle: Promise<integer>;
	    /** 4GL code: MENU */
	    readonly parentMenu: Promise<string>;
	    /** 4GL code: NBOPT */
	    readonly noOfOptions: Promise<integer>;
	    /** 4GL code: FLAG */
	    readonly options: Promise<string[]>;
	    /** 4GL code: ACTOPT */
	    readonly activityCode1: Promise<string>;
	    /** 4GL code: OPTION */
	    readonly optionTitle: Promise<integer>;
	    /** 4GL code: FNCOPT */
	    readonly function: Promise<string>;
	    /** 4GL code: RANG */
	    readonly rowInMenu: Promise<integer>;
	    /** 4GL code: TRAIT */
	    readonly menuProcess: Promise<string>;
	    /** 4GL code: TYP */
	    readonly accessTypeObject: Promise<boolean>;
	    /** 4GL code: NBVAR */
	    readonly numberOfVariables: Promise<integer>;
	    /** 4GL code: ACTVAR */
	    readonly activityCode2: Promise<string>;
	    /** 4GL code: VALEUR */
	    readonly value: Promise<string[]>;
	    /** 4GL code: VARIA */
	    readonly variable: Promise<string>;
	    /** 4GL code: VALPAR */
	    readonly parameterValue: Promise<string[]>;
	    /** 4GL code: TRTENT */
	    readonly entryPoints: Promise<string>;
	    /** 4GL code: FCYAUZ */
	    readonly authorizationSite: Promise<boolean>;
	    /** 4GL code: MONO */
	    readonly single: Promise<boolean>;
	}
	//# sourceMappingURL=sys-function.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-company.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-company' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL code: COMPANY */
	export class SysCompany extends Node {
	    /** 4GL code: CPY */
	    readonly code: Promise<string>;
	    /** 4GL code: CPYLEGFLG */
	    readonly isLegalCompany: Promise<boolean | null>;
	    /** 4GL code: LEG */
	    readonly legislation: Reference<x3SystemUtils.nodes.SysMiscellaneousTable>;
	    /** 4GL code: CPYNAM */
	    readonly name: Promise<string>;
	    /** 4GL code: CPYSHO */
	    readonly shortDescription: Promise<string>;
	}
	//# sourceMappingURL=sys-company.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-activity-code.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-activity-code' {
	import { integer, Node, Reference } from '@sage/xtrem-core';
	import * as x3SystemUtils from '@sage/xtrem-x3-system-utils/lib/index';
	/** 4GL columnName: ACTIV */
	export class SysActivityCode extends Node {
	    /** 4GL columnName: CODACT */
	    readonly code: Promise<string>;
	    /** 4GL columnName: LIBACT */
	    readonly description: Promise<integer>;
	    /** 4GL columnName: DIME */
	    readonly screenSize: Promise<integer>;
	    /** 4GL columnName: DIMFIL */
	    readonly databaseMinimumSize: Promise<integer>;
	    /** 4GL columnName: MODULE */
	    readonly module: Promise<x3SystemUtils.enums.SysModuleTable>;
	    /** 4GL columnName: DIMMAX */
	    readonly maximumSize: Promise<integer>;
	    /** 4GL columnName: RANG */
	    readonly sequence: Promise<integer>;
	    /** 4GL columnName: ORDRE */
	    readonly order: Promise<integer>;
	    /** 4GL code: TYP */
	    readonly type: Promise<x3SystemUtils.enums.SysTypesOfActivityCode | null>;
	    /** 4GL code: DEP */
	    readonly dependency: Promise<x3SystemUtils.enums.SysTypeOfDependency | null>;
	    /** 4GL columnName: FLACT */
	    readonly activeFlag: Promise<boolean | null>;
	    /** 4GL columnName: INTIT */
	    readonly description1: Promise<string>;
	    /** 4GL columnName: ACTDEP */
	    readonly activityCode: Reference<SysActivityCode | null>;
	    /** 4GL columnName: ACTFOR */
	    readonly formula: Promise<string>;
	}
	//# sourceMappingURL=sys-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/sys-access.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/sys-access' {
	import { Node } from '@sage/xtrem-core';
	/** 4GL code: ACCCOD */
	export class SysAccess extends Node {
	    /** 4GL code: CODACC */
	    readonly access: Promise<string>;
	    /** 4GL code: INTACC */
	    readonly description: Promise<string>;
	    /** 4GL code: DESACC */
	    readonly description1: Promise<string>;
	}
	//# sourceMappingURL=sys-access.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/nodes/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/nodes/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-access';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-activity-code';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-company';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-function';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-functional-profile-per-site';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-image';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-language';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-table';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-miscellaneous-tables-columns';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-site';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-syracus-method';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-access';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-function-profile';
	export * from '@sage/xtrem-x3-system-utils/lib/nodes/sys-user-parameter-value';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/enums/sys-types-of-activity-code.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-types-of-activity-code' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysTypesOfActivityCodeEnum {
	    functional = 1,
	    sizing = 2,
	    localization = 3
	}
	export type SysTypesOfActivityCode = keyof typeof SysTypesOfActivityCodeEnum;
	export const sysTypesOfActivityCodeDataType: EnumDataType<"sizing" | "functional" | "localization", unknown>;
	//# sourceMappingURL=sys-types-of-activity-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/enums/sys-type-of-dependency.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-type-of-dependency' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysTypeOfDependencyEnum {
	    none = 1,
	    reverse = 2,
	    sizing = 3,
	    formula = 4
	}
	export type SysTypeOfDependency = keyof typeof SysTypeOfDependencyEnum;
	export const sysTypeOfDependencyDataType: EnumDataType<"none" | "reverse" | "sizing" | "formula", unknown>;
	//# sourceMappingURL=sys-type-of-dependency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/enums/sys-sequence-number-type.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-sequence-number-type' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysSequenceNumberTypeEnum {
	    alphanumeric = 1,
	    numeric = 2
	}
	export type SysSequenceNumberType = keyof typeof SysSequenceNumberTypeEnum;
	export const sysSequenceNumberTypeDataType: EnumDataType<"alphanumeric" | "numeric", unknown>;
	//# sourceMappingURL=sys-sequence-number-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/enums/sys-module-table.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/sys-module-table' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum SysModuleTableEnum {
	    supervisor = 1,
	    financials = 2,
	    aparAccounting = 3,
	    external = 4,
	    sales = 5,
	    purchasing = 6,
	    stock = 7,
	    manufacturing = 8,
	    commonData = 9,
	    development = 10,
	    sageX3Internals = 11,
	    helpDesk = 12,
	    crmActivities = 13,
	    fixedAssets = 14,
	    humanResourcesAdministration = 15,
	    moduleSpe1 = 16,
	    moduleSpe2 = 17,
	    moduleSpe3 = 18,
	    moduleSpe4 = 19,
	    humanCapitalManagement = 20
	}
	export type SysModuleTable = keyof typeof SysModuleTableEnum;
	export const sysModuleTableDataType: EnumDataType<"supervisor" | "financials" | "aparAccounting" | "external" | "sales" | "purchasing" | "stock" | "manufacturing" | "commonData" | "development" | "sageX3Internals" | "helpDesk" | "crmActivities" | "fixedAssets" | "humanResourcesAdministration" | "moduleSpe1" | "moduleSpe2" | "moduleSpe3" | "moduleSpe4" | "humanCapitalManagement", unknown>;
	//# sourceMappingURL=sys-module-table.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/enums/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/enums/index' {
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-module-table';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-sequence-number-type';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-type-of-dependency';
	export * from '@sage/xtrem-x3-system-utils/lib/enums/sys-types-of-activity-code';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/data-types/index.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/data-types/index' {
	import * as genericDataTypes from '@sage/xtrem-x3-system-utils/lib/data-types/data-types';
	export { genericDataTypes };
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-system-utils/build/lib/data-types/data-types.d.ts
declare module '@sage/xtrem-x3-system-utils/lib/data-types/data-types' {
	import { DecimalDataType, StringDataType } from '@sage/xtrem-core';
	export const textDatatype: StringDataType<unknown, string>;
	export const translatableTextDatatype: StringDataType<unknown, string>;
	export const decimalDatatype: DecimalDataType<unknown, number>;
	//# sourceMappingURL=data-types.d.ts.map
}
declare module '@sage/xtrem-x3-system-utils' {
	export * from '@sage/xtrem-x3-system-utils/index';
}
