/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.allowedAccessCodes=exports.accessRightsManager=exports.XtremX3AccessRightsManager=void 0;const xtrem_decimal_1=require("@sage/xtrem-decimal"),typesLib=xtrem_decimal_1,xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),x3SystemUtils=require(".."),logger=xtrem_core_1.Logger.getLogger(__filename,"access-rights");class XtremX3AccessRightsManager{static async _getUserAccessCodes(e,t){return e.query(x3SystemUtils.nodes.SysUserAccess,{filter:{user:await t.code,access:{_ne:""}}}).map(async e=>({accessCode:await(await e.access).access,modification:await e.modification,execution:await e.execution,inquiry:await e.inquiry})).toArray()}static async _getOptionsByFunctionCode(e,t){const s={};if(!await t.allAuthorizedFunctions){const a=await e.query(x3SystemUtils.nodes.SysFunctionalProfile,{filter:{profileForAllSites:{profile:await t.profile},access:true},orderBy:{function:1}}).toArray();await(0,xtrem_core_1.asyncArray)(a).forEach(async e=>{s[await(await e.function).internal]=await e.options})}return s}static async getUsername(e){const t=(await e.user)?.userName;if(!t)throw new xtrem_shared_1.LogicError("Username not set in context.");return t}static async _loadRightsFromDb(e){const t=await this.getUsername(e),s=await e.read(x3SystemUtils.nodes.SysUser,{code:t.toUpperCase()}),a=await s.profession,i=a?await a.functionProfile:await s.functionProfile;if(!i)throw new Error(`${await s.code}: functional profile missing`);const r=await s.allAccessCodes?null:await XtremX3AccessRightsManager._getUserAccessCodes(e,s),c=await i.allAuthorizedFunctions||false,n=await XtremX3AccessRightsManager._getOptionsByFunctionCode(e,i);return{userCode:t,profile:await i.profile,accessCodes:r,allFunctionsAllowed:c,optionsByFunctionCode:n,sitesByFunctionCode:{}}}static async getRightsEtag(e){const t=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),s=`SELECT VALEUR_0 AS RIGHTSETAG  FROM ${xtrem_x3_gateway_1.FolderManager.getFolderName({context:e})}.ADOVAL WHERE PARAM_0 = 'RIGHTSETAG'`,a=await t.execute(s);if(a.length)return a[0].RIGHTSETAG;return}static async verifyRightsEtag(e){const t=await XtremX3AccessRightsManager.getRightsEtag(e);if(typesLib.eq(XtremX3AccessRightsManager.rightsEtag,null))return XtremX3AccessRightsManager.rightsEtag=t,true;const s=typesLib.strictEq(XtremX3AccessRightsManager.rightsEtag,t);return logger.debug(()=>`Rights etag verification from DB: ${s}`),logger.debug(()=>`Rights etag verification stored: ${t}`),XtremX3AccessRightsManager.rightsEtag=t,s}static async verifyUserCache(e){const t=new Date;if(XtremX3AccessRightsManager.lastCacheCheck=XtremX3AccessRightsManager.lastCacheCheck||t,typesLib.lt(typesLib.sub(t.getTime(),XtremX3AccessRightsManager.lastCacheCheck.getTime()),3e4))return;if(XtremX3AccessRightsManager.lastCacheCheck=t,!await XtremX3AccessRightsManager.verifyRightsEtag(e))logger.debug(()=>"AccessRightManager cache invalidation."),await e.invalidateCachedCategory("AccessRightManager")}static async _getAccessRights(e){await this.verifyUserCache(e);const t=await this.getUsername(e);return e.getCachedValue({category:"AccessRightManager",key:`${e.schemaName}/${t}`,getValue:async()=>{const s=await logger.verboseAsync(()=>`Loading access rights for ${t}`);try{const t=await XtremX3AccessRightsManager._loadRightsFromDb(e);return s.success(),{value:t}}catch(e){throw s.fail(`Failed to load access rights : ${e.stack}`),e}},cacheInMemory:true,ttlInSeconds:3600})}static async getSiteCodes(e,t,s,a){if(t.allFunctionsAllowed)return null;const i=`${s}/${a}`;let r=t.sitesByFunctionCode[i];if(typesLib.strictEq(r,void 0))r=await e.query(x3SystemUtils.nodes.SysFunctionalProfilePerSite,{filter:{profile:t.profile,function:s,site:{_ne:""}}}).filter(async e=>!!await((await e.site)?.code)&&(typesLib.strictEq(a,"")||(await e.options).includes(a))).map(async e=>(await e.site)?.code||"").toArray(),t.sitesByFunctionCode[i]=r;return r}async getUserAccessFor(e,t,s="",a){const i={sites:[],accessCodes:[],status:"unavailable"};let r=a?.authorizationCode;const c=e.application.getFactoryByName(t),n=await XtremX3AccessRightsManager._getAccessRights(e);if(!await c.isEnabledByServiceOptions(e))return i;if(n.allFunctionsAllowed)return{sites:null,accessCodes:null,status:"authorized"};const o=c.queries.find(e=>typesLib.strictEq(e.name,s))||c.mutations.find(e=>typesLib.strictEq(e.name,s)),g=c.externalStorageManager,l=n.accessCodes?.filter(e=>e.modification||e.inquiry).map(e=>e.accessCode)||null;let u="";const d={create:"C",update:"M",delete:"S",read:"",lookup:""};if(typesLib.ne(o,null)){if(!r)r=o.authorizationCode||c.authorizationCode;if(r){let t="";if(g.accessMapping&&g.accessMapping[s]){const a=g.accessMapping[s];t=typesLib.strictEq(typeof a,"function")?a(e):a}u=typesLib.eq(d[t],null)?t:d[t]}}else{if(!r)r=c.authorizationCode;u=d[s]||""}if(typesLib.eq(r,null))return{sites:null,accessCodes:l,status:"authorized"};const y=await XtremX3AccessRightsManager.getSiteCodes(e,n,r,u),h=n.optionsByFunctionCode[r];if(typesLib.strictEq(h,void 0))return{sites:y,accessCodes:l,status:"unauthorized"};if(typesLib.strictNe(h,null)&&typesLib.strictNe(u,"")&&typesLib.lt(h.indexOf(u),0))return{sites:y,accessCodes:l,status:"unauthorized"};return{sites:y,accessCodes:l,status:"authorized"}}async getUserAccessCodes(e){return(await XtremX3AccessRightsManager._getAccessRights(e)).accessCodes}async isAccessCodeAvailable(e,t){if(!t)return true;const s=await XtremX3AccessRightsManager._getAccessRights(e),a=s.accessCodes?.filter(e=>e.modification||e.inquiry).map(e=>e.accessCode)||[];return!s.accessCodes||a.includes(t)}getUser(e,t){const s=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}),a=t.toUpperCase(),i=`${s}/${a}`;return e.getCachedValue({category:"User",key:i,getValue:async()=>{const t=await e.query(x3SystemUtils.nodes.SysUser,{filter:{login:a}}).toArray();let s;if(!t.length){if(s=await e.tryRead(x3SystemUtils.nodes.SysUser,{code:a}),!s)throw Error(`User does not exist for X3 user ${a}.`)}else[s]=t;return{value:await XtremX3AccessRightsManager.transformUserToUserInfo(s)}},cacheInMemory:true,ttlInSeconds:60})}async createAdminUser(){}createRequiredUsers(){}ensureAdminPersonaCreated(){return xtrem_core_1.adminDemoPersona}static async transformUserToUserInfo(e){const{activeInSelec:t,code:s,nameDescription:a,photo:i,email:r}=e;return{_id:await s,email:await r||"noreply@sage.com",firstName:await a,isActive:await t||void 0,photo:await i,userName:await s}}async getCurrentUser(e){const t=await e.user;if(!t)throw new xtrem_shared_1.LogicError("User not set on context.");return t}getUserNode(){return x3SystemUtils.nodes.SysUser}async getPermissions(e,t){const s=await XtremX3AccessRightsManager._getAccessRights(e),a=[];if(s.allFunctionsAllowed)return["create","read","update","delete","lookup"];const i=s.optionsByFunctionCode[t];if(typesLib.strictNe(i,void 0)){if(a.push("read","lookup"),typesLib.gte(i.indexOf("C"),0))a.push("create");if(typesLib.gte(i.indexOf("M"),0))a.push("update");if(typesLib.gte(i.indexOf("S"),0))a.push("delete")}return a}async createActivities(){}async updateActivities(){}async deleteActivities(){}getActivityNode(){return x3SystemUtils.nodes.SysActivityCode}getActivitiesInfo(){return[]}supportsPersona(){return false}getPersonaUser(){return null}getDemoPersonas(){return[]}invalidateAuthorizationCache(e){return e.invalidateCachedCategory("AUTHORIZATION",{})}}async function allowedAccessCodes(e){const t=await exports.accessRightsManager.getUserAccessCodes(e);if(t){const e=t.filter(e=>e.execution).map(e=>e.accessCode);return e.push(""),e.length?e:null}return null}exports.XtremX3AccessRightsManager=XtremX3AccessRightsManager,exports.accessRightsManager=new XtremX3AccessRightsManager,exports.allowedAccessCodes=allowedAccessCodes;
//# sourceMappingURL=x3-access-rights-manager.js.map