import { AccessRightsManager, ActivityInfo, Context, UserAccess, UserInfo } from '@sage/xtrem-core';
import { UserAccessCode } from '@sage/xtrem-x3-gateway';
import * as x3SystemUtils from '..';
export { UserAccessCode };
export declare class XtremX3AccessRightsManager implements AccessRightsManager {
    private static _getUserAccessCodes;
    private static _getOptionsByFunctionCode;
    static getUsername(context: Context): Promise<string>;
    private static _loadRightsFromDb;
    /**
     * Get the rights etag from the database (RIGHTSETAG parameter value)
     * @param context
     * @returns
     */
    private static getRightsEtag;
    private static rightsEtag;
    /**
     * Verify the rights etag from the database
     * @param context
     * @returns
     */
    private static verifyRightsEtag;
    private static lastCacheCheck;
    /**
     * Verify the user cache is still valid
     * @param context
     * @returns
     */
    private static verifyUserCache;
    private static _getAccessRights;
    private static getSiteCodes;
    /**
     * Returns whether a user (from his/her user code) can access a function (from its code)
     *
     * @param context
     * @param nodeName
     * @param option the access context (''/undefined=read, C=create, M=Modify, S=Delete, ...)
     */
    getUserAccessFor(context: Context, nodeName: string, propertyOrOperation?: string, options?: {
        authorizationCode?: string;
    }): Promise<UserAccess>;
    /**
     * Gets the list of access codes that the user is allowed to access
     *
     * @param context
     * @returns the list of access codes if controlled, null if the user can see all access codes.
     */
    getUserAccessCodes(context: Context): Promise<UserAccessCode[] | null>;
    /**
     * Returns whether a user (from his/her user code) can access a property (from its accessCode)
     *
     * @param {Context} context
     * @param {string} accessCode
     * @returns {boolean}
     * @memberof X3AccessRightsManager
     */
    isAccessCodeAvailable(context: Context, accessCode: string): Promise<boolean>;
    /**
     * Returns the user code for a given login
     *
     * @param {Context} context
     * @param {string} code
     */
    getUser(context: Context, code: string): Promise<UserInfo>;
    createAdminUser(): Promise<void>;
    createRequiredUsers(): void;
    ensureAdminPersonaCreated(): UserInfo;
    private static transformUserToUserInfo;
    getCurrentUser(context: Context): Promise<UserInfo>;
    getUserNode(): typeof x3SystemUtils.nodes.SysUser;
    getPermissions(context: Context, activity: string): Promise<string[]>;
    createActivities(): Promise<void>;
    updateActivities(): Promise<void>;
    deleteActivities(): Promise<void>;
    getActivityNode(): typeof x3SystemUtils.nodes.SysActivityCode;
    getActivitiesInfo(): ActivityInfo[];
    supportsPersona(): boolean;
    getPersonaUser(): UserInfo | null;
    getDemoPersonas(): UserInfo[];
    invalidateAuthorizationCache(context: Context): Promise<void>;
}
export declare const accessRightsManager: XtremX3AccessRightsManager;
export declare function allowedAccessCodes(context: Context): Promise<string[] | null>;
//# sourceMappingURL=x3-access-rights-manager.d.ts.map