"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysUser = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        userModel: {
            code: 'userModel',
        },
        _image: {
            code: '_image',
            identifier1: 'code',
            identifier2() {
                return '';
            },
            identifier3() {
                return '';
            },
        },
        profession: {
            profession: 'profession',
        },
        functionProfile: {
            profile: 'functionProfile',
        },
        access: {
            access: 'access',
        },
    },
};
/** 4GL columnName: AUTILIS */
let SysUser = class SysUser extends xtrem_core_1.Node {
};
exports.SysUser = SysUser;
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'ENAFLG',
        isStored: true,
        isNullable: true,
    })
], SysUser.prototype, "activeInSelec", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'NOMUSR',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isPublished: true,
    })
], SysUser.prototype, "name", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'INTUSR',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
        isPublished: true,
    })
], SysUser.prototype, "nameDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'USR',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
        isPublished: true,
    })
], SysUser.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'ALLACS',
        isStored: true,
        isNullable: true,
    })
], SysUser.prototype, "allAccessCodes", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'USREXT',
        isStored: true,
        isNullable: true,
    })
], SysUser.prototype, "externalUser", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'FNCCOD',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        // TODO: verify inconsistency json
        max: 8,
    })
], SysUser.prototype, "functions", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CODMET',
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysSyracusMethod,
    })
], SysUser.prototype, "profession", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'PRFFCT',
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysUserFunctionProfile,
        isPublished: true,
    })
], SysUser.prototype, "functionProfile", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ADDEML',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysUser.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        lookupAccess: true,
        async getValue() {
            return `${await this.nameDescription} (${await this.code})`;
        },
    })
], SysUser.prototype, "displayName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'LOGIN',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysUser.prototype, "login", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'ACSUSR',
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysAccess,
    })
], SysUser.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ARCPRF',
        isStored: true,
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 10 }),
    })
], SysUser.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'AUSPIC',
        // TODO: verify why isNullable was not set
        isNullable: true,
        node: () => x3SystemUtils.nodes.SysImage,
        columnType: 'binaryStream',
    })
], SysUser.prototype, "_image", void 0);
__decorate([
    xtrem_core_1.decorators.binaryStreamProperty({
        isPublished: true,
        isNullable: true,
        async getValue() {
            const image = await this._image;
            return typesLib.ne(image, null) ? image.data : null;
        },
    })
], SysUser.prototype, "photo", void 0);
exports.SysUser = SysUser = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'AUTILIS',
        storage: 'external',
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        keyPropertyNames: ['code'],
        isPublished: true,
        canRead: true,
        canSearch: true,
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysUser);
//# sourceMappingURL=sys-user.js.map