"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysLanguage = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        backupLanguage: {
            code: 'backupLanguage',
        },
    },
};
/** 4GL code: TABLAN */
let SysLanguage = class SysLanguage extends xtrem_core_1.Node {
};
exports.SysLanguage = SysLanguage;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'LAN',
        isPublished: true,
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isNotEmpty: true,
    })
], SysLanguage.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'LANSTD',
        isStored: true,
        isNullable: true,
    })
], SysLanguage.prototype, "standardLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'LANISO',
        isStored: true,
    })
], SysLanguage.prototype, "iso", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'LANUNI',
        isStored: true,
        isNullable: true,
    })
], SysLanguage.prototype, "unicodeLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'LANCON',
        isStored: true,
        isNullable: true,
    })
], SysLanguage.prototype, "connectionLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'LANRPL',
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => SysLanguage,
    })
], SysLanguage.prototype, "backupLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'INTSHO',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysLanguage.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'INTDES',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysLanguage.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'LANMAIN',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysLanguage.prototype, "primaryLanguage", void 0);
exports.SysLanguage = SysLanguage = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'TABLAN',
        storage: 'external',
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        canRead: true,
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysLanguage);
//# sourceMappingURL=sys-language.js.map