"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysFunctionalProfile = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        profile: {
            profile: 'profile',
        },
        function: {
            internal: 'function',
        },
        profileForAllSites: {
            profile: 'profile',
            function: 'function',
            site() {
                return ' ';
            },
        },
    },
};
/** 4GL code: AFCTPRF */
let SysFunctionalProfile = class SysFunctionalProfile extends xtrem_core_1.Node {
};
exports.SysFunctionalProfile = SysFunctionalProfile;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'PRFCOD',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysUserFunctionProfile,
    })
], SysFunctionalProfile.prototype, "profile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'FNC',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysFunction,
    })
], SysFunctionalProfile.prototype, "function", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'OPT',
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
        isStored: true,
    })
], SysFunctionalProfile.prototype, "options", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'ACS',
        isStored: true,
    })
], SysFunctionalProfile.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'FCYGRUCOD',
        isStored: true,
    })
], SysFunctionalProfile.prototype, "menu", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'FCYGRU',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunctionalProfile.prototype, "siteGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        node: () => x3SystemUtils.nodes.SysFunctionalProfilePerSite,
        columnType: 'string',
        isNullable: true,
    })
], SysFunctionalProfile.prototype, "profileForAllSites", void 0);
exports.SysFunctionalProfile = SysFunctionalProfile = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'AFCTPRF',
        storage: 'external',
        canRead: true,
        canSearch: true,
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        keyPropertyNames: ['profile', 'function', 'siteGrouping'],
        indexes: [
            {
                orderBy: {
                    profile: 1,
                    function: 1,
                    siteGrouping: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysFunctionalProfile);
//# sourceMappingURL=sys-functional-profile.js.map