"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysFunction = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        activityCode: {
            code: 'activityCode',
        },
    },
};
/** 4GL code: EDIFNC */
let SysFunction = class SysFunction extends xtrem_core_1.Node {
};
exports.SysFunction = SysFunction;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'MODULE',
        isStored: true,
        isNullable: true,
        dataType: () => x3SystemUtils.enums.sysModuleTableDataType,
    })
], SysFunction.prototype, "module", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODINT',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "internal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CODACT',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysActivityCode,
        isNullable: true,
    })
], SysFunction.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODEXT',
        isStored: true,
    })
], SysFunction.prototype, "external", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'NUMFNC',
        isStored: true,
    })
], SysFunction.prototype, "number", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'LIBMENU',
        isStored: true,
    })
], SysFunction.prototype, "menuTitle", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'MENU',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "parentMenu", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'NBOPT',
        isStored: true,
    })
], SysFunction.prototype, "noOfOptions", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'FLAG',
        isStored: true,
        max: 19,
    })
], SysFunction.prototype, "options", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ACTOPT',
        isStored: true,
        max: 19,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "activityCode1", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'OPTION',
        isStored: true,
        max: 19,
        // dataType: () => x3SystemUtils.datatypes.genericDataTypes.dictionaryTextDatatype,
    })
], SysFunction.prototype, "optionTitle", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'FNCOPT',
        isStored: true,
        max: 19,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "function", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'RANG',
        isStored: true,
    })
], SysFunction.prototype, "rowInMenu", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'TRAIT',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "menuProcess", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'TYP',
        isStored: true,
    })
], SysFunction.prototype, "accessTypeObject", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'NBVAR',
        isStored: true,
    })
], SysFunction.prototype, "numberOfVariables", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ACTVAR',
        isStored: true,
        max: 10,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "activityCode2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'VALEUR',
        isStored: true,
        max: 10,
    })
], SysFunction.prototype, "value", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'VARIA',
        isStored: true,
        max: 10,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysFunction.prototype, "variable", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'VALPAR',
        isStored: true,
        max: 20,
    })
], SysFunction.prototype, "parameterValue", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'TRTENT',
        isStored: true,
    })
], SysFunction.prototype, "entryPoints", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'FCYAUZ',
        isStored: true,
    })
], SysFunction.prototype, "authorizationSite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'MONO',
        isStored: true,
    })
], SysFunction.prototype, "single", void 0);
exports.SysFunction = SysFunction = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'AFONCTION',
        storage: 'external',
        canRead: true,
        canSearch: true,
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        keyPropertyNames: ['internal'],
        indexes: [
            {
                orderBy: {
                    internal: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    external: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    parentMenu: 1,
                    rowInMenu: 1,
                    internal: 1,
                },
                isUnique: true,
            },
            {
                orderBy: {
                    number: 1,
                },
            },
            {
                orderBy: {
                    module: 1,
                    parentMenu: 1,
                    internal: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysFunction);
//# sourceMappingURL=sys-function.js.map