/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.configMiddleware=exports.processContextValues=exports.processXtremX3Config=exports.decrypt=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_log_1=require("@sage/xtrem-log"),crypto=require("crypto"),_=require("lodash"),error_app_1=require("./error-app"),logger=xtrem_log_1.Logger.getLogger(__filename,"config"),demoMaxSqlConnections=100,demoMaxNodesPerPage=20;function parseScopes(e,r,o){logger.verbose(()=>["x-api-app-id","x-api-app-name","x-api-scope","x-api-base-url"].map(e=>`${e}=${JSON.stringify(r.header(e))}`).join(" "));const t=e.scope||r.header("x-api-scope")||r.header("x-mindo-scope");if(t&&/\ball:readonly\b/i.test(t.toString())){if(e.storage&&!e.storage.managedExternal&&!e.storage.sql)throw new Error("SQL config missing");if(void 0===!e.storage.maxConnections)e.storage.maxConnections=demoMaxSqlConnections;if(e.graphql=e.graphql||{},e.graphql.isReadonly=true,void 0===!e.graphql.maxNodesPerPage)e.graphql.maxNodesPerPage=demoMaxNodesPerPage;logger.info(()=>"request is configured in read-only mode")}if(t){const e=/\bfolder\.([^/s]+?)\b/g;let r,s=true;for(;r=e.exec(t.toString());){if(r[1]===o.locals.contextValues.folderName){s=true;break}s=false}if(!s)throw new Error(`Unauthorized folder ${o.locals.contextValues.folderName} `)}}function acceptService(e,r,o,t){if(!e.scope)return true;const s=r.url.split("/")[1];if(!s)return logger.error("no service"),(0,error_app_1.badRequest)(r,o,t),false;if(!/^[a-z][a-z0-9-]*$/.test(s))return logger.error("Invalid syntax for service (must start with a lowercase letter and can only contain lowercase letters, digits and '-')"),(0,error_app_1.badRequest)(r,o,t),false;if(e.scope){if(!(new RegExp(`\\bapi\\.${s}\\b`,"i").test(e.scope)||/(?:api|explorer|metadata)/.test(s)))return logger.error(`unauthorized scope ${e.scope}`),(0,error_app_1.forbidden)(r,o,t),false}return true}function processConfig(e,r,o,t){if(logger.verbose(()=>`email=${JSON.stringify(e.email)} scope=${JSON.stringify(e.scope)} `),parseScopes(e,r,o),acceptService(e,r,o,t))t()}function processLocalConfig(e){return e.locals.config={...xtrem_config_1.ConfigManager.current,...e.locals.context},e.locals.config}function decrypt(e,r){if(!/^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$/.test(e))throw new Error("Input must be a base64 encoded string");if(!r)throw new Error("xtrem.security.secret config value must be set");const o=JSON.parse(Buffer.from(e,"base64").toString());if(!o.iv&&!o.encrypted)return o;const t=crypto.createHash("sha256").update(String(r)).digest("base64").substr(0,32),s=Buffer.from(o.iv,"hex"),n=Buffer.from(o.encrypted,"hex"),a=crypto.createDecipheriv("aes-256-cbc",Buffer.from(t),s);let c=a.update(n);return c=Buffer.concat([c,a.final()]),JSON.parse(c.toString())}function getSecret(){const{security:e}=xtrem_config_1.ConfigManager.current||{},{syracuse:r}=e||{};if(!r.secret)throw new Error("xtrem.security.secret config value must be set");return r.secret}function processXtremX3Config(e,r,o){const t=e.header("x-etna-config");if(!r.locals.contextValues)r.locals.contextValues={};const s=xtrem_config_1.ConfigManager.current.x3;if(!t){if(r.locals.config=xtrem_config_1.ConfigManager.current,s&&s.development&&s.development.folderName)r.locals.contextValues.folderName=s.development.folderName,r.locals.contextValues.referenceFolder=s.development.referenceFolder||s.development.folderName;return r.locals.contextValues.sessionLogin=r.locals.config.user,r.locals.config}if(Array.isArray(t))r.status(400).json({error:"multiple x-etna-config headers not allowed"});const n=decrypt(t,o||getSecret());if(n.session)n.user=n.session.userName,n.email=n.session.userName,r.locals.contextValues.sessionLogin=n.session.login||n.login,delete n.session;if(n.folderName)r.locals.contextValues.folderName=n.folderName,r.locals.contextValues.referenceFolder=n.referenceFolder||n.folderName;else throw new Error("x-etna-config missing folder name");if(n.sql){if("sqlServer"===n.sql.driver)n.sql.driver="tedious";const e={...s?.sql,...n.sql};n.x3={...s,sql:e},delete n.sql}else n.x3=s;if(!n.x3.sql)throw new Error("X3 SQL config not found");if(n.cookies)r.locals.contextValues.x3Cookies=n.cookies;return r.locals.contextValues.xtremServiceUrl=n.xtremServiceUrl,r.locals.config={...processLocalConfig(r),...n},r.locals.config}function processContextValues(e,r,o){const t=e.header("x-etna-context-values");if(Array.isArray(t))r.status(400).json({error:"multiple x-etna-context-values headers not allowed"});if(r.locals.contextValues=r.locals.contextValues??{},t){const e=o||getSecret();r.locals.contextValues=_.merge(decrypt(t,e),r.locals.contextValues)}}exports.decrypt=decrypt,exports.processXtremX3Config=processXtremX3Config,exports.processContextValues=processContextValues;const configMiddleware=(e,r,o)=>{if(/^\/(ping|ready|login-service)$/.test(e.path))return void o();try{processContextValues(e,r);processConfig(processXtremX3Config(e,r),e,r,o)}catch(e){r.status(400).json({error:e.message})}};exports.configMiddleware=configMiddleware;
//# sourceMappingURL=config-middleware.js.map