/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.authMiddleware=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_log_1=require("@sage/xtrem-log"),jwt=require("jsonwebtoken"),jwksClient=require("jwks-rsa"),error_app_1=require("./error-app"),logger=xtrem_log_1.Logger.getLogger(__filename,"auth");function extractToken(e){if(!e||e.length<8)return null;if(0!==e.indexOf("Bearer "))return null;const r=/^Bearer\s+([a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+)/.exec(e);return r&&r[1]}function verifyCommonClaims(e,r,t=120){if(!e.iat)throw new Error("Invalid token - expect issued at time");if(!e.exp)throw new Error("Invalid token - expect expiration time");const n=Date.now();if(1e3*e.iat-n>1e3*t)throw new Error("Invalid token - issued at time in the future");if(e.exp-n>0)throw new Error("Invalid token - expired");if(null!=r&&e.exp-e.iat>r)throw new Error("Invalid token - max expiration exceeded")}async function verifyAuthToken(e,r,t){const{jwksUrl:n,issuer:o,audience:i,syracuse:s}=r;let a;if(s){const{clientId:r,secret:n,clockToleranceSeconds:o}=s;try{a=jwt.verify(e,n||"")}catch(e){throw new Error(`Invalid token - ${e.name} - ${e.message}`)}if(r!==a.iss)throw new Error(`Invalid token - issuer ${r} does not match payload ${a.iss}`);verifyCommonClaims(a,t,o)}else if(n&&o&&i){const r=jwksClient({cache:true,jwksUri:n||""}),getKey=(e,t)=>{r.getSigningKey(e.kid,(e,r)=>{if(e)t(e);else t(null,r.getPublicKey())})},t={issuer:o,algorithm:"RS256",audience:i};a=await new Promise((r,n)=>{jwt.verify(e,getKey,t,(e,t)=>{if(e)n(e);else r(t)})})}else throw Error("Security config incomplete.");return a}async function verifyAuth(e,r){const t=r.headers.authorization;let n;if(t){if(n=extractToken(t),!n)throw new Error(`Invalid token: authorization method ${t.split(" ")[0]}`)}else if(r.cookies.access_token&&r.cookies.access_token_sign)n=`${r.cookies.access_token}.${r.cookies.access_token_sign}`;else return;if(3!==n?.split(".").length)throw new Error("Invalid token: must contain 3 segments");return verifyAuthToken(n,e)}function unauthorizedError(e,r,t,n){return logger.error(`Unauthorized: ${r.method} ${r.url} [${e}]`),(0,error_app_1.unauthorized)(r,t,n)}const authMiddleware=async(e,r,t)=>{const{security:n}=xtrem_config_1.ConfigManager.current;if(!n?.syracuse||/^\/(ping|ready|login-service)$/.test(e.path))return t();try{const o=await verifyAuth(n,e);if(!o){if(e.accepts("html")){if(!n.loginUrl)throw new Error("Cannot redirect: no login URL configured");return void r.redirect(`${n.loginUrl}${n.redirectUrl?`?fromUrl=${encodeURIComponent(n.redirectUrl)}`:""}`)}throw new Error("no token")}else return r.locals.context={tenantId:o.tenantId},r.locals.contextValues=r.locals.contextValues??{},r.locals.contextValues.tokenLogin=o.sub,void t()}catch(n){return unauthorizedError(n.message,e,r,t)}};exports.authMiddleware=authMiddleware;
//# sourceMappingURL=auth-middleware.js.map