/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getTableMetadata=exports.listTables=exports.rowCount=exports.execute=exports.isReferenceFolderTable=exports.getPoolConfig=exports.logger=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),xtrem_x3_sdata_parser_1=require("@sage/xtrem-x3-sdata-parser"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager");exports.logger=xtrem_core_1.Logger.getLogger(__filename,"sync");const poolsCache={};function mapRow(e){return Object.keys(e).reduce((t,r)=>{const n=e[r];if(" "===n)t[r]="";else if(Buffer.isBuffer(n))t[r]=n.toString("hex");else t[r]=n;return t},{})}function pretty(e){const t={},r=[];return Object.keys(e).forEach(n=>{const a=/^(.*)_(\d+)$/.exec(n);if(a){const o=a[1];if("0"===a[2])if(`${o}_1`in e)r.push(t[o]=[e[n]]);else t[o]=e[n];else{if(!Array.isArray(t[o]))throw new Error(`${n}: column out of order`);t[o].push(e[n])}}}),r.forEach(e=>{let t=e.length;for(;t>0&&!e[t-1];)t-=1;e.length=t}),t}function removeColumns(e){return t=>{const r={...t};return e.forEach(e=>delete r[e]),r}}function whereSql(e){return e.where.map(t=>(0,xtrem_x3_sdata_parser_1.sdataToSql)(t,{mapProperty:t=>e.raw?t:`${t}_0`})).join(" and ")}class Cache{constructor(){this.entries={}}async get(e,t){const r=JSON.stringify(e);if(!this.entries[r])this.entries[r]=await t();return this.entries[r]}clear(){this.entries={}}}const cache=new Cache;function pagingIndex(e,t,r){if("tedious"===t.driver)return{name:"I_ROWID",isUnique:true,columns:[{name:"ROWID",ascending:true}]};return cache.get([t,r],async()=>{const n={skipColumns:true,skipSecurity:true,skipSequences:true},a=await e.readTableSchema(t.folderName,r,n);let o=a.indexes&&a.indexes.filter(e=>e.isUnique)[0];if(!o)if([o]=a.indexes,o)exports.logger.warn(()=>`${r}: no unique index`);else exports.logger.warn(()=>`${r}: no index`),o={name:"NOT_AN_INDEX",isUnique:false,columns:[{name:"UPDDATTIM_0",ascending:true}]};if(!o.isUnique)o.columns.concat({name:"ROWID",ascending:true});return o})}function orderBy(e){return e.columns.map(e=>`${e.name} ${e.ascending?"asc":"desc"}`)}setInterval(()=>cache.clear(),3e5);const tildeReplacement="120a77f81d984fb491eb2fad99ed02a3";function typedFormat(e){if("string"==typeof e)return`S${e.replace(/~/g,tildeReplacement)}`;if("number"==typeof e)return`N${e}`;if(e instanceof Date)return`D${e.toISOString()}`;throw new Error(`invalid value: ${typeof e}/${e}`)}function typedParse(e){const t=e.substring(1);switch(e[0]){case"S":return t.replace(new RegExp(tildeReplacement,"g"),"~");case"N":return parseFloat(t);case"D":return new Date(t);default:throw new Error(`cannot parse value: ${e}`)}}function addKeyFilter(e,t,r,n,a){const o=r.split("~").map(typedParse),val=t=>(a.push(o[t]),e.param(a.length-1));n.push(t.columns.map((e,r)=>`(${t.columns.slice(0,r).map((e,t)=>`${e.name} = ${val(t)}`).concat(`${e.name} ${e.ascending?">":"<"} ${val(r)}`).join(" and ")})`).join(" or "))}async function getPoolConfig(e,t=false){const r=e.x3;if(!r||!r.sql)throw new Error("SQL config is not supplied");const n=r.sql;if(t){const t=await getPoolConfig(e),r=xtrem_x3_sql_manager_1.PoolManager.create(t,poolsCache,exports.logger);n.folderName=await xtrem_x3_gateway_1.FolderManager.getReferenceFolderName(r,{currentConfig:e})}else n.folderName=xtrem_x3_gateway_1.FolderManager.getFolderName({currentConfig:e});return n}async function isReferenceFolderTable(e,t){const r=await getPoolConfig(t),n=xtrem_x3_sql_manager_1.PoolManager.create(r,poolsCache,exports.logger);return xtrem_x3_gateway_1.FolderManager.isReferenceFolderTable(r.folderName,e,n)}async function execute(e,t,r){e={...e,usePool:true};const n=xtrem_x3_sql_manager_1.PoolManager.create(e,poolsCache,exports.logger),a=[],o=[];if(r.since)a.push(`UPDDATTIM_0 > ${n.param(o.length)}`),o.push(r.since);let{until:s}=r;if(!s)s=new Date,s.setTime(s.getTime()-1e4);if(a.push(`UPDDATTIM_0 <= ${n.param(o.length)}`),o.push(s),r.where&&r.where.length>0)a.push(whereSql(r));const i=await pagingIndex(n,e,t);if(r.key)addKeyFilter(n,i,r.key,a,o);let l="*";const c=[];if(r.columns){const e=r.raw?r.columns:r.columns.map(e=>`${e}_0`);if(i.columns.map(e=>e.name).filter(t=>e.indexOf(t)<0).forEach(t=>{e.push(t),c.push(t)}),e.indexOf("UPDDATTIM_0")<0)e.push("UPDDATTIM_0"),c.push("UPDDATTIM_0");l=e.join(",")}const u="oracle"===e.driver?`/*+ index(${t} ${i.name}) */`:n.firstClause0(r.countHint),g=n.firstClause1(r.countHint),m=`select ${u} ${l} from ${n.getFullTableName(e.folderName,t)} where (${a.join(") and (")}) order by ${orderBy(i)} ${g}`;return exports.logger.verbose(()=>`SQL ${m} ARGS  ${o}`),n.withConnection(async e=>{const a=n.createReader(e,m,o),l=r.countHint;let u="",g=0;const f=Date.now(),p=[];try{for(;;){const e=await a.read();if(void 0===e)break;g+=1,p.push(e);const t=i.columns.map(t=>typedFormat(e[t.name])).join("~");if(t!==u){if(g>l)break;u=t}}}finally{await a.stop()}let d=p.map(mapRow);if(exports.logger.verbose(()=>`TIME ${Date.now()-f},  options = ${JSON.stringify(r)}, row count = ${d.length}`),c.length>0)d=d.map(removeColumns(c));if(!r.raw)d=d.map(pretty);const x=d.length<l;return{table:t,since:x?s:r.since,until:x?void 0:s,key:x?void 0:u,rows:d,done:x}})}function rowCount(e,t,r){e={...e,usePool:true};const n=xtrem_x3_sql_manager_1.PoolManager.create(e,poolsCache,exports.logger);return n.withConnection(async a=>{const o=[],s=[];if(r.since)o.push(`UPDDATTIM_0 > ${n.param(s.length)}`),s.push(r.since);if(r.where&&r.where.length>0)o.push(whereSql(r));const i=await pagingIndex(n,e,t);if(r.key)addKeyFilter(n,i,r.key,o,s);let l=`select count(*) from ${n.getFullTableName(e.folderName,t)}`;if(o.length>0)l+=` where (${o.join(") and (")})`;exports.logger.verbose(()=>`SQL ${l} ARGS  ${s}`);const c=await n.execute(a,l,s),u=c?c[0]:null;return{count:Number(u[Object.keys(u)[0]])}})}function getSynchronizableTableNames(e){e={...e,usePool:true};const t=xtrem_x3_sql_manager_1.PoolManager.create(e,poolsCache);return t.withConnection(async r=>{const n=await t.execute(r,`select CODFIC_0 from ${t.getFullTableName(e.folderName,"ATABZON")} where CODZONE_0='UPDDATTIM'`);return n?n.map(e=>e.CODFIC_0):[]})}async function listTables(e){e={...e,usePool:true};const t=xtrem_x3_sql_manager_1.PoolManager.create(e,poolsCache,exports.logger),r=await t.readTables(e.folderName),n="alasql"===e.driver?null:await getSynchronizableTableNames(e);return r.filter(e=>!n||n.includes(e.tableName))}async function getTableMetadata(e,t){e={...e,usePool:true};const r=xtrem_x3_sql_manager_1.PoolManager.create(e,poolsCache,exports.logger),n={skipSecurity:true,skipSequences:true},a=await r.readTableSchema(e.folderName,t,n);return{name:a.tableName,columns:a.columns.map(e=>({...e,default:void 0})),indexes:a.indexes.map(e=>({...e,isPrimaryKey:void 0}))}}exports.getPoolConfig=getPoolConfig,exports.isReferenceFolderTable=isReferenceFolderTable,exports.execute=execute,exports.rowCount=rowCount,exports.listTables=listTables,exports.getTableMetadata=getTableMetadata;
//# sourceMappingURL=sync-execute.js.map