/** @module @sage/xtrem-x3-sync */
import { Logger } from '@sage/xtrem-core';
import { Config } from '@sage/xtrem-shared';
import { ColumnDefinition, IndexDefinition, PoolConfig, TableDefinition } from '@sage/xtrem-x3-sql';
export declare const logger: Logger;
export interface ExecuteOptions {
    columns?: string[];
    since?: Date;
    until?: Date;
    key?: string;
    raw: boolean;
    countHint: number;
    where?: string[];
}
export interface TableMetaData {
    name: string;
    columns: ColumnDefinition[];
    indexes: IndexDefinition[];
}
export declare function getPoolConfig(config: Config, referenceFolderRequest?: boolean): Promise<PoolConfig>;
export declare function isReferenceFolderTable(tableName: string, config: Config): Promise<boolean>;
export interface SyncExecuteResult {
    table: string;
    since: Date | undefined;
    until: Date | undefined;
    key: string | undefined;
    rows: any[];
    done: boolean;
}
export declare function execute(config: PoolConfig, table: string, options: ExecuteOptions): Promise<SyncExecuteResult>;
export interface CountOptions {
    since?: Date;
    raw?: boolean;
    where?: string[];
    key?: string;
}
export declare function rowCount(config: PoolConfig, table: string, options: CountOptions): Promise<{
    count: number;
}>;
export declare function listTables(config: PoolConfig): Promise<TableDefinition[]>;
export declare function getTableMetadata(config: PoolConfig, tableName: string): Promise<TableMetaData>;
//# sourceMappingURL=sync-execute.d.ts.map