export type Dict<T> = {
    [key: string]: T;
};
export declare class Operator {
    code: string;
    text: string;
    precedence: number;
    isPrefix: boolean;
    isInfix: boolean;
    isAssociative: boolean;
    isPredicate: boolean;
    static operators: Dict<Operator>;
    constructor(code: string, text: string, precedence: number, isPrefix: boolean, isInfix: boolean, isAssociative: boolean, isPredicate: boolean);
    toString(): string;
    static createOp(code: string | null, text: string, precedence: number, isPrefix: boolean, isInfix: boolean, isAssociative: boolean, isPredicate: boolean): void;
    static init(): void;
}
export declare const operators: typeof Operator;
//# sourceMappingURL=operator.d.ts.map