/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.jsonToSdata=exports.sdataToJson=void 0;const parser_1=require("./parser"),config={tracer:{debug:void 0}};function _left(e){let r="";if(!e)return r;switch(e.type){case"operator":if("."===e.value.code)r=`${_left(e.children[0])}.${_left(e.children[1])}`;else throw new Error(`_left : "${e.value.code}" not yet implemented`);break;case"function":if("upper"===e.value)r=`upper(${_left(e.children[0])})`;else r=e.value;break;default:r=e.value}if(config.tracer.debug)config.tracer.debug(`mongodb.filter.left: ${r}`);return r}function _format(e,r){return r?new Date(e):"object"==typeof e&&e.toString()?e.toString():e}function _createFilter(e){if(e&&"string"==typeof e)e=parser_1.Parser.parse(e);if(config.tracer.debug)config.tracer.debug("mongodbDbHandle.create filter enter: ",e);if(!e)return{};let r={};if("operator"===e.type)switch(e.value.code){case"and":{if(e.children.length<2)throw new Error('Invalid "AND" condition');const t=[];t[0]=_createFilter(e.children[0]),t[1]=_createFilter(e.children[1]),r={$and:[t[0],t[1]]}}break;case"or":{if(e.children.length<2)throw new Error('Invalid "OR" condition');const t=[];t[0]=_createFilter(e.children[0]),t[1]=_createFilter(e.children[1]),r={$or:[t[0],t[1]]}}break;default:if(e.children[1]&&(null==e.children[1].value||""===e.children[1].value))if("="===e.value.code){const t="$or",a=_left(e.children[0]),n={},l={},o={};r[t]=[],n[a]=null,l[a]="",o[a]=[],r[t].push(n,l,o)}else if("<>"===e.value.code)r[_left(e.children[0])]={$exists:true,$ne:""};else throw new Error(`Unexpected operator '${e.value.code}' for 'null' value. Expected '=' or '<>'`);else{const t="$updDate"===e.children[0].value||"$creDate"===e.children[0].value;if("="===e.value.code)r[_left(e.children[0])]=_format(e.children[1].value,t);else{let a=e.value.text;if("between"===a){if(e.children.length<3)throw new Error('Invalid "BETWEEN" condition');r[_left(e.children[0])]={$gte:_format(e.children[1].value,t),$lte:_format(e.children[2].value,t)}}else{if(e.children.length<2);let n=null,l=e.children[1]&&_format(e.children[1].value,t);switch(a){case"le":a="lte";break;case"ge":a="gte";break;case"like":if(a="regex",l=l.replace(/([\\^$.()[\]{}*?+])/g,"\\$1"),"%"===l.charAt(0))l=l.substr(1);else l=`^${l}`;if("%"===l.charAt(l.length-1))l=l.substr(0,l.length-1);else l+="$";l=l.replace(/%/g,".*"),n="i";break;case"in":l=e.children.slice(1).map(e=>e&&_format(e.value,t));break;case"lt":case"gt":case"eq":case"ne":break;default:throw new Error(`Unknown operator ${a}`)}a=`$${a}`;const o=_left(e.children[0]);if(r[o]={},r[o][a]=l,n)r[o].$options=n}}}}else throw new Error(`${e.type} not yet implemented`);if(config.tracer.debug)config.tracer.debug("create filter exit: ",r);return r}function _toFilterValue(e,r){switch(r||typeof e){case"number":case"boolean":return e;case"string":return`'${e.replace(/'/g,"''")}'`;case"object":return null;default:throw new Error("object filter NIY")}}function _createSdataFilter(e){let r="";if("operator"===e.type){if(e.children.length<2)throw new Error(`Invalid "${e.value.code.toUpperCase()}" condition`);switch(e.value.code){case"and":case"AND":case"or":case"OR":r=`${_createSdataFilter(e.children[0])} ${e.value.code} ${_createSdataFilter(e.children[1])}`;break;default:r=`(${_left(e.children[0])} ${e.value.text} ${_toFilterValue(_format(e.children[1].value))})`}}else throw new Error(`${e.type} not yet implemented`);return r}function _createSdataFilterFromJson(e){return Object.keys(e).map(r=>{const t=_toFilterValue(e[r]);return t?`(${r} eq ${t})`:void 0}).filter(e=>void 0!==e).join(" and ")}function sdataToJson(e){return _createFilter(e)}function jsonToSdata(e){const r=e||{tracer:{}},t=[];if(r.sdataWhere)t.push(r.sdataWhere);if(r.where)t.push(_createSdataFilter(r.where));if(r.jsonWhere)t.push(_createSdataFilterFromJson(r.jsonWhere));return t.length?t.filter(e=>e).map(e=>`(${e})`).join(" AND "):""}exports.sdataToJson=sdataToJson,exports.jsonToSdata=jsonToSdata;
//# sourceMappingURL=json-converter.js.map