/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.create=exports.OraclePool=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_x3_sql_1=require("@sage/xtrem-x3-sql"),crypto=require("crypto"),oracle=require("oracledb"),reader_1=require("./reader"),writableOracle=require("oracledb");function setFetchTypeHandler(e){e.fetchTypeHandler=t=>{if(t.dbType===oracle.DB_TYPE_NUMBER&&e&&e.decimalColumns&&e.decimalColumns.length&&e.decimalColumns.includes(t.name))return{type:oracle.STRING};if(t.dbType===oracle.DB_TYPE_DATE||t.dbType===oracle.DB_TYPE_TIMESTAMP)return{converter:e=>{if(e instanceof Date)return new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()));return e}};return}}writableOracle.fetchAsString=[oracle.NUMBER,oracle.CLOB],writableOracle.fetchAsBuffer=[oracle.BLOB];class OraclePool extends xtrem_x3_sql_1.Pool{constructor(e,t){if(super(e,t),this.dialect="oracle",this.nullDate=xtrem_date_time_1.DateValue.make(1599,12,31),this.config.connectString=`${e.hostname}${e.port?`:${e.port}`:""}/${e.database}`,"sys"===this.config.user)this.config.privilege=oracle.SYSDBA}uniqid(e){return`Select SEQ_${e}.nextval As A$RESULT_0 from dual`}lockClause0(){return""}lockClause1(){return" For Update "}hintClause0(e,t){if(e){if(e.nohint||""===e.name)return"";return`/*+ INDEX${e.revert?"_DESC":""}(${e.abbrev} ${e.tname}_${e.name}) */`}if(t)return"/*+ FIRST_ROWS ( 1 ) */";return""}hintClause1(e,t){return""}firstClause0(e){return""}firstClause1(e){return`fetch first ${e} rows only`}asString(e,t){return`CAST(${e} AS varchar(${t||250}))`}lengthString(){return"length"}modString(e,t){return`mod(${e},${t})`}subString(e,t,r){return`substr(${e}, ${t}, ${r})`}emptyBlob(){return"empty_blob()"}emptyClob(){return"empty_clob()"}dateToChar(e,t,r){return`TO_CHAR(${e},'${t||"YYYY-MM-DD"+(r?" hh24:mi:ss":"")}')`}charToDate(e,t){if(t&&(e=>/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/.test(e))(e))return`TO_TIMESTAMP(${e},'YYYY-MM-DD"T"HH24:MI:SS.ff3"Z"')`;return`TO_DATE(${e},'YYYY-MM-DD${t?" hh24:mi:ss":""}')`}toChar(e){return`TO_CHAR(${e})`}charConcatenator(){return"||"}regexOrLike(e,t,r,a){return`REGEXP_LIKE(${"date"===t?this.dateToChar(e):this.toChar(e)},${this.quote(r)},${a})`}limitClause(e){return""}fetchOnlyClause(e){return`FETCH NEXT ${e} ROWS ONLY`}driverFunctions(e,t){switch(t){case"day":return`to_char(${e}, 'YYYY-MM-DD')`;case"month":return`to_char(${e}, 'YYYY-MM')`;case"year":return`to_char(${e}, 'YYYY')`;default:throw new Error("Unexpected parameter passed")}}escape(e){return`"${e}"`}param(e){return`:v${e+1}`}rowIdGet(e){return`ROWIDTOCHAR(${e})`}rowIdPut(e){return`CHARTOROWID(${e})`}executeWithTransaction(e,t){return this.withConnection(async r=>{await r.commit();const{args:a}=t,s=this.logger?.verbose(()=>`[${this.user}] Execute in transaction ${e}, args=${a?JSON.stringify(a):""}`);try{const n=await this.execute(r,e,a);if(t.rollback)await r.rollback();else await r.commit();return s?.success(),n}catch(t){throw s?.fail(`Failed: ${t.message} on ${e}`),t}})}checkConnection(e){return e}async createConnection(){this.logger&&this.logger.debug(()=>"connecting ..."),process.env.ORA_SDTZ="UTC";const e=await require("oracledb").getConnection(this.config);return await e.execute("ALTER SESSION SET TIME_ZONE='UTC'"),e}async closeConnection(e){try{await e.close()}catch(e){this.logger?.error(e.stack)}this.counters.discarded+=1,this.counters.alloc-=1}async execute(e,t,r,a){let s,n,i,c;if("string"==typeof e)s=null,n=e,i=t,c=r;else s=e,n=t,i=r,c=a;if(null==s)return this.withConnection(e=>this.execute(e,n,i,c));const o={outFormat:oracle.OUT_FORMAT_OBJECT};if(c=c||{},c.outputVars&&c.outputVars.length>0)c.outputVars.forEach(e=>{const t=oracle[e.type];if("number"!=typeof t)throw new Error(`invalid type: ${e.type}`);i[e.name]={dir:oracle.BIND_OUT,type:t}});if(c.decimalColumns)o.decimalColumns=c.decimalColumns;setFetchTypeHandler(o);const l=this?.logger.verbose(()=>`[${this.user}] Execute ${n}, args=${i?JSON.stringify(i):""}`);let u;try{u=await s.execute(n,this.convertArgs(i||[]),o),l?.success()}catch(e){throw l?.fail(`Failed: ${e.message} on ${n}`),e}if(u.rows)return u.rows;return{updateCount:u.rowsAffected,outputVars:c.outputVars&&c.outputVars.map(e=>u.outBinds[e.name][0])}}convertArgs(e){return e.reduce((e,t,r)=>(e[`v${r+1}`]=t,e),{})}createReader(e,t,r,a){this.logger&&this.logger.verbose(()=>`[${this.user}] Reader ${t}, args=${r?r.join(","):""}`);const s=a||{};return setFetchTypeHandler(s),(0,reader_1.oracleReader)(e,t,this.convertArgs(r||[]),s)}reader(e,t=[]){return new xtrem_core_1.AsyncArrayReader(()=>this.withConnection(r=>this.createReader(r,e,t,{}).readAll()))}isIndexNotFound(e){return/ORA-01418/.test(e.message)}isTableNotFound(e){return/ORA-00942/.test(e.message)}isUniqueViolated(e){return/ORA-00001/.test(e.message)}isLocked(e){return/ORA-00060/.test(e.message)}isNoRecord(e){return/ORA-01403/.test(e.message)}blobType(){return"BLOB"}clobType(){return"CLOB"}tinyIntType(){return"NUMBER(3)"}shortIntType(){return"NUMBER(5)"}intType(){return"NUMBER(10)"}stringType(e){return`VARCHAR2(${e})`}dateType(){return"DATE"}datetimeType(){return"DATE"}uuidType(){return"RAW(16)"}decimalType(){return"VARCHAR2(32)"}floatType(){return"BINARY_FLOAT"}doubleType(){return"BINARY_DOUBLE"}backupDatabase(e,t){throw new Error("Not implemented !!!")}restoreDatabase(e,t){throw new Error("Not implemented !!!")}async tableExists(e,t){let r="select * from all_tables where TABLE_NAME= :v1";const a=[e];if(null!=t)r=`${r} AND OWNER= :v2`,a.push(t);return!!(await this.reader(r,a).toArray())[0]}async describeQuery(e,t){const r=`TMPVIEW${crypto.randomBytes(4).readUInt32LE(0)}`;await this.execute(`Create view ${r} as ${e}`);try{const e=`SELECT COLUMN_NAME, DATA_TYPE, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, CHAR_LENGTH, CHAR_USED FROM ALL_TAB_COLUMNS WHERE OWNER='${t}' AND TABLE_NAME = '${r}' ORDER BY TABLE_NAME, COLUMN_ID`;return(await this.reader(e).toArray()).map(e=>{const t={};switch(t.name=e.COLUMN_NAME,e.DATA_TYPE){case"BLOB":t.type=522,t.typtyp=9;break;case"CLOB":t.type=523,t.typtyp=10;break;case"DATE":t.type=3,t.typtyp=8;break;case"TIMESTAMP(3)":t.type=526,t.typtyp=12;break;case"VARCHAR":t.type=+e.DATA_LENGTH+10,t.typtyp=7;break;case"VARCHAR2":t.type=+e.CHAR_LENGTH+10,t.typtyp=7;break;case"RAW":if(16===+e.DATA_LENGTH)t.type=525,t.typtyp=11;else throw new Error(`${r}.${e.COLUMN_NAME}: unsupported column type ${e.DATA_TYPE}`);break;case"NUMBER":{const r=+e.DATA_PRECISION,a=+e.DATA_SCALE;if(10===r&&!a)t.typtyp=3,t.type=4;else if(3===r&&!a)t.type=1,t.typtyp=1;else if(5===r&&!a)t.typtyp=2,t.type=2;else t.typtyp=4,t.type=7;break}default:throw new Error(`${r}.${e.COLUMN_NAME}: unsupported column type ${e.DATA_TYPE}`)}return t})}finally{await this.execute(`Drop view ${r}`)}}readTables(e){const t="select TABLE_NAME from ALL_TABLES where OWNER = :v1 order by TABLE_NAME";return this.reader(t,[e]).map(t=>({schemaName:e,tableName:t.TABLE_NAME})).toArray()}describeNumberColumn(e,t,r){const a=+r.DATA_PRECISION,s=+r.DATA_SCALE;if(!a&&!s)switch(+r.TYPE_TYPE){case 0:if("UPDTICK_0"!==t.name)this.logger?.warn(`${e}.${t.name}: unknown number type, no info`);t.type="decimal",t.precision=38,t.scale=0;break;case 1:t.type="byte";break;case 2:t.type="short";break;case 3:t.type="integer";break;default:{if(4!==r.TYPE_TYPE)this.logger?.warn(`${e}.${t.name}: unknown number type, TYPTYP=${r.TYPE_TYPE}`);t.type="decimal";let a=+r.ZONE_LENGTH;if(0===a)a=+r.TYPE_LENGTH;t.precision=Math.floor(a),t.scale=Math.round(10*(a-t.precision)),t.precision+=t.scale,t.useFloatingPointFormat=r.ZONE_OPTION&&-1!==r.ZONE_OPTION.indexOf("F")||r.TYPE_OPTION&&-1!==r.TYPE_OPTION.indexOf("F");break}}else if(!s)switch(a){case 3:t.type="byte";break;case 5:t.type="short";break;case 10:t.type="integer";break;default:this.logger?.warn(`${e}.${t.name}: unknown number type, TYPTYP=${r.TYPE_TYPE}, precision=${a}`),t.type="decimal",t.precision=a,t.scale=0}else t.type="decimal",t.precision=a,t.scale=s}async readTableSchema(e,t,r){const a={schemaName:e,tableName:t};let s="";if(!r.skipColumns)s=`SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_LENGTH, c.CHAR_USED, c.CHAR_LENGTH, c.DATA_PRECISION, c.DATA_SCALE, c.NULLABLE, c.DATA_DEFAULT, t.TYPTYP_0 TYPE_TYPE, t.OPTION_0 TYPE_OPTION, t.LNGTYP_0 TYPE_LENGTH, z.LONG_0 ZONE_LENGTH, z.OPTION_0 ZONE_OPTION FROM all_tab_cols c LEFT JOIN ${this.getFullTableName(a.schemaName,"ATABZON")} z ON z.CODFIC_0 = c.TABLE_NAME AND c.COLUMN_NAME LIKE CONCAT(z.CODZONE_0, '\\_%') ESCAPE '\\' LEFT JOIN ${this.getFullTableName(a.schemaName,"ATYPE")} t ON z.CODTYP_0 = t.CODTYP_0 WHERE table_name = :v1 AND c.OWNER = :v2 ORDER BY COLUMN_NAME`,a.columns=(await this.reader(s,[a.tableName,a.schemaName]).toArray()).filter(e=>!e.COLUMN_NAME.startsWith("SYS_STS")).map(e=>{const t={name:e.COLUMN_NAME,isNullable:"N"!==e.NULLABLE};switch(e.DATA_TYPE){case"DATE":t.type="date";break;case"TIMESTAMP(3)":t.type="datetime";break;case"BINARY_DOUBLE":t.type="double";break;case"BINARY_FLOAT":t.type="float";break;case"NUMBER":this.describeNumberColumn(a.tableName,t,e);break;case"BLOB":t.type="binaryStream";break;case"CLOB":t.type="textStream";break;case"VARCHAR":t.type="string",t.maxLength=parseInt(e.DATA_LENGTH,10);break;case"VARCHAR2":if(t.type="string","B"===e.CHAR_USED){if(e.DATA_LENGTH%4!=0)this.logger?.error(`${a.tableName}.${e.COLUMN_NAME}: invalid DATA_LENGTH value: ${e.DATA_LENGTH} (expected multiple of 4)`);t.maxLength=parseInt(e.DATA_LENGTH,10)/4}else t.maxLength=parseInt(e.CHAR_LENGTH,10);break;case"RAW":if(16===e.DATA_LENGTH)t.type="uuid";else t.type="binary",t.maxLength=e.DATA_LENGTH;break;default:throw new Error(`${a.tableName}.${a.tableName}: unknown column type ${e.DATA_TYPE}`)}if(e.DATA_DEFAULT)t.default=e.DATA_DEFAULT;else t.default=null;return t});if(!r.skipSecurity){s=`SELECT SECURE_0 FROM ${this.getFullTableName(a.schemaName,"ATABLE")} WHERE CODFIC_0 = ${this.param(0)} AND rownum=1`;const e=(await this.reader(s,[a.tableName]).toArray())[0];a.isOpenAccess=!e||2===e.SECURE_0}if(!r.skipIndexes){let e,t;s="select i.UNIQUENESS index_is_unique, ic.INDEX_NAME index_name, ic.COLUMN_NAME column_name, ic.DESCEND column_descending from ALL_IND_COLUMNS ic left join ALL_INDEXES i on ic.INDEX_NAME = i.INDEX_NAME and ic.TABLE_OWNER = i.TABLE_OWNER where ic.TABLE_NAME = :v1 and ic.TABLE_OWNER = :v2 order by ic.INDEX_NAME, ic.COLUMN_POSITION",a.indexes=[],(await this.reader(s,[a.tableName,a.schemaName]).toArray()).forEach(r=>{if(r.INDEX_NAME!==t)t=r.INDEX_NAME,e={name:r.INDEX_NAME,isPrimaryKey:false,isUnique:"UNIQUE"===r.INDEX_IS_UNIQUE,columns:[]},a.indexes.push(e);const s={name:r.COLUMN_NAME,ascending:"ASC"===r.COLUMN_DESCENDING};e.columns.push(s)})}if(!r.skipSequences)s="select LAST_NUMBER from ALL_SEQUENCES where SEQUENCE_NAME = :v1 and SEQUENCE_OWNER = :v2 and ROWNUM < 2",(await this.reader(s,[`SEQ_${a.tableName}`,a.schemaName]).toArray()).forEach(e=>{a.sequence=parseInt(e.LAST_NUMBER,10)});return a}getFullTableDefName(e){return this.getFullTableName(e.schemaName,e.tableName)}getFullTableName(e,t,r){const a=e?`"${e}"."${t}"`:`"${t}"`;return r?`${a} ${r}`:a}async release(){let e;for(;e=this.connections.pop();)await e.release();this.counters={...this.initialCounters}}extractFromDate(e,t,r,a){if(t)return`to_char(${e}, '${r}')`;return`to_date(to_char(${e}, '${r}')${a?`||'${a}'`:""}, 'YYYY/MM/DD')`}extractYearAndMonthAndDayFromDate(e,t=false){return this.extractFromDate(e,t,"YYMM/MM/DD")}extractYearAndMonthFromDate(e,t=false){return this.extractFromDate(e,t,"YYYY/MM","/01")}extractYearFromDate(e,t=false){return this.extractFromDate(e,t,"YYYY","/01/01")}}function create(e,t){return new OraclePool(e,t)}exports.OraclePool=OraclePool,exports.create=create;
//# sourceMappingURL=pool.js.map