// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-interop/build/index.d.ts
declare module '@sage/xtrem-x3-interop/index' {
	export * from '@sage/xtrem-x3-interop/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-interop/build/lib/index.d.ts
declare module '@sage/xtrem-x3-interop/lib/index' {
	import * as nodes from '@sage/xtrem-x3-interop/lib/nodes/_index';
	export { nodes };
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-interop/build/lib/services/dummy-storage-manager.d.ts
declare module '@sage/xtrem-x3-interop/lib/services/dummy-storage-manager' {
	import { AnyRecord, AnyRecordWithId, AsyncReader, Context, Dict, Extend, ExternalStorageManager, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, PropertyAndValue, ValidationContext } from '@sage/xtrem-core';
	export class DummyStorageManager<T extends Node> implements ExternalStorageManager<T> {
	    factory: NodeFactory;
	    insert(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecordWithId>;
	    update(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecord[]>;
	    delete(_node: Extend<T>, _cx: ValidationContext): Promise<number>;
	    query(_context: Context, _options: NodeExternalQueryOptions<T>): AsyncReader<any>;
	    mapRecordIn(_record: any): any;
	    mapAggregateRecordIn(_record: any): any;
	    getReferenceJoin(_propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
	    getCollectionJoin(_propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
	    getJoinValues(_node: Extend<T>, _data: any, _propertyName: string, _index: number): Dict<any>;
	    parseOrderBy(_context: Context, _orderBy: OrderBy<Node> | undefined): OrderByClause[];
	    parseCursor(_orderByClauses: OrderByClause[], _value: string): PropertyAndValue[];
	    private _lastTransientId;
	    allocateTransientId(): string;
	    getKeyValues(_context: Context, _values: any, _options?: {
	        allocateTransient: boolean;
	    }): Dict<any>;
	    isKeyPropertyTransient(_propertyName: string, _value: any): boolean;
	    isReverseReferenceProperty(_propertyName: string): boolean;
	    get defaultOrderBy(): OrderBy<Node>;
	    /**
	     * Gets the formatted key values a string concatenated by `~`
	     * This will be used for the _id value
	     *
	     * @param context
	     * @param values
	     * @returns
	     */
	    getId(_context: Context, values: Dict<any>): string;
	    canCreate(canCreate: boolean): boolean;
	    canUpdate(canUpdate: boolean): boolean;
	    canDelete(canDelete: boolean): boolean;
	    canDeleteMany(canDeleteMany: boolean): boolean;
	}
	//# sourceMappingURL=dummy-storage-manager.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-interop/build/lib/nodes/sys-synchronization-source.d.ts
declare module '@sage/xtrem-x3-interop/lib/nodes/sys-synchronization-source' {
	import { Context, Node } from '@sage/xtrem-core';
	import { Decimal } from '@sage/xtrem-decimal';
	import { decimal } from '@sage/xtrem-shared';
	/**
	 * Synchronization feed returned by the SysSynchronizationSource.getSynchronizationFeed method
	 */
	export interface SynchronizationFeed {
	    /** Tick for the next synchronization pass */
	    nextTick: decimal;
	    /** The returned feed. Each entry is a JSON string containing the record payload */
	    feed: AsyncGenerator<string>;
	}
	export class SysSynchronizationSource extends Node {
	    /**
	     *  Returns a synchronization feed for a synchronization source node.
	     *
	     * @param context the context
	     * @param node the synchronization source node
	     * @param startTick the start tick for incremental synchronization
	     * @param selector the selector that specifies the properties included in the response
	     * @returns a synchronization feed
	     */
	    static getSynchronizationFeed(context: Context, node: string, startTick: Decimal, selector: string, filter?: string): Promise<SynchronizationFeed>;
	}
	//# sourceMappingURL=sys-synchronization-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-interop/build/lib/nodes/sys-app.d.ts
declare module '@sage/xtrem-x3-interop/lib/nodes/sys-app' {
	import { Context, Node } from '@sage/xtrem-core';
	export interface AppInfo {
	    name: string;
	    version: string;
	    metadataPackage: string;
	}
	export class SysApp extends Node {
	    /**
	     *  Returns the source app's version.
	     *
	     * @param context the context
	     * @returns a synchronization feed
	     */
	    static getAppInfo(context: Context): AppInfo;
	}
	//# sourceMappingURL=sys-app.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/platform/xtrem-x3-interop/build/lib/nodes/_index.d.ts
declare module '@sage/xtrem-x3-interop/lib/nodes/_index' {
	export * from '@sage/xtrem-x3-interop/lib/nodes/sys-app';
	export * from '@sage/xtrem-x3-interop/lib/nodes/sys-synchronization-source';
	//# sourceMappingURL=_index.d.ts.map
}
declare module '@sage/xtrem-x3-interop' {
	export * from '@sage/xtrem-x3-interop/index';
}
