import { AnyRecord, AnyRecordWithId, AsyncReader, Context, Dict, Extend, ExternalStorageManager, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, PropertyAndValue, ValidationContext } from '@sage/xtrem-core';
export declare class DummyStorageManager<T extends Node> implements ExternalStorageManager<T> {
    factory: NodeFactory;
    insert(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecordWithId>;
    update(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecord[]>;
    delete(_node: Extend<T>, _cx: ValidationContext): Promise<number>;
    query(_context: Context, _options: NodeExternalQueryOptions<T>): AsyncReader<any>;
    mapRecordIn(_record: any): any;
    mapAggregateRecordIn(_record: any): any;
    getReferenceJoin(_propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
    getCollectionJoin(_propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
    getJoinValues(_node: Extend<T>, _data: any, _propertyName: string, _index: number): Dict<any>;
    parseOrderBy(_context: Context, _orderBy: OrderBy<Node> | undefined): OrderByClause[];
    parseCursor(_orderByClauses: OrderByClause[], _value: string): PropertyAndValue[];
    private _lastTransientId;
    allocateTransientId(): string;
    getKeyValues(_context: Context, _values: any, _options?: {
        allocateTransient: boolean;
    }): Dict<any>;
    isKeyPropertyTransient(_propertyName: string, _value: any): boolean;
    isReverseReferenceProperty(_propertyName: string): boolean;
    get defaultOrderBy(): OrderBy<Node>;
    /**
     * Gets the formatted key values a string concatenated by `~`
     * This will be used for the _id value
     *
     * @param context
     * @param values
     * @returns
     */
    getId(_context: Context, values: Dict<any>): string;
    canCreate(canCreate: boolean): boolean;
    canUpdate(canUpdate: boolean): boolean;
    canDelete(canDelete: boolean): boolean;
    canDeleteMany(canDeleteMany: boolean): boolean;
}
//# sourceMappingURL=dummy-storage-manager.d.ts.map