"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysSynchronizationSource = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_date_time_1 = require("@sage/xtrem-date-time");
const dummy_storage_manager_1 = require("../services/dummy-storage-manager");
let SysSynchronizationSource = class SysSynchronizationSource extends xtrem_core_1.Node {
    /**
     *  Returns a synchronization feed for a synchronization source node.
     *
     * @param context the context
     * @param node the synchronization source node
     * @param startTick the start tick for incremental synchronization
     * @param selector the selector that specifies the properties included in the response
     * @returns a synchronization feed
     */
    static async getSynchronizationFeed(context, node, startTick, selector, filter) {
        const nodeName = node.startsWith('#') ? node.slice(1) : node;
        const factory = context.application.getFactoryByName(nodeName);
        const nextTickResult = await context.readAggregate(factory.nodeConstructor, {
            values: { _updateStamp: { max: true } },
        });
        const nextTick = typesLib.floor(typesLib.div(nextTickResult._updateStamp.max.value, 1000));
        const selectorObject = (0, xtrem_core_1.friendlyJsonParse)(selector);
        if (selectorObject._syncTick)
            delete selectorObject._syncTick;
        const startTickNumber = startTick.toNumber();
        const syncTickFilter = typesLib.gt(startTickNumber, 0) ? { _updateStamp: { _gte: xtrem_date_time_1.Datetime.fromValue(typesLib.mul(startTickNumber, 1000)) } } : {};
        const filterObject = filter ? (0, xtrem_core_1.friendlyJsonParse)(filter) : undefined;
        const selectFilter = filterObject && typesLib.gt(Object.keys(filterObject).length, 0)
            ? { _and: [syncTickFilter, filterObject] }
            : syncTickFilter;
        const reader = await context.getSelectReader(factory.nodeConstructor, selectorObject, {
            filter: selectFilter,
            returnReferencesAsNaturalKey: true,
        });
        const _syncTick = typesLib.floor(typesLib.div(xtrem_date_time_1.Datetime.now().value, 1000));
        const feed = reader
            .map((item) => {
            item._syncTick = _syncTick;
            return JSON.stringify(item);
        })
            .toAsyncGenerator();
        return { nextTick, feed };
    }
};
exports.SysSynchronizationSource = SysSynchronizationSource;
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [
            {
                name: 'node',
                type: 'string',
                isMandatory: true,
            },
            { name: 'startTick', type: 'decimal', dataType: () => xtrem_core_1._syncTickDataType },
            { name: 'selector', type: 'string' },
            { name: 'filter', type: 'string' },
        ],
        return: {
            type: 'object',
            properties: {
                nextTick: { type: 'decimal', dataType: () => xtrem_core_1._syncTickDataType },
                feed: {
                    type: 'array',
                    item: 'string',
                },
            },
        },
    })
], SysSynchronizationSource, "getSynchronizationFeed", null);
exports.SysSynchronizationSource = SysSynchronizationSource = __decorate([
    xtrem_core_1.decorators.node({
        isPublished: true,
        storage: 'external',
        externalStorageManager: new dummy_storage_manager_1.DummyStorageManager(),
        keyPropertyNames: ['_id'],
    })
], SysSynchronizationSource);
//# sourceMappingURL=sys-synchronization-source.js.map