/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),nodes_1=require("../../fixtures/nodes"),setup_1=require("../../fixtures/setup");describe("context select",()=>{before(setup_1.setupTest),it("can select the array of _ids with `true` selector",()=>xtrem_core_1.Test.withReadonlyContext(async e=>{const t=await e.select(nodes_1.TestProductSite,true,{filter:{},first:5});chai_1.assert.isAtLeast(t.length,1),chai_1.assert.isAtMost(t.length,5),chai_1.assert.isTrue(t.every(e=>"string"==typeof e))})),it("can select with a selector",()=>xtrem_core_1.Test.withReadonlyContext(async e=>{const t=await e.select(nodes_1.TestProductSite,{_id:true,product:{code:true},stockSite:true},{filter:{},first:5});chai_1.assert.isAtLeast(t.length,1),chai_1.assert.isAtMost(t.length,5),t.forEach(e=>{chai_1.assert.isTrue("object"==typeof e,`Result ${e} is not an object.`),chai_1.assert.equal(Object.keys(e).length,3,`Result ${JSON.stringify(e)} has more attributes than the selected properties.`),chai_1.assert.deepEqual(Object.keys(e),["_id","product","stockSite"]),chai_1.assert.isNotNull(e.product?.code)})})),it("can select denormalized node with a selector",()=>xtrem_core_1.Test.withReadonlyContext(async e=>{const t=await e.select(nodes_1.TestUserFunctionProfileDefaultSite,{_id:true,profile:true,defaultSite:true},{filter:{profile:"ADDO"},first:5});chai_1.assert.isAtLeast(t.length,1),chai_1.assert.isAtMost(t.length,20),t.forEach(e=>{chai_1.assert.isTrue("object"==typeof e,`Result ${e} is not an object.`),chai_1.assert.equal(Object.keys(e).length,4,`Result ${JSON.stringify(e)} has more attributes than the selected properties.`),chai_1.assert.deepEqual(Object.keys(e),["denormalizedIndex","_id","defaultSite","profile"])})}))});
//# sourceMappingURL=select-test.js.map