/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),nodes_1=require("../../fixtures/nodes"),setup_1=require("../../fixtures/setup");describe("Denormalized collections",()=>{before(setup_1.setupTest),it("can query a node with denormalized collection and get results",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.read(nodes_1.TestUserFunctionProfile,{profile:"ADMIN"});chai_1.assert.equal(await t.defaultSites.length,20)})),it("can query a denormalized collection with a filter and get results",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.read(nodes_1.TestUserFunctionProfile,{profile:"ADDO"});chai_1.assert.isAtLeast(await t.reports.length,50),(0,chai_1.assert)(await t.reports.every(async e=>!!await e.profile));const a=e.application.getFactoryByConstructor(nodes_1.TestUserFunctionProfileReport).externalStorageManager.query(e,{filters:[{profile:"ADDO"},{reportGroupAuthor:false}]}),r=await a.readAll();chai_1.assert.isAtLeast(r.length,50);const s=await r[0]._createStamp,i=await r[0]._updateStamp,o=xtrem_core_1.date.today().value;chai_1.assert.isTrue(await(0,xtrem_core_1.asyncArray)(r).some(async e=>(await e._createStamp).date.value!==o)),chai_1.assert.isTrue(await(0,xtrem_core_1.asyncArray)(r).some(async e=>(await e._updateStamp).date.value!==o)),await(0,xtrem_core_1.asyncArray)(r).forEach(async e=>{const t=await e._createStamp,a=await e._updateStamp;chai_1.assert.equal(s.value,t.value),chai_1.assert.equal(i.value,a.value),chai_1.assert.isNotNull(await e._createUser),chai_1.assert.isNotNull(await e._updateUser),chai_1.assert.isNotNull(e._id)})})),it("cannot query a denormalized node with filter that does not contain all the key properties",async()=>{await chai_1.assert.isRejected(xtrem_core_1.Test.withContext(e=>e.query(nodes_1.TestUserFunctionProfileDefaultSite,{filter:{defaultSite:"DUMMY"}}).toArray()),"TestUserFunctionProfileDefaultSite: Denormalized node key property filter missing.")})});
//# sourceMappingURL=denormalized-test.js.map