import { Collection, date, integer, Node, Reference } from '@sage/xtrem-core';
import { TestCustomerType } from '../enums/test-customer-type';
import { TestCurrency } from './test-currency';
import { TestCustomerCategory } from './test-customer-category';
import { TestCustomerProduct } from './test-customer-product';
import { TestMiscellaneousTable } from './test-miscellaneous-table';
import { TestTaxRule } from './test-tax-rule';
/** 4GL code: BPCUSTOMER */
export declare class TestCustomer extends Node {
    /** 4GL code: BPCNUM */
    readonly code: Promise<string>;
    /** 4GL code: BPCNAM */
    readonly companyName: Promise<string>;
    /** 4GL code: BPCSHO */
    readonly shortCompanyName: Promise<string>;
    /** 4GL code: BCGCOD */
    readonly category: Reference<TestCustomerCategory | null>;
    /** 4GL code: BPCTYP */
    readonly customerType: Promise<TestCustomerType | null>;
    /** 4GL code: BPCINV */
    readonly billToCustomer: Reference<TestCustomer | null>;
    /** 4GL code: BPCGRU */
    readonly groupCustomer: Reference<TestCustomer | null>;
    /** 4GL code: BPCRSK */
    readonly riskCustomer: Reference<TestCustomer | null>;
    /** 4GL code: BPCSTA */
    readonly isActive: Promise<boolean | null>;
    /** 4GL code: PPTFLG */
    readonly isProspect: Promise<boolean | null>;
    /** 4GL code: CUR */
    readonly currency: Reference<TestCurrency | null>;
    readonly taxRule: Reference<TestTaxRule | null>;
    /** 4GL code: CDTISRDAT */
    readonly insuranceDate: Promise<date | null>;
    /** 4GL code: MTCFLG */
    readonly canBeMatched: Promise<boolean | null>;
    /** 4GL code: LNDAUZ */
    readonly isLoanAllowed: Promise<boolean | null>;
    /** 4GL code: OCNFLG */
    readonly mustPrintAcknowledgment: Promise<boolean | null>;
    /** 4GL code: ORDCLE */
    readonly isOrderClosingAllowed: Promise<boolean | null>;
    /** 4GL code: ODL */
    readonly mustContainOneOrderPerDelivery: Promise<boolean | null>;
    /** 4GL code: BUS */
    readonly businessSector: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: ORIPPT */
    readonly prospectOrigin: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: PITCDT */
    readonly tokenCredit: Promise<integer>;
    /** 4GL code: PITCPT */
    readonly manualAdditionalToken: Promise<integer>;
    /** 4GL code: TOTPIT */
    readonly totalTokenCredit: Promise<integer>;
    /** 4GL code: COTPITRQD */
    readonly necessaryTokensForServiceContract: Promise<integer>;
    /** 4GL code: CNTFIRDAT */
    readonly firstContactDate: Promise<date | null>;
    /** 4GL code: ORDFIRDAT */
    readonly firstOrderDate: Promise<date | null>;
    /** 4GL code: QUOLASDAT */
    readonly lastQuoteDate: Promise<date | null>;
    /** 4GL code: CNTLASDAT */
    readonly lastContactDate: Promise<date | null>;
    /** 4GL code: CNTNEXDAT */
    readonly nextContactDate: Promise<date | null>;
    /** 4GL code: BELVATSUB */
    readonly isSubjectToTax: Promise<boolean | null>;
    /** 4GL code: BPCSNCDAT */
    readonly initialDateSinceCustomer: Promise<date | null>;
    /** 4GL code: ELECTINV */
    readonly isEfatElectronicInvoicingAllowed: Promise<boolean | null>;
    readonly customerProducts: Collection<TestCustomerProduct>;
}
//# sourceMappingURL=test-customer.d.ts.map