import { Collection, Context, date, integer, Node, Reference } from '@sage/xtrem-core';
import { DateValue } from '@sage/xtrem-date-time';
import { Decimal } from '@sage/xtrem-decimal';
import { TestDocumentLine } from './document-line';
export declare class TestDocument extends Node {
    readonly code: Promise<string>;
    readonly description: Promise<string>;
    readonly date: Promise<DateValue>;
    readonly parentDocument: Reference<TestDocument>;
    readonly parentCode: Promise<string>;
    readonly parentDescription: Promise<string>;
    readonly parentDate: Promise<DateValue>;
    readonly grandparentDocument: Reference<TestDocument>;
    readonly grandparentCode: Promise<string>;
    readonly grandparentDescription: Promise<string>;
    readonly grandparentDate: Promise<DateValue>;
    readonly lines: Collection<TestDocumentLine>;
    readonly parentLines: Collection<TestDocumentLine>;
    readonly grandparentLines: Collection<TestDocumentLine>;
    readonly child: Collection<TestDocument>;
    static apiOperation(context: Context, parameters: {
        numero: integer;
        chaine: string;
        datetest: date[];
        dectest: Decimal;
        amltest: boolean;
        structures: {
            test1: string;
            test2: string;
        }[];
    }): Promise<{
        retourint: integer;
        retourmes: string;
    }>;
}
//# sourceMappingURL=document.d.ts.map