/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlQuery=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),sql_converter_1=require("./sql-converter"),sql_resolver_1=require("./sql-resolver"),sql_value_converter_1=require("./sql-value-converter");class SqlQuery{static{this.internalStatistics={queryCount:0}}constructor(e,t,r,s){if(this.context=e,this.factory=t,this.options=r,this.schemaName=s,this._inactiveProperties=[],r.locale)this.currentLocale=r.locale;const{joinFallbackProperties:o}=this.externalStorageManager;if(r.singleResultRequest&&o&&o.length>0)this.options=this.fillFallbackPropertyOptions(r);this.sqlConverter=new sql_converter_1.SqlConverter(this.context,this.schemaName,this.factory)}fillFallbackPropertyOptions(e){const t={...e},{joinFallbackProperties:r}=this.externalStorageManager;return t.first=1,r?.forEach(e=>{if(!t.orderBy)t.orderBy={};t.orderBy[e]=1,t.filters.forEach((r,s)=>{if(r[e]&&"object"!=typeof r[e])if(r[e]={_in:[r[e],null]},t.filters[s]=r,t.orderBy)t.orderBy[e]=-1})}),t}get externalStorageManager(){return this.factory.externalStorageManager}get outputColumns(){return this._selectedColumns}get groupValueColumns(){return{groups:this.groupColumns,values:this.valueColumns}}getGroupsOrderBy(e){return this.sqlConverter.convertAggregateGroups(e).map((t,r)=>({...t,path:e[r].path,direction:1,property:t.property,group:e[r]}))}orderBySql(e,t,r){const{orderByClauses:s}=this;if(!s)return"";if(0===s.length)return"";return`ORDER BY ${s.map(s=>{const o=e?1===s.direction?-1:1:s.direction,a=sql_resolver_1.SqlResolver.orderByDirections(this.context),l=SqlQuery.getAggregationOperator(s,t,r);return`${t&&!s.group?`${s.columnAlias}${l}`:`${s.columnAlias}`} ${-1===o?a.desc:a.asc}`}).join(", ")}`}static getAggregationOperator(e,t,r){const s=[...r||[],...t||[]].find(t=>t.columnAlias?.substring(0,t.columnAlias.lastIndexOf(`_${sql_resolver_1.SqlResolver.makeColumnAlias(t.aggregationOperator||"")}`.toUpperCase()))===`${e.columnAlias}`);return s?.aggregationOperator?`_${sql_resolver_1.SqlResolver.makeColumnAlias(s?.aggregationOperator)}`.toUpperCase():""}cursorWhere(e){if(!this.options[e])return"";if(!this.orderByClauses)throw new Error(`${this.factory.tableName}: missing 'orderBy' option`);const{before:t,after:r,orderByClauses:s}=this,o=s.map((o,a)=>{const l=[];for(let o=0;o<a;o+=1){const a=s[o];let i;if("after"===e)i=sql_value_converter_1.SqlValueConverter.toSql(this.context,this.factory,a.property,r[o].value);if("before"===e)i=sql_value_converter_1.SqlValueConverter.toSql(this.context,this.factory,a.property,t[o].value);l.push(`${a.sql} = ${i}`)}const i="before"===e?o.direction>0?"<":">":o.direction>0?">":"<";{const{property:s}=o;let n="";if("after"===e)n=`${o.sql} ${i} ${sql_value_converter_1.SqlValueConverter.toSql(this.context,this.factory,o.property,r[a].value)}`;if("before"===e)n=`${o.sql} ${i} ${sql_value_converter_1.SqlValueConverter.toSql(this.context,this.factory,o.property,t[a].value)}`;if("<"===i&&s.isNullable){const e=sql_resolver_1.SqlResolver.getPropertyType(o.property);n=`(${n} OR ${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,o.sql,e,["1","0"])}=1)`}l.push(n)}return sql_converter_1.SqlConverter.and(l)});return sql_converter_1.SqlConverter.or(o)}whereClause(){const e=this.options.filters.map(e=>this.sqlConverter.convertFilter(e));if(!this.externalStorageManager.isDenormalized)e.push(this.cursorWhere("after")),e.push(this.cursorWhere("before"));return sql_converter_1.SqlConverter.and(e)}getGroupByClauses(e){const t=this.aggregateResult;if(t?.groups?.length){return{groupByClause:`GROUP BY ${t?.groups.map(e=>e.sql).join(", ")}`,groupOrderByClause:` ORDER BY ${t?.groups.map(t=>`${t.columnAlias} ${e?"DESC":"ASC"}`).join(", ")}`}}if(t?.values?.length)return{};return{groupOrderByClause:this.orderBySql(e)}}static transformConverted(e){e.forEach(t=>{if(t.denormalizeChildSlots&&t.denormalizeChildSlots.length>0)t.denormalizeChildSlots.forEach(t=>{e.push(t)})})}getOutputPaths(e,t,r){const s=true===e?{_id:true}:e;return Object.entries(s).forEach(([e,s])=>{const o=[...t,e];if(true===s)r.push(o);else if(s&&"object"==typeof s){if(!s._id)r.push(o);this.getOutputPaths(s,o,r)}}),r}getTableColumnPaths(){const e=Object.values(sql_resolver_1.systemProperties).map(e=>sql_resolver_1.SqlResolver.findProperty(this.factory,e.name));return[...this.factory.properties.filter(e=>!Object.values(sql_resolver_1.systemProperties).find(t=>t.name===e.name)),...e].filter(e=>e.isStored&&"collection"!==e.type&&"denormalizedIndex"!==e.name&&!this._inactiveProperties.includes(e)).map(e=>[e.name])}getOutputColumns(){const e=this.options.selector?this.getOutputPaths(this.options.selector,[],[]):this.getTableColumnPaths(),t=this.sqlConverter.convertOutputPaths(e);return SqlQuery.transformConverted(t),t.filter(e=>!!e.sql)}columnValue(e,t){if(this._inactiveProperties.some(t=>t.name===e.property?.name))return null;return sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,t)}async mapRecordIn(e,t){const r={};if(!e)throw new xtrem_shared_1.LogicError("missing outputColumns");if(true===this.options.selector){const r=e[0];if(r.columnAlias&&1===r.payloadPath?.length&&"_id"===r.payloadPath[0]){if("_id"!==r.property?.name)throw new xtrem_shared_1.LogicError(`unexpected property: ${r.property?.name}`);return t[r.columnAlias]}}return await(0,xtrem_core_1.asyncArray)(e).forEach(e=>{if(e.payloadPath){if(!e.columnAlias)throw new xtrem_shared_1.LogicError("no column alias");const s=this.columnValue(e,t[e.columnAlias]);let o=r;const a=e.payloadPath[e.payloadPath.length-1];for(let t=0;t<e.payloadPath.length-1&&null!=o;t+=1){const r=e.payloadPath[t];if("object"!=typeof o[r])o[r]={};if(null===s&&"_id"===a&&t===e.payloadPath.length-2)o[r]=null;o=o[r]}if(o)o[a]=s}}),this._inactiveProperties.forEach(e=>{r[e.name]=null}),r}async mapAggregateRecordIn(e,t,r){const assign=(e,t,r,s)=>{const o=t.shift();if(t.length>(s?1:0)){if(!e[o])e[o]={};assign(e[o],t,r,s)}else e[o]=r},s={};return await(0,xtrem_core_1.asyncArray)(e).forEach(e=>{s.group=s.group||{};const t=e.aggregationOperator??"value",o=e.payloadPath&&e.payloadPath.length>0?[...e.payloadPath,t]:[...e.path.split(".").slice(1),t];assign(s.group,o,this.columnValue(e,r[e.columnAlias]),e.aggregationOperator)}),await(0,xtrem_core_1.asyncArray)(t).forEach(e=>{s.values=s.values||{};const t=e.aggregationOperator??"value",o=e.payloadPath&&e.payloadPath.length>0?[...e.payloadPath,t]:[...e.path.split(".").slice(1),t];assign(s.values,o,this.columnValue(e,r[e.columnAlias]))}),s}isAggregateQuery(){return!!this.aggregateResult?.groups?.length||!!this.aggregateResult?.values?.length}isSingleResult(){return!!(this.aggregateResult&&this.aggregateResult.groups&&0===this.aggregateResult.groups.length)}get defaultOrderBy(){return this.factory.keyProperties.filter(e=>this.externalStorageManager.isDenormalized&&"denormalizedIndex"!==e.name).reduce((e,t)=>(e[t.name]=1,e),{})}static lockClause(e){return""}static safeParseInt(e,t){const r=Number(t);if(!Number.isInteger(r))throw new Error(`column ${e.name}: invalid integer value ${t}`);return r}static safeParseFloat(e,t){const r=Number(t);if(!Number.isFinite(r))throw new Error(`column ${e.name}: invalid number value ${t}`);return r}static parsePropertyValue(e,t){const r=sql_resolver_1.SqlResolver.getPropertyType(e);if("string"===r)return t;if(!t)return null;switch(r){case"float":case"double":case"decimal":return this.safeParseFloat(e,t);case"integer":case"short":return this.safeParseInt(e,t);case"boolean":return"true"===String(t);case"enum":if(!Number.isFinite(Number(t))){return e.dataType.numberValue(t)}return this.safeParseInt(e,t);case"date":return xtrem_date_time_1.DateValue.parse(t);case"dateRange":return xtrem_date_time_1.DateRange.parse(t);case"datetimeRange":return xtrem_date_time_1.DatetimeRange.parse(t);case"time":return xtrem_date_time_1.Time.parse(t);case"datetime":return xtrem_date_time_1.Datetime.parse(t);case"uuid":return xtrem_core_1.Uuid.fromString(t);default:throw new Error(`column ${e.name}: unsupported type ${r}`)}}static fastHash(e){let t=5381,r=e.length;for(;r;)r-=1,t=33*t^e.charCodeAt(r);return t>>>0}static cursorChecksum(e){const t=e.replace(/'/g,'"');return`#${(this.fastHash(t.replace(/'/g,'"'))%100).toString().padStart(2,"0")}`}static removeCursorChecksum(e){if(!e)return e;const t=e.substring(0,e.length-3),r=this.cursorChecksum(t);if(!e.endsWith(r))throw new Error(`${e}: invalid cursor value (checksum verification failed)`);return t}static parseCursorValues(e,t){if(0===e.length)throw new Error("Cannot parse cursor: missing orderBy");if(t.length>e.length)throw new Error("Cannot parse cursor: too many values");if(t.length<e.length)throw new Error("Cannot parse cursor: too few values");return e.map((e,r)=>({property:e.property,value:this.parsePropertyValue(e.property,t[r])}))}static parseCursor(e,t){const r=this.removeCursorChecksum(t);return this.parseCursorValues(e,(0,xtrem_core_1.friendlyJsonParse)(r))}isMissingColumnInOrderByClause(e){return!this._selectedColumns?.find(t=>t.property===e.property||this.isAggregateQuery()&&t.columnAlias===`${e.columnAlias}_${sql_resolver_1.SqlResolver.makeColumnAlias(t?.aggregationOperator||"").toUpperCase()}`)}getSqlQuery(){SqlQuery.internalStatistics.queryCount+=1;const{options:e}=this;this.aggregateResult=this.sqlConverter.convertAggregate(this.options.aggregate);const t=this.options.aggregate&&!this.options.orderBy?this.getGroupsOrderBy(this.options.aggregate.groups):this.sqlConverter.convertOrderBy(this.options.orderBy||this.defaultOrderBy);if(this.orderByClauses=this.options.count?[]:t,this.after=this.options.after&&!this.externalStorageManager.isDenormalized?SqlQuery.parseCursor(this.orderByClauses,this.options.after):void 0,this.before=this.options.before&&!this.externalStorageManager.isDenormalized?SqlQuery.parseCursor(this.orderByClauses,this.options.before):void 0,e.forUpdate&&!this.context.isWritable)throw new Error(`${this.factory.name}: cannot query for update: context is readonly`);const r=e.forUpdate?SqlQuery.lockClause("t0"):"",s=!!e.last&&!e.count,o=s?e.last?sql_resolver_1.SqlResolver.getX3Pool(this.context).limitClause(e.last):"":"",a=!s?e.first?sql_resolver_1.SqlResolver.getX3Pool(this.context).limitClause(e.first):"":o,l=s?e.last?sql_resolver_1.SqlResolver.getX3Pool(this.context).fetchOnlyClause(e.last):"":"",i=!s?e.first?sql_resolver_1.SqlResolver.getX3Pool(this.context).fetchOnlyClause(e.first):"":l;if(this.isAggregateQuery()){const{groups:e,values:t}=this.aggregateResult;this.groupColumns=e,this.valueColumns=t,this._selectedColumns=[...t||[],...e||[]]}else if(e.count)this._selectedColumns=[];else{this._inactiveProperties=this.externalStorageManager.getInactiveProperties(this.context);const e=this.getOutputColumns();this._selectedColumns=e}const{groupByClause:n,groupOrderByClause:u}=this.getGroupByClauses(s),c=[];if(this.orderByClauses.filter(e=>this.isMissingColumnInOrderByClause(e)).forEach(e=>{c.push(e.path.join(".")),this._selectedColumns.push({alias:"",...e,path:e.path.join("."),property:e.property,factory:this.factory})}),this.isAggregateQuery()&&c.length>0)throw new Error(`${c.join(",")} not contained in either an aggregate function or the GROUP BY clause`);const h=`WHERE ${this.whereClause()}`,p=this._selectedColumns.map(e=>`${e.sql} AS ${e.columnAlias}`).join(", "),g=this.sqlConverter.getTableAliases().replace(/\sAS\s/g," ").trim();let m=[e.count?"SELECT COUNT(*) AS NROWS":`SELECT ${a} ${p}`,`FROM ${g}`,h,n].join(" ");if(e.count)return m;if(!this.isSingleResult())m+=` ${this.orderBySql(s,this.groupColumns,this.valueColumns)||u||""}`;return m+=` ${i} ${r}`,m}}exports.SqlQuery=SqlQuery;
//# sourceMappingURL=sql-query.js.map