/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebServiceMapping=void 0;const xtrem_core_1=require("@sage/xtrem-core"),fs=require("fs"),_=require("lodash"),path=require("path"),index_1=require("../../../index"),web_service_response_1=require("./web-service-response"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-service");class WebServiceMapping{static removeStatusFromMapping(e){return e.replace(/[+^!]/,"")}static xtremToLegacyDataFormatting(e){let i=e;if(i instanceof xtrem_core_1.date)i=i.value;if(i?(i.toString()||"").match(/([12]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01]))/g,i):false)return i.replace(/-/g,"");if(_.isBoolean(i))return i?"2":"1";return i}static stringifyContent(e){return JSON.stringify(e,(e,i)=>void 0===i?"":i,4)}static updateMapping(e,i){const r={},t=JSON.parse(JSON.stringify(e)),a=JSON.parse(JSON.stringify(i));return Object.keys(a||{}).forEach(e=>{if(r[e]=a[e],_.isPlainObject(a[e]))Object.keys(a[e]||{}).forEach(i=>{if(a[e][i]!==t[e][i]&&"^"===a[e][i][0])r[e][i]=t[e][i]})}),Object.keys(t||{}).forEach(e=>{if(_.isPlainObject(t[e])){if(!a[e])r[e]=t[e];Object.keys(t[e]||{}).forEach(i=>{if(!(a&&a[e]&&a[e][i]))r[e][i]=t[e][i]})}}),r}static mappingGroup(e,i,r,t,a=""){r[t]=r[t]?r[t]:{},e.properties.forEach(e=>{let s=[];if(i)s=Array.isArray(i)?i:[i];s.forEach(i=>{if(i===e.name&&!("+"===r?.[t]?.[i]?.[0]||"!"===r?.[t]?.[i]?.[0])){if(a){if(r[t]&&!r[t].lineNumber)r[t].lineNumber="^entryLineNumber";if(r[t]&&!r[t].collectionName)r[t].collectionName=`^${a}`}if(e.isReferenceProperty())r[t][i]=`^${e.name}.${e.targetFactory.keyProperties[0].columnName}`;else r[t][i]=`^${e.name}`}})})}static async readMappingFile(e,i){const r=i.package.dir,t=path.resolve(r,"data/gateway",e.isImportBasedWebService?`${e.importModelName}-import.json`:`${e.webServiceName}-mapping.json`);let a={};try{return a=await fs.promises.readFile(t,"utf8"),JSON.parse(a)}catch(i){if(logger.error(`Mapping file doesn't exists. The file must be in /data/gateway of your module with the following name ${e.isImportBasedWebService?e.importModelName:e.webServiceName}-{mapping,import}.json`),"development"!==e.deploymentMode)throw new Error(i);if("development"===e.deploymentMode&&e.isImportBasedWebService)throw new Error(i);return{}}}static async writeMappingFile(e,i,r){const t=i.package.dir,a=path.resolve(t,"data/gateway");try{await fs.promises.stat(a)}catch(e){await fs.promises.mkdir(a)}const s=path.resolve(t,"data/gateway",e.isImportBasedWebService?`${e.importModelName}-import.json`:`${e.webServiceName}-mapping.json`);await fs.promises.writeFile(s,WebServiceMapping.stringifyContent(r)),logger.info("File is created (or updated) successfully.")}static async buildObjectAndSubProgramWebServiceMapping(e,i,r){const t=r?r.forceMappingRegeneration?r.forceMappingRegeneration:false:false;let a;if(e.isObjectBasedWebService)a=e.webServiceInputsAndKeysDataSchema;else a=e.webServiceInputDataSchema;if(!_.isEmpty(a)){if(0===a.statusCode)throw new Error(`Failed to get mapping for web service '${e.webServiceName}': ${a.messages?.errors?.join(" & ")}`)}else throw new Error(index_1.data.errorsMessages.poolWebServiceNotExistent(e.webServiceName));const s=a.results.payload,n=a.results.keys;let p={},o={};if(!t)o=await WebServiceMapping.readMappingFile(e,i),p=JSON.parse(JSON.stringify(o));const c=i.properties.filter(e=>e.isCollectionProperty()),l=Object.keys(s||{}).filter(e=>"Table"===s[e].type),g=Object.keys(s||{}).filter(e=>"Table"!==s[e].type),f=Object.keys(n||{}),b=i.keyProperties||[],m=[];b.forEach(e=>{m.push(Object.keys(e.orderBy||{}))}),(f||[]).forEach(e=>{WebServiceMapping.mappingGroup(i,e,p,"keys")}),(g||[]).forEach(e=>{const r=s[e].fields,t=Object.keys(r||{});WebServiceMapping.mappingGroup(i,t,p,e)}),(l||[]).forEach(e=>{const i=s[e],{lines:r}=i,t=Object.keys(r.fields||{});(c||[]).forEach(i=>{if(i.isCollectionProperty())WebServiceMapping.mappingGroup(i.targetFactory,t,p,e,i.name)})});const y=WebServiceMapping.updateMapping(p,o);if(WebServiceMapping.stringifyContent(o)!==WebServiceMapping.stringifyContent(y))await WebServiceMapping.writeMappingFile(e,i,y);return y}static checkObjectAndSubProgramWebServiceMappingIntegrity(e,i){let r=[];const parseObjectProperties=(e,i=false)=>{if(!i)r=[];if(!_.isEmpty(e))return Object.keys(e||{}).forEach(i=>{if(_.isPlainObject(e[i]))parseObjectProperties(e[i],true);if("type"!==i&&"lines"!==i&&"fields"!==i&&"table"!==i&&"list"!==i&&"keys"!==i&&"collectionName"!==i&&r.indexOf(i)<0&&isNaN(parseInt(i,10)))r.push(i)}),r;return null},t=parseObjectProperties(e),a=(parseObjectProperties(i)||[]).find(e=>t.indexOf(e)<0);if(a)throw new Error(`"${a}" doesn't exist in the web service's inputs. Please remove it from the mapping file.`)}static async getWebServiceMapping(e,i,r){if(_.isEmpty(e.mapping)){if(!e.isImportBasedWebService)if("development"===e.deploymentMode)e.mapping=await WebServiceMapping.buildObjectAndSubProgramWebServiceMapping(e,i,r),WebServiceMapping.checkObjectAndSubProgramWebServiceMappingIntegrity(e.webServiceInputDataSchema.results.payload,e.mapping);else e.mapping=await WebServiceMapping.readMappingFile(e,i);e.mapping=await WebServiceMapping.readMappingFile(e,i)}return e.mapping}static getKeys(e){const i={},r=e.results.ADXDOC.ADXKEY.GRP,t=Array.isArray(r.FLD)?r.FLD:null!=r.FLD?[r.FLD]:[];if(r&&!_.isEmpty(t))t.forEach(e=>{if(Object.keys(e.$||{}).length>0){const r=e.$.NAM,t=e.$.TYP,a=e.$.LEN,s=`${e.$.C_ENG?e.$.C_ENG:""} (${t} : ${a})`;i[r]=s}});return i}static getPayload(e){const i={};let r=e.results.ADXDOC.ADXDATA.GRP;if(!Array.isArray(r))r=[r];return(r||[]).forEach(e=>{let r="",t="",a=1;const s=Array.isArray(e.FLD)?e.FLD:null!=e.FLD?[e.FLD]:[];if(s.length>0&&"ADXTEC"!==e.$.NAM&&"LEFTLIST"!==e.$.NAM)(s||[]).forEach((s,n)=>{const p=s.$.NAM,o=s.$.TYP,c=s.$.LEN,l=s.$.UNSEL,g=`${s.$.C_ENG?s.$.C_ENG:""} (${o} : ${c})`;if(!l)if(0===n||r!==e.$.NAM)if(r=e.$.NAM,t=e.$.TYB,a=!_.isNaN(parseInt(e.$.DIM,10))?parseInt(e.$.DIM,10):1,"Table"===t||a>1)i[r]={type:"Table",lines:{lineNumber:"Line Number",fields:{[p]:g}}};else if("List"===t)i[r]={type:"List",fields:{[p]:g}};else i[r]={fields:{[p]:g}};else if("Table"===t||a>1)i[r].lines.fields[p]=g;else if("List"===t)i[r].fields[p]=g;else i[r].fields[p]=g})}),i}static getWebServiceKeysAndInputsParameters(e,i){let r,t;if("objectKeysAndObjectInput"===e)r=WebServiceMapping.getPayload(i),t=WebServiceMapping.getKeys(i);else if("subProgramInput"===e||"objectInput"===e)r=WebServiceMapping.getPayload(i);else if("objectKeys"===e)t=WebServiceMapping.getKeys(i);else r={},t={};return web_service_response_1.WebServiceResponse.buildWebServiceResponse(1,{payload:r,keys:t})}}exports.WebServiceMapping=WebServiceMapping;
//# sourceMappingURL=web-service-mapping.js.map