/// <reference types="node" />
/// <reference types="node" />
import { Context, NodeFactory, ValidationContext } from '@sage/xtrem-core';
import { interfaces } from '../index';
export interface WebServiceCallOptions {
    languageRequest?: boolean;
    folderRequest?: boolean;
    validationContext?: ValidationContext;
}
export declare class WebServiceCall implements interfaces.WebServiceCallInterface {
    private _nodeContext;
    private readonly _webServiceName;
    private options;
    private _webServicePoolParameters;
    private _webServiceDescription;
    private _isObjectBasedWebService;
    private _webServiceInputDataSchema;
    private _webServiceKeysDataSchema;
    private _webServiceInputsAndKeysDataSchema;
    private _deploymentMode;
    private _importModelName;
    private _isImportBasedWebService;
    private _mapping;
    private _soapPayload;
    private _codeLang;
    /**
     *
     * @param webServicePoolParameters
     * @param webServiceName
     */
    private constructor();
    static create(context: Context, webServiceName: string, options: WebServiceCallOptions): Promise<WebServiceCall>;
    private init;
    private static getLanguageFromLocale;
    get codeLang(): Promise<string>;
    /**
     * Method to instantiate a call service.
     * @param context
     * @param node
     * @param webServiceName
     */
    static connectTo(context: Context, webServiceName: string, options: WebServiceCallOptions): Promise<WebServiceCall>;
    /**
     * Create a new record with auto mapping.
     * Can be used only for Object's based web service
     *
     * @param graphQLPayload
     * @param options
     */
    doCreate(graphQLPayload: any, factory: NodeFactory, options?: interfaces.MappingOptions): Promise<interfaces.ResultInterface>;
    /**
     * Create a new record.
     * Can be used only for Object's based web service
     * @param xmlPayload
     */
    createWithRawXmlPayload(xmlPayload: any): Promise<interfaces.ResultInterface>;
    /**
     * Create a new record.
     * Can be used only for Object's based web service
     * @param payload
     */
    createWithPayload(payload: interfaces.WebServiceInputsParameters<string>): Promise<interfaces.ResultInterface>;
    /**
     * Update an existing record with auto mapping.
     * Can be used only for Object's based web service
     *
     * @param graphQLPayload
     * @param options
     */
    doUpdate(graphQLPayload: any, factory: NodeFactory, options?: interfaces.MappingOptions): Promise<interfaces.ResultInterface>;
    /**
     *
     * @param xmlPayload
     */
    updateWithRawXmlPayload(xmlPayload: any): Promise<interfaces.ResultInterface>;
    /**
     * Modify a record.
     * Can be used only for Object's based web service
     * @param keys
     * @param payload
     */
    updateWithPayload(keys: interfaces.WebServiceKeysParameters<string>, payload: interfaces.WebServiceInputsParameters<string>): Promise<interfaces.ResultInterface>;
    /**
     * Run an X3 Subprogram
     * Can be used only for SubProgram's based web service.
     *
     * @param graphQLPayload
     * @param options
     */
    runSubProgram(graphQLPayload: any, factory: NodeFactory, options?: interfaces.MappingOptions): Promise<interfaces.ResultInterface>;
    /**
     * Run an X3 Subprogram
     * Can be used only for SubProgram's based web service.
     * @param xmlPayload
     */
    runSubProgramWithRawXmlPayload(xmlPayload: any): Promise<interfaces.ResultInterface>;
    /**
     * Run an X3 Subprogram
     * Can be used only for SubProgram's based web service.
     * @param payload
     */
    runSubProgramWithPayload(payload: interfaces.WebServiceInputsParameters<string | Buffer>): Promise<interfaces.ResultInterface>;
    /**
     * create a record using the import based web service
     *
     * @param importModelName
     * @param graphqlPayload
     */
    createWithImport(importModelName: string, factory: NodeFactory, graphqlPayload: any): Promise<interfaces.ResultInterface>;
    /**
     * check if is the action is allowed in object based web service
     */
    private isObjectBasedWebServiceAllowedAction;
    /**
     * check if is the action is allowed in sub-program based web service
     */
    private isSubProgramBasedWebServiceAllowedAction;
    /**
     * Check if the web service is object's based
     * @param description web service description
     */
    checkIfObjectWebService(): void;
    /**
     * get the description of the web Service
     * Can be used for Object and Subprogram
     */
    private setDescription;
    /**
     * Read a given record.
     * Can be used only for Object's based web service.
     * @param listSize
     * @param keys
     */
    read(listSize: number, keys: interfaces.WebServiceKeysParameters<string>): Promise<interfaces.ResultInterface>;
    /**
     * Query a given record.
     * Can be used only for Object's based web service.
     * @param listSize
     * @param keys
     */
    query(listSize: number, keys: interfaces.WebServiceKeysParameters<string>): Promise<interfaces.ResultInterface>;
    /**
     * get the web service errors
     */
    manageWebServiceResponseMessages(webServiceResponse: interfaces.ResultInterface, mapping: any, graphQLPayload: any): void;
    /**
     * get an xtrem compatible web service response
     */
    getXtremCompatibleResponse(response: interfaces.ResultInterface, mapping: any): any;
    /**
     * Get the JSON Input Schema of the web service.
     */
    private getWebServiceInputsDataSchema;
    /**
     * Get the JSON format schema for the object's keys
     * can be used for QUERY or READ.
     */
    private getWebServiceKeysDataSchema;
    /**
     * Get the JSON format schema for the object's keys
     * can be used for QUERY or READ.
     */
    private getWebServiceInputsAndKeysDataSchema;
    get webServicePoolParameters(): interfaces.WebServicePoolParameters;
    set webServicePoolParameters(webServicePoolParameters: interfaces.WebServicePoolParameters);
    get webServiceDescription(): interfaces.ResultInterface;
    get isObjectBasedWebService(): boolean;
    get webServiceInputDataSchema(): interfaces.ResultInterface;
    get webServiceKeysDataSchema(): interfaces.ResultInterface;
    get webServiceInputsAndKeysDataSchema(): interfaces.ResultInterface;
    get webServiceName(): string;
    get deploymentMode(): string;
    get mapping(): any;
    set mapping(mapping: any);
    get context(): Context;
    get importModelName(): string;
    get isImportBasedWebService(): boolean;
    get soapPayload(): interfaces.WebServiceRequestData;
    set soapPayload(payload: interfaces.WebServiceRequestData);
}
//# sourceMappingURL=web-service-call.d.ts.map