/// <reference types="lodash" />
import type { integration } from '@sage/xtrem-ui';
import * as React from 'react';
export interface HeaderProps {
    pageTitle: string | null;
    pageSubtitle: string | null;
    stockSiteCode?: string;
    depositorCode?: string;
    path: string;
    hasOpenDialog: boolean;
    hasOpenSticker: boolean;
    hasLookupDialog: boolean;
    openDialog?: integration.Menu;
    lookupDialog?: integration.Menu;
    onInternalNavigationChange: (path: string) => void;
    goHome: () => void;
    isApplicationDirty: boolean;
    preNavigationConfirmation: (() => Promise<void>) | null;
    isNavigationConfirmationPromptDisplayed: boolean;
}
export declare class Header extends React.Component<HeaderProps> {
    onLeftIconClick: () => Promise<void>;
    onRightIconClick: import("lodash").DebouncedFuncLeading<() => void>;
    getTitle(): string | null;
    isMainPage: () => boolean;
    isSettingsPage: () => boolean;
    render(): React.ReactNode;
}
declare const _default: import("react-redux").ConnectedComponent<typeof Header, {
    ref?: React.LegacyRef<Header> | undefined;
    key?: React.Key | null | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=header.d.ts.map