declare module 'lib/component/container/navigation-panel/navigation-panel-types' {
	export const navigationPanelId = "$navigationPanel";
	//# sourceMappingURL=navigation-panel-types.d.ts.map
}
declare module 'lib/service/shortcut-service' {
	export const getCurrentKeySequence: () => string[];
	export const clearKeyCombination: () => void;
	export type Key = 'escape' | 'control' | 'shift' | 'alt' | 'arrowup' | 'arrowdown' | 'space' | 'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'v' | 'w' | 'z' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' | '0' | 'f1' | 'f2' | 'f3' | 'f4' | 'f5' | 'f6' | 'f7' | 'f8' | 'f9' | 'f10' | 'f11' | 'f12';
	export const subscribe: (combination: Key | Key[], callback: () => void) => number;
	export const unsubscribe: (shortcutSubscriptionId: number | null) => void;
	//# sourceMappingURL=shortcut-service.d.ts.map
}
declare module 'lib/utils/types' {
	/// <reference types="react" />
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Datetime, DateValue } from '@sage/xtrem-date-time';
	import type { Dict } from '@sage/xtrem-shared';
	import type { Primitive, UnionToIntersection } from 'ts-essentials';
	import type { ScreenBase } from 'lib/service/screen-base';
	export type UnionType<T extends any[]> = T[number];
	export type DatePropertyValue = Date | string | DateValue;
	export type DateTimePropertyValue = Date | string | Datetime;
	export type QueryParameters = Dict<number | string | boolean>;
	/** Useful to make OR condition between properties in our interface. If we put the two properties Typescript returns an a type error.
	 * E.G RequireOnlyOne<interface, 'key1' | 'key2'> */
	export type RequireOnlyOne<T, Keys extends keyof T = keyof T & string> = Pick<T, Exclude<keyof T, Keys>> & {
	    [K in Keys]-?: Required<Pick<T, K>> & Partial<Record<Exclude<Keys, K>, undefined>>;
	}[Keys];
	export type Merge<M, N> = Omit<M, Extract<keyof M, keyof N>> & N;
	export type ValueOrCallbackWithFieldValue<CT extends ScreenBase, ReturnType, ValueType = any, RecordType = Dict<any>> = ((this: CT, value: ValueType, rowValue?: RecordType) => ReturnType) | ReturnType;
	export type ValueOrCallbackWitRecordValue<CT extends ScreenBase, ReturnType, RecordType = Dict<any>> = ((this: CT, rowValue?: RecordType) => ReturnType | undefined) | ReturnType | undefined;
	export type ValueOrCallback<CT extends ScreenBase, ReturnType> = ((this: CT) => ReturnType | undefined) | ReturnType;
	export type SingleKeyed<T> = T extends Array<any> ? never : T extends object ? RequireOnlyOne<{
	    [P in keyof T]?: T[P];
	}> : T;
	export type WithAtLeastOneKey<T, U = {
	    [K in keyof T]: Required<Pick<T, K>>;
	}> = Partial<T> & U[keyof U];
	export type Simplify<T> = {
	    [KeyType in keyof T]: T[KeyType];
	};
	export type PickOwnProperties<T extends ClientNode, P> = Simplify<Pick<T, {
	    [K in keyof T]: T[K] extends P ? UnionToIntersection<T[K]> extends Array<P> ? P & UnionToIntersection<P> extends infer Z ? P extends Z ? never : K : K : K : P extends Array<infer U> ? T[K] extends U ? UnionToIntersection<T[K]> extends Array<U> ? K : never : T[K] extends U ? K : never : P extends T[K] ? K : never;
	}[keyof T]>>;
	export type IsEqual<T, U> = (<G>() => G extends T ? 1 : 2) extends <G>() => G extends U ? 1 : 2 ? true : false;
	type Filter<KeyType, ExcludeType> = IsEqual<KeyType, ExcludeType> extends true ? never : KeyType extends ExcludeType ? never : KeyType;
	export type Except<ObjectType, KeysType extends keyof ObjectType> = {
	    [KeyType in keyof ObjectType as Filter<KeyType, KeysType>]: ObjectType[KeyType];
	};
	export type SetRequired<BaseType, Keys extends keyof BaseType> = Simplify<Except<BaseType, Keys> & Required<Pick<BaseType, Keys>>>;
	type ValueOrCallbackKeys<Base> = NonNullable<{
	    [Key in keyof Base]: Base[Key] extends ValueOrCallback<any, any> ? Base[Key] extends UnionToIntersection<Base[Key]> ? never : Key : never;
	}[keyof Base]>;
	type ConditionalKeys<Base, Condition> = NonNullable<{
	    [Key in keyof Base]: Base[Key] extends Condition ? Key : never;
	}[keyof Base]>;
	export type ValueOrCallbackKeysExtractor<Base> = ValueOrCallbackKeys<Omit<Base, ConditionalKeys<Base, Primitive>>>;
	type ValueOrCallbackPick<Base> = Pick<Base, ValueOrCallbackKeys<Base>>;
	type ValueOrCallbackReturnExtractorInternal<Base> = ValueOrCallbackPick<Omit<Base, ConditionalKeys<Base, Primitive>>>;
	export type ValueOrCallbackReturnExtractor<Base, K extends keyof ValueOrCallbackReturnExtractorInternal<Base>> = ValueOrCallbackReturnExtractorInternal<Base>[K] extends ValueOrCallback<any, infer R> ? R : never;
	export type MakeRequired<T, K extends keyof T & string> = Omit<T, K> & Required<Pick<T, K>>;
	export type CarbonLinkEvent = React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLButtonElement>;
	export type Writeable<T> = {
	    -readonly [P in keyof T]: T[P];
	};
	export type RecordValue<T> = T extends Record<any, infer U> ? U : never;
	export interface JsonSerializableObject {
	    [member: string]: JsonSerializableValue;
	}
	export interface JsonSerializableArray extends Array<JsonSerializableValue> {
	}
	export type JsonSerializableValue = Primitive | JsonSerializableObject | JsonSerializableArray;
	type _TupleOf<T, N extends number, R extends unknown[]> = R['length'] extends N ? R : _TupleOf<T, N, [T, ...R]>;
	export type FixedSizeTuple<T, N extends number> = N extends N ? (number extends N ? T[] : _TupleOf<T, N, []>) : never;
	export {};
	//# sourceMappingURL=types.d.ts.map
}
declare module 'lib/component/decorator-properties' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	export { AggregateDecoratorProperties, BlockDecoratorProperties, ButtonDecoratorProperties, CalendarDecoratorProperties, CardDecoratorProperties, ChartDecoratorProperties, CheckboxDecoratorProperties, ContentTableDecoratorProperties, CountDecoratorProperties, DateDecoratorProperties, TimeDecoratorProperties, DetailListDecoratorProperties, DetailPanelDecoratorProperties, DropdownListDecoratorProperties, DynamicPodDecoratorProperties, FileDecoratorProperties, FileDepositDecoratorProperties, FilterEditorDecoratorProperties, FilterSelectDecoratorProperties, FormDesignerDecoratorProperties, FragmentFieldsDecoratorProperties, GridRowBlockDecoratorProperties, IconDecoratorProperties, ImageDecoratorProperties, LabelDecoratorProperties, LinkDecoratorProperties, MessageDecoratorProperties, MultiDropdownDecoratorProperties, MultiFileDepositDecoratorProperties, MultiReferenceDecoratorProperties, NestedGridDecoratorProperties, NodeBrowserTreeDecoratorProperties, NumericDecoratorProperties, PageActionDecoratorProperties, PageDecoratorProperties, PageExtensionDecoratorProperties, PageFragmentDecoratorProperties, PluginDecoratorProperties, PodDecoratorProperties, ProgressDecoratorProperties, RadioDecoratorProperties, ReferenceDecoratorProperties, RelativeDateDecoratorProperties, RichTextDecoratorProperties, SectionDecoratorProperties, SelectDecoratorProperties, SelectionCardDecoratorProperties, SeparatorDecoratorProperties, StaticContentDecoratorProperties, StepSequenceDecoratorProperties, StickerDecoratorProperties, SwitchDecoratorProperties, TableDecoratorProperties, TableSummaryDecoratorProperties, TextAreaDecoratorProperties, TextDecoratorProperties, TileDecoratorProperties, ToggleDecoratorProperties, TreeDecoratorProperties, VisualProcessDecoratorProperties, VitalPodDecoratorProperties, WorkflowDecoratorProperties, } from 'lib/component/decorators';
	//# sourceMappingURL=decorator-properties.d.ts.map
}
declare module 'lib/utils/window' {
	import type { Dict } from '@sage/xtrem-shared';
	export const getWindowParameters: () => Dict<string>;
	export const getLocalStorage: () => Storage;
	export const isDevMode: () => boolean;
	//# sourceMappingURL=window.d.ts.map
}
declare module 'lib/utils/console' {
	export const isNoConsole: () => boolean;
	export const xtremConsole: Console;
	//# sourceMappingURL=console.d.ts.map
}
declare module 'lib/service/promise-tracker' {
	export abstract class PromiseTracker {
	    /** The number of tracked async operations which are currently executing */
	    private static pendingPromisesCount;
	    /** add the has-pending-promises element to the document */
	    private static ensurePendingElementExists;
	    private static deletePendingElementIfExists;
	    private static pushPending;
	    private static popPending;
	    /**
	     * This function is called when a dialog is open on the screen.
	     *
	     * Dialogs are tricky because they create a promise which is only resolved when the user closes the dialog.
	     * We have to decrement pendingPromisesCount so that it can get back to 0 while the dialog is open.
	     */
	    static pushDialog(): void;
	    /**
	     * This function is called when a dialog is closed.
	     *
	     * We increment pendingPromisesCount to counter-balance what we pushDialog did earlier.
	     */
	    static popDialog(): void;
	    /**
	     * This function tracks the execution of an async operations
	     *
	     * It adds a hidden #has-pending-promises div element to the DOM at the beginning of the operation and
	     * removes it when the operation completes.
	     *
	     * This div elements is used to wait on the completion of async operations (graphql API calls, refresh of components)
	     * in our library of cucumber steps (see the waitForPromises() function in xtrem-cli)
	     */
	    static withTracker<T>(body: () => Promise<T>): Promise<T>;
	}
	//# sourceMappingURL=promise-tracker.d.ts.map
}
declare module 'lib/utils/constants' {
	export const SERVER_VALIDATION_RULE_PREFIX = "server-";
	export const NEW_PAGE = "$new";
	export const VISUAL_PROCESS_FAKE_NODE_TYPE_PAGE = "@sage/xtrem-ui/VisualProcessPageNode";
	export const REG_EXP_URL_PATTERN: RegExp;
	export const REG_EXP_INTERNAL_URL_PATTERN: RegExp;
	export const DUPLICATE_INDICATOR_QUERY_EDITOR_PARAM = "__duplicate";
	export const DEEP_BIND_QUERY_ALIAS_GLUE = "__";
	/**
	 * This token is used to signal that the user is stepping over the last step of the wizard
	 */
	export const WIZARD_FINISHED = "WIZARD_FINISHED";
	export const PREVIEW_WIDGET_ID = "PREVIEW_WIDGET";
	export const PREVIEW_DASHBOARD_ID = "PREVIEW_DASHBOARD";
	export const QUERY_PARAM_CUSTOM_MAIN_LIST_FILTER = "_filter";
	export const QUERY_PARAM_TUNNEL_SEGMENTS = "_TUNNEL_SEGMENTS";
	export const QUERY_PARAM_PRINTING_SOURCE_PAGE = "_PRINTING_SOURCE_PAGE";
	export const QUERY_PARAM_PRINTING_RECORD_ID = "_PRINTING_RECORD_ID";
	export const QUERY_PARAM_SELECTED_SECTION_ID = "_SELECTED_SECTION_ID";
	export const SHOULD_REFRESH_DIALOG_RESULT = "_SHOULD_REFRESH";
	export const TUNNEL_LINK_CLASS = "e-tunnel-link";
	export const BULK_ACTION_ASYNC_EXPORT = "asyncExport";
	export const ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS = "e-action-popover-submenus-compat";
	export const TABLE_INLINE_ACTION_CSS_CLASS = "e-table-inline-action";
	export const SINGLE_INLINE_ACTION_CSS_CLASS = "e-popover-action-single-button";
	export const PLUGIN_CACHE = "xtrem-plugin-cache";
	export const ARTIFACT_DATABASE_NAME = "xtrem-ui";
	export const ARTIFACT_CACHE_STORE = "artifact-cache";
	export const ARTIFACT_CACHE_DEFAULT_PASSPHRASE = "NO_KEY";
	export const QUERY_ALIAS_NAV_PANEL = "navigationPanelItems";
	export const QUERY_ALIAS_PAGE_DATA = "rootNode";
	export const ATTACHMENTS_PROPERTY_NAME = "_attachments";
	export const ATTACHMENTS_ELEMENT_ID = "_attachmentsList";
	export const DASHBOARD_SCREEN_ID = "$dashboard";
	export const HEADER_IMAGE = "_headerImage";
	export const HEADER_TITLE = "_headerTitle";
	//# sourceMappingURL=constants.d.ts.map
}
declare module 'lib/component/container/container-properties' {
	export { PageProperties } from 'lib/component/container/page/page-types';
	export { BlockProperties, DetailPanelProperties, SectionProperties, StickerProperties, TileProperties, } from 'lib/component/container/container-control-objects';
	//# sourceMappingURL=container-properties.d.ts.map
}
declare module 'lib/service/page-extension' {
	import { Page } from 'lib/service/page';
	import type { ScreenBase } from 'lib/service/screen-base';
	/**
	 * This type is used for extended fields. It checks the type. If the generic argument (`This`) extends the PageExtension,
	 * it will return a merged type of the extension properties and the base class properties.
	 *
	 * If the generic argument (`This`) does not extend PageExtension, so it's not an extended page, it will leave the type
	 * as is without appending any other properties.
	 */
	export type Extend<This extends ScreenBase> = This extends PageExtension<infer Base, any> ? ExtensionMembers<This & Base> : This;
	export type ExtensionMembers<T> = Pick<T, Exclude<keyof T, '_dummy'>>;
	export abstract class PageExtension<Base extends Page, Api> extends Page<Base extends Page<infer U> ? U : any> {
	    constructor();
	    basePage: string;
	    protected _dummy: Base;
	}
	//# sourceMappingURL=page-extension.d.ts.map
}
declare module 'lib/component/abstract-container' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import { AbstractUiControlObject } from 'lib/component/abstract-ui-control-object';
	import type { ContainerValidation } from 'lib/component/field/traits';
	import type { ContainerKey, LayoutContent, ParentType } from 'lib/component/types';
	export interface ContainerProperties<CT extends ScreenBase = ScreenBase> extends UiComponentProperties<CT>, ContainerValidation<CT> {
	    /**
	     * Whether the HTML element is disabled or not. Defaults to false
	     *
	     * The difference with readOnly is that disabled suggests that the field is not editable
	     * for some validation reason (e.g. a button which can't be clicked due to validation errors)
	     */
	    isDisabled?: ValueOrCallbackWithFieldValue<CT, boolean>;
	}
	/**
	 * Any container* than can be placed inside a page and can be interacted with (i.e. retrieving
	 * and/or setting container's properties values).
	 *
	 * *A container is any element than can contain other elements and doesn't have a value itself
	 * (e.g. a page, a section, a block, etc.)
	 */
	export abstract class AbstractContainer<CT extends ScreenBase, T extends ContainerKey, S extends ContainerProperties<CT>> extends AbstractUiControlObject<CT, S> {
	    protected _componentKey: T;
	    private readonly _getValidationState;
	    layout: LayoutContent<T>;
	    parent?: ParentType<T> | undefined;
	    static readonly defaultUiProperties: Partial<ContainerProperties>;
	    constructor(screenId: string, elementId: string, _getUiComponentProperties: (screenId: string, elementId: string) => S, _setUiComponentProperties: (screenId: string, elementId: string, state: S) => void, _componentKey: T, _getValidationState: () => Promise<boolean>, layout: LayoutContent<T>, parent?: ParentType<T> | undefined);
	    /** Whether the container has some validation errors or not */
	    get isValid(): Promise<boolean>;
	    /**
	     * Triggers the validation rules of all the fields in the Fragment Page. Since the validation rules
	     * might be asynchronous, this method returns a promise that must be awaited to get
	     * the validation result
	     */
	    validate(): Promise<string[]>;
	    /**
	     * Triggers the field validation rules. Since the validation rules might be asynchronous,
	     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
	     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
	     */
	    abstract validateWithDetails(partition: true): Promise<{
	        allErrors: ValidationResult[];
	        blockingErrors: ValidationResult[];
	    }>;
	    abstract validateWithDetails(partition: false): Promise<ValidationResult[]>;
	    abstract validateWithDetails(): Promise<ValidationResult[]>;
	    abstract validateWithDetails(partition: false): Promise<{
	        allErrors: ValidationResult[];
	        blockingErrors: ValidationResult[];
	    } | ValidationResult[]>;
	}
	//# sourceMappingURL=abstract-container.d.ts.map
}
declare module 'lib/utils/common-util' {
	export function deepFreeze<T>(object: T): Readonly<T>;
	export function containsValueDeep(object: any, value: any, strict?: boolean): boolean;
	export function differenceBetweenObjects<T extends object>(object: T, base: T): Partial<T>;
	/** Deep search an object structure by a property name. It returns a unique set of results. */
	export const deepFindPropertyValues: <T = any>(propertyName: string, target: Object | Array<any>, callback?: (target: any) => boolean) => T[];
	//# sourceMappingURL=common-util.d.ts.map
}
declare module 'lib/service/metadata-types' {
	import type { AccessStatus, Dict, GraphQLTypes, MetaCustomField, NodeTypeKind } from '@sage/xtrem-shared';
	export interface MetadataStringLiteralTypeEntry {
	    key: string;
	    content: string;
	}
	export interface MetadataAccessPropertyBinding {
	    name: string;
	    status: AccessStatus;
	}
	export interface MetadataAccessRightsResult {
	    node: string;
	    bindings: MetadataAccessPropertyBinding[];
	}
	export interface MetadataCustomNode {
	    name: string;
	    properties: MetaCustomField[];
	}
	export interface CustomizableNode {
	    node: string;
	    fullName: string;
	}
	export interface ExportTemplateDetails {
	    id: string;
	    name: string;
	}
	export interface ExportTemplatesByNode {
	    name: string;
	    exportTemplates: ExportTemplateDetails[];
	}
	export interface Fragment {
	    name: string;
	    content: string;
	}
	export interface MetadataType {
	    key?: string;
	    content?: string;
	    title?: string;
	    extensions?: string[];
	    plugins?: string[];
	    duplicateBindings?: string[] | null;
	    strings?: MetadataStringLiteralTypeEntry[];
	    access?: MetadataAccessRightsResult[];
	    customFields?: MetadataCustomNode[];
	    customizableNodes?: CustomizableNode[];
	    customizableNodesWizard?: CustomizableNode[];
	    exportTemplatesByNode?: ExportTemplatesByNode[];
	    nodeDetails?: RawNodeDetails[];
	    fragments?: Fragment[];
	}
	export interface MetadataResponse {
	    pages?: MetadataType[];
	    stickers?: MetadataType[];
	    strings?: MetadataStringLiteralTypeEntry[];
	}
	export type ModuleEntryProperties = keyof MetadataType;
	export type ArtifactType = 'pages' | 'stickers' | 'widgets' | 'strings';
	export type DataTypePropertyType = 'string' | 'uuid' | 'enum' | 'date' | 'decimal' | 'double' | 'short' | 'integer' | 'boolean' | 'json' | 'textStream' | 'binaryStream';
	export interface DataTypeProperty {
	    bind: string;
	    title: string;
	    type: DataTypePropertyType;
	}
	export interface DataTypeDetails {
	    name: string;
	    type: string;
	    title: string;
	    node: string;
	    tunnelPage?: string;
	    tunnelPageId?: DataTypeProperty;
	    value: DataTypeProperty;
	    helperText: DataTypeProperty;
	    columns: DataTypeProperty[];
	    imageField?: DataTypeProperty;
	    precision?: number;
	    scale?: number;
	    maxLength?: number;
	    values?: {
	        value: string;
	        title: string;
	    }[];
	}
	export interface NodeDetailsProperty {
	    name?: string;
	    title?: string;
	    canSort?: boolean;
	    canFilter?: boolean;
	    type: string;
	    isCustom?: boolean;
	    isMutable?: boolean;
	    targetNode?: string;
	    dataType?: string;
	    isStored?: boolean;
	    isOnInputType?: boolean;
	    isOnOutputType?: boolean;
	    enumType?: string;
	    parentNode?: string;
	}
	export interface FormattedNodeDetailsProperty extends NodeDetailsProperty {
	    type: GraphQLTypes | string;
	    kind: NodeTypeKind;
	    enumValues?: string[];
	    isCollection?: boolean;
	}
	export interface FormattedMutationDetailsProperty {
	    name: string;
	    title: string;
	    parameters: NodeDetailsMutationParameter[];
	}
	export interface RawNodeDetailsProperty extends NodeDetailsProperty {
	    targetNodeDetails?: RawNodeDetails;
	    dataTypeDetails?: DataTypeDetails;
	}
	export interface RawNodeDetailsMutation {
	    name: string;
	    title: string;
	    parameters: NodeDetailsMutationParameter[];
	}
	export interface NodeDetailsMutationParameter {
	    name: string;
	    title: string;
	}
	export interface NodeDetails {
	    name: string;
	    title: string;
	    defaultDataType?: string;
	    hasAttachments?: boolean;
	    packageName: string;
	}
	export interface RawNodeDetails extends NodeDetails {
	    properties: RawNodeDetailsProperty[];
	    mutations: RawNodeDetailsMutation[];
	    defaultDataTypeDetails?: DataTypeDetails;
	}
	export interface FormattedNodeDetails extends NodeDetails {
	    properties: Dict<FormattedNodeDetailsProperty>;
	    mutations: Dict<FormattedMutationDetailsProperty>;
	}
	//# sourceMappingURL=metadata-types.d.ts.map
}
declare module 'lib/component/nested-fields' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import { GridNestedFieldTypes } from '@sage/xtrem-shared';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { NestedAggregateProperties, NestedCheckboxProperties, NestedCountProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLabelProperties, NestedLinkProperties, NestedMultiDropdownProperties, NestedMultiReferenceProperties, NestedNumericProperties, NestedProgressProperties, NestedReferenceProperties, NestedRelativeDateProperties, NestedSelectProperties, NestedSwitchProperties, NestedTechnicalProperties, NestedTextAreaProperties, NestedTextProperties } from 'lib/component/nested-fields-properties';
	import { FieldKey } from 'lib/component/types';
	export { GridNestedFieldTypes };
	export type NestedFieldTypes = FieldKey.Aggregate | FieldKey.Checkbox | FieldKey.Count | FieldKey.Date | FieldKey.DropdownList | FieldKey.FilterSelect | FieldKey.Icon | FieldKey.Image | FieldKey.Label | FieldKey.Link | FieldKey.MultiDropdown | FieldKey.MultiReference | FieldKey.Numeric | FieldKey.Progress | FieldKey.Reference | FieldKey.RelativeDate | FieldKey.Select | FieldKey.Switch | FieldKey.Technical | FieldKey.Text | FieldKey.TextArea;
	export type PodNestedFieldTypes = FieldKey.Aggregate | FieldKey.Checkbox | FieldKey.Count | FieldKey.Date | FieldKey.DropdownList | FieldKey.FilterSelect | FieldKey.Icon | FieldKey.Image | FieldKey.Label | FieldKey.Link | FieldKey.MultiDropdown | FieldKey.MultiReference | FieldKey.Numeric | FieldKey.Progress | FieldKey.Reference | FieldKey.RelativeDate | FieldKey.Select | FieldKey.Switch | FieldKey.Technical | FieldKey.Text | FieldKey.TextArea;
	export const allowedMainFieldTypes: GridNestedFieldTypes[];
	export type NestedFieldComponentProps<T extends NestedFieldTypes, CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any, R extends ClientNode = any> = T extends FieldKey.Aggregate ? NestedAggregateProperties<CT, NodeType> : T extends FieldKey.Checkbox ? NestedCheckboxProperties<CT, NodeType> : T extends FieldKey.Count ? NestedCountProperties<CT, NodeType> : T extends FieldKey.Date ? NestedDateProperties<CT, NodeType> : T extends FieldKey.FilterSelect ? NestedFilterSelectProperties<CT, NodeType, R> : T extends FieldKey.Icon ? NestedIconProperties<CT, NodeType> : T extends FieldKey.Image ? NestedImageProperties<CT, NodeType> : T extends FieldKey.Label ? NestedLabelProperties<CT, NodeType> : T extends FieldKey.Link ? NestedLinkProperties<CT, NodeType> : T extends FieldKey.Numeric ? NestedNumericProperties<CT, NodeType> : T extends FieldKey.MultiDropdown ? NestedMultiDropdownProperties<CT, NodeType> : T extends FieldKey.DropdownList ? NestedDropdownListProperties<CT, NodeType> : T extends FieldKey.MultiReference ? NestedMultiReferenceProperties<CT, NodeType, R> : T extends FieldKey.Progress ? NestedProgressProperties<CT, NodeType> : T extends FieldKey.Reference ? NestedReferenceProperties<CT, NodeType, R> : T extends FieldKey.RelativeDate ? NestedRelativeDateProperties<CT, NodeType> : T extends FieldKey.Select ? NestedSelectProperties<CT, NodeType> : T extends FieldKey.Switch ? NestedSwitchProperties<CT, NodeType> : T extends FieldKey.Text ? NestedTextProperties<CT, NodeType> : T extends FieldKey.TextArea ? NestedTextAreaProperties<CT, NodeType> : NestedTextProperties<CT, NodeType>;
	export type NestedFieldTypesWithoutTechnical = Exclude<NestedFieldTypes, FieldKey.Technical>;
	export function isInstanceOf<T>(argument: any, C: new (...args: any[]) => T): argument is T;
	export function isNestedTechnical<NodeType extends ClientNode = any>(argument: NestedField<ScreenBase, NestedFieldTypes, NodeType>): argument is NestedField<any, FieldKey.Technical, NodeType>;
	export function withoutNestedTechnical<NodeType extends ClientNode = any>(argument?: NestedField<ScreenBase, NestedFieldTypes, NodeType>[]): NestedField<ScreenBase, Exclude<NestedFieldTypes, FieldKey.Technical>, NodeType>[];
	export interface NestedField<CT extends ScreenExtension<CT>, T extends Partial<NestedFieldTypes>, NodeType extends ClientNode = any, R extends ClientNode = any> {
	    defaultUiProperties: NestedFieldsProperties<T, Extend<CT>, NodeType, R>;
	    properties: NestedFieldsProperties<T, Extend<CT>, NodeType, R>;
	    type: T;
	}
	export interface NestedFieldTypeMap<CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any> {
	    [FieldKey.Aggregate]: NestedAggregateProperties<CT, NodeType>;
	    [FieldKey.Checkbox]: NestedCheckboxProperties<CT, NodeType>;
	    [FieldKey.Count]: NestedCountProperties<CT, NodeType>;
	    [FieldKey.Date]: NestedDateProperties<CT, NodeType>;
	    [FieldKey.DropdownList]: NestedDropdownListProperties<CT, NodeType>;
	    [FieldKey.FilterSelect]: NestedFilterSelectProperties<CT, NodeType, R>;
	    [FieldKey.Icon]: NestedIconProperties<CT, NodeType>;
	    [FieldKey.Image]: NestedImageProperties<CT, NodeType>;
	    [FieldKey.Label]: NestedLabelProperties<CT, NodeType>;
	    [FieldKey.Link]: NestedLinkProperties<CT, NodeType>;
	    [FieldKey.MultiDropdown]: NestedMultiDropdownProperties<CT, NodeType>;
	    [FieldKey.MultiReference]: NestedMultiReferenceProperties<CT, NodeType, R>;
	    [FieldKey.Numeric]: NestedNumericProperties<CT, NodeType>;
	    [FieldKey.Progress]: NestedProgressProperties<CT, NodeType>;
	    [FieldKey.Reference]: NestedReferenceProperties<CT, NodeType, R>;
	    [FieldKey.RelativeDate]: NestedRelativeDateProperties<CT, NodeType>;
	    [FieldKey.Select]: NestedSelectProperties<CT, NodeType>;
	    [FieldKey.Switch]: NestedSwitchProperties<CT, NodeType>;
	    [FieldKey.Technical]: NestedTechnicalProperties<CT, NodeType, R>;
	    [FieldKey.Text]: NestedTextProperties<CT, NodeType>;
	    [FieldKey.TextArea]: NestedTextAreaProperties<CT, NodeType>;
	}
	export type NestedFieldsProperties<T extends NestedFieldTypes, CT extends ScreenBase = any, NodeType extends ClientNode = any, R extends ClientNode = any> = {
	    [K in keyof NestedFieldTypeMap<CT, NodeType, R>]: K extends T ? NestedFieldTypeMap<CT, NodeType, R>[K] : never;
	}[keyof {
	    [K in keyof NestedFieldTypeMap<CT, NodeType, R>]: K extends T ? NestedFieldTypeMap<CT, NodeType, R>[K] : never;
	}];
	export interface NestedFieldHandlersArguments {
	    onClick?: any[];
	    onChange?: any[];
	    rowValue?: any;
	}
	export const getNestedFieldDefaultProperties: <T extends NestedFieldTypes = FieldKey.Text, CT extends ScreenBase<any, any> = ScreenBase<any, any>, NodeType extends ClientNode = any, R extends ClientNode = any>(defaultProperties: any, controlObjectType?: T) => NestedFieldComponentProps<T, Extend<CT>, NodeType, R>;
	export const aggregate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedAggregateProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Aggregate, NodeType>;
	export const checkbox: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCheckboxProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Checkbox, NodeType>;
	export const count: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCountProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Count, NodeType>;
	export const date: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDateProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Date, NodeType>;
	export const dropdownList: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDropdownListProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.DropdownList, NodeType>;
	export const filterSelect: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedFilterSelectProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedField<CT, FieldKey.FilterSelect, NodeType, R>;
	export const icon: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedIconProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Icon, NodeType>;
	export const image: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedImageProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Image, NodeType>;
	export const label: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLabelProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Label, NodeType>;
	export const link: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLinkProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Link, NodeType>;
	export const numeric: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedNumericProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Numeric, NodeType>;
	export const progress: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedProgressProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Progress, NodeType>;
	export const reference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedReferenceProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedField<CT, FieldKey.Reference, NodeType, R>;
	export const relativeDate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedRelativeDateProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.RelativeDate, NodeType>;
	export const multiReference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiReferenceProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedField<CT, FieldKey.MultiReference, NodeType, R>;
	export const multiDropdown: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiDropdownProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.MultiDropdown, NodeType, R>;
	export const select: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSelectProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Select, NodeType>; const nestedSwitch: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSwitchProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Switch, NodeType>;
	export { nestedSwitch as switch };
	export const text: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.Text, NodeType>;
	export const textArea: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextAreaProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedField<CT, FieldKey.TextArea, NodeType>;
	export const technical: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, ReferenceNode extends ClientNode = any>(properties: Omit<NestedTechnicalProperties<Extend<CT>, NodeType, ReferenceNode>, '_controlObjectType'>) => NestedField<CT, FieldKey.Technical, NodeType, ReferenceNode>;
	//# sourceMappingURL=nested-fields.d.ts.map
}
declare module 'lib/component/field/field-base-component-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ContextType, NodePropertyType } from 'lib/types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { NestedFieldHandlersArguments } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	export interface FieldWrapperExternalProps {
	    item?: PageArticleItem;
	    screenId: string;
	    contextType?: ContextType;
	    nestedReadOnlyField?: boolean;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean;
	    availableColumns?: number;
	    isParentDisabled?: boolean;
	    /**
	     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
	     * down the hidden status and mark the hidden inputs not focusable
	     * */
	    isParentHidden?: boolean;
	    fixedHeight?: number;
	}
	export interface FieldComponentExternalProperties extends FieldWrapperExternalProps {
	    bind?: PropertyValueType<ClientNode | any>;
	    elementId: string;
	    isParentDisabled?: boolean;
	    /**
	     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
	     * down the hidden status and mark the hidden inputs not focusable
	     * */
	    isParentHidden?: boolean;
	    fixedHeight?: number;
	}
	export interface ReadonlyFieldComponentProperties<FieldUiProperties extends ReadonlyFieldProperties, FieldValue> {
	    browser?: ReduxResponsive;
	    fieldProperties: FieldUiProperties;
	    nodeTypes?: Dict<FormattedNodeDetails>;
	    pageNode?: NodePropertyType;
	    value?: FieldValue;
	    onFocus: (row?: string, nestedField?: string) => void;
	    isInFocus?: boolean;
	    locale: LocalizeLocale;
	    isParentReadOnly?: boolean;
	}
	export type BaseReadonlyComponentProperties<FieldUiProperties extends ReadonlyFieldProperties, FieldValue, AdditionalProperties = {}> = FieldComponentExternalProperties & ReadonlyFieldComponentProperties<FieldUiProperties, FieldValue> & AdditionalProperties;
	export interface EditableFieldComponentProperties<FieldUiProperties extends ReadonlyFieldProperties, FieldValue> extends ReadonlyFieldComponentProperties<FieldUiProperties, FieldValue> {
	    validationErrors?: ValidationResult[];
	    setFieldValue: (bind: string, value: FieldValue) => Promise<void>;
	    validate: (bind: string, value: FieldValue) => Promise<ValidationResult[] | undefined>;
	    removeNonNestedErrors: (bind: string) => void;
	    setFieldProperties?: (elementId: string, value: FieldUiProperties) => void;
	    isParentReadOnly?: boolean;
	}
	export type BaseEditableComponentProperties<FieldUiProperties extends ReadonlyFieldProperties, FieldValue, AdditionalProperties = {}> = FieldComponentExternalProperties & EditableFieldComponentProperties<FieldUiProperties, FieldValue> & AdditionalProperties;
	export interface ErrorableFieldComponentProperties<FieldUiProperties extends ReadonlyFieldProperties, FieldValue> extends EditableFieldComponentProperties<FieldUiProperties, FieldValue> {
	    addInternalError?: (elementId: string, errorMessage: ValidationResult) => void;
	    removeInternalError?: (elementId: string) => void;
	}
	export type BaseErrorableComponentProperties<FieldUiProperties extends EditableFieldProperties, FieldValue, AdditionalProperties = {}> = FieldComponentExternalProperties & ErrorableFieldComponentProperties<FieldUiProperties, FieldValue> & AdditionalProperties;
	export interface NestedFieldsAdditionalProperties {
	    columnDefinition?: any;
	    contextNode?: NodePropertyType;
	    handlersArguments?: NestedFieldHandlersArguments;
	    isNested?: boolean;
	    isParentReadOnly?: boolean;
	    level?: number;
	    parentElementId?: string;
	    recordContext?: any;
	}
	export type FieldBaseComponentProperties<FieldUiProperties extends EditableFieldProperties, FieldValue, AdditionalProperties> = BaseReadonlyComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties> & EditableFieldComponentProperties<FieldUiProperties, FieldValue> & NestedFieldsAdditionalProperties;
	//# sourceMappingURL=field-base-component-types.d.ts.map
}
declare module 'lib/component/field/aggregate/aggregate-types' {
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { HasFilter, HasPlaceholder, HasScale, Postfixable, Prefixable, Clickable, ExtensionField, HasHelperText, HasParent, Sizable, Nested, NestedClickable, HasIcon } from 'lib/component/field/traits';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { ClientCollection, ClientNode } from '@sage/xtrem-client';
	import type { AggregationMethod, FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { ScreenBase } from 'lib/service/screen-base';
	export type AggregateComponentProps = BaseReadonlyComponentProperties<AggregateProperties, number, NestedFieldsAdditionalProperties>;
	export type AggregateValuesSelector<T> = T extends ClientCollection<any> ? void : T extends object ? {
	    [K in keyof T]?: T[K] extends (infer U)[] ? AggregateValuesSelector<U> : AggregateValuesSelector<T[K]>;
	} : true;
	export interface AggregateProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends ReadonlyFieldProperties<CT>, Postfixable<CT>, Prefixable<CT>, Sizable, HasPlaceholder, HasIcon, HasScale<CT, ReferencedItemType>, HasFilter<CT, ReferencedItemType> {
	    /** The child collection that is the subject of the aggregation query */
	    aggregateOn: keyof ReferencedItemType | AggregateValuesSelector<ReferencedItemType>;
	    /** The calculation method of the aggregation */
	    aggregationMethod: AggregationMethod;
	}
	export interface AggregateDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<AggregateProperties<CT, ReferencedItemType>, '_controlObjectType'>, Clickable<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasHelperText, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable {
	}
	export interface NestedAggregateProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<AggregateProperties<CT, NodeType>, 'bind'>, NestedClickable<CT>, Nested<NodeType>, Sizable {
	}
	//# sourceMappingURL=aggregate-types.d.ts.map
}
declare module 'lib/component/field/checkbox/checkbox-types' {
	import type { BaseErrorableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedClickable, Sizable, Validatable } from 'lib/component/field/traits';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	export interface CheckboxProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType> {
	}
	export interface CheckboxDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<CheckboxProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT>, HasParent<CT, BlockControlObject<CT>> {
	    isReversed?: boolean;
	}
	export interface NestedCheckboxProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<CheckboxProperties<CT, ContextNodeType>, 'bind'>, Nested<ContextNodeType>, NestedChangeable<CT>, NestedClickable<CT>, Sizable {
	    isReversed?: boolean;
	}
	export type CheckboxComponentProps = BaseErrorableComponentProperties<CheckboxProperties, boolean, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=checkbox-types.d.ts.map
}
declare module 'lib/component/field/count/count-types' {
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Clickable, ExtensionField, HasParent, Nested, NestedClickable, Sizable, HasFilter, Postfixable, Prefixable, HasIcon } from 'lib/component/field/traits';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	export type CountComponentProps = BaseReadonlyComponentProperties<CountProperties, number, NestedFieldsAdditionalProperties>;
	export interface CountProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends ReadonlyFieldProperties<CT>, Postfixable<CT>, Prefixable<CT>, Sizable, HasIcon, HasFilter<CT, ReferencedItemType> {
	}
	export interface CountDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends CountProperties<CT, ReferencedItemType>, Clickable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>> {
	}
	export interface NestedCountProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<CountProperties<CT>, 'bind'>, NestedClickable<CT>, Nested<NodeType>, Sizable {
	}
	//# sourceMappingURL=count-types.d.ts.map
}
declare module 'lib/component/field/date/date-types' {
	import type { BaseErrorableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasInputValueChangeListener, HasParent, Nested, NestedChangeable, NestedClickable, NestedGroupAggregations, NestedValidatable, Sizable, Validatable } from 'lib/component/field/traits';
	import type { DatePropertyValue, ValueOrCallback, ValueOrCallbackWitRecordValue } from 'lib/utils/types';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	export interface DateProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, Sizable {
	    /** The maximum date value allowed for the date field */
	    maxDate?: ValueOrCallback<CT, DatePropertyValue>;
	    /** The minimum date value allowed for the date field */
	    minDate?: ValueOrCallback<CT, DatePropertyValue>;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	}
	export interface DateDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<DateProperties<CT>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, HasInputValueChangeListener<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT, string> {
	}
	export interface NestedDateProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<DateProperties<CT, NodeType>, 'bind'>, Nested<NodeType>, NestedChangeable<CT>, NestedClickable<CT>, NestedGroupAggregations<'min' | 'max' | 'distinctCount'>, Sizable, NestedValidatable<CT, string, NodeType> {
	    /** The maximum date value allowed for the date field */
	    maxDate?: ValueOrCallbackWitRecordValue<CT, DatePropertyValue, NodeType>;
	    /** The minimum date value allowed for the date field */
	    minDate?: ValueOrCallbackWitRecordValue<CT, DatePropertyValue, NodeType>;
	}
	export type DateComponentProps = BaseErrorableComponentProperties<DateProperties, string, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=date-types.d.ts.map
}
declare module 'lib/component/field/dropdown-list/dropdown-list-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties, ClickableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject, TileControlObject } from 'lib/component/container/container-control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { Changeable, Clickable, ExtensionField, HasEmptyValue, HasOptions, HasOptionType, HasParent, HasPlaceholder, HasSound, Mappable, Nested, NestedChangeable, NestedClickable, NestedValidatable, Sizable, Validatable } from 'lib/component/field/traits';
	export interface DropdownListProperties<CT extends ScreenExtension<CT> = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, HasEmptyValue, HasOptions<CT>, HasOptionType, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasPlaceholder, HasSound<CT>, Mappable<CT>, Sizable {
	}
	export interface NestedDropdownListProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<DropdownListProperties<CT, ContextNodeType>, 'bind'>, Nested<ContextNodeType>, NestedChangeable<CT>, NestedClickable<CT>, HasEmptyValue, NestedValidatable<CT, string, ContextNodeType> {
	}
	export interface DropdownListDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<DropdownListProperties<CT>, '_controlObjectType'>, ExtensionField<CT, FieldControlObjectInstance<any>>, Changeable<CT>, Clickable<CT>, Validatable<CT, string> {
	}
	export type DropdownListExtensionDecoratorProperties<T extends ScreenExtension<T>> = ChangeableOverrideDecoratorProperties<DropdownListDecoratorProperties<Extend<T>>, T> & ClickableOverrideDecoratorProperties<DropdownListDecoratorProperties<Extend<T>>, T>;
	export type DropdownListComponentProps = BaseEditableComponentProperties<DropdownListProperties, string> & NestedFieldsAdditionalProperties & {
	    localizedOptions?: Dict<string>;
	    enumOptions?: string[];
	};
	export interface DropdownListInternalProps {
	    enumOptions?: string[];
	    localizedOptions: Dict<string>;
	    screenId: string;
	    value?: string;
	}
	export interface DropdownListCellEditorProperties extends CellParams<NestedDropdownListProperties> {
	    enumOptions?: string[];
	    localizedOptions?: Dict<string>;
	}
	//# sourceMappingURL=dropdown-list-types.d.ts.map
}
declare module 'lib/redux/middleware/action-subscription-middleware' {
	import type { Middleware } from 'redux';
	import type { AppAction } from 'lib/redux/action-types';
	export type ActionSubscription = (action: AppAction) => void;
	export type Unsubscribe = () => void;
	export const getSubscriptions: () => ActionSubscription[];
	export const subscribeToActions: (subscription: ActionSubscription) => Unsubscribe;
	export const actionSubscriptionMiddleware: Middleware;
	//# sourceMappingURL=action-subscription-middleware.d.ts.map
}
declare module 'lib/redux/middleware/logging-middleware' {
	import type { Middleware } from 'redux';
	export const loggingMiddleware: Middleware;
	//# sourceMappingURL=logging-middleware.d.ts.map
}
declare module 'lib/service/wrapper-service' {
	export interface FieldLocator {
	    screenId: string;
	    elementId: string;
	    recordId?: string;
	    title?: string;
	    nestedElementId?: string;
	    level?: number;
	}
	/**
	 * This interface should be implemented by the native mobile application. It contains a set
	 * of event handlers which are required for the communication between the mobile and the native apps.
	 */
	export interface WrapperMobileAppInterface {
	    /** Called when the mobile app recognizes the presence of the mobile wrapper and it registered its global communication interface */
	    onLoad?: () => void;
	    /**
	     * Called when a scannable field gets focussed and the scanner button can be displayed.
	     * @param fieldLocator unique field identifier
	     */
	    onFocus?: (fieldLocator: FieldLocator) => void;
	    /**
	     * Called when a scannable field loses focus and and the scanner button should be hidden.
	     * @param fieldLocator unique field identifier
	     */
	    onBlur?: (fieldLocator?: FieldLocator) => void;
	    /**
	     * Called when the mobile app initiates scanning
	     */
	    captureData?: (fieldLocator: FieldLocator) => void;
	}
	/**
	 * This interface should be implemented by the web app. These events are called by the mobile app to notify the web app about certain events.
	 * */
	export interface WrapperWebAppInterface {
	    /** Notifies the web app that the scanner activity was successfully opened. */
	    startScanning: (fieldLocator: FieldLocator) => void;
	    /** Notifies the web app that the scanner successfully scanned some value and the scanner was closed. */
	    setRawData: (fieldLocator: FieldLocator, rawValue: string) => void;
	}
	/**
	 * Initiate scanning from the web application.
	 * This method is called by the web app to request the opening of the scanner activity.
	 * It also takes a callback which is invoked by the native app if the scanning is successful.
	 */
	export const captureData: (fieldLocator: FieldLocator, callback: (rawValue: string) => void) => void;
	/**
	 * Update the native app about the currently focussed field.
	 * This method is called by the web app to notify the native app that the focus moved to a new field which is ready for scanning.
	 * It also takes a callback which is invoked by the native app if the scanning is successful.
	 **/
	export const onFocus: (fieldLocator: FieldLocator, callback: (rawValue: string) => void) => void;
	/**
	 * Update the native app about the currently focussed field.
	 * This method is called by the web app to notify the native app that the focus was removed from a field and it should hide the
	 * scanner button.
	 */
	export const onBlur: (fieldLocator?: FieldLocator) => void;
	//# sourceMappingURL=wrapper-service.d.ts.map
}
declare module 'lib/service/i18n-service' {
	import * as XtremDateTime from '@sage/xtrem-date-time';
	import type { LocalizeEnumFunction, LocalizeFunction } from '@sage/xtrem-shared';
	import type { DatePropertyValue } from 'lib/utils/types';
	/**
	 * This function will be either injected by the 'decoratorTransformer' (which wraps a specific set of decorators
	 * properties) or can be used in any page or sticker for any string that has to be translated.
	 * The translations will be fetched by the 'screen-loader-service' through the metadata endpoint based on
	 * the browser's locale settings. Hence the 'localize' function simply relies on the state to fetch all translations.
	 *
	 * @export
	 * @param {string} key the translation key
	 * @param {string} value the translation default value
	 * @returns {string} the translated string
	 */
	export const localize: LocalizeFunction;
	export const localizeText: LocalizeFunction;
	export const localizeEnumMember: LocalizeEnumFunction;
	export const formatDateToCurrentLocale: (date: DatePropertyValue, fmt?: XtremDateTime.DatePresetFormat) => string;
	export const formatNumberToCurrentLocale: (value: number | string, scale?: number) => string;
	//# sourceMappingURL=i18n-service.d.ts.map
}
declare module 'lib/component/ui/nested-field-errors-component' {
	import React from 'react';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	export interface NestedFieldErrorsExternalProps {
	    screenId: string;
	    elementId: string;
	}
	export interface NestedFieldErrorsProps extends NestedFieldErrorsExternalProps {
	    validationErrors: ValidationResult[];
	    value: any;
	    fieldType: string;
	    fieldTitle?: ValueOrCallbackWithFieldValue<any, string>;
	}
	export interface TableValidationError {
	    fieldName: string;
	    mainFieldName?: string;
	    mainFieldValue: string;
	    columnId?: string;
	    columnName?: string;
	    message: string;
	    recordId: string;
	    validationRule: string;
	    level?: number;
	}
	interface NestedFieldErrorsState {
	    isDialogOpen: boolean;
	} class NestedFieldErrors extends React.Component<NestedFieldErrorsProps, NestedFieldErrorsState> {
	    getTitle: () => string;
	    onRemainingErrorsClick: () => Promise<void>;
	    onClick: () => Promise<void>;
	    getErrorList: (limit?: number) => React.ReactNode;
	    render(): React.ReactNode;
	}
	export const ConnectedNestedFieldErrors: import("react-redux").ConnectedComponent<typeof NestedFieldErrors, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<NestedFieldErrors> | undefined;
	    screenId: string;
	    elementId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=nested-field-errors-component.d.ts.map
}
declare module 'lib/component/container/page/container-validation-errors' {
	import React from 'react';
	import type { PageMetadata } from 'lib/service/page-metadata';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	interface ContainerValidationErrorsComponentProps {
	    screenId: string;
	    validationResults: ValidationResult[];
	    pageMetadata: PageMetadata;
	    children?: React.ReactNode;
	}
	export function ContainerValidationErrorsComponent({ validationResults, pageMetadata, screenId, children, }: ContainerValidationErrorsComponentProps): React.ReactElement;
	export {};
	//# sourceMappingURL=container-validation-errors.d.ts.map
}
declare module 'lib/redux/actions/toast-actions' {
	import type { Toast } from 'lib/service/toast-service';
	import type { AppAction } from 'lib/redux/action-types';
	export const showToast: (toast: Toast) => AppAction;
	export const removeToast: (toastId: number) => AppAction;
	export const removeToasts: () => AppAction;
	//# sourceMappingURL=toast-actions.d.ts.map
}
declare module 'lib/service/toast-service' {
	import type { ToastProps } from 'carbon-react/esm/components/toast';
	import type { ContainerValidationResult } from 'lib/service/dispatch-service';
	import type { PageMetadata } from 'lib/service/page-metadata';
	import * as React from 'react';
	export type ToastType = ToastProps['variant'];
	export interface ToastOptions {
	    language?: 'markdown' | 'jsx';
	    timeout?: number;
	    type?: ToastType;
	}
	export interface Toast {
	    content: string | React.ReactNode;
	    isDismissed: boolean;
	    id: number;
	    language?: ToastOptions['language'];
	    timeout: number;
	    type: ToastType;
	}
	export const PERMANENT_TOAST: number;
	export const showToast: (content: Toast['content'], options?: ToastOptions) => void;
	export const showContainerValidationToast: (pageMetadata: PageMetadata, result: ContainerValidationResult) => void;
	export const removeToasts: () => void;
	//# sourceMappingURL=toast-service.d.ts.map
}
declare module 'lib/service/telemetry-service' {
	import * as xtremRedux from 'lib/redux';
	export const notifyConsumerOnError: (error: Error, state?: xtremRedux.XtremAppState) => void;
	//# sourceMappingURL=telemetry-service.d.ts.map
}
declare module 'lib/service/sound-api' {
	export class SoundApi {
	    private readonly isFieldSoundEnabled;
	    constructor(isFieldSoundDisabled?: boolean);
	    success(): Promise<void>;
	    error(): Promise<void>;
	}
	//# sourceMappingURL=sound-api.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-timer' {
	export interface Timer {
	    abort: () => void;
	    isRunning: () => boolean;
	    start: (callback: () => void, delay: number) => void;
	}
	export const useTimer: () => Timer;
	//# sourceMappingURL=use-timer.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-first-mount-state' {
	export function useFirstMountState(): boolean;
	//# sourceMappingURL=use-first-mount-state.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-update-effect' {
	import { type DependencyList, useEffect } from 'react';
	import { type EffectCallback } from '@sage/xtrem-ui-components'; const useUpdateEffect: typeof useEffect; function useDeepCompareUpdateEffect<Callback extends EffectCallback = EffectCallback, Deps extends DependencyList = DependencyList>(effect: Callback, deps: Deps): void;
	export { useUpdateEffect, useDeepCompareUpdateEffect };
	//# sourceMappingURL=use-update-effect.d.ts.map
}
declare module 'lib/component/field/image/image-utils' {
	export function getImageUrlFromValue(value?: string | null): string | undefined;
	//# sourceMappingURL=image-utils.d.ts.map
}
declare module 'lib/component/ui/portrait-component' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import * as React from 'react';
	export type PortraitShape = 'square' | 'circle';
	export type PortraitSize = 'XS' | 'S' | 'M' | 'ML' | 'L' | 'XL' | 'XXL';
	export type PortraitPlaceholderMode = 'Initials' | 'FirstThree';
	export interface PortraitProps {
	    shape?: PortraitShape;
	    size: PortraitSize;
	    placeholderValue?: string;
	    placeholderMode?: PortraitPlaceholderMode;
	    image?: {
	        value: string;
	    };
	    icon?: IconType;
	}
	export const getFirstThree: (value?: string) => string | undefined;
	export const getInitials: (value?: string) => string | undefined;
	export function Portrait({ icon, image, shape, size, placeholderValue, placeholderMode, }: PortraitProps): React.ReactElement;
	//# sourceMappingURL=portrait-component.d.ts.map
}
declare module 'lib/component/field/image/image-types' {
	import type { PortraitShape } from 'lib/component/ui/portrait-component';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasImagePlaceholder, HasNestedImagePlaceholder, HasParent, Mappable, Nested, NestedChangeable, NestedClickable, Sizable } from 'lib/component/field/traits';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	export interface ImageDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<ImageProperties<CT>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, Mappable<CT>, HasParent<CT, BlockControlObject<CT>>, HasImagePlaceholder<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable {
	}
	export interface NestedImageProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<ImageProperties<CT>, 'bind'>, Nested<NodeType>, NestedChangeable<CT>, NestedClickable<CT>, HasNestedImagePlaceholder<CT, NodeType>, Mappable<CT>, Sizable {
	}
	export interface ImageProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    /** The value of the height attribute of the HTML image (e.g. 100px, 75%, auto, etc.)*/
	    height?: string;
	    shape?: PortraitShape;
	}
	export interface ImageValue {
	    value: string;
	}
	export interface ImageComponentState {
	    isZooming: boolean;
	}
	export type ImageComponentProps = BaseEditableComponentProperties<ImageDecoratorProperties, ImageValue, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=image-types.d.ts.map
}
declare module 'lib/utils/keyboard-event-utils' {
	import type { KeyboardEvent } from 'react';
	export const KEY_BACKSPACE = 8;
	export const KEY_SPACE_BAR = 32;
	export const KEY_DELETE = 46;
	export const KEY_F2 = 113;
	export const KEY_ENTER = 13;
	export const KEY_TAB = 9;
	export const KEY_ESC = 27;
	export const SHIFT_TAB = "Shift+Tab";
	export const TAB = "Tab";
	export const ENTER = "Enter";
	export const ESCAPE = "Escape";
	export const BACKSPACE = "Backspace";
	export const DELETE = "Delete";
	export const F2 = "F2";
	export const SPACEBAR = " ";
	export function getCharCodeFromEvent(event: KeyboardEvent): number;
	export const isModifierKeyPressed: (event: KeyboardEvent) => boolean;
	export const isUnmodifiedAlphabeticalChar: (event: KeyboardEvent) => boolean;
	export function isEnter(event: KeyboardEvent): boolean;
	export function isTab(event: KeyboardEvent): boolean;
	export function isEsc(event: KeyboardEvent): boolean;
	export function isDeleteOrBackspace(event: KeyboardEvent): boolean;
	export function isBackspace(event: KeyboardEvent): boolean;
	export function isSpaceBar(event: KeyboardEvent): boolean;
	export function isForwardTab(event: KeyboardEvent): boolean;
	export function isBackwardTab(event: KeyboardEvent): boolean;
	//# sourceMappingURL=keyboard-event-utils.d.ts.map
}
declare module 'lib/component/ui/select/select-dropdown-item' {
	import React from 'react';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	interface SelectDropDownItemProps {
	    addSelectedItem: (item: SelectItem) => void;
	    fullWidth?: boolean;
	    hasHighlightMatchText: boolean;
	    isMultiSelect?: boolean;
	    isSelected: boolean;
	    item: SelectItem;
	    itemProps?: object;
	    searchText?: string;
	    removeSelectedItem: (item: SelectItem) => void;
	    style?: React.CSSProperties;
	    variant?: 'plain' | 'carbon';
	}
	export function SelectDropDownItem({ addSelectedItem, fullWidth, isMultiSelect, isSelected, hasHighlightMatchText, item, itemProps, searchText, removeSelectedItem, style, variant, }: SelectDropDownItemProps): React.ReactElement;
	export {};
	//# sourceMappingURL=select-dropdown-item.d.ts.map
}
declare module 'lib/component/ui/select/styles' {
	export const ulDivStyles: ({ hasHelperTextField }: {
	    hasHelperTextField?: boolean;
	}) => React.CSSProperties;
	export const ulStyles: ({ shouldRenderOptionsAbove, hasLookupLinkLine, maxHeight, hasCreateNewItemLink, }: {
	    shouldRenderOptionsAbove?: boolean;
	    hasLookupLinkLine?: boolean;
	    maxHeight?: number;
	    hasCreateNewItemLink?: boolean;
	}) => React.CSSProperties;
	export const liStyles: ({ isActive, isSelected }?: {
	    isActive?: boolean | undefined;
	    isSelected?: boolean | undefined;
	}) => React.CSSProperties;
	//# sourceMappingURL=styles.d.ts.map
}
declare module 'lib/utils/access-utils' {
	import type { AccessStatus, Dict } from '@sage/xtrem-shared';
	import type { CollectionActionAccessConfiguration, HasAccessRights } from 'lib/component/field/traits';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { NodePropertyType } from 'lib/types';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface AccessStatusProps {
	    accessBindings: AccessBindings;
	    bind: any;
	    elementProperties: ReadonlyFieldProperties | HasAccessRights;
	    contextNode?: NodePropertyType;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    dataTypes: Dict<DataTypeDetails>;
	}
	export const getElementAccessStatus: ({ accessBindings, bind, elementProperties, contextNode, nodeTypes, }: AccessStatusProps) => AccessStatus | undefined;
	export const getElementAccessStatusWithoutId: (accessBindings: AccessBindings, access?: CollectionActionAccessConfiguration) => AccessStatus;
	//# sourceMappingURL=access-utils.d.ts.map
}
declare module 'lib/component/ui/select/select-create-new-item' {
	import React from 'react';
	import type { NodePropertyType } from 'lib/types';
	export interface SelectCreateNewItemProps {
	    node?: NodePropertyType;
	    createTunnelLinkText?: string;
	    onLinkKeyDown?: (e: React.KeyboardEvent<HTMLButtonElement>) => void;
	    onCreateNewItemLinkClick?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
	    screenId?: string;
	    position?: {
	        top?: string;
	        bottom?: string;
	    };
	}
	export const SelectCreateNewItem: React.ForwardRefExoticComponent<SelectCreateNewItemProps & React.RefAttributes<HTMLButtonElement | HTMLLinkElement>>;
	//# sourceMappingURL=select-create-new-item.d.ts.map
}
declare module 'lib/component/ui/select/select-dropdown' {
	import type { UseComboboxGetItemPropsOptions } from 'downshift';
	import React from 'react';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	interface SelectDropDownProps {
	    addSelectedItem: (item: SelectItem) => void;
	    node?: any;
	    createTunnelLinkText?: string;
	    focusLookupButton: () => void;
	    fullWidth?: boolean;
	    getItemProps?: (options: UseComboboxGetItemPropsOptions<SelectItem>) => any;
	    hasHelperTextField?: boolean;
	    hasHighlightMatchText: boolean;
	    hasLookupIcon?: boolean;
	    highlightedIndex?: number;
	    highlightFirstListItem: () => void;
	    highlightLastListItem: () => void;
	    inputValue: string;
	    isItemSelected: (args: {
	        id: string;
	        value: string;
	    }) => boolean;
	    isLinkCreateNewText?: boolean;
	    isMultiSelect?: boolean;
	    isOpen: boolean;
	    items: SelectItem[];
	    loading: boolean;
	    lookupLinkRef?: React.RefObject<HTMLLinkElement>;
	    createTunnelLinkRef?: React.RefObject<HTMLLinkElement>;
	    maxHeight?: number;
	    menuProps?: any;
	    minLookupCharacters?: number;
	    onCreateNewItemLinkClick?: () => void;
	    onLookupIconClick?: (event: React.MouseEvent<any>) => void;
	    removeSelectedItem: (item: SelectItem) => void;
	    screenId?: string;
	    shouldRenderOptionsAbove?: boolean;
	    ulRef?: React.RefObject<HTMLUListElement>;
	    variant?: 'plain' | 'carbon';
	    inputId?: string;
	}
	export function SelectDropDown({ addSelectedItem, node, createTunnelLinkText, focusLookupButton, fullWidth, getItemProps, hasHelperTextField, hasHighlightMatchText, hasLookupIcon, highlightedIndex, highlightFirstListItem, highlightLastListItem, inputValue, isItemSelected, isLinkCreateNewText, isMultiSelect, isOpen, items, loading, lookupLinkRef, createTunnelLinkRef, maxHeight, menuProps, minLookupCharacters, onCreateNewItemLinkClick, onLookupIconClick, removeSelectedItem, screenId, shouldRenderOptionsAbove, ulRef: externalUlRef, variant, inputId, }: SelectDropDownProps): React.ReactElement;
	export {};
	//# sourceMappingURL=select-dropdown.d.ts.map
}
declare module 'lib/component/ui/tooltip/tooltip-types' {
	/// <reference types="react" />
	export type TooltipPosition = 'left' | 'right' | 'top' | 'bottom';
	export interface TooltipProps {
	    message?: string | React.ReactNode;
	    position?: TooltipPosition;
	    children: JSX.Element | JSX.Element[];
	}
	//# sourceMappingURL=tooltip-types.d.ts.map
}
declare module 'lib/component/ui/icon/icon-component' {
	import React from 'react';
	import type { TooltipPosition } from 'lib/component/ui/tooltip/tooltip-types';
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { FontSize } from 'carbon-react/esm/components/icon/icon.style';
	interface CarbonIconProps {
	    /** Add classes to this component */
	    className?: string;
	    /** Icon type */
	    type: IconType;
	    /** Background size */
	    bgSize?: 'small' | 'medium' | 'large';
	    /** Background shape */
	    bgShape?: 'circle' | 'rounded-rect' | 'square';
	    /** Background color theme */
	    bg?: string;
	    /** Icon font size */
	    fontSize?: FontSize;
	    /** Icon color */
	    color?: string;
	    /** Sets the icon in the disabled state */
	    disabled?: boolean;
	    /** The message string to be displayed in the tooltip */
	    tooltipMessage?: string | React.ReactNode;
	    /** The position to display the tooltip */
	    tooltipPosition?: TooltipPosition;
	    /** The tooltip background color */
	    tooltipBgColor?: string;
	    /** The tooltip font color */
	    tooltipFontColor?: string;
	    ariaLabel?: string;
	    mx?: number;
	    my?: number;
	    m?: number;
	    mt?: number;
	    mr?: number;
	    mb?: number;
	    ml?: number;
	}
	export interface IconProps extends CarbonIconProps {
	    onClick?: (event: React.MouseEvent<HTMLDivElement, MouseEvent>) => void;
	    style?: React.CSSProperties;
	}
	export const Icon: React.ForwardRefExoticComponent<IconProps & React.RefAttributes<HTMLDivElement>>;
	export {};
	//# sourceMappingURL=icon-component.d.ts.map
}
declare module 'lib/component/ui/select/clear-button' {
	import React from 'react';
	interface ClearButtonProps {
	    hidden: boolean;
	    classNameSelectClose: string;
	    closeIconClassName?: string;
	    onClearFieldButtonClick: () => void;
	}
	export const ClearButton: React.FC<ClearButtonProps>;
	export {};
	//# sourceMappingURL=clear-button.d.ts.map
}
declare module 'lib/component/field/select/select-utils' {
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import type { HasOptionDetailsType, HasOptionType, HasOptions, Mappable } from 'lib/component/field/traits';
	import type { Dict } from '@sage/xtrem-shared';
	export const SELECT_EMPTY_VALUE = "_emptyValue";
	interface SelectLikeComponentProperties {
	    enumOptions?: string[];
	    localizedOptions?: Dict<string>;
	    screenId: string;
	    value?: any;
	    fieldProperties: Mappable<any> & HasOptionType & HasOptions<any> & HasOptionDetailsType<any> & {
	        hasEmptyValue?: boolean;
	    };
	    recordContext?: any;
	}
	export const createSelectItemFromOption: (option?: string, props?: SelectLikeComponentProperties, displayedAs?: string) => SelectItem;
	export const getItemsFromProps: (props: SelectLikeComponentProperties, currentSearchText?: string, rowValue?: any) => SelectItem[];
	export const getValidOptionValuesForSelect: (options?: string[], optionType?: string) => string[];
	export const isMatchingSearch: (currentSearchText: string, value?: string) => boolean;
	export {};
	//# sourceMappingURL=select-utils.d.ts.map
}
declare module 'lib/component/ui/select/select-input' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { DownshiftProps, UseMultipleSelectionGetSelectedItemPropsOptions } from 'downshift';
	import React from 'react';
	import type { InputProps, SelectItem } from 'lib/component/ui/select/select-component';
	import type { SizeOptions } from 'carbon-react/esm/components/button/button.component';
	interface SelectInputProps extends DownshiftProps<SelectItem> {
	    borderColor?: string;
	    closeIconClassName?: string;
	    closeMenu: () => void;
	    disabled?: boolean;
	    disablePills?: boolean;
	    displayNew?: boolean;
	    error?: string;
	    getSelectedItemProps?: (args: UseMultipleSelectionGetSelectedItemPropsOptions<SelectItem>) => any;
	    handleBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
	    handleSelectedItemRemove?: (selectedItem: SelectItem) => void;
	    hasInputSearch?: boolean;
	    hasLookupIcon?: boolean;
	    helperText?: string;
	    helperTextLink?: string;
	    icon?: IconType;
	    image?: SelectItem['image'];
	    info?: string;
	    inputId?: string;
	    inputProps: InputProps;
	    isLinkHelperText?: boolean;
	    isMultiSelect?: boolean;
	    label?: string;
	    loading?: boolean;
	    lookupButtonRef?: React.RefObject<HTMLButtonElement>;
	    lookupIconId?: string;
	    onClearFieldButtonClick?: () => void;
	    onHelperTextLinkClick?: () => void;
	    onLookupIconClick?: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement, MouseEvent>) => void;
	    selectedRecords?: SelectItem[];
	    size?: SizeOptions;
	    testId?: string;
	    toggleButtonProps: any;
	    variant?: 'plain' | 'carbon';
	    warning?: string;
	    width?: string;
	    wrapperProps: any;
	}
	export const SelectInput: React.ForwardRefExoticComponent<SelectInputProps & React.RefAttributes<HTMLInputElement>>;
	export {};
	//# sourceMappingURL=select-input.d.ts.map
}
declare module 'lib/component/ui/select/select-component' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { UseComboboxStateChangeTypes } from 'downshift';
	import React from 'react';
	import type { ImageValue } from 'lib/component/field/image/image-types';
	import type { CollectionItem } from 'lib/component/types';
	import type { SizeOptions } from 'carbon-react/esm/components/button/button.component';
	export interface SelectItem {
	    _id?: string;
	    id: string;
	    value: string;
	    image?: ImageValue;
	    helperText?: string;
	    displayedAs?: string;
	    __collectionItem?: CollectionItem;
	    pendoId?: string;
	}
	export type InputProps = React.ComponentProps<'input'>;
	export interface SelectProps {
	    allowClearOnTab?: boolean;
	    allowSelectOnTab?: boolean;
	    autoSelect?: boolean;
	    borderColor?: string;
	    node?: any;
	    defaultIsOpen?: boolean;
	    disabled?: boolean;
	    disablePills?: boolean;
	    disableOpenOnFocus?: boolean;
	    elementId?: string;
	    error?: string;
	    info?: string;
	    shouldRenderOptionsAbove?: boolean;
	    warning?: string;
	    escapeBehavior?: 'native' | 'revert';
	    hasInputSearch?: boolean;
	    hasHighlightMatchText?: boolean;
	    fullWidth?: boolean;
	    getItems: (searchText: string) => Promise<SelectItem[]>;
	    getNewItem?: (searchText: string) => SelectItem;
	    hasLookupIcon?: boolean;
	    hasClearFieldButton?: boolean;
	    helperText?: string;
	    helperTextLink?: string;
	    icon?: IconType;
	    initialInputValue?: string;
	    initialSelectedItems?: SelectItem[];
	    inputId?: string;
	    inputWidth?: string;
	    isSortedAlphabetically?: boolean;
	    isDropdownDisabled?: boolean;
	    isLinkCreateNewText?: boolean;
	    isLinkHelperText?: boolean;
	    isMultiSelect?: boolean;
	    isSoundDisabled?: boolean;
	    isHelperTextHidden?: boolean;
	    label?: string;
	    lookupButtonRef?: React.RefObject<HTMLButtonElement>;
	    lookupIconId?: string;
	    closeIconClassName?: string;
	    minLookupCharacters?: number;
	    /** This property indicates that the select ui component is used that does not support helper text in the items array */
	    noHelperTextInItem?: boolean;
	    onAutoSelect?: (value: CollectionItem | undefined) => void;
	    onBlur?: () => void;
	    onChange?: (value: CollectionItem | undefined, isOrganicChange: boolean) => void;
	    onSelected?: (value: SelectItem | null | undefined, selectionType: UseComboboxStateChangeTypes) => void;
	    onHelperTextLinkClick?: () => void;
	    onHighlightedChange?: (value?: SelectItem | null) => void;
	    onInputChange?: (value: string, type?: UseComboboxStateChangeTypes) => void;
	    onInputFocus?: () => void;
	    onKeyDown?: (e: React.KeyboardEvent<HTMLInputElement>) => void;
	    onLookupIconClick?: (event: React.MouseEvent<any>) => void;
	    onSelectedItemsChange?: (selectedRecords: CollectionItem[]) => void;
	    placeholder?: string;
	    preventSelectionOnBlur?: boolean;
	    readOnly?: boolean;
	    refetchIfChanged?: any;
	    screenId?: string;
	    selectedItem?: SelectItem;
	    selectedItems?: SelectItem[];
	    shouldFilterItems?: boolean;
	    size?: SizeOptions;
	    testId?: string;
	    variant?: 'plain' | 'carbon';
	    isInTable?: boolean;
	    createTunnelLinkText?: string;
	    onCreateNewItemLinkClick?: () => void;
	}
	export const Select: React.ForwardRefExoticComponent<SelectProps & React.RefAttributes<HTMLInputElement>>;
	//# sourceMappingURL=select-component.d.ts.map
}
declare module 'lib/component/field/reference/reference-utils' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ContextType } from 'lib/types';
	import type { CollectionItem, OrderByType } from 'lib/component/types';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import type { ReferenceDecoratorProperties, ReferenceProperties } from 'lib/component/field/reference/reference-types';
	type FieldProps<T extends ClientNode = any> = Pick<ReferenceDecoratorProperties<any, T>, 'helperText' | 'columns' | 'isHelperTextHidden' | 'valueField' | 'imageField' | 'helperTextField' | 'tunnelPageIdField' | 'tunnelPage'>;
	export function getReferenceImage<T extends ClientNode = any>({ value, fieldProperties: { imageField }, }: {
	    value?: T;
	    fieldProperties: FieldProps<T>;
	}): SelectItem['image'];
	export function getReferenceSearchText<T extends ClientNode = any>({ value, fieldProperties: { valueField }, }: {
	    value?: T;
	    fieldProperties: FieldProps<T>;
	}): string;
	export function getReferenceHelperText<T extends ClientNode = any>({ value, fieldProperties: { helperTextField, helperText }, }: {
	    value?: T;
	    fieldProperties: FieldProps<T>;
	}): string | undefined;
	export function getReferenceTunnelLinkId<T extends ClientNode = any>({ fieldProperties, value, }: {
	    fieldProperties: FieldProps<T>;
	    value?: T;
	}): string | undefined;
	export function isReferenceDisabled<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, }: {
	    screenId: string;
	    fieldProperties: FieldProps<T>;
	    value?: T;
	    rowValue?: any;
	}): boolean;
	export function isReferenceReadOnly<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, contextType, }: {
	    screenId: string;
	    fieldProperties: FieldProps<T>;
	    value?: T;
	    rowValue?: any;
	    contextType?: ContextType;
	}): boolean;
	export function hasHelperTextField<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, contextType, }: {
	    screenId: string;
	    fieldProperties: FieldProps<T>;
	    value?: T;
	    rowValue?: any;
	    contextType?: ContextType;
	}): boolean;
	export function hasLookupIcon<T extends ClientNode = any>({ screenId, fieldProperties, value, rowValue, contextType, }: {
	    screenId: string;
	    fieldProperties: FieldProps<T>;
	    value?: T | T[];
	    rowValue: any;
	    contextType?: ContextType;
	}): boolean;
	export function getReferenceSelectedRecord<T extends ClientNode = any>({ value, fieldProperties, }: {
	    value?: T;
	    fieldProperties: FieldProps<T>;
	}): SelectItem | undefined;
	export function nodeToSelectItem<T extends ClientNode = any>({ collectionItem, fieldProperties: { valueField, helperTextField, imageField }, }: {
	    fieldProperties: FieldProps<T>;
	    collectionItem: CollectionItem;
	}): SelectItem;
	export function nodesToSelectItems<T extends ClientNode = any>({ nodes, fieldProperties, }: {
	    nodes?: CollectionItem[];
	    fieldProperties: FieldProps<T>;
	}): SelectItem[];
	export const getReferenceValueField: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<any, T>) => string;
	export const getReferenceValueFieldPath: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<any, T>) => string;
	export const getReferenceOrderBy: <T extends ClientNode = any>(fieldProperties: ReferenceProperties<any, T>) => OrderByType<T>;
	export function getReferencePath<T extends ClientNode = any>(value: ReferenceProperties<any, T>['valueField']): string;
	export function getReferencePath<T extends ClientNode = any>(value: ReferenceProperties<any, T>['helperTextField']): string;
	export const isStringReferenceValueField: (valueField: ReferenceProperties<any, any>['valueField']) => boolean;
	export {};
	//# sourceMappingURL=reference-utils.d.ts.map
}
declare module 'lib/component/property-decorators/control-object-property-decorator' {
	import type { BaseControlObject } from 'lib/component/base-control-object';
	export const ControlObjectProperty: <PropertiesType extends Object, ConstructorType extends BaseControlObject<any, PropertiesType>>() => (controlObjectConstructor: ConstructorType, name: keyof PropertiesType) => void;
	//# sourceMappingURL=control-object-property-decorator.d.ts.map
}
declare module 'lib/component/field/aggregate/aggregate-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link AggregateControlObject} that holds a single-line aggregate value
	 */
	export class AggregateControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Aggregate, FieldComponentProps<FieldKey.Aggregate>> {
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /**
	     * Number of digits after the numeric field value decimal point.
	     * Must be in the range 0 - 20, inclusive.
	     */
	    scale?: number;
	    /** Aggregate to be displayed inline after the field value */
	    prefix?: string;
	    /** Aggregate to be displayed inline before the field value */
	    postfix?: string;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=aggregate-control-object.d.ts.map
}
declare module 'lib/component/field/button/button-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
	 */
	export class ButtonControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Button, FieldComponentProps<FieldKey.Button>> {
	    /** The border color of the button */
	    get borderColor(): string | undefined;
	    /** The border color of the button */
	    set borderColor(newValue: string | undefined);
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=button-control-object.d.ts.map
}
declare module 'lib/component/field/select/select-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { NestedFilterSelectProperties } from 'lib/component/decorators';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, ExtensionField, HasEmptyValue, HasIcon, HasInputValueChangeListener, HasOptionDetailsType, HasOptions, HasParent, HasPlaceholder, HasSound, Mappable, Nested, NestedChangeable, NestedValidatable, Postfixable, Prefixable, Sizable, Validatable } from 'lib/component/field/traits';
	export interface SelectProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, HasIcon, HasPlaceholder, HasOptions<CT>, HasSound<CT>, Postfixable<CT>, Prefixable<CT>, Sizable {
	}
	export interface SelectEditorProps extends CellParams<NestedSelectProperties> {
	    enumOptions?: string[];
	    localizedOptions?: Dict<string>;
	}
	export interface SelectInternalProps {
	    enumOptions?: string[];
	    localizedOptions?: Dict<string>;
	    screenId: string;
	    value?: string;
	}
	export interface FilterSelectCellEditorProps extends CellParams<NestedFilterSelectProperties> {
	    localizedNew: string;
	}
	export interface SelectDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<SelectProperties<CT, void>, '_controlObjectType'>, Changeable<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasInputValueChangeListener<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT>, Mappable<CT>, HasOptionDetailsType<CT>, HasSound<CT>, Sizable {
	}
	export interface NestedSelectProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<SelectProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, Nested<ContextNodeType>, Sizable, HasEmptyValue, HasOptionDetailsType<CT>, NestedValidatable<CT, string, ContextNodeType> {
	}
	export type SelectExtensionDecoratorProperties<T extends ScreenExtension<T>> = ChangeableOverrideDecoratorProperties<SelectDecoratorProperties<Extend<T>>, T>;
	export type SelectAdditionalProperties = NestedFieldsAdditionalProperties & SelectInternalProps;
	export type SelectComponentProps = BaseEditableComponentProperties<SelectDecoratorProperties, string, SelectAdditionalProperties>;
	//# sourceMappingURL=select-types.d.ts.map
}
declare module 'lib/component/ui/decimal/decimal-component' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { DecimalProps, CustomEvent } from 'carbon-react/esm/components/decimal';
	import React from 'react';
	import type { CarbonStyleOverrides } from 'lib/component/types';
	interface Props {
	    allowEmptyValue?: boolean;
	    disabled: boolean;
	    fieldHelp?: string;
	    inputIcon?: IconType;
	    onChange: (event: CustomEvent) => void;
	    onKeyDown?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
	    precision?: DecimalProps['precision'];
	    styleOverride?: CarbonStyleOverrides;
	    validations?: any;
	    value?: string;
	}
	interface InternalProps extends Props {
	    locale: string;
	}
	export interface DecimalValueObject {
	    rawValue: string;
	    formattedValue: string;
	}
	export const UnconnectedDecimal: React.FC<InternalProps>;
	export const Decimal: import("react-redux").ConnectedComponent<React.FC<InternalProps>, {
	    allowEmptyValue?: boolean | undefined;
	    disabled: boolean;
	    fieldHelp?: string | undefined;
	    inputIcon?: IconType | undefined;
	    onChange: (event: CustomEvent) => void;
	    onKeyDown?: ((event: React.KeyboardEvent<HTMLInputElement>) => void) | undefined;
	    precision?: DecimalProps['precision'];
	    styleOverride?: CarbonStyleOverrides | undefined;
	    validations?: any;
	    value?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=decimal-component.d.ts.map
}
declare module 'lib/component/ui/filter/filter-manager' {
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { Filter } from 'lib/service/filter-service';
	import type { StringFilter, RangeFilter, MultipleRangeFilter, EnumFilter } from 'lib/component/types';
	import { GraphQLTypes } from 'lib/types';
	import type { ReferenceProperties } from 'lib/component/field/reference/reference-types';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { FiltrableType } from '@sage/xtrem-shared';
	export interface FilterManagerField {
	    type: NestedFieldTypes;
	    properties: {
	        bind?: string;
	        canFilter?: boolean;
	        title?: string;
	        type: GraphQLTypes | null;
	        valueField?: ReferenceProperties['valueField'];
	        helperTextField?: ReferenceProperties['helperTextField'];
	    };
	}
	export interface FilterManagerExternalProps {
	    screenId: string;
	    nestedFields: FilterManagerField[];
	    handleCancel: () => void;
	    handleSave: (filters: Filter<FiltrableType>[]) => void;
	    initialFilters?: Filter[];
	}
	export interface FilterManagerProps extends FilterManagerExternalProps {
	    browser?: ReduxResponsive;
	}
	type FilterDisplayNameType = StringFilter | RangeFilter | MultipleRangeFilter | EnumFilter;
	export const getFilterDisplayName: (fieldId: string, nestedFields: FilterManagerField[], text: FilterDisplayNameType, filterValue: string, title?: string) => string;
	export {};
	//# sourceMappingURL=filter-manager.d.ts.map
}
declare module 'lib/service/filter-service' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict, FilterType, FiltrableType } from '@sage/xtrem-shared';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { FilterManagerField } from 'lib/component/ui/filter/filter-manager';
	import type { NodePropertyType } from 'lib/types';
	import type { GraphQLFilter, QueryArguments } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface Filter<T extends FiltrableType = string> {
	    id: string;
	    value: Array<{
	        filterValue: FilterValue<T>;
	        /** Indicates that the filter should be applied against the ID field, it is used with nested objects (e.g reference columns) */
	        filterById?: boolean;
	        filterType: {
	            value: FilterType<T>;
	            text: string;
	        };
	    }>;
	}
	export type FilterValue<T extends FiltrableType = string> = T extends string ? T | T[] : T;
	export const getGraphQLFilter: <T extends FiltrableType>(filters: Filter<T>[], nestedFields: FilterManagerField[]) => GraphQLFilter;
	export const getGraphQLFilterAsString: (queryFilter: GraphQLFilter) => QueryArguments['filter'];
	export const getFilterAsGraphQLFilterString: (filters: Filter[], nestedFields: FilterManagerField[]) => QueryArguments['filter'];
	export const mergeGraphQLFilters: <T extends ClientNode = any>(graphQLFilters: (GraphQLFilter<T> | undefined)[]) => any;
	export const getTypedNestedFields: (screenId: string, node: NodePropertyType, nestedFields: NestedField<ScreenBase, NestedFieldTypes>[], knownNodeTypes: Dict<FormattedNodeDetails>) => FilterManagerField[];
	//# sourceMappingURL=filter-service.d.ts.map
}
declare module 'lib/utils/formatters' {
	import { DateValue } from '@sage/xtrem-date-time';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { DatePropertyValue, DateTimePropertyValue, ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	export const getIsoDate: (date: DatePropertyValue | undefined | null) => string | undefined;
	export const isInvalidJsDate: (jsDate: Date) => boolean;
	export const dateToString: (date: Date, dateFieldFormat?: string) => string;
	export const isDateOrDateTime: (value: DatePropertyValue | DateTimePropertyValue) => 'date' | 'datetime' | null;
	export const getFirstDayOfMonth: (date: DateValue) => DateValue;
	export const getLastDayOfMonth: (date: DateValue) => DateValue;
	export interface FormatNumericValueArgs {
	    screenId: string;
	    value: any;
	    ignoreLocale?: boolean;
	    scale?: ValueOrCallbackWithFieldValue<ScreenBase, number, number>;
	    rowValue?: any;
	    locale?: string;
	}
	export const formatNumericValue: ({ screenId, value, ignoreLocale, scale, rowValue, locale, }: FormatNumericValueArgs) => string;
	export const parseLocalizedNumberStringToNumber: (value: string | null | undefined | number, separator: string) => number | null;
	interface NumberComponents {
	    integer: string;
	    decimal: string;
	    separator: string;
	    sign: '+' | '-';
	}
	export const getNumberComponentsFromLocalizedNumberString: (value: string | null | undefined | number, separator: string) => NumberComponents;
	export function humanFileSize(size: number): string;
	export {};
	//# sourceMappingURL=formatters.d.ts.map
}
declare module 'lib/component/field/carbon-utility-components' {
	import type * as CarbonUtilityComponents from 'react';
	import React from 'react';
	export function FieldLabel({ label, children, htmlFor, className, errorMessage, infoMessage, warningMessage, id, }: React.PropsWithChildren<{
	    id?: string;
	    label?: string;
	    htmlFor?: string;
	    className?: string;
	    errorMessage?: string;
	    infoMessage?: string;
	    warningMessage?: string;
	}>): React.ReactElement;
	export function HelperText({ helperText }: {
	    helperText?: string;
	}): React.ReactElement;
	export const getFieldElement: (className: string, element?: JSX.Element | string) => CarbonUtilityComponents.ReactNode;
	//# sourceMappingURL=carbon-utility-components.d.ts.map
}
declare module 'lib/utils/dom' {
	import type { ResponsiveProperties } from 'lib/component/abstract-ui-control-object';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldKey, FieldValue } from 'lib/component/types';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { ContextType } from 'lib/types';
	export function scrollWithAnimationTo(element: HTMLElement, container: HTMLElement, offset?: number): void;
	export function isHidden(hiddenProperties?: Partial<PageArticleItem> | ResponsiveProperties, browser?: ReduxResponsive): boolean;
	export const getDataTestIdAttribute: (fieldType: string, label?: string, elementId?: string | object, prefix?: string) => string;
	export const getComponentClass: (props: Partial<BaseEditableComponentProperties<ReadonlyFieldProperties, FieldValue<FieldKey>>>, specificClassNames: string, rowValue?: any) => string;
	export const getFieldClass: (screenId: string, fieldValue: any, classNames: string, fieldProperties: EditableFieldProperties, hasValidationErrors?: boolean, isFieldHidden?: boolean, rowValue?: {}, contextType?: ContextType) => string;
	export const copyToClipboard: (content: string) => void;
	export function focusTopPage(): void;
	export const focusPageContent: () => void;
	/** For mocking purposes */
	export const getNewFileReader: () => FileReader;
	export const getTabControlElement: () => HTMLElement | null;
	export const isScrolledToTheEnd: (element: HTMLElement) => boolean;
	export const isChildOfElementWithClass: (element: Element | Document, className: string) => boolean;
	export const isChildOfElementWithAttributeValue: (element: Element | Document, attributeName: string, attributeValue: string) => boolean;
	export const findAncestorDatasetProperty: (element: HTMLElement, datasetPropertyName: string) => string | null;
	//# sourceMappingURL=dom.d.ts.map
}
declare module 'lib/component/errorable-field-control-object' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldKey } from 'lib/component/types';
	export interface ErrorableFieldProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	}
	export abstract class ErrorableFieldControlObject<CT extends ScreenBase, T extends FieldKey, S extends ErrorableFieldProperties<CT>> extends EditableFieldControlObject<CT, T, S> {
	    static readonly defaultUiProperties: Partial<ErrorableFieldProperties>;
	}
	//# sourceMappingURL=errorable-field-control-object.d.ts.map
}
declare module 'lib/component/field/field-base-component' {
	import * as React from 'react';
	import * as xtremRedux from 'lib/redux';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import { ContextType } from 'lib/types';
	import type { ValueOrCallbackKeysExtractor, ValueOrCallbackReturnExtractor } from 'lib/utils/types';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { ErrorableFieldProperties } from 'lib/component/errorable-field-control-object';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { BaseEditableComponentProperties, BaseErrorableComponentProperties, BaseReadonlyComponentProperties, EditableFieldComponentProperties, FieldBaseComponentProperties, FieldComponentExternalProperties, NestedFieldsAdditionalProperties, ReadonlyFieldComponentProperties } from 'lib/component/field/field-base-component-types';
	interface BaseAttributesDivWrapper {
	    'data-testid': string;
	    className: string;
	}
	export class FieldBaseComponent<CoreProps extends BaseReadonlyComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties> & NestedFieldsAdditionalProperties, FieldUiProperties extends ReadonlyFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends React.Component<CoreProps & NestedFieldsAdditionalProperties, ComponentState> {
	    protected componentRef: React.RefObject<HTMLDivElement>;
	    shouldComponentUpdate(nextProps: CoreProps, nextState: any): boolean;
	    componentDidUpdate(prevProps: CoreProps): void;
	    /**
	     * @deprecated Use handleChange from abstract-fields-utils instead of this.
	     */
	    handleChange(elementId: string, value: any, // TODO Type this properly
	    setFieldValue: (bind: string, value: any) => Promise<void>, validate?: (bind: string, value: any) => Promise<ValidationResult[] | undefined>, onChange?: () => void): void;
	    protected getResolvedProperty<K extends ValueOrCallbackKeysExtractor<FieldUiProperties>>(key: K, skipHexFormat?: boolean): ValueOrCallbackReturnExtractor<FieldUiProperties, K>;
	    /**
	     * 'data-label' is used for alignment purposes only
	     *
	     * @private
	     * @memberof FieldBaseComponent
	     */
	    private readonly getDataLabel;
	    private readonly getComponentClass;
	    getBaseAttributesDivWrapper: (componentName: string, specificClassNames: string, contextType?: ContextType, rowValue?: any, isNested?: boolean) => BaseAttributesDivWrapper;
	    getFocusableElement(fieldContainer: HTMLElement): HTMLElement | null;
	    getValue: () => FieldValue | undefined;
	    getClickHandler: () => () => void;
	    getTitle(): string;
	    triggerChangeListener: (newValue?: any) => void;
	    isDisabled(): boolean;
	}
	export class ReadonlyFieldBaseComponent<FieldUiProperties extends ReadonlyFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends FieldBaseComponent<BaseReadonlyComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, FieldUiProperties, FieldValue, AdditionalProperties, ComponentState> {
	    shouldComponentUpdate(nextProps: FieldBaseComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, nextState: any): boolean;
	}
	export class EditableFieldBaseComponent<FieldUiProperties extends EditableFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends FieldBaseComponent<BaseEditableComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, FieldUiProperties, FieldValue, AdditionalProperties, ComponentState> {
	    shouldComponentUpdate(nextProps: FieldBaseComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, nextState: any): boolean;
	    isReadOnly(): boolean;
	}
	export class ErrorableFieldBaseComponent<FieldUiProperties extends ErrorableFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends FieldBaseComponent<BaseErrorableComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, FieldUiProperties, FieldValue, AdditionalProperties, ComponentState> {
	    shouldComponentUpdate(nextProps: FieldBaseComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, nextState: any): boolean;
	    isReadOnly(): boolean;
	}
	export const mapReadonlyStateToProps: () => (state: xtremRedux.XtremAppState, props: FieldComponentExternalProperties) => ReadonlyFieldComponentProperties<UiComponentProperties, any>;
	export const mapStateToProps: () => (state: xtremRedux.XtremAppState, props: FieldComponentExternalProperties) => EditableFieldComponentProperties<UiComponentProperties, any>;
	export const mapDispatchToProps: <Properties extends UiComponentProperties<ScreenBase<any, any>> = UiComponentProperties<ScreenBase<any, any>>>(callback?: (dispatch: xtremRedux.AppThunkDispatch, props: FieldComponentExternalProperties) => Partial<EditableFieldComponentProperties<Properties, any>>) => (dispatch: xtremRedux.AppThunkDispatch, props: FieldComponentExternalProperties) => Partial<EditableFieldComponentProperties<Properties, any>>;
	export {};
	//# sourceMappingURL=field-base-component.d.ts.map
}
declare module 'lib/component/field/carbon-wrapper' {
	import * as React from 'react';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ContextType } from 'lib/types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { NestedFieldHandlersArguments } from 'lib/component/nested-fields';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { Postfixable, Prefixable } from 'lib/component/field/traits';
	export interface CarbonWrapperProps {
	    children: React.ReactNode;
	    className: string;
	    componentName: string;
	    componentRef?: React.RefObject<any>;
	    contextType?: ContextType;
	    handlersArguments?: NestedFieldHandlersArguments;
	    helperText?: string;
	    isReadOnly?: ((value: any, rowValue?: any) => boolean) | boolean;
	    map?: (value?: any) => string;
	    nestedReadOnlyField?: boolean;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean;
	    noReadOnlySupport?: boolean;
	    isNested?: boolean;
	    readOnlyDisplayValue?: string;
	    readOnlyTooltip?: string;
	    isTitleHidden?: boolean;
	}
	export class CarbonWrapper extends ReadonlyFieldBaseComponent<EditableFieldProperties & Prefixable<ScreenBase> & Postfixable<ScreenBase>, any, CarbonWrapperProps> {
	    getMappedValue: () => string;
	    getDisplayValue(): string;
	    onClick: () => Promise<void>;
	    getReadonlyValueNode: (rowValue: any) => React.ReactElement;
	    render(): React.ReactNode;
	}
	//# sourceMappingURL=carbon-wrapper.d.ts.map
}
declare module 'lib/component/field/aggregate/aggregate-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { AggregateDecoratorProperties } from 'lib/component/field/aggregate/aggregate-types';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	export interface AggregateComponentState {
	    value: string;
	}
	export class AggregateComponent extends ReadonlyFieldBaseComponent<AggregateDecoratorProperties, number, NestedFieldsAdditionalProperties> {
	    render(): React.ReactNode;
	}
	export const ConnectedAggregateComponent: import("react-redux").ConnectedComponent<typeof AggregateComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<AggregateComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedAggregateComponent;
	//# sourceMappingURL=aggregate-component.d.ts.map
}
declare module 'lib/component/field/aggregate/async-aggregate-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { AggregateComponentProps } from 'lib/component/field/aggregate/aggregate-types';
	export function AsyncConnectedAggregateComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncAggregateComponent(props: AggregateComponentProps): React.ReactElement;
	//# sourceMappingURL=async-aggregate-component.d.ts.map
}
declare module 'lib/component/ui/input-field-skeleton' {
	import * as React from 'react';
	export interface InputFieldSkeletonProps {
	    hasTitle?: boolean;
	    bodyHeight?: string;
	}
	export const InputFieldSkeleton: React.FC<InputFieldSkeletonProps>;
	//# sourceMappingURL=input-field-skeleton.d.ts.map
}
declare module 'lib/utils/async-component-utils' {
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	export const hasConnectedSkeletonFieldTitle: (props: FieldComponentExternalProperties) => boolean;
	//# sourceMappingURL=async-component-utils.d.ts.map
}
declare module 'lib/component/field/checkbox/checkbox-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { CheckboxDecoratorProperties } from 'lib/component/field/checkbox/checkbox-types';
	export class CheckboxComponent extends EditableFieldBaseComponent<CheckboxDecoratorProperties, boolean, NestedFieldsAdditionalProperties> {
	    onChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
	    render(): React.ReactNode;
	}
	export const ConnectedCheckboxComponent: import("react-redux").ConnectedComponent<typeof CheckboxComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<CheckboxComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedCheckboxComponent;
	//# sourceMappingURL=checkbox-component.d.ts.map
}
declare module 'lib/component/field/checkbox/async-checkbox-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { CheckboxComponentProps } from 'lib/component/field/checkbox/checkbox-types';
	export function AsyncConnectedCheckboxComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncCheckboxComponent(props: CheckboxComponentProps): React.ReactElement;
	//# sourceMappingURL=async-checkbox-component.d.ts.map
}
declare module 'lib/component/field/count/count-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { CountDecoratorProperties } from 'lib/component/field/count/count-types';
	export class CountComponent extends ReadonlyFieldBaseComponent<CountDecoratorProperties, number, NestedFieldsAdditionalProperties> {
	    render(): React.ReactNode;
	}
	export const ConnectedCountComponent: import("react-redux").ConnectedComponent<typeof CountComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<CountComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedCountComponent;
	//# sourceMappingURL=count-component.d.ts.map
}
declare module 'lib/component/field/count/async-count-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { CountComponentProps } from 'lib/component/field/count/count-types';
	export function AsyncConnectedCountComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncCountComponent(props: CountComponentProps): React.ReactElement;
	//# sourceMappingURL=async-count-component.d.ts.map
}
declare module 'lib/utils/carbon-locale' {
	/// <reference types="lodash" />
	import type { I18nProviderProps } from 'carbon-react/esm/components/i18n-provider';
	export const isSingular: (count: number | string) => boolean;
	export const carbonLocale: ((selectedLocale: string) => I18nProviderProps['locale']) & import("lodash").MemoizedFunction;
	//# sourceMappingURL=carbon-locale.d.ts.map
}
declare module 'lib/component/field/date/date-component' {
	import * as React from 'react';
	import type { DateProperties } from 'lib/component/control-objects';
	import { ErrorableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { DateComponentProps } from 'lib/component/field/date/date-types';
	export interface DateComponentState {
	    internalError?: string;
	    formattedValue?: string;
	    rawValue?: string;
	}
	export class DateComponent extends ErrorableFieldBaseComponent<DateProperties, string, NestedFieldsAdditionalProperties, DateComponentState> {
	    private readonly dateInputRef;
	    constructor(props: DateComponentProps);
	    private readonly onInputValueChanged;
	    private readonly dispatchChange;
	    UNSAFE_componentWillReceiveProps(nextProps: DateComponentProps): void;
	    private readonly onBlur;
	    private readonly onChange;
	    private readonly onKeyDown;
	    private readonly getFormattedDate;
	    private readonly validate;
	    render(): React.ReactNode;
	}
	export const ConnectedDateComponent: import("react-redux").ConnectedComponent<typeof DateComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DateComponent> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDateComponent;
	//# sourceMappingURL=date-component.d.ts.map
}
declare module 'lib/component/field/date/async-date-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { DateComponentProps } from 'lib/component/field/date/date-types';
	export function AsyncConnectedDateComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncDateComponent(props: DateComponentProps): React.ReactElement;
	//# sourceMappingURL=async-date-component.d.ts.map
}
declare module 'lib/component/abstract-layout-builder' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { ResponsiveProperties } from 'lib/component/abstract-ui-control-object';
	import type { ComponentKey, ContainerWidth, DecoratorTarget, FieldWidth, LayoutContent, MetadataProps } from 'lib/component/types';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface DefaultFieldLayoutProps extends ResponsiveProperties {
	    elementId: string;
	    containerType: string;
	    width?: FieldWidth;
	    isFullWidth: boolean;
	}
	export abstract class AbstractLayoutBuilder<T extends ComponentKey> {
	    target: DecoratorTarget<T>;
	    elementId: string;
	    readonly nodeTypes: Dict<FormattedNodeDetails>;
	    readonly dataTypes: Dict<DataTypeDetails>;
	    readonly metadata: MetadataProps<T>;
	    layout: LayoutContent<T>;
	    constructor(target: DecoratorTarget<T>, elementId: string, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, metadata: MetadataProps<T>);
	    readonly build: () => this;
	    protected abstract buildLayout: () => this;
	    protected buildContainerLayout(elementId: string, category: string, isHiddenMobile?: boolean, isHiddenDesktop?: boolean, width?: ContainerWidth): Partial<PageArticleItem>;
	    protected buildFieldLayout({ elementId, containerType, isHiddenDesktop, isHiddenMobile, width, isFullWidth, }: Partial<DefaultFieldLayoutProps>): PageArticleItem;
	}
	//# sourceMappingURL=abstract-layout-builder.d.ts.map
}
declare module 'lib/component/abstract-field-layout-builder' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { FieldKey } from 'lib/component/types';
	export class AbstractFieldLayoutBuilder<T extends FieldKey> extends AbstractLayoutBuilder<T> {
	    protected buildLayout: () => this;
	}
	//# sourceMappingURL=abstract-field-layout-builder.d.ts.map
}
declare module 'lib/component/nested-fields-extensions' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types/index';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedAggregateProperties, NestedCheckboxProperties, NestedCountProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLabelProperties, NestedLinkProperties, NestedMultiDropdownProperties, NestedMultiReferenceProperties, NestedNumericProperties, NestedProgressProperties, NestedReferenceProperties, NestedSelectProperties, NestedSwitchProperties, NestedTextAreaProperties, NestedTextProperties } from 'lib/component/nested-fields-properties';
	import { FieldKey } from 'lib/component/types';
	export interface NestedExtensionInsertBeforeProperties {
	    insertBefore?: string;
	    insertAfter?: string;
	}
	export interface NestedAggregateExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedAggregateProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedCheckboxExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedCheckboxProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedCountExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedCountProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedDateExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedDateProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedDropdownListExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedDropdownListProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedFilterSelectExtensionProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends NestedFilterSelectProperties<CT, C, R>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedIconExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedIconProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedImageExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedImageProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedLabelExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedLabelProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedLinkExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedLinkProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedNumericExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedNumericProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedMultiDropdownExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedMultiDropdownProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedMultiReferenceExtensionProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends NestedMultiReferenceProperties<CT, C, R>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedProgressExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedProgressProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedReferenceExtensionProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends NestedReferenceProperties<CT, C, R>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedSelectExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedSelectProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedSwitchExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedSwitchProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedTextExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedTextProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedTextAreaExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedTextAreaProperties<CT, C>, NestedExtensionInsertBeforeProperties {
	}
	export interface NestedFieldsExtensionPropertiesMap<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> {
	    [FieldKey.Aggregate]: NestedAggregateExtensionProperties<CT, C>;
	    [FieldKey.Checkbox]: NestedCheckboxExtensionProperties<CT, C>;
	    [FieldKey.Count]: NestedCountExtensionProperties<CT, C>;
	    [FieldKey.Date]: NestedDateExtensionProperties<CT, C>;
	    [FieldKey.DropdownList]: NestedDropdownListExtensionProperties<CT, C>;
	    [FieldKey.FilterSelect]: NestedFilterSelectExtensionProperties<CT, C, R>;
	    [FieldKey.Icon]: NestedIconExtensionProperties<CT, C>;
	    [FieldKey.Image]: NestedImageExtensionProperties<CT, C>;
	    [FieldKey.Label]: NestedLabelExtensionProperties<CT, C>;
	    [FieldKey.Link]: NestedLinkExtensionProperties<CT, C>;
	    [FieldKey.Numeric]: NestedNumericExtensionProperties<CT, C>;
	    [FieldKey.MultiDropdown]: NestedMultiDropdownExtensionProperties<CT, C>;
	    [FieldKey.MultiReference]: NestedMultiReferenceExtensionProperties<CT, C, R>;
	    [FieldKey.Numeric]: NestedNumericExtensionProperties<CT, C>;
	    [FieldKey.Progress]: NestedProgressExtensionProperties<CT, C>;
	    [FieldKey.Reference]: NestedReferenceExtensionProperties<CT, C, R>;
	    [FieldKey.Select]: NestedSelectExtensionProperties<CT, C>;
	    [FieldKey.Switch]: NestedSwitchExtensionProperties<CT, C>;
	    [FieldKey.Text]: NestedTextExtensionProperties<CT, C>;
	    [FieldKey.TextArea]: NestedTextAreaExtensionProperties<CT, C>;
	}
	export type NestedFieldsExtensionProperties<T extends NestedFieldTypes, CT extends ScreenBase = any, C extends ClientNode = any, R extends ClientNode = any> = {
	    [K in keyof NestedFieldsExtensionPropertiesMap<CT, C, R>]: K extends T ? NestedFieldsExtensionPropertiesMap<CT, C, R>[K] : never;
	}[keyof {
	    [K in keyof NestedFieldsExtensionPropertiesMap<CT, C, R>]: K extends T ? NestedFieldsExtensionPropertiesMap<CT, C, R>[K] : never;
	}];
	export interface NestedExtensionField<CT extends ScreenExtension<CT>, T extends NestedFieldTypes, C extends ClientNode = any, R extends ClientNode = any> {
	    defaultUiProperties: NestedFieldsExtensionProperties<T, Extend<CT>, C, R>;
	    properties: NestedFieldsExtensionProperties<T, Extend<CT>, C, R>;
	    type: T;
	}
	export const aggregate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedAggregateExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Aggregate, NodeType>;
	export const checkbox: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCheckboxExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Checkbox, NodeType>;
	export const count: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCountExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Count, NodeType>;
	export const date: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDateExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Date, NodeType>;
	export const dropdownList: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDropdownListExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.DropdownList, NodeType>;
	export const filterSelect: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedFilterSelectExtensionProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.FilterSelect, NodeType, R>;
	export const icon: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedIconExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Icon, NodeType>;
	export const image: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedImageExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Image, NodeType>;
	export const label: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLabelExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Label, NodeType>;
	export const link: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLinkProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Link, NodeType>;
	export const numeric: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedNumericExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Numeric, NodeType>;
	export const multiDropdown: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedMultiDropdownExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.MultiDropdown, NodeType>;
	export const multiReference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiReferenceExtensionProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.MultiReference, NodeType, R>;
	export const progress: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedProgressExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Progress, NodeType>;
	export const reference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedReferenceExtensionProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Reference, NodeType, R>;
	export const select: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSelectExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Select, NodeType>; const nestedSwitch: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSwitchExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Switch, NodeType>;
	export { nestedSwitch as switch };
	export const text: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextExtensionProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedExtensionField<CT, FieldKey.Text, NodeType>;
	//# sourceMappingURL=nested-fields-extensions.d.ts.map
}
declare module 'lib/component/nested-fields-overrides' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types/index';
	import type { ChangeableNestedOverrideDecoratorProperties, ClickableNestedOverrideDecoratorProperties, OverrideNestedDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedAggregateProperties, NestedCheckboxProperties, NestedCountProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLabelProperties, NestedLinkProperties, NestedMultiDropdownProperties, NestedMultiReferenceProperties, NestedNumericProperties, NestedProgressProperties, NestedReferenceProperties, NestedSelectProperties, NestedSwitchProperties, NestedTextAreaProperties, NestedTextProperties } from 'lib/component/nested-fields-properties';
	import { FieldKey } from 'lib/component/types';
	export interface NestedOverrideInsertBeforeProperties {
	    insertBefore?: string;
	    insertAfter?: string;
	}
	export interface NestedAggregateOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedAggregateProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedAggregateProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedCheckboxOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedCheckboxProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedCheckboxProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedCountOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedCountProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedCountProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedDateOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedDateProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedDateProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedDropdownListOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedDropdownListProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedDropdownListProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedFilterSelectOverrideProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedFilterSelectProperties<CT, C, R>>, ChangeableNestedOverrideDecoratorProperties<NestedFilterSelectProperties<CT, C, R>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedIconOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedIconProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedIconProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedImageOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedImageProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedImageProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedLabelOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedLabelProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedLabelProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedLinkOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedLinkProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedLinkProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedNumericOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedNumericProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedNumericProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedMultiDropdownOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedMultiDropdownProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedMultiDropdownProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedMultiReferenceOverrideProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedMultiReferenceProperties<CT, C, R>>, ChangeableNestedOverrideDecoratorProperties<NestedMultiReferenceProperties<CT, C, R>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedProgressOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedProgressProperties<CT, C>>, ClickableNestedOverrideDecoratorProperties<NestedProgressProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedReferenceOverrideProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedReferenceProperties<CT, C, R>>, ChangeableNestedOverrideDecoratorProperties<NestedReferenceProperties<CT, C, R>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedSelectOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedSelectProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedSelectProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedSwitchOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedSwitchProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedSwitchProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedTextOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedTextProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedTextProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export interface NestedTextAreaOverrideProperties<CT extends ScreenBase, C extends ClientNode = any> extends OverrideNestedDecoratorProperties<NestedTextAreaProperties<CT, C>>, ChangeableNestedOverrideDecoratorProperties<NestedTextAreaProperties<CT, C>, CT, C>, NestedOverrideInsertBeforeProperties {
	}
	export type NestedFieldsOverrideProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> = NestedAggregateOverrideProperties<CT, C> | NestedCheckboxOverrideProperties<CT, C> | NestedCountOverrideProperties<CT, C> | NestedDateOverrideProperties<CT, C> | NestedDropdownListOverrideProperties<CT, C> | NestedFilterSelectOverrideProperties<CT, C, R> | NestedIconOverrideProperties<CT, C> | NestedImageOverrideProperties<CT, C> | NestedLabelOverrideProperties<CT, C> | NestedLinkOverrideProperties<CT, C> | NestedNumericOverrideProperties<CT, C> | NestedMultiDropdownOverrideProperties<CT, C> | NestedMultiReferenceOverrideProperties<CT, C, R> | NestedProgressOverrideProperties<CT, C> | NestedReferenceOverrideProperties<CT, C, R> | NestedSelectOverrideProperties<CT, C> | NestedSwitchOverrideProperties<CT, C> | NestedTextOverrideProperties<CT, C> | NestedTextAreaOverrideProperties<CT, C>;
	export interface NestedOverrideField<CT extends ScreenExtension<CT>, T extends NestedFieldTypes, C extends ClientNode = any, R extends ClientNode = any> {
	    defaultUiProperties: Partial<NestedFieldsOverrideProperties<Extend<CT>, C, R>>;
	    properties: NestedFieldsOverrideProperties<Extend<CT>, C, R>;
	    type: T;
	}
	export const aggregate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedAggregateOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Aggregate, NodeType>;
	export const checkbox: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCheckboxOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Checkbox, NodeType>;
	export const count: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCountOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Count, NodeType>;
	export const date: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDateOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Date, NodeType>;
	export const dropdown: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDropdownListOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.DropdownList, NodeType>;
	export const filterSelect: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedFilterSelectOverrideProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.FilterSelect, NodeType, R>;
	export const icon: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedIconOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Icon, NodeType>;
	export const image: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedImageOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Image, NodeType>;
	export const label: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLabelOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Label, NodeType>;
	export const link: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLinkProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Link, NodeType>;
	export const numeric: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedNumericOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Numeric, NodeType>;
	export const multiDropdown: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedMultiDropdownOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.MultiDropdown, NodeType>;
	export const multiReference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiReferenceOverrideProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.MultiReference, NodeType, R>;
	export const progress: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedProgressOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Progress, NodeType>;
	export const reference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedReferenceOverrideProperties<Extend<CT>, NodeType, R>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Reference, NodeType, R>;
	export const select: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSelectOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Select, NodeType>; const nestedSwitch: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCheckboxOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Switch, NodeType>;
	export { nestedSwitch as switch };
	export const text: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextOverrideProperties<Extend<CT>, NodeType>, '_controlObjectType'>) => NestedOverrideField<CT, FieldKey.Text, NodeType>;
	//# sourceMappingURL=nested-fields-overrides.d.ts.map
}
declare module 'lib/component/field/multi-reference/multi-reference-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { MultiReferenceDecoratorProperties } from 'lib/component/field/multi-reference/multi-reference-types';
	export enum MultiReferenceDecoratorPropertiesKeys {
	    isDropdownDisabled = "isDropdownDisabled",
	    onOpenMultiReferenceDialog = "onOpenMultiReferenceDialog",
	    onCloseMultiReferenceDialog = "onCloseMultiReferenceDialog",
	    minLookupCharacters = "minLookupCharacters"
	}
	type BaseMultiReferenceExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase> = {
	    onCloseMultiReferenceDialogAfter?: (this: CT, _id: any) => void;
	    onOpenMultiReferenceDialogAfter?: (this: CT, _id: any) => void;
	};
	export interface MultiReferenceExtensionDecoratorProperties<T extends ScreenExtension<T>, NodeType extends ClientNode = any> extends BaseMultiReferenceExtensionDecoratorProperties<Extend<T>>, ChangeableOverrideDecoratorProperties<Omit<MultiReferenceDecoratorProperties<Extend<T>, NodeType>, 'isMultiReferenceDialogOpen'>, Extend<T>> {
	    /** The definitions of the nested fields used to represent the table rows */
	    columns?: NestedExtensionField<T, NestedFieldTypes, NodeType>[];
	    /** Allows overriding existing column properties in the base page's columns */
	    columnOverrides?: NestedOverrideField<T, NestedFieldTypes, NodeType>[];
	}
	/**
	 * Initializes the decorated member as a [MultiReference]{@link MultiReferenceControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [MultiReference]{@link MultiReferenceControlObject} field will be initialized with
	 */
	export function multiReferenceField<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: Omit<MultiReferenceDecoratorProperties<Extend<T>, NodeType>, 'isMultiReferenceDialogOpen'>): (target: T, name: string) => void;
	export function multiReferenceFieldOverride<T extends ScreenExtension<T>, NodeType extends ClientNode = any>(properties: MultiReferenceExtensionDecoratorProperties<T, NodeType>): (target: T, name: string) => void;
	export {};
	//# sourceMappingURL=multi-reference-decorator.d.ts.map
}
declare module 'lib/component/field/multi-reference/multi-reference-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { MultiReferenceDecoratorPropertiesKeys } from 'lib/component/field/multi-reference/multi-reference-decorator';
	import type { HasColumns, HasFilter, HasIcon, HasLookupDialogTitle, HasSound, MaxItems, MinItems, Sizable, Changeable, Clickable, ExtensionField, HasDynamicLookupSuggestions, HasInputValueChangeListener, HasNestedFilter, HasParent, NestedChangeable, NestedClickable, NestedMaxItems, NestedMinItems, Validatable, Nested, HasValueField, HasHelperTextField, NestedHasLookupDialogTitle } from 'lib/component/field/traits';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { FieldControlObjectInstance, ReferenceRecursiveOrderBy } from 'lib/component/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	export interface MultiReferenceProperties<CT extends ScreenExtension<CT> = ScreenBase, MultiReferencedItemType extends ClientNode = any, ContextNodeType = any> extends EditableFieldProperties<CT, ContextNodeType>, HasFilter<CT, MultiReferencedItemType>, HasIcon, HasSound<CT>, Partial<HasColumns<CT, MultiReferencedItemType>>, Sizable, HasValueField<MultiReferencedItemType>, HasHelperTextField<MultiReferencedItemType>, MinItems<CT>, MaxItems<CT> {
	    /** Whether the rows of the reference lookup can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	    /** The GraphQL node property that will be used to display an image in front of the values. t*/
	    imageField?: PropertyValueType<MultiReferencedItemType>;
	    /** Minimum number of characters to trigger server lookup. If `0` supplied, the first page of suggestions will be fetched on focus. Defaults to 3 */
	    minLookupCharacters?: number;
	    /** The GraphQL node that the field suggestions will be fetched from */
	    node: keyof ScreenBaseGenericType<CT>;
	    /** The column or the set of columns which the table should be sorted by */
	    orderBy?: ReferenceRecursiveOrderBy<MultiReferencedItemType>;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Function to be executed when the reference's dialog is opened */
	    onOpenMultiReferenceDialog?: (this: CT, _id: string) => void;
	    /** Function to be executed when the reference's dialog is closed */
	    onCloseMultiReferenceDialog?: (this: CT, _id: string) => void;
	    /** Auto-select item if search matches only one element */
	    isMultiReferenceDialogOpen?: boolean;
	    /** Should suggestions be based on all known columns? */
	    shouldSuggestionsIncludeColumns?: boolean;
	}
	export interface MultiReferenceDecoratorProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<MultiReferenceProperties<CT, ContextNodeType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, HasInputValueChangeListener<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, HasSound<CT>, HasDynamicLookupSuggestions<CT, ContextNodeType>, HasLookupDialogTitle<CT>, Sizable, MinItems<CT>, MaxItems<CT> {
	    /** Minimum number of characters to trigger server lookup */
	    [MultiReferenceDecoratorPropertiesKeys.minLookupCharacters]?: number;
	    /** Whether the dropdown is disabled or not. If disabled the lookup dialog will be forcefully enabled. */
	    [MultiReferenceDecoratorPropertiesKeys.isDropdownDisabled]?: boolean;
	}
	type UnionMultiReference = 'bind' | 'filter' | 'minItems' | 'maxItems';
	export interface NestedMultiReferenceProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any, MultiReferencedNode extends ClientNode = any> extends Omit<MultiReferenceProperties<CT, MultiReferencedNode, ContextNodeType>, UnionMultiReference>, NestedChangeable<CT>, NestedClickable<CT>, Nested<ContextNodeType>, Sizable, HasNestedFilter<CT, ContextNodeType, MultiReferencedNode>, Validatable<CT, MultiReferencedNode[]>, NestedHasLookupDialogTitle<CT, ContextNodeType>, NestedMinItems<CT>, NestedMaxItems<CT> {
	    /** Minimum number of characters to trigger server lookup */
	    [MultiReferenceDecoratorPropertiesKeys.minLookupCharacters]?: number;
	    /** Whether the dropdown is disabled or not. If disabled the lookup dialog will be set to true. */
	    [MultiReferenceDecoratorPropertiesKeys.isDropdownDisabled]?: boolean;
	}
	export type MultiReferenceComponentProps<T extends ClientNode = any> = BaseEditableComponentProperties<MultiReferenceDecoratorProperties<any, T>, T[], NestedFieldsAdditionalProperties>;
	export interface MultiReferenceComponentState {
	    id: string;
	    isNestedLookupDialogOpen?: boolean;
	}
	export {};
	//# sourceMappingURL=multi-reference-types.d.ts.map
}
declare module 'lib/component/field/progress/progress-types' {
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { Clickable, ExtensionField, HasParent, Nested, NestedClickable, Sizable, Colorable } from 'lib/component/field/traits';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { ClientNode } from '@sage/xtrem-client';
	export interface ProgressDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<ProgressProperties<CT>, '_controlObjectType'>, Clickable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable {
	}
	export interface NestedProgressProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<ProgressProperties<CT>, 'bind'>, Nested<NodeType>, NestedClickable<CT>, Sizable {
	}
	export interface ProgressProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT>, Colorable<CT> {
	    currentProgressLabel?: string;
	    maxProgressLabel?: string;
	    areProgressLabelsHidden?: boolean;
	}
	export type ProgressComponentProps = BaseReadonlyComponentProperties<ProgressProperties, number, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=progress-types.d.ts.map
}
declare module 'lib/component/field/progress/progress-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { ProgressDecoratorProperties } from 'lib/component/field/progress/progress-types';
	export class ProgressComponent extends ReadonlyFieldBaseComponent<ProgressDecoratorProperties, number, NestedFieldsAdditionalProperties> {
	    render(): React.ReactNode;
	}
	export const ConnectedProgressComponent: import("react-redux").ConnectedComponent<typeof ProgressComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<ProgressComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedProgressComponent;
	//# sourceMappingURL=progress-component.d.ts.map
}
declare module 'lib/component/field/progress/async-progress-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ProgressComponentProps } from 'lib/component/field/progress/progress-types';
	export function AsyncConnectedProgressComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncProgressComponent(props: ProgressComponentProps): React.ReactElement;
	//# sourceMappingURL=async-progress-component.d.ts.map
}
declare module 'lib/utils/layout-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import { SectionControlObject } from 'lib/component/control-objects';
	import type { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { PageArticleItem, PageArticleLayout } from 'lib/service/layout-service';
	import type { AccessBindings, PageDefinition } from 'lib/service/page-definition';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { DialogDescription } from 'lib/types/dialogs';
	import type { NodePropertyType } from 'lib/types';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	export const getFieldOrderAndFocusability: (screenId: string, articleItem: PageArticleLayout, uiComponentProperties: Dict<UiComponentProperties<ScreenBase>>, isParentFocusable: boolean, collector?: Dict<boolean>) => Dict<boolean>;
	export const findNextField: (screenId: string, currentElementId?: string, isFocusable?: boolean) => ReadonlyFieldControlObject<any, any, any, any> | null;
	export interface IsHiddenOrDisabledInLayoutArgs {
	    componentProperties: Dict<UiComponentProperties>;
	    screenId: string;
	    elementId: string;
	    accessBindings: AccessBindings;
	    contextNode?: NodePropertyType;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    dataTypes: Dict<DataTypeDetails>;
	}
	export const isHiddenOrDisabledInLayout: ({ componentProperties, screenId, elementId, accessBindings, contextNode, nodeTypes, dataTypes, }: IsHiddenOrDisabledInLayoutArgs) => boolean;
	export const isSectionUsedInAnyDialogs: (activeDialogs: Dict<DialogDescription>, sectionContainerId: string) => boolean;
	export const getHeaderSection: (pageDefinition: PageDefinition, isSmallScreen?: boolean) => SectionControlObject | null;
	export const getVisibleSections: (pageDefinition: PageDefinition, activeDialogs: Dict<DialogDescription>, isSmallScreen?: boolean) => Partial<PageArticleItem>[];
	export const focusFirstElement: (selector: string, hasDialogActionButtons?: boolean) => void;
	//# sourceMappingURL=layout-utils.d.ts.map
}
declare module 'lib/utils/type-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	export const isNumber: (value?: any) => value is number;
	type PathType = Array<string | number>;
	type CollectionCallback<ValueType, AccumulatorType, SourceType> = (value: ValueType, acc: AccumulatorType, key: string | number, path: PathType, source: SourceType) => [ValueType, PathType];
	type ValueCallback<ValueType, AccumulatorType, SourceType> = (value: ValueType, acc: AccumulatorType, key: string | number, path: PathType, source: SourceType) => AccumulatorType;
	type onArray<AccumulatorType, SourceType> = CollectionCallback<Array<any>, AccumulatorType, SourceType>;
	type onObject<AccumulatorType, SourceType> = CollectionCallback<Dict<any>, AccumulatorType, SourceType>;
	type onValue<AccumulatorType, SourceType> = ValueCallback<any, AccumulatorType, SourceType>;
	export const reduceDict: <SourceType, AccumulatorType>() => (source: SourceType, initial: AccumulatorType, onValueFn: onValue<AccumulatorType, SourceType>, onObjectFn?: onObject<AccumulatorType, SourceType>, onArrayFn?: onArray<AccumulatorType, SourceType>) => AccumulatorType;
	export const AllAndOnly: <T>() => <U extends T[]>(array: U & ([T] extends [U[number]] ? unknown : never)) => U & ([T] extends [U[number]] ? unknown : never);
	export {};
	//# sourceMappingURL=type-utils.d.ts.map
}
declare module 'lib/service/validation-service' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import type { DateDecoratorProperties, MultiDropdownDecoratorProperties, NumericDecoratorProperties, TextAreaDecoratorProperties, TextDecoratorProperties } from 'lib/component/decorators';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { XtremAppState } from 'lib/redux';
	import type { NodePropertyType } from 'lib/types';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	type ExtendedFieldProperties = EditableFieldProperties & TextDecoratorProperties & TextAreaDecoratorProperties & NumericDecoratorProperties & DateDecoratorProperties & MultiDropdownDecoratorProperties;
	export const CHILDREN_VALIDATION_ERROR_MESSAGE: () => string;
	export const CHILDREN_VALIDATION_RULE: () => string;
	export const executeValidationRulesOnField: ({ screenId, elementId, fieldProperties, value, rowValue: inputRowValue, columnId, recordId, }: {
	    screenId: string;
	    elementId: string;
	    fieldProperties?: ExtendedFieldProperties;
	    value: any;
	    rowValue?: Dict<any>;
	    columnId?: string;
	    recordId?: string;
	}) => Promise<ValidationResult[]>;
	export const checkNestedRecordValidationStatus: ({ rowValue, columnDefinitions, columnsToValidate, screenId, elementId, recordId, }: {
	    screenId: string;
	    elementId: string;
	    rowValue: Dict<any>;
	    columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[];
	    columnsToValidate: Set<string>;
	    recordId: string;
	}) => Promise<Dict<ValidationResult>>;
	/**
	 * The function checks all validation rules.
	 *
	 * @param screenElement
	 * @param elementId
	 * @param componentProperties
	 * @param value
	 */
	export const checkValidationStatus: (screenElement: ScreenBase, elementId: string, componentProperties: Dict<UiComponentProperties>, value: any, accessBindings: AccessBindings, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, contextNode?: NodePropertyType) => Promise<ValidationResult[]>;
	export const getSectionValidationMessage: (screenId: string, sectionId: string, state: XtremAppState) => string | null;
	export const getValidationState: (screenId: string, elementId: string, state?: XtremAppState) => boolean;
	export {};
	//# sourceMappingURL=validation-service.d.ts.map
}
declare module 'lib/service/ag-grid-licence-service' {
	export const setAgGridLicence: () => void;
	//# sourceMappingURL=ag-grid-licence-service.d.ts.map
}
declare module 'lib/utils/date-utils' {
	import type { AggFunc } from 'lib/service/collection-data-utils';
	export function isRowValueInDateGroup(rowValue: string, groupValue: string, aggFunc: AggFunc): boolean;
	export function getTimezoneUtcOffsetByCity(timeZone: string): string;
	//# sourceMappingURL=date-utils.d.ts.map
}
declare module 'lib/component/ui/calendar-body/calendar-body-utils' {
	/// <reference types="lodash" />
	import type { EventContentArg } from '@fullcalendar/core';
	import type { Locale } from '@sage/xtrem-shared';
	import type { ValueOrCallbackWitRecordValue } from 'lib/utils/types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { CollectionItem } from 'lib/component/types';
	import type { CalendarEvent } from 'lib/component/ui/calendar-body/calendar-body-types';
	export const getEventStyle: (screenId: string, eventProps: EventContentArg, record: any, hasClickEventListener?: boolean, cardColor?: ValueOrCallbackWitRecordValue<any, string>) => {
	    eventClasses: string;
	    style: React.CSSProperties;
	};
	export interface EventFormatterArgs {
	    screenId: string;
	    record: CollectionItem;
	    startDateField: PropertyValueType;
	    endDateField?: PropertyValueType;
	    isEventMovable?: ValueOrCallbackWitRecordValue<any, boolean>;
	}
	export const eventFormatter: ({ screenId, record, startDateField, endDateField, isEventMovable, }: EventFormatterArgs) => CalendarEvent;
	export const getCalendarLocale: ((userLocale: Locale) => string) & import("lodash").MemoizedFunction;
	//# sourceMappingURL=calendar-body-utils.d.ts.map
}
declare module 'lib/component/ui/calendar-body/calendar-event-component' {
	import React from 'react';
	import type { CalendarEventCardProps } from 'lib/component/ui/calendar-body/calendar-body-types';
	export function CalendarEventCardComponent({ elementId, eventProps, selectedView, isMobileMonthlyView, value, screenId, hasClickEventListener, cardColor, eventCard, }: CalendarEventCardProps): React.ReactElement | null;
	//# sourceMappingURL=calendar-event-component.d.ts.map
}
declare module 'lib/component/ui/calendar-body/calendar-body-component' {
	import * as React from 'react';
	import type { CalendarBodyComponentProps } from 'lib/component/ui/calendar-body/calendar-body-types';
	export const CalendarComponentBody: React.NamedExoticComponent<CalendarBodyComponentProps>;
	//# sourceMappingURL=calendar-body-component.d.ts.map
}
declare module 'lib/component/ui/calendar-body/async-calendar-body-component' {
	import * as React from 'react';
	import type { CalendarBodyComponentProps } from 'lib/component/ui/calendar-body/calendar-body-types';
	export function AsyncCalendarBodyComponent(props: CalendarBodyComponentProps): React.ReactElement;
	//# sourceMappingURL=async-calendar-body-component.d.ts.map
}
declare module 'lib/component/field/field-actions-component' {
	import React from 'react';
	import type { PageActionControlObject } from 'lib/component/control-objects';
	import type { ScreenExtension } from 'lib/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { IconType } from 'carbon-react/esm/components/icon';
	export interface AdditionalFieldAction<CT extends ScreenExtension<CT> = ScreenBase> {
	    title: string;
	    onClick: (this: CT) => void;
	    icon: IconType;
	    id: string;
	}
	interface FieldActionExternalProps {
	    screenId: string;
	    fieldId: string;
	    isDisabled?: boolean;
	    additionalFieldActions?: AdditionalFieldAction[];
	}
	interface FieldActionProps extends FieldActionExternalProps {
	    fieldActionsMap?: PageActionControlObject[];
	} function FieldActions(props: FieldActionProps): React.ReactElement | null; const _default: import("react-redux").ConnectedComponent<typeof FieldActions, {
	    screenId: string;
	    fieldId: string;
	    isDisabled?: boolean | undefined;
	    additionalFieldActions?: AdditionalFieldAction<ScreenBase<any, any>>[] | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=field-actions-component.d.ts.map
}
declare module 'lib/component/property-decorators/control-object-resolved-property-decorator' {
	import type { BaseControlObject } from 'lib/component/base-control-object';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	export interface FieldControlObjectResolvedPropertyHooks<CT> {
	    onSet?: (this: CT, screenId: string, elementId: string, value: any) => void;
	    onGet?: (this: CT, screenId: string, elementId: string) => void;
	}
	export const FieldControlObjectResolvedProperty: <PropertiesType extends Object, ConstructorType extends BaseControlObject<any, PropertiesType & ReadonlyFieldProperties<any>>>(hooks?: FieldControlObjectResolvedPropertyHooks<ConstructorType>) => (controlObjectConstructor: ConstructorType, name: keyof PropertiesType) => void;
	export const ContainerControlObjectResolvedProperty: <PropertiesType extends Object, ConstructorType extends BaseControlObject<any, any>>() => (controlObjectConstructor: ConstructorType, name: keyof PropertiesType) => void;
	//# sourceMappingURL=control-object-resolved-property-decorator.d.ts.map
}
declare module 'lib/component/page-action/page-action-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import { AbstractUiControlObject } from 'lib/component/abstract-ui-control-object';
	import type { Clickable, HasHelperText, HasIcon, HasShortcuts } from 'lib/component/field/traits';
	import type { ButtonProps } from 'carbon-react/esm/components/button';
	export type PageActionButtonType = ButtonProps['buttonType'];
	export interface PageActionProperties<CT extends ScreenBase = ScreenBase> extends UiComponentProperties<CT>, HasHelperText, Clickable<CT>, HasIcon, HasShortcuts {
	    /** Type of button, according with Carbon's API. Can be primary, secondary or tertiary */
	    buttonType?: PageActionButtonType;
	    /** Whether the HTML element is hidden or not. Defaults to false */
	    isHidden?: ValueOrCallbackWithFieldValue<CT, boolean>;
	    /** If set, only the icon is displayed, the title is used as a tooltip */
	    isIconButton?: boolean;
	    /** If set the action's icon and text are rendered in red. Optional, defaults to false. */
	    isDestructive?: boolean;
	}
	export interface IPageAction<CT extends ScreenExtension<CT> = ScreenBase> {
	    screenId: string;
	    elementId: string;
	    getUiComponentProperties?: (screenId: string, elementId: string) => PageActionProperties<CT>;
	    setUiComponentProperties?: (screenId: string, elementId: string, state: PageActionProperties<CT>) => void;
	}
	/**
	 * Action that will be placed in the page header (i.e. business action)
	 */
	export class PageActionControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractUiControlObject<CT, PageActionProperties<CT>> {
	    static readonly defaultUiProperties: Partial<PageActionProperties<any>>;
	    constructor({ screenId, elementId, getUiComponentProperties, setUiComponentProperties, }: IPageAction<CT>);
	    /** Additional text that will be displayed when mousing over the page action */
	    helperText?: string;
	    /** Icon of the action */
	    icon?: IconType;
	    /** Whether the action is displayed */
	    isHidden?: boolean;
	    /** Whether the action is displayed */
	    buttonType?: PageActionButtonType;
	    execute(executeErrorHandlers?: boolean, ...args: any[]): Promise<void>;
	}
	//# sourceMappingURL=page-action-control-object.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ButtonProps } from 'carbon-react/esm/components/button';
	import type { NestedRecordId, ScreenExtension } from 'lib/types';
	import type { MenuSeparatorType } from 'lib/component/control-objects';
	import type { CollectionActionAccessConfiguration, HasGenericErrorHandler, HasIcon } from 'lib/component/field/traits';
	import type { CollectionItem, PartialCollectionValueWithIds } from 'lib/component/types';
	export interface CollectionPropertiesWithActions extends HasGenericErrorHandler<any> {
	    dropdownActions?: Array<CollectionItemAction<any> | MenuSeparatorType>[];
	    inlineActions?: Array<InlineCollectionItemAction<any>>[];
	    levels?: {
	        dropdownActions: any[];
	        inlineActions: any;
	    }[];
	}
	export interface CollectionItemAction<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends HasIcon, HasGenericErrorHandler<CT> {
	    access?: CollectionActionAccessConfiguration;
	    id?: string;
	    isDestructive?: boolean;
	    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
	    isDisplayed?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
	    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
	    onClick: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => void;
	    title: string;
	}
	export interface CollectionItemActionGroup<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends HasIcon, HasGenericErrorHandler<CT> {
	    access?: CollectionActionAccessConfiguration;
	    children?: Array<CollectionItemAction<CT, NestedRecordType> | MenuSeparatorType | CollectionItemActionGroup<CT, NestedRecordType>>;
	    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
	    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: PartialCollectionValueWithIds<NestedRecordType>) => boolean;
	    title: string;
	}
	export interface InlineCollectionItemAction<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends CollectionItemAction<CT, NestedRecordType> {
	    buttonType?: ButtonProps['buttonType'];
	    isMajor?: boolean;
	}
	export interface NestedCollectionItemAction<CT extends ScreenExtension<CT>, NestedRecordType extends ClientNode = any> extends HasIcon, HasGenericErrorHandler<CT> {
	    access?: CollectionActionAccessConfiguration;
	    id?: string;
	    isDestructive?: boolean;
	    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
	    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
	    onClick: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => void;
	    title: string;
	}
	export interface NestedCollectionItemActionGroup<CT extends ScreenExtension<CT>, NestedRecordType extends ClientNode = any> extends HasIcon, HasGenericErrorHandler<CT> {
	    access?: CollectionActionAccessConfiguration;
	    children?: Array<NestedCollectionItemAction<CT, NestedRecordType> | MenuSeparatorType | NestedCollectionItemActionGroup<CT, NestedRecordType>>;
	    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
	    isHidden?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, level?: number, parentIds?: NestedRecordId[]) => boolean;
	    title: string;
	}
	//# sourceMappingURL=table-dropdown-action-types.d.ts.map
}
declare module 'lib/component/field/nested-grid/nested-grid-component-types' {
	import type { RowNode } from '@ag-grid-community/core';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import type { OnTelemetryEventFunction, ReduxResponsive } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ContextType, ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { FixedSizeTuple } from 'lib/utils/types';
	import type { InternalNestedGridProperties, MenuSeparatorType } from 'lib/component/control-objects';
	import type { GridNestedFieldTypes, NestedField } from 'lib/component/nested-fields';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { SidebarDefinitionDecorator } from 'lib/component/table-sidebar/table-sidebar-types';
	import type { CollectionItem, OrderByType } from 'lib/component/types';
	import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { ServerRecordMapperFunction } from 'lib/component/field/traits';
	export interface Column {
	    /** Field title label */
	    headerName?: string;
	    /** Bind */
	    field: string;
	}
	export interface GetDetailRowDataParams {
	    node: RowNode;
	    data: any;
	    successCallback(rowValue: any[]): void;
	}
	export interface NestedGridComponentExternalProps {
	    elementId: string;
	    isParentDisabled?: boolean;
	    item?: PageArticleItem;
	    mobilePerformInitialLoadNestedGridData?: boolean;
	    screenId: string;
	    searchText?: string;
	}
	export interface NestedGridInternalComponentProps {
	    accessBindings: AccessBindings;
	    contextType?: ContextType;
	    dataTypes: Dict<DataTypeDetails>;
	    elementId: string;
	    enumTypes: Dict<string[]>;
	    fieldProperties: InternalNestedGridProperties;
	    groupKey?: string;
	    groupTitle?: string;
	    isParentDisabled?: boolean;
	    locale: LocalizeLocale;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    onRowClick?: (recordId: NestedGridItemId, level: number) => () => void;
	    screenId: string;
	    searchText?: string;
	    setFieldProperties?: (elementId: string, properties: InternalNestedGridProperties) => void;
	    setGlobalLoading?: (setGlobalLoading: boolean) => void;
	    username?: string;
	    validationErrors: ValidationResult[];
	    value: CollectionValue;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface NestedGridComponentProps extends NestedGridComponentExternalProps {
	    accessBindings: AccessBindings;
	    browser: ReduxResponsive;
	    contextType?: ContextType;
	    dataTypes: Dict<DataTypeDetails>;
	    enableMobileLoadMore?: boolean;
	    enumTypes: Dict<string[]>;
	    fieldProperties: InternalNestedGridProperties;
	    isLoading?: boolean;
	    locale: LocalizeLocale;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    onRowClick?: (rowValue: CollectionItem) => void;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	    openSidebar: (args: {
	        elementId: string;
	        screenId: string;
	        level: number;
	        parentId: string;
	    }) => void;
	    setFieldProperties?: (elementId: string, properties: InternalNestedGridProperties) => void;
	    setGlobalLoading?: (setGlobalLoading: boolean) => void;
	    username?: string;
	    validate?: (elementId: string, value: CollectionValue) => Promise<ValidationResult[] | undefined>;
	    validationErrors: ValidationResult[];
	    value: CollectionValue;
	}
	export interface ColumnsData {
	    columnDefinition: NestedField<ScreenBase, GridNestedFieldTypes>;
	    bind: string;
	    elementId: string;
	}
	export type ExtensionLevel<CT extends ScreenExtension<CT>, T extends ClientNode = any> = {
	    /** The definitions of the nested fields used to represent the table rows */
	    columns?: NestedExtensionField<CT, GridNestedFieldTypes, T>[];
	    /** Allows overriding existing column properties in the base page's columns */
	    columnOverrides?: NestedOverrideField<CT, GridNestedFieldTypes, T>[];
	    /** Additional row actions */
	    dropdownActions?: Array<NestedCollectionItemAction<CT, T> | MenuSeparatorType | NestedCollectionItemActionGroup<CT, T>>;
	};
	export type Level<CT extends ScreenExtension<CT>, T extends ClientNode = any> = {
	    childProperty?: PropertyValueType<T>;
	    columns: NestedField<CT, GridNestedFieldTypes, T>[];
	    /** Sets a text when no data is available in the table */
	    emptyStateText?: string;
	    /** Sets a complementary text link when no data is available in the table  */
	    emptyStateClickableText?: string;
	    /** Function to be executed when the clickable text is clicked */
	    onEmptyStateLinkClick?: (this: CT, recordId: NestedGridItemId, level: number) => void;
	    filter?: GraphQLFilter<T> | ((this: CT) => GraphQLFilter<T>);
	    /** The GraphQL node that the grid level represents */
	    node: keyof ScreenBaseGenericType<CT> & string;
	    /** The column or the set of columns which the nested grid should be sorted by */
	    orderBy?: OrderByType<T>;
	    /** Actions that are rendered at the end of the table as a drop-down menu */
	    dropdownActions?: Array<NestedCollectionItemAction<CT, T> | MenuSeparatorType | NestedCollectionItemActionGroup<CT, T>>;
	    /** Allows changing record values before those are rendered to the screen. This function is invoked whenever new entities are fetched from the server. */
	    mapServerRecord?: ServerRecordMapperFunction<CT, T>;
	    canAddNewLine?: boolean;
	    sidebar?: SidebarDefinitionDecorator<CT, T>;
	};
	export type MappedExtensionLevel<CT extends ScreenExtension<CT>, T extends ClientNode[] = [any, any]> = {
	    [K in keyof T]: T[K] extends ClientNode ? ExtensionLevel<CT, T[K]> : never;
	};
	export type MappedLevel<CT extends ScreenExtension<CT>, T extends ClientNode[] = [any, any]> = {
	    [K in keyof T]: T[K] extends ClientNode ? Level<CT, T[K]> : never;
	};
	export type MappedSelected<T extends ClientNode[] = [any, any]> = FixedSizeTuple<string[], T['length']>;
	export type NestedGridItemId = string;
	//# sourceMappingURL=nested-grid-component-types.d.ts.map
}
declare module 'lib/component/field/nested-grid/nested-grid-utils' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { UnionType } from 'lib/utils/types';
	import type { MappedLevel } from 'lib/component/field/nested-grid/nested-grid-component-types';
	export function getLevelMap<L extends ClientNode[] = [any, any]>(levels: MappedLevel<any, L>): Record<number, keyof UnionType<L> | undefined>;
	//# sourceMappingURL=nested-grid-utils.d.ts.map
}
declare module 'lib/component/field/nested-grid/nested-grid-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { ValueOrCallback, ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { OptionsMenuItem, TableOptionsMenuType } from 'lib/component/container/page/page-types';
	import type { NestedGridDecoratorProperties } from 'lib/component/decorators';
	import type { PageActionControlObject } from 'lib/component/page-action/page-action-control-object';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldKey, PartialCollectionValue, PartialCollectionValueWithIds } from 'lib/component/types';
	import { TableDisplayMode } from 'lib/component/types';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { AdditionalFieldAction } from 'lib/component/field/field-actions-component';
	import type { HasFieldActions, HasOptionsMenu, HasRowChangeIndicators } from 'lib/component/field/traits';
	import type { MappedLevel, MappedSelected, NestedGridItemId } from 'lib/component/field/nested-grid/nested-grid-component-types';
	export interface NestedGridProperties<CT extends ScreenExtension<CT> = ScreenBase, L extends ClientNode[] = [any, any]> extends ReadonlyFieldProperties<CT>, HasFieldActions<CT>, HasOptionsMenu<CT>, HasRowChangeIndicators {
	    /** Whether the rows of the nested grid can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	    /** Whether the rows of the nested grid can be activated or not. Defaults to false.
	     *  If set to true then single row selection will be used, such that when you select a row, any previously selected row gets unselected.
	     */
	    canActivate?: boolean;
	    /** Whether the rows of the nested grid can be selected or not. Defaults to true.
	     *  Allows multiple rows to be selected.
	     */
	    canSelect?: boolean;
	    /** Whether the user can decide which nested grid columns to display. Defaults to true */
	    canUserHideColumns?: boolean;
	    /** The definitions of the nested grid's levels */
	    levels: MappedLevel<CT, L>;
	    /** Determines how the nested grid rows are displayed. Defaults to "comfortable" */
	    displayMode?: TableDisplayMode;
	    /**  Whether in mobile devices a search box should be displayed or not*/
	    hasSearchBoxMobile?: boolean;
	    /** The definitions of the nested fields used to represent the nested grid rows on mobile.
	     * If no value is provided, the first four columns are used by default */
	    mobileCard?: CardDefinition<CT>;
	    /** Number of lines displayed by default in the nested grid. Defaults to 20 */
	    pageSize?: number;
	    /** Selected rows identifiers */
	    selectedRecords?: MappedSelected<L>;
	    /** The GraphQL node that the nested grid represents, needed for filtering */
	    node?: keyof ScreenBaseGenericType<CT>;
	    /** Forces a mobile-like card view on desktop */
	    cardView?: boolean;
	    /** Indicate additional warning message, rendered as tooltip and blue border. */
	    infoMessage?: ValueOrCallbackWithFieldValue<CT, string>;
	    /** Indicate additional information, rendered as tooltip and orange border. */
	    warningMessage?: ValueOrCallbackWithFieldValue<CT, string>;
	}
	export interface InternalNestedGridProperties<CT extends ScreenExtension<CT> = ScreenBase> extends NestedGridProperties<CT> {
	    activeUserFilter?: GraphQLFilter;
	    headerBusinessActions?: ValueOrCallback<CT, PageActionControlObject[]>;
	    optionsMenu?: ValueOrCallback<CT, OptionsMenuItem[]>;
	    optionsMenuType?: TableOptionsMenuType;
	    additionalFieldActions?: AdditionalFieldAction[];
	}
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
	 */
	export class NestedGridControlObject<L extends ClientNode[] = [any, any], CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.NestedGrid, NestedGridProperties<CT, L>> {
	    static readonly defaultUiProperties: Partial<NestedGridDecoratorProperties>;
	    private ensureNestedGridHasValue;
	    private setFieldValue;
	    private defaultSelectedRecords;
	    /** Whether user can hide columns or not */
	    get canUserHideColumns(): boolean;
	    /** Whether user can hide columns or not */
	    set canUserHideColumns(newValue: boolean);
	    /** Number of lines displayed by default in the nested grid (defaults to 20) */
	    pageSize?: number;
	    /** Whether the rows of this nested grid can be selected or not */
	    canSelect?: boolean;
	    /** Whether the rows of this nested grid can be filtered or not */
	    canFilter?: boolean;
	    /**
	     * Indicate additional warning message, rendered as tooltip and blue border.
	     */
	    get infoMessage(): string | undefined;
	    /**
	     * Indicate additional warning message, rendered as tooltip and blue border.
	     */
	    set infoMessage(infoMessage: string | undefined);
	    /**
	     * Indicate additional information, rendered as tooltip and orange border
	     */
	    get warningMessage(): string | undefined;
	    /**
	     * Indicate additional information, rendered as tooltip and orange border
	     */
	    set warningMessage(warningMessage: string | undefined);
	    /** Selected rows identifiers */
	    get selectedRecords(): MappedSelected<L>;
	    /** Selected rows identifiers */
	    set selectedRecords(rowIds: MappedSelected<L>);
	    /** Selects a given row by its identifier*/
	    selectRecord<N extends number>(recordId: NestedGridItemId, level: N): void;
	    refresh(): Promise<void>;
	    /** Unselects a given row by its identifier */
	    unselectRecord<N extends number>(recordId: NestedGridItemId, level: N): void;
	    /** Unselects all items */
	    unselectAllRecords(): void;
	    /**
	     * Return all data known to the client (it does not include rows which were not previously fetched by some
	     * user interaction such as pagination) in normalized collection form.
	     * */
	    get normalizedValue(): PartialCollectionValueWithIds<L[0]>[];
	    /**
	     * Return all data known to the client (it does not include rows which were not previously fetched by some
	     * user interaction such as pagination) in a tree form.
	     * */
	    get value(): PartialCollectionValueWithIds<L[0]>[];
	    /**
	     * Resets the value of the nested grid, all pending changes will be overridden and all cached rows will be discarded
	     * */
	    set value(newValue: PartialCollectionValueWithIds<L[0]>[]);
	    private validateLevel;
	    openSidebar(recordId?: string, level?: number): void;
	    /** Update the value of a single row in the collection */
	    setRecordValue<N extends number>(recordValue: PartialCollectionValueWithIds<L[N]>, level: N): void;
	    /** Return a single record that is already known to the client */
	    getRecordValue<N extends number>(recordId: string, level: N): PartialCollectionValueWithIds<L[N]> | null;
	    /** Add a single row to the nested grid and in its dataset with default values coming from the server */
	    addRecordWithDefaults<N extends number>(level: N, parentId: N extends 0 ? undefined : string): Promise<PartialCollectionValue<L[N]>>;
	    /** Add a single row to the nested grid and in its dataset */
	    addRecord<N extends number>(recordValue: PartialCollectionValue<L[N]>, level: N, parentId: N extends 0 ? undefined : string): PartialCollectionValue<L[N]>;
	    /** Remove a single row from the nested grid and its dataset */
	    removeRecord(recordId: NestedGridItemId, level: number): void;
	    /** Add or update row in the nested grid depending of the existence of the ID field */
	    addOrUpdateRecordValue<N extends number>(recordData: PartialCollectionValue<L[N]>, level: N, parentId: N extends 0 ? undefined : string): PartialCollectionValue<L[N]>;
	    /** Add or update row in the nested grid (depending of the existence of its "_id" field and a given "level") */
	    getRecordByFieldValue<N extends number, P extends keyof L[N]>(fieldName: P, fieldValue: L[N][P], level: N): PartialCollectionValue<L[N]> | null;
	    /** Gets all records that have been added/updated/removed. */
	    getChangedRecords(): PartialCollectionValue<L[0]>[];
	    refreshRecord<N extends number>(recordId: string, level: N, skipUpdate?: boolean): Promise<PartialCollectionValueWithIds<L[N]>>;
	    /**
	     * Fetches data for children record based on parent record id and child level. Default limit is 100. If the
	     * openLevel attribute is set to true, the parent record is unfolded on the user interface and the children are
	     * displayed.
	     */
	    loadChildRecords<N extends number>({ childLevel, parentRecordId, limit, filter, openLevel, }: {
	        childLevel: N;
	        parentRecordId: string;
	        limit?: number;
	        filter?: GraphQLFilter<L[N]>;
	        openLevel?: boolean;
	    }): Promise<PartialCollectionValue<L[N]>[]>;
	    redraw(): Promise<void>;
	}
	//# sourceMappingURL=nested-grid-control-object.d.ts.map
}
declare module 'lib/component/ui/calendar-body/calendar-view-selector' {
	import * as React from 'react';
	import type { CalendarView } from 'lib/component/ui/calendar-body/calendar-body-types';
	export interface CalendarViewSelectorProps {
	    selectedView: CalendarView;
	    onSelectView: (view: CalendarView) => void;
	}
	export function CalendarViewSelector({ selectedView, onSelectView }: CalendarViewSelectorProps): React.ReactElement;
	//# sourceMappingURL=calendar-view-selector.d.ts.map
}
declare module 'lib/component/ui/filter/filters-component' {
	import * as React from 'react';
	import type { Filter } from 'lib/service/filter-service';
	import type { FilterManagerField } from 'lib/component/ui/filter/filter-manager';
	import type { FilterModel } from 'lib/component/field/table/table-component-types';
	export interface FilterCommonProps {
	    fields: FilterManagerField[];
	    filters: Filter[];
	    handleSave: (filters: Filter[]) => void;
	    isDisabled?: boolean;
	    screenId: string;
	}
	export function FiltersComponent({ filters, isDisabled, fields, screenId, handleSave, }: FilterCommonProps): React.ReactElement | null;
	interface FilterLabelProps extends FilterCommonProps {
	    isNavigationPanel?: boolean;
	    filters: Filter[] | FilterModel;
	}
	interface IPill {
	    labelKey: string;
	    pillKey: string;
	    removePill: Function;
	    text: string;
	}
	export const dateFilterNormalization: (filter: FilterModel) => string;
	export const filterModelToPills: (fields: FilterManagerField[], filters: FilterModel[], removingFn: Function) => IPill[];
	export function FiltersLabels({ fields, filters, isNavigationPanel, handleSave, }: FilterLabelProps): React.ReactElement | null;
	export {};
	//# sourceMappingURL=filters-component.d.ts.map
}
declare module 'lib/component/ui/icon/status-icon-with-popover' {
	import type { ReactNode } from 'react';
	import React from 'react';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { CarbonLinkEvent, ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	type StatusIconWithPopoverProps = {
	    screenId: string;
	    unFilterErrors?: Function;
	    filterErrors?: Function;
	    content: ReactNode;
	    validationErrors: ValidationResult[];
	    /** Indicate additional warning message, rendered as tooltip and blue border. */
	    infoMessage?: ValueOrCallbackWithFieldValue<ScreenBase, string>;
	    /** Indicate additional information, rendered as tooltip and orange border. */
	    warningMessage?: ValueOrCallbackWithFieldValue<ScreenBase, string>;
	};
	type StatusIconWithPopoverState = {
	    mode: Mode;
	    isOpen: boolean;
	};
	type Mode = 'DEFAULT' | 'ERRORS'; class StatusIconWithPopover extends React.Component<StatusIconWithPopoverProps, StatusIconWithPopoverState> {
	    private toolTipRef;
	    private triggerButtonRef;
	    private closeButtonRef;
	    constructor(props: StatusIconWithPopoverProps);
	    isVisible: () => boolean;
	    getDisplayErrorsButton: () => HTMLButtonElement | null | undefined;
	    close: () => void;
	    open: (ev?: CarbonLinkEvent) => void;
	    toggle: () => void;
	    setDefaultMode: () => Promise<void>;
	    setErrorsMode: () => Promise<void>;
	    getFilterButton: () => React.ReactNode;
	    render(): React.ReactNode;
	}
	export default StatusIconWithPopover;
	//# sourceMappingURL=status-icon-with-popover.d.ts.map
}
declare module 'lib/component/container/footer/bussiness-action-button-wrapper' {
	import * as React from 'react';
	export interface BusinessActionButtonWrapperProps {
	    id?: string;
	    title?: string;
	    children: React.ReactNode;
	}
	/** Adds classes and test ids to buttons so business-action-like buttons have the same selectors and style */
	export function BusinessActionButtonWrapper({ children, title, id, }: BusinessActionButtonWrapperProps): React.ReactElement;
	//# sourceMappingURL=bussiness-action-button-wrapper.d.ts.map
}
declare module 'lib/component/container/footer/business-action' {
	import * as React from 'react';
	import type { PageActionButtonType } from 'lib/component/control-objects';
	import type { IconType } from 'carbon-react/esm/components/icon';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	export interface BusinessActionExternalProps {
	    id?: string;
	    screenId: string;
	    defaultButtonType?: PageActionButtonType;
	    buttonTypeOverride?: PageActionButtonType;
	    isIconOnly?: boolean;
	    onClick?: () => void;
	    parentRef?: React.Ref<HTMLButtonElement>;
	    size?: 'small' | 'medium';
	    isSeparated?: boolean;
	    alwaysTriggerFieldEvent?: boolean;
	    skipWrapping?: boolean;
	    pendoId?: string;
	    title?: string;
	}
	export interface BusinessActionProps extends BusinessActionExternalProps {
	    isHidden?: boolean;
	    isDisabled?: boolean;
	    isDestructive?: boolean;
	    title?: string;
	    icon?: IconType;
	    helperText?: string;
	    buttonType?: PageActionButtonType;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface BusinessActionState {
	    tooltipShowing: boolean;
	}
	export class BusinessAction extends React.Component<BusinessActionProps, BusinessActionState> {
	    constructor(props: BusinessActionProps);
	    onClick: () => void;
	    setTooltipState: (tooltipShowing: boolean) => () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedBusinessAction: import("react-redux").ConnectedComponent<typeof BusinessAction, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<BusinessAction> | undefined;
	    id?: string | undefined;
	    screenId: string;
	    defaultButtonType?: PageActionButtonType;
	    buttonTypeOverride?: PageActionButtonType;
	    isIconOnly?: boolean | undefined;
	    onClick?: (() => void) | undefined;
	    parentRef?: React.Ref<HTMLButtonElement> | undefined;
	    size?: "small" | "medium" | undefined;
	    isSeparated?: boolean | undefined;
	    alwaysTriggerFieldEvent?: boolean | undefined;
	    skipWrapping?: boolean | undefined;
	    pendoId?: string | undefined;
	    title?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedBusinessAction;
	//# sourceMappingURL=business-action.d.ts.map
}
declare module 'lib/component/ui/table-shared/desktop-table-add-new-row-button' {
	import * as React from 'react';
	import type { PageActionControlObject } from 'lib/component/page-action/page-action-control-object';
	export interface DesktopTableAddNewRowButtonExternalProps {
	    addItemActions?: PageActionControlObject[];
	    elementId: string;
	    hasSidebar?: boolean;
	    isDisabled?: boolean;
	    level?: number;
	    onFocusPhantomRow?: () => void;
	    screenId: string;
	}
	export interface DesktopTableAddNewRowButtonProps extends DesktopTableAddNewRowButtonExternalProps {
	    openSidebar: (args: {
	        screenId: string;
	        elementId: string;
	        level?: number;
	    }) => void;
	}
	export const DesktopTableAddNewRowButton: React.NamedExoticComponent<DesktopTableAddNewRowButtonProps>;
	export const ConnectedDesktopTableAddNewRowButton: import("react-redux").ConnectedComponent<React.NamedExoticComponent<DesktopTableAddNewRowButtonProps>, {
	    addItemActions?: PageActionControlObject<import("../../../service/screen-base").ScreenBase<any, any>>[] | undefined;
	    elementId: string;
	    hasSidebar?: boolean | undefined;
	    isDisabled?: boolean | undefined;
	    level?: number | undefined;
	    onFocusPhantomRow?: (() => void) | undefined;
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=desktop-table-add-new-row-button.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-create-actions/table-create-actions' {
	import React from 'react';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValueOrCallback } from 'lib/utils/types';
	import type { PageActionControlObject } from 'lib/component/control-objects';
	export interface TableCreateActionsProps {
	    createActions: ValueOrCallback<ScreenBase, PageActionControlObject | PageActionControlObject[]> | undefined;
	    multiActionType: 'multi-action-button' | 'split-button';
	    screenId: string;
	    elementId: string;
	}
	export const TableCreateActions: React.FC<TableCreateActionsProps>;
	//# sourceMappingURL=table-create-actions.d.ts.map
}
declare module 'lib/service/dirty-state-service' {
	import type { XtremAppState } from 'lib/redux/state';
	import type { DialogControl } from 'lib/service/dialog-service';
	export const openDirtyPageConfirmationDialog: (screenId: string) => DialogControl;
	export const onPageDirtyChange: (state: XtremAppState, screenId: string, isDirty: boolean) => void;
	export const notifyConsumerAboutDirtyStatus: (state: XtremAppState, isDirty?: boolean) => Promise<void>;
	//# sourceMappingURL=dirty-state-service.d.ts.map
}
declare module 'lib/utils/lokijs-filter-transformer' {
	import type { Filter } from '@sage/xtrem-client';
	export const transformToLokiJsFilter: (target: Filter<any>) => Filter<any>;
	//# sourceMappingURL=lokijs-filter-transformer.d.ts.map
}
declare module 'lib/service/loki' {
	import lokijs from '@sage/lokijs';
	import type { ClientNode, ExtractEdgesPartial } from '@sage/xtrem-client';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { PartialCollectionValue, PartialCollectionValueWithIds } from 'lib/component/types';
	import type { CollectionGlobalValidationState, InternalValue, NormalizedCollection } from 'lib/service/collection-data-types';
	import type { ScreenBase } from 'lib/service/screen-base';
	type LokiOptions<T extends ClientNode = any> = {
	    dbKey?: string;
	    elementId: string;
	    initialValues: PartialCollectionValue<T>[];
	    isTransient: boolean;
	    screenId: string;
	};
	export const extendLokiOperators: () => void;
	export const destroyScreenCollections: (screenId: string, keepNavigationPanelDb?: boolean) => void;
	export class LokiDb<T extends ClientNode = any> implements NormalizedCollection<T> {
	    protected readonly collection: lokijs.Collection<InternalValue<T>>;
	    protected minId: number;
	    protected result: Resultset<InternalValue<T> & LokiObj> | null;
	    protected readonly screenId: string;
	    protected readonly elementId: string;
	    static getCollectionId(screenId: string, elementId: string, dbKey?: string): string;
	    constructor({ screenId, elementId, initialValues, isTransient, dbKey }: LokiOptions<T>);
	    static groupBy(input: any[], groupKey: string): any;
	    calculateAggregatedValue({ aggregationKey, aggregationMethod, ...findAllParams }: Parameters<NormalizedCollection<T>['calculateAggregatedValue']>[0]): number;
	    withTemporaryRecords<B>(body: (db: this) => B, temporaryRecords?: ExtractEdgesPartial<T>[]): B;
	    getCompositeKey({ _id, __level, __isGroup: isGroup, __groupKey: groupKey, __uncommitted, }: {
	        _id: string;
	        __level?: number;
	        __isGroup?: boolean;
	        __groupKey?: string;
	        __uncommitted?: boolean;
	    }): string;
	    getPathProperty(record: {
	        _id: string;
	        __level?: number;
	        __parentId?: string;
	        __uncommitted?: boolean;
	    }): string;
	    getIdAndLevelFromCompositeKey(compositeKey: string): {
	        _id: string;
	        __level?: number;
	    };
	    protected ensureResult(): void;
	    generateIndex(): string;
	    /** Prepare the collection information for server side processing. Generated IDs and LokJS flags removed */
	    exportDataForServerProcessing(): T[];
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: undefined;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): PartialCollectionValueWithIds<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: true;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): PartialCollectionValueWithIds<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: false;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: boolean;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T> | PartialCollectionValueWithIds<T>;
	    findAll({ level, parentId, where, includeUnloaded, includePhantom, isUncommitted, }?: Parameters<NormalizedCollection<T>['findAll']>[0]): this;
	    where(fun: (data: InternalValue<T> & LokiObj) => boolean): this;
	    clear(): this;
	    remove({ data, beforeRemove, afterRemove, }: Parameters<NormalizedCollection<T>['remove']>[0]): this;
	    sort({ columnDefinitions, orderBy, }: {
	        columnDefinitions: NestedField<ScreenBase, NestedFieldTypes, T, any>[];
	        orderBy?: Parameters<NormalizedCollection<T>['sort']>[0]['orderBy'];
	    }): this;
	    filter({ where, groupByKey }: Parameters<NormalizedCollection<T>['filter']>[0]): this;
	    update({ data, beforeUpdate, afterUpdate, cleanMetadata, }: Parameters<NormalizedCollection<T>['update']>[0]): InternalValue<T>;
	    getIdPathToRecordByIdAndLevel({ id, level, }: Parameters<NormalizedCollection<T>['getIdPathToRecordByIdAndLevel']>[0]): string[];
	    getIdPathToRecordByRecord(startRecord: {
	        _id: string;
	        __parentId?: string;
	        __level?: number;
	    }): string[];
	    createRecord({ data, level, dirty, action, beforeCreate, parentId, isUncommitted, }: Parameters<NormalizedCollection<T>['createRecord']>[0]): InternalValue<T>;
	    addRecord({ data, level, cleanMetadata, dirty, action, beforeInsert, afterInsert, parentId, isUncommitted, }: Parameters<NormalizedCollection<T>['addRecord']>[0]): any;
	    skip(offset: Parameters<NormalizedCollection<T>['skip']>[0]): this;
	    take(limit: Parameters<NormalizedCollection<T>['take']>[0]): this;
	    getAncestorIds({ id, level }: Parameters<NormalizedCollection<T>['getAncestorIds']>[0]): string[];
	    value({ cleanMetadata, cleanDatabaseMeta, }: {
	        cleanMetadata: true;
	        cleanDatabaseMeta?: boolean;
	    }): PartialCollectionValueWithIds<T>[];
	    value({ cleanMetadata, cleanDatabaseMeta, }: {
	        cleanMetadata: false;
	        cleanDatabaseMeta?: boolean;
	    }): InternalValue<T>[];
	    value({ cleanMetadata, cleanDatabaseMeta, }: {
	        cleanMetadata?: boolean;
	        cleanDatabaseMeta?: boolean;
	    }): PartialCollectionValueWithIds<T>[];
	    value(): PartialCollectionValueWithIds<T>[];
	    getValidationStateByColumn(levels: number): CollectionGlobalValidationState;
	    getAllServerRecordWithServerSideValidationIssues(): string[];
	    getInvalidLoadedRecords({ level, parentId, withoutServerErrors, includePhantom, }?: {
	        level?: number | null;
	        parentId?: string | null;
	        withoutServerErrors?: boolean;
	        includePhantom?: boolean;
	    }): this;
	    getInvalidUnloadedRecords({ level, parentId, withoutServerErrors, includePhantom, }?: {
	        level?: number | null;
	        parentId?: string | null;
	        withoutServerErrors?: boolean;
	        includePhantom?: boolean;
	    }): this;
	    getAllInvalidRecords({ level, parentId, includePhantom, }?: {
	        level?: number | null;
	        parentId?: string | null;
	        includePhantom?: boolean;
	    }): this;
	    isCollectionValid(): boolean;
	    isCollectionDirty(): boolean;
	    startRecordTransaction({ recordId, recordLevel, }: Parameters<NormalizedCollection<T>['startRecordTransaction']>[0]): void;
	    commitRecord({ recordId, recordLevel }: Parameters<NormalizedCollection<T>['commitRecord']>[0]): boolean;
	    cancelRecordTransaction({ recordId, recordLevel, }: Parameters<NormalizedCollection<T>['cancelRecordTransaction']>[0]): void;
	}
	export {};
	//# sourceMappingURL=loki.d.ts.map
}
declare module 'lib/redux/actions/node-type-actions' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppThunkDispatch } from 'lib/redux/action-types';
	import { ActionType } from 'lib/redux/action-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export const addNodeTypes: (types: Dict<any>) => {
	    type: ActionType.AddNodeTypes;
	    value: Dict<FormattedNodeDetails>;
	};
	export const fetchNodeTypes: (nodeName: string[], locale: string) => (dispatch: AppThunkDispatch) => Promise<void>;
	//# sourceMappingURL=node-type-actions.d.ts.map
}
declare module 'lib/component/field/checkbox/checkbox-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { CheckboxDecoratorProperties } from 'lib/component/field/checkbox/checkbox-types';
	/**
	 * Initializes the decorated member as a [Checkbox]{@link CheckboxControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Checkbox]{@link CheckboxControlObject} field will be initialized with
	 */
	export function checkboxField<T extends ScreenExtension<T>>(properties: CheckboxDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function checkboxFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<CheckboxDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
	//# sourceMappingURL=checkbox-decorator.d.ts.map
}
declare module 'lib/component/field/date/date-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { DateDecoratorProperties } from 'lib/component/field/date/date-types';
	/**
	 * Initializes the decorated member as a [Date]{@link DateControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Date]{@link DateControlObject} field will be initialized with
	 */
	export function dateField<T extends ScreenExtension<T>>(properties: DateDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function dateFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<DateDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
	//# sourceMappingURL=date-decorator.d.ts.map
}
declare module 'lib/component/field/multi-dropdown/multi-dropdown-types' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, ExtensionField, HasParent, HasSound, Mappable, Nested, NestedChangeable, NestedClickable, NestedValidatable, Sizable, Validatable, MinItems, MaxItems, NestedMinItems, NestedMaxItems, Clickable, HasIcon, HasOptions, HasPlaceholder, Postfixable, Prefixable } from 'lib/component/field/traits';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject } from 'lib/component/container/container-control-objects';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenExtension } from 'lib/types';
	import type { Extend } from 'lib/service/page-extension';
	export interface MultiDropdownProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, Clickable<CT>, HasIcon, HasPlaceholder, HasOptions<CT>, HasSound<CT>, Mappable<CT>, Postfixable<CT>, Prefixable<CT>, Sizable, MinItems<CT>, MaxItems<CT> {
	}
	export interface MultiDropdownDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<MultiDropdownProperties<CT>, '_controlObjectType'>, Changeable<CT>, HasParent<CT, BlockControlObject<CT>>, HasSound<CT>, Mappable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable, Validatable<CT, string[]>, MinItems<CT>, MaxItems<CT> {
	}
	type NestedUnionType = 'bind' | 'onClick' | 'minItems' | 'maxItems';
	export interface NestedMultiDropdownProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<MultiDropdownProperties<CT, ContextNodeType>, NestedUnionType>, Nested<ContextNodeType>, NestedChangeable<CT>, NestedClickable<CT>, NestedValidatable<CT, string[], ContextNodeType>, Sizable, NestedMinItems<CT>, NestedMaxItems<CT> {
	}
	export type MultiDropdownExtensionDecoratorProperties<T extends ScreenExtension<T>> = ChangeableOverrideDecoratorProperties<MultiDropdownDecoratorProperties<Extend<T>>, T>;
	export interface MultiDropdownInternalProps {
	    enumOptions?: string[];
	    localizedOptions?: Dict<string>;
	    screenId: string;
	    value?: string[];
	}
	export type MultiDropdownComponentProps = BaseEditableComponentProperties<MultiDropdownDecoratorProperties, string[], MultiDropdownInternalProps & NestedFieldsAdditionalProperties>;
	export {};
	//# sourceMappingURL=multi-dropdown-types.d.ts.map
}
declare module 'lib/component/field/multi-dropdown/multi-dropdown-decorator' {
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { MultiDropdownDecoratorProperties, MultiDropdownExtensionDecoratorProperties } from 'lib/component/field/multi-dropdown/multi-dropdown-types';
	/**
	 * Initializes the decorated member as a [MultiDropdown]{@link MultiDropdownControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [MultiDropdown]{@link MultiDropdownControlObject} field will be initialized with
	 */
	export function multiDropdownField<T extends ScreenExtension<T>>(properties: MultiDropdownDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function multiDropdownFieldOverride<T extends ScreenExtension<T>>(properties: MultiDropdownExtensionDecoratorProperties<T>): (target: T, name: string) => void;
	//# sourceMappingURL=multi-dropdown-decorator.d.ts.map
}
declare module 'lib/component/field/numeric/numeric-types' {
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedClickable, NestedValidatable, Sizable, Validatable, HasIcon, HasPlaceholder, HasScale, Postfixable, Prefixable, HasInputValueChangeListener, HasMaxMin, NestedGroupAggregations } from 'lib/component/field/traits';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { ValueOrCallbackWitRecordValue, ValueOrCallback } from 'lib/utils/types';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	export interface NumericProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, HasIcon, HasPlaceholder, HasScale<CT, ContextNodeType>, HasMaxMin<CT>, Postfixable<CT>, Prefixable<CT>, Sizable {
	    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
	    isNotZero?: ValueOrCallback<CT, boolean>;
	}
	export interface NumericDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<NumericProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasInputValueChangeListener<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT, number> {
	}
	export interface NestedNumericProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<NumericProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, NestedClickable<CT>, Nested<ContextNodeType>, NestedGroupAggregations, Sizable, NestedValidatable<CT, number, ContextNodeType> {
	    isTableReadOnly?: boolean;
	    /** The maximum value allowed for the numeric field */
	    max?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
	    /** The minimum value allowed for the numeric field */
	    min?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
	    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
	    isNotZero?: ValueOrCallbackWitRecordValue<CT, boolean, ContextNodeType>;
	}
	export type NumericComponentProps = BaseEditableComponentProperties<NumericProperties, number, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=numeric-types.d.ts.map
}
declare module 'lib/component/field/numeric/numeric-decorator' {
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { NumericDecoratorProperties } from 'lib/component/field/numeric/numeric-types';
	/**
	 * Initializes the decorated member as a [Numeric]{@link NumericControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Numeric]{@link NumericControlObject} field will be initialized with
	 */
	export function numericField<T extends ScreenExtension<T>>(properties: NumericDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function numericFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<NumericDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
	//# sourceMappingURL=numeric-decorator.d.ts.map
}
declare module 'lib/component/field/select/select-decorator' {
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { SelectDecoratorProperties, SelectExtensionDecoratorProperties } from 'lib/component/field/select/select-types';
	/**
	 * Initializes the decorated member as a [Select]{@link SelectControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Select]{@link SelectControlObject} field will be initialized with
	 */
	export function selectField<T extends ScreenExtension<T>>(properties: SelectDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function selectFieldOverride<T extends ScreenExtension<T>>(properties: SelectExtensionDecoratorProperties<T>): (target: T, name: string) => void;
	//# sourceMappingURL=select-decorator.d.ts.map
}
declare module 'lib/component/field/switch/switch-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { CellProps } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedClickable, NestedValidatable, Validatable } from 'lib/component/field/traits';
	export interface SwitchCellRendererProps extends CellProps<NestedSwitchProperties> {
	    onChange: (value: boolean) => void;
	}
	export interface SwitchProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends Omit<EditableFieldProperties<CT, ContextNodeType>, 'isMandatory'> {
	    size?: 'small' | 'large';
	    titleHelp?: string;
	}
	export interface SwitchDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<SwitchProperties<CT, void>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, Validatable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export interface NestedSwitchProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<SwitchProperties<CT, ContextNodeType>, 'bind'>, Nested<ContextNodeType>, NestedChangeable<CT>, NestedValidatable<CT, boolean, ContextNodeType>, NestedClickable<CT> {
	}
	export type SwitchComponentProps = BaseEditableComponentProperties<SwitchDecoratorProperties<any>, boolean, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=switch-types.d.ts.map
}
declare module 'lib/component/field/switch/switch-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { SwitchDecoratorProperties } from 'lib/component/field/switch/switch-types';
	export { NestedSwitchProperties } from 'lib/component/field/switch/switch-types';
	/**
	 * Initializes the decorated member as a [Switch]{@link SwitchControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Switch]{@link SwitchControlObject} field will be initialized with
	 */
	export function switchField<T extends ScreenExtension<T>>(properties: SwitchDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function switchFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<SwitchDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
	//# sourceMappingURL=switch-decorator.d.ts.map
}
declare module 'lib/component/field/text/text-types' {
	import type { BaseErrorableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasInputValueChangeListener, HasParent, Nested, NestedChangeable, NestedClickable, NestedValidatable, Validatable, HasIcon, HasPlaceholder, Postfixable, Prefixable, Sizable, HasMaxMinLength, NestedGroupAggregations } from 'lib/component/field/traits';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValueOrCallbackWitRecordValue } from 'lib/utils/types';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	export interface TextProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT>, HasIcon, HasPlaceholder, Postfixable<CT>, Prefixable<CT>, HasMaxMinLength<CT>, Sizable {
	    /** Set text field to be password */
	    isPassword?: boolean;
	}
	export interface TextDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<TextProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasInputValueChangeListener<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT, string> {
	}
	export interface NestedTextProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<TextProperties<CT>, 'bind'>, NestedChangeable<CT>, NestedClickable<CT>, NestedGroupAggregations<'min' | 'max' | 'distinctCount'>, Nested<ContextNodeType>, Sizable, NestedValidatable<CT, string, ContextNodeType> {
	    isTableReadOnly?: boolean;
	    /** The maximum length of the text field value */
	    maxLength?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
	    /** The minimum length of the text field value */
	    minLength?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
	}
	export type TextComponentProps = BaseErrorableComponentProperties<TextProperties, string, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=text-types.d.ts.map
}
declare module 'lib/component/field/text/text-decorator' {
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { TextDecoratorProperties } from 'lib/component/field/text/text-types';
	/**
	 * Initializes the decorated member as a [Text]{@link TextControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Text]{@link TextControlObject} field will be initialized with
	 */
	export function textField<T extends ScreenExtension<T>>(properties: TextDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function textFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<TextDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
	//# sourceMappingURL=text-decorator.d.ts.map
}
declare module 'lib/service/customization-service' {
	/**
	 * This service updates the page definitions to include user defined custom fields, which are loaded to the product
	 * from the `customFields` page metadata property
	 */
	import { type Dict, type MetaCustomField } from '@sage/xtrem-shared';
	import type { NestedField } from 'lib/component/nested-fields';
	import type { ComponentKey } from 'lib/component/types';
	import type { Constructible } from 'lib/types';
	import type { Page } from 'lib/service/page';
	import type { PageMetadata } from 'lib/service/page-metadata';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export const addCustomFieldsToPageBody: (nodeTypes: Dict<FormattedNodeDetails>, pageMetadata: PageMetadata, pageConstructor: Constructible<Page>) => void;
	export const componentsWithLookup: ComponentKey[];
	export const addCustomColumnToNestedFields: (contextNode: string, nodeTypes: Dict<FormattedNodeDetails>, currentNestedFields: NestedField<any, any>[], elementId: string, componentType: ComponentKey, onlyInsertIfFound: boolean, customFields?: Dict<MetaCustomField[]>) => void;
	export const getCustomFields: (contextNode: string, nodeTypes: Dict<FormattedNodeDetails>, currentNestedFields: NestedField<any, any>[], elementId: string, componentType: ComponentKey, customFields?: Dict<MetaCustomField[]>, onlyInsertIfFound?: boolean) => NestedField<any, any>[];
	export const isCustomFieldReadOnly: (nodeTypes: Dict<FormattedNodeDetails>, nodeName: string, bind: string) => boolean;
	export function calculateDeepPaths(propertyPath: string): {
	    subpath: string[];
	    selectorSegments: string[];
	    mainSegments: string[];
	    alias: string;
	};
	//# sourceMappingURL=customization-service.d.ts.map
}
declare module 'lib/component/abstract-decorator-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { PageMetadata } from 'lib/service/page-metadata';
	import type { ExtensionLevel, Level } from 'lib/component/field/nested-grid/nested-grid-component-types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { SidebarSectionDefinition } from 'lib/component/table-sidebar/table-sidebar-types';
	import type { ComponentKey, DecoratorProperties } from 'lib/component/types';
	export const findColumnIndex: (columns: NestedField<any, NestedFieldTypes>[], match: string) => number;
	export const insertColumn: (columns: NestedField<any, any>[], column: NestedExtensionField<any, any>, override?: boolean, onlyInsertIfFound?: boolean) => void;
	/**
	 * It merges the custom fields into the sidePanelLayout and returns a copy with the custom fields on it
	 */
	export const mergeIntoSidebarLayout: (sidePanelLayout: Dict<SidebarSectionDefinition>, customFields: NestedExtensionField<any, any>[]) => Dict<SidebarSectionDefinition>;
	/**
	 * It merges the columns defined by the base page and the columns provided by the extension.
	 *  */
	export const mergeColumnPropertyDefinitions: <T extends NestedFieldTypes = NestedFieldTypes>(currentColumns?: NestedField<any, T>[], columnExtensions?: NestedExtensionField<any, T>[]) => NestedField<any, T>[];
	export const overrideColumnPropertyDefinitions: <T extends NestedFieldTypes = NestedFieldTypes>(currentColumns?: NestedField<any, T>[], columnOverrides?: NestedOverrideField<any, T>[]) => NestedField<any, T>[];
	/** Merge the level definition of existing levels */
	export const mergeLevelPropertyDefinition: (currentLevels?: Level<any, any>[], levelExtensions?: ExtensionLevel<any>[]) => Level<any, any>[];
	export const overrideExtendedProperties: <T extends ComponentKey>(nodeTypes: Dict<FormattedNodeDetails>, elementId: string, pageMetadata: PageMetadata, properties: DecoratorProperties<T>, componentType: ComponentKey) => DecoratorProperties<T>;
	//# sourceMappingURL=abstract-decorator-utils.d.ts.map
}
declare module 'lib/render/responsive-breakpoints' {
	export interface Breakpoints {
	    xs: number;
	    s: number;
	    m: number;
	    l: number;
	}
	export const breakpoints: Breakpoints;
	//# sourceMappingURL=responsive-breakpoints.d.ts.map
}
declare module 'lib/utils/responsive-utils' {
	import type { DialogSizes } from 'carbon-react/esm/components/dialog/dialog.config';
	import type { ComponentKey, ContainerWidth, FieldWidth } from 'lib/component/types';
	import type { ReduxResponsive, ResponsiveTypes } from 'lib/redux/state';
	import type { Breakpoints } from 'lib/render/responsive-breakpoints';
	export interface ScreenSize extends Breakpoints {
	    infinity: number;
	}
	export const DEFAULT_FIELD_SIZE: number;
	export const COLUMN_COUNT_HELPER_PANEL: number;
	export const COLUMN_COUNT_PAGE_BODY: ScreenSize;
	export const MARGIN_SIZE_PAGE_BODY: ScreenSize;
	export const GUTTER_SIZE_PAGE_BODY: ScreenSize;
	export const FIELD_SIZE: {
	    'extra-large': ScreenSize;
	    large: ScreenSize;
	    medium: ScreenSize;
	    small: ScreenSize;
	};
	export enum CONTAINER_SIZE_NAMING {
	    extraLarge = "extra-large",
	    large = "large",
	    medium = "medium",
	    small = "small",
	    extraSmall = "extra-small"
	}
	export const CONTAINER_SIZE: {
	    [key in CONTAINER_SIZE_NAMING]: ScreenSize;
	};
	export const getPageBodyColumnCount: (is: ResponsiveTypes) => number;
	export const getPageBodyMarginSize: (is: ResponsiveTypes) => number;
	export const getGutterSize: (is: ResponsiveTypes) => number;
	export const calculateContainerWidth: (is: ResponsiveTypes, availableColumnNum: number, setContainerWidth?: ContainerWidth) => any;
	export const calculateFieldWidth: (is: ResponsiveTypes, fieldType: ComponentKey, availableColumnNum?: number, isFieldFullWidth?: boolean, setFieldNum?: FieldWidth) => number;
	export const getMaxDialogSize: (browser: ReduxResponsive) => DialogSizes;
	//# sourceMappingURL=responsive-utils.d.ts.map
}
declare module 'lib/component/field/visual-process/visual-process-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface VisualProcessProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    /** The value of the height attribute. Minimum height should be at least the height of the top edit panel and a line.  */
	    height?: string;
	}
	export interface VisualProcessDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<VisualProcessProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export type VisualProcessComponentProperties = BaseEditableComponentProperties<VisualProcessDecoratorProperties, {
	    value: string;
	}>;
	//# sourceMappingURL=visual-process-types.d.ts.map
}
declare module 'lib/utils/vp-utils' {
	export const resolveImageUrl: (collectionId: string, resourceId: string) => string;
	//# sourceMappingURL=vp-utils.d.ts.map
}
declare module 'lib/service/visual-process-service' {
	import type { XLinkProps } from '@sage/visual-process-editor';
	import type { ReferenceDecoratorProperties } from 'lib/component/field/reference/reference-types';
	import { CollectionValue } from 'lib/service/collection-data-service';
	export const executeVisualProcessLink: (screenId: string, xlinkProps: XLinkProps) => void;
	export const getVisualProcessPageLookupProperties: () => ReferenceDecoratorProperties;
	export const getPageLookupDialogCollectionValue: (screenId: string, elementId: string) => Promise<CollectionValue>;
	//# sourceMappingURL=visual-process-service.d.ts.map
}
declare module 'lib/component/field/visual-process/visual-process-component' {
	import type { ConsumerDataRequestResult } from '@sage/visual-process-editor';
	import * as React from 'react';
	import type { VisualProcessProperties } from 'lib/component/control-objects';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	export interface VisualProcessComponentState {
	    lookupDialogPageResultCallback?: (result: ConsumerDataRequestResult) => void;
	    lookupDialogPageValue?: CollectionValue;
	}
	export class VisualProcessComponent extends EditableFieldBaseComponent<VisualProcessProperties, {
	    value: string;
	}, {}, VisualProcessComponentState> {
	    private readonly onChange;
	    private readonly onLinkClick;
	    private readonly onGetData;
	    private readonly onPageLookupDialogSelected;
	    readonly closeLookupDialog: () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedVisualProcessComponent: import("react-redux").ConnectedComponent<typeof VisualProcessComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<VisualProcessComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedVisualProcessComponent;
	//# sourceMappingURL=visual-process-component.d.ts.map
}
declare module 'lib/component/field/visual-process/async-visual-process-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { VisualProcessComponentProperties } from 'lib/component/field/visual-process/visual-process-types';
	export function AsyncConnectedVisualProcessComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncVisualProcessComponent(props: VisualProcessComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-visual-process-component.d.ts.map
}
declare module 'lib/redux/actions/focus-actions' {
	import type { AppAction } from 'lib/redux/action-types';
	export const setFocusPosition: (screenId: string, elementId: string, row?: string, nestedField?: string) => AppAction;
	export const emptyFocusPosition: () => AppAction;
	//# sourceMappingURL=focus-actions.d.ts.map
}
declare module 'lib/component/abstract-decorator' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import { type PageMetadata } from 'lib/service/page-metadata';
	import type { ComponentKey, ControlObjectConstructor, ControlObjectConstructorProps, ControlObjectInstance, DecoratorProperties, DecoratorTarget, LayoutBuilder, LayoutContent, MetadataProps } from 'lib/component/types';
	export class AbstractDecorator<T extends ComponentKey> {
	    protected target: DecoratorTarget<T>;
	    protected elementId: string;
	    protected _metadataProps: MetadataProps<T>;
	    protected componentType: T;
	    protected nodeTypes: Dict<FormattedNodeDetails>;
	    protected dataTypes: Dict<DataTypeDetails>;
	    protected _controlObjectConstructorProps: Partial<ControlObjectConstructorProps<T>>;
	    protected _layout: new (target: DecoratorTarget<T>, elementId: string, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, props: MetadataProps<T>) => LayoutBuilder<T>;
	    protected _controlObjectConstructor: ControlObjectConstructor<T>;
	    protected layoutBuilder: LayoutBuilder<T>;
	    protected controlObjectInstance: ControlObjectInstance<T>;
	    constructor(target: DecoratorTarget<T>, elementId: string, _metadataProps: MetadataProps<T>, componentType: T, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, _controlObjectConstructorProps: Partial<ControlObjectConstructorProps<T>>);
	    build: () => this;
	    private getScreenId;
	    protected readonly buildLayout: () => this;
	    protected readonly buildActions: () => this;
	    protected readonly buildControlObject: () => this;
	    protected readonly buildMetadata: () => this;
	    private readonly setTarget;
	    protected getPageMetadata(): PageMetadata;
	    private readonly setControlObject;
	    protected setUiComponentProperties(dataTypeDefaults?: Partial<DecoratorProperties<T>>): this;
	    get layout(): LayoutContent<T>;
	    get controlObject(): AbstractDecorator<T>['controlObjectInstance'];
	}
	//# sourceMappingURL=abstract-decorator.d.ts.map
}
declare module 'lib/component/container/block/block-layout' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { ContainerKey } from 'lib/component/types';
	export class BlockLayout extends AbstractLayoutBuilder<ContainerKey.Block> {
	    buildLayout: () => this;
	}
	//# sourceMappingURL=block-layout.d.ts.map
}
declare module 'lib/component/container/detail-panel/detail-panel-layout' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { DetailPanelDecoratorProperties } from 'lib/component/decorator-properties';
	import type { ContainerKey, DecoratorTarget, MetadataProps } from 'lib/component/types';
	import { AbstractLayoutBuilder } from 'lib/component/container/layouts';
	export interface IDetailPanelLayout {
	    detailPanelHeader: DetailPanelDecoratorProperties['header'];
	    detailPanelSections: DetailPanelDecoratorProperties['sections'];
	}
	export class DetailPanelLayout extends AbstractLayoutBuilder<ContainerKey.DetailPanel> implements IDetailPanelLayout {
	    target: DecoratorTarget<ContainerKey.DetailPanel>;
	    elementId: string;
	    detailPanelHeader: IDetailPanelLayout['detailPanelHeader'];
	    detailPanelSections: IDetailPanelLayout['detailPanelSections'];
	    detailPanelSectionsLayout: Partial<PageArticleItem>[];
	    detailPanelHeaderLayout: Partial<PageArticleItem>;
	    constructor(target: DecoratorTarget<ContainerKey.DetailPanel>, elementId: string, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, props: IDetailPanelLayout & MetadataProps<ContainerKey.DetailPanel>);
	    buildLayout: () => this;
	}
	//# sourceMappingURL=detail-panel-layout.d.ts.map
}
declare module 'lib/component/container/grid-row-block/grid-row-block-layout' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { ContainerKey } from 'lib/component/types';
	export class GridRowBlockLayout extends AbstractLayoutBuilder<ContainerKey.GridRowBlock> {
	    buildLayout: () => this;
	}
	//# sourceMappingURL=grid-row-block-layout.d.ts.map
}
declare module 'lib/component/container/page/page-layout' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { ContainerKey } from 'lib/component/types';
	export interface IPageLayout {
	    populateBlocks: () => PageLayout;
	    populateSections: () => PageLayout;
	}
	export class PageLayout extends AbstractLayoutBuilder<ContainerKey.Page> implements IPageLayout {
	    buildLayout: () => this;
	    populateFields: () => this;
	    populateBlocks: () => this;
	    populateSections: () => this;
	}
	//# sourceMappingURL=page-layout.d.ts.map
}
declare module 'lib/component/container/section/section-layout' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { ContainerKey } from 'lib/component/types';
	export class SectionLayout extends AbstractLayoutBuilder<ContainerKey.Section> {
	    buildLayout: () => this;
	}
	//# sourceMappingURL=section-layout.d.ts.map
}
declare module 'lib/component/container/sticker/sticker-layout' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { ContainerKey } from 'lib/component/types';
	export class StickerLayout extends AbstractLayoutBuilder<ContainerKey.Sticker> {
	    buildLayout: () => this;
	    populateFields: () => this;
	    populateBlocks: () => this;
	    populateSections: () => this;
	}
	//# sourceMappingURL=sticker-layout.d.ts.map
}
declare module 'lib/component/container/tile/tile-layout' {
	import { AbstractLayoutBuilder } from 'lib/component/abstract-layout-builder';
	import type { ContainerKey } from 'lib/component/types';
	export class TileLayout extends AbstractLayoutBuilder<ContainerKey.Tile> {
	    buildLayout: () => this;
	}
	//# sourceMappingURL=tile-layout.d.ts.map
}
declare module 'lib/component/container/layouts' {
	export * from 'lib/component/abstract-layout-builder';
	export * from 'lib/component/container/block/block-layout';
	export * from 'lib/component/container/detail-panel/detail-panel-layout';
	export * from 'lib/component/container/grid-row-block/grid-row-block-layout';
	export * from 'lib/component/container/page/page-layout';
	export * from 'lib/component/container/section/section-layout';
	export * from 'lib/component/container/sticker/sticker-layout';
	export * from 'lib/component/container/tile/tile-layout';
	//# sourceMappingURL=layouts.d.ts.map
}
declare module 'lib/component/container/block/block-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { BlockProperties, SectionControlObject } from 'lib/component/control-objects';
	import { BlockControlObject } from 'lib/component/control-objects';
	import type { ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface BlockDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<BlockProperties<CT>, '_controlObjectType'>, HasParent<CT, SectionControlObject<CT>>, ExtensionField<CT, BlockControlObject<CT>> {
	}
	/**
	 * Initializes the decorated member as a [Block]{@link BlockControlObject} container with the provided properties
	 *
	 * @param properties The properties that the [Block]{@link BlockControlObject} container will be initialized with
	 */
	export function block<CT extends ScreenExtension<CT>>(properties: BlockDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
	//# sourceMappingURL=block-decorator.d.ts.map
}
declare module 'lib/component/field/multi-file-deposit/multi-file-deposit-types' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { CancelTokenSource } from 'axios';
	import type { MarkRequired } from 'ts-essentials';
	import type { OnTelemetryEventFunction, ReduxResponsive } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { GraphQLApi } from 'lib/service/graphql-api';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { NestedRecordId, ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { SectionControlObject } from 'lib/component/container/container-control-objects';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { NestedFieldTypes, PodNestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { AttachmentAssociation, FieldControlObjectInstance } from 'lib/component/types';
	import type { CollectionValueFieldProperties } from 'lib/component/field/collection-value-field';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { CanBeReadOnly, Changeable, Clickable, ExtensionField, HasCollectionSelectionEventHandlers, HasCollectionSelectionEventHandlersAfter, HasParent } from 'lib/component/field/traits';
	import type { AccessBindings } from 'lib/service/page-definition';
	export interface MultiFileDepositProperties<CT extends ScreenBase = ScreenBase> extends MarkRequired<CollectionValueFieldProperties<CT, AttachmentAssociation>, 'node'>, CanBeReadOnly<CT, any> {
	    /** Whether the add button is displayed. If set to true, an extra empty pod is rendered at the end of the list. Defaults to false */
	    canAddRecord?: boolean;
	    /** Whether the remove icon is displayed on each pod on the top-right corner. */
	    canRemoveRecord?: boolean;
	    /** Selected rows identifiers */
	    selectedRecords?: NestedRecordId[];
	}
	export interface MultiFileDepositDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<MultiFileDepositProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasCollectionSelectionEventHandlers<CT, AttachmentAssociation>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
	    /** File types that can be uploaded. Can be either audio/*, video/*, image/*, an extension name starting with '.'
	     *  or a valid media type. Look at [IANA Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). for a complete list of standard media types.
	     * It is possible to set more than one file type, simply by defining them separated by a comma.
	     */
	    fileTypes?: string;
	    /** The GraphQL node that the represents the attachment object */
	    attachmentNode: keyof ScreenBaseGenericType<CT>;
	    /** Whether the user can decide which nested grid columns to display. Defaults to true */
	    canUserHideColumns?: boolean;
	}
	type BaseMultiFileDepositExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase> = HasCollectionSelectionEventHandlersAfter<CT, AttachmentAssociation>;
	export interface MultiFileDepositExtensionDecoratorProperties<CT extends ScreenExtension<CT>> extends BaseMultiFileDepositExtensionDecoratorProperties<Extend<CT>>, ChangeableOverrideDecoratorProperties<MultiFileDepositDecoratorProperties<Extend<CT>>, CT> {
	    columns?: NestedExtensionField<CT, PodNestedFieldTypes, AttachmentAssociation>[];
	    /** Allows overriding existing column properties in the base page's columns */
	    columnOverrides?: NestedOverrideField<CT, NestedFieldTypes, AttachmentAssociation>[];
	}
	export interface MultiFileDepositComponentAdditionalProperties {
	    accessBindings: AccessBindings;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    dataTypes: Dict<DataTypeDetails>;
	    enumTypes: Dict<string[]>;
	    graphApi: GraphQLApi<any>;
	    browser: ReduxResponsive;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export type MultiFileDepositComponentProperties = BaseEditableComponentProperties<MultiFileDepositDecoratorProperties, CollectionValue<AttachmentAssociation>> & MultiFileDepositComponentAdditionalProperties;
	export type WithCancelToken<T> = T & {
	    cancelTokenSource?: CancelTokenSource;
	};
	export {};
	//# sourceMappingURL=multi-file-deposit-types.d.ts.map
}
declare module 'lib/component/field/multi-file-deposit/multi-file-deposit-decorator' {
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { MultiFileDepositDecoratorProperties, MultiFileDepositExtensionDecoratorProperties } from 'lib/component/field/multi-file-deposit/multi-file-deposit-types';
	/**
	 * Initializes the decorated member as a [MultiFileDeposit]{@link MultiFileDepositControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [MultiFileDeposit]{@link MultiFileDepositControlObject} field will be initialized with
	 */
	export function multiFileDepositField<T extends ScreenExtension<T>>(properties: MultiFileDepositDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function multiFileDepositFieldOverride<T extends ScreenExtension<T>>(properties: MultiFileDepositExtensionDecoratorProperties<T>): (target: T, name: string) => void;
	//# sourceMappingURL=multi-file-deposit-decorator.d.ts.map
}
declare module 'lib/utils/attachment-utils' {
	import type { PageMetadata } from 'lib/service/page-metadata';
	import type { AttachmentInformation } from 'lib/service/node-information-service';
	import type { Page } from 'lib/service/page';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import { type Dict } from '@sage/xtrem-shared';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export const getAttachmentInformation: (nodeName: string, nodeTypes: Dict<FormattedNodeDetails>) => AttachmentInformation | null;
	export interface PageWithAttachmentElements extends Page {
	    $attachmentBlock: BlockControlObject;
	}
	export function addAttachmentElements(pageMetadata: PageMetadata, attachmentInformation: AttachmentInformation): void;
	//# sourceMappingURL=attachment-utils.d.ts.map
}
declare module 'lib/component/container/page/standard-page-actions' {
	import type { PageActionDecoratorProperties } from 'lib/component/decorators';
	export const remove: () => PageActionDecoratorProperties<any>;
	export const save: () => PageActionDecoratorProperties<any>;
	export const confirmDialog: () => PageActionDecoratorProperties<any>;
	export const duplicate: () => PageActionDecoratorProperties<any>;
	export const executeDuplication: () => PageActionDecoratorProperties<any>;
	export const openAttachmentsDialog: () => PageActionDecoratorProperties<any>;
	export const create: () => PageActionDecoratorProperties<any>;
	export const cancel: () => PageActionDecoratorProperties<any>;
	export const openCustomizationPageWizard: () => PageActionDecoratorProperties<any>;
	export const openRecordHistory: () => PageActionDecoratorProperties<any>;
	//# sourceMappingURL=standard-page-actions.d.ts.map
}
declare module 'lib/component/container/page/page-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { RootMenuItem, SubMenuItem } from '@sage/xtrem-shared';
	import type { Page } from 'lib/service/page';
	import type { Constructible, PageExtension } from 'lib/types';
	import { AbstractDecorator } from 'lib/component/abstract-decorator';
	import { PageControlObject } from 'lib/component/control-objects';
	import type { LabelControlObject } from 'lib/component/control-objects';
	import type { VoidPromise } from 'lib/component/field/traits';
	import type { PageCategory } from 'lib/component/types';
	import { ContainerKey } from 'lib/component/types';
	import { PageLayout } from 'lib/component/container/layouts';
	import type { IdFieldType, PageProperties } from 'lib/component/container/page/page-types';
	import type { ValueOrCallback } from 'lib/utils/types';
	export interface PageDecoratorProperties<CT extends PageExtension<CT>, NodeType extends ClientNode = any> extends PageProperties<CT, NodeType> {
	    /** Function code corresponding to the page */
	    authorizationCode?: string;
	    /**
	     * Metadata field for organizing pages. It should only be used for ADC, in Xtrem, the the `menuItem` should be used
	     * instead.
	     * */
	    category?: PageCategory;
	    /** Menu item that the page belongs to on the navigation menu */
	    menuItem?: SubMenuItem | RootMenuItem;
	    /** Priority that determines the order of the elements in its category on the navigation panel. */
	    priority?: number;
	    /**
	     *  Module the page belongs to
	     * @deprecated it used to be used in X3, no longer relevant
	     * */
	    module?: string;
	    /** Function that will be executed immediately after the page has been loaded */
	    onLoad?: (this: CT) => VoidPromise;
	    /** Function that will be executed immediately before the page closes */
	    onClose?: (this: CT, isWizardFinished?: boolean) => VoidPromise;
	    /** Callback which is triggered when the dirty status of the page changes */
	    onDirtyStateUpdated?: (this: CT, isDirty: boolean) => void;
	    /** Subtitle displayed along with the page's title */
	    subtitle?: string;
	    /** If set, the confirmation dialog is not displayed when the user navigates away from the page */
	    skipDirtyCheck?: boolean;
	    /**
	     * Singular name of the object that the page represents. It is displayed above the page title like the `subtitle`.
	     * If both `objectTypeSingular` and `subtitle` is defined, then `objectTypeSingular` takes precedence over `the `subtitle` on the full width navigation panel.
	     */
	    objectTypeSingular?: string;
	    /**
	     * Plural name of the object that the page represents. It is used in the navigation panel and in error messages.
	     * If both `objectTypePlural` and `title` is defined, then `objectTypePlural` takes precedence over `title` on the full width navigation panel.
	     * */
	    objectTypePlural?: string;
	    /** Callback function that can return a field instance or a string. If a non-falsy value or field instance is returned, its value is displayed in place of the title */
	    idField?: (this: CT) => IdFieldType<CT>;
	    /** Callback function that can return a label field from the class body. The label field is placed next to the page or record title. */
	    headerLabel?: (this: CT) => LabelControlObject<any, CT>;
	    /**
	     * Callback function which returns a path that can be used as the parent page in the page hierarchy.
	     * If this decorator property is defined, then we will display a back arrow icon.
	     * This icon is placed before the page title, or before the record navigation arrows if present.
	     * */
	    hierarchyParentPage?: (this: CT) => string;
	    /**
	     * Enables a object specific dashboard option on the page.
	     */
	    has360View?: ValueOrCallback<CT, boolean>;
	    /** Function that will be executed when the user switches between page mode and 360 view mode */
	    on360ViewSwitched?: (this: CT, is360ViewOn: boolean) => void;
	}
	export class PageDecorator extends AbstractDecorator<ContainerKey.Page> {
	    protected _layout: typeof PageLayout;
	    protected _controlObjectConstructor: typeof PageControlObject;
	    protected readonly buildActions: () => this;
	    protected setUiComponentProperties: () => this;
	    private readonly getNavigationPanelProps;
	}
	/**
	 * Initializes the decorated member as a [Page]{@link PageControlObject} container with the provided properties
	 *
	 * @param properties The properties that the [Page]{@link PageControlObject} container will be initialized with
	 */
	export function page<CT extends PageExtension<CT>, NodeType extends ClientNode = any>(properties: PageDecoratorProperties<CT, NodeType>): (ctor: Constructible<Page>) => void;
	//# sourceMappingURL=page-decorator.d.ts.map
}
declare module 'lib/redux/actions/dirty-state-actions' {
	import type { AppThunkDispatch } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state';
	export const setFieldDirty: ({ screenId, elementId }: {
	    screenId: string;
	    elementId: string;
	}) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setFieldClean: ({ screenId, elementId }: {
	    screenId: string;
	    elementId: string;
	}) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	//# sourceMappingURL=dirty-state-actions.d.ts.map
}
declare module 'lib/plugin' {
	/**
	 * This file contains the interfaces and objects that we expose for plugin developers to use.
	 */
	import { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import { ReduxResponsive } from 'lib/redux/state';
	import { QueryProperty } from 'lib/service/graphql-utils';
	import { Dict } from '@sage/xtrem-shared';
	export { isFieldDisabled, isFieldReadOnly } from 'lib/component/field/carbon-helpers';
	export { XtremUiPlugin, XtremUiPluginComponent, XtremUiPluginComponentProps } from 'lib/service/plugin-service';
	export { QueryProperty, UiComponentProperties, ReduxResponsive, Dict };
	//# sourceMappingURL=plugin.d.ts.map
}
declare module 'lib/service/plugin-service' {
	/// <reference types="react" />
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { ReduxResponsive } from 'lib/plugin';
	import type { QueryProperty } from 'lib/service/graphql-utils';
	import type { ToastOptions } from 'lib/service/toast-service';
	import type { IRouter } from 'lib/service/router';
	import type { QueryParameters } from 'lib/utils/types';
	/**
	 * Props that are passed to the plugin component. These values can be used to retrieve all essential information that is
	 * needed in order to render a plugin field. It contains a number of functions which can be used to provide updates back
	 * to the framework or query additional data from the server.
	 **/
	export interface XtremUiPluginComponentProps<XtremUiPluginCustomDecoratorProperties extends {} = {}, FieldValue extends any = any> {
	    /** The ID of the field, based on the property name of the field declaration on the page. */
	    elementId: string;
	    /** ID of the page that the addon field is loaded into. */
	    screenId: string;
	    /** The actual value of the field which should be displayed. */
	    value: FieldValue;
	    /** Information about the actual device that the field is rendered into. */
	    browser?: ReduxResponsive;
	    /**
	     * Field properties, it includes all values that are declared in the field decorator or on runtime using the
	     * `Plugin` control object's `setProperty` method.
	     **/
	    fieldProperties: EditableFieldProperties & XtremUiPluginCustomDecoratorProperties;
	    /** Query parameters that are passed to the page that the plugin is loaded into. */
	    queryParameters: QueryParameters;
	    /** Locale of the user, such as `en-US` or `fr-FR`. */
	    locale: string;
	    /** Username or unique ID of the user. */
	    username: string;
	    /** Internal router object. It enables the plugin field to make trigger various navigation events. */
	    router: IRouter;
	    /** Execute GraphQL queries directly against the transaction GraphQL endpoint of the application (`/api`) */
	    executeQuery: (query: string) => Promise<any>;
	    /**
	     * Send an update about the field value. It should be called whenever the user finishes changing the value of the
	     * field, for example on blur event.
	     **/
	    setFieldValue: (value: FieldValue) => void;
	    /**
	     * Update a property of the field properties object. This function has the same effect as the `Plugin` control
	     * object's setter methods.
	     **/
	    setFieldProperty: (property: keyof EditableFieldProperties & XtremUiPluginCustomDecoratorProperties, value: any) => void;
	    /** Display a toast on the top of the screen. */
	    showToast: (content: string, options?: ToastOptions) => void;
	    /** A fixed height that is set by the framework in some special cases. If it is set, the plugin is expected to expand or shrink its implementation to this size. */
	    fixedHeight?: number;
	}
	/**
	 * Type that the plugin component is expected to implement. The first generic type represents the custom decorator
	 * properties that the plugin field can receive from the field declaration on the page. The second generic type
	 * represents the value of the field, it is used the determine the type of the `value` property and argument type of the
	 * `setValue` method.
	 **/
	export type XtremUiPluginComponent<XtremUiPluginCustomDecoratorProperties extends {} = {}, FieldValue extends any = any> = React.ComponentType<XtremUiPluginComponentProps<XtremUiPluginCustomDecoratorProperties, FieldValue>>;
	/**
	 * Xtrem UI Plugin declaration. This interface *must* be implemented and *default exported* from the main file of the
	 * plugin NPM package in order to integrate with the Xtrem UI framework.
	 **/
	export interface XtremUiPlugin<XtremUiPluginCustomDecoratorProperties extends {} = {}, FieldValue extends any = any> {
	    /** Plugin name */
	    name: string;
	    /** React component that is used to render the body of the plugin field. */
	    component: XtremUiPluginComponent<XtremUiPluginCustomDecoratorProperties, FieldValue>;
	    /** Create a GraphQL query fragment that is used to query the value of field. */
	    createFieldQuery?: (
	    /**
	     * Field properties, it includes all values that are declared in the field decorator or on runtime using the
	     * `Plugin` control object's `setProperty` method.
	     **/
	    fieldProperties: XtremUiPluginCustomDecoratorProperties & EditableFieldProperties) => QueryProperty;
	    /**
	     * Transform the GraphQL query result value to the type that is needed by the field. For example, it enables
	     * plugin developers to convert raw values to their desired type (for example converting strings to numbers) of
	     * their component. This is called before the initial value of the component is registered by the framework.
	     **/
	    transformFromGraphValue?: (rawValueFromQueryResult: any) => FieldValue;
	    /**
	     * Transform the value of the field to a GraphQL mutation friendly format. This function is called when the value
	     * of the page is prepared to a CRUD operation, for example when the `this.$.values` variable is accessed on a page.
	     */
	    transformToGraphValue?: (value: FieldValue) => any;
	}
	//# sourceMappingURL=plugin-service.d.ts.map
}
declare module 'lib/utils/file-deposit-utils' {
	import type { CreateOperation, UpdateOperation } from '@sage/xtrem-client';
	import type { CancelTokenSource } from 'axios';
	import type { FileDepositValue } from 'lib/component/types';
	export const STATUS_CREATED = "created";
	export const STATUS_UPLOADED = "uploaded";
	export const STATUS_UPLOAD_FAILED = "uploadFailed";
	export const STATUS_VERIFIED = "verified";
	export const STATUS_CANCELLED = "cancelled";
	export const STATUS_UPLOADING = "uploading";
	export const STATUS_REJECTED = "rejected";
	export function isDisallowedMimeType(allowedTypes: string | string[], fileType: string, fileName: string): boolean;
	export interface FileDepositProgress {
	    isInProgress: boolean;
	    progress: number;
	    fieldValue: Partial<FileDepositValue>;
	    cancelTokenSource: CancelTokenSource;
	}
	export interface DepositFileArguments {
	    file: File;
	    targetNodeMutations: {
	        create: CreateOperation<any, any>;
	        update: UpdateOperation<any, any>;
	    };
	    onUploadProgress?: (progressEvent: FileDepositProgress) => void;
	}
	export function depositFile({ file, targetNodeMutations, onUploadProgress, }: DepositFileArguments): Promise<FileDepositValue>;
	export function showNotAllowedTypeToast(type: string): void;
	export function getMimeTypeFromExtension(filename: string): string;
	export const getMimeTypeUserFriendlyName: (mimeType: string) => string;
	//# sourceMappingURL=file-deposit-utils.d.ts.map
}
declare module 'lib/component/field/multi-file-deposit/multi-file-deposit-utils' {
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { DepositFileArguments } from 'lib/utils/file-deposit-utils';
	import type { NestedField } from 'lib/component/nested-fields';
	import type { AttachmentAssociation } from 'lib/component/types';
	import type { WithCancelToken } from 'lib/component/field/multi-file-deposit/multi-file-deposit-types';
	export function getMultiFileDepositFieldColumns(): Array<NestedField<any, any, AttachmentAssociation>>;
	export interface DepositFileToCollectionValueArguments extends DepositFileArguments {
	    value: CollectionValue<WithCancelToken<AttachmentAssociation>>;
	}
	export function depositFileToCollectionValue({ file, targetNodeMutations, value, onUploadProgress, }: DepositFileToCollectionValueArguments): Promise<void>;
	//# sourceMappingURL=multi-file-deposit-utils.d.ts.map
}
declare module 'lib/service/value-formatter-service' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { CollectionItem, ComponentKey, ControlObjectInstance } from 'lib/component/types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { XtremUiPlugin } from 'lib/service/plugin-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	/**
	 * Formats a single field into a suitable format based on its server-side GraphQL type or the corresponding control
	 * object
	 *
	 * @param screenId
	 * @param elementId
	 * @param nodeTypes
	 * @param fieldType
	 * @param fieldProperties
	 * @param value
	 * @param parentNode
	 */
	export const formatValue: ({ pageDefinition, elementId, fieldProperties, fieldType, nodeTypes, parentNode, plugins, rowValue, screenId, value, }: {
	    pageDefinition?: PageDefinition;
	    elementId: string;
	    fieldProperties: ReadonlyFieldProperties;
	    fieldType: ComponentKey;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    parentNode?: string;
	    plugins: Dict<XtremUiPlugin>;
	    rowValue?: any;
	    screenId: string;
	    value?: any;
	}) => any;
	export interface FormatCollectionItemArgs<T extends ClientNode = any> {
	    screenId: string;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    collectionItem: CollectionItem;
	    plugins?: Dict<XtremUiPlugin>;
	    columnsDefinitions: NestedField<ScreenBase, NestedFieldTypes, T>[];
	    parentNode?: string;
	    contextRow?: any;
	}
	/**
	 * Format all values of a nested collection item into client-side suitable format based on various rules depending on
	 * the server-side node GraphQL types and the control object types.
	 * @param screenId
	 * @param nodeTypes
	 * @param collectionItem
	 * @param columnsDefinitions
	 * @param parentNode
	 */
	export const formatCollectionItem: <T extends ClientNode = any>({ screenId, nodeTypes, collectionItem, plugins, columnsDefinitions, parentNode, contextRow, }: FormatCollectionItemArgs<T>) => T;
	/**
	 * Format all values of a screen into client-side suitable format based on various rules depending on the server-side
	 * node GraphQL types and the control object types.
	 *
	 * If the `onlyElementIds` parameter is supplied, it will only format those values which are provided in this parameter.
	 *
	 * @param screenId
	 * @param controlObjects
	 * @param uiComponentProperties
	 * @param nodeTypes
	 * @param values
	 * @param parentNode
	 */
	export const formatScreenValues: ({ pageDefinition, screenId, controlObjects, plugins, nodeTypes, values, parentNode, onlyElementIds, }: {
	    pageDefinition?: PageDefinition;
	    screenId: string;
	    controlObjects: Dict<ControlObjectInstance<any>>;
	    plugins: Dict<XtremUiPlugin>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    values: Dict<any>;
	    parentNode?: string;
	    onlyElementIds?: string[];
	}) => Dict<any>;
	//# sourceMappingURL=value-formatter-service.d.ts.map
}
declare module 'lib/redux/actions/field-value-actions' {
	import type { Changeable as fieldValueActions } from 'lib/component/field/traits';
	import type { XtremUiPlugin } from 'lib/service/plugin-service';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { AppThunkDispatch } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state';
	import type { Dict } from '@sage/xtrem-shared';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { QueryArguments } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export const setFieldValue: (screenId: string, elementId: string, fieldValue: any, isOrganicChange?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export interface ApplyDefaultValuesArgs {
	    dispatch: AppThunkDispatch;
	    screenDefinition: ScreenBaseDefinition<any>;
	    fieldProperties?: fieldValueActions<any>;
	    plugins: Dict<XtremUiPlugin>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    requestedFieldIds?: string[];
	    skipDispatch?: boolean;
	}
	export const applyDefaultValues: ({ dispatch, screenDefinition, fieldProperties, plugins, nodeTypes, requestedFieldIds, skipDispatch, }: ApplyDefaultValuesArgs) => Promise<any>;
	export interface DispatchDefaultValuesSetArgs {
	    screenDefinition: ScreenBaseDefinition<any>;
	    plugins: Dict<XtremUiPlugin>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    defaultValues: Dict<any>;
	    dispatch?: AppThunkDispatch;
	    skipDispatch?: boolean;
	}
	export const dispatchDefaultValuesSet: ({ screenDefinition, plugins, nodeTypes, defaultValues, dispatch, skipDispatch, }: DispatchDefaultValuesSetArgs) => any;
	export const loadCollectionData: (screenId: string, elementId: string, nestedFields: NestedField<ScreenBase, NestedFieldTypes>[], queryArguments: QueryArguments, bind?: PropertyValueType, keepAllRecords?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	//# sourceMappingURL=field-value-actions.d.ts.map
}
declare module 'lib/service/field-state-service' {
	import type { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	export const isFieldDirty: (screenId: string, elementId: string) => boolean;
	export const setFieldDirty: (screenId: string, elementId: string) => void;
	export const setFieldClean: (screenId: string, elementId: string) => void;
	export const refreshField: ({ screenId, elementId, keepPageInfo, keepModifications, }: {
	    screenId: string;
	    elementId: string;
	    keepPageInfo?: boolean;
	    keepModifications?: boolean;
	}) => Promise<any>;
	export const focusField: (screenId: string, elementId: string) => void;
	export const isFieldInFocus: (screenId: string, elementId: string) => boolean;
	export const getFocussedField: (screenId: string) => ReadonlyFieldControlObject<any, any, any, any> | null;
	//# sourceMappingURL=field-state-service.d.ts.map
}
declare module 'lib/component/field/field-header' {
	import React from 'react';
	interface FieldHeaderProps {
	    children?: React.ReactNode;
	    elementId: string;
	    screenId: string;
	    title?: string;
	    isDisabled?: boolean;
	    isTitleHidden?: boolean;
	}
	export function FieldHeader(props: FieldHeaderProps): React.ReactElement;
	export {};
	//# sourceMappingURL=field-header.d.ts.map
}
declare module 'lib/component/field/calendar/calendar-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { CalendarComponentAdditionalProps, CalendarComponentInternalProps, CalendarState, InternalCalendarProperties } from 'lib/component/field/calendar/calendar-types';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { NodePropertyType } from 'lib/types';
	export class CalendarComponent extends ReadonlyFieldBaseComponent<InternalCalendarProperties, CollectionValue, CalendarComponentAdditionalProps & {
	    fieldProperties: InternalCalendarProperties;
	}, CalendarState> {
	    constructor(props: CalendarComponentInternalProps);
	    private readonly onFilterChange;
	    private readonly saveFilters;
	    private readonly onSelectView;
	    private readonly getTypedEventItems;
	    private readonly getEventItems;
	    render(): React.ReactNode;
	}
	export const ConnectedCalendarComponent: import("react-redux").ConnectedComponent<typeof CalendarComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<CalendarComponent> | undefined;
	    contextNode?: NodePropertyType | undefined;
	    recordContext?: any;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedCalendarComponent;
	//# sourceMappingURL=calendar-component.d.ts.map
}
declare module 'lib/component/field/calendar/async-calendar-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { CalendarComponentInternalProps } from 'lib/component/field/calendar/calendar-types';
	export function AsyncConnectedCalendarComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncCalendarComponent(props: CalendarComponentInternalProps): React.ReactElement;
	//# sourceMappingURL=async-calendar-component.d.ts.map
}
declare module 'lib/component/field/rich-text/rich-text-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	export interface RichTextDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<RichTextProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export interface RichTextProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    /** The value of the height attribute. Minimum height should be at least the height of the top edit panel and a line.  */
	    height?: string;
	    /** List of available text editing capabilities, e.g bold text, font size, font color. If not set all capabilities are enabled.  */
	    capabilities?: RichTextEditorCapabilities[];
	}
	export type RichTextComponentProps = BaseEditableComponentProperties<RichTextProperties, {
	    value: string;
	}>;
	export interface RichTextComponentState {
	    value: string;
	}
	export type RichTextEditorCapabilities = 'bold' | 'italic' | 'underline' | 'strikethrough' | 'history' | 'heading' | 'fontColor' | 'fontBackgroundColor' | 'fontSize' | 'fontFamily' | 'table' | 'lists' | 'alignment' | 'indentation' | 'link';
	//# sourceMappingURL=rich-text-types.d.ts.map
}
declare module 'lib/component/field/rich-text/rich-text-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { RichTextComponentProps, RichTextProperties, RichTextComponentState } from 'lib/component/field/rich-text/rich-text-types';
	import { ContextType } from 'lib/types';
	export class RichTextComponent extends EditableFieldBaseComponent<RichTextProperties, {
	    value: string;
	}, {}, RichTextComponentState> {
	    private readonly toolbarContainer;
	    constructor(props: RichTextComponentProps);
	    getToolbarItems(): string[];
	    onBlur: () => void;
	    onChange: (value: string) => void;
	    onKeyDown: (data: any) => void;
	    UNSAFE_componentWillReceiveProps(nextProps: RichTextComponentProps): void;
	    render(): React.ReactNode;
	}
	export const ConnectedRichTextComponent: import("react-redux").ConnectedComponent<typeof RichTextComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<RichTextComponent> | undefined;
	    contextType?: ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedRichTextComponent;
	//# sourceMappingURL=rich-text-component.d.ts.map
}
declare module 'lib/component/field/rich-text/async-rich-text-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { RichTextComponentProps } from 'lib/component/field/rich-text/rich-text-types';
	export function AsyncConnectedRichTextComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncRichTextComponent(props: RichTextComponentProps): React.ReactElement;
	//# sourceMappingURL=async-rich-text-component.d.ts.map
}
declare module 'lib/component/field/chart/chart-types' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { Filter } from 'lib/service/filter-service';
	import type { BlockControlObject, InternalChartProperties } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance, GraphqlCollection } from 'lib/component/types';
	import type { BaseReadonlyComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Clickable, ExtensionField, HasFieldActions, HasParent, HasFilter } from 'lib/component/field/traits';
	import type { ScreenBaseGenericType } from 'lib/types';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ChartDeclaration } from 'lib/component/chart-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface ChartProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends ReadonlyFieldProperties<CT>, HasFilter<CT, NodeType> {
	    /** Whether the series of the chart can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	    /** Chart configuration properties */
	    chart: ChartDeclaration<CT>;
	    /** The GraphQL node that the table represents, needed for filtering */
	    node?: keyof ScreenBaseGenericType<CT>;
	    /** Whether the legend should be hidden */
	    isLegendHidden?: boolean;
	}
	export interface ChartDecoratorProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends HasFieldActions<CT>, ChartProperties<CT, NodeType>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export interface ChartComponentAdditionalProps {
	    setFieldProperties: (elementId: string, value: ChartDecoratorProperties & InternalChartProperties) => void;
	    nodeTypes: Dict<FormattedNodeDetails>;
	}
	export type ChartComponentProps = BaseReadonlyComponentProperties<ChartDecoratorProperties, GraphqlCollection, ChartComponentAdditionalProps>;
	export interface ChartComponentState {
	    filters: Filter[];
	}
	//# sourceMappingURL=chart-types.d.ts.map
}
declare module 'lib/component/field/chart/chart-utils' {
	import type { LocalizeLocale } from '@sage/xtrem-shared';
	import { FieldKey } from '@sage/xtrem-shared';
	import { ChartTypes } from 'lib/component/chart-types';
	import type { ChartProperties } from 'lib/component/field/chart/chart-types';
	import type { GraphqlCollection } from 'lib/component/types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	export const chartColors: string[];
	export interface ChartOptions {
	    screenId: string;
	    locale: LocalizeLocale;
	    type: ChartTypes;
	    isLegendHidden: boolean;
	    data: any[];
	    height: number;
	    series?: {
	        stroke: string;
	        xKey: string;
	        yKey: string;
	        yName: string;
	        seriesNestedField: NestedField<any, FieldKey.Numeric>;
	    }[];
	    pie?: {
	        labelKey: string;
	        angleKey: string;
	        stroke: string;
	        fills: string[];
	        valueNestedField: NestedField<any, FieldKey.Numeric>;
	    };
	    labelNestedField: NestedField<any, NestedFieldTypes>;
	    legend: {
	        enabled: boolean;
	        position: string;
	    };
	    xAxis: {
	        key: string;
	    };
	}
	export function getChartOptions({ screenId, properties, locale, collection, }: {
	    screenId: string;
	    properties: ChartProperties;
	    locale: LocalizeLocale;
	    collection?: GraphqlCollection;
	}): ChartOptions;
	export function formatChartLabel({ screenId, nestedField, locale, value, rowValue, }: {
	    screenId: string;
	    nestedField: NestedField<any, NestedFieldTypes>;
	    locale: LocalizeLocale;
	    value: any;
	    rowValue: any;
	}): string;
	//# sourceMappingURL=chart-utils.d.ts.map
}
declare module 'lib/component/field/chart/line/line-chart-component' {
	import React from 'react';
	import { type ChartOptions } from 'lib/component/field/chart/chart-utils';
	export function LineChartComponent({ series, screenId, xAxis, data, legend, height, labelNestedField, locale, }: ChartOptions): React.JSX.Element;
	//# sourceMappingURL=line-chart-component.d.ts.map
}
declare module 'lib/component/field/chart/bar/bar-chart-component' {
	import React from 'react';
	import type { ChartOptions } from 'lib/component/field/chart/chart-utils';
	export function BarChartComponent(props: ChartOptions): React.JSX.Element;
	//# sourceMappingURL=bar-chart-component.d.ts.map
}
declare module 'lib/component/field/chart/pie/pie-chart-component' {
	import React from 'react';
	import type { ChartOptions } from 'lib/component/field/chart/chart-utils';
	export function PieChartComponent({ pie, locale, data, xAxis, height, screenId, legend, isLegendHidden, labelNestedField, }: ChartOptions): React.JSX.Element;
	//# sourceMappingURL=pie-chart-component.d.ts.map
}
declare module 'lib/component/field/chart/chart-component' {
	import * as React from 'react';
	import type { Filter } from 'lib/service/filter-service';
	import type { GraphqlCollection } from 'lib/component/types';
	import type { FilterManagerField } from 'lib/component/ui/filter/filter-manager';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { ChartComponentProps, ChartComponentState, ChartDecoratorProperties } from 'lib/component/field/chart/chart-types';
	import type { OptionalNodePropertyType } from 'lib/types';
	export class ChartComponent extends ReadonlyFieldBaseComponent<ChartDecoratorProperties, GraphqlCollection, ChartComponentProps, ChartComponentState> {
	    constructor(props: ChartComponentProps);
	    onFilterChange: () => Promise<void>;
	    renderChart(): React.ReactNode;
	    saveFilters: (filters: Filter[]) => void;
	    getFilterableFields: (node: OptionalNodePropertyType, nestedFields: ChartDecoratorProperties['chart']['series']) => FilterManagerField[];
	    getNestedFields: () => FilterManagerField[];
	    render(): React.ReactNode;
	}
	export const ConnectedChartComponent: import("react-redux").ConnectedComponent<typeof ChartComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<ChartComponent> | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedChartComponent;
	//# sourceMappingURL=chart-component.d.ts.map
}
declare module 'lib/component/field/chart/async-chart-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ChartComponentProps } from 'lib/component/field/chart/chart-types';
	export function AsyncConnectedChartComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncChartComponent(props: ChartComponentProps): React.ReactElement;
	//# sourceMappingURL=async-chart-component.d.ts.map
}
declare module 'lib/component/field/table-summary/table-summary-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { CollectionValueFieldProperties } from 'lib/component/field/collection-value-field';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { HasColumns, HasDynamicLookupSuggestions, HasRowChangeIndicators, CanFetchDefaults, Clickable, ExtensionField, HasCollectionSelectionEventHandlers, HasCollectionSelectionEventHandlersAfter, HasFieldActions, HasParent } from 'lib/component/field/traits';
	import type { NestedRecordId, ScreenExtension } from 'lib/types';
	import type { OverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { GridNestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { Extend } from 'lib/service/page-extension';
	export interface TableSummaryDecoratorProperties<CT extends ScreenBase = ScreenBase, NestedRecordType extends ClientNode = any> extends TableSummaryProperties<CT, NestedRecordType>, Clickable<CT>, HasFieldActions<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, HasCollectionSelectionEventHandlers<CT, NestedRecordType>, CanFetchDefaults {
	    /** Function to be executed when the table field's value changes */
	    onChange?: (this: CT, recordId: NestedRecordId, column: string, rowItem: NestedRecordType) => void;
	}
	export type BaseTableSummaryExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase, NestedRecordType extends ClientNode = any> = HasCollectionSelectionEventHandlersAfter<CT, NestedRecordType> & {
	    /** Function to be executed when the table field's value changes after base onChange*/
	    onChangeAfter?: (this: CT, recordId: NestedRecordId, column: string, rowItem: NestedRecordType) => void;
	};
	export interface TableSummaryExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> extends BaseTableSummaryExtensionDecoratorProperties<Extend<CT>>, OverrideDecoratorProperties<TableSummaryDecoratorProperties<Extend<CT>, ReferencedItemType>> {
	    /** The definitions of the nested fields used to represent the table rows */
	    columns?: NestedExtensionField<CT, GridNestedFieldTypes, ReferencedItemType>[];
	    /** Allows overriding existing column properties in the base page's columns */
	    columnOverrides?: NestedOverrideField<CT, GridNestedFieldTypes, ReferencedItemType>[];
	}
	export interface TableSummaryProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends CollectionValueFieldProperties<CT, NestedRecordType>, HasColumns<CT, NestedRecordType>, HasRowChangeIndicators, HasFieldActions<CT> {
	    /** Defines a message when the table is empty */
	    emptyStateText?: string;
	}
	export interface InternalTableSummaryProperties<CT extends ScreenExtension<CT> = ScreenBase, NRT extends ClientNode = any> extends TableSummaryProperties<CT, NRT>, HasDynamicLookupSuggestions<CT, NRT> {
	    activeUserFilter?: GraphQLFilter;
	    isNewEnabled?: boolean;
	    valueField?: string;
	    hiddenColumns?: string[];
	}
	export type TableSummaryComponentProperties = BaseEditableComponentProperties<TableSummaryDecoratorProperties, CollectionValue>;
	//# sourceMappingURL=table-summary-types.d.ts.map
}
declare module 'lib/component/connected-collection' {
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import * as React from 'react';
	import type { Dict } from '@sage/xtrem-shared';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ClientNode } from '@sage/xtrem-client';
	interface ConnectedCollectionValueProps {
	    value?: CollectionValue;
	    isUncommitted?: boolean;
	}
	/**
	 * If a CollectionValue `value` property is provided, the HOC subscribes to the add and remove events of collection value
	 * items and re-renders the child component on change
	 * @param WrappedComponent
	 */
	export const withCollectionValueSubscription: (WrappedComponent: React.ComponentType<ConnectedCollectionValueProps>) => React.ComponentType;
	/**
	 * If a CollectionValue `value` property is provided, the HOC subscribes to the add and remove events of collection value
	 * items and re-renders the child component on change
	 * @param WrappedComponent
	 */
	export const withCollectionValueAndOrderSubscription: (WrappedComponent: React.ComponentType<ConnectedCollectionValueProps>) => React.ComponentType;
	export interface ConnectedCollectionItemValueProps extends ConnectedCollectionValueProps {
	    recordId?: string;
	    level?: number;
	    onChange?: (bind: string, value: any, recordId: string) => Promise<void>;
	    recordValue?: ClientNode;
	    validationState?: Dict<ValidationResult>;
	    isUncommitted?: boolean;
	    shouldFetchDefault?: boolean;
	}
	/**
	 * If a CollectionValue `value` property and a valid `recordId` property are provided, the HOC subscribes to changes to
	 * the item tracked by the record ID and re-renders the child component if the item changes.
	 * @param WrappedComponent
	 */
	export const withCollectionValueItemSubscription: <U extends ConnectedCollectionItemValueProps>(WrappedComponent: React.ComponentType<U>) => React.ComponentType<U>;
	export {};
	//# sourceMappingURL=connected-collection.d.ts.map
}
declare module 'lib/component/field/table-summary/table-summary-row-component' {
	import * as React from 'react';
	import type { NestedFieldWrapperContextProps } from 'lib/render/nested-field-wrapper';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { NestedField, NestedFieldTypesWithoutTechnical } from 'lib/component/nested-fields';
	import type { ConnectedCollectionItemValueProps } from 'lib/component/connected-collection';
	export interface TableRowComponentProps extends ConnectedCollectionItemValueProps {
	    columns: NestedField<ScreenBase, NestedFieldTypesWithoutTechnical>[];
	    commonProperties: NestedFieldWrapperContextProps;
	}
	export const TableSummaryRowComponent: React.ComponentType<TableRowComponentProps>;
	//# sourceMappingURL=table-summary-row-component.d.ts.map
}
declare module 'lib/component/field/table-summary/table-summary-component' {
	import * as React from 'react';
	import type { NestedField, NestedFieldTypesWithoutTechnical } from 'lib/component/nested-fields';
	import type { TableSummaryDecoratorProperties } from 'lib/component/field/table-summary/table-summary-types';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { ContextType } from 'lib/types';
	export class TableSummaryComponent extends EditableFieldBaseComponent<TableSummaryDecoratorProperties, CollectionValue> {
	    getColumnHeaders: () => React.ReactNode;
	    getVisibleColumns: () => NestedField<ScreenBase, NestedFieldTypesWithoutTechnical>[];
	    getRows: () => React.ReactNode;
	    render(): React.ReactNode;
	}
	export const ConnectedTableSummaryComponent: import("react-redux").ConnectedComponent<React.ComponentType<{}>, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<{}, any, any>> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedTableSummaryComponent;
	//# sourceMappingURL=table-summary-component.d.ts.map
}
declare module 'lib/component/field/table-summary/async-table-summary-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { TableSummaryComponentProperties } from 'lib/component/field/table-summary/table-summary-types';
	export function AsyncConnectedTableSummaryComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncTableSummaryComponent(props: TableSummaryComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-table-summary-component.d.ts.map
}
declare module 'lib/utils/table-component-utils' {
	import type { ColDef, GridApi } from '@ag-grid-community/core';
	import { type Dict } from '@sage/xtrem-shared';
	import type { OptionsMenuItem } from 'lib/component/control-objects';
	import type { TableDecoratorProperties, TableProperties } from 'lib/component/field/table/table-component-types';
	import type { OrderByType } from 'lib/component/types';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { TableView, TableViewGrouping, TableViewSortedColumn } from 'lib/redux/state';
	import type { ValueOrCallback } from 'lib/utils/types';
	export const AUTO_COLUMN_ID = "ag-Grid-AutoColumn";
	export const getGraphFilter: ({ filterModel, screenId, tableFieldProperties, activeOptionsMenuItem, }: {
	    filterModel: any;
	    screenId: string;
	    tableFieldProperties: TableProperties;
	    activeOptionsMenuItem?: OptionsMenuItem;
	}) => any;
	export const isColumnBindVariant: (colBind: string, colId: string) => boolean;
	export interface ColumnCompareType {
	    bind: string;
	    valueField?: string;
	}
	export const resolveCompareFunction: (screenId: string, compareFunc: Function, arg1: ColumnCompareType, arg2: ColumnCompareType) => number;
	export const getOrderByKey: (columnId: string) => string;
	export const removeNumericPostfix: (colId: string) => string;
	export const removeTableNumericPostfix: (colId: string) => string;
	/** Converts Ag-grid filter statements to Xtrem's GraphQL-friendly filter object structure */
	export const getOrderByFromSortModel: (sortModel: TableViewSortedColumn[], columns: any[], autoGroupColumnDef?: ColDef) => OrderByType;
	interface ShouldRenderDropdownAboveProps {
	    isPhantomRow: boolean;
	    pageSize: number;
	    rowIndex: number;
	}
	export const shouldRenderDropdownAbove: ({ isPhantomRow, pageSize, rowIndex, }: ShouldRenderDropdownAboveProps) => boolean;
	export const calculateHiddenColumns: import("memoize-one").MemoizedFn<(hiddenColumns: string[], actualColumns: (string | undefined | null)[]) => (string | null | undefined)[]>;
	export interface GetCardDefinitionFromColumnsArgs {
	    screenId: string;
	    columns: TableDecoratorProperties['columns'];
	    isGreaterThanSmall: boolean;
	    hiddenColumns?: string[];
	    sortColumns?: (this: any, firstColumn: ColumnCompareType, secondColumn: ColumnCompareType) => number;
	    mobileCard?: TableDecoratorProperties['mobileCard'];
	}
	export const getCardDefinitionFromColumns: ({ screenId, columns, isGreaterThanSmall, hiddenColumns, sortColumns, mobileCard, }: GetCardDefinitionFromColumnsArgs) => CardDefinition;
	export function setGridContext<T = any>(gridApi: GridApi, contextProducer: (c: T) => void): void;
	type TableContext = {
	    headerClasses: Dict<boolean>;
	    onSelectAll: (selectedRowCount: number) => void;
	    onUnselectAll: () => void;
	    totalRowCount: number;
	    isSelectAllEnabled: boolean;
	};
	export function setTableContext(gridApi: GridApi, contextProducer: (c: TableContext) => void): void;
	export function getGridApiContext<T = any>(gridApi: GridApi, defaultValue: T): T;
	export function getTableContext(gridApi: GridApi): TableContext;
	type NestedGridContext = {
	    parentId?: string;
	    level?: number;
	    parentApi?: GridApi;
	    headerClasses: Dict<boolean>;
	};
	export function getNestedGridContext(gridApi: GridApi): NestedGridContext;
	export function setNestedGridContext(gridApi: GridApi, contextProducer: (c: NestedGridContext) => void): void;
	export const getTableViewColumnHidden: (views?: Dict<TableView>, level?: number) => Dict<boolean> | undefined;
	export const getTableViewFilter: (views?: Dict<TableView>, level?: number) => Dict<any>;
	export const getTableViewGrouping: (views?: Dict<TableView>, level?: number) => TableViewGrouping | undefined;
	export const getTableViewOptionsMenuItem: (views?: Dict<TableView>, level?: number) => OptionsMenuItem | undefined;
	export const getTableViewSortOrder: (views?: Dict<TableView>, level?: number) => TableViewSortedColumn[] | undefined;
	export const getActiveOptionsMenu: (screenId: string, views?: Dict<TableView>, optionsMenu?: ValueOrCallback<any, OptionsMenuItem[]>) => OptionsMenuItem | undefined;
	export {};
	//# sourceMappingURL=table-component-utils.d.ts.map
}
declare module 'lib/component/ui/tooltip/tooltip' {
	import * as React from 'react';
	import type { IconProps } from 'lib/component/ui/icon/icon-component';
	import type { TooltipProps } from 'lib/component/ui/tooltip/tooltip-types';
	export function Tooltip({ message, position, ...props }: TooltipProps): React.ReactElement;
	export function TableTooltip(props: Omit<IconProps, 'color' | 'type' | 'tooltipMessage'> & {
	    content: string | React.ReactNode;
	}): React.ReactElement;
	//# sourceMappingURL=tooltip.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/cell-wrapper' {
	import React from 'react';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { NestedCheckboxProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export interface CellWrapperProps extends React.PropsWithChildren<CellParams<NestedCheckboxProperties<ScreenBase, any>, any>> {
	    textAlign?: 'right' | 'left' | 'center';
	}
	export function CellWrapper({ children, textAlign, ...props }: React.PropsWithChildren<CellWrapperProps>): React.ReactElement | null;
	//# sourceMappingURL=cell-wrapper.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-utility-types' {
	import type { ColDef, GridApi } from '@ag-grid-community/core';
	import type { FilterTypeValue } from '@sage/xtrem-shared';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ScreenBase } from 'lib/service/screen-base';
	export interface AgGridColumnConfigWithScreenIdAndColDef extends ColDef {
	    columnDefinition?: NestedField<ScreenBase, NestedFieldTypes>;
	    columnId: string;
	    field?: string;
	    isEditable: (data: any) => boolean;
	    screenId: string;
	    xtremSortIndex?: number;
	}
	export interface AgGridColumnConfigWithAllColumns extends AgGridColumnConfigWithScreenIdAndColDef {
	    getColumns: () => NestedField<any, any>[];
	}
	export interface GridApiWithContext extends Omit<GridApi, 'context'> {
	    context: any;
	}
	export interface ColumnPanelColumnState {
	    colId: string;
	    isHidden: boolean;
	    isMandatory: boolean;
	    isSpecialColumn?: boolean;
	    title: string;
	}
	export interface FilterValue {
	    filterType: {
	        text: string;
	        value: FilterTypeValue;
	    };
	    filterValue: any;
	    /** Indicates that the filter should be applied against the ID field, it is used with nested objects (e.g reference columns) */
	    filterById?: boolean;
	}
	//# sourceMappingURL=ag-grid-utility-types.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-event-handlers' {
	import type { CellClickedEvent, CellKeyDownEvent, RowClickedEvent } from '@ag-grid-community/core';
	import type { NestedFieldsProperties, NestedFieldTypesWithoutTechnical } from 'lib/component/nested-fields';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { OnRowClickFunction } from 'lib/component/field/table/table-component-types';
	export const onCellClickHandler: (screenId: string, tableElementId: string, nestedFieldProperties: NestedFieldsProperties<NestedFieldTypesWithoutTechnical, ScreenBase>, isParentFieldDisabled: boolean) => (event: CellClickedEvent) => void;
	export const onCellValueChangedHandler: (screenId: string, tableElementId: string, nestedFieldProperties: NestedFieldsProperties<NestedFieldTypesWithoutTechnical, ScreenBase>, value: () => CollectionValue, isInLookupDialog?: boolean) => ((params: any) => Promise<void>);
	export const onCellKeyDown: (event: CellKeyDownEvent) => void;
	/** Event listener, triggered when the user clicks any part of the row apart from the dropdown actions */
	export const onRowClick: (onRowClickCallback?: OnRowClickFunction) => (event: RowClickedEvent) => void;
	//# sourceMappingURL=ag-grid-event-handlers.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-service' {
	/// <reference types="lodash" />
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import type { OptionsMenuItem } from 'lib/component/control-objects';
	import type { ColumnsData, InternalTableProperties } from 'lib/component/field/table/table-component-types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import { FieldKey } from 'lib/component/types';
	import type { TableViewLevel, TableViewSortedColumn } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ContextType, NodePropertyType } from 'lib/types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { AgGridColumnConfigWithScreenIdAndColDef } from 'lib/utils/ag-grid/ag-grid-utility-types';
	export const shouldDisplayColumnInPanel: ((columnDefinition?: NestedField<ScreenBase, any>) => boolean) & import("lodash").MemoizedFunction;
	export const getCellClass: (isEditable: boolean, columnId: string, columnDefinition: NestedField<ScreenBase, NestedFieldTypes>, title: string, columnDefinitionType: NestedFieldTypes) => string[];
	export function withoutNestedTechnicalColumns(argument: ColumnsData[]): ColumnsData<Exclude<NestedFieldTypes, FieldKey.Technical>>[];
	export const getColumns: ({ accessBindings, columnsData, contextType, dataTypes, currentTableView, elementId: tableElementId, enumTypes, fieldProperties, isDisabled, isFilteringDisabled, groupBy, hasFloatingFilters, isParentDisabled, isReadOnly, level, locale, lookupSelectionMode, nodeTypes, pageNode, screenId, isSortingDisabled, value, activeOptionsMenuItem, }: {
	    accessBindings: AccessBindings;
	    columnsData: ColumnsData[];
	    contextType?: ContextType;
	    currentTableView?: TableViewLevel;
	    elementId: string;
	    enumTypes: Dict<string[]>;
	    /**
	     * Ag-grid seems to cache some of these values in the column configuration, so in order to ensure that we always
	     * have an up-to-date version of the properties, we pass them in as a callback
	     * */
	    fieldProperties: () => Omit<InternalTableProperties, 'selectedRecords'>;
	    isDisabled?: boolean;
	    isFilteringDisabled?: boolean;
	    groupBy?: string;
	    hasFloatingFilters?: boolean;
	    level: number;
	    locale: LocalizeLocale;
	    lookupSelectionMode?: 'single' | 'multiple';
	    isParentDisabled: () => boolean;
	    isReadOnly?: ValueOrCallbackWithFieldValue<ScreenBase, boolean>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    pageNode?: NodePropertyType;
	    screenId: string;
	    isSortingDisabled?: boolean;
	    customizedOrderBy?: TableViewSortedColumn[];
	    activeOptionsMenuItem?: OptionsMenuItem;
	    dataTypes: Dict<DataTypeDetails>;
	    /**
	     * Ag-grid seems to cache some of these values in the column configuration, so in order to ensure that we always
	     * have an up-to-date version of the value, we pass them in as a callback
	     * */
	    value: () => CollectionValue;
	}) => AgGridColumnConfigWithScreenIdAndColDef[];
	//# sourceMappingURL=ag-grid-service.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-table-utils' {
	import type { CellPosition, ColumnState, DateFilterModel, GridApi, NumberFilterModel, SetFilterModel, TabToNextCellParams, TextFilterModel } from '@ag-grid-community/core';
	import type { Dict } from '@sage/xtrem-shared';
	import type { EnumType } from 'json-to-graphql-query';
	import type { PickProperties } from 'ts-essentials';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { Filter } from 'lib/service/filter-service';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { AgGridColumnConfigWithScreenIdAndColDef, ColumnPanelColumnState, FilterValue } from 'lib/utils/ag-grid/ag-grid-utility-types';
	export type FilterModel = DateFilterModel | NumberFilterModel | TextFilterModel | SetFilterModel;
	export const ROW_HEIGHT = 40;
	export const getFilterValueFromAgGridFilterStatement: (filterBase: FilterModel & {
	    filterById?: boolean;
	}, filterKey: string) => FilterValue;
	export function callGridMethod<M extends keyof PickProperties<GridApi, (...args: any[]) => any>>(gridApi: GridApi | undefined | null, method: M, ...args: ArgsType<GridApi[M]>): ReturnType<GridApi[M]> | undefined;
	export function getSafeGridApiContext<M extends keyof PickProperties<GridApi, (...args: any[]) => any>, R>(cb: (arg: ReturnType<GridApi[M]> extends void ? undefined : ReturnType<GridApi[M]>) => R, gridApi: GridApi | undefined | null, method: M, ...args: ArgsType<GridApi[M]>): R | undefined;
	export type FilterTypes = string | number | boolean | EnumType;
	type ArgsType<T> = T extends (...args: infer A) => any ? A : never;
	export const mapAgGridFilterToXtremFilters: (filterModel: Dict<any>) => (filterKey: any) => Filter<FilterTypes>;
	export const tryToCommitPhantomRow: ({ api, screenId, value, elementId, }: {
	    api: GridApi;
	    screenId: string;
	    value: CollectionValue;
	    elementId: string;
	}) => Promise<Dict<ValidationResult> | null>;
	export const tabToNextCell: (screenId: string, elementId: string, value: () => CollectionValue, onTelemetryEvent?: OnTelemetryEventFunction) => (event: TabToNextCellParams) => CellPosition | null;
	export const getFirstEditableColumn: (api: GridApi, data?: any, includeSelect?: boolean) => string | undefined;
	export const getFilterModel: (api?: GridApi | null, groupByColumnField?: string) => any | undefined;
	export const getAllUnselectedIds: (gridApi: GridApi) => string[];
	export const getColumnStatesForColumnPanel: (screenId: string, columnDefinitions?: AgGridColumnConfigWithScreenIdAndColDef[], columnStates?: ColumnState[]) => ColumnPanelColumnState[];
	export {};
	//# sourceMappingURL=ag-grid-table-utils.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-inline-actions' {
	import React from 'react';
	import type { TableDropdownActionsCellProps } from 'lib/component/ui/table-shared/cell/table-dropdown-action-cell';
	import type { InlineCollectionItemAction } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	interface ResolvedInlineCollectionItemAction extends Omit<InlineCollectionItemAction<any, any>, 'isDisabled' | 'isHidden' | 'isDisplayed' | 'onClick'> {
	    key: string;
	    isHidden?: boolean;
	    isDisabled?: boolean;
	    isDisplayed?: boolean;
	    onClick?: () => void;
	}
	interface TableInlineActionsProps {
	    inlineActions: Array<ResolvedInlineCollectionItemAction>;
	    isEditing?: boolean;
	    stopEditing?: TableDropdownActionsCellProps['stopEditing'];
	    column?: TableDropdownActionsCellProps['column'];
	    api?: TableDropdownActionsCellProps['api'];
	    rowIndex?: TableDropdownActionsCellProps['node']['rowIndex'];
	    hasDropdownActions?: boolean;
	    elementId: string;
	    level: number;
	} function TableInlineActions({ inlineActions, isEditing }: TableInlineActionsProps): React.ReactElement; const _default: import("react-redux").ConnectedComponent<typeof TableInlineActions, {
	    actions?: import("../../types").GridRowActionType | undefined;
	    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
	    column?: import("@ag-grid-community/core").Column<any> | undefined;
	    fieldId: string;
	    hasDropdownActions?: boolean | undefined;
	    hasInlineActions?: boolean | undefined;
	    isDisabled?: boolean | undefined;
	    isEditing?: boolean | undefined;
	    isPhantomRow?: boolean | undefined;
	    level: number;
	    onTelemetryEvent?: import("../../../redux/state").OnTelemetryEventFunction | undefined;
	    recordId: string;
	    rowIndex?: number | null | undefined;
	    rowValue: any;
	    screenId: string;
	    stopEditing?: ((suppressNavigateAfterEdit?: boolean | undefined) => void) | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=table-inline-actions.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/table-dropdown-action-cell' {
	import * as React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { MenuSeparatorType } from 'lib/component/control-objects';
	import type { DropdownActionItem, Nested } from 'lib/component/field/traits';
	import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	type ActionItemType = DropdownActionItem<any> | NestedCollectionItemAction<any> | MenuSeparatorType | NestedCollectionItemActionGroup<any>;
	export interface TableDropdownActionsCellProps extends Omit<CellParams<Nested, any>, 'colDef'> {
	    colDef: {
	        cellRendererParams: {
	            screenId: string;
	            elementId: string;
	            level: number;
	            isParentFieldDisabled: boolean;
	            isReadOnly: boolean;
	            inlineActions: Array<ActionItemType>;
	            dropdownActions: Array<ActionItemType>;
	        };
	    };
	    isEditing: boolean;
	}
	export function TableDropdownActionsCell(props: TableDropdownActionsCellProps): React.ReactElement | null;
	export {};
	//# sourceMappingURL=table-dropdown-action-cell.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-actions' {
	import * as React from 'react';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { NestedRecordId } from 'lib/types';
	import type { GridRowActionType } from 'lib/component/types';
	import type { TableDropdownActionsCellProps } from 'lib/component/ui/table-shared/cell/table-dropdown-action-cell';
	import type { CollectionPropertiesWithActions } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	export interface TableDropdownActionExternalProps {
	    actions?: GridRowActionType;
	    api?: TableDropdownActionsCellProps['api'];
	    column?: TableDropdownActionsCellProps['column'];
	    fieldId: string;
	    hasDropdownActions?: boolean;
	    hasInlineActions?: boolean;
	    isDisabled?: boolean;
	    isEditing?: boolean;
	    isPhantomRow?: boolean;
	    level: number;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	    recordId: NestedRecordId;
	    rowIndex?: TableDropdownActionsCellProps['node']['rowIndex'];
	    rowValue: any;
	    screenId: string;
	    stopEditing?: TableDropdownActionsCellProps['stopEditing'];
	}
	export interface TableDropdownActionProps extends TableDropdownActionExternalProps {
	    fieldProperties: CollectionPropertiesWithActions;
	    tableData: CollectionValue;
	    accessBindings: AccessBindings;
	    rowValue: any;
	}
	export function TableDropdownActions({ accessBindings, api, column, fieldId, fieldProperties, hasInlineActions, isDisabled, isEditing, isPhantomRow, level, recordId, rowIndex, rowValue, screenId, stopEditing, tableData, onTelemetryEvent, }: TableDropdownActionProps): React.ReactNode; const _default: import("react-redux").ConnectedComponent<typeof TableDropdownActions, {
	    actions?: GridRowActionType | undefined;
	    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
	    column?: import("@ag-grid-community/core").Column<any> | undefined;
	    fieldId: string;
	    hasDropdownActions?: boolean | undefined;
	    hasInlineActions?: boolean | undefined;
	    isDisabled?: boolean | undefined;
	    isEditing?: boolean | undefined;
	    isPhantomRow?: boolean | undefined;
	    level: number;
	    onTelemetryEvent?: OnTelemetryEventFunction | undefined;
	    recordId: string;
	    rowIndex?: number | null | undefined;
	    rowValue: any;
	    screenId: string;
	    stopEditing?: ((suppressNavigateAfterEdit?: boolean | undefined) => void) | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=table-dropdown-actions.d.ts.map
}
declare module 'lib/component/ui/xtrem-action-popover' {
	import * as React from 'react';
	import type { HasGenericErrorHandler, HasIcon } from 'lib/component/field/traits';
	import type { MenuSeparatorType } from 'lib/component/control-objects';
	import type { TableDropdownActionExternalProps } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-actions';
	export interface XtremActionPopoverItem extends HasIcon, HasGenericErrorHandler<any> {
	    key: string;
	    title: string;
	    onClick: () => void;
	    isDisabled?: boolean;
	    isHidden?: boolean;
	    isDestructive?: boolean;
	    testId?: string;
	    childrenProp?: Array<XtremActionPopoverItem | MenuSeparatorType>;
	    pendoId?: string;
	}
	export interface XtremActionPopoverExternalProps {
	    api?: TableDropdownActionExternalProps['api'];
	    color?: string;
	    column?: TableDropdownActionExternalProps['column'];
	    hasInlineActions?: boolean;
	    isDisabled?: boolean;
	    isEditing?: TableDropdownActionExternalProps['isEditing'];
	    isOverSidebar?: boolean;
	    items: Array<XtremActionPopoverItem | MenuSeparatorType>;
	    menuRef?: React.MutableRefObject<(HTMLSpanElement & HTMLButtonElement) | null>;
	    noIconSupport?: boolean;
	    onOpen?: () => void;
	    pendoId?: string;
	    rowIndex?: TableDropdownActionExternalProps['rowIndex'];
	    stopEditing?: TableDropdownActionExternalProps['stopEditing'];
	}
	export interface XtremActionPopoverProps extends XtremActionPopoverExternalProps {
	    isDeviceLessThanSmall: boolean;
	}
	export function XtremActionPopover({ color, isDeviceLessThanSmall, isDisabled, isEditing, isOverSidebar, items, menuRef, noIconSupport, onOpen, pendoId, }: XtremActionPopoverProps): React.ReactNode; const _default: import("react-redux").ConnectedComponent<typeof XtremActionPopover, {
	    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
	    color?: string | undefined;
	    column?: import("@ag-grid-community/core").Column<any> | undefined;
	    hasInlineActions?: boolean | undefined;
	    isDisabled?: boolean | undefined;
	    isEditing?: boolean | undefined;
	    isOverSidebar?: boolean | undefined;
	    items: ("MENU_SEPARATOR" | XtremActionPopoverItem)[];
	    menuRef?: React.MutableRefObject<(HTMLSpanElement & HTMLButtonElement) | null> | undefined;
	    noIconSupport?: boolean | undefined;
	    onOpen?: (() => void) | undefined;
	    pendoId?: string | undefined;
	    rowIndex?: number | null | undefined;
	    stopEditing?: ((suppressNavigateAfterEdit?: boolean | undefined) => void) | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=xtrem-action-popover.d.ts.map
}
declare module 'lib/utils/action-menu-utils' {
	import type { MenuSeparatorType } from 'lib/component/control-objects';
	import type { DropdownActionItem, ErrorHandlerFunction } from 'lib/component/field/traits';
	import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import type { XtremActionPopoverItem } from 'lib/component/ui/xtrem-action-popover';
	import type { AccessBindings } from 'lib/service/page-definition';
	export type ActionType = 'pod-action' | 'pod-collection-action' | 'table-dropdown-action' | 'table-inline-action' | 'table-sidebar-header-dropdown-action' | 'table-sidebar-header-quick-action';
	export interface CalculateActionMenuPropsWithSeparator {
	    accessBindings: AccessBindings;
	    actions?: Array<DropdownActionItem<any> | NestedCollectionItemAction<any> | MenuSeparatorType | NestedCollectionItemActionGroup<any>>;
	    actionType: ActionType;
	    screenId: string;
	    onTriggerMenuItem: (context: {
	        id?: string;
	        uniqueId: string;
	    }, eventHandler: (this: any, recordId: string, rowItem: any, level?: number, parentIds?: string[]) => void, errorHandler?: ErrorHandlerFunction<any>) => void;
	    rowValue?: any;
	    pendoId?: string;
	}
	export interface CalculateActionMenuProps {
	    accessBindings: AccessBindings;
	    actions?: Array<DropdownActionItem<any> | NestedCollectionItemAction<any>>;
	    onTriggerMenuItem: (context: {
	        id?: string;
	        uniqueId: string;
	    }, isDisabled: boolean, eventHandler: (this: any, recordId: string, rowItem: any, level?: number, parentIds?: string[]) => void, errorHandler?: ErrorHandlerFunction<any>) => void;
	    rowValue?: any;
	    screenId: string;
	}
	export function calculateActionMenu(args: CalculateActionMenuPropsWithSeparator): Array<XtremActionPopoverItem>;
	//# sourceMappingURL=action-menu-utils.d.ts.map
}
declare module 'lib/component/ui/nested-block' {
	import type { ClientNode } from '@sage/xtrem-client';
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { NodePropertyType } from 'lib/types';
	import { ContextType } from 'lib/types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { XtremActionPopoverItem } from 'lib/component/ui/xtrem-action-popover';
	import type { FieldKey } from 'lib/component/types';
	import type { Dict } from '@sage/xtrem-shared';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface NestedBlockProps {
	    actionPopoverItems?: XtremActionPopoverItem[];
	    additionalTestId?: string;
	    availableColumns: number;
	    baseClassName?: string;
	    browser?: ReduxResponsive;
	    canSelect?: boolean;
	    contextNode?: NodePropertyType;
	    contextType?: ContextType;
	    headerLabel?: NestedField<any, FieldKey.Label>;
	    hideValidationSummary?: boolean;
	    info?: string;
	    isCloseIconDisplayed?: boolean;
	    isDisabled?: boolean;
	    isHidden?: ValueOrCallbackWithFieldValue<any, boolean>;
	    isReadOnly?: boolean;
	    isSelected?: boolean;
	    isTitleHidden?: ValueOrCallbackWithFieldValue<any, boolean>;
	    item: Partial<PageArticleItem>;
	    level?: number;
	    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
	    nodeTypes?: Dict<FormattedNodeDetails>;
	    noMargin?: boolean;
	    onActionPopoverOpen?: () => void;
	    onBlockClick?: () => void;
	    onBlockRemoved?: () => void;
	    onBlockSelectionChange?: (isSelected: boolean) => void;
	    onChange?: (bind: string, value: any) => Promise<void>;
	    parentElementId: string;
	    readOnlyOverride?: (this: ScreenBase, elementId: string) => boolean | void;
	    recordValue?: ClientNode;
	    screenId: string;
	    title?: NestedField<ScreenBase, NestedFieldTypes> | ValueOrCallbackWithFieldValue<any, string>;
	    validate?: (columnName: string, value: any) => Promise<ValidationResult[]>;
	    validationErrors?: ValidationResult[];
	    warning?: string;
	}
	export interface ConnectedNestedBlockProps extends NestedBlockProps {
	    recordId: string;
	    value?: CollectionValue;
	}
	export interface NestedBlockExternalProps extends ConnectedNestedBlockProps {
	    screenType: string;
	}
	export class NestedBlock extends React.Component<NestedBlockProps> {
	    private readonly onChange;
	    private readonly renderField;
	    private readonly resolveTitle;
	    private readonly getStatusIcon;
	    private renderTitle;
	    private readonly renderHeader;
	    render(): React.ReactNode;
	}
	export const ConnectedNestedBlock: import("react-redux").ConnectedComponent<React.ComponentType<NestedBlockProps>, {
	    recordId: string;
	    value?: CollectionValue<any> | undefined;
	    actionPopoverItems?: XtremActionPopoverItem[] | undefined;
	    additionalTestId?: string | undefined;
	    availableColumns: number;
	    baseClassName?: string | undefined;
	    browser?: ReduxResponsive | undefined;
	    canSelect?: boolean | undefined;
	    contextNode?: NodePropertyType | undefined;
	    contextType?: ContextType | undefined;
	    headerLabel?: NestedField<any, FieldKey.Label, any, any> | undefined;
	    hideValidationSummary?: boolean | undefined;
	    info?: string | undefined;
	    isCloseIconDisplayed?: boolean | undefined;
	    isDisabled?: boolean | undefined;
	    isHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
	    isReadOnly?: boolean | undefined;
	    isSelected?: boolean | undefined;
	    isTitleHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
	    item: Partial<PageArticleItem>;
	    level?: number | undefined;
	    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
	    nodeTypes?: Dict<FormattedNodeDetails> | undefined;
	    noMargin?: boolean | undefined;
	    onActionPopoverOpen?: (() => void) | undefined;
	    onBlockClick?: (() => void) | undefined;
	    onBlockRemoved?: (() => void) | undefined;
	    onBlockSelectionChange?: ((isSelected: boolean) => void) | undefined;
	    onChange?: ((bind: string, value: any) => Promise<void>) | undefined;
	    parentElementId: string;
	    readOnlyOverride?: ((this: ScreenBase, elementId: string) => boolean | void) | undefined;
	    recordValue?: ClientNode | undefined;
	    screenId: string;
	    title?: NestedField<ScreenBase<any, any>, NestedFieldTypes, any, any> | ValueOrCallbackWithFieldValue<any, string> | undefined;
	    validate?: ((columnName: string, value: any) => Promise<ValidationResult[]>) | undefined;
	    validationErrors?: ValidationResult[] | undefined;
	    warning?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<NestedBlockProps, any, any>> | undefined;
	    recordId: string;
	    value?: CollectionValue<any> | undefined;
	    actionPopoverItems?: XtremActionPopoverItem[] | undefined;
	    additionalTestId?: string | undefined;
	    availableColumns: number;
	    baseClassName?: string | undefined;
	    browser?: ReduxResponsive | undefined;
	    canSelect?: boolean | undefined;
	    contextNode?: NodePropertyType | undefined;
	    contextType?: ContextType | undefined;
	    headerLabel?: NestedField<any, FieldKey.Label, any, any> | undefined;
	    hideValidationSummary?: boolean | undefined;
	    info?: string | undefined;
	    isCloseIconDisplayed?: boolean | undefined;
	    isDisabled?: boolean | undefined;
	    isHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
	    isReadOnly?: boolean | undefined;
	    isSelected?: boolean | undefined;
	    isTitleHidden?: ValueOrCallbackWithFieldValue<any, boolean> | undefined;
	    item: Partial<PageArticleItem>;
	    level?: number | undefined;
	    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
	    nodeTypes?: Dict<FormattedNodeDetails> | undefined;
	    noMargin?: boolean | undefined;
	    onActionPopoverOpen?: (() => void) | undefined;
	    onBlockClick?: (() => void) | undefined;
	    onBlockRemoved?: (() => void) | undefined;
	    onBlockSelectionChange?: ((isSelected: boolean) => void) | undefined;
	    onChange?: ((bind: string, value: any) => Promise<void>) | undefined;
	    parentElementId: string;
	    readOnlyOverride?: ((this: ScreenBase, elementId: string) => boolean | void) | undefined;
	    recordValue?: ClientNode | undefined;
	    screenId: string;
	    title?: NestedField<ScreenBase<any, any>, NestedFieldTypes, any, any> | ValueOrCallbackWithFieldValue<any, string> | undefined;
	    validate?: ((columnName: string, value: any) => Promise<ValidationResult[]>) | undefined;
	    validationErrors?: ValidationResult[] | undefined;
	    warning?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=nested-block.d.ts.map
}
declare module 'lib/component/field/pod-collection/pod-collection-component' {
	import * as React from 'react';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { NodePropertyType } from 'lib/types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { MenuSeparatorType } from 'lib/component/container/page/page-types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { CollectionItem, FieldKey } from 'lib/component/types';
	import type { CollectionItemAction, CollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { PodCollectionProperties } from 'lib/component/field/pod-collection/pod-collection-types';
	export interface PodCollectionItemProps {
	    _id: string;
	    additionalTestId?: string;
	    canRemoveRecord: boolean;
	    canSelectRecord: boolean;
	    dropdownActions?: Array<CollectionItemAction<any> | CollectionItemActionGroup<any> | MenuSeparatorType>;
	    elementId: string;
	    getRowValue: () => CollectionItem;
	    headerLabel?: NestedField<any, FieldKey.Label>;
	    isDisabled: boolean;
	    isReadOnly: boolean;
	    isSelected: boolean;
	    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
	    node?: NodePropertyType;
	    onPodChange: (bind: string, value: any) => Promise<void>;
	    onPodClick: () => void;
	    onPodRemoved: () => Promise<void>;
	    onPodSelectionChange: (isSelected: boolean) => void;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	    podWidth: any;
	    screenId: string;
	    title?: NestedField<ScreenBase, NestedFieldTypes> | ValueOrCallbackWithFieldValue<any, string>;
	}
	export const PodCollectionItem: React.FC<PodCollectionItemProps>;
	interface PodCollectionState {
	    invalidRecordIds: string[];
	}
	export class PodCollectionComponent extends EditableFieldBaseComponent<PodCollectionProperties, CollectionValue, {}, PodCollectionState> {
	    constructor(props: BaseEditableComponentProperties<PodCollectionProperties, CollectionValue>);
	    shouldComponentUpdate(): boolean;
	    private onBlockChange;
	    private getRowValue;
	    private getChildFields;
	    private onPodAdded;
	    private onPodRemoved;
	    private readonly onPodClick;
	    private readonly onPodSelectionChange;
	    private readonly isItemSelected;
	    getTooltipContent: () => React.ReactNode;
	    filterErrors: () => void;
	    unFilterErrors: () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedPodCollectionComponent: import("react-redux").ConnectedComponent<React.ComponentType<{}>, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<{}, any, any>> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedPodCollectionComponent;
	//# sourceMappingURL=pod-collection-component.d.ts.map
}
declare module 'lib/component/field/pod-collection/async-pod-collection-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { PodCollectionComponentProperties } from 'lib/component/field/pod-collection/pod-collection-types';
	export function AsyncConnectedPodCollectionComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncPodCollectionComponent(props: PodCollectionComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-pod-collection-component.d.ts.map
}
declare module 'lib/component/field/detail-list/detail-list-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { QueryArguments } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { OverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldControlObjectInstance, FieldKey, GraphqlCollection, OrderByType } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { ExtensionField, HasFilter, HasNode, HasParent } from 'lib/component/field/traits';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { Extend } from 'lib/service/page-extension';
	export type DetailListNestedTypes = FieldKey.Aggregate | FieldKey.Date | FieldKey.Label | FieldKey.Link | FieldKey.Numeric | FieldKey.Reference | FieldKey.Text;
	export interface DetailListProperties<CT extends ScreenExtension<CT> = ScreenBase, ItemType extends ClientNode = any> extends ReadonlyFieldProperties<CT>, HasFilter<CT, ItemType>, HasNode<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	    /** The column or the set of columns which the table should be sorted by */
	    orderBy?: OrderByType<ItemType>;
	    /** The definitions of the nested fields used to represent the list */
	    fields: NestedField<CT, DetailListNestedTypes, ItemType>[];
	    /** Function to be executed when any part of an item is clicked */
	    onRecordClick?: (this: CT, item: ItemType) => void;
	}
	export interface InternalDetailListProperties {
	    loadDetailListData: (screenId: string, elementId: string, fields: NestedField<ScreenBase, NestedFieldTypes>[], queryArguments: QueryArguments, bind?: PropertyValueType) => void;
	    isLoading: boolean;
	}
	export interface DetailListDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends DetailListProperties<CT, ReferencedItemType> {
	}
	export interface DetailListExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> extends OverrideDecoratorProperties<DetailListDecoratorProperties<Extend<CT>, ReferencedItemType>> {
	    onRecordClickAfter?: (this: CT, item: ReferencedItemType) => void;
	    /** The definitions of the nested fields used to represent the table rows */
	    fields?: NestedExtensionField<CT, DetailListNestedTypes, ReferencedItemType>[];
	    /** Allows overriding existing column properties in the base page's columns */
	    fieldOverrides?: NestedOverrideField<CT, DetailListNestedTypes, ReferencedItemType>[];
	}
	export type DetailListComponentProps = BaseEditableComponentProperties<DetailListProperties, GraphqlCollection, InternalDetailListProperties>;
	//# sourceMappingURL=detail-list-types.d.ts.map
}
declare module 'lib/component/field/detail-list/detail-list-component' {
	import React from 'react';
	import type { DetailListComponentProps } from 'lib/component/field/detail-list/detail-list-types';
	export function DetailListComponent(props: DetailListComponentProps): React.ReactElement;
	export const ConnectedDetailListComponent: import("react-redux").ConnectedComponent<typeof DetailListComponent, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDetailListComponent;
	//# sourceMappingURL=detail-list-component.d.ts.map
}
declare module 'lib/component/field/detail-list/async-detail-list-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { DetailListComponentProps } from 'lib/component/field/detail-list/detail-list-types';
	export function AsyncConnectedDetailListComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncDetailListComponent(props: DetailListComponentProps): React.ReactElement;
	//# sourceMappingURL=async-detail-list-component.d.ts.map
}
declare module 'lib/component/field/message/message-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	export type MessageVariant = 'error' | 'info' | 'success' | 'warning';
	export interface MessageProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT> {
	    content?: string;
	    isMarkdown?: boolean;
	    variant?: MessageVariant;
	}
	export interface MessageDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<MessageProperties<CT>, '_controlObjectType'>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
	}
	export type MessageComponentProps = BaseEditableComponentProperties<MessageDecoratorProperties<any>, string>;
	//# sourceMappingURL=message-types.d.ts.map
}
declare module 'lib/component/field/field-base-utils' {
	import * as xtremRedux from 'lib/redux';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import type { EditableFieldComponentProperties, FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	export const handleChange: (bind: string, value: any, setFieldValue: (bind: string, value: any) => void, validate?: (bind: string, value: any) => Promise<string | undefined>, onChange?: () => void) => void;
	export const mapStateToProps: () => (state: xtremRedux.XtremAppState, props: FieldComponentExternalProperties) => EditableFieldComponentProperties<UiComponentProperties, any>;
	export const mapDispatchToProps: (callback?: (dispatch: xtremRedux.AppThunkDispatch, props: FieldComponentExternalProperties) => Partial<any>) => (dispatch: xtremRedux.AppThunkDispatch, props: FieldComponentExternalProperties) => Partial<EditableFieldComponentProperties<UiComponentProperties, any>>;
	//# sourceMappingURL=field-base-utils.d.ts.map
}
declare module 'lib/component/field/message/message-component' {
	import * as React from 'react';
	import type { MessageComponentProps } from 'lib/component/field/message/message-types';
	export function MessageComponent(props: MessageComponentProps): React.ReactElement;
	export const ConnectedMessageComponent: import("react-redux").ConnectedComponent<typeof MessageComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedMessageComponent;
	//# sourceMappingURL=message-component.d.ts.map
}
declare module 'lib/component/field/message/async-message-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { MessageComponentProps } from 'lib/component/field/message/message-types';
	export function AsyncConnectedMessageComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncMessageComponent(props: MessageComponentProps): React.ReactElement;
	//# sourceMappingURL=async-message-component.d.ts.map
}
declare module 'lib/component/field/multi-reference/multi-reference-component' {
	import type { ClientNode } from '@sage/xtrem-client';
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { MultiReferenceComponentProps, MultiReferenceComponentState, MultiReferenceDecoratorProperties } from 'lib/component/field/multi-reference/multi-reference-types';
	export class MultiReferenceComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<MultiReferenceDecoratorProperties<any, T>, T[], NestedFieldsAdditionalProperties, MultiReferenceComponentState> {
	    private readonly lookupButtonRef;
	    private readonly selectInputRef;
	    constructor(props: MultiReferenceComponentProps<T>);
	    private readonly onInputValueChanged;
	    private readonly onMobileInputChange;
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: MultiReferenceComponentProps<T>): void;
	    private readonly onSelectedItemsChange;
	    private readonly openLookupDialog;
	    private readonly closeLookupDialog;
	    private readonly onLookupDialogSelectionFinished;
	    private readonly hasLookupIcon;
	    private readonly getBorderColor;
	    private readonly isLookupDialogOpen;
	    private readonly isLookupDialogOpenMobile;
	    private readonly isReadOnlyAndHasPicture;
	    private readonly mobileAutoSelect;
	    render(): React.ReactNode;
	    private readonly renderMobile;
	    private readonly getItems;
	    private readonly getMinLookupCharacters;
	    private readonly renderDesktop;
	    isRelatedTargetEqualTo: (e: React.FocusEvent<HTMLInputElement>, input: string) => boolean;
	}
	export const ConnectedMultiReferenceComponent: import("react-redux").ConnectedComponent<typeof MultiReferenceComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<MultiReferenceComponent<ClientNode>> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedMultiReferenceComponent;
	//# sourceMappingURL=multi-reference-component.d.ts.map
}
declare module 'lib/component/field/multi-reference/async-multi-reference-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { MultiReferenceComponentProps } from 'lib/component/field/multi-reference/multi-reference-types';
	export function AsyncConnectedMultiReferenceComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncMultiReferenceComponent(props: MultiReferenceComponentProps): React.ReactElement;
	//# sourceMappingURL=async-multi-reference-component.d.ts.map
}
declare module 'lib/component/field/multi-dropdown/multi-dropdown-component' {
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { MultiDropdownInternalProps, MultiDropdownDecoratorProperties } from 'lib/component/field/multi-dropdown/multi-dropdown-types';
	export class MultiDropdownComponent extends EditableFieldBaseComponent<MultiDropdownDecoratorProperties, string[], MultiDropdownInternalProps> {
	    private readonly onChange;
	    private readonly getBorderColor;
	    private readonly getItems;
	    private readonly getReadOnlyValue;
	    render(): React.ReactNode;
	}
	export const ConnectedMultiDropdownComponent: import("react-redux").ConnectedComponent<typeof MultiDropdownComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<MultiDropdownComponent> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedMultiDropdownComponent;
	//# sourceMappingURL=multi-dropdown-component.d.ts.map
}
declare module 'lib/component/field/multi-dropdown/async-multi-dropdown-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { MultiDropdownComponentProps } from 'lib/component/field/multi-dropdown/multi-dropdown-types';
	export function AsyncConnectedMultiDropdownComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncMultiDropdownComponent(props: MultiDropdownComponentProps): React.ReactElement;
	//# sourceMappingURL=async-multi-dropdown-component.d.ts.map
}
declare module 'lib/component/field/select/select-component' {
	import * as React from 'react';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { SelectComponentProps, SelectDecoratorProperties, SelectAdditionalProperties } from 'lib/component/field/select/select-types';
	export class SelectComponent extends EditableFieldBaseComponent<SelectDecoratorProperties, string, SelectAdditionalProperties, {}> {
	    static resolveDisplayValueFromProps(props: SelectComponentProps, value?: string): string;
	    private readonly onInputValueChanged;
	    onChange: (selectedItem: SelectItem | undefined, isOrganicChange: boolean) => void;
	    getItems: (searchText: string) => Promise<SelectItem[]>;
	    render(): React.ReactNode;
	}
	export const ConnectedSelectComponent: import("react-redux").ConnectedComponent<typeof SelectComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<SelectComponent> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedSelectComponent;
	//# sourceMappingURL=select-component.d.ts.map
}
declare module 'lib/component/field/select/async-select-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { SelectComponentProps } from 'lib/component/field/select/select-types';
	export function AsyncConnectedSelectComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncSelectComponent(props: SelectComponentProps): React.ReactElement;
	//# sourceMappingURL=async-select-component.d.ts.map
}
declare module 'lib/component/field/dropdown-list/dropdown-list-component' {
	import React from 'react';
	import type { DropdownListComponentProps } from 'lib/component/field/dropdown-list/dropdown-list-types';
	export const DropdownListComponent: React.FC<DropdownListComponentProps>;
	export const ConnectedDropdownListComponent: import("react-redux").ConnectedComponent<React.FC<DropdownListComponentProps>, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDropdownListComponent;
	//# sourceMappingURL=dropdown-list-component.d.ts.map
}
declare module 'lib/component/field/dropdown-list/async-dropdown-list-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { DropdownListComponentProps } from 'lib/component/field/dropdown-list/dropdown-list-types';
	export function AsyncConnectedDropdownListComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncDropdownListComponent(props: DropdownListComponentProps): React.ReactElement;
	//# sourceMappingURL=async-dropdown-list-component.d.ts.map
}
declare module 'lib/component/field/filter-editor/filter-editor-types' {
	import type { Dict, FilterProperty } from '@sage/xtrem-shared';
	import type { DefaultPropertyType, FilterParameter } from '@sage/xtrem-ui-components';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent, HasPlaceholder, Sizable } from 'lib/component/field/traits';
	export interface FilterEditorProperties<CT extends ScreenExtension<CT> = ScreenBase, NodeType = void> extends EditableFieldProperties<CT, NodeType>, HasPlaceholder, Sizable {
	    /** The GraphQL node that the field suggestions will be fetched from */
	    node?: string;
	    /** List of properties that are displayed as fields for the filter */
	    selectedProperties?: Dict<DefaultPropertyType>;
	    /** External filter parameters, ignored in parameter usage mode */
	    filterParameters?: FilterParameter[];
	    /** Whether the filter should create new parameters or should display a list of existing parameters */
	    parameterMode?: 'creation' | 'usage';
	}
	export interface FilterEditorDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<FilterEditorProperties<CT>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, Sizable {
	    /** Ensures that all columns sized automatically  */
	    automaticColumnsSpacing?: boolean;
	}
	export type FilterEditorExtensionDecoratorProperties<CT extends ScreenExtension<CT>> = ChangeableOverrideDecoratorProperties<FilterEditorDecoratorProperties<Extend<CT>>, CT>;
	export type FilterEditorComponentProps = BaseEditableComponentProperties<FilterEditorDecoratorProperties<any>, FilterEditorFieldValue>;
	export interface FilterEditorFieldValue {
	    filters: (FilterProperty & {
	        _id: string;
	    })[];
	    parameters: FilterParameter[];
	}
	//# sourceMappingURL=filter-editor-types.d.ts.map
}
declare module 'lib/component/field/filter-editor/filter-editor-component' {
	import * as React from 'react';
	import type { FilterEditorComponentProps } from 'lib/component/field/filter-editor/filter-editor-types';
	export const changeEventHandler: (screenId: string, elementId: string) => () => Promise<void>;
	export function FilterEditorComponent(props: FilterEditorComponentProps): React.ReactElement;
	export const ConnectedFilterEditorComponent: import("react-redux").ConnectedComponent<typeof FilterEditorComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedFilterEditorComponent;
	//# sourceMappingURL=filter-editor-component.d.ts.map
}
declare module 'lib/component/field/filter-editor/async-filter-editor-component' {
	import * as React from 'react';
	import type { FilterEditorComponentProps } from 'lib/component/field/filter-editor/filter-editor-types';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	export function AsyncConnectedFilterEditorComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncFilterEditorComponent(props: FilterEditorComponentProps): React.ReactElement;
	//# sourceMappingURL=async-filter-editor-component.d.ts.map
}
declare module 'lib/component/field/filter-select/filter-select-component' {
	import type { ClientNode } from '@sage/xtrem-client';
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { FilterSelectComponentProps, FilterSelectState, FilterSelectDecoratorProperties } from 'lib/component/field/filter-select/filter-select-types';
	export class FilterSelectComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<FilterSelectDecoratorProperties<any, T>, string, {}, FilterSelectState> {
	    private readonly lookupButtonRef;
	    private searchText;
	    private readonly selectInputRef;
	    constructor(props: FilterSelectComponentProps<T>);
	    private readonly onInputValueChanged;
	    private readonly getSearchTextFromValue;
	    private readonly getSelectedItemFromValue;
	    private readonly onChangeCallback;
	    private readonly getItems;
	    private readonly getSelectItemsFromNodes;
	    private readonly getSelectItemFromCollectionItem;
	    private readonly getLocalizedSuffix;
	    private readonly getNewItem;
	    private readonly isMobileLookupDialogOpen;
	    private readonly isMobileSize;
	    private readonly triggerOpenFilterSelectDialogEvent;
	    private readonly triggerChangeEvent;
	    private readonly onMobileButtonClick;
	    private readonly onLookupDialogSelectionFinished;
	    private readonly onLookupDialogClose;
	    private readonly mobileAutoSelect;
	    private readonly onMobileInputChange;
	    private readonly onChange;
	    private renderMobile;
	    private readonly getMinLookupCharacters;
	    renderDesktop(): React.ReactNode;
	    render(): React.ReactNode;
	}
	export const ConnectedFilterSelectComponent: import("react-redux").ConnectedComponent<typeof FilterSelectComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<FilterSelectComponent<ClientNode>> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedFilterSelectComponent;
	//# sourceMappingURL=filter-select-component.d.ts.map
}
declare module 'lib/component/field/filter-select/async-filter-select-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { FilterSelectComponentProps } from 'lib/component/field/filter-select/filter-select-types';
	export function AsyncConnectedFilterSelectComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncFilterSelectComponent(props: FilterSelectComponentProps): React.ReactElement;
	//# sourceMappingURL=async-filter-select-component.d.ts.map
}
declare module 'lib/component/field/button/button-types' {
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { Clickable, ExtensionField, HasParent, Mappable, Sizable, HasShortcuts } from 'lib/component/field/traits';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	export interface ButtonProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT>, Sizable, HasShortcuts {
	    /** The border color of the button */
	    borderColor?: ValueOrCallbackWithFieldValue<CT, string>;
	}
	export interface ButtonDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<ButtonProperties<CT>, '_controlObjectType'>, Mappable<CT>, Clickable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export type ButtonComponentProps = BaseReadonlyComponentProperties<ButtonProperties, string, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=button-types.d.ts.map
}
declare module 'lib/component/field/button/button-component' {
	import type { ButtonProps } from 'carbon-react/esm/components/button';
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { ButtonDecoratorProperties } from 'lib/component/field/button/button-types';
	export class ButtonComponent extends ReadonlyFieldBaseComponent<ButtonDecoratorProperties, string, {
	    icon?: IconType;
	    buttonType?: ButtonProps['buttonType'];
	    isDestructive?: boolean;
	    onClick?: () => void;
	}> {
	    getFocusableElement(element: HTMLElement): HTMLButtonElement | null;
	    onClick: () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedButtonComponent: import("react-redux").ConnectedComponent<typeof ButtonComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    icon?: IconType | undefined;
	    buttonType?: ButtonProps['buttonType'];
	    onClick?: (() => void) | undefined;
	    isDestructive?: boolean | undefined;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<ButtonComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedButtonComponent;
	//# sourceMappingURL=button-component.d.ts.map
}
declare module 'lib/component/field/button/async-button-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ButtonComponentProps } from 'lib/component/field/button/button-types';
	export function AsyncConnectedButtonComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncButtonComponent(props: ButtonComponentProps): React.ReactElement;
	//# sourceMappingURL=async-button-component.d.ts.map
}
declare module 'lib/component/field/card/card-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/container/container-control-objects';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Clickable, ExtensionField, HasHelperText, HasNode, HasParent } from 'lib/component/field/traits';
	export interface CardProperties<CT extends ScreenExtension<CT> = ScreenBase, NodeType extends ClientNode = any> extends ReadonlyFieldProperties<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, HasHelperText, HasNode<CT> {
	    cardDefinition: CardDefinition<CT, NodeType>;
	}
	export interface CardDecoratorProperties<CT extends ScreenBase, NodeType extends ClientNode = any> extends Omit<CardProperties<CT, NodeType>, '_controlObjectType'> {
	}
	export type CardComponentProps = BaseReadonlyComponentProperties<CardProperties, {
	    query: {
	        totalCard: number;
	    };
	}, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=card-types.d.ts.map
}
declare module 'lib/component/field/card/card-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { CardProperties } from 'lib/component/field/card/card-types';
	export class CardComponent extends ReadonlyFieldBaseComponent<CardProperties, any> {
	    render(): React.ReactElement;
	}
	export const ConnectedCardComponent: import("react-redux").ConnectedComponent<typeof CardComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<CardComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedCardComponent;
	//# sourceMappingURL=card-component.d.ts.map
}
declare module 'lib/component/field/card/async-card-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { CardComponentProps } from 'lib/component/field/card/card-types';
	export function AsyncConnectedCardComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncCardComponent(props: CardComponentProps): React.ReactElement;
	//# sourceMappingURL=async-card-component.d.ts.map
}
declare module 'lib/component/field/file/file-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface FileValue {
	    value: string;
	}
	export interface FileProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    /** File types that can be uploaded. Can be either audio/*, video/*, image/*, an extension name starting with '.'
	     *  or a valid media type. Look at [IANA Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). for a complete list of standard media types.
	     * It is possible to set more than one file type, simply by defining them separated by a comma.
	     */
	    fileTypes?: string;
	    /** Name of the uploaded file */
	    text: string;
	}
	export interface FileDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<FileProperties<CT>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	    onFileInfo?: (this: CT, mimeType: string, length: number, fileName: string) => void;
	}
	export type FileComponentProps = BaseEditableComponentProperties<FileDecoratorProperties, FileValue>;
	//# sourceMappingURL=file-types.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-focus' {
	export const useFocus: (componentRef: any, isInFocus?: boolean, selector?: string) => void;
	//# sourceMappingURL=use-focus.d.ts.map
}
declare module 'lib/component/field/file/file-component' {
	import * as React from 'react';
	import type { FileComponentProps } from 'lib/component/field/file/file-types';
	export function FileComponent(props: FileComponentProps): React.ReactElement;
	export const ConnectedFileComponent: import("react-redux").ConnectedComponent<typeof FileComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedFileComponent;
	//# sourceMappingURL=file-component.d.ts.map
}
declare module 'lib/component/field/file/async-file-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { FileComponentProps } from 'lib/component/field/file/file-types';
	export function AsyncConnectedFileComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncFileComponent(props: FileComponentProps): React.ReactElement;
	//# sourceMappingURL=async-file-component.d.ts.map
}
declare module 'lib/component/field/file-deposit/file-deposit-types' {
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { GraphQLApi } from 'lib/service/graphql-api';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType } from 'lib/types';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance, FileDepositValue } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface FileDepositProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    /** File types that can be uploaded. Can be either audio/*, video/*, image/*, an extension name starting with '.'
	     *  or a valid media type. Look at [IANA Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). for a complete list of standard media types.
	     * It is possible to set more than one file type, simply by defining them separated by a comma.
	     */
	    fileTypes?: string;
	    /** Name of the uploaded file */
	    /** The GraphQL node that the field suggestions will be fetched from */
	    node: keyof ScreenBaseGenericType<CT>;
	}
	export interface FileDepositDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<FileDepositProperties<CT>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export type FileDepositComponentProps = BaseEditableComponentProperties<FileDepositDecoratorProperties, FileDepositValue, {
	    graphApi: GraphQLApi<any>;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}>;
	//# sourceMappingURL=file-deposit-types.d.ts.map
}
declare module 'lib/component/field/file-deposit/file-deposit-component' {
	import * as React from 'react';
	import type { FileDepositComponentProps } from 'lib/component/field/file-deposit/file-deposit-types';
	export function FileDepositComponent(props: FileDepositComponentProps): React.ReactElement;
	export const ConnectedFileDepositComponent: import("react-redux").ConnectedComponent<typeof FileDepositComponent, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedFileDepositComponent;
	//# sourceMappingURL=file-deposit-component.d.ts.map
}
declare module 'lib/component/field/file-deposit/async-file-deposit-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { FileDepositComponentProps } from 'lib/component/field/file-deposit/file-deposit-types';
	export function AsyncConnectedFileDepositComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncFileDepositComponent(props: FileDepositComponentProps): React.ReactElement;
	//# sourceMappingURL=async-file-deposit-component.d.ts.map
}
declare module 'lib/component/field/form-designer/form-designer-types' {
	import type { FilterParameter } from '@sage/xtrem-ui-components';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { OverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { ValueOrCallback } from 'lib/utils/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { BinaryValue, FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	import type { PaperOrientation, PaperSize } from '@sage/xtrem-document-editor';
	export interface FormDesignerDecoratorProperties<CT extends ScreenBase = ScreenBase> extends FormDesignerProperties<CT>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
	    /** The parameters of the form editor */
	    parameters?: ValueOrCallback<CT, FilterParameter[]>;
	    /** Function to be executed when the editor is ready for interaction by the user */
	    onReady?: (this: CT) => void;
	    /** Triggered when the user changes the header content  */
	    onHeaderValueChanged?: (this: CT, newHeaderValue: string) => void;
	    /** Triggered when the user changes the footer content  */
	    onFooterValueChanged?: (this: CT, newFooterValue: string) => void;
	}
	export interface FormDesignerExtensionDecoratorProperties<CT extends ScreenExtension<CT>> extends OverrideDecoratorProperties<FormDesignerDecoratorProperties<Extend<CT>>> {
	}
	export interface FormDesignerProperties<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldProperties<CT> {
	    /** Paper size of the editor view, defaults to A4 */
	    paperSize?: PaperSize;
	    /** Paper orientation of the editor view, defaults to portrait */
	    paperOrientation?: PaperOrientation;
	    /** HTML content of the header */
	    headerValue?: string;
	    /** HTML content of the footer */
	    footerValue?: string;
	    /** Top margin in centimeters */
	    marginTop?: number;
	    /** Bottom margin in centimeters */
	    marginBottom?: number;
	    /** Right margin in centimeters */
	    marginRight?: number;
	    /** Left margin in centimeters */
	    marginLeft?: number;
	}
	export type FormDesignerComponentProperties = BaseEditableComponentProperties<FormDesignerProperties, BinaryValue>;
	export type FormDesignerComponentProps = BaseEditableComponentProperties<FormDesignerDecoratorProperties, BinaryValue, NestedFieldsAdditionalProperties & {
	    isDirty?: boolean;
	}>;
	//# sourceMappingURL=form-designer-types.d.ts.map
}
declare module 'lib/component/field/form-designer/form-designer-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { BinaryValue } from 'lib/component/types';
	import type { FormDesignerComponentProps, FormDesignerDecoratorProperties } from 'lib/component/field/form-designer/form-designer-types';
	export interface FormDesignerComponentState {
	    value: string;
	    headerValue: string;
	    footerValue: string;
	    isDirty: boolean;
	}
	export class FormDesignerComponent extends EditableFieldBaseComponent<FormDesignerDecoratorProperties, BinaryValue, NestedFieldsAdditionalProperties, FormDesignerComponentState> {
	    private actionSubscription;
	    constructor(props: FormDesignerComponentProps);
	    componentWillReceiveProps(nextProps: Readonly<FormDesignerComponentProps>): void;
	    componentWillUnmount(): void;
	    private readonly onReadyEvent;
	    private readonly onChange;
	    private readonly onHeaderChange;
	    private readonly onFooterChange;
	    private readonly getObjectDetails;
	    private readonly onEditorReady;
	    private readonly onObjectInsert;
	    private readonly getDocumentParameters;
	    private readonly onDisplayToast;
	    private readonly contextProvider;
	    render(): React.ReactNode;
	}
	export const ConnectedFormDesignerComponent: import("react-redux").ConnectedComponent<typeof FormDesignerComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<FormDesignerComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedFormDesignerComponent;
	//# sourceMappingURL=form-designer-component.d.ts.map
}
declare module 'lib/component/field/form-designer/async-form-designer-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { FormDesignerComponentProperties } from 'lib/component/field/form-designer/form-designer-types';
	export function AsyncConnectedFormDesignerComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncFormDesignerComponent(props: FormDesignerComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-form-designer-component.d.ts.map
}
declare module 'lib/component/field/icon/icon-types' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { BackgroundColorable, Colorable, Clickable, ExtensionField, HasParent, Mappable, Nested, NestedClickable, Sizable } from 'lib/component/field/traits';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { FontSize } from 'carbon-react/esm/components/icon/icon.style';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject } from 'lib/component/container/block/block-control-object';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	export interface IconDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<IconProperties<CT>, '_controlObjectType'>, Clickable<CT>, Mappable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	    iconSize?: ValueOrCallbackWithFieldValue<CT, FontSize>;
	}
	export interface NestedIconProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<IconProperties<CT>, 'bind'>, Mappable<CT>, Nested<NodeType>, NestedClickable<CT>, Sizable {
	}
	export type IconBackgroundShape = 'circle' | 'rounded-rect' | 'square';
	export type IconBackgroundSize = 'small' | 'medium' | 'large';
	export interface IconProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT>, BackgroundColorable<CT>, Colorable<CT> {
	    /** The background shape of the icon */
	    backgroundShape?: ValueOrCallbackWithFieldValue<CT, IconBackgroundShape>;
	    /** The size of the icon background */
	    backgroundSize?: ValueOrCallbackWithFieldValue<CT, IconBackgroundSize>;
	    /** The size of the icon */
	    iconSize?: ValueOrCallbackWithFieldValue<CT, FontSize>;
	}
	export type IconComponentProps = BaseReadonlyComponentProperties<IconProperties, IconType, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=icon-types.d.ts.map
}
declare module 'lib/component/field/icon/icon-component' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { IconDecoratorProperties } from 'lib/component/field/icon/icon-types';
	export class IconComponent extends ReadonlyFieldBaseComponent<IconDecoratorProperties, IconType, NestedFieldsAdditionalProperties> {
	    getIconElement(): React.ReactNode;
	    render(): React.ReactNode;
	}
	export const ConnectedIconComponent: import("react-redux").ConnectedComponent<typeof IconComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<IconComponent> | undefined;
	    contextType?: ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedIconComponent;
	//# sourceMappingURL=icon-component.d.ts.map
}
declare module 'lib/component/field/icon/async-icon-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { IconComponentProps } from 'lib/component/field/icon/icon-types';
	export function AsyncConnectedIconComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncIconComponent(props: IconComponentProps): React.ReactElement;
	//# sourceMappingURL=async-icon-component.d.ts.map
}
declare module 'lib/component/ui/styled-icon-button' {
	/// <reference types="react" />
	export const StyledIconButton: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("carbon-react/esm/components/button").ButtonProps & import("react").RefAttributes<HTMLButtonElement>>, any, {}, never>;
	//# sourceMappingURL=styled-icon-button.d.ts.map
}
declare module 'lib/component/field/image/image-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { ImageComponentProps, ImageComponentState, ImageValue, ImageDecoratorProperties } from 'lib/component/field/image/image-types';
	import { ContextType } from 'lib/types';
	export class ImageComponent extends EditableFieldBaseComponent<ImageDecoratorProperties, ImageValue, NestedFieldsAdditionalProperties, ImageComponentState> {
	    private readonly fileRef;
	    constructor(props: ImageComponentProps);
	    private readFile;
	    private readonly getPlaceholderValue;
	    private readonly getPlaceholderMode;
	    private readonly onDragOver;
	    private readonly onDrop;
	    private readonly onCreateElementClick;
	    private readonly onFileChanged;
	    private readonly onRemoveImage;
	    private readonly onFullScreenOpen;
	    private readonly onFullScreenClose;
	    private readonly renderRemoveIcon;
	    private readonly renderReadOnlyPlaceholder;
	    private readonly renderValueBody;
	    private readonly renderFullScreenView;
	    private renderUploadArea;
	    render(): React.ReactNode;
	}
	export const ConnectedImageComponent: import("react-redux").ConnectedComponent<typeof ImageComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<ImageComponent> | undefined;
	    contextType?: ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedImageComponent;
	//# sourceMappingURL=image-component.d.ts.map
}
declare module 'lib/component/field/image/async-image-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ImageComponentProps } from 'lib/component/field/image/image-types';
	export function AsyncConnectedImageComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncImageComponent(props: ImageComponentProps): React.ReactElement;
	//# sourceMappingURL=async-image-component.d.ts.map
}
declare module 'lib/component/field/label/label-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { BackgroundColorable, CanBeMandatory, Clickable, Colorable, ExtensionField, HasOptionType, HasParent, Mappable, Nested, NestedClickable, Postfixable, Prefixable, Sizable } from 'lib/component/field/traits';
	export interface LabelProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT>, Postfixable<CT>, Prefixable<CT>, BackgroundColorable<CT>, HasOptionType, Colorable<CT> {
	    /** The border color of the label */
	    borderColor?: ValueOrCallbackWithFieldValue<CT, string>;
	}
	export interface LabelDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<LabelProperties<CT>, '_controlObjectType'>, Clickable<CT>, Mappable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>> {
	}
	export interface NestedLabelProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<LabelProperties<CT>, 'bind'>, Mappable<CT>, Nested<NodeType>, NestedClickable<CT>, Sizable, CanBeMandatory<CT, NodeType> {
	}
	export type LabelComponentProps = BaseReadonlyComponentProperties<LabelProperties, string, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=label-types.d.ts.map
}
declare module 'lib/component/ui/label/label-component' {
	import React from 'react';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { LabelProperties } from 'lib/component/control-objects';
	export interface LabelProps extends LabelProperties {
	    value?: string;
	    rawValue?: string | number;
	    isDisabled?: boolean;
	    onClick?: () => void;
	    rowValue?: object;
	    prefix?: ValueOrCallbackWithFieldValue<any, string>;
	    postfix?: ValueOrCallbackWithFieldValue<any, string>;
	    backgroundColor?: ValueOrCallbackWithFieldValue<any, string>;
	    borderColor?: ValueOrCallbackWithFieldValue<any, string>;
	    color?: ValueOrCallbackWithFieldValue<any, string>;
	    size?: 'M' | 'S';
	    screenId: string;
	}
	export const LabelComponent: React.FC<LabelProps>;
	//# sourceMappingURL=label-component.d.ts.map
}
declare module 'lib/component/field/label/label-component' {
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { LabelDecoratorProperties } from 'lib/component/field/label/label-types';
	export class LabelComponent extends ReadonlyFieldBaseComponent<LabelDecoratorProperties, string, NestedFieldsAdditionalProperties> {
	    render(): React.ReactNode;
	}
	export const ConnectedLabelComponent: import("react-redux").ConnectedComponent<typeof LabelComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<LabelComponent> | undefined;
	    contextType?: ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedLabelComponent;
	//# sourceMappingURL=label-component.d.ts.map
}
declare module 'lib/component/field/label/async-label-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { LabelComponentProps } from 'lib/component/field/label/label-types';
	export function AsyncConnectedLabelComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncLabelComponent(props: LabelComponentProps): React.ReactElement;
	//# sourceMappingURL=async-label-component.d.ts.map
}
declare module 'lib/component/field/plugin/plugin-types' {
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { LocalizeLocale } from '@sage/xtrem-shared';
	import type { XtremUiPlugin, ReduxResponsive } from 'lib/plugin';
	import type { QueryParameters } from 'lib/utils/types';
	export interface PluginDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<PluginProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
	}
	export interface PluginProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    pluginPackage: string;
	}
	export interface PluginAdditionalProps {
	    locale: LocalizeLocale;
	    username: string;
	    pluginImplementation: XtremUiPlugin;
	    queryParameters: QueryParameters;
	    browser?: ReduxResponsive;
	}
	export type PluginComponentFieldProps = BaseEditableComponentProperties<PluginDecoratorProperties, any, PluginAdditionalProps>;
	//# sourceMappingURL=plugin-types.d.ts.map
}
declare module 'lib/component/field/plugin/plugin-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { PluginDecoratorProperties, PluginAdditionalProps, PluginComponentFieldProps } from 'lib/component/field/plugin/plugin-types';
	export class PluginComponent extends EditableFieldBaseComponent<any, PluginDecoratorProperties, any, PluginAdditionalProps> {
	    private readonly router;
	    constructor(props: PluginComponentFieldProps);
	    setFieldValue: (value: any) => void;
	    setFieldProperties: (propertyName: string, propertyValue: any) => void;
	    componentDidCatch(error: Error): void;
	    render(): React.ReactNode;
	}
	export const ConnectedPluginComponent: import("react-redux").ConnectedComponent<typeof PluginComponent, {
	    [x: string]: any;
	    [x: number]: any;
	    [x: symbol]: any;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    [x: string]: any;
	    [x: number]: any;
	    [x: symbol]: any;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedPluginComponent;
	//# sourceMappingURL=plugin-component.d.ts.map
}
declare module 'lib/component/field/plugin/async-plugin-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { PluginComponentFieldProps } from 'lib/component/field/plugin/plugin-types';
	export function AsyncConnectedPluginComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncPluginComponent(props: PluginComponentFieldProps): React.ReactElement;
	//# sourceMappingURL=async-plugin-component.d.ts.map
}
declare module 'lib/component/field/pod/pod-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/container/container-control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { PodNestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasColumns, HasDropdownActions, HasDynamicLookupSuggestions, HasFilter, HasHeaderLabel, HasHelperText, HasLookupDialogTitle, HasNode, HasParent, HasPlaceholder, Sizable, Validatable } from 'lib/component/field/traits';
	export interface PodProperties<CT extends ScreenExtension<CT>, NestedRecordType extends ClientNode = any> extends EditableFieldProperties<CT, NestedRecordType>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasColumns<CT, NestedRecordType, PodNestedFieldTypes>, HasDropdownActions<CT>, HasDynamicLookupSuggestions<CT, NestedRecordType>, HasFilter<CT, NestedRecordType>, HasHeaderLabel<CT, NestedRecordType>, HasHelperText, HasLookupDialogTitle<CT>, HasNode<CT>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, HasPlaceholder, Sizable, Validatable<CT> {
	    /** Label on the add button that is displayed when the field is empty. */
	    addButtonText?: string;
	    /** Pod field can be removed and set to null, default: false */
	    canRemove?: boolean;
	    isReferenceDialogOpen?: boolean;
	    onAddButtonClick?: (this: CT) => Promise<Partial<NestedRecordType>> | Partial<NestedRecordType>;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface PodDecoratorProperties<CT extends ScreenBase, NodeType extends ClientNode> extends Omit<PodProperties<CT, NodeType>, '_controlObjectType'> {
	}
	export type PodComponentProperties = BaseEditableComponentProperties<PodDecoratorProperties<ScreenBase, any>, any>;
	//# sourceMappingURL=pod-types.d.ts.map
}
declare module 'lib/component/ui/pod/pod-component' {
	import * as React from 'react';
	import type { OnTelemetryEventFunction, ReduxResponsive } from 'lib/redux/state';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ContextType } from 'lib/types';
	import type { PodDecoratorProperties } from 'lib/component/decorators';
	export interface PodProps {
	    availableColumns: number;
	    baseAttributesDivWrapper: any;
	    browser?: ReduxResponsive;
	    contextType?: ContextType;
	    elementId: string;
	    fieldProperties: PodDecoratorProperties<ScreenBase, any>;
	    isDisabled: boolean;
	    isReadOnly: boolean;
	    onBlockClick: () => void;
	    onChange?: (bind: string, value: any) => Promise<void>;
	    onNewPod: () => void;
	    onRemove: () => void;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	    screenId: string;
	    validationErrors?: ValidationResult[];
	    value: any;
	}
	export function Pod(props: PodProps): React.ReactElement;
	//# sourceMappingURL=pod-component.d.ts.map
}
declare module 'lib/component/field/pod/pod-component' {
	import * as React from 'react';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { CollectionItem } from 'lib/component/types';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { PodDecoratorProperties } from 'lib/component/field/pod/pod-types';
	export class PodComponent extends EditableFieldBaseComponent<PodDecoratorProperties<ScreenBase, any>, any, NestedFieldsAdditionalProperties> {
	    onChange: (collectionItem: CollectionItem | undefined, isOrganicChange: boolean) => void;
	    onRemove: () => void;
	    onNewPod: () => Promise<void>;
	    isLookupDialogOpen: () => boolean;
	    onLookupDialogSelectionFinished: ([selectedRecord]: SelectItem[]) => void;
	    closeLookupDialog: () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedPodComponent: import("react-redux").ConnectedComponent<typeof PodComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<PodComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=pod-component.d.ts.map
}
declare module 'lib/component/field/pod/async-pod-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { PodComponentProperties } from 'lib/component/field/pod/pod-types';
	export function AsyncConnectedPodComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncPodComponent(props: PodComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-pod-component.d.ts.map
}
declare module 'lib/component/field/radio/radio-types' {
	/// <reference types="react" />
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { CanFetchDefaults, Changeable, ExtensionField, HasOptions, HasParent, Mappable, Sizable, Validatable } from 'lib/component/field/traits';
	export interface RadioProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT>, Sizable, HasOptions<CT>, CanFetchDefaults, Mappable<CT> {
	}
	export interface RadioDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<RadioProperties<CT>, '_controlObjectType'>, Changeable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT>, Sizable {
	}
	export type RadioComponentProps = BaseEditableComponentProperties<RadioProperties, string>;
	export interface CarbonRadioButtonGroupProps {
	    name: string;
	    legend: string;
	    groupName: string;
	    label: string;
	    labelHelp?: string;
	    hasError?: boolean;
	    error?: string;
	    warning?: string;
	    info?: string;
	    value?: string;
	    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
	    styleOverride?: {
	        root?: object;
	        content?: object;
	        legend?: object;
	    };
	}
	export interface CarbonRadioButtonProps {
	    key: string;
	    checked?: boolean;
	    disabled?: boolean;
	    error?: boolean;
	    fieldHelpInline?: boolean;
	    id?: string;
	    inputWidth?: number;
	    label?: string;
	    labelAlign?: 'left' | 'right';
	    labelWidth?: number;
	    name?: string;
	    onChange?: (ev: React.ChangeEvent<HTMLElement>) => void;
	    reverse?: boolean;
	    size?: 'small' | 'large';
	    value: string;
	}
	//# sourceMappingURL=radio-types.d.ts.map
}
declare module 'lib/component/field/radio/radio-component' {
	import type { Dict } from '@sage/xtrem-shared';
	import React from 'react';
	import type { RadioComponentProps } from 'lib/component/field/radio/radio-types';
	type RadioAdditionalProps = RadioComponentProps & {
	    localizedOptions?: Dict<string>;
	    enumOptions?: string[];
	};
	export function RadioComponent(props: RadioAdditionalProps): React.ReactElement;
	export const ConnectedRadioComponent: import("react-redux").ConnectedComponent<typeof RadioComponent, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedRadioComponent;
	//# sourceMappingURL=radio-component.d.ts.map
}
declare module 'lib/component/field/radio/async-radio-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { RadioComponentProps } from 'lib/component/field/radio/radio-types';
	export function AsyncConnectedRadioComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncRadioComponent(props: RadioComponentProps): React.ReactElement;
	//# sourceMappingURL=async-radio-component.d.ts.map
}
declare module 'lib/component/field/separator/separator-types' {
	import type { BaseReadonlyComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { ComponentProperties } from 'lib/component/base-control-object';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface SeparatorProperties<CT extends ScreenBase = ScreenBase> extends ComponentProperties<CT> {
	    /** Whether the field should span all the parent width */
	    isFullWidth?: boolean;
	    /** Whether the HTML element is hidden or not. Defaults to false */
	    isHidden?: ValueOrCallbackWithFieldValue<CT, boolean>;
	    /** It makes the separator element invisible. The separator still preserves its space in the layout, but the line is not displayed. */
	    isInvisible?: boolean;
	}
	export interface SeparatorDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<SeparatorProperties, '_controlObjectType'>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export type SeparatorComponentProperties = BaseReadonlyComponentProperties<SeparatorDecoratorProperties, void>;
	//# sourceMappingURL=separator-types.d.ts.map
}
declare module 'lib/component/field/separator/separator-component' {
	import React from 'react';
	import type { BaseReadonlyComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { SeparatorDecoratorProperties } from 'lib/component/field/separator/separator-types';
	export function SeparatorComponent(props: BaseReadonlyComponentProperties<SeparatorDecoratorProperties, void>): React.ReactElement;
	export const ConnectedSeparatorComponent: import("react-redux").ConnectedComponent<typeof SeparatorComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedSeparatorComponent;
	//# sourceMappingURL=separator-component.d.ts.map
}
declare module 'lib/component/field/separator/async-separator-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { SeparatorComponentProperties } from 'lib/component/field/separator/separator-types';
	export function AsyncConnectedSeparatorComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncSeparatorComponent(props: SeparatorComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-separator-component.d.ts.map
}
declare module 'lib/component/field/step-sequence/step-sequence-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { HasOptions, HasOptionType, HasParent, Mappable, Sizable } from 'lib/component/field/traits';
	import type { BlockControlObject } from 'lib/component/container/block/block-control-object';
	import type { Dict } from '@sage/xtrem-shared';
	import type { StepSequenceItemProps } from 'carbon-react/esm/components/step-sequence';
	export type StepSequenceStatus = Exclude<StepSequenceItemProps['status'], undefined>;
	export interface StepSequenceProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT>, HasOptions<CT>, HasOptionType, Mappable<CT> {
	    isVertical?: boolean;
	    statuses?: Dict<StepSequenceStatus>;
	}
	export interface StepSequenceDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<StepSequenceProperties<CT>, '_controlObjectType'>, HasParent<CT, BlockControlObject<CT>>, Sizable {
	}
	//# sourceMappingURL=step-sequence-types.d.ts.map
}
declare module 'lib/component/field/step-sequence/step-sequence-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import type { StepSequenceDecoratorProperties } from 'lib/component/field/step-sequence/step-sequence-types';
	export class StepSequenceComponent extends ReadonlyFieldBaseComponent<StepSequenceDecoratorProperties, any> {
	    getStatus: ({ index, steps, step, }: {
	        index: number;
	        steps: SelectItem[];
	        step: SelectItem;
	    }) => 'current' | 'complete' | 'incomplete';
	    getSteps: () => SelectItem[];
	    localizeCount: (stepNum: number, totalNum: number) => string;
	    render(): React.ReactNode;
	}
	export const ConnectedStepSequenceComponent: import("react-redux").ConnectedComponent<typeof StepSequenceComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<StepSequenceComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedStepSequenceComponent;
	//# sourceMappingURL=step-sequence-component.d.ts.map
}
declare module 'lib/component/field/step-sequence/async-step-sequence-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	export function AsyncConnectedStepSequenceComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncStepSequenceComponent(props: any): React.ReactElement;
	//# sourceMappingURL=async-step-sequence-component.d.ts.map
}
declare module 'lib/component/field/switch/switch-component' {
	import * as React from 'react';
	import type { SwitchComponentProps } from 'lib/component/field/switch/switch-types';
	export const SwitchComponent: React.FC<SwitchComponentProps>;
	export const ConnectedSwitchComponent: import("react-redux").ConnectedComponent<React.FC<SwitchComponentProps>, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedSwitchComponent;
	//# sourceMappingURL=switch-component.d.ts.map
}
declare module 'lib/component/field/switch/async-switch-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { SwitchComponentProps } from 'lib/component/field/switch/switch-types';
	export function AsyncConnectedSwitchComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncSwitchComponent(props: SwitchComponentProps): React.ReactElement;
	//# sourceMappingURL=async-switch-component.d.ts.map
}
declare module 'lib/component/field/text-area/text-area-types' {
	import type { BaseErrorableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { Changeable, Clickable, ExtensionField, HasParent, HasMaxMinLength, Nested, NestedChangeable, NestedClickable, NestedValidatable, Validatable } from 'lib/component/field/traits';
	import type { ValueOrCallbackWitRecordValue } from 'lib/utils/types';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { ClientNode } from '@sage/xtrem-client';
	export interface TextAreaProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, HasMaxMinLength<CT> {
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** The number of rows the text area will span */
	    rows?: number;
	}
	export interface TextAreaDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<TextAreaProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT, string> {
	}
	export interface NestedTextAreaProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<TextAreaProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, NestedClickable<CT>, Nested<ContextNodeType>, NestedValidatable<CT, string, ContextNodeType> {
	    /** The maximum length of the text field value */
	    maxLength?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
	    /** The minimum length of the text field value */
	    minLength?: ValueOrCallbackWitRecordValue<CT, number, ContextNodeType>;
	}
	export type TextAreaComponentProps = BaseErrorableComponentProperties<TextAreaProperties, string, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=text-area-types.d.ts.map
}
declare module 'lib/component/field/text-area/text-area-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { TextAreaDecoratorProperties } from 'lib/component/field/text-area/text-area-types';
	type TextAreaComponentProps = BaseEditableComponentProperties<TextAreaDecoratorProperties, string>;
	export interface TextAreaComponentState {
	    value: string;
	}
	export class TextAreaComponent extends EditableFieldBaseComponent<TextAreaDecoratorProperties, string, {}, TextAreaComponentState> {
	    constructor(props: TextAreaComponentProps);
	    onChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
	    onBlur: () => void;
	    onKeyDown: (event: KeyboardEvent) => void;
	    UNSAFE_componentWillReceiveProps(nextProps: TextAreaComponentProps): void;
	    getFocusableElement(element: HTMLElement): HTMLTextAreaElement | null;
	    render(): React.ReactNode;
	}
	export const ConnectedTextAreaComponent: import("react-redux").ConnectedComponent<typeof TextAreaComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<TextAreaComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedTextAreaComponent;
	//# sourceMappingURL=text-area-component.d.ts.map
}
declare module 'lib/component/field/text-area/async-text-area-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { TextAreaComponentProps } from 'lib/component/field/text-area/text-area-types';
	export function AsyncConnectedTextAreaComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncTextAreaComponent(props: TextAreaComponentProps): React.ReactElement;
	//# sourceMappingURL=async-text-area-component.d.ts.map
}
declare module 'lib/component/field/text/text-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { TextDecoratorProperties } from 'lib/component/field/text/text-types';
	type TextComponentProps = BaseEditableComponentProperties<TextDecoratorProperties, string, NestedFieldsAdditionalProperties & {
	    isDirty?: boolean;
	}>;
	export interface TextComponentState {
	    value: string;
	    isDirty: boolean;
	}
	export class TextComponent extends EditableFieldBaseComponent<TextDecoratorProperties, string, NestedFieldsAdditionalProperties, TextComponentState> {
	    constructor(props: TextComponentProps);
	    private readonly onInputValueChanged;
	    private readonly onChange;
	    private readonly onBlur;
	    private readonly onKeyDown;
	    private readonly onKeyUp;
	    private readonly onClick;
	    UNSAFE_componentWillReceiveProps(nextProps: TextComponentProps): void;
	    private readonly handleFocus;
	    private readonly handleSelection;
	    render(): React.ReactNode;
	}
	export const ConnectedTextComponent: import("react-redux").ConnectedComponent<typeof TextComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<TextComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedTextComponent;
	//# sourceMappingURL=text-component.d.ts.map
}
declare module 'lib/component/field/text/async-text-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { TextComponentProps } from 'lib/component/field/text/text-types';
	export function AsyncConnectedTextComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncTextComponent(props: TextComponentProps): React.ReactElement;
	//# sourceMappingURL=async-text-component.d.ts.map
}
declare module 'lib/component/field/toggle/toggle-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { CanFetchDefaults, Changeable, Clickable, ExtensionField, HasOptions, HasOptionType, HasParent, Mappable, MappableIcon, Sizable } from 'lib/component/field/traits';
	export interface ToggleProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT>, Sizable, HasOptions<CT>, MappableIcon<CT>, Mappable<CT>, CanFetchDefaults {
	    isGrouped?: boolean;
	}
	export interface ToggleDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<ToggleProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasOptions<CT>, HasOptionType, Sizable {
	}
	export type ToggleComponentProps = BaseEditableComponentProperties<ToggleProperties<any>, string>;
	//# sourceMappingURL=toggle-types.d.ts.map
}
declare module 'lib/component/field/toggle/toggle-component' {
	import type { Dict } from '@sage/xtrem-shared';
	import React from 'react';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { ToggleComponentProps } from 'lib/component/field/toggle/toggle-types';
	type ToggleAdditionalProps = ToggleComponentProps & {
	    localizedOptions?: Dict<string>;
	    enumOptions?: string[];
	} & NestedFieldsAdditionalProperties;
	export function ToggleComponent(props: ToggleAdditionalProps): React.ReactElement;
	export const ConnectedToggleComponent: import("react-redux").ConnectedComponent<typeof ToggleComponent, {
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedToggleComponent;
	//# sourceMappingURL=toggle-component.d.ts.map
}
declare module 'lib/component/field/toggle/async-toggle-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ToggleComponentProps } from 'lib/component/field/toggle/toggle-types';
	export function AsyncConnectedToggleComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncToggleComponent(props: ToggleComponentProps): React.ReactElement;
	//# sourceMappingURL=async-toggle-component.d.ts.map
}
declare module 'lib/component/field/vital-pod/vital-pod-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/container/container-control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { PodNestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasColumns, HasDropdownActions, HasFilter, HasHeaderLabel, HasHelperText, HasNode, HasParent, HasPlaceholder, Sizable, Validatable } from 'lib/component/field/traits';
	export interface VitalPodProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends EditableFieldProperties<CT, NestedRecordType>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasColumns<CT, NestedRecordType, PodNestedFieldTypes>, HasDropdownActions<CT>, HasFilter<CT, NestedRecordType>, HasHeaderLabel<CT, NestedRecordType>, HasHelperText, HasNode<CT>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, HasPlaceholder, Sizable, Validatable<CT> {
	    /** Label on the add button that is displayed when the field is empty. */
	    addButtonText?: string;
	    /** Pod field can be removed and set to null, default: false */
	    canRemove?: boolean;
	    onAddButtonClick?: (this: CT) => Promise<Partial<NestedRecordType>> | Partial<NestedRecordType>;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface VitalPodDecoratorProperties<CT extends ScreenBase, NodeType extends ClientNode> extends Omit<VitalPodProperties<CT, NodeType>, '_controlObjectType'> {
	}
	export type VitalPodComponentProperties = BaseEditableComponentProperties<VitalPodDecoratorProperties<ScreenBase, any>, any>;
	//# sourceMappingURL=vital-pod-types.d.ts.map
}
declare module 'lib/component/field/vital-pod/vital-pod-component' {
	import * as React from 'react';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { VitalPodDecoratorProperties } from 'lib/component/field/vital-pod/vital-pod-types';
	export class VitalPodComponent extends EditableFieldBaseComponent<VitalPodDecoratorProperties<ScreenBase, any>, any, NestedFieldsAdditionalProperties> {
	    onChange: (bind: string, value: any) => Promise<void>;
	    onRemove: () => void;
	    onNewPod: () => Promise<void>;
	    render(): React.ReactNode;
	}
	export const ConnectedVitalPodComponent: import("react-redux").ConnectedComponent<typeof VitalPodComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<VitalPodComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedVitalPodComponent;
	//# sourceMappingURL=vital-pod-component.d.ts.map
}
declare module 'lib/component/field/vital-pod/async-vital-pod-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { VitalPodComponentProperties } from 'lib/component/field/vital-pod/vital-pod-types';
	export function AsyncConnectedVitalPodComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncVitalPodComponent(props: VitalPodComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-vital-pod-component.d.ts.map
}
declare module 'lib/component/field/link/link-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { CanBeMandatory, Clickable, ExtensionField, HasDynamicIcon, HasDynamicNestedIcon, HasParent, Mappable, Nested, NestedClickable, Sizable } from 'lib/component/field/traits';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { QueryParameters, ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	export interface LinkProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT> {
	}
	export interface LinkDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<LinkProperties<CT>, '_controlObjectType'>, Clickable<CT>, Mappable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, HasDynamicIcon<CT> {
	    /** The page to navigate to on link click */
	    page?: ValueOrCallbackWithFieldValue<CT, string, void>;
	    queryParameters?: ValueOrCallbackWithFieldValue<CT, QueryParameters, string, void>;
	}
	export interface NestedLinkProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<LinkProperties<CT>, 'bind'>, NestedClickable<CT>, Mappable<CT>, Nested<ContextNodeType>, Sizable, CanBeMandatory<CT, ContextNodeType>, HasDynamicNestedIcon<CT, ContextNodeType> {
	    /** The page to navigate to on link click */
	    page?: ValueOrCallbackWithFieldValue<CT, string, ContextNodeType>;
	    queryParameters?: ValueOrCallbackWithFieldValue<CT, QueryParameters, string, ContextNodeType>;
	}
	export type LinkComponentProps = BaseReadonlyComponentProperties<LinkProperties, string, NestedFieldsAdditionalProperties>;
	//# sourceMappingURL=link-types.d.ts.map
}
declare module 'lib/component/field/link/link-utils' {
	import type { LinkDecoratorProperties, NestedLinkProperties } from 'lib/component/field/link/link-types';
	import type { QueryParameters } from 'lib/utils/types';
	export const getQueryParameters: (screenId: string, fieldProperties: Omit<LinkDecoratorProperties | NestedLinkProperties, 'onClick'>, fieldValue: any, rowValue?: any) => QueryParameters;
	export const getQueryParametersAsString: (screenId: string, fieldProperties: Omit<LinkDecoratorProperties | NestedLinkProperties, 'onClick'>, fieldValue: any, rowValue?: any) => string;
	export const getPage: (screenId: string, fieldProperties: Omit<LinkDecoratorProperties | NestedLinkProperties, 'onClick'>, fieldValue: any, rowValue?: any) => string;
	export const getTextLink: (screenId: string, fieldProperties: Omit<LinkDecoratorProperties | NestedLinkProperties, 'onClick'>, fieldValue: any, rowValue?: any) => string;
	//# sourceMappingURL=link-utils.d.ts.map
}
declare module 'lib/component/field/link/link-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { LinkDecoratorProperties } from 'lib/component/field/link/link-types';
	export class LinkComponent extends ReadonlyFieldBaseComponent<LinkDecoratorProperties, string, NestedFieldsAdditionalProperties> {
	    private readonly onClick;
	    getFocusableElement(element: HTMLElement): HTMLButtonElement | null;
	    render(): React.ReactNode;
	}
	export const ConnectedLinkComponent: import("react-redux").ConnectedComponent<typeof LinkComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<LinkComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedLinkComponent;
	//# sourceMappingURL=link-component.d.ts.map
}
declare module 'lib/component/field/link/async-link-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { LinkComponentProps } from 'lib/component/field/link/link-types';
	export function AsyncConnectedLinkComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncLinkComponent(props: LinkComponentProps): React.ReactElement;
	//# sourceMappingURL=async-link-component.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-cell-editor-utils' {
	/// <reference types="react" />
	/// <reference types="lodash" />
	import type { Column, SuppressKeyboardEventParams } from '@ag-grid-community/core';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ScreenBase } from 'lib/service/screen-base';
	export function isLeftOrRight(event: React.KeyboardEvent): boolean;
	export function isCharNumeric(charStr: string): boolean;
	export function isAllowedDateCharacter(charStr: string): boolean;
	export function isValidUrl(text: string): boolean;
	export function getInitialCellEditorState<T>({ eventKey, initialValue, isNumeric, }: {
	    eventKey: string | null;
	    initialValue: T;
	    isNumeric?: boolean;
	}): {
	    value: T | string;
	    highlightOnFocus: boolean;
	};
	export function isKeyPressedNumeric(event: React.KeyboardEvent): boolean;
	export function isKeyPressedDateComponent(event: React.KeyboardEvent): boolean;
	export function isFinishedEditingPressed(event: React.KeyboardEvent): boolean;
	export const defaultCellRendederStyles: React.CSSProperties;
	export const defaultCellEditorStyles: React.CSSProperties;
	export const setDefaultAgGridInputStyles: (input: HTMLInputElement) => void;
	export const getColumnsToExport: (columns: Column[]) => Column[];
	export const cellExportFormatter: (column: NestedField<ScreenBase, NestedFieldTypes, any>, value?: string | number | null) => string;
	export interface GetRowClassRulesOptions {
	    canSelect: boolean;
	    openedRecordId?: string | number | null;
	    isChangeIndicatorDisabled?: boolean;
	}
	export const getRowClassRules: (({ canSelect, openedRecordId, isChangeIndicatorDisabled }: GetRowClassRulesOptions) => any) & import("lodash").MemoizedFunction;
	export const isBackwardTabOnInput: (keyboardEvent: any) => boolean;
	export const isForwardTabOnButton: (keyboardEvent: any) => boolean;
	export const suppressKeyboardEventForReferenceCellEditor: (params: SuppressKeyboardEventParams) => boolean;
	export const isBackwardTabOnFirstAction: (keyboardEvent: any, index: number) => boolean;
	export const isForwardTabOnLastAction: (keyboardEvent: any, index: number, length: number) => boolean;
	export const suppressKeyboardEventForActionCellEditor: (params: SuppressKeyboardEventParams) => boolean;
	//# sourceMappingURL=ag-grid-cell-editor-utils.d.ts.map
}
declare module 'lib/component/field/numeric/numeric-component' {
	import * as React from 'react';
	import type { NumericComponentProps } from 'lib/component/field/numeric/numeric-types';
	export function NumericComponent(props: NumericComponentProps): React.ReactElement;
	export const ConnectedNumericComponent: import("react-redux").ConnectedComponent<typeof NumericComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedNumericComponent;
	//# sourceMappingURL=numeric-component.d.ts.map
}
declare module 'lib/component/field/numeric/async-numeric-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { NumericComponentProps } from 'lib/component/field/numeric/numeric-types';
	export function AsyncConnectedNumericComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncNumericComponent(props: NumericComponentProps): React.ReactElement;
	//# sourceMappingURL=async-numeric-component.d.ts.map
}
declare module 'lib/component/field/static-content/static-content-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface StaticContentProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT> {
	    content?: string;
	    isMarkdown?: boolean;
	    maxVisibleLines?: number;
	}
	export interface StaticContentDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<StaticContentProperties<CT>, '_controlObjectType'>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>> {
	}
	export type StaticContentComponentProps = BaseEditableComponentProperties<StaticContentDecoratorProperties<any>, string>;
	//# sourceMappingURL=static-content-types.d.ts.map
}
declare module 'lib/component/field/static-content/static-content-component' {
	import * as React from 'react';
	import type { StaticContentComponentProps } from 'lib/component/field/static-content/static-content-types';
	export function StaticContentComponent({ fieldProperties, screenId, value, elementId, ...rest }: StaticContentComponentProps): React.ReactElement;
	export const ConnectedStaticContentComponent: import("react-redux").ConnectedComponent<typeof StaticContentComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedStaticContentComponent;
	//# sourceMappingURL=static-content-component.d.ts.map
}
declare module 'lib/component/field/static-content/async-static-content-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { StaticContentComponentProps } from 'lib/component/field/static-content/static-content-types';
	export function AsyncConnectedStaticContentComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncStaticContentComponent(props: StaticContentComponentProps): React.ReactElement;
	//# sourceMappingURL=async-static-content-component.d.ts.map
}
declare module 'lib/component/field/tree/tree-types' {
	import type { ReduxResponsive, TableView, TableViewGrouping, TableViewSortedColumn } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ContextType, NestedRecordId, ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { Dict, LocalizeLocale, FilterTypeValue } from '@sage/xtrem-shared';
	import type { BlockControlObject, CollectionValueFieldProperties, SectionControlObject, TreeDropdownAction } from 'lib/component/control-objects';
	import type { GridNestedFieldTypes, NestedField } from 'lib/component/nested-fields';
	import type { CollectionItem, FieldControlObjectInstance } from 'lib/component/types';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { CanFetchDefaults, Clickable, ExtensionField, HasColumns, HasFieldActions, HasFilter, HasParent } from 'lib/component/field/traits';
	import type { ClientCollectionValueType } from 'lib/component/field/reference/reference-types';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface TreeComponentExternalProps extends FieldComponentExternalProperties {
	    elementId: string;
	    item?: PageArticleItem;
	    mobilePerformInitialLoadTreeData?: boolean;
	    screenId: string;
	    searchText?: string;
	}
	export interface TreeInternalComponentProps {
	    contextType?: ContextType;
	    elementId: string;
	    fieldProperties: TreeDecoratorProperties<ScreenBase>;
	    onRowClick?: (recordId: NestedRecordId) => () => void;
	    screenId: string;
	    searchText?: string;
	    setFieldProperties?: (elementId: string, properties: TreeDecoratorProperties<ScreenBase>) => void;
	    setTableViewColumnHidden?: (level: number, columnHidden?: Dict<boolean>) => void;
	    setTableViewColumnOrder?: (level: number, columnOrder?: string[]) => void;
	    setTableViewFilter?: (level: number, filter?: any) => void;
	    setTableViewGrouping?: (level: number, grouping?: TableViewGrouping) => void;
	    setTableViewSearchText?: (level: number, searchText: string) => void;
	    setTableViewSortOrder?: (level: number, sortOrder?: TableViewSortedColumn[]) => void;
	    tableViews?: Dict<TableView>;
	    value: CollectionValue;
	    validationErrors: ValidationResult[];
	    fixedHeight?: number;
	}
	export interface TreeComponentProps extends TreeComponentExternalProps {
	    accessBindings: AccessBindings;
	    browser: ReduxResponsive;
	    contextType?: ContextType;
	    dataTypes: Dict<DataTypeDetails>;
	    enableMobileLoadMore?: boolean;
	    enumTypes: Dict<string[]>;
	    fieldProperties: TreeDecoratorProperties<ScreenBase>;
	    isLoading?: boolean;
	    locale: LocalizeLocale;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    onRowClick?: (rowValue: CollectionItem) => void;
	    setFieldProperties?: (elementId: string, properties: TreeDecoratorProperties<ScreenBase>) => void;
	    tableViews: Dict<TableView>;
	    validate?: (elementId: string, value: CollectionValue) => Promise<ValidationResult[] | undefined>;
	    value: CollectionValue;
	}
	export interface FilterValue {
	    filterType: {
	        text: string;
	        value: FilterTypeValue;
	    };
	    filterValue: any;
	}
	export interface TreeDecoratorProperties<CT extends ScreenBase = ScreenBase, NestedRecordType extends ClientNode = any> extends TreeProperties<CT, NestedRecordType>, Clickable<CT>, HasFieldActions<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, CanFetchDefaults {
	    /** Function to be executed when a row is selected */
	    onRowSelected?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType) => void;
	    /** Function to be executed when a row is unselected */
	    onRowUnselected?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType) => void;
	    /** Function to be executed when the tree field's value changes */
	    onChange?: (this: CT, recordId: NestedRecordId, column: string, rowItem: NestedRecordType) => void;
	    /** Function to be executed when any part of a row is clicked */
	    onRowClick?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType) => void;
	}
	export interface TreeProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends CollectionValueFieldProperties<CT, NestedRecordType>, HasFieldActions<CT>, HasFilter<CT, NestedRecordType>, HasColumns<CT, NestedRecordType> {
	    /** Whether the rows of the tree can be selected or not. Defaults to true */
	    canSelect?: boolean;
	    /** Determines how the tree rows are displayed. Defaults to "comfortree" */
	    sublevelProperty: ClientCollectionValueType<NestedRecordType>;
	    /** The master column */
	    masterColumn: NestedField<CT, GridNestedFieldTypes, NestedRecordType>;
	    /** Actions that are rendered at the end of the tree as a drop-down menu */
	    dropdownActions?: TreeDropdownAction<CT>[];
	    /** Selected rows identifiers */
	    selectedRecords?: NestedRecordId[];
	    /** The GraphQL node that the tree represents, needed for filtering */
	    node?: keyof ScreenBaseGenericType<CT>;
	}
	//# sourceMappingURL=tree-types.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/table-loading-cell-renderer' {
	import React from 'react';
	type LoadingCellRendererProps = {
	    elementId: string;
	};
	export function TableLoadingCellRenderer({ elementId }: LoadingCellRendererProps): React.ReactNode;
	export {};
	//# sourceMappingURL=table-loading-cell-renderer.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-strings' {
	/// <reference types="lodash" />
	import type { Dict } from '@sage/xtrem-shared';
	export const localeText: (() => Dict<string>) & import("lodash").MemoizedFunction;
	export default localeText;
	//# sourceMappingURL=ag-grid-strings.d.ts.map
}
declare module 'lib/component/field/tree/desktop-tree-component' {
	import type { CellFocusedEvent, ColumnEverythingChangedEvent, ColumnState, GridApi } from '@ag-grid-community/core';
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	import type { InternalTableProperties, TableInternalComponentProps } from 'lib/component/field/table/table-component-types';
	import type { TreeDecoratorProperties } from 'lib/component/field/tree/tree-types';
	import type { AgGridColumnConfigWithScreenIdAndColDef } from 'lib/utils/ag-grid/ag-grid-utility-types';
	interface TreeDesktopState {
	    columns: AgGridColumnConfigWithScreenIdAndColDef[];
	    columnStates?: ColumnState[];
	    hasFloatingFilters: boolean;
	    isConfigurationDialogOpen?: boolean;
	    phantomRows: any[];
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    selectedRows: any[];
	    tableHasData: boolean;
	    autoGroupColumnDef?: AgGridColumnConfigWithScreenIdAndColDef;
	}
	export class DesktopTreeComponent extends React.Component<TableInternalComponentProps<any, TreeDecoratorProperties<any>>, TreeDesktopState> {
	    private gridApi;
	    private dataOperationMode;
	    private actionSubscription;
	    private collectionValueChangeSubscription;
	    private collectionValidityChangeSubscription;
	    protected containerRef: React.RefObject<HTMLDivElement>;
	    private readonly defaultColDef;
	    private readonly loadingCellRendererParams;
	    constructor(props: TableInternalComponentProps<any, TreeDecoratorProperties<any>>);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: TableInternalComponentProps): void;
	    componentWillUnmount(): void;
	    private readonly getRowNode;
	    private readonly onCollectionUpdated;
	    private getCursor;
	    private getFilters;
	    /** Marks items selected on the table, this function is triggered by changes initiated by a pagination or reset
	     * event
	     **/
	    private readonly selectTableItems;
	    private readonly insertDataSourceIntoTable;
	    private readonly refreshHeader;
	    private readonly updateColumnValidation;
	    private readonly getUnknownLastRow;
	    private readonly getRowCount;
	    /**
	     * Ag-grid callback which is triggered whenever the table component needs new data from our framework
	     * @param getRowsParams
	     */
	    private readonly getRows;
	    private readonly serverSideDataSource;
	    private readonly isDisabled;
	    private readonly isReadOnly;
	    private readonly resizeListener;
	    private readonly getTableViewColumnHidden;
	    private readonly getTableViewFilter;
	    private readonly getTableViewSortOrder;
	    /**
	     * Ag-grid lifecycle event listener. It is triggered when the table is prepared with the initial rendering of the
	     * controller components and is ready to receive data.
	     **/
	    private readonly onGridReady;
	    private readonly updateSelectedRows;
	    private readonly getFilterModel;
	    private readonly handleFilterChanged;
	    private readonly setShouldResetTable;
	    private readonly getRowId;
	    private readonly getRowClass;
	    private readonly gridOptions;
	    private readonly getColumnDefinitions;
	    private readonly hasFilterableColumns;
	    private readonly toggleFloatingFilters;
	    private readonly getServerSideGroupKey;
	    private readonly getCacheBlockSize;
	    private readonly isServerSideGroup;
	    private readonly excludeInternalColumnsFilter;
	    private readonly getAllColumnIds;
	    private readonly getAllDisplayedColumnIds;
	    autoSizeAllColumns: (gridApi?: GridApi | null) => void;
	    private readonly onFirstDataRendered;
	    private readonly sortColumns;
	    private readonly getMainMenuItems;
	    onCellFocused: (params: CellFocusedEvent) => void;
	    getAllNotVisibleNotHiddenColumns: (tableProperties: InternalTableProperties) => string[];
	    hideUnhideColumns: (event?: ColumnEverythingChangedEvent) => void;
	    getDefaultHeight: () => number;
	    private readonly noRowsOverlayComponentParams;
	    private readonly onRowClicked;
	    private readonly rowClassRules;
	    private readonly adjustTableHeight;
	    initColumnState(): Promise<void>;
	    render(): React.ReactNode;
	}
	export const ConnectedDesktopTableComponent: import("react-redux").ConnectedComponent<typeof DesktopTreeComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DesktopTreeComponent> | undefined;
	    bulkActions?: import("../../container/page/page-types").BulkAction[] | undefined;
	    mobilePerformInitialLoadTableData?: boolean | undefined;
	    searchText?: string | undefined;
	    errorMessage?: string | undefined;
	    isParentDisabled?: boolean | undefined;
	    lookupSelectionMode?: "multiple" | "single" | undefined;
	    bind?: any;
	    elementId: string;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDesktopTableComponent;
	//# sourceMappingURL=desktop-tree-component.d.ts.map
}
declare module 'lib/component/field/tree/async-desktop-tree-component' {
	import * as React from 'react';
	import type { TableInternalComponentProps } from 'lib/component/field/table/table-component-types';
	export function AsyncDesktopTreeComponent(props: TableInternalComponentProps): React.ReactElement;
	//# sourceMappingURL=async-desktop-tree-component.d.ts.map
}
declare module 'lib/component/field/tree/tree-component' {
	import * as React from 'react';
	import type { TreeComponentProps } from 'lib/component/field/tree/tree-types';
	import type { NestedRecordId } from 'lib/types';
	export class TreeComponent extends React.Component<TreeComponentProps> {
	    getComponentClass: () => string;
	    onRowClick: (recordId: NestedRecordId) => () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedTreeComponent: import("react-redux").ConnectedComponent<typeof TreeComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<TreeComponent> | undefined;
	    elementId: string;
	    item?: import("../../..").PageArticleItem | undefined;
	    mobilePerformInitialLoadTreeData?: boolean | undefined;
	    screenId: string;
	    searchText?: string | undefined;
	    bind?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedTreeComponent;
	//# sourceMappingURL=tree-component.d.ts.map
}
declare module 'lib/component/field/tree/async-tree-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { TreeComponentProps } from 'lib/component/field/tree/tree-types';
	export function AsyncConnectedTreeComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncTreeComponent(props: TreeComponentProps): React.ReactElement;
	//# sourceMappingURL=async-tree-component.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-search-box-component' {
	import React from 'react';
	import type { InternalNestedGridProperties } from 'lib/component/field/field-control-objects';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	export const getSearchTextboxId: (screenId?: string, elementId?: string) => string | undefined;
	export interface TableSearchBoxProps {
	    disableAutoFocus?: boolean;
	    elementId?: string;
	    fieldProperties?: InternalTableProperties | InternalNestedGridProperties;
	    filterText?: string;
	    isDisabled?: boolean;
	    onSearchBoxValueChange: (searchText: string) => void;
	    screenId?: string;
	}
	export function TableSearchBox({ disableAutoFocus, elementId, fieldProperties, filterText, isDisabled, onSearchBoxValueChange, screenId, }: TableSearchBoxProps): React.ReactElement;
	//# sourceMappingURL=table-search-box-component.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-configuration-dialog/table-configuration-dialog' {
	import React from 'react';
	import type { ColumnPanelColumnState } from 'lib/utils/ag-grid/ag-grid-utility-types';
	export interface TableConfigurationDialogProps {
	    onDialogClose: () => void;
	    isDialogOpen?: boolean;
	    columnPanelColumnStates: ColumnPanelColumnState[];
	    onChangeColumnHiddenState: (colId: string, isHidden: boolean) => void;
	    onOrderChange: (colIds: string[]) => void;
	}
	export function TableConfigurationDialogColumnItem({ c, onVisibilityChanged, }: {
	    c: ColumnPanelColumnState;
	    onVisibilityChanged: (ev: React.ChangeEvent<HTMLInputElement>) => void;
	}): React.ReactElement;
	export function TableConfigurationDialog({ isDialogOpen, onDialogClose, columnPanelColumnStates, onChangeColumnHiddenState, onOrderChange, }: TableConfigurationDialogProps): React.ReactElement;
	export const getNewOrder: (columnState: ColumnPanelColumnState[], filteredColumnState: string[], movedItem: string) => string[];
	//# sourceMappingURL=table-configuration-dialog.d.ts.map
}
declare module 'lib/utils/feature-toggles' {
	export const isUserClientCustomizationEnabled: () => boolean;
	export const isUserClientCustomizationDisabled: () => boolean;
	//# sourceMappingURL=feature-toggles.d.ts.map
}
declare module 'lib/service/user-client-customization-service' {
	export const USER_CLIENT_CUSTOMIZATION_KEY = "userClientCustomizations";
	export type UserClientCustomizationType = 'TableColumnState' | 'NestedGridColumnState';
	export interface UserClientCustomization {
	    data: any;
	    elementId: string;
	    screenId: string;
	    type: UserClientCustomizationType;
	}
	export const getUserClientCustomization: (username: string, screenId: string, elementId: string, type: UserClientCustomizationType) => Promise<UserClientCustomization | null>;
	export const setUserClientCustomization: (username: string, screenId: string, elementId: string, type: UserClientCustomizationType, data: any) => Promise<UserClientCustomization | null>;
	export const clearUserClientCustomization: (username: string, screenId: string, elementId: string, type: UserClientCustomizationType) => Promise<void>;
	//# sourceMappingURL=user-client-customization-service.d.ts.map
}
declare module 'lib/component/field/nested-grid/desktop-nested-grid-component' {
	import type { ColDef, ColumnState, GridOptions } from '@ag-grid-community/core';
	import * as React from 'react';
	import type { NestedGridInternalComponentProps } from 'lib/component/field/nested-grid/nested-grid-component-types';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	type RowSelectionMode = 'single' | 'multiple' | undefined;
	interface NestedGridDesktopState {
	    columns: ColDef[];
	    detailCellRendererParams: GridOptions['detailCellRendererParams'];
	    isExportingExcel: boolean;
	    rowSelectionMode: RowSelectionMode;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    isConfigurationDialogOpen?: boolean;
	    columnStates?: ColumnState[];
	    tableHasData?: boolean;
	}
	export class DesktopNestedGridComponent extends React.Component<NestedGridInternalComponentProps, NestedGridDesktopState> {
	    private gridApi;
	    private dataOperationMode;
	    private collectionValueChangeSubscription;
	    private actionSubscription;
	    private readonly containerRef;
	    private readonly collectionValidityChangeSubscriptions;
	    constructor(props: NestedGridInternalComponentProps);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: NestedGridInternalComponentProps): void;
	    componentWillUnmount(): void;
	    private getGridApiByRecordPath;
	    private readonly setShouldResetTable;
	    /**
	     * Child tables are destroyed by ag-grid upon paginating
	     * so we can just collapse them and let the user expand them again
	     */
	    private readonly onPaginationChanged;
	    private readonly onOptionsMenuItemChange;
	    private readonly getRowClass;
	    private readonly isDisabled;
	    private readonly isReadOnly;
	    private readonly noRowsOverlayComponentParams;
	    private readonly onCellKeyDown;
	    private readonly onCellClicked;
	    private readonly getRowNode;
	    private readonly getCommonGridProps;
	    private readonly onRowGroupOpened;
	    private readonly onFilterChanged;
	    private readonly onSortChanged;
	    private readonly focusPhantomRowAndStartEditing;
	    private readonly onCollectionUpdated;
	    private readonly getCurrentlySelectedRecords;
	    private readonly isRecordSelected;
	    /** Marks items selected on the nestedGrid, this function is triggered by changes initiated by a pagination or reset
	     * event
	     **/
	    private readonly selectNestedGridItems;
	    private readonly getParentNode;
	    private readonly unselectParentsRecursive;
	    private readonly selectParentsRecursive;
	    private readonly insertDataSourceIntoNestedGrid;
	    private getCursor;
	    /** Marks items selected on the table, this function is triggered by changes initiated by a pagination or reset
	     * event
	     **/
	    private readonly selectTableItems;
	    private readonly onCellEditingStopped;
	    private readonly onValidityChange;
	    private readonly subscribeToValidationChanges;
	    private readonly setPhantomRow;
	    private readonly getRowCount;
	    /**
	     * Ag-grid callback which is triggered whenever the nestedGrid component needs new data from our framework
	     * @param getRowsParams
	     */
	    private readonly getRows;
	    private readonly serverSideDataSource;
	    /**
	     * Ag-grid lifecycle event listener. It is triggered when the nestedGrid is prepared with the initial rendering of the
	     * controller components and is ready to receive data.
	     **/
	    private readonly onGridReady;
	    /** Event listener, triggered when the user clicks on any part of the row apart from the dropdown actions */
	    private readonly onRowClick;
	    /**
	     * Gets the IDs of all rows that have been selected.
	     *
	     * @private
	     * @memberof DesktopNestedGridComponent
	     */
	    private readonly getSelectedNodes;
	    private readonly getPreviouslySelectedItemIds;
	    /**
	     * Gets the IDs of all the rows that have been unselected.
	     *
	     * @private
	     * @memberof DesktopNestedGridComponent
	     */
	    private readonly getUnselectedIds;
	    private readonly selectRow;
	    private readonly unselectRow;
	    private readonly getNewlySelectedRowIds;
	    private readonly selectUnselectAllChildren;
	    /**
	     * Event listener, triggered when the user clicks the checkbox on the front of the row. Both for selection and
	     * deselection.
	     * */
	    private readonly onSelectionChange;
	    private readonly getRowId;
	    /**
	     * This function gets called whenever a row gets expanded.
	     * This is where the sever-side data source is set.
	     * Information about the grid's level as well as its parent ID & parent grid api is added to ag-grid's context
	     * and is used for filtering, sorting and selection.
	     *
	     * @private
	     * @param {GetDetailRowDataParams} { successCallback, ...params }
	     * @memberof DesktopNestedGridComponent
	     */
	    private readonly getDetailRowData;
	    private readonly getDetailCellRendererParams;
	    private readonly getCollectionValue;
	    private readonly getMainMenuItems;
	    private readonly getAllColumnIds;
	    updateColumnState(): void;
	    private readonly onColumnPanelHiddenStateChange;
	    private readonly onColumnPanelOrderChangeChange;
	    private readonly autoSizeAllColumns;
	    private readonly onFirstDataRendered;
	    private readonly resetOptionsMenu;
	    private readonly getColumnDefinitions;
	    private readonly getCacheBlockSize;
	    private readonly getRowSelectionMode;
	    private readonly loadingCellRendererParams;
	    private readonly onFocusPhantomRow;
	    render(): React.ReactNode;
	}
	export default DesktopNestedGridComponent;
	//# sourceMappingURL=desktop-nested-grid-component.d.ts.map
}
declare module 'lib/component/field/nested-grid/async-desktop-nested-grid-component' {
	import * as React from 'react';
	import type { NestedGridInternalComponentProps } from 'lib/component/field/nested-grid/nested-grid-component-types';
	export function AsyncDesktopNestedGridComponent(props: NestedGridInternalComponentProps): React.ReactElement;
	//# sourceMappingURL=async-desktop-nested-grid-component.d.ts.map
}
declare module 'lib/utils/async' {
	export const asyncForEach: (array: any[], callback: Function) => Promise<void>;
	/**
	 *  Makes a promise cancelable/abortable without libraries or subclassing
	 */
	export const cancelable: <T extends any = any>(promise: Promise<T>) => [() => void, Promise<T>];
	/**
	 *  Takes only last promise call by cancelling the previous ones, avoids race conditions.
	 */
	export const takeLatest: <T extends any = any>() => (promise: Promise<T>) => Promise<T>;
	//# sourceMappingURL=async.d.ts.map
}
declare module 'lib/component/field/table/mobile-table-component' {
	import { type Dict } from '@sage/xtrem-shared';
	import React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	import type { TableInternalComponentProps } from 'lib/component/field/table/table-component-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface MobileTableComponentState {
	    searchText?: string;
	    isFetchingNextPage?: boolean;
	    isLoading?: boolean;
	    hasMorePages: boolean;
	    valuesDisplayed: any[];
	    pageNumber: number;
	}
	export interface MobileTableProps extends TableInternalComponentProps {
	    nodeTypes: Dict<FormattedNodeDetails>;
	    hasFieldActions: boolean;
	    browser: ReduxResponsive;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    openSidebar: (props: {
	        screenId: string;
	        elementId: string;
	    }) => void;
	}
	export class UnconnectedMobileTableComponent extends React.Component<MobileTableProps, MobileTableComponentState> {
	    private readonly takeLatest;
	    constructor(props: MobileTableProps);
	    componentDidMount(): Promise<void>;
	    componentDidUpdate(prevProps: Readonly<MobileTableProps>): Promise<void>;
	    private getCursor;
	    private readonly isNavigationPanel;
	    private readonly toXtremFilters;
	    private readonly isDisabled;
	    private readonly isReadOnly;
	    private readonly subscribeToCollectionValueEvents;
	    private readonly onRowSelected;
	    private readonly canCreateNewItem;
	    private readonly getCreateNewItem;
	    private readonly onRowClick;
	    private readonly refreshTableContent;
	    private readonly onFiltersChanged;
	    private readonly getFilterableFields;
	    private readonly fetchNextPage;
	    private readonly getRows;
	    private readonly getOptionsMenuType;
	    private readonly onScroll;
	    private readonly onKeyDown;
	    private readonly onOptionsMenuItemChanged;
	    private readonly onSearchBoxValueChange;
	    private readonly onResetFilter;
	    private renderMobileHeaderActions;
	    private renderDesktopHeader;
	    private renderOptionsMenu;
	    private renderMobileSearchbox;
	    private renderMobileHeader;
	    render(): React.ReactNode;
	}
	//# sourceMappingURL=mobile-table-component.d.ts.map
}
declare module 'lib/component/field/table/mobile-table-skeleton-card' {
	import React from 'react';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	export interface MobileTableSkeletonCardProps {
	    cardDefinition: CardDefinition;
	}
	export const MobileTableSkeletonCard: React.NamedExoticComponent<MobileTableSkeletonCardProps>;
	//# sourceMappingURL=mobile-table-skeleton-card.d.ts.map
}
declare module 'lib/component/field/nested-grid/nested-grid-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ElementOf } from 'ts-essentials';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ClickableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject, MenuSeparatorType, NestedGridProperties, SectionControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import type { Clickable, ExtensionField, HasFieldActions, HasParent } from 'lib/component/field/traits';
	import type { MappedExtensionLevel, NestedGridItemId } from 'lib/component/field/nested-grid/nested-grid-component-types';
	export interface NestedGridDecoratorProperties<CT extends ScreenBase = ScreenBase, L extends ClientNode[] = [any, any]> extends NestedGridProperties<CT, L>, Clickable<CT>, HasFieldActions<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
	    /** Function to be executed when a row is activated */
	    onRowActivated?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when a row is deactivated */
	    onRowDeactivated?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when a row is selected */
	    onRowSelected?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when a row is unselected */
	    onRowUnselected?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when the nestedGrid field's value changes */
	    onChange?: (this: CT, recordId: NestedGridItemId, column: string, rowItem: ElementOf<L>) => void;
	    /** Function to be executed when any part of a row is clicked */
	    onRowClick?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Actions that are rendered at the end of the nestedGrid as a drop-down menu */
	    dropdownActions?: Array<NestedCollectionItemAction<CT> | MenuSeparatorType | NestedCollectionItemActionGroup<CT>>;
	    /** Displays line numbers in front of each line. The line numbers are static and not related to the data */
	    hasLineNumbers?: boolean;
	}
	type BaseNestedGridExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase, L extends ClientNode[] = any> = {
	    /** Function to be executed when a row is activated and after onRowActivated*/
	    onRowActivatedAfter?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when a row is deactivated and after onRowDeactivated */
	    onRowDeactivatedAfter?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when a row is selected and after onRowSelected*/
	    onRowSelectedAfter?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when a row is unselected and after onRowUnselected*/
	    onRowUnselectedAfter?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>, level: number) => void;
	    /** Function to be executed when the nestedGrid field's value changes and after onChange*/
	    onChangeAfter?: (this: CT, recordId: NestedGridItemId, column: string, rowItem: ElementOf<L>) => void;
	    /** Function to be executed when any part of a row is clicked and after onRowClick */
	    onRowClickAfter?: (this: CT, recordId: NestedGridItemId, rowItem: ElementOf<L>) => void;
	};
	export interface NestedGridExtensionDecoratorProperties<CT extends ScreenExtension<CT>, L extends ClientNode[] = [any, any]> extends BaseNestedGridExtensionDecoratorProperties<Extend<CT>>, ClickableOverrideDecoratorProperties<NestedGridDecoratorProperties<Extend<CT>, L>, CT> {
	    /** The definitions of the nested grid's levels */
	    levels?: MappedExtensionLevel<CT, L>;
	}
	/**
	 * Initializes the decorated member as a [NestedGrid]{@link NestedGridControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [NestedGrid]{@link NestedGridControlObject} field will be initialized with
	 */
	export function nestedGridField<T extends ScreenExtension<T>, L extends ClientNode[] = [any, any]>(properties: NestedGridDecoratorProperties<T, L>): (target: T, name: string) => void;
	export function nestedGridFieldOverride<T extends ScreenExtension<T>, L extends ClientNode[] = [any, any]>(properties: NestedGridExtensionDecoratorProperties<T, L>): (target: T, name: string) => void;
	export {};
	//# sourceMappingURL=nested-grid-decorator.d.ts.map
}
declare module 'lib/component/ui/no-rows-found/no-rows-found-component-types' {
	import type { GridApi } from '@ag-grid-community/core';
	import type { NestedGridDecoratorProperties } from 'lib/component/field/nested-grid/nested-grid-decorator';
	import type { TableDecoratorProperties } from 'lib/component/field/table/table-component-types';
	export interface NoRowsFoundComponentProps {
	    /** Sets a text when no data is available in the table */
	    emptyStateText?: string;
	    /** Sets a complementary text link when no data is available in the table  */
	    emptyStateClickableText?: string;
	    /** Function to be executed when the clickable text is clicked */
	    onEmptyStateLinkClick?: (parentId?: string, level?: number) => void;
	    onRemoveFiltersClick?: () => void;
	    screenId: string;
	    elementId: string;
	    isTree: boolean;
	    isFiltering: boolean;
	    level?: number;
	    parentId?: string;
	    type?: 'link' | 'button';
	    isCardView?: boolean;
	    hasPhantomRow?: boolean;
	}
	export interface TableNoRowsFoundProps {
	    api: GridApi | null;
	    fieldProperties: TableDecoratorProperties;
	    screenId: string;
	    elementId: string;
	    isEditable: boolean;
	}
	export interface NestedGridNoRowsFoundProps {
	    api: GridApi;
	    fieldProperties: NestedGridDecoratorProperties;
	    screenId: string;
	    elementId: string;
	    isFiltering?: boolean;
	}
	//# sourceMappingURL=no-rows-found-component-types.d.ts.map
}
declare module 'lib/component/ui/svg/no-rows' {
	import * as React from 'react';
	export const NoRows: React.MemoExoticComponent<() => React.JSX.Element>;
	//# sourceMappingURL=no-rows.d.ts.map
}
declare module 'lib/component/ui/svg/no-data-found' {
	import * as React from 'react';
	export interface NoDataFoundProps {
	    width?: number;
	    height?: number;
	}
	export const NoDataFound: React.MemoExoticComponent<({ width, height }: NoDataFoundProps) => React.JSX.Element>;
	//# sourceMappingURL=no-data-found.d.ts.map
}
declare module 'lib/component/ui/no-rows-found/no-rows-found-component' {
	import * as React from 'react';
	import type { NestedGridNoRowsFoundProps, NoRowsFoundComponentProps, TableNoRowsFoundProps } from 'lib/component/ui/no-rows-found/no-rows-found-component-types';
	export function EmptyTableComponent({ emptyStateText, emptyStateClickableText, onEmptyStateLinkClick, onRemoveFiltersClick, isTree, screenId, isFiltering, level, parentId, isCardView, hasPhantomRow, }: Partial<NoRowsFoundComponentProps>): React.ReactElement | null;
	/** To be used in ag-grid table */
	export function DesktopTableEmptyComponent({ fieldProperties, api, screenId, elementId, isEditable, }: TableNoRowsFoundProps): React.ReactElement;
	/** To be used in ag-grid nested grid */
	export function DesktopNestedGridEmptyComponent({ fieldProperties, api, screenId, elementId, }: NestedGridNoRowsFoundProps): React.ReactElement;
	//# sourceMappingURL=no-rows-found-component.d.ts.map
}
declare module 'lib/component/ui/mobile-table/mobile-table-component' {
	import React from 'react';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { MobileTableProps } from 'lib/component/field/table/mobile-table-component';
	import type { CollectionItem } from 'lib/component/types';
	export interface UiMobileTableProps {
	    canDragCard?: boolean;
	    elementId: string;
	    fieldProperties: MobileTableProps['fieldProperties'];
	    groupByField: PropertyValueType;
	    hasMorePages: boolean;
	    isDisabled: boolean;
	    isFetchingNextPage?: boolean;
	    isGreaterThanSmall: boolean;
	    isLoading?: boolean;
	    isNavigationPanel: boolean;
	    isUsingInfiniteScroll?: boolean;
	    onFetchNextPage: () => void;
	    onKeyDown?: (event: React.KeyboardEvent<HTMLDivElement>) => void;
	    onResetFilter?: () => void;
	    onRowClick?: (item: any) => (_item: any, isModifierKeyPushed: boolean) => void;
	    onRowSelected: (row: CollectionItem) => Promise<void>;
	    onScroll?: (event: React.SyntheticEvent<HTMLDivElement>) => void;
	    screenId: string;
	    searchText?: string;
	    valuesDisplayed: any[];
	    canAddRecord?: boolean;
	    isNestedGrid?: boolean;
	    dropdownActions?: MobileTableProps['fieldProperties']['dropdownActions'];
	    inlineActions?: MobileTableProps['fieldProperties']['inlineActions'];
	    columns: MobileTableProps['fieldProperties']['columns'];
	}
	export function MobileTable(props: UiMobileTableProps): JSX.Element;
	//# sourceMappingURL=mobile-table-component.d.ts.map
}
declare module 'lib/component/field/nested-grid/mobile-nested-grid-component' {
	import React from 'react';
	import type { InternalNestedGridProperties } from 'lib/component/field/nested-grid/nested-grid-control-object';
	import type { NestedGridItemId } from 'lib/component/field/nested-grid/nested-grid-component-types';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	export interface MobileNestedGridComponentProps {
	    elementId: string;
	    fieldProperties: InternalNestedGridProperties;
	    isDisabled: boolean;
	    onRowClick?: (recordId: NestedGridItemId, level: number) => () => void;
	    screenId: string;
	    isLoading?: boolean;
	    value: CollectionValue;
	    validationErrors: ValidationResult[];
	    openSidebar: (args: {
	        screenId: string;
	        elementId: string;
	        level: number;
	        parentId?: string;
	    }) => void;
	    canAddNewLine: boolean;
	}
	export function MobileNestedGridComponent(props: MobileNestedGridComponentProps): React.ReactElement;
	//# sourceMappingURL=mobile-nested-grid-component.d.ts.map
}
declare module 'lib/component/field/nested-grid/nested-grid-component' {
	import * as React from 'react';
	import type { NestedGridComponentProps, NestedGridItemId } from 'lib/component/field/nested-grid/nested-grid-component-types';
	export class NestedGridComponent extends React.Component<NestedGridComponentProps> {
	    getComponentClass: () => string;
	    onRowClick: (recordId: NestedGridItemId, level: number) => () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedNestedGridComponent: import("react-redux").ConnectedComponent<typeof NestedGridComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<NestedGridComponent> | undefined;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    mobilePerformInitialLoadNestedGridData?: boolean | undefined;
	    screenId: string;
	    searchText?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedNestedGridComponent;
	//# sourceMappingURL=nested-grid-component.d.ts.map
}
declare module 'lib/component/field/nested-grid/async-nested-grid-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { NestedGridComponentProps } from 'lib/component/field/nested-grid/nested-grid-component-types';
	export function AsyncConnectedNestedGridComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncNestedGridComponent(props: NestedGridComponentProps): React.ReactElement;
	//# sourceMappingURL=async-nested-grid-component.d.ts.map
}
declare module 'lib/component/field/relative-date/relative-date-types' {
	import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { Clickable, ExtensionField, HasParent, Nested, NestedClickable, Sizable } from 'lib/component/field/traits';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { ClientNode } from '@sage/xtrem-client';
	export interface RelativeDateDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<RelativeDateProperties<CT>, '_controlObjectType'>, Clickable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable {
	}
	export interface NestedRelativeDateProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<RelativeDateProperties<CT>, 'bind'>, Nested<NodeType>, NestedClickable<CT>, Sizable {
	}
	export interface RelativeDateProperties<CT extends ScreenBase = ScreenBase> extends ReadonlyFieldProperties<CT> {
	}
	export type RelativeDateComponentProps = BaseReadonlyComponentProperties<RelativeDateProperties, string, // iso-date?
	// iso-date?
	NestedFieldsAdditionalProperties & {
	    scope?: 'date' | 'datetime';
	}>;
	//# sourceMappingURL=relative-date-types.d.ts.map
}
declare module 'lib/component/field/relative-date/relative-date-utils' {
	import type { Locale } from '@sage/xtrem-shared';
	import type { DatePropertyValue, DateTimePropertyValue } from 'lib/utils/types';
	export type RelativeDateScope = 'date' | 'datetime';
	export function toRelative_(type: RelativeDateScope, lang: Locale, end: DatePropertyValue | DateTimePropertyValue, start?: DatePropertyValue | DateTimePropertyValue): string | false;
	export function toRelative(type: RelativeDateScope, end: DatePropertyValue): string | false;
	export const getRelativeDateDisplayValue: (value: DatePropertyValue, scope?: RelativeDateScope) => string;
	//# sourceMappingURL=relative-date-utils.d.ts.map
}
declare module 'lib/component/field/relative-date/relative-date-component' {
	import * as React from 'react';
	import { ReadonlyFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { RelativeDateDecoratorProperties } from 'lib/component/field/relative-date/relative-date-types';
	import type { DatePropertyValue } from 'lib/utils/types';
	export class RelativeDateComponent extends ReadonlyFieldBaseComponent<RelativeDateDecoratorProperties, DatePropertyValue, NestedFieldsAdditionalProperties> {
	    render(): React.ReactNode;
	}
	export const ConnectedRelativeDateComponent: import("react-redux").ConnectedComponent<typeof RelativeDateComponent, {
	    key?: React.Key | null | undefined;
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    ref?: React.LegacyRef<RelativeDateComponent> | undefined;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedRelativeDateComponent;
	//# sourceMappingURL=relative-date-component.d.ts.map
}
declare module 'lib/component/field/relative-date/async-relative-date-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { RelativeDateComponentProps } from 'lib/component/field/relative-date/relative-date-types';
	export function AsyncConnectedRelativeDateComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncRelativeDateComponent(props: RelativeDateComponentProps): React.ReactElement;
	//# sourceMappingURL=async-relative-date-component.d.ts.map
}
declare module 'lib/component/field/node-browser-tree/node-browser-tree-types' {
	import type { Dict, Property, TreeElement } from '@sage/xtrem-shared';
	import type { NodeDetails } from 'lib/service/node-information-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType } from 'lib/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { CanFetchDefaults, Clickable, Changeable, ExtensionField, HasFieldActions, HasParent, Validatable } from 'lib/component/field/traits';
	export interface NodeBrowserTreeProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT> {
	    node?: keyof ScreenBaseGenericType<CT>;
	    filter?: (nodes: NodeDetails[]) => NodeDetails[];
	}
	export type NodeBrowserTreeValue = Dict<TreeElement<NodeDetails>>;
	export interface NodeBrowserTreeDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<NodeBrowserTreeProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, HasFieldActions<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, Validatable<CT, NodeBrowserTreeValue>, CanFetchDefaults {
	    filter?: (nodes: NodeDetails[]) => NodeDetails[];
	    fetchItems?: (this: CT, treeNode: Property) => Promise<Property[]>;
	}
	export type NodeBrowserTreeComponentProps = BaseEditableComponentProperties<NodeBrowserTreeDecoratorProperties, NodeBrowserTreeValue>;
	//# sourceMappingURL=node-browser-tree-types.d.ts.map
}
declare module 'lib/component/ui/node-browser-tree/node-browser-tree-type' {
	import type { NodePropertyType } from 'lib/types';
	import type { Dict, Property } from '@sage/xtrem-shared';
	import type { NodeDetails } from 'lib/service/node-information-service';
	export interface NodeBrowserTreeProps {
	    isDisabled?: boolean;
	    isReadOnly?: boolean;
	    checkedItems?: Dict<Property>;
	    onCheckedItemsUpdated?: (checkedItems: Dict<Property>) => void;
	    node?: NodePropertyType;
	    filter?: (nodes: NodeDetails[]) => NodeDetails[];
	    /** This is for platform use cases only. If you need to use this, please talk to the platform team first. */
	    fetchItems?: (treeNode: Property) => Promise<Property[]>;
	    locale: string;
	}
	//# sourceMappingURL=node-browser-tree-type.d.ts.map
}
declare module 'lib/component/ui/node-browser-tree/node-browser-tree' {
	import React from 'react';
	import type { NodeBrowserTreeProps } from 'lib/component/ui/node-browser-tree/node-browser-tree-type';
	export const NodeBrowserTree: React.FC<NodeBrowserTreeProps>;
	//# sourceMappingURL=node-browser-tree.d.ts.map
}
declare module 'lib/component/field/node-browser-tree/node-browser-tree-component' {
	import React from 'react';
	import type { NodeBrowserTreeComponentProps } from 'lib/component/field/node-browser-tree/node-browser-tree-types';
	export const NodeBrowserTreeComponent: React.FC<NodeBrowserTreeComponentProps>;
	export const ConnectedNodeBrowserTree: import("react-redux").ConnectedComponent<React.FC<NodeBrowserTreeComponentProps>, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedNodeBrowserTree;
	//# sourceMappingURL=node-browser-tree-component.d.ts.map
}
declare module 'lib/component/field/node-browser-tree/async-node-browser-tree-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { NodeBrowserTreeComponentProps } from 'lib/component/field/node-browser-tree/node-browser-tree-types';
	export function AsyncConnectedNodeBrowserTreeComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncNodeBrowserTreeComponent(props: NodeBrowserTreeComponentProps): React.ReactElement;
	//# sourceMappingURL=async-node-browser-tree-component.d.ts.map
}
declare module 'lib/component/field/selection-card/selection-card-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { CanFetchDefaults, Changeable, ExtensionField, HasOptions, HasParent, Mappable, Sizable, Validatable } from 'lib/component/field/traits';
	export type DetailedIconType = 'accounting' | 'addons' | 'animal' | 'apple' | 'arrow-down' | 'arrow-left' | 'arrow-right' | 'arrow-up' | 'asset_mgt' | 'award' | 'bag' | 'bakery' | 'barcode' | 'bicycle' | 'binocular' | 'blank-template' | 'book-search' | 'book-tag' | 'book' | 'box-distribution' | 'bright' | 'building-and-people' | 'building' | 'business-mgt' | 'business-scale' | 'calculator' | 'calendar' | 'camera' | 'card-stacked' | 'card-transaction' | 'card' | 'cart-warehouse-2' | 'cart-warehouse' | 'cart' | 'certificate' | 'chart-bar' | 'chat' | 'check' | 'checkbox' | 'checklist' | 'chemical' | 'chess' | 'chevron-down' | 'chevron-left' | 'chevron-right' | 'chevron-up' | 'click' | 'clock' | 'close' | 'clothes' | 'cloud-connected' | 'cloud-currency-dollar' | 'cloud-currency-euro' | 'cloud-currency-pound' | 'cloud-data' | 'cloud-down' | 'cloud-service' | 'cloud-up' | 'cloud' | 'coffee' | 'compass' | 'computer-wifi' | 'connected' | 'consultant' | 'conversation' | 'conveyer-belt' | 'cooking' | 'cpu' | 'credit-card' | 'crowd' | 'crown' | 'dart-board' | 'dashboard-setting' | 'data' | 'database' | 'decline' | 'desktop' | 'device-setting' | 'devices' | 'dollar' | 'double-check' | 'download' | 'dump-truck' | 'ear' | 'ecomm' | 'excavator' | 'eye' | 'factory' | 'favorite' | 'filter' | 'financial-services-euro' | 'financial-services-pound' | 'financial-services_dollar-green-on-transparent_icon.svg' | 'financials-2' | 'financials' | 'flag' | 'flower-abs' | 'folder-share' | 'folder-write' | 'folder' | 'food-serve' | 'food' | 'form' | 'gauge' | 'gears' | 'glasses' | 'globe' | 'grad-cap' | 'green-offering' | 'green' | 'handshake' | 'happy' | 'heart' | 'hide' | 'holiday' | 'home' | 'hourglass' | 'hub' | 'idea' | 'incline' | 'industry' | 'info-tip' | 'info' | 'integration' | 'jewelry' | 'key-hole' | 'keys' | 'lab' | 'label' | 'laptop' | 'light-bulb' | 'lightning' | 'like' | 'link' | 'locations' | 'lock' | 'lock_unlocked' | 'magnifying-glass' | 'mail-opened' | 'mail' | 'map' | 'medical' | 'megaphone' | 'memo' | 'microphone' | 'minus' | 'mobile-purchase-dollar' | 'mobile-purchase-euro' | 'mobile-purchase-pound' | 'mobile-wifi' | 'money-bill' | 'money-dollar' | 'money-euro' | 'money-pound' | 'money-received-dollar' | 'money-received-euro' | 'money-received-pound' | 'money-stacked' | 'monitor-click' | 'mouse' | 'name-tag' | 'newspaper' | 'non-profit' | 'note' | 'notebook' | 'office' | 'page' | 'payment' | 'payroll' | 'pen' | 'pencil' | 'people-chat' | 'people-network-2' | 'people-network' | 'people-search' | 'people-settings' | 'person' | 'phone' | 'pie-break' | 'pin-dropped' | 'pin-map' | 'pin' | 'play-button' | 'plus' | 'point' | 'pound' | 'power' | 'presentation' | 'print' | 'processing' | 'puzzle' | 'question-circle' | 'question' | 'receipts' | 'recycle' | 'redo' | 'remote' | 'rocket' | 'safe' | 'satelite' | 'savings' | 'scissors' | 'sd-card' | 'secured-sign-in' | 'server' | 'service' | 'setting' | 'share' | 'shoes' | 'shopping-bag' | 'shuffle' | 'sign' | 'sim' | 'smartphone' | 'stationeries' | 'store' | 'support' | 'switch-board' | 'sync' | 'tab' | 'table' | 'tablet-hand' | 'tablet' | 'thermometer' | 'time-clock' | 'timer' | 'tools' | 'trash-bin' | 'travel' | 'truck' | 'two-ways' | 'undo' | 'user-cards' | 'user-message' | 'video-game' | 'video-guide' | 'video' | 'wallet' | 'warehouse' | 'warning-2' | 'warning' | 'weather' | 'wireless' | 'wrench' | 'writing' | 'zoom-in' | 'zoom-out';
	export interface SelectionCardProperties<CT extends ScreenBase = ScreenBase> extends EditableFieldProperties<CT>, Sizable, HasOptions<CT>, CanFetchDefaults, Mappable<CT> {
	    icon: (option: string) => DetailedIconType;
	    description: (option: string) => string;
	}
	export interface SelectionCardDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<SelectionCardProperties<CT>, '_controlObjectType'>, Changeable<CT>, HasParent<CT, BlockControlObject<CT>>, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT>, Sizable {
	}
	export type SelectionCardComponentProps = BaseEditableComponentProperties<SelectionCardProperties, string>;
	//# sourceMappingURL=selection-card-types.d.ts.map
}
declare module 'lib/utils/detailed-icons-utils' {
	export const resolveDetailedIcon: (icon: string) => string;
	//# sourceMappingURL=detailed-icons-utils.d.ts.map
}
declare module 'lib/component/field/selection-card/selection-card-component' {
	import type { Dict } from '@sage/xtrem-shared';
	import React from 'react';
	import type { SelectionCardComponentProps } from 'lib/component/field/selection-card/selection-card-types';
	type SelectionCardAdditionalProps = SelectionCardComponentProps & {
	    localizedOptions?: Dict<string>;
	    enumOptions?: string[];
	};
	export function SelectionCardComponent(props: SelectionCardAdditionalProps): React.ReactElement;
	export const ConnectedSelectionCardComponent: import("react-redux").ConnectedComponent<typeof SelectionCardComponent, {
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedSelectionCardComponent;
	//# sourceMappingURL=selection-card-component.d.ts.map
}
declare module 'lib/component/field/selection-card/async-selection-card-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { SelectionCardComponentProps } from 'lib/component/field/selection-card/selection-card-types';
	export function AsyncConnectedSelectionCardComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncSelectionCardComponent(props: SelectionCardComponentProps): React.ReactElement;
	//# sourceMappingURL=async-selection-card-component.d.ts.map
}
declare module 'lib/component/field/dynamic-pod/dynamic-pod-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/container/container-control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { PodNestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasColumns, HasDropdownActions, HasFilter, HasHeaderLabel, HasHelperText, HasNode, HasParent, HasPlaceholder, Sizable, Validatable } from 'lib/component/field/traits';
	import type { Dict } from '@sage/xtrem-shared';
	import type { DataTypeDetails } from 'lib/service/metadata-types';
	export interface DynamicPodProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends EditableFieldProperties<CT, NestedRecordType>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, HasPlaceholder, HasHelperText, HasNode<CT>, HasColumns<CT, NestedRecordType, PodNestedFieldTypes>, Sizable, HasFilter<CT, NestedRecordType>, HasDropdownActions<CT>, HasHeaderLabel<CT, NestedRecordType>, Validatable<CT> {
	    /** Label on the add button that is displayed when the field is empty. */
	    addButtonText?: string;
	    onAddButtonClick?: (this: CT) => Promise<Partial<NestedRecordType>> | Partial<NestedRecordType>;
	    /** Pod field can be removed and set to null, default: false */
	    canRemove?: boolean;
	}
	export interface DynamicPodDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<DynamicPodProperties<CT>, '_controlObjectType'> {
	}
	export interface DynamicPodComponentProps extends BaseEditableComponentProperties<DynamicPodDecoratorProperties, any> {
	    loadEnumTypes: (optionType: string[], locale: string) => Promise<void>;
	    loadDataTypes: (referenceTypes: string[], locale: string) => Promise<void>;
	    enumTypes: Dict<string[]>;
	    dataTypes: Dict<DataTypeDetails>;
	}
	//# sourceMappingURL=dynamic-pod-types.d.ts.map
}
declare module 'lib/component/field/dynamic-pod/dynamic-pod-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { DynamicPodComponentProps, DynamicPodDecoratorProperties } from 'lib/component/field/dynamic-pod/dynamic-pod-types';
	export class DynamicPodComponent extends EditableFieldBaseComponent<DynamicPodDecoratorProperties, any, DynamicPodComponentProps, {
	    fetchingReferenceTypes: boolean;
	    fetchingOptionTypes: boolean;
	}> {
	    constructor(props: DynamicPodComponentProps);
	    getMissingOptionTypes(): string[];
	    getMissingReferenceTypes(): string[];
	    checkDataModel(): void;
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: DynamicPodComponentProps): void;
	    private readonly onChange;
	    private readonly onRemove;
	    private readonly onNewPod;
	    private addReferenceDataTypeInfo;
	    render(): React.ReactNode;
	}
	export const ConnectedDynamicPodComponent: import("react-redux").ConnectedComponent<typeof DynamicPodComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DynamicPodComponent> | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDynamicPodComponent;
	//# sourceMappingURL=dynamic-pod-component.d.ts.map
}
declare module 'lib/component/field/dynamic-pod/async-dynamic-pod-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { DynamicPodComponentProps } from 'lib/component/field/dynamic-pod/dynamic-pod-types';
	export function AsyncConnectedDynamicPodComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncdynamicPodComponent(props: DynamicPodComponentProps): React.ReactElement;
	//# sourceMappingURL=async-dynamic-pod-component.d.ts.map
}
declare module 'lib/component/field/workflow/workflow-types' {
	import type { FilterParameter } from '@sage/xtrem-ui-components';
	import type { Edge, Node } from 'reactflow';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { OverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { ValueOrCallback } from 'lib/utils/types';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent } from 'lib/component/field/traits';
	import type { Dict, WorkflowVariable } from '@sage/xtrem-shared';
	export interface DefaultDataType extends Dict<any> {
	    type?: string;
	    subtitle?: string;
	    details?: string;
	    variables?: WorkflowVariable[];
	}
	export interface WorkflowFieldValue {
	    edges: Edge[];
	    nodes: Node<{
	        screenId?: string;
	        elementId?: string;
	    }>[];
	}
	export interface WorkflowDecoratorProperties<CT extends ScreenBase = ScreenBase> extends WorkflowProperties<CT>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>> {
	    /** The parameters of the form editor */
	    parameters?: ValueOrCallback<CT, FilterParameter[]>;
	}
	export interface WorkflowExtensionDecoratorProperties<CT extends ScreenExtension<CT>> extends OverrideDecoratorProperties<WorkflowDecoratorProperties<Extend<CT>>> {
	}
	export interface WorkflowProperties<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldProperties<CT> {
	}
	export type WorkflowComponentProperties = BaseEditableComponentProperties<WorkflowProperties, WorkflowFieldValue>;
	//# sourceMappingURL=workflow-types.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-set-field-value' {
	export const useFieldValue: <T extends unknown>(screenId?: string, elementId?: string) => T | null;
	//# sourceMappingURL=use-set-field-value.d.ts.map
}
declare module 'lib/component/field/workflow/workflow-component-utils' {
	import type { Edge, Node } from 'reactflow';
	import type { DefaultDataType } from 'lib/component/field/workflow/workflow-types';
	import type { WorkflowVariable } from '@sage/xtrem-shared';
	export const edgeStyle: Partial<Edge>;
	export const removeTransientNodeDataProperties: (data: DefaultDataType) => DefaultDataType;
	export const removeTransientNodeDataPropertiesFromNodes: (nodes: Node<DefaultDataType>[]) => Node[];
	export const removeTransientEdgeDataPropertiesFromEdges: (nodes: Edge<DefaultDataType>[]) => Edge[];
	export const changeEventHandler: (screenId: string, elementId: string) => () => Promise<void>;
	export const usePreviousWorkflowNodes: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => Node<DefaultDataType>[];
	export const useSourceNode: (edgeId: string, screenId?: string, elementId?: string) => Node<DefaultDataType> | null;
	export const useWorkflowNodeVariables: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => WorkflowVariable[];
	export function removeChildNodesAndEdgesFromStartPoint(nodeId: string, tempEdges: Edge[], tempNodes: Node[]): void;
	export function allocateId(prefix: string, items: {
	    id: string;
	}[]): string;
	//# sourceMappingURL=workflow-component-utils.d.ts.map
}
declare module 'lib/component/field/workflow/workflow-context-provider' {
	/// <reference types="react" />
	export interface WorkflowContextValue {
	    screenId: string;
	    elementId: string;
	    isReadOnly: boolean;
	    onNodeDataChange: (nodeId: string, newData: any) => void;
	}
	export const WorkflowContext: import("react").Context<WorkflowContextValue | null>;
	//# sourceMappingURL=workflow-context-provider.d.ts.map
}
declare module 'lib/component/field/workflow/custom-node' {
	import type { NodeProps } from 'reactflow';
	import * as React from 'react';
	import type { DefaultDataType } from 'lib/component/field/workflow/workflow-types';
	interface CustomNodeProps extends NodeProps<DefaultDataType> {
	}
	export function CustomNode({ data, isConnectable, id }: CustomNodeProps): React.ReactElement | null;
	export {};
	//# sourceMappingURL=custom-node.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-compare' {
	export const useCompare: (val: any) => boolean;
	//# sourceMappingURL=use-compare.d.ts.map
}
declare module 'lib/component/field/workflow/workflow-node-selector-component' {
	import * as React from 'react';
	export interface WorkflowNodeSelectorComponentProps {
	    value: string | null;
	    onChange: (newValue: string) => void;
	    filterType?: string[];
	}
	export function WorkflowNodeSelectorComponent({ value, onChange, filterType, }: WorkflowNodeSelectorComponentProps): React.ReactElement | null;
	//# sourceMappingURL=workflow-node-selector-component.d.ts.map
}
declare module 'lib/redux/actions/menu-actions' {
	import type { AppThunkDispatch } from 'lib/redux/action-types';
	import type { Menu, XtremAppState } from 'lib/redux/state';
	export const addMenuItem: (menuItem: Menu) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const updateMenuItem: (menuItemId: string, badgeContent?: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const removeMenuItem: (menuItemId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	//# sourceMappingURL=menu-actions.d.ts.map
}
declare module 'lib/redux/actions/menu-items' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { Menu } from 'lib/redux';
	import type { SectionControlObject } from 'lib/component/control-objects';
	import type { ScreenBase } from 'lib/service/screen-base';
	export const navigationPanelMenuItemId = "NavigationPanelMenuItem";
	export const closeDialogMenuItemId = "CloseDialogMenuItem";
	export const getCloseDialogMenuItem: (dialogId: number, isDialogSticker: boolean, title?: string) => Menu;
	export const getStickerMenuItem: (stickerId: string, icon: IconType, sections: SectionControlObject<ScreenBase>[], badgeContent?: string, title?: string, category?: string) => Menu;
	//# sourceMappingURL=menu-items.d.ts.map
}
declare module 'lib/component/container/page/page-extension-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { PageMetadata } from 'lib/service/page-metadata';
	import type { PageExtension } from 'lib/types';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import type { PageActionControlObject } from 'lib/component/control-objects';
	import type { AccessConfiguration } from 'lib/component/field/traits';
	import type { PageDecoratorProperties } from 'lib/component/container/page/page-decorator';
	import type { BasePageDecoratorProperties, PageNavigationPanelExtension } from 'lib/component/container/page/page-types';
	export interface PageExtensionDecoratorProperties<CT extends PageExtension<CT>, NodeType extends ClientNode = any> extends BasePageDecoratorProperties<CT> {
	    /** Page that this extension extends in the following format: @sage/package-name/PageName */
	    extends: string;
	    /** Access binding that determines whether the extension is loaded */
	    extensionAccessBinding?: AccessConfiguration;
	    /** Navigation panel property overrides */
	    navigationPanel?: PageNavigationPanelExtension<CT, NodeType>;
	    /** Navigation panel property overrides */
	    businessActions?: (this: CT) => PageActionControlObject[];
	}
	export interface RuntimePageMetadata extends PageMetadata {
	    uiComponentProperties: Dict<UiComponentProperties & {
	        onLoadAfter: Array<PageDecoratorProperties<any>['onLoad']>;
	        onCloseAfter: Array<PageDecoratorProperties<any>['onClose']>;
	    }>;
	    defaultUiComponentProperties: Dict<UiComponentProperties & {
	        onLoadAfter: Array<PageDecoratorProperties<any>['onLoad']>;
	        onCloseAfter: Array<PageDecoratorProperties<any>['onClose']>;
	    }>;
	}
	export function pageExtension<CT extends PageExtension<CT>, NodeType extends ClientNode = any>(properties: PageExtensionDecoratorProperties<CT, NodeType>): (ctor: Function) => void;
	//# sourceMappingURL=page-extension-decorator.d.ts.map
}
declare module 'lib/utils/id-field-utils' {
	import type { PageHeaderFields } from 'lib/component/container/page/page-types';
	import type { PageDefinition } from 'lib/service/page-definition';
	export const getFieldDisplayValue: (pageDefinition: PageDefinition, field: PageHeaderFields, locale?: string) => string | null;
	export const getIdFieldValue: (pageDefinition: PageDefinition, locale?: string) => string | null;
	//# sourceMappingURL=id-field-utils.d.ts.map
}
declare module 'lib/utils/page-utils' {
	import type { RuntimePageMetadata } from 'lib/component/container/page/page-extension-decorator';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { PageEventType } from 'lib/component/container/page/page-types';
	export interface HeaderTitles {
	    subtitle: string | undefined;
	    title: string;
	}
	export function getHeaderTitles({ idFieldValue, isRecordCreationPage, objectTypePlural, objectTypeSingular, subtitle, title, }: {
	    idFieldValue?: string | null;
	    isRecordCreationPage?: boolean;
	    objectTypePlural?: string | null;
	    objectTypeSingular?: string | null;
	    subtitle?: string;
	    title: string;
	}): HeaderTitles;
	export const getPageTitlesFromPageDefinition: (pageDefinition: PageDefinition, locale: string) => HeaderTitles;
	/**
	 * Mutates PageMetadata to inject the provided onLoad function to be executed after the page fragment or page extension has been loaded
	 */
	export const injectOnloadAfterIntoPageMetadata: (pageMetadata: RuntimePageMetadata, onLoad: PageEventType<any>) => void;
	//# sourceMappingURL=page-utils.d.ts.map
}
declare module 'lib/redux/actions/dialog-actions' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { DialogDescription } from 'lib/types/dialogs';
	import type { AppThunkDispatch } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state';
	import type { QueryParameters } from 'lib/utils/types';
	export const closeDialog: (dialogId: number) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const openDialog: (dialogId: number, dialog: DialogDescription) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const loadPageDialogContent: (path: string, queryParameters?: QueryParameters, values?: Dict<any>, onFinish?: (values?: Dict<any>) => void, isDuplicate?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<string | null>;
	//# sourceMappingURL=dialog-actions.d.ts.map
}
declare module 'lib/component/container/block/block-component' {
	import type { AccessStatus } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import { ContextType } from 'lib/types';
	import type { BlockProperties } from 'lib/component/control-objects';
	export interface BlockComponentExternalProps {
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    contextType?: ContextType;
	    availableColumns: number;
	    isParentDisabled?: boolean;
	    isParentHidden?: boolean;
	    accessRule?: AccessStatus;
	}
	export interface BlockComponentProps extends BlockComponentExternalProps {
	    screenType: string;
	    fieldProperties: Omit<BlockProperties, 'parent'>;
	    browser: ReduxResponsive;
	}
	export function BlockComponent(props: BlockComponentProps): React.ReactElement | null;
	export const ConnectedBlockComponent: import("react-redux").ConnectedComponent<typeof BlockComponent, {
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    availableColumns: number;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    accessRule?: AccessStatus | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=block-component.d.ts.map
}
declare module 'lib/component/container/grid-row-block/grid-row-block-types' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ContainerProperties } from 'lib/component/abstract-container';
	import type { BlockControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { NestedGridControlObject, TableControlObject } from 'lib/component/field/field-control-objects';
	import type { ExtensionField, HasParent } from 'lib/component/field/traits';
	export interface GridRowBlockProperties<CT extends ScreenBase = ScreenBase> extends ContainerProperties<CT> {
	    selectedRecordId?: string;
	    selectedLevel?: number;
	}
	export interface GridRowBlockDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<GridRowBlockProperties<CT>, '_controlObjectType'>, HasParent<CT, SectionControlObject<CT>>, ExtensionField<CT, BlockControlObject<CT>> {
	    boundTo: (this: CT) => TableControlObject | NestedGridControlObject;
	    fieldFilter?: (this: CT, elementId: keyof CT) => boolean;
	    readOnlyOverride?: (this: CT, elementId: keyof CT) => boolean | undefined | void;
	}
	//# sourceMappingURL=grid-row-block-types.d.ts.map
}
declare module 'lib/component/container/grid-row-block/grid-row-block-component' {
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { ContextType } from 'lib/types';
	import type { NestedGridProperties } from 'lib/component/field/field-control-objects';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	import type { GridRowBlockDecoratorProperties } from 'lib/component/container/grid-row-block/grid-row-block-types';
	export interface GridRowBlockComponentExternalProps {
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    contextType?: ContextType;
	    availableColumns: number;
	    isParentDisabled?: boolean;
	    /**
	     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
	     * down the hidden status and mark the hidden inputs not focusable
	     * */
	    isParentHidden?: boolean;
	}
	export interface GridRowBlockComponentProps extends GridRowBlockComponentExternalProps {
	    screenType: string;
	    fieldProperties: GridRowBlockDecoratorProperties;
	    browser?: ReduxResponsive;
	    referredTableProperties?: InternalTableProperties | NestedGridProperties;
	    parentElementId: string;
	}
	export function GridRowBlockComponent(props: GridRowBlockComponentProps): React.ReactElement | null;
	export const ConnectedGridRowBlockComponent: import("react-redux").ConnectedComponent<typeof GridRowBlockComponent, {
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    availableColumns: number;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedGridRowBlockComponent;
	//# sourceMappingURL=grid-row-block-component.d.ts.map
}
declare module 'lib/component/container/grid-row-block/async-grid-row-block' {
	import * as React from 'react';
	import type { GridRowBlockComponentExternalProps } from 'lib/component/container/grid-row-block/grid-row-block-component';
	export function AsyncGridRowBlockComponent(props: GridRowBlockComponentExternalProps): React.ReactElement;
	//# sourceMappingURL=async-grid-row-block.d.ts.map
}
declare module 'lib/service/user-customization' {
	export interface UserCustomization {
	    componentId: string;
	    propertyName: string;
	    propertyValue: any;
	}
	//# sourceMappingURL=user-customization.d.ts.map
}
declare module 'lib/utils/hooks/effects/use-parent-element-size' {
	interface Size {
	    width: number;
	    height: number;
	}
	export function useParentElementSize<T extends HTMLElement = HTMLDivElement>(): [(node: T | null) => void, Size];
	export {};
	//# sourceMappingURL=use-parent-element-size.d.ts.map
}
declare module 'lib/component/container/section/section-component' {
	import type { AccessStatus } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { UserCustomization } from 'lib/service/user-customization';
	import { ContextType } from 'lib/types';
	import type { SectionProperties } from 'lib/component/control-objects';
	import type { ComponentKey } from 'lib/component/types';
	import type { PageMode } from 'lib/component/container/page/page-types';
	export interface SectionComponentExternalProps {
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    contextType?: ContextType;
	    availableColumns: number;
	    isParentDisabled?: boolean;
	    /**
	     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
	     * down the hidden status and mark the hidden inputs not focusable
	     * */
	    isParentHidden?: boolean;
	    accessRule?: AccessStatus;
	    hasFooter?: boolean;
	}
	export interface SectionComponentProps extends SectionComponentExternalProps {
	    fieldProperties: SectionProperties;
	    browser?: ReduxResponsive;
	    pageMode?: PageMode;
	    setFieldProperties: (bind: string, state: SectionProperties) => void;
	    updateUserCustomization: (userCustomizations: UserCustomization[]) => void;
	    firstFieldType?: ComponentKey | null;
	}
	export function SectionComponent(props: SectionComponentProps): React.ReactElement;
	export const ConnectedSectionComponent: import("react-redux").ConnectedComponent<typeof SectionComponent, {
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    availableColumns: number;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    accessRule?: AccessStatus | undefined;
	    hasFooter?: boolean | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=section-component.d.ts.map
}
declare module 'lib/component/container/tile/tile-types' {
	import type { AccessStatus, Dict } from '@sage/xtrem-shared';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ContextType } from 'lib/types';
	import type { ContainerProperties } from 'lib/component/abstract-container';
	import type { BaseControlObject } from 'lib/component/base-control-object';
	import type { SectionControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { ExtensionField, HasParent } from 'lib/component/field/traits';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { ContainerWidth } from 'lib/component/types';
	export interface GridColumnDefinition {
	    columnSpan: number;
	    columnStart?: number;
	    elementId: string;
	    isFirstInRow?: boolean;
	    isHidden?: boolean;
	    isLastInRow?: boolean;
	    row?: number;
	}
	export interface TileComponentExternalProps {
	    accessRule?: AccessStatus;
	    availableColumns: number;
	    contextType?: ContextType;
	    isParentDisabled?: boolean;
	    /**
	     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
	     * down the hidden status and mark the hidden inputs not focusable
	     * */
	    isParentHidden?: boolean;
	    item: Partial<PageArticleItem>;
	    screenId: string;
	}
	export interface TileComponentProps extends TileComponentExternalProps {
	    browser: ReduxResponsive;
	    columnInfo: Dict<GridColumnDefinition>;
	    fieldProperties: Omit<TileProperties, 'parent'>;
	    screenType: string;
	}
	export interface TileFieldExternalProps {
	    availableColumns: number;
	    elementId: string;
	    item: PageArticleItem;
	    screenId: string;
	    isParentDisabled?: boolean;
	}
	export interface TileFieldProps extends TileFieldExternalProps {
	    browser: ReduxResponsive;
	    fieldController: BaseControlObject<any, any>;
	    fieldProperties: ReadonlyFieldProperties;
	    locale: string;
	    pageDefinition: PageDefinition;
	    value: any;
	}
	export interface TileDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<TileProperties<CT>, '_controlObjectType'>, HasParent<CT, SectionControlObject<CT>>, ExtensionField<CT, TileControlObject<CT>> {
	}
	export interface TileProperties<CT extends ScreenBase = ScreenBase> extends ContainerProperties<CT> {
	    /** The width of the tile relative to the section where it is place.
	     * Must be a number between 1 and 12, both included*/
	    width?: ContainerWidth;
	}
	//# sourceMappingURL=tile-types.d.ts.map
}
declare module 'lib/component/container/tile/tile-grid-manager' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { GridColumnDefinition } from 'lib/component/container/tile/tile-types';
	export class TileGridManager {
	    private readonly state;
	    private readonly width;
	    constructor(width: number);
	    private getCurrentRow;
	    private getRemainingColumns;
	    private isEmptyState;
	    private wouldOverflow;
	    appendItem(item: GridColumnDefinition): void;
	    getState(): Dict<GridColumnDefinition>;
	}
	//# sourceMappingURL=tile-grid-manager.d.ts.map
}
declare module 'lib/component/container/tile/tile-field' {
	import * as React from 'react';
	import type { TileFieldProps } from 'lib/component/container/tile/tile-types'; function TileField(props: TileFieldProps): React.ReactElement;
	export const ConnectedTileField: import("react-redux").ConnectedComponent<typeof TileField, {
	    availableColumns: number;
	    elementId: string;
	    item: import("../../..").PageArticleItem;
	    screenId: string;
	    isParentDisabled?: boolean | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=tile-field.d.ts.map
}
declare module 'lib/component/container/tile/tile-component' {
	/// <reference types="@sage/xtrem-shared" />
	import * as React from 'react';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import { ContextType } from 'lib/types';
	import type { TileComponentProps } from 'lib/component/container/tile/tile-types';
	export function TileComponent(props: TileComponentProps): React.ReactElement;
	export namespace TileComponent {
	    var displayName: string;
	}
	export const ConnectedTileComponent: import("react-redux").ConnectedComponent<typeof TileComponent, {
	    accessRule?: import("@sage/xtrem-shared").AccessStatus | undefined;
	    availableColumns: number;
	    contextType?: ContextType | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=tile-component.d.ts.map
}
declare module 'lib/render/rendering-router' {
	import * as React from 'react';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import type { ContextType } from 'lib/types';
	export class RenderingRouterProps {
	    availableColumns: number;
	    contextType?: ContextType;
	    item: Partial<PageArticleItem>;
	    screenId: string;
	    isParentDisabled?: boolean;
	    /**
	     * Indicates if any of the parents in the layout structure is hidden, it is required so we can cascade
	     * down the hidden status and mark the hidden inputs not focusable
	     * */
	    isParentHidden?: boolean;
	    fixedHeight?: number;
	    hasFooter?: boolean;
	}
	export const RenderingRouter: React.FC<RenderingRouterProps>;
	//# sourceMappingURL=rendering-router.d.ts.map
}
declare module 'lib/component/ui/tabs/xtrem-tabs' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import React from 'react';
	export interface XtremTabItem {
	    id: string;
	    title: string;
	    icon?: IconType;
	    validationMessage?: string | null;
	}
	export interface XtremTabsProps {
	    onTabChange: (tabId: string) => void;
	    tabs: XtremTabItem[];
	    selectedTabId: string;
	    inSidebar?: boolean;
	}
	export function XtremTabs(props: XtremTabsProps): React.ReactElement;
	//# sourceMappingURL=xtrem-tabs.d.ts.map
}
declare module 'lib/component/container/footer/business-actions' {
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import type { PageActionButtonType, PageActionControlObject } from 'lib/component/control-objects';
	export interface BusinessActionsExternalProps {
	    businessActions?: PageActionControlObject[];
	    contextType: ContextType;
	    defaultButtonType: PageActionButtonType;
	    maxMainActions?: number;
	    screenId: string;
	    pendoId?: string;
	}
	export interface BusinessActionsProps extends BusinessActionsExternalProps {
	    enabledBusinessActions: string[];
	    visibleBusinessActions: string[];
	}
	export function BusinessActions(props: BusinessActionsProps): React.ReactElement; const _default: import("react-redux").ConnectedComponent<typeof BusinessActions, {
	    businessActions?: PageActionControlObject<import("../../../service/screen-base").ScreenBase<any, any>>[] | undefined;
	    contextType: ContextType;
	    defaultButtonType: import("carbon-react/esm/components/button/button.component").ButtonTypes | undefined;
	    maxMainActions?: number | undefined;
	    screenId: string;
	    pendoId?: string | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=business-actions.d.ts.map
}
declare module 'lib/component/container/detail-panel/detail-panel-component' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { DetailPanelControlObject, DetailPanelProperties } from 'lib/component/control-objects';
	import type { SectionProperties } from 'lib/component/container/container-properties';
	export interface DetailPanelExternalProps {
	    detailPanel: DetailPanelControlObject;
	    screenId: string;
	}
	export interface DetailPanelProps extends DetailPanelExternalProps {
	    enabledFooterActions: number;
	    detailPanelProperties: DetailPanelProperties;
	    setFieldProperties: (bind: string, properties: DetailPanelProperties) => void;
	    visibleFooterActions: number;
	    sectionProperties: Dict<SectionProperties>;
	}
	export class DetailPanel extends React.Component<DetailPanelProps> {
	    onTabSelect: (selectedId: any) => void;
	    onClose: () => void;
	    render(): React.ReactNode;
	} const _default: import("react-redux").ConnectedComponent<typeof DetailPanel, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DetailPanel> | undefined;
	    detailPanel: DetailPanelControlObject<import("../../../service/screen-base").ScreenBase<any, any>>;
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=detail-panel-component.d.ts.map
}
declare module 'lib/component/ui/page-title' {
	import React from 'react';
	export interface PageTitleProps {
	    title: string;
	}
	export function PageTitle({ title }: PageTitleProps): React.ReactElement;
	//# sourceMappingURL=page-title.d.ts.map
}
declare module 'lib/component/container/navigation-panel/navigation-panel-body-items' {
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ReduxResponsive, TableView } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { TableDecoratorProperties } from 'lib/component/decorators';
	import type { ValueOrCallback } from 'lib/utils/types';
	import type { BulkAction } from 'lib/component/control-objects';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { AccessBindings } from 'lib/service/page-definition';
	export interface NavigationPanelBodyItemsExternalProps {
	    isFullWidthGrid?: boolean;
	    screenId: string;
	    setFieldProperties?: (elementId: string, properties: InternalTableProperties) => void;
	}
	export interface NavigationPanelBodyItemsProps extends NavigationPanelBodyItemsExternalProps {
	    accessBindings: AccessBindings;
	    browser: ReduxResponsive;
	    bulkActions?: BulkAction[];
	    dataTypes: Dict<DataTypeDetails>;
	    enumTypes: Dict<string[]>;
	    groupByField?: PropertyValueType;
	    isAutoSelectEnabled: boolean;
	    isSoundDisabled?: ValueOrCallback<any, boolean>;
	    locale?: LocalizeLocale;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    selectedRecordId?: string | null;
	    tableProperties?: TableDecoratorProperties;
	    tableViews: Dict<TableView>;
	    username?: string;
	    value?: CollectionValue;
	} function NavigationPanelBodyItems({ accessBindings, browser, bulkActions, dataTypes, enumTypes, groupByField, isAutoSelectEnabled, isSoundDisabled, isFullWidthGrid, locale, nodeTypes, screenId, selectedRecordId, setFieldProperties, tableProperties, tableViews, username, value, }: NavigationPanelBodyItemsProps): React.ReactElement | null;
	export const ConnectedNavigationPanelBodyItems: import("react-redux").ConnectedComponent<typeof NavigationPanelBodyItems, {
	    isFullWidthGrid?: boolean | undefined;
	    screenId: string;
	    setFieldProperties?: ((elementId: string, properties: InternalTableProperties) => void) | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=navigation-panel-body-items.d.ts.map
}
declare module 'lib/component/container/navigation-panel/navigation-panel-component' {
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { Page } from 'lib/service/page';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValueOrCallback } from 'lib/utils/types';
	import type { PageActionControlObject } from 'lib/component/page-action/page-action-control-object';
	import type { PageNavigationPanel } from 'lib/component/container/page/page-types';
	export interface NavigationPanelExternalProps {
	    screenId: string;
	    selectedRecordId: string | null;
	}
	export interface NavigationPanelProps extends NavigationPanelExternalProps {
	    browser?: ReduxResponsive;
	    createAction?: ValueOrCallback<ScreenBase, PageActionControlObject | PageActionControlObject[]>;
	    isNavigationPanelHidden: boolean;
	    isNavigationPanelOpened: boolean;
	    isNewPage: boolean;
	    isRecordSelected: boolean;
	    isSelectAllChecked: boolean;
	    navigationPanelDefinition: PageNavigationPanel<Page>;
	    selectedRecordIds: string[];
	    setNavigationPanelIsHeaderHidden: (isHeaderHidden: boolean) => void;
	    setNavigationPanelIsOpened: (isOpened: boolean) => void;
	    title: string;
	}
	export class NavigationPanel extends React.Component<NavigationPanelProps> {
	    private togglePanelButtonRef;
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: NavigationPanelProps): void;
	    private readonly isFullWidth;
	    setChevronFocus: () => void;
	    private readonly setNavigationPanelIsOpened;
	    private readonly renderSplitHeaderActions;
	    private readonly renderTitle;
	    private readonly renderHeaderTop;
	    private readonly isHeaderHidden;
	    renderFullWidth: () => React.ReactNode;
	    render(): React.ReactNode;
	} const _default: import("react-redux").ConnectedComponent<typeof NavigationPanel, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<NavigationPanel> | undefined;
	    screenId: string;
	    selectedRecordId: string | null;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=navigation-panel-component.d.ts.map
}
declare module 'lib/component/container/page-footer/page-footer-component' {
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import type { PageActionControlObject, PageMode } from 'lib/component/control-objects';
	export interface PageFooterProps {
	    screenId: string;
	    businessActions?: PageActionControlObject[];
	    contextType?: ContextType;
	    pageMode?: PageMode;
	}
	export function PageFooter({ businessActions, screenId, contextType, pageMode, }: PageFooterProps): React.ReactElement | null;
	//# sourceMappingURL=page-footer-component.d.ts.map
}
declare module 'lib/component/container/navigation-panel/toggle-navigation-panel-button' {
	import * as React from 'react';
	interface ToggleNavigationPanelProps {
	    isNavigationPanelOpened: boolean;
	    setNavigationPanelIsOpened: (isOpened: boolean) => void;
	    parentOnClick?: (parentRef: any) => any;
	    parentRef?: any;
	} function ToggleNavigationPanelButton(props: ToggleNavigationPanelProps): React.ReactElement;
	export default ToggleNavigationPanelButton;
	//# sourceMappingURL=toggle-navigation-panel-button.d.ts.map
}
declare module 'lib/component/container/page/page-header-card' {
	import type { Dict } from '@sage/xtrem-shared';
	import React from 'react';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	export interface PageHeaderCardExternalProps {
	    screenId: string;
	}
	export interface PageHeaderCardProps extends PageHeaderCardExternalProps {
	    cardDefinition: CardDefinition | null;
	    screenId: string;
	    value: Dict<any> | null;
	}
	export function PageHeaderCardComponent({ screenId, cardDefinition, value, }: PageHeaderCardProps): React.ReactElement | null;
	export const ConnectedPageHeaderCardComponent: import("react-redux").ConnectedComponent<typeof PageHeaderCardComponent, {
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=page-header-card.d.ts.map
}
declare module 'lib/component/ui/navigation-arrows/navigation-arrows' {
	import * as React from 'react';
	interface HeaderNavigationArrowsProps {
	    hasNextRecord: boolean;
	    hasPreviousRecord: boolean;
	    onNextRecord: () => Promise<void>;
	    onPreviousRecord: () => Promise<void>;
	} function NavigationArrows({ hasNextRecord, hasPreviousRecord, onNextRecord, onPreviousRecord, }: HeaderNavigationArrowsProps): React.ReactElement;
	export default NavigationArrows;
	//# sourceMappingURL=navigation-arrows.d.ts.map
}
declare module 'lib/component/container/page/header-navigation-arrows' {
	import * as React from 'react';
	interface HeaderNavigationArrowsExternalProps {
	    screenId: string;
	}
	interface HeaderNavigationArrowsProps extends HeaderNavigationArrowsExternalProps {
	    selectedRecordId?: string | null;
	}
	export function HeaderNavigationArrows({ selectedRecordId, screenId, }: HeaderNavigationArrowsProps): React.ReactElement; const ConnectedHeaderNavigationArrows: import("react-redux").ConnectedComponent<typeof HeaderNavigationArrows, {
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedHeaderNavigationArrows;
	//# sourceMappingURL=header-navigation-arrows.d.ts.map
}
declare module 'lib/component/container/page/header-quick-actions' {
	import * as React from 'react';
	import type { IconType } from 'carbon-react/esm/components/icon';
	import type { PageActionControlObject } from 'lib/component/page-action/page-action-control-object';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	export interface HeaderQuickActionExternalProp {
	    screenId: string;
	    id: string;
	}
	export interface HeaderQuickActionProp extends HeaderQuickActionExternalProp {
	    icon: IconType;
	    isDisabled?: boolean;
	    isHidden?: boolean;
	    title?: string;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface HeaderQuickActionsExternalProps {
	    screenId: string;
	}
	export interface HeaderQuickActionsProps extends HeaderQuickActionsExternalProps {
	    headerQuickActions?: Array<PageActionControlObject>;
	}
	export function HeaderQuickActions({ screenId, headerQuickActions, }: HeaderQuickActionsProps): React.ReactElement | null;
	export const ConnectedHeaderQuickActions: import("react-redux").ConnectedComponent<typeof HeaderQuickActions, {
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=header-quick-actions.d.ts.map
}
declare module 'lib/component/container/page/header-dropdown-actions' {
	import * as React from 'react';
	import type { MenuSeparatorType } from 'lib/component/container/page/page-types';
	import type { XtremActionPopoverItem } from 'lib/component/ui/xtrem-action-popover';
	export interface HeaderDropdownActionsExternalProps {
	    screenId: string;
	}
	export interface HeaderDropdownActionsProps extends HeaderDropdownActionsExternalProps {
	    headerDropdownActions?: Array<XtremActionPopoverItem | MenuSeparatorType>;
	}
	export function HeaderDropdownActions({ headerDropdownActions, }: HeaderDropdownActionsProps): React.ReactElement | null;
	export const ConnectedHeaderDropdownActions: import("react-redux").ConnectedComponent<typeof HeaderDropdownActions, {
	    headerDropdownActions?: ("MENU_SEPARATOR" | XtremActionPopoverItem)[] | undefined;
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=header-dropdown-actions.d.ts.map
}
declare module 'lib/component/container/page-360/page-360-switch' {
	import * as React from 'react';
	export interface Page360SwitchProps {
	    screenId: string;
	}
	export function Page360Switch({ screenId }: Page360SwitchProps): React.ReactElement;
	//# sourceMappingURL=page-360-switch.d.ts.map
}
declare module 'lib/component/container/page/print-record-button' {
	import * as React from 'react';
	export interface PrintRecordButtonProps {
	    screenId: string;
	}
	export function PrintRecordButton({ screenId }: PrintRecordButtonProps): React.ReactElement | null;
	//# sourceMappingURL=print-record-button.d.ts.map
}
declare module 'lib/component/container/page/wizard-steps' {
	import * as React from 'react';
	import type { ValueOrCallback } from 'lib/utils/types';
	export interface WizardStepsProps {
	    screenId: string;
	    selectedSection?: string | null;
	    sections: {
	        id: string;
	        title?: ValueOrCallback<any, string>;
	    }[];
	}
	export function WizardSteps({ sections, selectedSection, screenId }: WizardStepsProps): React.ReactNode;
	//# sourceMappingURL=wizard-steps.d.ts.map
}
declare module 'lib/component/container/page/xtrem-header' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { PageArticleItem } from 'lib/service/layout-service';
	import { ContextType } from 'lib/types';
	import type { LabelControlObject, PageActionControlObject, SectionProperties } from 'lib/component/control-objects';
	import type { MenuSeparatorType, PageMode } from 'lib/component/container/page/page-types';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	export type StepStatus = 'complete' | 'current' | 'incomplete';
	export interface XtremHeaderExternalProps {
	    activeSection: string | null;
	    areNavigationTabsHidden: boolean;
	    availableColumns: number;
	    contextType?: ContextType;
	    hasNavigationPanel: boolean;
	    headerLineBlock: Partial<PageArticleItem> | null;
	    isRecordCreationPage?: boolean;
	    navigationPanelValue?: CollectionValue;
	    pageBodyRef: React.RefObject<HTMLDivElement>;
	    screenId: string;
	    setActiveSection: (sectionId: string) => void;
	}
	export interface XtremHeaderProps extends XtremHeaderExternalProps {
	    canToggleNavigationPanel: boolean;
	    has360View?: boolean;
	    hasDropdownOrQuickActions: boolean;
	    headerDropdownMenu?: Array<PageActionControlObject | MenuSeparatorType>;
	    headerImage: string | null;
	    headerLabelField?: LabelControlObject;
	    headerSection: Partial<PageArticleItem> | null;
	    headerTitle: string | null;
	    hierarchyParentPage?: () => string | null;
	    idFieldValue?: string | null;
	    is360ViewOn: boolean;
	    isHeaderImageNeeded: boolean;
	    isNavigationPanelHeaderHidden: boolean;
	    isNavigationPanelOpened: boolean;
	    isNewPage: boolean;
	    isTitleHidden?: boolean;
	    objectTypePlural?: string | null;
	    objectTypeSingular?: string | null;
	    pageMode: PageMode;
	    sections: Partial<PageArticleItem>[];
	    sectionsProperties: Dict<SectionProperties>;
	    sectionValidationErrors: Dict<string | null>;
	    setNavigationPanelIsOpened: (isOpened: boolean) => void;
	    shouldDisplayNavigationArrows: boolean;
	    subtitle?: string;
	    title: string;
	}
	export interface HeaderState {
	    isHeaderSectionClosed?: boolean;
	}
	export class XtremHeader extends React.Component<XtremHeaderProps, HeaderState> {
	    private readonly activeIndicator;
	    private readonly tabContainer;
	    private readonly tabDictionary;
	    private readonly hotkeySubscriptions;
	    private readonly parentRef;
	    constructor(props: XtremHeaderProps);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: XtremHeaderProps): void;
	    componentWillUnmount(): void;
	    private setIndicatorPosition;
	    private readonly getActiveSectionIndex;
	    private readonly setActiveSectionByIndex;
	    private readonly setActiveSection;
	    private readonly hasTabs;
	    private readonly getClasses;
	    private readonly getVisibleTabs;
	    private readonly onRecordClose;
	    private readonly renderTabs;
	    private readonly onHeaderSectionToggle;
	    renderCloseIcon: () => React.ReactNode;
	    renderHeaderToggleButton: () => React.ReactNode;
	    private readonly renderTitleImage;
	    render(): React.ReactNode;
	}
	export const ConnectedXtremHeader: import("react-redux").ConnectedComponent<typeof XtremHeader, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<XtremHeader> | undefined;
	    activeSection: string | null;
	    areNavigationTabsHidden: boolean;
	    availableColumns: number;
	    contextType?: ContextType | undefined;
	    hasNavigationPanel: boolean;
	    headerLineBlock: Partial<PageArticleItem> | null;
	    isRecordCreationPage?: boolean | undefined;
	    navigationPanelValue?: CollectionValue<any> | undefined;
	    pageBodyRef: React.RefObject<HTMLDivElement>;
	    screenId: string;
	    setActiveSection: (sectionId: string) => void;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=xtrem-header.d.ts.map
}
declare module 'lib/component/ui/dnd-files/drag-and-drop-file' {
	import React, { type ReactNode } from 'react';
	interface DragAndDropFileProps {
	    isDisabled?: boolean;
	    children: ReactNode;
	    onFileDrop: (files: FileList) => void;
	} function DragAndDropFile({ children, isDisabled, onFileDrop }: DragAndDropFileProps): React.ReactElement;
	export default DragAndDropFile;
	//# sourceMappingURL=drag-and-drop-file.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/abstract-widget-query-builder' {
	import type { AggregationProperty, UserWidgetDefinition } from 'lib/redux/state';
	import type { LoadMoreRowsParams } from 'lib/service/dashboard-service';
	import type { Aggregations } from '@sage/xtrem-shared';
	export class AbstractWidgetQueryBuilder {
	    protected filters: {};
	    protected groupByPath?: string;
	    protected nodePath: string;
	    protected orderBy: {};
	    protected query: any;
	    protected queryType: 'readAggregate' | 'queryAggregate' | 'query';
	    protected userWidgetDefinition: UserWidgetDefinition;
	    constructor(userWidgetDefinition: UserWidgetDefinition);
	    getFilterObject(): any;
	    protected buildPath(): this;
	    protected buildQuery(queryArgs?: LoadMoreRowsParams): this;
	    protected buildGroupBySingleValueQuery(): this;
	    protected buildGroupByMultipleValuesQuery({ group, aggregations, first, }: {
	        group: NonNullable<UserWidgetDefinition['xAxis']>;
	        aggregations: AggregationProperty[];
	        first?: number;
	    }): this;
	    protected createAggregationFragment(aggregationProperty: string, aggregationMethod?: Aggregations): any;
	    protected buildOrderBy(): this;
	    protected buildFilter(): this;
	    build(): any;
	    getValue(_data: any): any;
	}
	//# sourceMappingURL=abstract-widget-query-builder.d.ts.map
}
declare module 'lib/dashboard/dashboard-types' {
	import type { Dashboard } from '@sage/xtrem-shared';
	export interface UiDashboard extends Dashboard {
	    isSelected?: boolean;
	}
	export interface DashboardContextVariables {
	    recordId: string;
	}
	//# sourceMappingURL=dashboard-types.d.ts.map
}
declare module 'lib/dashboard/widgets/widget-utils' {
	/// <reference types="react" />
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator, WidgetType } from 'lib/dashboard/widgets/abstract-widget';
	export const SplitBox: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("carbon-react/esm/components/box").BoxProps & import("react").RefAttributes<HTMLDivElement>>, any, {}, never>;
	export const standardWidgetDecorator: <W extends AbstractWidget<any, {}>>(properties: AbstractWidgetDecorator<W>, type: WidgetType) => (ctor: Constructible<AbstractWidget>) => void;
	export type WidgetValueOrCallback<Context extends AbstractWidget, T extends any = any> = T | ((this: Context) => T);
	export type WidgetValueOrCallbackWithId<Context extends AbstractWidget, T extends any = any> = T | ((this: Context, _id: string) => T);
	//# sourceMappingURL=widget-utils.d.ts.map
}
declare module 'lib/dashboard/widgets/chart-types' {
	/// <reference types="react" />
	import type { Dict } from '@sage/xtrem-shared';
	import type { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	interface AxisDefinition<W extends AbstractWidget> {
	    bind: string;
	    title?: WidgetValueOrCallback<W, string>;
	}
	interface SecondaryAxisDefinition<W extends AbstractWidget, T = any, P = any, S = any> extends AxisDefinition<W> {
	    color?: React.CSSProperties['color'];
	    onClick?: (this: W, record: T, primaryValue: P, secondaryValue: S) => void;
	    tooltipContent?: (this: W, record: T, primaryValue: P, secondaryValue: S) => string;
	}
	interface ChartProps<W extends AbstractWidget, T = any, P = any, S = any> {
	    dataOptions?: Dict<Dict<string>>;
	    primaryAxis: AxisDefinition<W>;
	    primaryAxisLabel?: string;
	    secondaryAxes: SecondaryAxisDefinition<W, T, P, S>[];
	    secondaryAxisLabel?: string;
	}
	type ExtractWidgetDataType<W extends AbstractWidget> = W extends AbstractWidget<infer D> ? D : any;
	export type { AxisDefinition, ChartProps, ExtractWidgetDataType, SecondaryAxisDefinition };
	//# sourceMappingURL=chart-types.d.ts.map
}
declare module 'lib/dashboard/widgets/bar-chart-widget-decorator' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator, WithContent } from 'lib/dashboard/widgets/abstract-widget';
	import type { ChartProps, ExtractWidgetDataType } from 'lib/dashboard/widgets/chart-types';
	export interface BarChartWidgetProperties<W extends AbstractWidget, C = any, P = any, S = any> extends AbstractWidgetDecorator<W>, WithContent<W, C>, ChartProps<W, C, P, S> {
	    areAxesStacked?: boolean;
	    areAxesSwapped?: boolean;
	    dataOptions?: Dict<Dict<string>>;
	    isHistogram?: boolean;
	}
	export function barChart<W extends AbstractWidget, C = any, P = any, S = number>(properties: BarChartWidgetProperties<W, C, P, S>): (ctor: Constructible<AbstractWidget<ExtractWidgetDataType<W>>>) => void;
	//# sourceMappingURL=bar-chart-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/widgets/line-chart-widget-decorator' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator, WithContent } from 'lib/dashboard/widgets/abstract-widget';
	import type { ChartProps, ExtractWidgetDataType } from 'lib/dashboard/widgets/chart-types';
	export interface LineChartWidgetProperties<W extends AbstractWidget, C = any, P = any, S = any> extends AbstractWidgetDecorator<W>, WithContent<W, C>, ChartProps<W, C, P, S> {
	    dataOptions?: Dict<Dict<string>>;
	}
	export function lineChart<W extends AbstractWidget, C = any, P = any, S = number>(properties: LineChartWidgetProperties<W, C, P, S>): (ctor: Constructible<AbstractWidget<ExtractWidgetDataType<W>>>) => void;
	//# sourceMappingURL=line-chart-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/chart-widget-query-builder' {
	import { AbstractWidgetQueryBuilder } from 'lib/dashboard/generic-widgets';
	import type { AggregationProperty } from 'lib/redux/state';
	export class ChartWidgetQueryBuilder extends AbstractWidgetQueryBuilder {
	    build(queryParams?: {
	        first: number;
	    }): any;
	    getValue(data: any): any;
	    protected formatValue({ property: { data: { type }, decimalDigits, divisor, }, value, }: {
	        property: AggregationProperty;
	        value: any;
	    }): number | string;
	}
	//# sourceMappingURL=chart-widget-query-builder.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/generic-widget-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { UserWidgetDefinition } from 'lib/redux/state';
	import type { AbstractWidget, CallToActionDefinition } from 'lib/dashboard/widgets/abstract-widget';
	export const getCallToActionsFromWidgetDefinition: (userWidgetDefinition: UserWidgetDefinition, filter?: any, isPreview?: boolean) => Dict<CallToActionDefinition<AbstractWidget>>;
	//# sourceMappingURL=generic-widget-utils.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/generic-chart-widget' {
	import type { UserWidgetDefinition } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	import { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	export const createGenericChartWidgetDefinition: (userWidgetDefinition: UserWidgetDefinition, dashboardId: string, widgetId: string, group: string, contextVariables?: DashboardContextVariables, isPreview?: boolean) => AbstractWidget;
	//# sourceMappingURL=generic-chart-widget.d.ts.map
}
declare module 'lib/dashboard/widgets/indicator-tile-widget-decorator' {
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	export interface IndicatorTileWidgetProperties<W extends AbstractWidget> extends AbstractWidgetDecorator<W> {
	    /** Icon that is displayed on the left side of the widget */
	    icon?: WidgetValueOrCallback<W, string>;
	    /** Color of the icon and its background */
	    color?: WidgetValueOrCallback<W, string>;
	    /** Key property value that is displayed in the middle of the widget */
	    value?: WidgetValueOrCallback<W, string>;
	    /** Key property value that is displayed in the middle of the widget */
	    subtitle?: WidgetValueOrCallback<W, string>;
	    /** Key property value that is displayed in the middle of the widget */
	    decimalDigits?: WidgetValueOrCallback<W, number>;
	    /** Action triggered when the tile is clicked. */
	    onClick?: (this: W) => void;
	}
	/**
	 * The indicator tile widget is a simple status or value summary indicator. It consists of a main value, an icon with a particular
	 * background color and a subtitle.
	 * */
	export function indicatorTile<W extends AbstractWidget>(properties: IndicatorTileWidgetProperties<W>): (ctor: Constructible<AbstractWidget>) => void;
	//# sourceMappingURL=indicator-tile-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/indicator-tile-widget-query-builder' {
	import { AbstractWidgetQueryBuilder } from 'lib/dashboard/generic-widgets';
	export class IndicatorTileWidgetQueryBuilder extends AbstractWidgetQueryBuilder {
	    build(): any;
	    getValue(data: any): any;
	}
	//# sourceMappingURL=indicator-tile-widget-query-builder.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/generic-indicator-tile-widget' {
	import type { UserWidgetDefinition } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	import { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	export const createGenericIndicatorTileWidgetDefinition: (userWidgetDefinition: UserWidgetDefinition, dashboardId: string, widgetId: string, group: string, contextVariables?: DashboardContextVariables, isPreview?: boolean) => AbstractWidget;
	//# sourceMappingURL=generic-indicator-tile-widget.d.ts.map
}
declare module 'lib/dashboard/widgets/table-widget-decorator' {
	import type { DateFilterPeriodType, PeriodDetails, RenderAsType, TableWidgetProps, ValueFormatType, WidgetCollectionItem } from '@sage/bms-dashboard';
	import type { Dict } from '@sage/xtrem-shared';
	import type { Constructible } from 'lib/types';
	import { type AbstractWidget, type AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetValueOrCallback, WidgetValueOrCallbackWithId } from 'lib/dashboard/widgets/widget-utils';
	export type TableWidgetOptions = {
	    mode?: 'card' | 'table';
	    dataOptions?: Dict<string>;
	    selectedPeriod?: PeriodDetails;
	    selectedItems?: string[];
	};
	type TableWidgetType = AbstractWidget<any, TableWidgetOptions>;
	export interface WidgetDisplayOptions<W extends TableWidgetType> {
	    colorVariant?: WidgetValueOrCallbackWithId<W, 'neutral' | 'negative' | 'positive' | 'warning'>;
	    tooltipText?: WidgetValueOrCallbackWithId<W, string>;
	}
	export interface ColumnDefinitionOptions<W extends TableWidgetType> {
	    title: string;
	    onClick?: (this: W, _id: string) => void;
	    displayOptions?: WidgetDisplayOptions<W>;
	    renderedAs?: RenderAsType;
	    valueFormat?: ValueFormatType;
	    decimalDigits?: number;
	}
	export interface RowDefinition<W extends AbstractWidget> {
	    title: ColumnDefinitionOptions<W>;
	    titleRight?: ColumnDefinitionOptions<W>;
	    line2?: ColumnDefinitionOptions<W>;
	    line2Right?: ColumnDefinitionOptions<W>;
	    line3?: ColumnDefinitionOptions<W>;
	    line3Right?: ColumnDefinitionOptions<W>;
	    image?: ColumnDefinitionOptions<W>;
	    icon?: ColumnDefinitionOptions<W>;
	    [key: string]: ColumnDefinitionOptions<W> | undefined;
	}
	export interface TableWidgetRow extends Omit<WidgetCollectionItem, 'i'> {
	    _id: number | string;
	}
	export type TableDropDownOption = Dict<{
	    title: string;
	}>;
	export type TableDropDownMenu = Dict<TableDropDownOption>;
	export interface TableWidgetDateFilter<W extends TableWidgetType> {
	    minDate?: WidgetValueOrCallback<W, Date>;
	    maxDate?: WidgetValueOrCallback<W, Date>;
	    /** Type of periods that the user can choose from. Defaults to all available periods */
	    periodTypes?: DateFilterPeriodType[];
	    /** Defaults to day */
	    defaultPeriodType?: DateFilterPeriodType;
	    /** Defaults to today */
	    defaultDate?: WidgetValueOrCallback<W, Date>;
	}
	export interface TableWidgetProperties<W extends TableWidgetType> extends AbstractWidgetDecorator<W> {
	    businessIcon?: WidgetValueOrCallback<W, TableWidgetProps['iconSrc']>;
	    canSelect?: WidgetValueOrCallback<W, boolean>;
	    canSwitchViewMode?: WidgetValueOrCallback<W, boolean>;
	    content?: WidgetValueOrCallback<W, TableWidgetRow[]>;
	    dataDropdownMenu?: WidgetValueOrCallback<W, TableDropDownMenu>;
	    dateFilter?: TableWidgetDateFilter<W>;
	    displayMode?: WidgetValueOrCallback<W, 'card' | 'table'>;
	    filterMenuType?: TableWidgetProps['filterMenuType'];
	    rowDefinition: WidgetValueOrCallback<W, RowDefinition<W>>;
	    totalCount?: WidgetValueOrCallback<W, number | undefined>;
	    rowActions?: WidgetValueOrCallback<W, (Omit<NonNullable<TableWidgetProps['rowActions']>[number], 'onClick'> & {
	        onClick: (this: W, i: string | number) => void;
	    })[]>;
	}
	/**
	 * A widget that displays tabular data as a table or card view.
	 */
	export function table<W extends TableWidgetType>(properties: TableWidgetProperties<W>): (ctor: Constructible<TableWidgetType>) => void;
	export {};
	//# sourceMappingURL=table-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/table-widget-query-builder' {
	import { AbstractWidgetQueryBuilder } from 'lib/dashboard/generic-widgets';
	import type { TableProperty, UserWidgetDefinition } from 'lib/redux/state';
	import type { LoadMoreRowsParams } from 'lib/service/dashboard-service';
	import type { RowDefinition } from 'lib/dashboard/widgets/table-widget-decorator';
	export class TableWidgetQueryBuilder extends AbstractWidgetQueryBuilder {
	    private columns;
	    rowDefinition: RowDefinition<any>;
	    constructor(userWidgetDefinition: UserWidgetDefinition);
	    build(queryArgs?: LoadMoreRowsParams): any;
	    getValue(data: any): any;
	    protected formatValue({ column: { data: { type, enumValues, node }, formatting, divisor, }, value, isJsonSubfield, }: {
	        column: TableProperty;
	        value: any;
	        isJsonSubfield?: boolean;
	    }): string;
	}
	//# sourceMappingURL=table-widget-query-builder.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/generic-table-widget' {
	import type { UserWidgetDefinition } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	import { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	export const createGenericTableWidgetDefinition: (userWidgetDefinition: UserWidgetDefinition, dashboardId: string, widgetId: string, group: string, contextVariables?: DashboardContextVariables, isPreview?: boolean) => AbstractWidget;
	//# sourceMappingURL=generic-table-widget.d.ts.map
}
declare module 'lib/dashboard/generic-widgets/index' {
	import { AbstractWidgetQueryBuilder } from 'lib/dashboard/generic-widgets/abstract-widget-query-builder';
	import type { UserWidgetDefinition } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	import type { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	export { AbstractWidgetQueryBuilder };
	export const GENERIC_PLATFORM_WIDGET_PREFIX = "@sage/xtrem-ui";
	export const getGenericWidgetDefinition: (userWidgetDefinition: UserWidgetDefinition, dashboardId: string, widgetId: string, group: string, contextVariables?: DashboardContextVariables, isPreview?: boolean) => AbstractWidget;
	export const getGenericWidgetArtifactName: (userWidgetDefinition: UserWidgetDefinition) => string;
	//# sourceMappingURL=index.d.ts.map
}
declare module 'lib/dashboard/widgets/contact-card-widget-decorator' {
	import type { ContactCardProps } from '@sage/bms-dashboard';
	import type { Constructible } from 'lib/types';
	import { type AbstractWidget, type AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import { type WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	export type ContactCardWidgetOptions = Omit<ContactCardProps, 'stringLiterals'> & {
	    selectedContactType?: 'contact' | 'site';
	    selectedContactId?: string;
	};
	type ContactCardWidgetType = AbstractWidget<any, ContactCardWidgetOptions>;
	export type ContactCardWidgetContent = Omit<ContactCardProps, 'stringLiterals'>;
	export interface ContactCardWidgetProperties<W extends ContactCardWidgetType> extends AbstractWidgetDecorator<W> {
	    content?: WidgetValueOrCallback<W, ContactCardWidgetContent>;
	}
	/**
	 * The contact card widget
	 * */
	export function contactCard<W extends ContactCardWidgetType>(properties: ContactCardWidgetProperties<W>): (ctor: Constructible<ContactCardWidgetType>) => void;
	export {};
	//# sourceMappingURL=contact-card-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/widgets/pie-chart-widget-decorator' {
	import type { PieChartProps } from '@sage/bms-dashboard';
	import type { Dict } from '@sage/xtrem-shared';
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import type { RowDefinition, TableWidgetRow } from 'lib/dashboard/widgets/table-widget-decorator';
	import type { WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	export type PieChartWidgetOptions = {
	    selectedFilter?: string;
	};
	type PieChartWidgetType = AbstractWidget<any, PieChartWidgetOptions>;
	export interface PieChartWidgetProperties<W extends PieChartWidgetType> extends AbstractWidgetDecorator<W>, Omit<PieChartProps, 'pieChartData'> {
	    rowDefinition: WidgetValueOrCallback<W, RowDefinition<W>>;
	    content?: WidgetValueOrCallback<W, TableWidgetRow[]>;
	    isDonut?: boolean;
	    hasCardView?: boolean;
	    filter?: {
	        ariaLabel: string;
	        options: Dict<string>;
	        onChange(this: PieChartWidgetType, newValue: string | null): void;
	        value?: string;
	        isFullWidth?: boolean;
	        representation?: 'dropdown' | 'tabs';
	        isEmptyAllowed?: boolean;
	    };
	}
	export function pieChart<W extends PieChartWidgetType>(properties: PieChartWidgetProperties<W>): (ctor: Constructible<W>) => void;
	export {};
	//# sourceMappingURL=pie-chart-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/widgets/gauge-widget-decorator' {
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	export interface GaugeWidgetData {
	    value: number;
	    totalValue?: number;
	    evolutionValue?: number;
	}
	export interface GaugeWidgetProperties<W extends AbstractWidget> extends AbstractWidgetDecorator<W> {
	    content?: WidgetValueOrCallback<W, GaugeWidgetData>;
	    scale?: WidgetValueOrCallback<W, number>;
	    valueUnit?: WidgetValueOrCallback<W, string>;
	    color?: WidgetValueOrCallback<W, string>;
	    evolutionUnit?: WidgetValueOrCallback<W, string>;
	}
	export function gauge<W extends AbstractWidget>(properties: GaugeWidgetProperties<W>): (ctor: Constructible<AbstractWidget>) => void;
	//# sourceMappingURL=gauge-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/widgets/static-content-widget-decorator' {
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	export interface StaticContentWidgetProperties<W extends AbstractWidget> extends AbstractWidgetDecorator<W> {
	    /** Content of the widget in [Markdown](https://en.wikipedia.org/wiki/Markdown) format. */
	    content?: WidgetValueOrCallback<W, string>;
	}
	/**
	 * A widget that displays static content using [Markdown](https://en.wikipedia.org/wiki/Markdown). It can be used to display announcements or other text based summaries to the users.
	 */
	export function staticContent<W extends AbstractWidget>(properties: StaticContentWidgetProperties<W>): (ctor: Constructible<AbstractWidget>) => void;
	//# sourceMappingURL=static-content-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/widgets/visual-process-widget-decorator' {
	import type { Constructible } from 'lib/types';
	import type { AbstractWidget, AbstractWidgetDecorator } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetValueOrCallback } from 'lib/dashboard/widgets/widget-utils';
	import type { XDocument } from '@sage/visual-process-editor';
	export interface VisualProcessWidgetProperties<W extends AbstractWidget> extends AbstractWidgetDecorator<W> {
	    content?: WidgetValueOrCallback<W, XDocument>;
	}
	export function visualProcess<W extends AbstractWidget>(properties: VisualProcessWidgetProperties<W>): (ctor: Constructible<AbstractWidget>) => void;
	//# sourceMappingURL=visual-process-widget-decorator.d.ts.map
}
declare module 'lib/dashboard/widgets/index' {
	import { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	import type { ContactCardWidgetOptions } from 'lib/dashboard/widgets/contact-card-widget-decorator';
	import type { PieChartWidgetOptions } from 'lib/dashboard/widgets/pie-chart-widget-decorator';
	import type { TableWidgetOptions } from 'lib/dashboard/widgets/table-widget-decorator';
	export { AbstractWidget, WidgetCacheLifespan } from 'lib/dashboard/widgets/abstract-widget';
	export { barChart } from 'lib/dashboard/widgets/bar-chart-widget-decorator';
	export { contactCard, type ContactCardWidgetOptions, type ContactCardWidgetProperties, } from 'lib/dashboard/widgets/contact-card-widget-decorator';
	export { gauge } from 'lib/dashboard/widgets/gauge-widget-decorator';
	export { indicatorTile } from 'lib/dashboard/widgets/indicator-tile-widget-decorator';
	export { lineChart } from 'lib/dashboard/widgets/line-chart-widget-decorator';
	export { pieChart, type PieChartWidgetProperties } from 'lib/dashboard/widgets/pie-chart-widget-decorator';
	export { staticContent } from 'lib/dashboard/widgets/static-content-widget-decorator';
	export { table } from 'lib/dashboard/widgets/table-widget-decorator';
	export { visualProcess } from 'lib/dashboard/widgets/visual-process-widget-decorator';
	export class ContactCardWidget<T = any> extends AbstractWidget<T, ContactCardWidgetOptions> {
	}
	export class TableWidget<T = any> extends AbstractWidget<T, TableWidgetOptions> {
	}
	export class PieChartWidget<T = any> extends AbstractWidget<T, PieChartWidgetOptions> {
	}
	//# sourceMappingURL=index.d.ts.map
}
declare module 'lib/service/dashboard-service' {
	import { type AbstractWidget as BmsAbstractWidget, type VisualProcessProps, type WidgetCollectionItem } from '@sage/bms-dashboard';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dashboard, DashboardItem, Dict } from '@sage/xtrem-shared';
	import type { AbstractWidget, WidgetDefinition } from 'lib/dashboard/widgets/abstract-widget';
	import type { DashboardListItem } from 'lib/redux/state';
	export const DASHBOARD_DETAILS_QUERY: {
	    _id: boolean;
	    title: boolean;
	    isTemplate: boolean;
	    children: {
	        _id: boolean;
	        type: boolean;
	        settings: boolean;
	        x: boolean;
	        y: boolean;
	        h: boolean;
	        w: boolean;
	    };
	};
	export const fetchCurrentDashboardDefinition: (group: string, shouldFetchPlatformLiterals?: boolean) => Promise<{
	    dashboard: Dashboard | null;
	    stringLiterals: Dict<string>;
	    availableDashboards: DashboardListItem[] | null;
	    canEditDashboards: boolean;
	}>;
	export const fetchWidgetCategories: () => Promise<Dict<string>>;
	export const fetchDashboardTemplates: (group: string) => Promise<DashboardListItem[]>;
	export const setSelectedDashboard: (selectedId: string, group: string) => Promise<Dashboard>;
	export const cloneDashboard: (dashboardIdToClone: string) => Promise<Dashboard>;
	export const deleteDashboard: (dashboardIdToDelete: string) => Promise<void>;
	export const createEmptyDashboard: (group: string) => Promise<Dashboard>;
	export const updateDashboard: (dashboardDefinition: Dashboard) => Promise<Dashboard>;
	export interface XtremUiWidgetCategory extends ClientNode {
	    title: string;
	    sortValue?: number;
	}
	export interface XtremUiWidget extends ClientNode {
	    category: XtremUiWidgetCategory;
	    title: string;
	    description: string;
	    type: string;
	}
	/**
	 * Fetches widget list from the server and adds "Others" category to those which doesn't have one.
	 * It also adds a _sortValue as the items should be categorized alphabetically, e
	 * except the Others, so we cannot sort them just by their label
	 * @returns
	 */
	export const getWidgetList: (group?: string) => Promise<{
	    widgets: XtremUiWidget[];
	    categories: XtremUiWidgetCategory[];
	}>;
	export const refreshWidget: (widgetId: string, group: string, skipUnset?: boolean) => void;
	export const fetchWidgetPage: ({ queryArgs, widgetId, group, }: {
	    widgetId: string;
	    queryArgs: LoadMoreRowsParams;
	    group: string;
	}) => Promise<WidgetCollectionItem[]>;
	export type PillColorVariant = 'warning' | 'neutral' | 'negative' | 'positive';
	export type LoadMoreRowsParams = {
	    startIndex: number;
	    stopIndex: number;
	    pageCount: number;
	    pageSize: number;
	    after?: WidgetCollectionItem;
	    first: number;
	};
	export const getVisualProcessWidgetConfig: (widgetId: string, widgetDefinition: WidgetDefinition, group: string, isEditing?: boolean) => Partial<BmsAbstractWidget<VisualProcessProps>>;
	export const getWidgetsFromDashboardItems: (dashboardId: string, group: string, children: DashboardItem[], widgets: Dict<WidgetDefinition>, isEditing?: boolean, onCloseCallback?: (widgetId: string) => void, canEditDashboards?: boolean) => BmsAbstractWidget[];
	export const fetchWidgetData: ({ forceRefetch, locale, version, widgetDefinition, queryArgs, group, }: {
	    forceRefetch?: boolean;
	    locale?: string;
	    version?: string;
	    widgetDefinition: WidgetDefinition;
	    group: string;
	    queryArgs?: Partial<LoadMoreRowsParams>;
	}) => Promise<any>;
	export const resolveWidgetProperty: <T>(property: T, group: string, widget: string | AbstractWidget, ...args: any[]) => T extends (...args: any) => any ? ReturnType<T> : T | undefined;
	//# sourceMappingURL=dashboard-service.d.ts.map
}
declare module 'lib/dashboard/dashboard-strings' {
	import type { StringLiterals } from '@sage/bms-dashboard';
	export const localeText: () => Partial<StringLiterals>;
	export default localeText;
	//# sourceMappingURL=dashboard-strings.d.ts.map
}
declare module 'lib/dashboard/dashboard-placeholder' {
	import * as React from 'react';
	export interface DashboardPlaceholderProps {
	    isTitlePlaceholderHidden?: boolean;
	}
	export function DashboardPlaceholder({ isTitlePlaceholderHidden }: DashboardPlaceholderProps): React.ReactElement;
	//# sourceMappingURL=dashboard-placeholder.d.ts.map
}
declare module 'lib/dashboard/async-drag-drop-canvas-wrapper' {
	import * as React from 'react';
	import type { DragDropCanvasWrapperProps } from '@sage/bms-dashboard';
	export function AsyncDragDropCanvasWrapper(props: DragDropCanvasWrapperProps): React.ReactElement;
	export default AsyncDragDropCanvasWrapper;
	//# sourceMappingURL=async-drag-drop-canvas-wrapper.d.ts.map
}
declare module 'lib/dashboard/dashboard-title-editor' {
	import * as React from 'react';
	export interface DashboardTitleEditorProps {
	    title: string;
	    onChange: (newTitle: string) => void;
	}
	export function DashboardTitleEditor({ title, onChange }: DashboardTitleEditorProps): React.ReactElement;
	//# sourceMappingURL=dashboard-title-editor.d.ts.map
}
declare module 'lib/dashboard/dashboard-selection-tabs' {
	import * as React from 'react';
	import type { DashboardListItem } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export interface DashboardSelectionTabsExternalProps {
	    canChangeTabs?: () => Promise<void>;
	    onCreateDialogOpen?: () => void;
	    contextVariables?: DashboardContextVariables;
	    group: string;
	}
	export interface DashboardSelectionTabsProps extends DashboardSelectionTabsExternalProps {
	    availableDashboards: DashboardListItem[];
	    selectedDashboardId?: string;
	    setSelectedDashboard: (dashboardId: string) => void;
	}
	export function DashboardSelectionTabs({ availableDashboards, onCreateDialogOpen, selectedDashboardId, setSelectedDashboard, canChangeTabs, }: DashboardSelectionTabsProps): React.ReactElement | null;
	export const ConnectedDashboardSelectionTabs: import("react-redux").ConnectedComponent<typeof DashboardSelectionTabs, {
	    canChangeTabs?: (() => Promise<void>) | undefined;
	    onCreateDialogOpen?: (() => void) | undefined;
	    contextVariables?: DashboardContextVariables | undefined;
	    group: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=dashboard-selection-tabs.d.ts.map
}
declare module 'lib/redux/actions/dashboard-actions' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	import type { AbstractWidget, WidgetDefinition } from 'lib/dashboard/widgets/abstract-widget';
	import { type LoadMoreRowsParams } from 'lib/service/dashboard-service';
	import type { Constructible } from 'lib/types';
	import type { AppAction, AppThunkDispatch } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state';
	/**
	 * Constructs the widget object depending its type. It checks if the widget is generic user configured or functional code provided, then constructs it.
	 */
	export const createWidgetObject: ({ contextVariables, dashboardId, group, settings, type, widgetConstructors, widgetId, }: {
	    contextVariables?: DashboardContextVariables;
	    dashboardId: string;
	    group: string;
	    settings?: any;
	    type: string;
	    widgetConstructors: Dict<Constructible<AbstractWidget>>;
	    widgetId: string;
	}) => AbstractWidget;
	export const refreshCurrentDashboard: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const fetchUserDashboardDefinition: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const setSelectedDashboard: (id: string, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	/**
	 * Clone a dashboard based on its ID, then marks it automatically selected
	 * @param idToClone
	 * @returns
	 */
	export const cloneDashboard: (idToClone: string, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	/**
	 * Creates an empty dashboard, then marks it automatically selected
	 * @param idToClone
	 * @returns
	 */
	export const createEmptyDashboard: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const deleteDashboard: (dashboardId: string, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export function getNewTableData({ widgetDefinition, data, }: {
	    widgetDefinition: WidgetDefinition;
	    data: any;
	    group: string;
	}): any;
	export const loadWidgetData: ({ widgetId, group, forceRefetch, queryArgs, dataMode, skipUnset, }: {
	    widgetId: string;
	    group: string;
	    forceRefetch?: boolean;
	    queryArgs?: LoadMoreRowsParams;
	    dataMode?: 'SET' | 'ADD';
	    skipUnset?: boolean;
	}) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<any[]>;
	export const setWidgetOptions: (dashboardId: string, widgetId: string, group: string, options: any) => AppAction;
	export const SetWidgetLoading: (widgetId: string, isLoading: boolean) => AppAction;
	//# sourceMappingURL=dashboard-actions.d.ts.map
}
declare module 'lib/redux/actions/widget-editor-actions' {
	import type { AppAction, AppThunkDispatch } from 'lib/redux/action-types';
	import type { UserWidgetDefinition, XtremAppState } from 'lib/redux/state';
	export const openWidgetEditorDialog: (group: string, widgetId?: string, widgetDefinition?: UserWidgetDefinition) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const closeWidgetEditorDialog: (group: string) => AppAction;
	export const updateUserWidgetDefinition: (widgetDefinition: UserWidgetDefinition, group: string) => AppAction;
	//# sourceMappingURL=widget-editor-actions.d.ts.map
}
declare module 'lib/dashboard/widget-editor/widget-editor-utils' {
	import { type Dict, type Property } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { UserCustomizableWidget, UserWidgetDefinition } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export interface WidgetEditorStepProps {
	    contextVariables?: DashboardContextVariables;
	    group: string;
	    locale: string;
	    nodeNames: Dict<string>;
	    onWidgetDefinitionUpdated: (newData: UserWidgetDefinition) => void;
	    stepIndex: number;
	    widgetDefinition: UserWidgetDefinition;
	}
	export interface WidgetEditorStep {
	    key: WidgetEditorStepType;
	    title: string;
	}
	export type StepStatus = 'complete' | 'current' | 'incomplete';
	export const DEFAULT_CHART_COLORS: {
	    label: string;
	    value: string;
	}[];
	export interface WidgetStepDefinition {
	    title: string;
	    isValid: (uwd: UserWidgetDefinition) => boolean;
	}
	export type WidgetEditorStepType = 'BASIC_INFO' | 'DATA' | 'CONTENT' | 'FILTERS' | 'SORTING' | 'LAYOUT';
	/** This most be a function and cannot be a const, as the localize function must be called when the widget editor is
	 * being opened to enure that the strings were loaded.
	 * */
	export const getWidgetEditorSteps: () => Dict<WidgetStepDefinition>;
	export const stepsForWidgetTypes: Record<UserCustomizableWidget, WidgetEditorStepType[]>;
	export function isChart(widgetDefinition: UserWidgetDefinition): boolean;
	export const getStepStatus: (availableSteps: string[], activeStep: string, step: string) => StepStatus;
	export const PropertyTableHeader: React.FC;
	export const getPropertyParentNode: ({ property, nodeNames, widgetDefinition, }: {
	    property: Property;
	    nodeNames: Dict<string>;
	    widgetDefinition: UserWidgetDefinition;
	}) => string;
	export const getWidgetDefaultSize: ({ type, columns }: UserWidgetDefinition) => {
	    w: number;
	    h: number;
	};
	//# sourceMappingURL=widget-editor-utils.d.ts.map
}
declare module 'lib/redux/actions/dashboard-editor-actions' {
	import type { Dashboard, Dict } from '@sage/xtrem-shared';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import * as dashboardService from 'lib/service/dashboard-service';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { AppAction, AppThunkDispatch } from 'lib/redux/action-types';
	import type { UserWidgetDefinition, XtremAppState } from 'lib/redux/state';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export const resetNextWidgetIdOnlyToBeUsedInTests: () => void;
	export const getWidgetListCardDefinition: (dispatch: AppThunkDispatch, group: string, contextVariables?: DashboardContextVariables) => CardDefinition<any>;
	export const saveDashboardEditorState: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const createDashboardPageDefinition: (dispatch: AppThunkDispatch, group: string, widgets: dashboardService.XtremUiWidget[], categories: dashboardService.XtremUiWidgetCategory[], contextVariables?: DashboardContextVariables, nodeTypes?: Dict<FormattedNodeDetails>, locale?: string) => PageDefinition;
	export const openDashboardEditorDialog: (group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const closeDashboardEditorDialog: (group: string) => AppAction;
	export const undoDashboardEditor: (group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const redoDashboardEditor: (group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const updateDashboardEditorStateWithHistory: (newDashboardDefinition: Dashboard, group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const removeDashboardEditorWidget: (widgetId: string, group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const updateDashboardTitleInEditor: (newTitle: string, group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	/**
	 * Fetches widget source code from the server. It should be called when a new widget is added to the dashboard which has not been previously
	 * loaded into the state from the server.
	 *
	 */
	export const loadNewWidget: (widgetType: string, widgetId: string, dashboardId: string, group: string, contextVariables?: DashboardContextVariables, settings?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export interface WidgetPosition {
	    i: string;
	    x: number;
	    y: number;
	    h: number;
	    w: number;
	}
	export const updateDashboardEditorWidgetPositions: (widgets: WidgetPosition[], group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const addNewWidgetToDashboardLayout: (widgetId: string, artifactName: string, group: string, uwd?: UserWidgetDefinition) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const updateWidgetSettings: (widgetId: string, group: string, settings?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const addFunctionalDeveloperDefinedWidget: (widget: dashboardService.XtremUiWidget, group: string, contextVariables?: DashboardContextVariables) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	/**
	 * Takes the current working copy of from the widget editor and adds it to the dashboard definition.
	 * @returns
	 */
	export const finishEditingUserDefinedWidget: (group: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	//# sourceMappingURL=dashboard-editor-actions.d.ts.map
}
declare module 'lib/dashboard/widget-editor/basics-step' {
	import * as React from 'react';
	import type { Dict } from '@sage/xtrem-shared';
	import type { WidgetEditorStepProps } from 'lib/dashboard/widget-editor/widget-editor-utils';
	import type { ResponsiveTypes } from 'lib/redux/state';
	export interface BasicsStepProps extends WidgetEditorStepProps {
	    widgetCategories: Dict<string>;
	    browserIs: ResponsiveTypes;
	    isNewWidget: boolean;
	}
	export function BasicsStep({ nodeNames, widgetCategories, onWidgetDefinitionUpdated, widgetDefinition, browserIs, isNewWidget, stepIndex, }: BasicsStepProps): React.ReactElement;
	export const ConnectedBasicsStep: import("react-redux").ConnectedComponent<typeof BasicsStep, {
	    contextVariables?: import("../dashboard-types").DashboardContextVariables | undefined;
	    group: string;
	    locale: string;
	    nodeNames: Dict<string>;
	    onWidgetDefinitionUpdated: (newData: import("../../redux/state").UserWidgetDefinition) => void;
	    stepIndex: number;
	    widgetDefinition: import("../../redux/state").UserWidgetDefinition;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=basics-step.d.ts.map
}
declare module 'lib/dashboard/widget-editor/data-step' {
	import * as React from 'react';
	import type { WidgetEditorStepProps } from 'lib/dashboard/widget-editor/widget-editor-utils';
	export function DataStep({ stepIndex, widgetDefinition, onWidgetDefinitionUpdated, locale, }: WidgetEditorStepProps): React.ReactElement;
	//# sourceMappingURL=data-step.d.ts.map
}
declare module 'lib/dashboard/widget-editor/content-step/content-utils' {
	import type { FlatTableProps } from '@sage/xtrem-ui-components';
	import type { ResponsiveTypes } from 'lib/redux/state';
	import type { WidgetEditorStepProps } from 'lib/dashboard/widget-editor/widget-editor-utils';
	export interface ContentStepProps extends WidgetEditorStepProps {
	    browserIs: ResponsiveTypes;
	}
	export type ContentAction<FT extends FlatTableProps<any, any>, Changes> = {
	    type: 'ROW_ADDED';
	} | {
	    type: 'ROW_DRAGGED';
	    ids: Parameters<NonNullable<FT['onRowDrag']>>[0];
	} | {
	    type: 'CELL_CHANGED';
	    changes: Changes;
	    selectedProperties: ContentStepProps['widgetDefinition']['selectedProperties'];
	} | {
	    type: 'ROW_REMOVED';
	    row: Parameters<NonNullable<FT['onRowRemoved']>>[0];
	};
	//# sourceMappingURL=content-utils.d.ts.map
}
declare module 'lib/dashboard/widget-editor/content-step/indicator-tile-widget-content' {
	/// <reference types="lodash" />
	import * as React from 'react';
	import type { ContentStepProps } from 'lib/dashboard/widget-editor/content-step/content-utils';
	import { Aggregations } from '@sage/xtrem-shared';
	export const aggregationTranslations: (() => Record<Aggregations, string>) & import("lodash").MemoizedFunction;
	export function IndicatorWidgetContent({ browserIs, onWidgetDefinitionUpdated, widgetDefinition, nodeNames, }: {
	    browserIs: ContentStepProps['browserIs'];
	    onWidgetDefinitionUpdated: ContentStepProps['onWidgetDefinitionUpdated'];
	    widgetDefinition: ContentStepProps['widgetDefinition'];
	    nodeNames: ContentStepProps['nodeNames'];
	}): React.ReactElement;
	//# sourceMappingURL=indicator-tile-widget-content.d.ts.map
}
declare module 'lib/dashboard/widget-editor/content-step/chart-widget-content' {
	import { type Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ContentStepProps } from 'lib/dashboard/widget-editor/content-step/content-utils';
	export function ChartWidgetContent({ browserIs, onWidgetDefinitionUpdated, widgetDefinition, nodeNames, }: {
	    browserIs: ContentStepProps['browserIs'];
	    nodeNames: Dict<string>;
	    onWidgetDefinitionUpdated: ContentStepProps['onWidgetDefinitionUpdated'];
	    widgetDefinition: ContentStepProps['widgetDefinition'];
	}): React.ReactElement;
	//# sourceMappingURL=chart-widget-content.d.ts.map
}
declare module 'lib/dashboard/widget-editor/content-step/table-widget-content' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ContentStepProps } from 'lib/dashboard/widget-editor/content-step/content-utils';
	export function TableWidgetContent({ browserIs, onWidgetDefinitionUpdated, widgetDefinition, nodeNames, }: {
	    browserIs: ContentStepProps['browserIs'];
	    nodeNames: Dict<string>;
	    onWidgetDefinitionUpdated: ContentStepProps['onWidgetDefinitionUpdated'];
	    widgetDefinition: ContentStepProps['widgetDefinition'];
	}): React.ReactElement;
	//# sourceMappingURL=table-widget-content.d.ts.map
}
declare module 'lib/dashboard/widget-editor/content-step/index' {
	/// <reference types="@sage/xtrem-shared" />
	import * as React from 'react';
	import type { ContentStepProps } from 'lib/dashboard/widget-editor/content-step/content-utils';
	export function ContentStep({ browserIs, nodeNames, onWidgetDefinitionUpdated, stepIndex, widgetDefinition, }: ContentStepProps): React.ReactElement;
	export const ConnectedContentStep: import("react-redux").ConnectedComponent<typeof ContentStep, {
	    contextVariables?: import("../../dashboard-types").DashboardContextVariables | undefined;
	    group: string;
	    locale: string;
	    nodeNames: import("@sage/xtrem-shared/lib/util").Dict<string>;
	    onWidgetDefinitionUpdated: (newData: import("../../../redux/state").UserWidgetDefinition) => void;
	    stepIndex: number;
	    widgetDefinition: import("../../../redux/state").UserWidgetDefinition;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=index.d.ts.map
}
declare module 'lib/dashboard/widget-editor/filters-step' {
	import * as React from 'react';
	import type { WidgetEditorStepProps } from 'lib/dashboard/widget-editor/widget-editor-utils';
	export function FilterStep({ stepIndex, widgetDefinition, onWidgetDefinitionUpdated, locale, nodeNames, }: WidgetEditorStepProps): React.ReactElement;
	//# sourceMappingURL=filters-step.d.ts.map
}
declare module 'lib/dashboard/widget-editor/sorting-step' {
	import * as React from 'react';
	import type { WidgetEditorStepProps } from 'lib/dashboard/widget-editor/widget-editor-utils';
	import type { ResponsiveTypes } from 'lib/redux/state';
	import type { Dict } from '@sage/xtrem-shared';
	export interface SortingStepProps extends WidgetEditorStepProps {
	    browserIs: ResponsiveTypes;
	}
	export function SortingStep({ stepIndex, browserIs, widgetDefinition, onWidgetDefinitionUpdated, nodeNames, }: SortingStepProps): React.ReactElement | null;
	export const ConnectedSortingStep: import("react-redux").ConnectedComponent<typeof SortingStep, {
	    contextVariables?: import("../dashboard-types").DashboardContextVariables | undefined;
	    group: string;
	    locale: string;
	    nodeNames: Dict<string>;
	    onWidgetDefinitionUpdated: (newData: import("../../redux/state").UserWidgetDefinition) => void;
	    stepIndex: number;
	    widgetDefinition: import("../../redux/state").UserWidgetDefinition;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=sorting-step.d.ts.map
}
declare module 'lib/dashboard/widget-editor/indicator-tile-icons' {
	/// <reference types="lodash" />
	import type { Dict } from '@sage/xtrem-shared';
	export const indicatorTileIcons: (() => Dict<string>) & import("lodash").MemoizedFunction;
	export const indicatorTileIconsSortedArray: (() => Array<{
	    value: string;
	    label: string;
	}>) & import("lodash").MemoizedFunction;
	//# sourceMappingURL=indicator-tile-icons.d.ts.map
}
declare module 'lib/dashboard/widget-editor/widget-action-configuration' {
	import type { UserWidgetDefinition, UserWidgetDefinitionAction } from 'lib/redux/state';
	import * as React from 'react';
	import type { PickKeys } from 'ts-essentials';
	export interface WidgetActionConfigurationProps {
	    actionKey: PickKeys<Required<UserWidgetDefinition>, UserWidgetDefinitionAction>;
	    actionName: string;
	    helperText: string;
	    onWidgetDefinitionUpdated: (newData: UserWidgetDefinition) => void;
	    widgetDefinition: UserWidgetDefinition;
	}
	export function WidgetActionConfiguration({ actionKey, actionName, helperText, onWidgetDefinitionUpdated, widgetDefinition, }: WidgetActionConfigurationProps): React.ReactElement;
	//# sourceMappingURL=widget-action-configuration.d.ts.map
}
declare module 'lib/dashboard/widget-editor/layout-step' {
	import * as React from 'react';
	import type { WidgetEditorStepProps } from 'lib/dashboard/widget-editor/widget-editor-utils';
	export function LayoutStep({ contextVariables, group, onWidgetDefinitionUpdated, stepIndex, widgetDefinition, }: WidgetEditorStepProps): React.ReactElement;
	//# sourceMappingURL=layout-step.d.ts.map
}
declare module 'lib/dashboard/widget-editor/widget-editor-dialog' {
	import * as React from 'react';
	import type { Dict, Locale } from '@sage/xtrem-shared';
	import type { UserWidgetDefinition } from 'lib/redux/state';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export interface WidgetEditorDialogExternalProps {
	    group: string;
	    contextVariables?: DashboardContextVariables;
	}
	export interface WidgetEditorDialogProps extends WidgetEditorDialogExternalProps {
	    isDirty: boolean;
	    isNewWidget: boolean;
	    isOpen: boolean;
	    locale: Locale;
	    nodeNames: Dict<string>;
	    onClose: () => void;
	    onFinish: () => void;
	    onUpdateWidgetSettings: (widgetDefinition: UserWidgetDefinition) => void;
	    onWidgetDefinitionUpdated: (widgetDefinition: UserWidgetDefinition) => void;
	    widgetDefinition: UserWidgetDefinition;
	}
	export function WidgetEditorDialog({ contextVariables, group, isDirty, isNewWidget, isOpen, locale, nodeNames, onClose, onFinish, onWidgetDefinitionUpdated, widgetDefinition, }: WidgetEditorDialogProps): React.ReactElement;
	export const ConnectedWidgetEditorDialog: import("react-redux").ConnectedComponent<typeof WidgetEditorDialog, {
	    group: string;
	    contextVariables?: DashboardContextVariables | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=widget-editor-dialog.d.ts.map
}
declare module 'lib/dashboard/widget-editor/async-widget-editor-dialog' {
	import * as React from 'react';
	import type { WidgetEditorDialogExternalProps } from 'lib/dashboard/widget-editor/widget-editor-dialog';
	export function AsyncConnectedWidgetEditorDialog(props: WidgetEditorDialogExternalProps): React.ReactElement;
	//# sourceMappingURL=async-widget-editor-dialog.d.ts.map
}
declare module 'lib/dashboard/dashboard-editor-dialog' {
	import * as React from 'react';
	import type { Dashboard, Dict, Locale } from '@sage/xtrem-shared';
	import type { WidgetDefinition } from 'lib/dashboard/widgets/abstract-widget';
	import type { WidgetPosition } from 'lib/redux/actions/dashboard-editor-actions';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export interface DashboardEditorDialogExternalProps {
	    contextVariables?: DashboardContextVariables;
	    group: string;
	}
	export interface DashboardEditorDialogProps extends DashboardEditorDialogExternalProps {
	    canEditDashboards: boolean;
	    currentDashboardDefinition: Dashboard;
	    dashboardDefinition: Dashboard;
	    isDirty: boolean;
	    isNavigationPanelOpened: boolean;
	    isOpen?: boolean;
	    isRedoDisabled: boolean;
	    isUndoDisabled: boolean;
	    loadingDashboards: boolean;
	    locale: Locale;
	    onClose: () => void;
	    redoDashboardEditor: () => void;
	    removeDashboardEditorWidget: (widgetId: string) => void;
	    saveDashboardEditorState: () => Promise<void>;
	    setNavigationPanelIsOpened: (newState: boolean) => void;
	    undoDashboardEditor: () => void;
	    updateDashboardEditorWidgetPositions: (widgets: WidgetPosition[]) => void;
	    updateDashboardTitleInEditor: (newTitle: string) => void;
	    widgets: Dict<WidgetDefinition>;
	}
	export function DashboardEditorDialog({ canEditDashboards, contextVariables, currentDashboardDefinition, dashboardDefinition, group, isDirty, isNavigationPanelOpened, isOpen, isRedoDisabled, isUndoDisabled, loadingDashboards, locale, onClose, redoDashboardEditor, removeDashboardEditorWidget, saveDashboardEditorState, setNavigationPanelIsOpened, undoDashboardEditor, updateDashboardEditorWidgetPositions, updateDashboardTitleInEditor, widgets, }: DashboardEditorDialogProps): React.ReactElement;
	export const ConnectedDashboardEditorDialog: import("react-redux").ConnectedComponent<typeof DashboardEditorDialog, {
	    contextVariables?: DashboardContextVariables | undefined;
	    group: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=dashboard-editor-dialog.d.ts.map
}
declare module 'lib/dashboard/dashboard-create-dialog' {
	import type { DialogSizes } from 'carbon-react/esm/components/dialog';
	import * as React from 'react';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export interface DashboardCreateDialogExternalProps {
	    group: string;
	    isOpen: boolean;
	    contextVariables?: DashboardContextVariables;
	    onClose: () => void;
	    onNextClicked: (success: boolean) => void;
	}
	export interface DashboardCreateDialogProps extends DashboardCreateDialogExternalProps {
	    cloneDashboard: (dashboardId: string) => Promise<void>;
	    createDashboard: () => Promise<void>;
	    dialogSize: DialogSizes;
	}
	export function DashboardCreateDialog({ cloneDashboard, createDashboard, dialogSize, group, isOpen, onClose, onNextClicked, }: DashboardCreateDialogProps): React.ReactElement;
	export const ConnectedDashboardCreateDialog: import("react-redux").ConnectedComponent<typeof DashboardCreateDialog, {
	    group: string;
	    isOpen: boolean;
	    contextVariables?: DashboardContextVariables | undefined;
	    onClose: () => void;
	    onNextClicked: (success: boolean) => void;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=dashboard-create-dialog.d.ts.map
}
declare module 'lib/dashboard/dashboard-component' {
	import * as React from 'react';
	import type { Dashboard, Dict, Locale } from '@sage/xtrem-shared';
	import type { WidgetDefinition } from 'lib/dashboard/widgets/abstract-widget';
	import type { DashboardContextVariables } from 'lib/dashboard/dashboard-types';
	export interface DashboardComponentExternalProps {
	    group: string;
	    dashboardContextVariables?: DashboardContextVariables;
	}
	export interface DashboardComponentProps extends DashboardComponentExternalProps {
	    canEditDashboards: boolean;
	    cloneDashboard: (dashboardId: string) => Promise<void>;
	    dashboardDefinition?: Dashboard;
	    deleteDashboard: (dashboardId: string) => Promise<void>;
	    fetchUserDashboardDefinition: () => void;
	    globalLoading: boolean;
	    hasInstalledPackagesLoaded: boolean;
	    loadingDashboards: boolean;
	    locale: Locale;
	    openDashboardEditorDialog: () => void;
	    refreshCurrentDashboard: () => void;
	    widgets: Dict<WidgetDefinition>;
	}
	type DIALOG_MODE_OBJ = {
	    CREATE_DASHBOARD: 'CREATE_DASHBOARD';
	    EDIT_DASHBOARD: 'EDIT_DASHBOARD';
	    NONE: 'NONE';
	};
	export type DIALOG_MODE = DIALOG_MODE_OBJ[keyof DIALOG_MODE_OBJ];
	export interface DashboardComponentState {
	    dialogMode: DIALOG_MODE;
	    startedFetching: boolean;
	    verticalSpaceReady: boolean;
	}
	export class DashboardComponent extends React.Component<DashboardComponentProps, DashboardComponentState> {
	    constructor(props: DashboardComponentProps);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: DashboardComponentProps): void;
	    private readonly fetchDashboards;
	    private readonly onCreateDialogOpen;
	    private readonly onCreateDialogClose;
	    private readonly onDeleteDashboard;
	    private readonly onDuplicateDashboard;
	    private readonly renderNoDashboards;
	    private readonly renderEmptyDashboard;
	    private readonly renderKebabMenu;
	    private readonly getWidgets;
	    private readonly renderDashboard;
	    render(): React.ReactNode;
	}
	export const ConnectedDashboardComponent: import("react-redux").ConnectedComponent<typeof DashboardComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DashboardComponent> | undefined;
	    group: string;
	    dashboardContextVariables?: DashboardContextVariables | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=dashboard-component.d.ts.map
}
declare module 'lib/component/container/page/page-360-view' {
	import * as React from 'react';
	export interface Page360ViewProps {
	    screenId: string;
	}
	export function Page360View({ screenId }: Page360ViewProps): React.ReactElement | null;
	//# sourceMappingURL=page-360-view.d.ts.map
}
declare module 'lib/component/container/page/page-component' {
	import * as React from 'react';
	import type { PageDefinition } from 'lib/service/page-definition';
	import { ContextType } from 'lib/types';
	import type { PageComponentProps } from 'lib/component/container/page/page-types'; class PageComponent extends React.Component<PageComponentProps> {
	    private readonly pageBodyRef;
	    private shortcutSubscriptions;
	    constructor(props: PageComponentProps);
	    componentDidMount(): void;
	    componentDidCatch(error: Error): void;
	    componentWillUnmount(): void;
	    getActiveSectionId: () => string | undefined;
	    getVisibleSections: () => HTMLDivElement[];
	    getActiveSectionIndex(): number;
	    onBodyScroll: () => void;
	    onFileDrop: (files: FileList) => Promise<void>;
	    getPageClassName(): string;
	    getPendoPageMode(): string;
	    hasPageFooter: () => boolean;
	    renderDetailPanel(): React.ReactNode;
	    renderSections(availableColumns: number): React.ReactNode;
	    render(): React.ReactNode;
	} const _default: import("react-redux").ConnectedComponent<typeof PageComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<PageComponent> | undefined;
	    availableColumns: number;
	    pageDefinition: PageDefinition;
	    contextType: ContextType;
	    selectedSection?: string | null | undefined;
	    noHeader?: boolean | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=page-component.d.ts.map
}
declare module 'lib/component/ui/screen-component' {
	import * as React from 'react';
	export interface ScreenComponentProps {
	    screenPath: string;
	    queryParameters: any;
	    values?: any;
	    onFinish?: (values: any) => void;
	}
	/**
	 * This component allows us to enable a page to somewhere in the application
	 */
	export const ScreenComponent: React.MemoExoticComponent<({ screenPath, queryParameters, values, onFinish }: ScreenComponentProps) => React.ReactElement>;
	//# sourceMappingURL=screen-component.d.ts.map
}
declare module 'lib/component/field/workflow/add-workflow-node-dialog' {
	import * as React from 'react';
	export interface AddWorkflowNodeDialogProps {
	    previousNodeId?: string;
	    screenId: string;
	    elementId: string;
	    isOpen: boolean;
	    onClose: () => void;
	    onConfirm: (result: {
	        selectedNodeType: string;
	        values: any;
	    }) => void;
	    filterType?: string[];
	}
	export function AddWorkflowNodeDialog({ isOpen, onClose, onConfirm, previousNodeId, screenId, elementId, filterType, }: AddWorkflowNodeDialogProps): React.ReactElement;
	//# sourceMappingURL=add-workflow-node-dialog.d.ts.map
}
declare module 'lib/redux/actions/workflow-nodes-actions' {
	import type { WorkflowNode } from '@sage/xtrem-shared';
	import * as xtremRedux from 'lib/redux';
	export const loadWorkflowNodes: () => (dispatch: xtremRedux.AppThunkDispatch, getState: () => xtremRedux.XtremAppState) => Promise<void>;
	export const setWorkflowNodes: (workflowNodes: WorkflowNode[]) => xtremRedux.AppAction;
	//# sourceMappingURL=workflow-nodes-actions.d.ts.map
}
declare module 'lib/component/field/workflow/custom-edge' {
	import React from 'react';
	import type { EdgeProps } from 'reactflow';
	export function CustomEdge({ id, sourceX, sourceY, targetX, targetY, sourcePosition, targetPosition, sourceHandleId, data, markerEnd, style, }: EdgeProps<{
	    screenId: string;
	    elementId: string;
	}>): React.ReactElement;
	//# sourceMappingURL=custom-edge.d.ts.map
}
declare module 'lib/component/field/workflow/workflow-component' {
	import * as React from 'react';
	import type { WorkflowComponentProperties } from 'lib/component/field/workflow/workflow-types';
	export function WorkflowComponent(props: WorkflowComponentProperties): React.ReactElement;
	export function WorkflowInnerComponent(props: WorkflowComponentProperties): React.ReactElement;
	export const ConnectedFormDesignerComponent: import("react-redux").ConnectedComponent<typeof WorkflowComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedFormDesignerComponent;
	//# sourceMappingURL=workflow-component.d.ts.map
}
declare module 'lib/component/field/workflow/async-workflow-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { WorkflowComponentProperties } from 'lib/component/field/workflow/workflow-types';
	export function AsyncConnectedWorkflowComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncFormDesignerComponent(props: WorkflowComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-workflow-component.d.ts.map
}
declare module 'lib/component/field/content-table/content-table-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { DefaultPropertyType, TableContentWithGroupsProps } from '@sage/xtrem-ui-components';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent, HasPlaceholder, Sizable } from 'lib/component/field/traits';
	export interface ContentTableProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType>, HasPlaceholder, Sizable {
	    /** The GraphQL node that the field suggestions will be fetched from */
	    node: string;
	    selectedProperties?: Dict<DefaultPropertyType>;
	}
	export interface ContentTableDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<ContentTableProperties<CT>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, Sizable {
	}
	export type ContentTableExtensionDecoratorProperties<CT extends ScreenExtension<CT>> = ChangeableOverrideDecoratorProperties<ContentTableDecoratorProperties<Extend<CT>>, CT>;
	export type ContentTableComponentProps<T extends ClientNode = any> = BaseEditableComponentProperties<ContentTableProperties<any, T>, ContentTableFieldValue>;
	export type ContentTableFieldValue = TableContentWithGroupsProps['value'];
	//# sourceMappingURL=content-table-types.d.ts.map
}
declare module 'lib/component/field/content-table/content-table-component' {
	import * as React from 'react';
	import type { ContentTableComponentProps } from 'lib/component/field/content-table/content-table-types';
	export const changeEventHandler: (screenId: string, elementId: string) => () => Promise<void>;
	export function ContentTableComponent(props: ContentTableComponentProps): React.ReactElement;
	export const ConnectedContentTableComponent: import("react-redux").ConnectedComponent<typeof ContentTableComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedContentTableComponent;
	//# sourceMappingURL=content-table-component.d.ts.map
}
declare module 'lib/component/field/content-table/async-content-table-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ContentTableComponentProps } from 'lib/component/field/content-table/content-table-types';
	export function AsyncConnectedContentTableComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncContentTableComponent(props: ContentTableComponentProps): React.ReactElement;
	//# sourceMappingURL=async-content-table-component.d.ts.map
}
declare module 'lib/component/field/multi-file-deposit/multi-file-deposit-component' {
	import * as React from 'react';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { MultiFileDepositComponentAdditionalProperties, MultiFileDepositComponentProperties, MultiFileDepositDecoratorProperties, WithCancelToken } from 'lib/component/field/multi-file-deposit/multi-file-deposit-types';
	import type { AttachmentAssociation } from 'lib/component/types';
	import { ContextType } from 'lib/types';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	interface MultiFileDepositComponentState {
	    hasValue: boolean;
	    isFileInputVisible: boolean;
	}
	export class MultiFileDepositComponent extends EditableFieldBaseComponent<MultiFileDepositDecoratorProperties<any>, CollectionValue<WithCancelToken<AttachmentAssociation>>, MultiFileDepositComponentAdditionalProperties, MultiFileDepositComponentState> {
	    private changeSubscription;
	    constructor(props: MultiFileDepositComponentProperties);
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    onChange: (fileList: FileList) => void;
	    cancelFileUploading: (recordId: string) => void;
	    displayCancelUploadDialog(recordId: string): Promise<void>;
	    displayRemoveFileDialog(recordId: string): Promise<void>;
	    toggleDropzone: () => void;
	    renderUploadedFilesTable: () => React.ReactElement | null;
	    render(): React.ReactElement;
	}
	export const ConnectedMultiFileDepositComponent: import("react-redux").ConnectedComponent<typeof MultiFileDepositComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<MultiFileDepositComponent> | undefined;
	    contextNode?: import("../../../types").NodePropertyType | undefined;
	    recordContext?: any;
	    columnDefinition?: any;
	    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedMultiFileDepositComponent;
	//# sourceMappingURL=multi-file-deposit-component.d.ts.map
}
declare module 'lib/component/field/multi-file-deposit/async-multi-file-deposit-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { MultiFileDepositComponentProperties } from 'lib/component/field/multi-file-deposit/multi-file-deposit-types';
	export function AsyncConnectedMultiFileDepositComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncMultiFileDepositComponent(props: MultiFileDepositComponentProperties): React.ReactElement;
	//# sourceMappingURL=async-multi-file-deposit-component.d.ts.map
}
declare module 'lib/component/field/time/time-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedValidatable, Sizable, Validatable } from 'lib/component/field/traits';
	export interface TimeProperties<CT extends ScreenExtension<CT> = ScreenBase, NodeType = any> extends EditableFieldProperties<CT, NodeType>, Sizable {
	}
	export interface TimeDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<TimeProperties<CT, ReferencedItemType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, Sizable, Validatable<CT, string> {
	}
	export interface NestedTimeProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<TimeProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, Nested<ContextNodeType>, Sizable, NestedValidatable<CT, string, ContextNodeType> {
	}
	export type TimeExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> = ChangeableOverrideDecoratorProperties<TimeDecoratorProperties<Extend<CT>, ReferencedItemType>, CT>;
	export type TimeComponentProps<T extends ClientNode = any> = BaseEditableComponentProperties<TimeProperties<any, T>, string> & {
	    onChange?: (value: string) => void;
	};
	//# sourceMappingURL=time-types.d.ts.map
}
declare module 'lib/component/ui/time/time-types' {
	import type { Ref } from 'react';
	import type { TimeComponentState } from 'lib/component/ui/time/use-time';
	export interface TimeComponentProps {
	    screenId: string;
	    elementId: string;
	    dataTestId: string;
	    fieldId: string;
	    hasAmPmToggle: boolean;
	    hoursRef: Ref<HTMLInputElement>;
	    isDisabled?: boolean;
	    isFullWidth?: boolean;
	    isReadOnly?: boolean;
	    isValid?: boolean;
	    localize: (key: string, defaultMessage: string) => string;
	    maxHours: number;
	    minHours: number;
	    minutesRef: Ref<HTMLInputElement>;
	    onClick?: () => void;
	    onHoursBlur: NonNullable<React.ComponentProps<'input'>['onBlur']>;
	    onHoursChange: NonNullable<React.ComponentProps<'input'>['onChange']>;
	    onKeyDown: NonNullable<React.ComponentProps<'input'>['onKeyDown']>;
	    onMinutesBlur: NonNullable<React.ComponentProps<'input'>['onBlur']>;
	    onMinutesChange: NonNullable<React.ComponentProps<'input'>['onChange']>;
	    onToggleChange?: (ev: React.MouseEvent<HTMLButtonElement, MouseEvent>, value?: string | undefined, name?: string | undefined) => void;
	    state: TimeComponentState;
	}
	export type ToggleState = 'AM' | 'PM' | null;
	//# sourceMappingURL=time-types.d.ts.map
}
declare module 'lib/component/ui/time/time-utils' {
	import type { TimeComponentState } from 'lib/component/ui/time/use-time';
	export const TIME_REGEX: RegExp;
	export function formatString(value: string): string;
	export function validateHours({ hours, toggle, hasAmPmToggle, }: {
	    hours: TimeComponentState['hoursString'];
	    toggle: TimeComponentState['toggle'] | 'unknown';
	    hasAmPmToggle: boolean;
	}): {
	    isValid: true;
	    hours: TimeComponentState['hours'];
	    hoursString: TimeComponentState['hoursString'];
	} | {
	    isValid: false;
	    hoursString: TimeComponentState['hoursString'];
	};
	export function validateMinutes(minutes: TimeComponentState['minutesString']): {
	    isValid: true;
	    minutes: TimeComponentState['minutes'];
	    minutesString: TimeComponentState['minutesString'];
	} | {
	    isValid: false;
	    minutesString: TimeComponentState['minutesString'];
	};
	export function validateSeconds(seconds: string): {
	    isValid: true;
	    seconds: TimeComponentState['seconds'];
	} | {
	    isValid: false;
	};
	export function getValueFromString({ time, hasAmPmToggle }: {
	    time?: string | null;
	    hasAmPmToggle: boolean;
	}): {
	    hours: number;
	    hoursString: string;
	    minutes: number;
	    minutesString: string;
	    seconds: number;
	    toggle: TimeComponentState['toggle'];
	    value: string | null;
	};
	//# sourceMappingURL=time-utils.d.ts.map
}
declare module 'lib/component/ui/time/use-time' {
	import type { I18nProviderProps } from 'carbon-react/esm/components/i18n-provider';
	import React from 'react';
	import type { TimeComponentProps } from 'lib/component/field/time/time-types';
	import type { ToggleState } from 'lib/component/ui/time/time-types';
	export type TimeComponentState = {
	    hours: number;
	    hoursString: string;
	    minutesString: string;
	    minutes: number;
	    seconds: number;
	    toggle: ToggleState;
	    value: string | null;
	};
	export type TimeComponentAction = {
	    type: 'CHANGE_HOURS';
	    hours: TimeComponentState['hoursString'];
	} | {
	    type: 'CHANGE_MINUTES';
	    minutes: TimeComponentState['minutesString'];
	} | {
	    type: 'CHANGE_VALUE';
	    value?: string;
	} | {
	    type: 'CHANGE_HAS_AM_PM_TOGGLE';
	    hasAmPmToggle: boolean;
	} | {
	    type: 'BLUR_HOURS';
	} | {
	    type: 'BLUR_MINUTES';
	} | {
	    type: 'BLUR_FIELD';
	} | {
	    type: 'TOGGLE_CHANGE';
	    toggle: TimeComponentState['toggle'];
	};
	type UseTimeHook = {
	    componentRef: React.RefObject<HTMLDivElement>;
	    dataTestId: string;
	    dispatch: React.Dispatch<TimeComponentAction>;
	    hasAmPmToggle: boolean;
	    hoursRef: React.RefObject<HTMLInputElement>;
	    maxHours: number;
	    minHours: number;
	    minutesRef: React.RefObject<HTMLInputElement>;
	    onHoursBlur: NonNullable<React.ComponentProps<'input'>['onBlur']>;
	    onHoursChange: NonNullable<React.ComponentProps<'input'>['onChange']>;
	    onBlurField: () => void;
	    onKeyDown: NonNullable<React.ComponentProps<'input'>['onKeyDown']>;
	    onMinutesBlur: NonNullable<React.ComponentProps<'input'>['onBlur']>;
	    onMinutesChange: NonNullable<React.ComponentProps<'input'>['onChange']>;
	    providerLocale?: I18nProviderProps['locale'];
	    state: TimeComponentState;
	    toggleChange: (toggle: 'AM' | 'PM') => void;
	};
	type UseTimeProps = Pick<TimeComponentProps, 'locale' | 'isInFocus' | 'elementId' | 'value'> & {
	    onChange?: (v: string | null) => void;
	};
	export function useTime({ locale, isInFocus, elementId, value, onChange }: UseTimeProps): UseTimeHook;
	export {};
	//# sourceMappingURL=use-time.d.ts.map
}
declare module 'lib/component/ui/time/time-component' {
	import React from 'react';
	import type { TimeComponentProps } from 'lib/component/ui/time/time-types';
	export const TimeComponent: React.FC<TimeComponentProps>;
	//# sourceMappingURL=time-component.d.ts.map
}
declare module 'lib/component/field/time/time-component' {
	import React from 'react';
	import type { TimeComponentProps } from 'lib/component/field/time/time-types';
	export function TimeComponent({ locale, isInFocus, elementId, screenId, fieldProperties, validationErrors, value, isParentDisabled, isParentHidden, setFieldValue, validate, contextType, ...rest }: TimeComponentProps): React.ReactElement;
	export const ConnectedTimeComponent: import("react-redux").ConnectedComponent<typeof TimeComponent, {
	    bind?: any;
	    onChange?: ((value: string) => void) | undefined;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedTimeComponent;
	//# sourceMappingURL=time-component.d.ts.map
}
declare module 'lib/component/field/time/async-time-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { TimeComponentProps } from 'lib/component/field/time/time-types';
	export function AsyncConnectedTimeComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncTimeComponent(props: TimeComponentProps): React.ReactElement;
	//# sourceMappingURL=async-time-component.d.ts.map
}
declare module 'lib/component/field/datetime-range/datetime-range-types' {
	/// <reference types="react" />
	import type { CalendarDate } from '@internationalized/date';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Datetime } from '@sage/xtrem-date-time';
	import type { LocalizeLocale } from '@sage/xtrem-shared';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseEditableComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedValidatable, Sizable, Validatable } from 'lib/component/field/traits';
	export interface DatetimeRangeProperties<CT extends ScreenExtension<CT> = ScreenBase, NodeType = any> extends EditableFieldProperties<CT, NodeType>, Sizable {
	    isTimeZoneHidden?: boolean;
	    timeZone?: string;
	    minDate?: Date;
	    maxDate?: Date;
	    defaultDate?: Date | Datetime | string;
	}
	export interface DatetimeRangeDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<DatetimeRangeProperties<CT, ReferencedItemType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, Sizable, Validatable<CT, string> {
	}
	export interface NestedDatetimeRangeProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<DatetimeRangeProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, Nested<ContextNodeType>, Sizable, NestedValidatable<CT, string, ContextNodeType> {
	}
	export type DatetimeRangeExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> = ChangeableOverrideDecoratorProperties<DatetimeRangeDecoratorProperties<Extend<CT>, ReferencedItemType>, CT>;
	export interface CurrentDatesState {
	    start: Datetime | null;
	    end: Datetime | null;
	}
	export interface DatetimeRangeValue extends Required<Pick<CurrentDatesState, 'start' | 'end'>> {
	}
	export interface DatetimeRangeComponentProps<T extends ClientNode = any> extends BaseEditableComponentProperties<DatetimeRangeDecoratorProperties<any, T>, DatetimeRangeValue> {
	}
	export interface DatetimeComponentProps {
	    'aria-label': string;
	    screenId: string;
	    elementId: string;
	    date: CalendarDate | null;
	    fieldId: string;
	    inputRef?: React.RefObject<HTMLInputElement>;
	    isDisabled?: boolean;
	    isPopoverOpen: boolean;
	    isReadOnly?: boolean;
	    isTimeZoneHidden?: boolean;
	    locale: LocalizeLocale;
	    maxDate?: Datetime;
	    minDate?: Datetime;
	    onDateChange: (date: CalendarDate | null) => void;
	    onPopperOpenChange: (isOpen: boolean, inputName: 'start' | 'end') => void;
	    onTimeChange: (string: string | null) => void;
	    rangeStartDate: CalendarDate | null;
	    time: string | null;
	    timeZone?: string;
	    title: string;
	    type: 'start' | 'end';
	    validationError?: string;
	}
	//# sourceMappingURL=datetime-range-types.d.ts.map
}
declare module 'lib/component/field/datetime-range/datetime-range-utils' {
	import { CalendarDate } from '@internationalized/date';
	import { Datetime, type Time } from '@sage/xtrem-date-time';
	import { type LocalizeLocale } from '@sage/xtrem-shared';
	export function calendarDateToDatetime(calendarDate: CalendarDate, timeZone?: string): Datetime;
	export function datetimeToCalendarDate(datetime: Datetime, timeZone: string): CalendarDate;
	export function datetimeToTime(datetime: Datetime, timeZone: string): string;
	export function toDatetime(input: Datetime | Date | string, timeZone: string, locale?: LocalizeLocale): Datetime;
	export const formatDatetime: (date: Datetime | null | undefined, locale?: LocalizeLocale) => string;
	export const isDateInRange: (date: Datetime, startDate: Datetime, endDate: Datetime) => boolean;
	export function isValidTimeZone(timeZone: string): boolean;
	export const makeDatetime: (date: CalendarDate, time: Time, timeZone?: string) => Datetime;
	//# sourceMappingURL=datetime-range-utils.d.ts.map
}
declare module 'lib/component/field/datetime-range/use-datetime-range' {
	import type { CalendarDate } from '@internationalized/date';
	import type { Datetime } from '@sage/xtrem-date-time';
	import type { LocalizeLocale } from '@sage/xtrem-shared';
	import type { CurrentDatesState, DatetimeRangeValue } from 'lib/component/field/datetime-range/datetime-range-types';
	export interface DatetimeRangeComponentState {
	    value: CurrentDatesState;
	    endDate: CalendarDate | null;
	    validationError: boolean;
	    endTime: string | null;
	    startDate: CalendarDate | null;
	    startTime: string | null;
	    timeZone: string;
	    isDirty: boolean;
	    openInputPopover: 'start' | 'end' | null;
	}
	export type Action = {
	    type: 'SET_START_DATE';
	    date: DatetimeRangeComponentState['startDate'];
	} | {
	    type: 'SET_END_DATE';
	    date: DatetimeRangeComponentState['endDate'];
	} | {
	    type: 'SET_START_TIME';
	    time: DatetimeRangeComponentState['startTime'];
	} | {
	    type: 'SET_END_TIME';
	    time: DatetimeRangeComponentState['endTime'];
	} | {
	    type: 'SET_OPEN_POPOVER_ON_INPUT';
	    inputName: 'start' | 'end';
	    isOpen: boolean;
	} | {
	    type: 'RESET';
	    value?: DatetimeRangeValue | null;
	    timeZone: string;
	};
	export interface UseDatetimeRangeProps {
	    value?: DatetimeRangeValue | null;
	    fieldProperties: any;
	    locale: LocalizeLocale;
	    setFieldValue: any;
	    validate: any;
	    elementId: string;
	    screenId: string;
	    onChange: (value: DatetimeRangeValue | null) => void;
	}
	export interface UseDatetimeRangeResult {
	    currentDates: CurrentDatesState;
	    endDate: CalendarDate | null;
	    validationError: boolean;
	    endTime: string | null;
	    handleEndDateChange: (date: CalendarDate) => void;
	    handleEndTimeChange: (time: string) => void;
	    handlePopoverOpenChange: (isOpen: boolean, inputName: 'start' | 'end') => void;
	    handleStartDateChange: (date: CalendarDate) => void;
	    handleStartTimeChange: (time: string) => void;
	    isDirty: boolean;
	    maxDateValue: Datetime;
	    minDateValue: Datetime;
	    openInputPopover: 'start' | 'end' | null;
	    startDate: CalendarDate | null;
	    startTime: string | null;
	    timeZone: string;
	}
	export function useDatetimeRange({ fieldProperties, locale, value }: UseDatetimeRangeProps): UseDatetimeRangeResult;
	//# sourceMappingURL=use-datetime-range.d.ts.map
}
declare module 'lib/component/field/datetime-range/month-year-header-component' {
	/// <reference types="react" />
	export function MonthYearHeaderComponent(): JSX.Element;
	//# sourceMappingURL=month-year-header-component.d.ts.map
}
declare module 'lib/component/field/datetime-range/calendar-cell-component' {
	/// <reference types="react" />
	import type { CalendarDate } from '@internationalized/date';
	export function CalendarCellComponent({ day, rangeStartCalendarDate, selectedDate, timeZone, }: {
	    day: CalendarDate;
	    rangeStartCalendarDate?: CalendarDate | null;
	    selectedDate?: CalendarDate;
	    timeZone: string;
	}): JSX.Element;
	//# sourceMappingURL=calendar-cell-component.d.ts.map
}
declare module 'lib/component/field/datetime-range/datetime-input-component' {
	/// <reference types="react" />
	import type { DatetimeComponentProps } from 'lib/component/field/datetime-range/datetime-range-types';
	export function DatetimeInputComponent({ 'aria-label': ariaLabel, screenId, elementId, date, fieldId, inputRef, isDisabled, isPopoverOpen, isReadOnly, isTimeZoneHidden, locale, maxDate, minDate, onDateChange, onPopperOpenChange, onTimeChange, rangeStartDate, time, timeZone, title, type, validationError, }: DatetimeComponentProps): JSX.Element;
	//# sourceMappingURL=datetime-input-component.d.ts.map
}
declare module 'lib/component/field/datetime-range/datetime-range-component' {
	import React from 'react';
	import type { DatetimeRangeComponentProps } from 'lib/component/field/datetime-range/datetime-range-types';
	export function DatetimeRangeComponent({ locale, elementId, screenId, setFieldValue, validate, isInFocus, fieldProperties, isParentDisabled, isParentHidden, contextType, validationErrors, value, ...rest }: DatetimeRangeComponentProps): JSX.Element;
	export const ConnectedDatetimeRangeComponent: import("react-redux").ConnectedComponent<typeof DatetimeRangeComponent, {
	    bind?: any;
	    screenId: string;
	    elementId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDatetimeRangeComponent;
	//# sourceMappingURL=datetime-range-component.d.ts.map
}
declare module 'lib/component/field/datetime-range/async-datetime-range-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { DatetimeRangeComponentProps } from 'lib/component/field/datetime-range/datetime-range-types';
	export function AsyncConnectedDatetimeRangeComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncDatetimeRangeComponent(props: DatetimeRangeComponentProps): React.ReactElement;
	//# sourceMappingURL=async-datetime-range-component.d.ts.map
}
declare module 'lib/render/field-wrapper' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { AccessStatus } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { BaseControlObject } from 'lib/component/base-control-object';
	import type { FieldWrapperExternalProps } from 'lib/component/field/field-base-component-types';
	import type { ResponsiveTypes } from 'lib/redux/state';
	export interface FieldWrapperProps extends FieldWrapperExternalProps {
	    fieldController: BaseControlObject<any, any>;
	    browserIs?: ResponsiveTypes;
	    isHidden?: boolean;
	    accessRule?: AccessStatus;
	    onFocus: (screenId: string, elementId: string, row: string, nestedField: string) => void;
	    fixedHeight?: number;
	}
	/**
	 * Main field type router. Depending on the field type, it renders the corresponding component to the DOM
	 */
	export class FieldWrapper extends React.Component<FieldWrapperProps> {
	    /** A field is hidden if it is hidden by its `isHidden` decorator property or if the field is unavailable for
	     * the current user based on the access rights computation.
	     **/
	    private readonly isHidden;
	    private readonly renderField;
	    render(): React.ReactNode;
	} const _default: import("react-redux").ConnectedComponent<typeof FieldWrapper, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<FieldWrapper> | undefined;
	    item?: import("..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default _default;
	//# sourceMappingURL=field-wrapper.d.ts.map
}
declare module 'lib/service/sticker' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { StickerControlObject } from 'lib/component/control-objects';
	import { DeveloperApi, ScreenBase } from 'lib/service/screen-base';
	export class StickerDeveloperApi<TGraphqlApi> extends DeveloperApi<TGraphqlApi> {
	    constructor(sticker: Sticker);
	    /** This sticker */
	    get sticker(): StickerControlObject;
	    finish(): void;
	}
	export abstract class Sticker<TGraphqlApi = any> extends ScreenBase<TGraphqlApi> {
	    readonly $: StickerDeveloperApi<TGraphqlApi>;
	    constructor();
	}
	//# sourceMappingURL=sticker.d.ts.map
}
declare module 'lib/service/sticker-definition' {
	import type { Constructible } from 'lib/types';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { Sticker } from 'lib/service/sticker';
	export interface StickerDefinition extends ScreenBaseDefinition {
	    sticker: Sticker;
	}
	export const getStickerDefinition: (stickerConstructor: Constructible<Sticker>) => StickerDefinition;
	//# sourceMappingURL=sticker-definition.d.ts.map
}
declare module 'lib/component/field/table/table-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { TableDecoratorProperties } from 'lib/component/decorator-properties';
	import type { GridNestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldKey, PartialCollectionValueWithIds } from 'lib/component/types';
	import { CollectionValueControlObject } from 'lib/component/field/collection-value-field';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
	 */
	export class TableControlObject<NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.Table, NestedRecordType, CT, GridNestedFieldTypes, InternalTableProperties<CT, NestedRecordType>> {
	    static readonly defaultUiProperties: Partial<TableDecoratorProperties>;
	    /** Whether user can hide columns or not  */
	    get canUserHideColumns(): boolean;
	    /** Whether user can hide columns or not  */
	    set canUserHideColumns(newValue: boolean);
	    /** Whether all table columns can be resized or not */
	    canResizeColumns?: boolean;
	    /** Whether the rows of this table can be filtered or not */
	    canFilter?: boolean;
	    /** Whether the "phantom row" will be displayed or not */
	    isPhantomRowDisabled?: boolean;
	    /** Whether the rows of this table can be filtered or not */
	    isReadOnly?: boolean;
	    hideColumn(columnBind: string): void;
	    showColumn(columnBind: string): void;
	    /** Return records that the user just added to this table and not yet known by the server. */
	    getNewRecords(): PartialCollectionValueWithIds<NestedRecordType>[];
	    get node(): string;
	    /** Redraws the current table view, this function can be useful when values are updated that are used in property callbacks. */
	    redraw(columnBind?: string): Promise<void>;
	    openSidebar(recordId?: string): void;
	    refresh(keepModifications?: boolean): Promise<void>;
	}
	//# sourceMappingURL=table-control-object.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-error-content' {
	import * as React from 'react';
	export interface DialogErrorContentProps {
	    content: Error;
	}
	export function DialogErrorContent({ content }: DialogErrorContentProps): React.ReactElement;
	//# sourceMappingURL=dialog-error-content.d.ts.map
}
declare module 'lib/component/container/dialog/body/dialog-action-buttons' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { DialogButton } from 'lib/types/dialogs';
	export interface DialogButtonsProps {
	    buttons: Dict<DialogButton>;
	    reverseButtons: boolean;
	    pickNegativeButtons: boolean;
	    defaultFocusRef?: React.RefObject<any>;
	}
	export function DialogActionButtons(props: DialogButtonsProps): React.ReactElement;
	//# sourceMappingURL=dialog-action-buttons.d.ts.map
}
declare module 'lib/component/container/dialog/body/custom-content' {
	import * as React from 'react';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { CustomDialogContentType, CustomDialogOptions, DialogBodyContentProps } from 'lib/types/dialogs';
	export interface DialogCustomContentProps extends DialogBodyContentProps<CustomDialogOptions> {
	    content: CustomDialogContentType;
	    screenId: string;
	    availableColumns: number;
	    screenDefinition?: ScreenBaseDefinition;
	}
	export function DialogBodyCustomContent(props: DialogCustomContentProps): React.ReactElement;
	export const ConnectedDialogBodyCustomContent: import("react-redux").ConnectedComponent<typeof DialogBodyCustomContent, {
	    dialog: import("../../../../types/dialogs").DialogDescription<CustomDialogOptions>;
	    screenId: string;
	    content: CustomDialogContentType;
	    availableColumns: number;
	    screenDefinition?: ScreenBaseDefinition<any> | undefined;
	    selectedSection?: string | null | undefined;
	    noHeader?: boolean | undefined;
	    defaultFocusRef?: React.RefObject<any> | undefined;
	    onStepOneSection: (direction: 1 | -1) => void;
	    isFirstSection: boolean;
	    isLastSection: boolean;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=custom-content.d.ts.map
}
declare module 'lib/component/container/dialog/body/message-content' {
	import * as React from 'react';
	import type { DialogBodyContentProps } from 'lib/types/dialogs';
	export function DialogBodyMessageContent(props: DialogBodyContentProps): React.ReactElement;
	//# sourceMappingURL=message-content.d.ts.map
}
declare module 'lib/component/container/section/section-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ButtonProps } from 'carbon-react/esm/components/button';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { SectionProperties } from 'lib/component/control-objects';
	import { SectionControlObject } from 'lib/component/control-objects';
	import type { ExtensionField, VoidPromise } from 'lib/component/field/traits';
	export interface SectionDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<SectionProperties<CT>, '_controlObjectType'>, ExtensionField<CT, SectionControlObject<CT>> {
	    /** Function that gets executed when the section becomes active */
	    onActive?: (this: CT) => VoidPromise;
	    /** Function that gets executed when the section stops being active */
	    onInactive?: (this: CT) => VoidPromise;
	    /** Button label for the next button if this section is used in a wizard */
	    wizardNextButtonLabel?: string;
	    /** Button type for the next button if this section is used in a wizard */
	    wizardNextButtonType?: ButtonProps['buttonType'];
	    /** Button label for the previous button if this section is used in a wizard */
	    wizardPreviousButtonLabel?: string;
	    /** Button type for the previous button if this section is used in a wizard */
	    wizardPreviousButtonType?: ButtonProps['buttonType'];
	}
	/**
	 * Initializes the decorated member as a [Section]{@link SectionControlObject} container with the provided properties
	 *
	 * @param properties The properties that the [Section]{@link SectionControlObject} container will be initialized with
	 */
	export function section<CT extends ScreenExtension<CT>>(properties: SectionDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
	//# sourceMappingURL=section-decorator.d.ts.map
}
declare module 'lib/component/container/dialog/body/page-content' {
	import * as React from 'react';
	import type { DialogBodyContentProps } from 'lib/types/dialogs';
	export function DialogBodyPageContent({ availableColumns, dialog, isFirstSection, isLastSection, onStepOneSection, screenDefinition, selectedSection, noHeader, }: DialogBodyContentProps): React.ReactNode;
	//# sourceMappingURL=page-content.d.ts.map
}
declare module 'lib/component/container/dialog/body/dialog-body-content' {
	import * as React from 'react';
	import type { DialogBodyContentProps } from 'lib/types/dialogs';
	export function DialogBodyContent(props: DialogBodyContentProps): React.ReactElement;
	//# sourceMappingURL=dialog-body-content.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { DialogDescription, PageDialogOptions, CustomDialogOptions } from 'lib/types/dialogs';
	import { SectionControlObject } from 'lib/component/container/container-control-objects';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	export const collectSections: (dialog: DialogDescription<PageDialogOptions & CustomDialogOptions>, screenDefinitions: Dict<ScreenBaseDefinition>) => SectionControlObject[];
	//# sourceMappingURL=dialog-utils.d.ts.map
}
declare module 'lib/component/container/page/page-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ContainerValidationResult } from 'lib/service/dispatch-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ScreenExtension } from 'lib/types';
	import { AbstractContainer } from 'lib/component/abstract-container';
	import type { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { ContainerComponentProps } from 'lib/component/types';
	import { ContainerKey } from 'lib/component/types';
	import type { IPageControlObject, PageMode, PageNavigationPanel, PageProperties } from 'lib/component/container/page/page-types';
	/**
	 * Main [container]{@link AbstractContainer} of each screen. Holds any number of [sections]{@link SectionControlObject}
	 * and might define additional parts (e.g. crud actions, business actions, a helper panel, etc.)
	 */
	export class PageControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.Page, ContainerComponentProps<ContainerKey.Page>> {
	    private readonly _dispatchPageValidation;
	    private readonly _getFocussedField;
	    static readonly defaultUiProperties: Partial<PageProperties>;
	    constructor(properties: IPageControlObject);
	    /** Visualization mode */
	    get mode(): PageMode | undefined;
	    /** Panel where to search, filter and navigate through current page related items */
	    get navigationPanel(): PageNavigationPanel<any, any> | undefined;
	    /**
	     * The GraphQL node that the page is bind to. This settings will be omitted
	     * if the page is set to be transient
	     */
	    get node(): string;
	    get focussedField(): ReadonlyFieldControlObject<CT, any, any, any> | null;
	    /** Subtitle displayed along with the page's title */
	    subtitle?: string;
	    /**
	     * Triggers the validation rules of all the fields of the page. Since the validation rules
	     * might be asynchronous, this method returns a promise that must be awaited to get
	     * the validation result
	     */
	    validate(): Promise<string[]>;
	    /**
	     * Triggers the field validation rules. Since the validation rules might be asynchronous,
	     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
	     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
	     */
	    validateWithDetails(partition: true): Promise<ContainerValidationResult>;
	    validateWithDetails(partition: false): Promise<ValidationResult[]>;
	    validateWithDetails(): Promise<ValidationResult[]>;
	}
	//# sourceMappingURL=page-control-object.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-header' {
	import * as React from 'react';
	import type { DialogDescription, PageDialogOptions, CustomDialogOptions } from 'lib/types/dialogs';
	export interface DialogHeaderProps {
	    dialog: DialogDescription<PageDialogOptions & CustomDialogOptions>;
	    selectedSection?: string | null;
	    setSelectedSection: (selectedSectionId: string) => void;
	}
	export function DialogHeader({ dialog, setSelectedSection, selectedSection, }: DialogHeaderProps): React.ReactElement | null;
	//# sourceMappingURL=dialog-header.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-breadcrumbs' {
	import * as React from 'react';
	export interface DialogBreadcrumbsProps {
	    screenId: string | null;
	}
	export function DialogBreadcrumbs({ screenId }: DialogBreadcrumbsProps): React.ReactElement | null;
	//# sourceMappingURL=dialog-breadcrumbs.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-title' {
	import type { CustomDialogOptions, DialogDescription, PageDialogOptions } from 'lib/types/dialogs';
	import * as React from 'react';
	export interface DialogTitleProps {
	    dialog: DialogDescription<PageDialogOptions & CustomDialogOptions>;
	    baseBottomMargin?: string;
	    baseTopMargin?: string;
	    onCloseDialog: () => Promise<void>;
	}
	export const DialogTitle: React.FC<DialogTitleProps>;
	//# sourceMappingURL=dialog-title.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-component' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { CustomDialogOptions, DialogDescription, PageDialogOptions } from 'lib/types/dialogs';
	export interface DialogComponentExternalProps {
	    dialogKey: string;
	    isFullScreen: boolean;
	}
	export interface DialogComponentProps extends DialogComponentExternalProps {
	    browser: ReduxResponsive;
	    closeDialog: (dialogId: number) => Promise<void>;
	    dialog: DialogDescription<PageDialogOptions & CustomDialogOptions>;
	    screenDefinitions: Dict<ScreenBaseDefinition>;
	    setActiveSection: (screenId: string, activeSection: string) => Promise<void>;
	    stepOneSection: (screenId: string, direction: 1 | -1) => Promise<void>;
	}
	interface DialogComponentState {
	    activeSection: string | null;
	}
	export class DialogComponent extends React.Component<DialogComponentProps, DialogComponentState> {
	    private normalDialogRef;
	    constructor(props: DialogComponentProps);
	    componentDidUpdate(prevProps: DialogComponentProps): void;
	    closeDialog: () => Promise<void>;
	    getDialogContentGridSize: () => number;
	    getActiveSection: () => string | null;
	    /**
	     *
	     * @description Carbon Dialog focustrap and AgGrid internal state focus handling are incompatible.
	     * They compete and overlap each other for the same browser events and imperative effects (.focus()).
	     * Therefore, we disable the focus trap when the page dialog includes a table within.
	     * For the same reasons we disable the 'Esc' key.
	     *
	     * `disableFocusTrap: boolean` does not currently work... so we use the hidden `bespokeFocusTrap`
	     * callback property with a noop function, which does the same. We should consider a
	     * replacement in the future, when `disableFocusTrap` is back in the Carbon library.
	     *
	     * Giving its current state, disabling by default the FocusTrap in all/most of the dialogs might
	     * not be completely discarded. Browsers defaults may be enough for most cases.
	     *
	     */
	    hasTableField: () => boolean;
	    setSelectedSection: (selectedSection: string) => void;
	    onStepOneSection: (direction: 1 | -1) => void;
	    renderDialogContent(defaultFocusRef?: React.RefObject<any>, noHeader?: boolean): React.ReactNode;
	    renderSidebarDialog: () => React.ReactNode;
	    renderNormalDialog: () => React.ReactNode;
	    renderStickerDialog: () => React.ReactNode;
	    renderFullScreenStickerDialog: () => React.ReactNode;
	    renderFullScreenDialog: () => React.ReactNode;
	    render(): React.ReactNode;
	}
	export const ConnectedDialogComponent: import("react-redux").ConnectedComponent<typeof DialogComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DialogComponent> | undefined;
	    dialogKey: string;
	    isFullScreen: boolean;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=dialog-component.d.ts.map
}
declare module 'lib/component/container/dialog/dialog-router' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { ReduxResponsive } from 'lib/redux/state';
	import type { DialogDescription } from 'lib/types/dialogs';
	interface DialogRouterComponentProps {
	    activeDialogs: Dict<DialogDescription>;
	    browser: ReduxResponsive;
	}
	export function DialogRouter(props: DialogRouterComponentProps): React.ReactElement;
	export const ConnectedDialogRouter: import("react-redux").ConnectedComponent<typeof DialogRouter, {
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=dialog-router.d.ts.map
}
declare module 'lib/component/container/dialog/loading-dialog' {
	import * as React from 'react';
	export interface LoadingDialogState {
	    isRendered: boolean;
	}
	export class LoadingDialog extends React.PureComponent<{}, LoadingDialogState> {
	    private timeoutRef;
	    constructor(props: {});
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    render(): React.ReactNode;
	}
	export default LoadingDialog;
	//# sourceMappingURL=loading-dialog.d.ts.map
}
declare module 'lib/component/toast/toast-component' {
	import * as React from 'react';
	import type { Toast } from 'lib/service/toast-service';
	export interface ToastComponentExternalProps {
	    toast: Toast;
	}
	export interface ToastComponentState {
	    open: boolean;
	}
	export interface ToastComponentProps extends ToastComponentExternalProps {
	    removeToast: () => void;
	}
	export class ToastComponent extends React.Component<ToastComponentProps, ToastComponentState> {
	    timeout?: number;
	    constructor(props: ToastComponentProps);
	    componentDidMount(): void;
	    onDismiss: () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedToastComponent: import("react-redux").ConnectedComponent<typeof ToastComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<ToastComponent> | undefined;
	    toast: Toast;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=toast-component.d.ts.map
}
declare module 'lib/render/select-like-field-wrapper' {
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import * as React from 'react';
	import type { Dict } from '@sage/xtrem-shared';
	import type { HasOptionType } from 'lib/component/field/traits';
	import { FieldKey } from 'lib/component/types';
	type fieldType = FieldKey.Select | FieldKey.DropdownList | FieldKey.Radio | FieldKey.MultiDropdown;
	interface SelectLikeFieldWrapperExternalProps extends BaseEditableComponentProperties<EditableFieldProperties & HasOptionType, any, NestedFieldsAdditionalProperties> {
	    fieldType: fieldType;
	}
	export interface SelectLikeFieldWrapperProps extends SelectLikeFieldWrapperExternalProps {
	    localizedOptions?: Dict<string>;
	    enumOptions?: string[];
	}
	export function SelectLikeFieldWrapper(props: SelectLikeFieldWrapperProps): React.ReactElement;
	export const ConnectedSelectLikeFieldWrapper: import("react-redux").ConnectedComponent<typeof SelectLikeFieldWrapper, {
	    fieldType: fieldType;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    validationErrors?: import("..").ValidationResult[] | undefined;
	    setFieldValue: (bind: string, value: any) => Promise<void>;
	    validate: (bind: string, value: any) => Promise<import("..").ValidationResult[] | undefined>;
	    removeNonNestedErrors: (bind: string) => void;
	    setFieldProperties?: ((elementId: string, value: EditableFieldProperties<import("../service/screen-base").ScreenBase<any, any>, any> & HasOptionType) => void) | undefined;
	    isParentReadOnly?: boolean | undefined;
	    browser?: import("../plugin").ReduxResponsive | undefined;
	    fieldProperties: EditableFieldProperties<import("../service/screen-base").ScreenBase<any, any>, any> & HasOptionType;
	    nodeTypes?: Dict<import("../service/metadata-types").FormattedNodeDetails> | undefined;
	    pageNode?: import("../types").NodePropertyType | undefined;
	    value?: any;
	    onFocus: (row?: string | undefined, nestedField?: string | undefined) => void;
	    isInFocus?: boolean | undefined;
	    locale: import("@sage/xtrem-shared").LocalizeLocale;
	    columnDefinition?: any;
	    contextNode?: import("../types").NodePropertyType | undefined;
	    handlersArguments?: import("../component/nested-fields").NestedFieldHandlersArguments | undefined;
	    isNested?: boolean | undefined;
	    level?: number | undefined;
	    parentElementId?: string | undefined;
	    recordContext?: any;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=select-like-field-wrapper.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-nested-field' {
	import type * as xtremRedux from 'lib/redux';
	import React from 'react';
	import type { SidebarFieldBinding } from 'lib/component/table-sidebar/table-sidebar-types';
	import { FieldKey } from 'lib/component/types';
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import type { ReduxResponsive } from 'lib/plugin';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { NestedGridDecoratorProperties, TableDecoratorProperties } from 'lib/component/decorator-properties';
	export interface TableSidebarNestedFieldExternalProps extends SidebarFieldBinding {
	    availableColumns: number;
	    screenId: string;
	}
	export interface TableSidebarNestedFieldProps extends TableSidebarNestedFieldExternalProps {
	    fieldProperties: EditableFieldProperties;
	    setFieldProperties: (bind: string, fieldProperties: EditableFieldProperties) => void;
	    browser: ReduxResponsive;
	    fieldType: FieldKey;
	    onChange?: (bind: string, value: any) => Promise<void>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    locale: LocalizeLocale;
	    screenId: string;
	    elementId: string;
	    level?: number;
	    recordId?: string;
	    value: CollectionValue;
	    isUncommitted: boolean;
	    recordValue: any;
	    shouldFetchDefault: boolean;
	    tableProperties: TableDecoratorProperties | NestedGridDecoratorProperties;
	    validationErrors?: ValidationResult[];
	}
	export function TableSidebarNestedField({ availableColumns, browser, elementId, fieldId, fieldProperties, fieldType, level, locale, onChange, recordValue, screenId, tableProperties, validationErrors, setFieldProperties, }: TableSidebarNestedFieldProps): React.ReactElement | null;
	export const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarNestedFieldExternalProps) => Partial<TableSidebarNestedFieldProps>;
	export const ConnectedTableSidebarNestedField: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarNestedFieldProps>, {
	    availableColumns: number;
	    screenId: string;
	    fieldId: string;
	    isNested: boolean;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<TableSidebarNestedFieldProps, any, any>> | undefined;
	    availableColumns: number;
	    screenId: string;
	    fieldId: string;
	    isNested: boolean;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-nested-field.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-normal-field' {
	import type * as xtremRedux from 'lib/redux';
	import React from 'react';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	export interface TableSidebarNormalFieldExternalProps {
	    fieldId: string;
	    availableColumns: number;
	    screenId: string;
	}
	export interface TableSidebarNormalFieldProps extends TableSidebarNormalFieldExternalProps {
	    fieldProperties: ReadonlyFieldProperties;
	    screenId: string;
	}
	export function TableSidebarNormalField({ fieldProperties, availableColumns, fieldId, screenId, }: TableSidebarNormalFieldProps): React.ReactElement;
	export const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarNormalFieldExternalProps) => Partial<TableSidebarNormalFieldProps>;
	export const ConnectedTableSidebarNormalField: import("react-redux").ConnectedComponent<typeof TableSidebarNormalField, {
	    fieldId: string;
	    availableColumns: number;
	    screenId: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-normal-field.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-block' {
	import type * as xtremRedux from 'lib/redux';
	import React from 'react';
	import type { SidebarFieldBinding } from 'lib/component/table-sidebar/table-sidebar-types';
	import type { ReduxResponsive } from 'lib/redux/state';
	export interface TableSidebarBlockExternalProps {
	    section: string;
	    block: string;
	}
	export interface TableSidebarBlockProps extends TableSidebarBlockExternalProps {
	    title?: string;
	    browser: ReduxResponsive;
	    fields: SidebarFieldBinding[];
	    screenId: string;
	}
	export function TableSidebarBlock({ title, browser, fields, screenId }: TableSidebarBlockProps): React.ReactElement;
	export const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarBlockExternalProps) => TableSidebarBlockProps;
	export const ConnectedTableSidebarBlock: import("react-redux").ConnectedComponent<typeof TableSidebarBlock, {
	    section: string;
	    block: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-block.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-section' {
	import type * as xtremRedux from 'lib/redux';
	import React from 'react';
	export interface TableSidebarSectionExternalProps {
	    section: string;
	}
	export interface TableSidebarSectionProps extends TableSidebarSectionExternalProps {
	    blocks: string[];
	}
	export function TableSidebarSection({ blocks, section }: TableSidebarSectionProps): React.ReactElement;
	export const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarSectionExternalProps) => TableSidebarSectionProps;
	export const ConnectedTableSidebarSection: import("react-redux").ConnectedComponent<typeof TableSidebarSection, {
	    section: string;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-section.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-card' {
	import type * as xtremRedux from 'lib/redux';
	import React from 'react';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	export interface TableSidebarCardProps {
	    cardDefinition?: CardDefinition<any>;
	    screenId: string;
	    recordValue: any;
	    elementId: string;
	    recordId?: string;
	    value: CollectionValue;
	    level?: number;
	    isUncommitted: boolean;
	}
	export function TableSidebarCard({ cardDefinition, screenId, elementId, recordValue, }: TableSidebarCardProps): React.ReactElement | null;
	export const mapStateToProps: (state: xtremRedux.XtremAppState) => Partial<TableSidebarCardProps>;
	export const ConnectedTableSidebarCard: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarCardProps>, {
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<TableSidebarCardProps, any, any>> | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-card.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-body' {
	import type * as xtremRedux from 'lib/redux';
	import React from 'react';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { SidebarSectionDefinition } from 'lib/component/table-sidebar/table-sidebar-types';
	import type { Dict } from '@sage/xtrem-shared';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	export interface TableSidebarBodyProps {
	    sidebarLayoutDefinition: Dict<SidebarSectionDefinition>;
	    screenId?: string;
	    recordId?: string;
	    value: CollectionValue;
	    isUncommitted: boolean;
	    level?: number;
	    recordValue?: any;
	    validationErrors: ValidationResult[];
	}
	export function TableSidebarBody({ validationErrors, sidebarLayoutDefinition, screenId, recordId, recordValue, }: TableSidebarBodyProps): React.ReactElement;
	export const mapStateToProps: (state: xtremRedux.XtremAppState) => Partial<TableSidebarBodyProps>;
	export const ConnectedTableSidebarBody: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarBodyProps>, {
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<TableSidebarBodyProps, any, any>> | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-body.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-footer' {
	import React from 'react';
	import * as xtremRedux from 'lib/redux';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { ReduxResponsive } from 'lib/plugin';
	interface TableSideBarFooterProps {
	    onConfirm: (addNewRecord?: boolean) => void;
	    onCancel: () => void;
	    isNewRecord: boolean;
	    validationErrors: ValidationResult[];
	    recordId?: string;
	    value: CollectionValue;
	    isUncommitted: boolean;
	    externalErrors: boolean;
	    level?: number;
	    browser: ReduxResponsive;
	}
	export function TableSidebarFooter({ validationErrors, isNewRecord, onConfirm, onCancel, externalErrors, browser, }: TableSideBarFooterProps): React.ReactElement;
	export const mapDispatchToProps: (dispatch: xtremRedux.AppThunkDispatch) => Partial<TableSideBarFooterProps>;
	export const ConnectedTableSidebarFooter: import("react-redux").ConnectedComponent<React.ComponentType<TableSideBarFooterProps>, {
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<TableSideBarFooterProps, any, any>> | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export {};
	//# sourceMappingURL=table-sidebar-footer.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-header' {
	import * as React from 'react';
	import type * as xtremRedux from 'lib/redux';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { MenuSeparatorType } from 'lib/component/container/page/page-types';
	import type { ErrorHandlerFunction } from 'lib/component/field/traits';
	import type { CollectionItemAction, CollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	export interface TableSidebarHeaderProps {
	    accessBindings: AccessBindings;
	    elementId: string;
	    hasNextRecord: boolean;
	    hasPreviousRecord: boolean;
	    headerDropdownActions?: Array<CollectionItemAction<any> | CollectionItemActionGroup<any> | MenuSeparatorType>;
	    headerQuickActions?: Array<CollectionItemAction<any>>;
	    isLoading: boolean;
	    isUncommitted: boolean;
	    level?: number;
	    onError?: ErrorHandlerFunction<any>;
	    onNextRecord: () => Promise<void>;
	    onPreviousRecord: () => Promise<void>;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	    recordId?: string;
	    recordValue: any;
	    screenDefinition: ScreenBaseDefinition;
	    screenId: string;
	    sidebarGetTitle?: string | ((_id: string, recordValue?: any) => string);
	    tableTitle?: string;
	    value?: CollectionValue;
	}
	export function TableSidebarHeader({ accessBindings, elementId, hasNextRecord, hasPreviousRecord, headerDropdownActions, headerQuickActions, isLoading, onError, onNextRecord, onPreviousRecord: onPrevRecord, onTelemetryEvent, recordValue, screenDefinition, screenId, sidebarGetTitle, tableTitle, }: TableSidebarHeaderProps): React.ReactElement | null;
	export const mapDispatchToProps: (dispatch: xtremRedux.AppThunkDispatch) => Partial<TableSidebarHeaderProps>;
	export const mapStateToProps: (state: xtremRedux.XtremAppState) => Partial<TableSidebarHeaderProps>;
	export const ConnectedTableSidebarHeader: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarHeaderProps>, {
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	} | {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<React.Component<TableSidebarHeaderProps, any, any>> | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar-header.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar' {
	import React from 'react';
	import * as xtremRedux from 'lib/redux';
	export interface TableSidebarProps {
	    elementId?: string;
	    isFullWidthDialogScreen?: boolean;
	    isLoading: boolean;
	    isScreenMounted: boolean;
	    onCancel: () => void;
	    screenId?: string;
	}
	export function TableSidebar({ elementId, isFullWidthDialogScreen, isLoading, isScreenMounted, onCancel, screenId, }: TableSidebarProps): React.ReactElement | null;
	export const mapStateToProps: (state: xtremRedux.XtremAppState) => Partial<TableSidebarProps>;
	export const mapDispatchToProps: (dispatch: xtremRedux.AppThunkDispatch) => Partial<TableSidebarProps>;
	export const ConnectedTableSidebar: import("react-redux").ConnectedComponent<typeof TableSidebar, {
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-sidebar.d.ts.map
}
declare module 'lib/xtrem-controller' {
	export {};
	//# sourceMappingURL=xtrem-controller.d.ts.map
}
declare module 'lib/xtrem-ui-index' {
	import * as React from 'react';
	import * as xtremRedux from 'lib/redux';
	import type { ApplicationContext } from 'lib/redux/state';
	export interface XtremUiIndexProps {
	    path: string;
	    applicationContext: ApplicationContext;
	}
	/**
	 * Entry point of the Xtrem UI framework. Instantiates the react Providers, sets the application
	 * context and renders the framework components
	 */
	export class XtremUiIndex extends React.Component<XtremUiIndexProps> {
	    constructor(props: XtremUiIndexProps);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: XtremUiIndexProps): void;
	    componentWillUnmount(): void;
	    private setGlobalState;
	    navigate(thunkDispatch: xtremRedux.AppThunkDispatch, path: string): Promise<void>;
	    /** This method is used by xtrem-standalone */
	    cleanToasts(): void;
	    render(): React.ReactNode;
	}
	//# sourceMappingURL=xtrem-ui-index.d.ts.map
}
declare module 'lib/dashboard/dashboard-root-component' {
	import * as React from 'react';
	import type { ApplicationContext } from 'lib/redux/state';
	export interface DashboardRootComponentProps {
	    applicationContext: ApplicationContext;
	    group: string;
	}
	export interface DashboardRootComponentState {
	    error?: Error;
	}
	export class DashboardRootComponent extends React.Component<DashboardRootComponentProps, DashboardRootComponentState> {
	    componentDidMount(): Promise<void>;
	    componentDidCatch(error: Error): void;
	    render(): React.ReactNode;
	}
	//# sourceMappingURL=dashboard-root-component.d.ts.map
}
declare module 'lib/integration' {
	import { ApplicationContext, Menu } from 'lib/redux/state';
	import FieldWrapper from 'lib/render/field-wrapper';
	import { Breakpoints, breakpoints } from 'lib/render/responsive-breakpoints';
	import { XtremUiIndex } from 'lib/xtrem-ui-index';
	import { DashboardRootComponent } from 'lib/dashboard/dashboard-root-component';
	/**
	 * This file contains the exports for integration, not API usage.
	 */
	export { ApplicationContext, XtremUiIndex, DashboardRootComponent, FieldWrapper, Menu, Breakpoints, breakpoints };
	//# sourceMappingURL=integration.d.ts.map
}
declare module 'lib/service/table-view-storage-service' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { TableView } from 'lib/redux/state';
	export const TABLE_VIEW_STORAGE_KEY = "TableViews";
	export const getStoredTableViewsByScreen: (username: string, screenId: string) => Promise<Dict<Dict<TableView>>>;
	export const getStoredTableViewsByElement: (username: string, screenId: string, elementId: string) => Promise<Dict<TableView>>;
	export const setStoredTableViewsByScreen: (username: string, screenId: string, tableViews: Dict<Dict<TableView>>) => Promise<Dict<Dict<TableView>>>;
	export const setStoredTableViewsByElement: (username: string, screenId: string, elementId: string, tableViews: Dict<TableView>) => Promise<Dict<Dict<TableView>>>;
	export const clearStoredTableViewsByElement: (username: string, screenId: string, elementId: string) => Promise<void>;
	//# sourceMappingURL=table-view-storage-service.d.ts.map
}
declare module 'lib/redux/actions/navigation-panel-actions' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { OptionsMenuItem } from 'lib/component/control-objects';
	import type { AppThunkDispatch } from 'lib/redux/action-types';
	import type { TableViewGrouping, TableViewSortedColumn, XtremAppState } from 'lib/redux/state';
	export const refreshNavigationPanel: (screenId: string, recordAdded?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const setNavigationPanelIsHidden: (isHidden: boolean, screenId: string) => (dispatch: AppThunkDispatch) => void;
	export const setNavigationPanelIsOpened: (isOpened: boolean, screenId: string) => (dispatch: AppThunkDispatch) => void;
	export const setNavigationPanelIsHeaderHidden: (isHeaderHidden: boolean, screenId: string) => (dispatch: AppThunkDispatch) => void;
	export const setTableViewColumnHidden: (screenId: string, elementId: string, level: number, columnHidden?: Dict<boolean>) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setTableViewColumnOrder: (screenId: string, elementId: string, level: number, columnOrder?: string[]) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setTableViewFilter: (screenId: string, elementId: string, level: number, filter?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setTableViewGrouping: (screenId: string, elementId: string, level: number, grouping?: TableViewGrouping) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setTableViewOptionMenuItem: (screenId: string, elementId: string, level: number, optionsMenuItem?: OptionsMenuItem) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setTableViewOptionsMenuItemAndViewFilter: (screenId: string, elementId: string, level: number, optionsMenuItem?: OptionsMenuItem, filter?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const setTableViewSearchText: (screenId: string, elementId: string, level: number, searchText: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	export const clearNavigationPanelSearchText: (screenId: string) => (dispatch: AppThunkDispatch) => void;
	export const setTableViewSortOrder: (screenId: string, elementId: string, level: number, sortOrder?: TableViewSortedColumn[]) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
	//# sourceMappingURL=navigation-panel-actions.d.ts.map
}
declare module 'lib/service/storage-service' {
	import type { Dict } from '@sage/xtrem-shared';
	export type PrimitiveType = string | number | boolean | null;
	export interface Storage {
	    set: (key: string, value: string | number | boolean) => void;
	    get: (key: string) => PrimitiveType;
	    getAll: () => Dict<PrimitiveType>;
	    remove: (key: string) => void;
	}
	/** Add a single entry from the storage */
	export const set: (key: string, value: string | number | boolean) => void;
	/** Get a single entry from the storage */
	export const get: (key: string) => PrimitiveType;
	/** Get all entries from the storage as a dictionary */
	export const getAll: () => Dict<PrimitiveType>;
	/** Removes a single entry from the storage */
	export const remove: (key: string) => void;
	//# sourceMappingURL=storage-service.d.ts.map
}
declare module 'lib/service/navigation-panel-service' {
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import type { OptionsMenuItem, OptionsMenuItemType, OptionsMenuType, RuntimePageNavigationPanel } from 'lib/component/container/page/page-types';
	import type { InternalTableProperties, TableDecoratorProperties } from 'lib/component/field/table/table-component-types';
	import type { OrderByType, PartialCollectionValue } from 'lib/component/types';
	import type { ApplicationContext } from 'lib/integration';
	import type { NodePropertyType } from 'lib/types';
	import { CollectionValue } from 'lib/service/collection-data-service';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	export function createMySelectedDataOptionItem(pageDefinition: PageDefinition): OptionsMenuItem;
	export const resolveNavigationPanelOptionFilter: (pageDefinition: PageDefinition) => (optionItem?: OptionsMenuItem) => OptionsMenuItem | undefined;
	export const resolveOptionsMenu: (pageDefinition: PageDefinition, optionsMenu: OptionsMenuType<any> | undefined, applicationContext?: ApplicationContext) => Promise<OptionsMenuItemType[]>;
	export const getMergedOptionMenu: (pageDefinition: PageDefinition, navigationPanel: RuntimePageNavigationPanel<any>, applicationContext?: ApplicationContext) => Promise<OptionsMenuItemType[]>;
	export const getInitialOptionMenuItem: (pageDefinition: PageDefinition, navigationTableProperties: InternalTableProperties) => OptionsMenuItem | undefined;
	export const onNavigationPanelRowClick: (pageDefinition: PageDefinition, navigationPanel: RuntimePageNavigationPanel<any>, path?: string) => (recordId: string, rowItem: any, isModifierKeyPushed?: boolean) => void;
	export const createNavigationTableProperties: (screenId: string, pageNode: NodePropertyType, pageDefinition: PageDefinition, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, path?: string, applicationContext?: ApplicationContext) => Promise<InternalTableProperties>;
	export const createNavigationPanelValue: (screenId: string, navigationPanelTableProperties: TableDecoratorProperties, initialValues: PartialCollectionValue<any>[], nodeTypes?: Dict<FormattedNodeDetails>, locale?: LocalizeLocale, activeOptionsMenuItem?: OptionsMenuItem, orderBy?: OrderByType) => CollectionValue;
	//# sourceMappingURL=navigation-panel-service.d.ts.map
}
declare module 'lib/service/screen-loader-service' {
	import type { Dict } from '@sage/xtrem-shared';
	import * as xtremShared from '@sage/xtrem-shared';
	import type { AbstractWidget } from 'lib/dashboard/widgets/abstract-widget';
	import type { AppThunkDispatch, XtremAppState } from 'lib/redux';
	import type { ApplicationContext } from 'lib/redux/state';
	import type { Constructible } from 'lib/types';
	import type { QueryParameters } from 'lib/utils/types';
	import type { ArtifactType, MetadataResponse } from 'lib/service/metadata-types';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { StickerDefinition } from 'lib/service/sticker-definition';
	export const getXtremArtifactVariable: () => xtremShared.Dict<Constructible<any>>; global {
	    let xtremArtifact: Dict<Constructible<any>>;
	}
	/**
	 * Fetches the plugin source code from the server or restores it from the cache.
	 *
	 * @param pluginPackage
	 * @param applicationContext
	 * @param cache
	 * @returns plugin source code
	 */
	export function fetchPlugin(pluginPackage: string, applicationContext: ApplicationContext, version: string, cache?: Cache): Promise<string>;
	/**
	 * Check and evaluate raw Xtrem UI plugin script content. If the plugin is compliant with the expected standards, then
	 * it will be added to the application state.
	 **/
	export const loadPlugins: (dispatch: AppThunkDispatch, plugins: string[], applicationContext: ApplicationContext, loadedPlugins: string[], applicationPackages: Dict<string>) => Promise<void>;
	export const processStringLiteralsFromResponse: (metadataType: ArtifactType | undefined, response: MetadataResponse) => Dict<string>;
	/**
	 * This function will mutate pageDefinition object in order to add all the info related to table views.
	 */
	export const setUpTableViews: ({ applicationContext, pageDefinition, screenId, }: {
	    applicationContext: ApplicationContext;
	    pageDefinition: PageDefinition;
	    screenId: string;
	}) => Promise<void>;
	/**
	 * Fetches the page definition corresponding to the path from the server and evaluates the javascript response
	 *
	 * @param path the xtrem path in string format
	 */
	export const fetchPageDefinition: ({ getState, dispatch, path, isMainPage, queryParameters, values, onFinish, isDuplicate, }: {
	    getState: () => XtremAppState;
	    dispatch: AppThunkDispatch;
	    path: string;
	    isMainPage?: boolean;
	    queryParameters?: QueryParameters;
	    values?: Dict<any>;
	    onFinish?: (values?: Dict<any>) => void;
	    isDuplicate?: boolean;
	}) => Promise<PageDefinition | null>;
	/**
	 * Fetches the sticker definition corresponding to the path from the server and evaluates the javascript response
	 *
	 * @param path the xtrem path in string format
	 */
	export const fetchStickerDefinition: (getState: () => XtremAppState, dispatch: AppThunkDispatch, path: string, onFinish?: (values?: Dict<any>) => void) => Promise<StickerDefinition | null>;
	/**
	 * Fetches the sticker definition corresponding to the path from the server and evaluates the javascript response
	 *
	 * @param path the xtrem path in string format
	 */
	export const fetchWidgetDefinitions: (getState: () => XtremAppState, dispatch: AppThunkDispatch, widgetsToLoad: string[]) => Promise<Dict<Constructible<AbstractWidget>> | null>;
	//# sourceMappingURL=screen-loader-service.d.ts.map
}
declare module 'lib/redux/actions/router-actions' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { QueryParameters } from 'lib/utils/types';
	import type { AppAction, AppThunkDispatch } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export const getPageValues: (screenDefinition: PageDefinition, recordId: string | null, clean?: boolean, nodeTypes?: Dict<FormattedNodeDetails>) => Promise<any>;
	export const triggerPostNavigationToasts: (state: XtremAppState, path: string, queryParameters: QueryParameters) => Promise<void>;
	/**
	 * Be aware that base64 encoded parameters in the path will override the queryParameters object
	 * @param path Be
	 * @param queryParameters
	 */
	export const navigate: (path: string, queryParameters?: QueryParameters) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const selectRecord: (screenId: string, recordId: string | null, clean?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const findNavPanelRecordLocation: (screenId: string, state: XtremAppState, offset: 1 | -1) => Promise<string | null>;
	export const selectNextRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const selectFirstRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const selectPreviousRecord: (screenId: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const goHome: () => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
	export const setIdToQueryParameters: (screenId: string, _id: string) => AppAction;
	//# sourceMappingURL=router-actions.d.ts.map
}
declare module 'lib/service/router' {
	import type { QueryParameters } from 'lib/utils/types';
	/** Router API. It encapsulates function that enable developers to navigate to various pages and open records programmatically. */
	export interface IRouter {
	    /** Navigates to another page, query parameters can be sent to the page that is being opened. */
	    goTo: (path: string, queryParameters?: QueryParameters, skipDirtyCheck?: boolean) => void;
	    /** Navigates to an external link in a new tab. */
	    goToExternal: (link: string) => void;
	    /**
	     * Refreshes the current page, it restores the page to it's original state including field values and all component properties.
	     * If the page is bound to any record, the value is refetched from the server.
	     * It triggers the `onLoad` lifecycle hooks in page and page extension decorators.
	     */
	    refresh: (skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     * Clears all field values and resets all component properties. It triggers the `onLoad` lifecycle hooks in page and page extension decorators.
	     */
	    emptyPage: (skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     * Close the current record and navigates to the full width nav panel.
	     */
	    closeRecord: (skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     * Selects a record of the current page. The action is identical to when the the user selects a record from the navigation panel.
	     */
	    selectRecord: (_id: number | string, skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     * Selects the first record from the navigation panel
	     */
	    firstRecord: (skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     * Selects the next record from the navigation panel. This action can only be used if a navigation panel is defined for the page.
	     */
	    nextRecord: (skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     * Selects the previous record from the navigation panel. This action can only be used if a navigation panel is defined for the page.
	     */
	    previousRecord: (skipDirtyCheck?: boolean) => Promise<void>;
	    /**
	     *  Determines whether there is a next record on the navigation panel. This action can only be used if a navigation panel is defined for the page.
	     */
	    hasNextRecord: () => Promise<boolean>;
	    /**
	     * Determines whether there is a previous record on the navigation panel. This action can only be used if a navigation panel is defined for the page.
	     */
	    hasPreviousRecord: () => Promise<boolean>;
	    hardRefresh: () => Promise<void>;
	    goHome: (skipDirtyCheck?: boolean) => Promise<void>;
	}
	export class Router implements IRouter {
	    private readonly screenId;
	    constructor(screenId: string);
	    private isScreenDirty;
	    private wrapNavigationMethod;
	    goTo(path: string, queryParameters?: QueryParameters, skipDirtyCheck?: boolean): Promise<void>;
	    goToExternal(link: string): void;
	    refresh(skipDirtyCheck?: boolean): Promise<void>;
	    emptyPage(skipDirtyCheck?: boolean): Promise<void>;
	    closeRecord(skipDirtyCheck?: boolean): Promise<void>;
	    selectRecord(recordId: number | string, skipDirtyCheck?: boolean): Promise<void>;
	    firstRecord(skipDirtyCheck?: boolean): Promise<void>;
	    nextRecord(skipDirtyCheck?: boolean): Promise<void>;
	    previousRecord(skipDirtyCheck?: boolean): Promise<void>;
	    hasPreviousRecord(): Promise<boolean>;
	    hasNextRecord(): Promise<boolean>;
	    hardRefresh(): Promise<void>;
	    goHome(skipDirtyCheck?: boolean): Promise<void>;
	}
	export const getRouter: (screenId: string) => Router;
	//# sourceMappingURL=router.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-options-menu' {
	import React from 'react';
	import type { OptionsMenuItem, TableOptionsMenuType } from 'lib/component/container/page/page-types';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	export interface TableOptionsMenuExternalProps {
	    elementId: string;
	    onSelectionChange: (selectedItem: OptionsMenuItem) => void;
	    optionsMenuItems: OptionsMenuItem[];
	    optionsMenuType?: TableOptionsMenuType;
	    screenId: string;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface TableOptionsMenuProps extends TableOptionsMenuExternalProps {
	    setTableViewOptionsMenuItem: (optionsMenuItem: OptionsMenuItem) => void;
	}
	export function TableOptionsMenu({ elementId, onSelectionChange, optionsMenuItems, optionsMenuType, screenId, selectedOptionsMenuItem, setTableViewOptionsMenuItem, onTelemetryEvent, }: TableOptionsMenuProps): React.ReactElement | null;
	export const ConnectedTableOptionsMenu: import("react-redux").ConnectedComponent<typeof TableOptionsMenu, {
	    elementId: string;
	    onSelectionChange: (selectedItem: OptionsMenuItem) => void;
	    optionsMenuItems: OptionsMenuItem[];
	    optionsMenuType?: TableOptionsMenuType | undefined;
	    screenId: string;
	    selectedOptionsMenuItem?: OptionsMenuItem<any> | undefined;
	    onTelemetryEvent?: OnTelemetryEventFunction | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=table-options-menu.d.ts.map
}
declare module 'lib/component/ui/table-shared/desktop-table-export-button' {
	import * as React from 'react';
	export interface DesktopTableExportButtonProps {
	    onExport: (format: 'excel' | 'csv') => void;
	    isDisabled: boolean;
	    hasData: boolean;
	    elementId: string;
	    screenId: string;
	}
	export function DesktopTableExportButton({ onExport, isDisabled, hasData, elementId, screenId, }: DesktopTableExportButtonProps): React.ReactElement;
	//# sourceMappingURL=desktop-table-export-button.d.ts.map
}
declare module 'lib/component/ui/table-shared/desktop-table-print-button' {
	import * as React from 'react';
	export interface DesktopTablePrintingButtonProps {
	    screenId: string;
	    elementId: string;
	}
	export function DesktopTablePrintButton({ screenId, elementId, }: DesktopTablePrintingButtonProps): React.ReactElement | null;
	//# sourceMappingURL=desktop-table-print-button.d.ts.map
}
declare module 'lib/component/ui/table-shared/desktop-table-header' {
	import * as React from 'react';
	import type { Filter } from 'lib/service/filter-service';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	import type { InternalNestedGridProperties } from 'lib/component/field/nested-grid/nested-grid-control-object';
	import type { InternalTableProperties, TableViewMode } from 'lib/component/field/table/table-component-types';
	import type { CalendarView } from 'lib/component/ui/calendar-body/calendar-body-types';
	import type { FilterManagerField } from 'lib/component/ui/filter/filter-manager';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	export interface DesktopTableHeaderProps {
	    columnPanelDisabled?: boolean;
	    elementId: string;
	    fieldProperties: InternalTableProperties | InternalNestedGridProperties;
	    filterComponentFields?: FilterManagerField[];
	    filtersComponentFilters?: Filter[];
	    filterText?: string;
	    hasAddItemsButton: boolean;
	    hasCalendarView?: boolean;
	    hasData?: boolean;
	    hasFloatingFilters?: boolean;
	    hasSearchBox?: boolean;
	    hasSidebar: boolean;
	    isDisabled: boolean;
	    isExportDisabled?: boolean;
	    isReadOnly: boolean;
	    level?: number;
	    onExport?: (target: 'csv' | 'excel') => void;
	    onFilterByErrors?: () => void;
	    onFiltersComponentChanged?: (filters: Filter[]) => Promise<void>;
	    onFocusPhantomRow?: () => void;
	    /** Callback that is called when the column settings button is clicked. If undefined, the column settings button is not rendered. */
	    onOpenColumnPanel?: () => void;
	    onOptionsMenuItemChange?: (newOptionItem: OptionsMenuItem) => void;
	    onSearchBoxValueChange?: (textValue: string) => void;
	    onSwitchCalendarView?: (calendarView: CalendarView) => void;
	    onSwitchView?: (view: TableViewMode) => void;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	    /** Callback that is called when the toggle filter button is clicked. If undefined, the toggle button is not rendered. */
	    onToggleFilters?: () => void;
	    onUnsetFilterByErrors?: () => void;
	    screenId: string;
	    selectedCalendarView?: CalendarView;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    tableViewMode?: TableViewMode;
	    validationErrors: ValidationResult[];
	}
	/**
	 * This component contains the header functionality for the desktop table and nested grids. The functionality of these two components is very similar.
	 * It contains the field action buttons, export button, business header actions, options menu, validation errors and the field title label.
	 */
	export const DesktopTableHeaderComponent: React.FC<DesktopTableHeaderProps>;
	//# sourceMappingURL=desktop-table-header.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-selection-helper' {
	import type { GridApi } from '@ag-grid-community/core';
	import type { RefObject } from 'react';
	import type { MarkRequired } from 'ts-essentials';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { CollectionValueType } from 'lib/service/collection-data-types';
	import type { SelectedGroupState } from 'lib/component/field/table/table-component-types';
	import { GroupState } from 'lib/component/field/table/table-component-types';
	export const processGroupSelection: (gridApi: GridApi | null, value: CollectionValue, row: MarkRequired<CollectionValueType, '__groupKey' | '__isGroup'>, setSelected: boolean) => CollectionValueType[];
	export const changeGroupIcon: (rowId: string, groupState: GroupState, tableRef: RefObject<HTMLDivElement>) => void;
	export const updateGroupState: (prevSelectedGroupState: SelectedGroupState, groupKey: string, groupState: string, isSelected: boolean, tableRef: RefObject<HTMLDivElement>) => SelectedGroupState;
	//# sourceMappingURL=table-selection-helper.d.ts.map
}
declare module 'lib/component/ui/table-shared/desktop-table-bulk-action-bar' {
	import type { GridApi } from '@ag-grid-community/core';
	import * as React from 'react';
	import type { BulkAction } from 'lib/component/container/container-control-objects';
	import type { SelectedGroupState } from 'lib/component/field/table/table-component-types';
	import type { OnTelemetryEventFunction } from 'lib/redux/state';
	export interface DesktopTableBulkActionBarProps {
	    gridApi: GridApi;
	    selectedRowCount: number;
	    bulkActions?: BulkAction[];
	    screenId: string;
	    onClearSelection: () => void;
	    selectedGroupState?: SelectedGroupState;
	    isSelectAllChecked: boolean;
	    groupByColumnField?: string;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export function DesktopTableBulkActionBar({ bulkActions, gridApi, selectedGroupState, isSelectAllChecked, selectedRowCount, screenId, onClearSelection, groupByColumnField, onTelemetryEvent, }: DesktopTableBulkActionBarProps): React.ReactElement;
	//# sourceMappingURL=desktop-table-bulk-action-bar.d.ts.map
}
declare module 'lib/component/field/table/desktop-table-component' {
	import type { CellFocusedEvent, CellKeyDownEvent, ColDef, Column, ColumnEverythingChangedEvent, ColumnState, GridApi } from '@ag-grid-community/core';
	import type { Dict } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { TableViewGrouping, TableViewSortedColumn } from 'lib/redux/state';
	import type { CollectionValueType } from 'lib/service/collection-data-types';
	import { ContextType } from 'lib/types';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	import type { CalendarView } from 'lib/component/ui/calendar-body/calendar-body-types';
	import type { InternalTableProperties, SelectedGroupState, TableInternalComponentProps } from 'lib/component/field/table/table-component-types';
	import type { AgGridColumnConfigWithScreenIdAndColDef } from 'lib/utils/ag-grid/ag-grid-utility-types';
	interface ResizedColumn {
	    key: string | Column;
	    newWidth: number;
	}
	interface TableDesktopState {
	    autoGroupColumnDef?: ColDef;
	    columns: AgGridColumnConfigWithScreenIdAndColDef[];
	    columnStates?: ColumnState[];
	    groupByColumn?: AgGridColumnConfigWithScreenIdAndColDef;
	    hasFloatingFilters: boolean;
	    isConfigurationDialogOpen?: boolean;
	    isExportingExcel: boolean;
	    isSelectAllChecked: boolean;
	    phantomRows: {
	        _id: string;
	    }[];
	    selectedRowCount: number;
	    selectedRows: CollectionValueType[];
	    tableHasData: boolean;
	    selectedGroupState?: SelectedGroupState;
	    selectedCalendarView: CalendarView;
	    resizedColumns: ResizedColumn[];
	}
	export class DesktopTableComponent extends React.Component<TableInternalComponentProps, TableDesktopState> {
	    private gridApi;
	    private readonly gridId;
	    private dataOperationMode;
	    private readonly autoSizeStrategy;
	    private isFetching;
	    private isFilteringErrors;
	    private newDataSelected;
	    private actionSubscription;
	    private collectionValueChangeSubscription;
	    private collectionValidityChangeSubscription;
	    protected containerRef: React.RefObject<HTMLDivElement>;
	    private readonly defaultColDef;
	    private readonly loadingCellRendererParams;
	    private readonly loadingOverlayComponentParams;
	    constructor(props: TableInternalComponentProps);
	    componentDidMount(): void;
	    componentDidUpdate(prevProps: TableInternalComponentProps): void;
	    componentWillUnmount(): void;
	    private readonly getRowNode;
	    private readonly focusPhantomRowAndStartEditing;
	    private readonly onCollectionUpdated;
	    private getCursor;
	    private getFilters;
	    private readonly resetOptionsMenu;
	    /** Marks items selected on the table, this function is triggered by changes initiated by a pagination or reset
	     * event
	     **/
	    private readonly selectTableItems;
	    private readonly insertDataSourceIntoTable;
	    private readonly updateColumnValidation;
	    private readonly getUnknownLastRow;
	    private readonly getRowCount;
	    private readonly isNavigationPanel;
	    /**
	     * Ag-grid callback which is triggered whenever the table component needs new data from our framework
	     * @param getRowsParams
	     */
	    private readonly getRows;
	    private readonly serverSideDataSource;
	    private readonly isDisabled;
	    private readonly isReadOnly;
	    private readonly resizeListener;
	    /**
	     * Ag-grid lifecycle event listener. It is triggered when the table is prepared with the initial rendering of the
	     * controller components and is ready to receive data.
	     **/
	    private readonly onGridReady;
	    private readonly setPhantomRow;
	    /**
	     * Gets the IDs of all rows that have been selected.
	     *
	     * @private
	     * @memberof DesktopTableComponent
	     */
	    private readonly getSelectedIds;
	    private readonly onSelectAll;
	    private readonly onUnselectAll;
	    private readonly onSwitchView;
	    private readonly onSwitchCalendarView;
	    private readonly updateSelectedRows;
	    private readonly processSelectedGroupState;
	    private readonly toggleFullGroupSelection;
	    private readonly handleRowSelection;
	    private readonly notifyNewSelection;
	    /**
	     * Event listener, triggered when the user clicks the checkbox on the front of the row. Both for selection and
	     * deselection.
	     * */
	    private readonly onSelectionChange;
	    private readonly handleFilterChanged;
	    private readonly handleColumnRowGroupChanged;
	    private readonly setShouldResetTable;
	    private readonly onOptionsMenuItemChange;
	    private readonly getRowId;
	    private readonly onViewportChanged;
	    private readonly getRowClass;
	    private readonly gridOptions;
	    private readonly getColumnDefinitions;
	    private readonly hasFilterableColumns;
	    private readonly toggleFloatingFilters;
	    private readonly exportToExcelWithInfiniteScroll;
	    private readonly exportToExcelWithPagination;
	    private readonly exportToExcel;
	    private readonly getCacheBlockSize;
	    private readonly isServerSideGroup;
	    private readonly excludeInternalColumnsFilter;
	    private readonly getAllColumnIds;
	    private readonly getAllDisplayedColumnIds;
	    autoSizeAllColumns: (gridApi?: GridApi | null) => void;
	    private readonly onFirstDataRendered;
	    private readonly canBeGroupedBy;
	    private readonly ungroupByColumn;
	    private readonly groupByColumn;
	    private readonly updateColDefsStates;
	    private readonly sortColumns;
	    private readonly getGroupByMenuItem;
	    private readonly getMainMenuItems;
	    onCellFocused: (params: CellFocusedEvent) => void;
	    onCellKeyDown: (event: CellKeyDownEvent) => void;
	    getAllNotVisibleNotHiddenColumns: (tableProperties: InternalTableProperties) => string[];
	    hideUnhideColumns: (event?: ColumnEverythingChangedEvent) => void;
	    isColumnHidden: (colBind?: string) => boolean;
	    onFilterByErrors: () => Promise<void>;
	    onUnsetFilterByErrors: () => Promise<void>;
	    getDefaultHeight: () => number;
	    private readonly adjustTableHeight;
	    /**
	     * This method is triggered if the user clicks or tabs outside the table. If this happens we want to stop editing the cell in order
	     * to trigger onCellEditingStopped from ag-grid.
	     */
	    private readonly onBlurTable;
	    private readonly clearSelection;
	    initColumnState(): Promise<void>;
	    updateColumnState(): Promise<void>;
	    private readonly onColumnPanelHiddenStateChange;
	    private readonly onColumnPanelOrderChangeChange;
	    private readonly onSortChanged;
	    renderCalendarView(): React.ReactNode;
	    private readonly onCellClicked;
	    private readonly onCellEditingStopped;
	    private readonly onColumnResized;
	    private readonly onOpenColumnPanel;
	    private readonly onCloseColumnPanel;
	    private readonly noRowsOverlayComponentParams;
	    private readonly onRowClicked;
	    private readonly rowClassRules;
	    private readonly isInfiniteScroll;
	    render(): React.ReactNode;
	}
	export const ConnectedDesktopTableComponent: import("react-redux").ConnectedComponent<typeof DesktopTableComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<DesktopTableComponent> | undefined;
	    accessBindings: import("../../../service/page-definition").AccessBindings;
	    additionalLookupRecords?: (() => import("../../types").PartialCollectionValueWithIds<any>[]) | undefined;
	    activeLookupDialog?: import("../../../redux/state").FocusPosition | null | undefined;
	    api?: GridApi<any> | undefined;
	    bulkActions?: import("../../control-objects").BulkAction[] | undefined;
	    canDragCard?: boolean | undefined;
	    contextType?: ContextType | undefined;
	    dataTypes: Dict<import("../../../service/metadata-types").DataTypeDetails>;
	    elementId: string;
	    emptyStateClickableText?: string | undefined;
	    emptyStateText?: string | undefined;
	    enumTypes: Dict<string[]>;
	    errorMessage?: string | undefined;
	    fieldProperties: InternalTableProperties<import("../../../service/screen-base").ScreenBase<any, any>, any>;
	    filterModel?: any;
	    fixedHeight?: number | undefined;
	    graphApi?: import("../../..").GraphQLApi<any> | undefined;
	    groupByField?: any;
	    groupTitle?: string | undefined;
	    isAutoSelectEnabled?: boolean | undefined;
	    isInFocus?: boolean | undefined;
	    isNavPanel?: boolean | undefined;
	    isParentDisabled?: boolean | undefined;
	    isReadOnly?: import("../../../utils/types").ValueOrCallbackWithFieldValue<import("../../../service/screen-base").ScreenBase<any, any>, boolean> | undefined;
	    isUsingInfiniteScroll?: boolean | undefined;
	    locale: import("@sage/xtrem-shared").LocalizeLocale;
	    lookupSelectionMode?: "multiple" | "single" | undefined;
	    nodeTypes: Dict<import("../../../service/metadata-types").FormattedNodeDetails>;
	    numberOfVisibleRows?: number | undefined;
	    onEmptyStateClickableText?: (() => void) | undefined;
	    onFocus?: ((screenId: string, elementId: string, row: string, nestedField: string) => void) | undefined;
	    onRowClick?: import("./table-component-types").OnRowClickFunction | undefined;
	    recordContext?: any;
	    openedRecordId?: string | number | null | undefined;
	    pageNode?: import("../../../types").NodePropertyType | undefined;
	    screenId: string;
	    searchText?: string | undefined;
	    selectedRecordId?: string | number | boolean | undefined;
	    selectedOptionsMenuItem?: OptionsMenuItem<any> | undefined;
	    setFieldProperties?: ((elementId: string, properties: InternalTableProperties<import("../../../service/screen-base").ScreenBase<any, any>, any>) => void) | undefined;
	    setGlobalLoading?: ((setGlobalLoading: boolean) => void) | undefined;
	    setTableViewColumnHidden?: ((level: number, columnHidden?: Dict<boolean> | undefined) => void) | undefined;
	    setTableViewColumnOrder?: ((level: number, columnOrder?: string[] | undefined) => void) | undefined;
	    setTableViewFilter?: ((level: number, filter?: any) => void) | undefined;
	    setTableViewGrouping?: ((level: number, grouping?: TableViewGrouping | undefined) => void) | undefined;
	    setTableViewOptionsMenuItem?: ((level: number, optionsMenuItem?: OptionsMenuItem<any> | undefined) => void) | undefined;
	    setTableViewSearchText?: ((level: number, searchText: string) => void) | undefined;
	    setTableViewSortOrder?: ((level: number, sortOrder?: TableViewSortedColumn[] | undefined) => void) | undefined;
	    setTableViewOptionsMenuItemAndViewFilter?: ((level: number, optionsMenuItem?: OptionsMenuItem<any> | undefined, filter?: any) => void) | undefined;
	    tableViews?: Dict<import("../../../redux/state").TableView> | undefined;
	    username?: string | undefined;
	    validationErrors: import("../../../service/screen-base-definition").ValidationResult[];
	    value: import("../../../service/collection-data-service").CollectionValue<any>;
	    onTelemetryEvent?: import("../../../redux/state").OnTelemetryEventFunction | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedDesktopTableComponent;
	//# sourceMappingURL=desktop-table-component.d.ts.map
}
declare module 'lib/component/field/table/async-desktop-table-component' {
	import * as React from 'react';
	import type { TableInternalComponentProps } from 'lib/component/field/table/table-component-types';
	export function AsyncDesktopTableComponent(props: TableInternalComponentProps): React.ReactElement;
	//# sourceMappingURL=async-desktop-table-component.d.ts.map
}
declare module 'lib/component/field/table/table-component' {
	import * as React from 'react';
	import type { NestedRecordId } from 'lib/types';
	import type { CollectionItem } from 'lib/component/types';
	import type { TableComponentProps } from 'lib/component/field/table/table-component-types';
	export class TableComponent extends React.Component<TableComponentProps> {
	    componentDidMount(): void;
	    getComponentClass: () => string;
	    onRowClick: (recordId: NestedRecordId, newRecord?: CollectionItem, isModifierKeyPushed?: boolean) => () => void;
	    render(): React.ReactNode;
	}
	export const ConnectedTableComponent: import("react-redux").ConnectedComponent<typeof TableComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<TableComponent> | undefined;
	    bulkActions?: import("../../control-objects").BulkAction[] | undefined;
	    mobilePerformInitialLoadTableData?: boolean | undefined;
	    searchText?: string | undefined;
	    errorMessage?: string | undefined;
	    isParentDisabled?: boolean | undefined;
	    lookupSelectionMode?: "multiple" | "single" | undefined;
	    bind?: any;
	    elementId: string;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: import("../../../types").ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedTableComponent;
	//# sourceMappingURL=table-component.d.ts.map
}
declare module 'lib/component/field/table/async-table-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { TableComponentProps } from 'lib/component/field/table/table-component-types';
	export function AsyncConnectedTableComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncTableComponent(props: TableComponentProps): React.ReactElement;
	//# sourceMappingURL=async-table-component.d.ts.map
}
declare module 'lib/component/ui/lookup-dialog/lookup-dialog-utils' {
	export const CLASS_NAME_LOOKUP_DIALOG = "e-lookup-dialog";
	//# sourceMappingURL=lookup-dialog-utils.d.ts.map
}
declare module 'lib/component/ui/lookup-dialog/lookup-create-new-item' {
	import React from 'react';
	export interface LookupCreateNewItemProps {
	    node?: any;
	    createTunnelLinkText?: string;
	    onCreateNewItemLinkClick?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
	    screenId?: string;
	    isDeviceLessThanM?: boolean;
	}
	export function LookupCreateNewItem({ node, createTunnelLinkText, onCreateNewItemLinkClick, screenId, isDeviceLessThanM, }: LookupCreateNewItemProps): React.ReactElement | null;
	//# sourceMappingURL=lookup-create-new-item.d.ts.map
}
declare module 'lib/component/ui/lookup-dialog/lookup-dialog-component' {
	import type { ClientNode, Dict } from '@sage/xtrem-client';
	import type { LocalizeLocale } from '@sage/xtrem-shared';
	import React from 'react';
	import type { FocusPosition, ReduxResponsive } from 'lib/redux/state';
	import { CollectionValue } from 'lib/service/collection-data-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { NodePropertyType } from 'lib/types';
	import type { TableProperties } from 'lib/component/field/field-control-objects';
	import type { NestedField } from 'lib/component/nested-fields';
	import type { CollectionItem, PartialCollectionValueWithIds } from 'lib/component/types';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { ReferenceDecoratorProperties } from 'lib/component/decorator-properties';
	export interface LookupDialogExternalProps<T extends ClientNode = any> {
	    /** Whether the lookup dialog is open */
	    isOpen: boolean;
	    isMultiSelect?: boolean;
	    contextNode?: NodePropertyType;
	    fieldId: string;
	    fieldProperties: ReferenceDecoratorProperties<ScreenBase, T>;
	    isLinkCreateNewText?: boolean;
	    parentElementId?: string;
	    recordContext?: Dict<any>;
	    screenId: string;
	    searchText?: string;
	    selectedRecordId?: string | string[];
	    valueField?: any;
	    closeLookupDialog: () => void;
	    onSelectionFinished: (selectedValue?: CollectionItem[]) => void;
	    level?: number;
	    value?: CollectionValue;
	    createTunnelLinkText?: string;
	    onCreateNewItemLinkClick?: () => void;
	}
	export interface LookupDialogProps<T extends ClientNode = any> extends LookupDialogExternalProps<T> {
	    browser: ReduxResponsive;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    enumTypes: Dict<string[]>;
	    dataTypes: Dict<DataTypeDetails>;
	    onOpenLookupDialog: (dialogDetails: FocusPosition & {
	        dialogTitle: string;
	        onClose: () => void;
	    }) => void;
	    onCloseLookupDialog: () => void;
	    screenDefinition: ScreenBaseDefinition;
	    locale: LocalizeLocale;
	}
	export interface LookupDialogState {
	    value: CollectionValue | null;
	    appliedSearchText: string;
	    selectedItems: string[];
	}
	export class LookupDialog<T extends ClientNode = any> extends React.Component<LookupDialogProps<T>, LookupDialogState> {
	    constructor(props: LookupDialogProps<T>);
	    componentDidMount(): Promise<void>;
	    componentDidUpdate(prevProps: LookupDialogProps<T>): Promise<void>;
	    componentDidCatch(err: Error): void;
	    componentWillUnmount(): void;
	    onClose: () => void;
	    onRowClick: (selected: CollectionItem) => void;
	    onFinishSelection: () => void;
	    loadTableData: (elementId: string, appliedSearchText?: string) => Promise<CollectionValue | null>;
	    setFieldProperties: (_elementId: string, fieldProperties: TableProperties) => void;
	    getColumns: () => NestedField<any, any>[];
	    onKeyDown: <ElementT extends Element>(event: React.KeyboardEvent<ElementT>) => void;
	    getDialogTitle: () => string;
	    getTemporaryRecords: () => PartialCollectionValueWithIds<any>[];
	    populateDialog(): Promise<void>;
	    renderContent(): JSX.Element;
	    render(): React.ReactNode;
	} const _default: new <T extends ClientNode = any>() => React.Component<LookupDialogExternalProps<T>, LookupDialogState>;
	export default _default;
	//# sourceMappingURL=lookup-dialog-component.d.ts.map
}
declare module 'lib/component/field/reference/reference-component' {
	/// <reference types="lodash" />
	import type { ClientNode } from '@sage/xtrem-client';
	import type { UseComboboxStateChangeTypes } from 'downshift';
	import * as React from 'react';
	import { ContextType } from 'lib/types';
	import type { CarbonLinkEvent } from 'lib/utils/types';
	import type { CollectionItem } from 'lib/component/types';
	import type { PortraitSize } from 'lib/component/ui/portrait-component';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import { EditableFieldBaseComponent } from 'lib/component/field/field-base-component';
	import type { ConnectedReferenceComponentProps, ReferenceComponentState, ReferenceDecoratorProperties } from 'lib/component/field/reference/reference-types';
	export class ReferenceComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<ReferenceDecoratorProperties<any, T>, T, ConnectedReferenceComponentProps<T>, ReferenceComponentState> {
	    private readonly lookupButtonRef;
	    private searchText;
	    private readonly selectInputRef;
	    constructor(props: ConnectedReferenceComponentProps<T>);
	    private readonly onInputValueChanged;
	    componentDidMount(): void;
	    getIsReferenceDialogOpen: () => boolean;
	    onChange: (collectionItem: CollectionItem | undefined, isOrganicChange: boolean) => void;
	    onMobileButtonClick: (event: React.MouseEvent<HTMLElement>) => void;
	    private handleAutoSelection;
	    mobileAutoSelect: import("lodash").DebouncedFunc<(type?: UseComboboxStateChangeTypes) => Promise<void>>;
	    onButtonClick: (event: CarbonLinkEvent) => void;
	    openLookupDialog: () => void;
	    closeLookupDialog: (cb?: () => void) => Promise<void>;
	    onLookupDialogSelectionFinished: ([selectedRecord]: SelectItem[]) => void;
	    hasLookupIcon: () => boolean;
	    isLookupDialogOpen: () => boolean;
	    isLookupDialogOpenMobile: () => boolean;
	    isReadOnlyAndHasPicture: () => boolean;
	    render(): React.ReactNode;
	    handleOnCreateNewItemLinkClick: () => void;
	    renderMobile: (className: string) => React.ReactNode;
	    onOpenTunnel: (isNew?: boolean) => Promise<void>;
	    getHelperTextLink: () => string | undefined;
	    onMobileInputChange: (searchText: string, type?: UseComboboxStateChangeTypes) => Promise<void>;
	    onInputChange: (searchText: string, type?: UseComboboxStateChangeTypes) => Promise<void>;
	    getPortraitSize: () => PortraitSize;
	    getItems: (filterValue: string) => Promise<SelectItem[]>;
	    getMinLookupCharacters: () => number;
	    renderDesktop: (className: string) => React.ReactNode;
	    isRelatedTargetEqualTo: (e: React.FocusEvent<HTMLInputElement>, input: string) => boolean;
	}
	export const ConnectedReferenceComponent: import("react-redux").ConnectedComponent<typeof ReferenceComponent, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<ReferenceComponent<ClientNode>> | undefined;
	    bind?: any;
	    elementId: string;
	    isParentDisabled?: boolean | undefined;
	    isParentHidden?: boolean | undefined;
	    fixedHeight?: number | undefined;
	    item?: import("../../..").PageArticleItem | undefined;
	    screenId: string;
	    contextType?: ContextType | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    availableColumns?: number | undefined;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedReferenceComponent;
	//# sourceMappingURL=reference-component.d.ts.map
}
declare module 'lib/component/field/reference/async-reference-component' {
	import * as React from 'react';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { ReferenceComponentProps } from 'lib/component/field/reference/reference-types';
	export function AsyncConnectedReferenceComponent(props: FieldComponentExternalProperties): React.ReactElement;
	export function AsyncReferenceComponent(props: ReferenceComponentProps): React.ReactElement;
	//# sourceMappingURL=async-reference-component.d.ts.map
}
declare module 'lib/render/nested-field-wrapper' {
	import type { AccessStatus, LocalizeLocale } from '@sage/xtrem-shared';
	import * as React from 'react';
	import type { NestedField, NestedFieldHandlersArguments, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FocusPosition } from 'lib/redux/state';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ContextType, NestedRecordId, NodePropertyType } from 'lib/types';
	import type { QueryParameters } from 'lib/utils/types';
	export interface NestedFieldWrapperContextProps {
	    _id: NestedRecordId;
	    contextType?: ContextType;
	    contextNode?: NodePropertyType;
	    handlersArguments?: NestedFieldHandlersArguments;
	    screenId: string;
	    parentElementId: string;
	    setFieldValue: (bind: string, value: any) => Promise<void>;
	    recordContext?: any;
	}
	export interface NestedFieldWrapperExternalProps extends NestedFieldWrapperContextProps {
	    columnDefinition: NestedField<ScreenBase, NestedFieldTypes>;
	    columnName: string;
	    columnProperties: ReadonlyFieldProperties;
	    focusPosition?: FocusPosition | null;
	    isParentReadOnly?: boolean;
	    nestedReadOnlyField?: boolean;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean;
	    validate?: (columnName: string, value: any) => Promise<ValidationResult[]>;
	    validationErrors?: ValidationResult[];
	    value: any;
	}
	export interface NestedFieldWrapperProps extends NestedFieldWrapperExternalProps {
	    focusPosition?: FocusPosition | null;
	    accessRule?: AccessStatus;
	    locale: LocalizeLocale;
	    onFocus: (screenId: string, elementId: string, row: string, nestedField: string) => void;
	    navigate: (path: string, queryParameters?: QueryParameters) => void;
	    updateNestedFieldValidationErrors: (screenId: string, elementId: string, errors: ValidationResult[], columnName: string, recordId?: string) => void;
	}
	export class NestedFieldWrapper extends React.Component<NestedFieldWrapperProps> {
	    removeNonNestedErrors: (_bind: string) => undefined;
	    validate: (columnName: string, value: any) => Promise<ValidationResult[]>;
	    renderElement(): JSX.Element | undefined;
	    render(): React.ReactNode;
	}
	export const ConnectedNestedFieldWrapper: import("react-redux").ConnectedComponent<typeof NestedFieldWrapper, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<NestedFieldWrapper> | undefined;
	    columnDefinition: NestedField<ScreenBase, NestedFieldTypes>;
	    columnName: string;
	    columnProperties: ReadonlyFieldProperties;
	    focusPosition?: FocusPosition | null | undefined;
	    isParentReadOnly?: boolean | undefined;
	    nestedReadOnlyField?: boolean | undefined;
	    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
	    validate?: ((columnName: string, value: any) => Promise<ValidationResult[]>) | undefined;
	    validationErrors?: ValidationResult[] | undefined;
	    value: any;
	    _id: NestedRecordId;
	    contextType?: ContextType | undefined;
	    contextNode?: NodePropertyType | undefined;
	    handlersArguments?: NestedFieldHandlersArguments | undefined;
	    screenId: string;
	    parentElementId: string;
	    setFieldValue: (bind: string, value: any) => Promise<void>;
	    recordContext?: any;
	    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	//# sourceMappingURL=nested-field-wrapper.d.ts.map
}
declare module 'lib/component/ui/card/card-component' {
	import type { ClientNode } from '@sage/xtrem-client';
	import * as React from 'react';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ContextType } from 'lib/types';
	import type { CollectionItemAction, CollectionItemActionGroup, InlineCollectionItemAction } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import type { NestedField, NestedFieldTypes, NestedFieldTypesWithoutTechnical } from 'lib/component/nested-fields';
	import type { FieldKey } from 'lib/component/types';
	import type { PortraitPlaceholderMode } from 'lib/component/ui/portrait-component';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { MenuSeparatorType } from 'lib/component/container/page/page-types';
	export const getNestedValue: (value: any, bind: string) => any;
	export interface CardDefinition<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
	    title: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    titleRight?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line2?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line2Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line3?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line3Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    image?: NestedField<CT, FieldKey.Image | FieldKey.Icon, NodeType>;
	    progressBar?: NestedField<CT, FieldKey.Progress, NodeType>;
	    [key: string]: NestedField<CT, NestedFieldTypes, NodeType> | undefined;
	}
	export interface CardExtensionDefinition<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
	    title?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    titleRight?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line2?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line2Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line3?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    line3Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
	    image?: NestedExtensionField<CT, FieldKey.Image | FieldKey.Icon, NodeType>;
	    [key: string]: NestedExtensionField<CT, NestedFieldTypes, NodeType> | undefined;
	}
	export interface CardComponentProps<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
	    buttonRef?: React.RefObject<HTMLButtonElement>;
	    canDrag?: boolean;
	    canSelect?: boolean;
	    cardDefinition: CardDefinition<CT, any>;
	    contextType?: ContextType;
	    id?: string;
	    isInFocus?: boolean;
	    isSelected?: boolean;
	    isNewItem?: boolean;
	    isDisabled?: boolean;
	    imagePlaceholderValue?: string;
	    imagePlaceholderMode?: PortraitPlaceholderMode;
	    /** If the element is clickable then it is rendered into a button element, if not then into a div element */
	    onCardClick?: (recordValue: any, isModifierKeyPushed: boolean) => void;
	    onSelect?: (recordValue: any) => void;
	    parentElementId: string;
	    inlineActions?: Array<InlineCollectionItemAction<ScreenBase>>;
	    dropdownActions?: Array<CollectionItemAction<ScreenBase> | CollectionItemActionGroup<ScreenBase> | MenuSeparatorType>;
	    screenId: string;
	    shouldDisplayAlphabeticalDivider?: boolean;
	    value: NodeType;
	    isClickIndicatorHidden?: boolean;
	}
	export const CardComponent: React.MemoExoticComponent<(<CT extends ScreenBase<any, any> = ScreenBase<any, any>, NodeType extends ClientNode = any>(props: CardComponentProps<CT, NodeType>) => React.JSX.Element)>;
	//# sourceMappingURL=card-component.d.ts.map
}
declare module 'lib/component/ui/calendar-body/calendar-body-types' {
	import type { EventContentArg, EventInput } from '@fullcalendar/core';
	import type { CollectionValue, GridLodable } from 'lib/service/collection-data-service';
	import type { ValueOrCallbackWitRecordValue } from 'lib/utils/types';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { Dict } from '@sage/xtrem-shared';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	import type { HasCalendarConfigurationOptions } from 'lib/component/field/traits';
	export const calendarViews: Dict<() => string>;
	export type CalendarView = keyof typeof calendarViews;
	export interface CalendarEvent extends EventInput {
	    allDay?: boolean;
	    end: Date | string;
	    start: Date | string;
	    _id: string;
	}
	export interface CalendarBodyComponentProps extends HasCalendarConfigurationOptions<any> {
	    cardColor?: ValueOrCallbackWitRecordValue<any, string>;
	    elementId: string;
	    eventCard: CardDefinition;
	    fieldProperties: GridLodable;
	    fixedHeight?: number;
	    hasClickEventListener?: boolean;
	    isGreaterThanSmall: boolean;
	    onEventClick?: (_id: string, eventDetails: any, isModifierKeyPushed?: boolean) => void;
	    screenId: string;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    selectedView?: CalendarView;
	    value?: CollectionValue;
	    filterModel?: any;
	}
	export interface CalendarEventCardProps {
	    elementId: string;
	    eventProps: EventContentArg;
	    isMobileMonthlyView: boolean;
	    selectedView: CalendarView;
	    value?: CollectionValue;
	    screenId: string;
	    hasClickEventListener?: boolean;
	    cardColor?: ValueOrCallbackWitRecordValue<any, string>;
	    eventCard: CardDefinition;
	}
	//# sourceMappingURL=calendar-body-types.d.ts.map
}
declare module 'lib/component/field/calendar/calendar-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { Filter } from 'lib/service/filter-service';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { NestedRecordId, ScreenBaseGenericType } from 'lib/types';
	import type { DatePropertyValue } from 'lib/utils/types';
	import type { BlockControlObject, CollectionValueFieldProperties } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance } from 'lib/component/types';
	import type { BaseReadonlyComponentProperties } from 'lib/component/field/field-base-component-types';
	import type { ExtensionField, HasCalendarConfigurationOptions, HasFieldActions, HasGenericErrorHandler, HasParent, Mappable } from 'lib/component/field/traits';
	import type { CalendarView } from 'lib/component/ui/calendar-body/calendar-body-types';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export interface CalendarProperties<CT extends ScreenBase = ScreenBase, CalendarEventType extends ClientNode = any> extends CollectionValueFieldProperties<CT>, HasCalendarConfigurationOptions<CT, CalendarEventType> {
	    startDateField: PropertyValueType<CalendarEventType>;
	    /** The definitions of the nested fields used to represent the calendar events */
	    eventCard: CardDefinition<CT, CalendarEventType>;
	    /** Event handler that will be called when a day is clicked */
	    onDayClick?: (this: CT, date: Date) => void;
	    /** Event handler that will be called when an event is clicked */
	    onEventClick?: (this: CT, _id: string, event: CalendarEventType, isModifierKeyPushed: boolean) => void;
	    /** The GraphQL node that the table represents, needed for filtering */
	    node?: keyof ScreenBaseGenericType<CT>;
	    /** Whether the events of the calendar can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	}
	export interface InternalCalendarProperties<CT extends ScreenBase = ScreenBase> extends CalendarDecoratorProperties<CT> {
	    rangeStart: DatePropertyValue;
	    rangeEnd: DatePropertyValue;
	    activeUserFilter?: GraphQLFilter;
	}
	export interface CalendarDecoratorProperties<CT extends ScreenBase = ScreenBase, CalendarEventType extends ClientNode = any> extends CalendarProperties<CT, CalendarEventType>, HasFieldActions<CT>, Mappable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasGenericErrorHandler<CT>, HasParent<CT, BlockControlObject<CT>> {
	}
	export type BaseCalendarExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase, CalendarEventType extends ClientNode = any> = {
	    onDayClickAfter?: (this: CT, date: Date) => void;
	    onEventClickAfter?: (this: CT, _id: NestedRecordId, event: CalendarEventType, isModifierKeyPushed: boolean) => void;
	};
	export interface CalendarComponentAdditionalProps {
	    isGreaterThanSmall: boolean;
	    loading: boolean;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    selectedRecordId: string | null;
	    setFieldProperties: (elementId: string, value: InternalCalendarProperties) => void;
	}
	export type CalendarComponentProps = BaseReadonlyComponentProperties<CalendarDecoratorProperties, CollectionValue, CalendarComponentAdditionalProps>;
	export type CalendarComponentInternalProps = CalendarComponentProps & {
	    fieldProperties: InternalCalendarProperties;
	};
	export interface CalendarState {
	    filters: Filter[];
	    firstRender: boolean;
	    selectedRecordId: string | null;
	    selectedView: CalendarView;
	}
	//# sourceMappingURL=calendar-types.d.ts.map
}
declare module 'lib/component/field/calendar/calendar-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { DatePropertyValue } from 'lib/utils/types';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldKey } from 'lib/component/types';
	import { CollectionValueControlObject } from 'lib/component/field/collection-value-field';
	import type { CalendarProperties } from 'lib/component/field/calendar/calendar-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a calendar
	 */
	export class CalendarControlObject<CT extends ScreenExtension<CT> = ScreenBase, CalendarEventType extends ClientNode = any> extends CollectionValueControlObject<FieldKey.Calendar, CalendarEventType, CT, NestedFieldTypes, CalendarProperties<CT, CalendarEventType>> {
	    static readonly defaultUiProperties: Partial<CalendarProperties>;
	    /** Graphql filter that will restrict the events displayed in the calendar */
	    get filter(): GraphQLFilter<CalendarEventType> | undefined;
	    /** Graphql filter that will restrict the events displayed in the calendar */
	    set filter(filter: GraphQLFilter<CalendarEventType> | undefined);
	    /** The maximum date the user is allowed to navigate */
	    get maxDate(): DatePropertyValue | undefined;
	    /** The maximum date the user is allowed to navigate */
	    set maxDate(newValue: DatePropertyValue | undefined);
	    /** The minimum date the user is allowed to navigate */
	    get minDate(): DatePropertyValue | undefined;
	    /** The minimum date the user is allowed to navigate */
	    set minDate(newValue: DatePropertyValue | undefined);
	    refresh(): Promise<void>;
	}
	//# sourceMappingURL=calendar-control-object.d.ts.map
}
declare module 'lib/component/field/card/card-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { CardProperties } from 'lib/component/field/card/card-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
	 */
	export class CardControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Card, FieldComponentProps<FieldKey.Card, CT, NodeType>> {
	    static readonly defaultUiProperties: Partial<CardProperties>;
	    /** The GraphQL node that the field suggestions will be fetched from */
	    get node(): string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    refresh(): Promise<void>;
	    focus(): void;
	}
	//# sourceMappingURL=card-control-object.d.ts.map
}
declare module 'lib/component/field/chart/chart-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { CollectionItem, FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { ChartProperties } from 'lib/component/field/chart/chart-types';
	export interface InternalChartProperties<CT extends ScreenBase = ScreenBase> extends ChartProperties<CT> {
	    /** The GraphQL filter set by the user and applied to the records displayed on the chart */
	    activeUserFilter?: GraphQLFilter;
	}
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a set of read-only values and represents them as a chart
	 */
	export class ChartControlObject<CT extends ScreenExtension<CT> = ScreenBase, NodeType extends ClientNode = any> extends ReadonlyFieldControlObject<CT, FieldKey.Chart, FieldComponentProps<FieldKey.Chart, CT, NodeType>> {
	    static readonly defaultUiProperties: Partial<ChartProperties>;
	    /** Graphql filter that will restrict the records displayed in the chart */
	    get filter(): GraphQLFilter<NodeType> | undefined;
	    /** Graphql filter that will restrict the records displayed in the chart */
	    set filter(filter: GraphQLFilter<NodeType> | undefined);
	    /** Chart values */
	    get value(): CollectionItem[];
	    /** Chart values */
	    set value(newValue: CollectionItem[]);
	    /** Whether the legend should be hidden */
	    isLegendHidden?: boolean;
	    refresh(): Promise<void>;
	}
	//# sourceMappingURL=chart-control-object.d.ts.map
}
declare module 'lib/component/field/checkbox/checkbox-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a boolean value
	 */
	export class CheckboxControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Checkbox, FieldComponentProps<FieldKey.Checkbox>> {
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=checkbox-control-object.d.ts.map
}
declare module 'lib/component/field/content-table/content-table-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { DefaultPropertyType } from '@sage/xtrem-ui-components';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { ContentTableProperties } from 'lib/component/field/content-table/content-table-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a multi-line text value
	 */
	export class ContentTableControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.ContentTable, FieldComponentProps<FieldKey.ContentTable>> {
	    static readonly defaultUiProperties: Partial<ContentTableProperties>;
	    selectedProperties?: Dict<DefaultPropertyType>;
	    node?: string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Refetches data from the server */
	    refresh(): Promise<void>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=content-table-control-object.d.ts.map
}
declare module 'lib/component/field/count/count-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link AbstractField} that holds a reference to an existing GraphQL object. The type of GraphQL object
	 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
	 * properties define which properties of the GraphQL object will be displayed in the field
	 * and will be matched against the user provided text
	 */
	export class CountControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Count, FieldComponentProps<FieldKey.Count>> {
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter | undefined);
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Text to be displayed inline after the field value */
	    prefix?: string;
	    /** Text to be displayed inline before the field value */
	    postfix?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /** Field's value */
	    get value(): number | null;
	    set value(newValue: number | null);
	    refresh(): Promise<void>;
	}
	//# sourceMappingURL=count-control-object.d.ts.map
}
declare module 'lib/component/field/time/time-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
	 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
	 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
	 * be matched against the user provided text.
	 */
	export class TimeControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Time, FieldComponentProps<FieldKey.Time>> {
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    get hours(): number | null;
	    set hours(value: number);
	    get minutes(): number | null;
	    set minutes(value: number);
	    get seconds(): number | null;
	    set seconds(value: number);
	    get value(): string | null;
	    set value(value: string | null);
	}
	//# sourceMappingURL=time-control-object.d.ts.map
}
declare module 'lib/component/field/datetime-range/datetime-range-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Datetime } from '@sage/xtrem-date-time';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { DatetimeRangeValue } from 'lib/component/field/datetime-range/datetime-range-types';
	type AllowableDate = Datetime | Date | string;
	export class DatetimeRangeControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DatetimeRange, FieldComponentProps<FieldKey.DatetimeRange>> {
	    isTimeZoneHidden?: boolean;
	    timeZone?: string;
	    minDate?: AllowableDate;
	    maxDate?: AllowableDate;
	    defaultDate?: AllowableDate;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    get value(): DatetimeRangeValue | null;
	    set value(value: DatetimeRangeValue | null);
	}
	export {};
	//# sourceMappingURL=datetime-range-control-object.d.ts.map
}
declare module 'lib/component/field/date/date-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { DatePropertyValue } from 'lib/utils/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { ScreenExtension } from 'lib/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a date value in the YYYY-MM-DD format
	 */
	export class DateControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Date, FieldComponentProps<FieldKey.Date>> {
	    /** The maximum date value allowed for the date field */
	    get maxDate(): DatePropertyValue | undefined;
	    /** The maximum date value allowed for the date field */
	    set maxDate(newValue: DatePropertyValue | undefined);
	    /** The minimum date value allowed for the date field */
	    get minDate(): DatePropertyValue | undefined;
	    /** The minimum date value allowed for the date field */
	    set minDate(newValue: DatePropertyValue | undefined);
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=date-control-object.d.ts.map
}
declare module 'lib/component/field/detail-list/detail-list-control-object' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { DetailListProperties } from 'lib/component/control-objects';
	import type { DetailListDecoratorProperties } from 'lib/component/decorators';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldKey } from 'lib/component/types';
	export class DetailListControlObject<ItemType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.DetailList, DetailListProperties<CT, ItemType>> {
	    static readonly defaultUiProperties: Partial<DetailListDecoratorProperties>;
	    /** Graphql filter that will restrict the records displayed in the table */
	    get filter(): GraphQLFilter<ItemType> | undefined;
	    /** Graphql filter that will restrict the records displayed in the table */
	    set filter(filter: GraphQLFilter<ItemType> | undefined);
	    refresh(): Promise<void>;
	    /** Detail list items */
	    get value(): Partial<ItemType>[];
	    set value(newValue: Partial<ItemType>[]);
	}
	//# sourceMappingURL=detail-list-control-object.d.ts.map
}
declare module 'lib/component/field/dropdown-list/dropdown-list-control-object' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
	 */
	export class DropdownListControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DropdownList, FieldComponentProps<FieldKey.DropdownList>> {
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Indicator, whether sounds play on successful/erroneous selection */
	    isSoundDisabled?: boolean;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Options to be displayed in the select element */
	    options?: string[];
	    /**
	     * The GraphQL node that the select options will be fetched from.
	     * When using this property, the node must be an Enum
	     */
	    get optionType(): string | undefined;
	    focus(): void;
	    /** Field's value, only valid options can be set as value. */
	    set value(newValue: ReferencedEnumType | null);
	    /** Field's value, only valid options can be set as value. */
	    get value(): ReferencedEnumType | null;
	}
	//# sourceMappingURL=dropdown-list-control-object.d.ts.map
}
declare module 'lib/component/field/dynamic-pod/dynamic-pod-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { DynamicPodProperties } from 'lib/component/field/dynamic-pod/dynamic-pod-types';
	import type { NestedField } from 'lib/component/nested-fields';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
	 */
	export class DynamicPodControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DynamicPod, FieldComponentProps<FieldKey.DynamicPod>> {
	    static readonly defaultUiProperties: Partial<DynamicPodProperties>;
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter<NodeType> | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter<NodeType> | undefined);
	    /** The GraphQL node that the field suggestions will be fetched from */
	    get node(): string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Whether the value of the pod can be unset */
	    canRemove?: boolean;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    refresh(): Promise<void>;
	    focus(): void;
	    /** Set a new list of nested fields to be show in the pod  */
	    setNestedFields(nestedFields: NestedField<any, any>[]): void;
	    /** Add a individual nested field to the end of pod */
	    addNestedField(nestedField: NestedField<any, any>): void;
	    /** Remove the nested field by the bind */
	    removeNestedField(bind: string | Object): void;
	    /** Remove all nested fields */
	    removeAllNestedFields(): void;
	}
	//# sourceMappingURL=dynamic-pod-control-object.d.ts.map
}
declare module 'lib/component/field/file-deposit/file-deposit-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a file stream value
	 */
	export class FileDepositControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FileDeposit, FieldComponentProps<FieldKey.FileDeposit>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.FileDeposit>>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /** File types that can be uploaded. Can be either audio/*, video/*, image/*, an extension name starting with '.'
	     *  or a valid media type. Look at [IANA Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). for a complete list of standard media types.
	     * It is possible to set more than one file type, simply by defining them separated by a comma.
	     */
	    fileTypes?: string;
	}
	//# sourceMappingURL=file-deposit-control-object.d.ts.map
}
declare module 'lib/component/field/file/file-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a file stream value
	 */
	export class FileControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.File, FieldComponentProps<FieldKey.File>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.File>>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /** File types that can be uploaded. Can be either audio/*, video/*, image/*, an extension name starting with '.'
	     *  or a valid media type. Look at [IANA Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). for a complete list of standard media types.
	     * It is possible to set more than one file type, simply by defining them separated by a comma.
	     */
	    fileTypes?: string;
	    /**
	     * Name of the uploaded file
	     *
	     */
	    text: string;
	}
	//# sourceMappingURL=file-control-object.d.ts.map
}
declare module 'lib/component/field/filter-editor/filter-editor-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode, Dict } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { FilterEditorProperties } from 'lib/component/field/filter-editor/filter-editor-types';
	import type { DefaultPropertyType, FilterParameter } from '@sage/xtrem-ui-components';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
	 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
	 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
	 * be matched against the user provided text.
	 */
	export class FilterEditorControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FilterEditor, FieldComponentProps<FieldKey.FilterEditor>> {
	    static readonly defaultUiProperties: Partial<FilterEditorProperties>;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    selectedProperties?: Dict<DefaultPropertyType>;
	    filterParameters?: FilterParameter[];
	    parameterMode?: 'creation' | 'usage';
	    node?: string;
	    /** Refetches data from the server */
	    refresh(): Promise<void>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=filter-editor-control-object.d.ts.map
}
declare module 'lib/component/field/filter-select/filter-select-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FilterSelectProperties } from 'lib/component/field/filter-select/filter-select-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
	 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
	 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
	 * be matched against the user provided text.
	 */
	export class FilterSelectControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FilterSelect, FieldComponentProps<FieldKey.FilterSelect>> {
	    static readonly defaultUiProperties: Partial<FilterSelectProperties>;
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined);
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /** Indicator, whether field can generate value for to be created node */
	    isNewEnabled?: boolean;
	    /** Indicator, whether sounds play on successful/erroneous selection */
	    isSoundDisabled?: boolean;
	    /** The maximum length of the filter select field value */
	    maxLength?: number;
	    /** The minimum length of the filter select field value */
	    minLength?: number;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Lookup Dialog title **/
	    lookupDialogTitle?: string;
	    /** Refetches data from the server */
	    refresh(): Promise<void>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    fetchSuggestions(searchText: string): Promise<Partial<ReferencedItemType>[]>;
	}
	//# sourceMappingURL=filter-select-control-object.d.ts.map
}
declare module 'lib/component/field/form-designer/form-designer-control-object' {
	import type { FilterParameter } from '@sage/xtrem-ui-components';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { PaperOrientation, PaperSize } from '@sage/xtrem-document-editor';
	export class FormDesignerControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FormDesigner, FieldComponentProps<FieldKey.FormDesigner>> {
	    /** Document editor parameters */
	    parameters: FilterParameter[];
	    /** Paper orientation of the editor view, defaults to portrait */
	    paperOrientation: PaperOrientation;
	    /** Paper size of the editor view, defaults to A4 */
	    paperSize: PaperSize;
	    /** HTML content of the header */
	    headerValue: string;
	    /** HTML content of the footer */
	    footerValue: string;
	    /** Top margin in centimeters */
	    marginTop: number;
	    /** Bottom margin in centimeters */
	    marginBottom: number;
	    /** Right margin in centimeters */
	    marginRight: number;
	    /** Left margin in centimeters */
	    marginLeft: number;
	    executeEditorCommand(command: string, ...args: any[]): void;
	}
	//# sourceMappingURL=form-designer-control-object.d.ts.map
}
declare module 'lib/component/field/icon/icon-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { ScreenExtension } from 'lib/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { IconBackgroundShape, IconBackgroundSize } from 'lib/component/field/icon/icon-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a graphic icon
	 */
	export class IconControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Icon, FieldComponentProps<FieldKey.Icon>> {
	    /** The background color of the HTML field */
	    backgroundColor?: string;
	    /** The font color of the HTML field */
	    color?: string;
	    /** The background shape of the icon */
	    backgroundShape?: IconBackgroundShape;
	    /** The background shape of the icon */
	    backgroundSize?: IconBackgroundSize;
	}
	//# sourceMappingURL=icon-control-object.d.ts.map
}
declare module 'lib/component/field/image/image-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds an image
	 */
	export class ImageControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Image, FieldComponentProps<FieldKey.Image>> {
	    /** The value of the height attribute of the HTML image (e.g. 100px, 75%, auto, etc.)*/
	    get height(): string | undefined;
	}
	//# sourceMappingURL=image-control-object.d.ts.map
}
declare module 'lib/component/field/label/label-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import { LabelProperties } from 'lib/component/field/label/label-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a read-only text value
	 */
	export class LabelControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Label, FieldComponentProps<FieldKey.Label>> {
	    /** The border color of the label */
	    borderColor?: string;
	    /** The background color of the HTML field */
	    backgroundColor?: string;
	    /** The font color of the HTML field */
	    color?: string;
	    /** Text to be displayed inline after the field value */
	    prefix?: string;
	    /** Text to be displayed inline before the field value */
	    postfix?: string;
	    /** Field's value, only valid options can be set as value. */
	    set value(newValue: ReferencedEnumType | null);
	    /** Field's value, only valid options can be set as value. */
	    get value(): ReferencedEnumType | null;
	}
	export { LabelProperties };
	//# sourceMappingURL=label-control-object.d.ts.map
}
declare module 'lib/component/field/link/link-control-object' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { QueryParameters } from 'lib/utils/types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a link to another page
	 */
	export class LinkControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Link, FieldComponentProps<FieldKey.Link>> {
	    /** The page to navigate to on link click */
	    page?: string;
	    queryParameters?: QueryParameters;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=link-control-object.d.ts.map
}
declare module 'lib/component/field/message/message-control-object' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { MessageVariant } from 'lib/component/field/message/message-types';
	export class MessageControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Message, FieldComponentProps<FieldKey.Message>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.Message>>;
	    content?: string;
	    variant?: MessageVariant;
	}
	//# sourceMappingURL=message-control-object.d.ts.map
}
declare module 'lib/component/field/multi-dropdown/multi-dropdown-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
	 */
	export class MultiDropdownControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.MultiDropdown, FieldComponentProps<FieldKey.MultiDropdown>> {
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /** Indicator, whether sounds play on successful/erroneous selection */
	    isSoundDisabled?: boolean;
	    /** Options to be displayed in the MultiDropdown element */
	    options?: string[];
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Text to be displayed inline after the field value */
	    prefix?: string;
	    /** Text to be displayed inline before the field value */
	    postfix?: string;
	    /**  The minimum number of items that has to be selected*/
	    minItems?: number;
	    /**  The maximum number of items that has to be selected*/
	    maxItems?: number;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=multi-dropdown-control-object.d.ts.map
}
declare module 'lib/component/field/multi-file-deposit/multi-file-deposit-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldKey, AttachmentAssociation } from 'lib/component/types';
	import { CollectionValueControlObject } from 'lib/component/field/collection-value-field';
	import type { MultiFileDepositProperties } from 'lib/component/field/multi-file-deposit/multi-file-deposit-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
	 */
	export class MultiFileDepositControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.MultiFileDeposit, AttachmentAssociation, CT, NestedFieldTypes, MultiFileDepositProperties<CT>> {
	    canAddRecord?: boolean;
	    canRemoveRecord?: boolean;
	    /**
	     * Whether the field is editable (isReadOnly = false) or not (isReadOnly = true)
	     *
	     * The difference with disabled is that isReadOnly suggests that the field is never editable
	     * (e.g. the id field of an object)
	     */
	    isReadOnly: boolean;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    get node(): string;
	    addFiles(_files: File[]): Promise<void>;
	}
	//# sourceMappingURL=multi-file-deposit-control-object.d.ts.map
}
declare module 'lib/component/field/multi-reference/multi-reference-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey, PartialCollectionValue } from 'lib/component/types';
	import type { MultiReferenceDecoratorProperties } from 'lib/component/field/multi-reference/multi-reference-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a reference to an existing GraphQL object. The type of GraphQL object
	 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
	 * properties define which properties of the GraphQL object will be displayed in the field
	 * and will be matched against the user provided text
	 */
	export class MultiReferenceControlObject<MultiReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.MultiReference, FieldComponentProps<FieldKey.MultiReference>> {
	    static readonly defaultUiProperties: Partial<MultiReferenceDecoratorProperties>;
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter<MultiReferencedItemType> | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter<MultiReferencedItemType> | undefined);
	    /** The GraphQL node property that will be displayed below the reference field */
	    get helperTextField(): string | undefined;
	    /** The GraphQL node property that will be used to display an image in front of the values. t*/
	    get imageField(): string | undefined;
	    /** The GraphQL node that the field suggestions will be fetched from */
	    get node(): string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /** Indicator, whether sounds play on successful/erroneous selection */
	    isSoundDisabled?: boolean;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /**  The minimum number of items that has to be selected*/
	    minItems?: number;
	    /**  The maximum number of items that has to be selected*/
	    maxItems?: number;
	    /** Lookup Dialog title **/
	    lookupDialogTitle?: string;
	    /** Field's value */
	    get value(): PartialCollectionValue<MultiReferencedItemType>[];
	    /** Field's value */
	    set value(newValues: PartialCollectionValue<MultiReferencedItemType & {
	        $id: string;
	    }>[]);
	    /** The GraphQL node property that will be used as the reference field value */
	    get valueField(): string | undefined;
	    refresh(): Promise<void>;
	    focus(): void;
	    openDialog(): void;
	    fetchSuggestions(searchText: string): Promise<PartialCollectionValue<MultiReferencedItemType>[]>;
	}
	//# sourceMappingURL=multi-reference-control-object.d.ts.map
}
declare module 'lib/component/field/node-browser-tree/node-browser-tree-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldKey, FieldComponentProps } from 'lib/component/types';
	import type { NodeBrowserTreeDecoratorProperties } from 'lib/component/field/node-browser-tree/node-browser-tree-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
	 */
	export class NodeBrowserTreeControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.NodeBrowserTree, FieldComponentProps<FieldKey.NodeBrowserTree>> {
	    static readonly defaultUiProperties: Partial<NodeBrowserTreeDecoratorProperties>;
	    node: keyof ScreenBaseGenericType<CT>;
	}
	//# sourceMappingURL=node-browser-tree-control-object.d.ts.map
}
declare module 'lib/component/field/numeric/numeric-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that contains a numeric value
	 */
	export class NumericControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Numeric, FieldComponentProps<FieldKey.Numeric>> {
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /**
	     * Number of digits after the numeric field value decimal point.
	     * Must be in the range 0 - 20, inclusive.
	     */
	    scale?: number;
	    /** Text to be displayed inline after the field value */
	    prefix?: string;
	    /** Text to be displayed inline before the field value */
	    postfix?: string;
	    /** The maximum value allowed for the numeric field */
	    max?: number;
	    /** The minimum value allowed for the numeric field */
	    min?: number;
	    /** The helper text underneath the field */
	    placeholder?: string;
	    /** Validation property, ensures that there is a value in the input that is not equal to zero. */
	    isNotZero?: boolean;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=numeric-control-object.d.ts.map
}
declare module 'lib/component/field/plugin/plugin-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a boolean value
	 */
	export class PluginControlObject<PluginCustomDecoratorProperties extends {} = {}, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Plugin, FieldComponentProps<FieldKey.Plugin>> {
	    setProperty<K extends keyof PluginCustomDecoratorProperties>(property: keyof PluginCustomDecoratorProperties, newValue: PluginCustomDecoratorProperties[K]): void;
	    getProperty<K extends keyof PluginCustomDecoratorProperties>(property: keyof PluginCustomDecoratorProperties): PluginCustomDecoratorProperties[K];
	}
	//# sourceMappingURL=plugin-control-object.d.ts.map
}
declare module 'lib/component/field/pod-collection/pod-collection-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldKey } from 'lib/component/types';
	import { CollectionValueControlObject } from 'lib/component/field/collection-value-field';
	import type { PodCollectionProperties } from 'lib/component/field/pod-collection/pod-collection-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that allows the user to explicitly trigger some action
	 */
	export class PodCollectionControlObject<NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.PodCollection, NestedRecordType, CT, NestedFieldTypes, PodCollectionProperties<CT, NestedRecordType>> {
	    canAddRecord?: boolean;
	    canRemoveRecord?: boolean;
	    addButtonText?: string;
	    removeDialogTitle?: string;
	    removeDialogText?: string;
	    /**
	     * Whether the field is editable (isReadOnly = false) or not (isReadOnly = true)
	     *
	     * The difference with disabled is that isReadOnly suggests that the field is never editable
	     * (e.g. the id field of an object)
	     */
	    isReadOnly: boolean;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    get node(): string;
	}
	//# sourceMappingURL=pod-collection-control-object.d.ts.map
}
declare module 'lib/component/field/pod/pod-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { PodProperties } from 'lib/component/field/pod/pod-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
	 */
	export class PodControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Pod, FieldComponentProps<FieldKey.Pod>> {
	    static readonly defaultUiProperties: Partial<PodProperties<ScreenBase, any>>;
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter<NodeType> | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter<NodeType> | undefined);
	    /** The GraphQL node that the field suggestions will be fetched from */
	    get node(): string;
	    openLookupDialog(): void;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Whether the value of the pod can be unset */
	    canRemove?: boolean;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Lookup Dialog title **/
	    lookupDialogTitle?: string;
	    refresh(): Promise<void>;
	    focus(): void;
	}
	//# sourceMappingURL=pod-control-object.d.ts.map
}
declare module 'lib/component/field/progress/progress-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a numeric value and represents it as a percentage (e.g. progress bar)
	 */
	export class ProgressControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Progress, FieldComponentProps<FieldKey.Progress>> {
	    /**
	     * @deprecated
	     * The font color of the HTML field */
	    color?: string;
	    currentProgressLabel?: string;
	    maxProgressLabel?: string;
	    areProgressLabelsHidden?: boolean;
	}
	//# sourceMappingURL=progress-control-object.d.ts.map
}
declare module 'lib/component/field/radio/radio-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
	 */
	export class RadioControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Radio, FieldComponentProps<FieldKey.Radio>> {
	    /** Options to be displayed in the select element */
	    options?: string[];
	    /**
	     * The GraphQL node that the select options will be fetched from.
	     * When using this property, the node must be an Enum
	     */
	    get optionType(): string | undefined;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /** Field's value, only valid options can be set as value. */
	    set value(newValue: ReferencedEnumType | null);
	    /** Field's value, only valid options can be set as value. */
	    get value(): ReferencedEnumType | null;
	}
	//# sourceMappingURL=radio-control-object.d.ts.map
}
declare module 'lib/component/field/reference/reference-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey, PartialCollectionValue } from 'lib/component/types';
	import type { ReferenceDecoratorProperties } from 'lib/component/field/reference/reference-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a reference to an existing GraphQL object. The type of GraphQL object
	 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
	 * properties define which properties of the GraphQL object will be displayed in the field
	 * and will be matched against the user provided text
	 */
	export class ReferenceControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Reference, FieldComponentProps<FieldKey.Reference>> {
	    static readonly defaultUiProperties: Partial<ReferenceDecoratorProperties<ScreenBase>>;
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined);
	    /** The GraphQL node property that will be displayed below the reference field */
	    get helperTextField(): string | undefined;
	    /** The GraphQL node property that will be used to display an image in front of the values. t*/
	    get imageField(): string | undefined;
	    /** The GraphQL node that the field suggestions will be fetched from */
	    get node(): string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /** Indicator, whether sounds play on successful/erroneous selection */
	    isSoundDisabled?: boolean;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Lookup Dialog title **/
	    lookupDialogTitle?: string;
	    /** Field's value */
	    get value(): PartialCollectionValue<ReferencedItemType> | null;
	    /** Field's value */
	    set value(newValue: PartialCollectionValue<ReferencedItemType> | null);
	    /** The GraphQL node property that will be used as the reference field value */
	    get valueField(): string | undefined;
	    refresh(): Promise<void>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    openDialog(): void;
	    fetchSuggestions(searchText?: string): Promise<PartialCollectionValue<ReferencedItemType>[]>;
	}
	//# sourceMappingURL=reference-control-object.d.ts.map
}
declare module 'lib/component/field/relative-date/relative-date-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a numeric value and represents it as a percentage (e.g. progress bar)
	 */
	export class RelativeDateControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.RelativeDate, FieldComponentProps<FieldKey.RelativeDate>> {
	}
	//# sourceMappingURL=relative-date-control-object.d.ts.map
}
declare module 'lib/component/field/rich-text/rich-text-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { RichTextProperties } from 'lib/component/field/rich-text/rich-text-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a rich, formatted text value
	 */
	export class RichTextControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.RichText, FieldComponentProps<FieldKey.RichText>> {
	    static readonly defaultUiProperties: Partial<RichTextProperties>;
	    /** The value of the height attribute of the HTML image (e.g. 100px, 75%, auto, etc.) */
	    height?: string;
	    /** Field's value */
	    get value(): string;
	    /** Field's value */
	    set value(newValue: string);
	}
	//# sourceMappingURL=rich-text-control-object.d.ts.map
}
declare module 'lib/component/field/select/select-control-object' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
	 */
	export class SelectControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Select, FieldComponentProps<FieldKey.Select>> {
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Color of the icon, only supported in tile containers */
	    iconColor?: string;
	    /** Indicator, whether sounds play on successful/erroneous selection */
	    isSoundDisabled?: boolean;
	    /** Options to be displayed in the select element */
	    options?: string[];
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /**
	     * The GraphQL node that the select options will be fetched from.
	     * When using this property, the node must be an Enum
	     */
	    get optionType(): string | undefined;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /** Field's value, only valid options can be set as value. */
	    set value(newValue: ReferencedEnumType | null);
	    /** Field's value, only valid options can be set as value. */
	    get value(): ReferencedEnumType | null;
	}
	//# sourceMappingURL=select-control-object.d.ts.map
}
declare module 'lib/component/field/selection-card/selection-card-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
	 */
	export class SelectionCardControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.SelectionCard, FieldComponentProps<FieldKey.SelectionCard>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.SelectionCard>>;
	    /** Options to be displayed in the select element */
	    options?: string[];
	    /**
	     * The GraphQL node that the select options will be fetched from.
	     * When using this property, the node must be an Enum
	     */
	    get optionType(): string | undefined;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /** Field's value, only valid options can be set as value. */
	    set value(newValue: string | null);
	    /** Field's value, only valid options can be set as value. */
	    get value(): string | null;
	}
	//# sourceMappingURL=selection-card-control-object.d.ts.map
}
declare module 'lib/component/field/separator/separator-control-object' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { BaseControlObject } from 'lib/component/base-control-object';
	import type { FieldControlObjectConstructorProps } from 'lib/component/types';
	import { FieldKey } from 'lib/component/types';
	import type { SeparatorProperties } from 'lib/component/field/separator/separator-types';
	export class SeparatorControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends BaseControlObject<CT, SeparatorProperties> {
	    layout: FieldControlObjectConstructorProps<FieldKey.Separator>['layout'];
	    parent?: FieldControlObjectConstructorProps<FieldKey.Separator>['parent'];
	    insertBefore?: FieldControlObjectConstructorProps<FieldKey.Separator>['insertBefore'];
	    insertAfter?: FieldControlObjectConstructorProps<FieldKey.Separator>['insertAfter'];
	    static defaultUiProperties: Partial<SeparatorProperties>;
	    constructor({ screenId, elementId, getUiComponentProperties, setUiComponentProperties, layout, parent, }: FieldControlObjectConstructorProps<FieldKey.Separator>);
	    /** Whether the HTML element is visible or not */
	    isHidden?: boolean;
	    /** It makes the separator element invisible. The separator still preserves its space in the layout, but the line is not displayed. */
	    isInvisible?: boolean;
	}
	//# sourceMappingURL=separator-control-object.d.ts.map
}
declare module 'lib/component/field/static-content/static-content-control-object' {
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	export { StaticContentProperties } from 'lib/component/field/static-content/static-content-types';
	export class StaticContentControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.StaticContent, FieldComponentProps<FieldKey.StaticContent>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.StaticContent>>;
	    /**
	     * Support for the title property
	     * When set, and title is also set, beside it, an Info icon appears
	     * When hovered, titleHelp appears as a tooltip.
	     */
	    content?: string;
	    maxVisibleLines?: number;
	}
	//# sourceMappingURL=static-content-control-object.d.ts.map
}
declare module 'lib/component/field/step-sequence/step-sequence-control-object' {
	import type { ScreenExtension } from 'lib/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { StepSequenceStatus } from 'lib/component/field/step-sequence/step-sequence-types';
	import { StepSequenceProperties } from 'lib/component/field/step-sequence/step-sequence-types';
	import type { Dict } from '@sage/xtrem-shared';
	export { StepSequenceProperties };
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a step sequence
	 */
	export class StepSequenceControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.StepSequence, FieldComponentProps<FieldKey.StepSequence>> {
	    /** Steps to be displayed in the select element */
	    options?: string[];
	    /** An optional dicstionary of statuses. It takes strings as keys (which map to entries in either "options" or "optionType")
	     * and 'current' | 'complete' | 'incomplete' as values */
	    statuses?: Dict<StepSequenceStatus>;
	    /**
	     * The GraphQL node that the steps will be fetched from.
	     * When using this property, the node must be an Enum
	     */
	    get optionType(): string | undefined;
	}
	//# sourceMappingURL=step-sequence-control-object.d.ts.map
}
declare module 'lib/component/field/switch/switch-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey, FieldWidth } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a boolean value
	 */
	export class SwitchControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Switch, FieldComponentProps<FieldKey.Switch>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.Switch>>;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /**
	     * Support for the title property
	     * When set, and title is also set, beside it, an Info icon appears
	     * When hovered, titleHelp appears as a tooltip.
	     */
	    titleHelp?: string;
	    /**
	     * Size of the switch, it can be `small` or `large`. Default value is `small
	     */
	    size?: Exclude<FieldWidth, 'medium'>;
	}
	//# sourceMappingURL=switch-control-object.d.ts.map
}
declare module 'lib/component/field/table-summary/table-summary-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { TableSummaryDecoratorProperties } from 'lib/component/decorator-properties';
	import type { GridNestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldKey, PartialCollectionValueWithIds } from 'lib/component/types';
	import { CollectionValueControlObject } from 'lib/component/field/collection-value-field';
	import type { InternalTableSummaryProperties } from 'lib/component/field/table-summary/table-summary-types';
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
	 */
	export class TableSummaryControlObject<NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.TableSummary, NestedRecordType, CT, GridNestedFieldTypes, InternalTableSummaryProperties<CT, NestedRecordType>> {
	    static readonly defaultUiProperties: Partial<TableSummaryDecoratorProperties>;
	    /** Return records that the user just added to this table and not yet known by the server. */
	    getNewRecords(): PartialCollectionValueWithIds<NestedRecordType>[];
	    get node(): string;
	    /** Redraws the current table view, this function can be useful when values are updated that are used in property callbacks. */
	    redraw(columnBind?: string): Promise<void>;
	}
	//# sourceMappingURL=table-summary-control-object.d.ts.map
}
declare module 'lib/component/field/text-area/text-area-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a multi-line text value
	 */
	export class TextAreaControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.TextArea, FieldComponentProps<FieldKey.TextArea>> {
	    /** The number of rows the text area will span */
	    rows?: number;
	    /** The minimum length of the text field value */
	    minLength?: number;
	    /**  The maximum length of the text field value  */
	    maxLength?: number;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Moves the browser focus to this field */
	    focus(): void;
	}
	//# sourceMappingURL=text-area-control-object.d.ts.map
}
declare module 'lib/component/field/text/text-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a single-line text value
	 */
	export class TextControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Text, FieldComponentProps<FieldKey.Text>> {
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Icon of the input field. It will be placed on the right side. */
	    icon?: IconType;
	    /** Icon of the input field. It will be placed on the right side. */
	    iconColor?: string;
	    /** The minimum length of the text field value */
	    minLength?: number;
	    /**  The maximum length of the text field value  */
	    maxLength?: number;
	    /** The helper text underneath the field */
	    placeholder?: string;
	    /** Text to be displayed inline after the field value */
	    prefix?: string;
	    /** Text to be displayed inline before the field value */
	    postfix?: string;
	    /** The type of input field */
	    isPassword?: boolean;
	}
	//# sourceMappingURL=text-control-object.d.ts.map
}
declare module 'lib/component/field/toggle/toggle-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
	 */
	export class ToggleControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Toggle, FieldComponentProps<FieldKey.Toggle>> {
	    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.Toggle>>;
	    /** Buttons should appear grouped or with a margin between them */
	    isGrouped?: boolean;
	    /** Options to be displayed in the select element */
	    options?: string[];
	    /**
	     * The GraphQL node that the select options will be fetched from.
	     * When using this property, the node must be an Enum
	     */
	    get optionType(): string | undefined;
	    /** Moves the browser focus to this field */
	    focus(): void;
	    /** Field's value, only valid options can be set as value. */
	    set value(newValue: ReferencedEnumType | null);
	    /** Field's value, only valid options can be set as value. */
	    get value(): ReferencedEnumType | null;
	}
	//# sourceMappingURL=toggle-control-object.d.ts.map
}
declare module 'lib/component/field/tree/tree-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { NestedRecordId, ScreenExtension } from 'lib/types';
	import type { CollectionItem, FieldKey } from 'lib/component/types';
	import type { HasIcon } from 'lib/component/field/traits';
	import type { TreeDecoratorProperties, TreeProperties } from 'lib/component/field/tree/tree-types';
	import { CollectionValueControlObject } from 'lib/component/field/collection-value-field';
	import type { GridNestedFieldTypes } from 'lib/component/nested-fields';
	export interface TreeDropdownAction<CT extends ScreenExtension<CT>, NestedRecordType = CollectionItem> extends HasIcon {
	    title: string;
	    onClick: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType) => void;
	    isDisabled?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType) => boolean;
	}
	/**
	 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
	 */
	export class TreeControlObject<NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueControlObject<FieldKey.Tree, NestedRecordType, CT, GridNestedFieldTypes, TreeProperties<CT, NestedRecordType>> {
	    static readonly defaultUiProperties: Partial<TreeDecoratorProperties>;
	}
	//# sourceMappingURL=tree-control-object.d.ts.map
}
declare module 'lib/component/field/visual-process/visual-process-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { VisualProcessProperties } from 'lib/component/field/visual-process/visual-process-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a rich, formatted text value
	 */
	export class VisualProcessControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.VisualProcess, FieldComponentProps<FieldKey.VisualProcess>> {
	    static readonly defaultUiProperties: Partial<VisualProcessProperties>;
	    /** The value of the height attribute of the HTML image (e.g. 100px, 75%, auto, etc.)*/
	    height?: string;
	}
	//# sourceMappingURL=visual-process-control-object.d.ts.map
}
declare module 'lib/component/field/vital-pod/vital-pod-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	import type { VitalPodProperties } from 'lib/component/field/vital-pod/vital-pod-types';
	/**
	 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
	 */
	export class VitalPodControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.VitalPod, FieldComponentProps<FieldKey.VitalPod>> {
	    static readonly defaultUiProperties: Partial<VitalPodProperties>;
	    /** Graphql filter that will restrict the results of the reference field */
	    get filter(): GraphQLFilter<NodeType> | undefined;
	    /** Graphql filter that will restrict the results of the reference field */
	    set filter(filter: GraphQLFilter<NodeType> | undefined);
	    /** The GraphQL node that the field suggestions will be fetched from */
	    get node(): string;
	    /** The helper text underneath the field */
	    helperText?: string;
	    /** Whether the value of the pod can be unset */
	    canRemove?: boolean;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    refresh(): Promise<void>;
	    focus(): void;
	}
	//# sourceMappingURL=vital-pod-control-object.d.ts.map
}
declare module 'lib/component/field/workflow/workflow-control-object' {
	import type { FilterParameter } from '@sage/xtrem-ui-components';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import { EditableFieldControlObject } from 'lib/component/editable-field-control-object';
	import type { FieldComponentProps, FieldKey } from 'lib/component/types';
	export class WorkflowControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Workflow, FieldComponentProps<FieldKey.Workflow>> {
	    /** Document editor parameters */
	    parameters: FilterParameter[];
	}
	//# sourceMappingURL=workflow-control-object.d.ts.map
}
declare module 'lib/component/field/field-control-objects' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import { AggregateControlObject as Aggregate } from 'lib/component/field/aggregate/aggregate-control-object';
	import { ButtonControlObject as Button } from 'lib/component/field/button/button-control-object';
	import { CalendarControlObject as Calendar } from 'lib/component/field/calendar/calendar-control-object';
	import { CardControlObject as Card } from 'lib/component/field/card/card-control-object';
	import { ChartControlObject as Chart } from 'lib/component/field/chart/chart-control-object';
	import { CheckboxControlObject as Checkbox } from 'lib/component/field/checkbox/checkbox-control-object';
	import { ContentTableControlObject as ContentTable } from 'lib/component/field/content-table/content-table-control-object';
	import { CountControlObject as Count } from 'lib/component/field/count/count-control-object';
	import { TimeControlObject as Time } from 'lib/component/field/time/time-control-object';
	import { DatetimeRangeControlObject as DatetimeRange } from 'lib/component/field/datetime-range/datetime-range-control-object';
	import { DateControlObject as Date } from 'lib/component/field/date/date-control-object';
	import { DetailListControlObject as DetailList } from 'lib/component/field/detail-list/detail-list-control-object';
	import { DropdownListControlObject as DropdownList } from 'lib/component/field/dropdown-list/dropdown-list-control-object';
	import { DynamicPodControlObject as DynamicPod } from 'lib/component/field/dynamic-pod/dynamic-pod-control-object';
	import { FileDepositControlObject as FileDeposit } from 'lib/component/field/file-deposit/file-deposit-control-object';
	import { FileControlObject as File } from 'lib/component/field/file/file-control-object';
	import { FilterEditorControlObject as FilterEditor } from 'lib/component/field/filter-editor/filter-editor-control-object';
	import { FilterSelectControlObject as FilterSelect } from 'lib/component/field/filter-select/filter-select-control-object';
	import { FormDesignerControlObject as FormDesigner } from 'lib/component/field/form-designer/form-designer-control-object';
	import { IconControlObject as Icon } from 'lib/component/field/icon/icon-control-object';
	import { ImageControlObject as Image } from 'lib/component/field/image/image-control-object';
	import { LabelControlObject as Label } from 'lib/component/field/label/label-control-object';
	import { LinkControlObject as Link } from 'lib/component/field/link/link-control-object';
	import { MessageControlObject as Message } from 'lib/component/field/message/message-control-object';
	import { MultiDropdownControlObject as MultiDropdown } from 'lib/component/field/multi-dropdown/multi-dropdown-control-object';
	import { MultiFileDepositControlObject as MultiFileDeposit } from 'lib/component/field/multi-file-deposit/multi-file-deposit-control-object';
	import { MultiReferenceControlObject as MultiReference } from 'lib/component/field/multi-reference/multi-reference-control-object';
	import { NestedGridControlObject as NestedGrid } from 'lib/component/field/nested-grid/nested-grid-control-object';
	import { NodeBrowserTreeControlObject as NodeBrowserTree } from 'lib/component/field/node-browser-tree/node-browser-tree-control-object';
	import { NumericControlObject as Numeric } from 'lib/component/field/numeric/numeric-control-object';
	import { PluginControlObject as Plugin } from 'lib/component/field/plugin/plugin-control-object';
	import { PodCollectionControlObject as PodCollection } from 'lib/component/field/pod-collection/pod-collection-control-object';
	import { PodControlObject as Pod } from 'lib/component/field/pod/pod-control-object';
	import { ProgressControlObject as Progress } from 'lib/component/field/progress/progress-control-object';
	import { RadioControlObject as Radio } from 'lib/component/field/radio/radio-control-object';
	import { ReferenceControlObject as Reference } from 'lib/component/field/reference/reference-control-object';
	import { RelativeDateControlObject as RelativeDate } from 'lib/component/field/relative-date/relative-date-control-object';
	import { RichTextControlObject as RichText } from 'lib/component/field/rich-text/rich-text-control-object';
	import { SelectControlObject as Select } from 'lib/component/field/select/select-control-object';
	import { SelectionCardControlObject as SelectionCard } from 'lib/component/field/selection-card/selection-card-control-object';
	import { SeparatorControlObject as Separator } from 'lib/component/field/separator/separator-control-object';
	import { StaticContentControlObject as StaticContent } from 'lib/component/field/static-content/static-content-control-object';
	import { StepSequenceControlObject as StepSequence } from 'lib/component/field/step-sequence/step-sequence-control-object';
	import { SwitchControlObject as Switch } from 'lib/component/field/switch/switch-control-object';
	import { TableSummaryControlObject as TableSummary } from 'lib/component/field/table-summary/table-summary-control-object';
	import { TableControlObject as Table } from 'lib/component/field/table/table-control-object';
	import { TextAreaControlObject as TextArea } from 'lib/component/field/text-area/text-area-control-object';
	import { TextControlObject as Text } from 'lib/component/field/text/text-control-object';
	import { ToggleControlObject as Toggle } from 'lib/component/field/toggle/toggle-control-object';
	import { TreeControlObject as Tree } from 'lib/component/field/tree/tree-control-object';
	import { VisualProcessControlObject as VisualProcess } from 'lib/component/field/visual-process/visual-process-control-object';
	import { VitalPodControlObject as VitalPod } from 'lib/component/field/vital-pod/vital-pod-control-object';
	import { WorkflowControlObject as Workflow } from 'lib/component/field/workflow/workflow-control-object';
	export type { AggregateProperties } from 'lib/component/field/aggregate/aggregate-types';
	export type { ButtonProperties } from 'lib/component/field/button/button-types';
	export type { CalendarProperties } from 'lib/component/field/calendar/calendar-types';
	export type { CardProperties } from 'lib/component/field/card/card-types';
	export type { ChartProperties } from 'lib/component/field/chart/chart-types';
	export type { CheckboxProperties } from 'lib/component/field/checkbox/checkbox-types';
	export type { CollectionValueFieldProperties } from 'lib/component/field/collection-value-field';
	export type { ContentTableProperties } from 'lib/component/field/content-table/content-table-types';
	export type { CountProperties } from 'lib/component/field/count/count-types';
	export type { TimeProperties } from 'lib/component/field/time/time-types';
	export type { DatetimeRangeProperties } from 'lib/component/field/datetime-range/datetime-range-types';
	export type { DateProperties } from 'lib/component/field/date/date-types';
	export type { DetailListProperties } from 'lib/component/field/detail-list/detail-list-types';
	export type { DropdownListProperties } from 'lib/component/field/dropdown-list/dropdown-list-types';
	export type { FileDepositProperties } from 'lib/component/field/file-deposit/file-deposit-types';
	export type { FileProperties } from 'lib/component/field/file/file-types';
	export type { FilterEditorProperties } from 'lib/component/field/filter-editor/filter-editor-types';
	export type { FilterSelectProperties } from 'lib/component/field/filter-select/filter-select-types';
	export type { FormDesignerProperties } from 'lib/component/field/form-designer/form-designer-types';
	export type { IconProperties } from 'lib/component/field/icon/icon-types';
	export type { ImageProperties } from 'lib/component/field/image/image-types';
	export type { LinkProperties } from 'lib/component/field/link/link-types';
	export type { MessageProperties } from 'lib/component/field/message/message-types';
	export type { MultiDropdownProperties } from 'lib/component/field/multi-dropdown/multi-dropdown-types';
	export type { MultiFileDepositProperties } from 'lib/component/field/multi-file-deposit/multi-file-deposit-types';
	export type { MultiReferenceProperties } from 'lib/component/field/multi-reference/multi-reference-types';
	export type { NodeBrowserTreeProperties as NodeBrowserTreeComponentProperties } from 'lib/component/field/node-browser-tree/node-browser-tree-types';
	export type { NumericProperties } from 'lib/component/field/numeric/numeric-types';
	export type { PluginProperties } from 'lib/component/field/plugin/plugin-types';
	export type { PodProperties } from 'lib/component/field/pod/pod-types';
	export type { ProgressProperties } from 'lib/component/field/progress/progress-types';
	export type { RadioProperties } from 'lib/component/field/radio/radio-types';
	export type { ReferenceProperties } from 'lib/component/field/reference/reference-types';
	export type { RichTextProperties } from 'lib/component/field/rich-text/rich-text-types';
	export type { SelectProperties } from 'lib/component/field/select/select-types';
	export type { SelectionCardProperties } from 'lib/component/field/selection-card/selection-card-types';
	export type { SeparatorProperties } from 'lib/component/field/separator/separator-types';
	export type { SwitchProperties } from 'lib/component/field/switch/switch-types';
	export type { TableSummaryProperties } from 'lib/component/field/table-summary/table-summary-types';
	export type { TableProperties } from 'lib/component/field/table/table-component-types';
	export type { TextAreaProperties } from 'lib/component/field/text-area/text-area-types';
	export type { TextProperties } from 'lib/component/field/text/text-types';
	export type { ToggleProperties } from 'lib/component/field/toggle/toggle-types';
	export type { TreeProperties } from 'lib/component/field/tree/tree-types';
	export type { VisualProcessProperties } from 'lib/component/field/visual-process/visual-process-types';
	export type { VitalPodProperties } from 'lib/component/field/vital-pod/vital-pod-types';
	export type { WorkflowProperties } from 'lib/component/field/workflow/workflow-types';
	export * from 'lib/component/field/aggregate/aggregate-control-object';
	export * from 'lib/component/field/button/button-control-object';
	export * from 'lib/component/field/calendar/calendar-control-object';
	export * from 'lib/component/field/card/card-control-object';
	export * from 'lib/component/field/chart/chart-control-object';
	export * from 'lib/component/field/checkbox/checkbox-control-object';
	export * from 'lib/component/field/content-table/content-table-control-object';
	export * from 'lib/component/field/count/count-control-object';
	export * from 'lib/component/field/time/time-control-object';
	export * from 'lib/component/field/datetime-range/datetime-range-control-object';
	export * from 'lib/component/field/date/date-control-object';
	export * from 'lib/component/field/detail-list/detail-list-control-object';
	export * from 'lib/component/field/dropdown-list/dropdown-list-control-object';
	export * from 'lib/component/field/dynamic-pod/dynamic-pod-control-object';
	export * from 'lib/component/field/file-deposit/file-deposit-control-object';
	export * from 'lib/component/field/file/file-control-object';
	export * from 'lib/component/field/filter-editor/filter-editor-control-object';
	export * from 'lib/component/field/filter-select/filter-select-control-object';
	export * from 'lib/component/field/form-designer/form-designer-control-object';
	export * from 'lib/component/field/icon/icon-control-object';
	export * from 'lib/component/field/image/image-control-object';
	export * from 'lib/component/field/label/label-control-object';
	export * from 'lib/component/field/link/link-control-object';
	export * from 'lib/component/field/message/message-control-object';
	export * from 'lib/component/field/multi-dropdown/multi-dropdown-control-object';
	export * from 'lib/component/field/multi-file-deposit/multi-file-deposit-control-object';
	export * from 'lib/component/field/multi-reference/multi-reference-control-object';
	export * from 'lib/component/field/nested-grid/nested-grid-control-object';
	export * from 'lib/component/field/node-browser-tree/node-browser-tree-control-object';
	export * from 'lib/component/field/numeric/numeric-control-object';
	export * from 'lib/component/field/plugin/plugin-control-object';
	export * from 'lib/component/field/pod-collection/pod-collection-control-object';
	export * from 'lib/component/field/pod-collection/pod-collection-types';
	export * from 'lib/component/field/pod/pod-control-object';
	export * from 'lib/component/field/progress/progress-control-object';
	export * from 'lib/component/field/radio/radio-control-object';
	export * from 'lib/component/field/reference/reference-control-object';
	export * from 'lib/component/field/relative-date/relative-date-control-object';
	export * from 'lib/component/field/rich-text/rich-text-control-object';
	export * from 'lib/component/field/select/select-control-object';
	export * from 'lib/component/field/selection-card/selection-card-control-object';
	export * from 'lib/component/field/separator/separator-control-object';
	export * from 'lib/component/field/static-content/static-content-control-object';
	export * from 'lib/component/field/step-sequence/step-sequence-control-object';
	export * from 'lib/component/field/switch/switch-control-object';
	export * from 'lib/component/field/table-summary/table-summary-control-object';
	export * from 'lib/component/field/table/table-control-object';
	export * from 'lib/component/field/text-area/text-area-control-object';
	export * from 'lib/component/field/text/text-control-object';
	export * from 'lib/component/field/toggle/toggle-control-object';
	export * from 'lib/component/field/tree/tree-control-object';
	export * from 'lib/component/field/visual-process/visual-process-control-object';
	export * from 'lib/component/field/vital-pod/vital-pod-control-object';
	export * from 'lib/component/field/workflow/workflow-control-object';
	export { TableDisplayMode } from 'lib/component/types';
	export { Aggregate, Button, Calendar, Card, Chart, Checkbox, ContentTable, Count, Date, Time, DatetimeRange, DetailList, DropdownList, DynamicPod, File, FileDeposit, FilterEditor, FilterSelect, FormDesigner, Icon, Image, Label, Link, Message, MultiDropdown, MultiFileDeposit, MultiReference, NestedGrid, NodeBrowserTree, Numeric, Plugin, Pod, PodCollection, Progress, Radio, Reference, RelativeDate, RichText, Select, SelectionCard, Separator, StaticContent, StepSequence, Switch, Table, TableSummary, Text, TextArea, Toggle, Tree, VisualProcess, VitalPod, Workflow, };
	export const fields: {
	    Aggregate: typeof Aggregate;
	    Button: typeof Button;
	    Calendar: typeof Calendar;
	    Card: typeof Card;
	    Chart: typeof Chart;
	    Checkbox: typeof Checkbox;
	    ContentTable: typeof ContentTable;
	    Count: typeof Count;
	    Date: typeof Date;
	    Time: typeof Time;
	    DatetimeRange: typeof DatetimeRange;
	    DetailList: typeof DetailList;
	    DropdownList: typeof DropdownList;
	    DynamicPod: typeof DynamicPod;
	    File: typeof File;
	    FileDeposit: typeof FileDeposit;
	    FilterSelect: typeof FilterSelect;
	    FormDesigner: typeof FormDesigner;
	    Icon: typeof Icon;
	    Image: typeof Image;
	    Label: typeof Label;
	    Link: typeof Link;
	    Message: typeof Message;
	    MultiDropdown: typeof MultiDropdown;
	    MultiReference: typeof MultiReference;
	    NestedGrid: typeof NestedGrid;
	    NodeBrowserTree: typeof NodeBrowserTree;
	    Numeric: typeof Numeric;
	    Plugin: typeof Plugin;
	    Pod: typeof Pod;
	    PodCollection: typeof PodCollection;
	    Progress: typeof Progress;
	    Radio: typeof Radio;
	    Reference: typeof Reference;
	    RelativeDate: typeof RelativeDate;
	    RichText: typeof RichText;
	    Select: typeof Select;
	    SelectionCard: typeof SelectionCard;
	    Separator: typeof Separator;
	    StaticContent: typeof StaticContent;
	    StepSequence: typeof StepSequence;
	    Switch: typeof Switch;
	    Table: typeof Table;
	    TableSummary: typeof TableSummary;
	    Text: typeof Text;
	    TextArea: typeof TextArea;
	    Toggle: typeof Toggle;
	    Tree: typeof Tree;
	    VisualProcess: typeof VisualProcess;
	    VitalPod: typeof VitalPod;
	    Workflow: typeof Workflow;
	};
	//# sourceMappingURL=field-control-objects.d.ts.map
}
declare module 'lib/component/field/field-properties' {
	export { AggregateProperties, ButtonProperties, CalendarProperties, CardProperties, ChartProperties, CheckboxProperties, CollectionValueFieldProperties, ContentTableProperties, CountProperties, DateProperties, DetailListProperties, DropdownListProperties, FileDepositProperties, FileProperties, FilterEditorProperties, FilterSelectProperties, FormDesignerProperties, IconProperties, ImageProperties, LabelProperties, LinkProperties, MessageProperties, MultiDropdownProperties, MultiReferenceProperties, NestedGridProperties, NodeBrowserTreeComponentProperties, NumericProperties, PluginProperties, PodCollectionProperties, PodProperties, ProgressProperties, RadioProperties, ReferenceProperties, RichTextProperties, SelectionCardProperties, SelectProperties, SeparatorProperties, SwitchProperties, TableProperties, TableSummaryProperties, TextAreaProperties, TextProperties, TimeProperties, ToggleProperties, TreeProperties, VisualProcessProperties, VitalPodProperties, } from 'lib/component/field/field-control-objects';
	//# sourceMappingURL=field-properties.d.ts.map
}
declare module 'lib/service/graphql-service' {
	import type { ClientNode as metadataService } from '@sage/xtrem-client';
	import type { Dict, WorkflowNode } from '@sage/xtrem-shared';
	import type { CancelToken } from 'axios';
	import type { OptionsMenuItem } from 'lib/component/container/page/page-types';
	import type { ReferenceProperties, TreeProperties } from 'lib/component/field/field-properties';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { TableDecoratorProperties } from 'lib/component/field/table/table-component-types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { OrderByType } from 'lib/component/types';
	import type { ApplicationContext } from 'lib/redux/state';
	import type { NodePropertyType } from 'lib/types';
	import type { GraphQLFilter, NodeCollectionResult, QueryArguments } from 'lib/service/graphql-utils';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { Page } from 'lib/service/page';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { XtremUiPlugin } from 'lib/service/plugin-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	export const fetchCollectionDataCount: ({ rootNode, filter, }: {
	    rootNode: NodePropertyType;
	    filter: string;
	}) => Promise<number>;
	export const fetchCollectionData: ({ bind, elementId, group, nestedFields, node, nodeTypes, queryArguments, rootNode, rootNodeId, screenDefinition, totalCount, treeProperties, }: {
	    bind?: PropertyValueType;
	    elementId: string;
	    group?: {
	        key: string;
	        value?: string;
	    };
	    nestedFields: NestedField<ScreenBase, NestedFieldTypes>[];
	    node?: string;
	    nodeTypes?: Dict<FormattedNodeDetails>;
	    queryArguments?: QueryArguments;
	    rootNode: NodePropertyType;
	    rootNodeId: string;
	    screenDefinition: ScreenBaseDefinition;
	    totalCount?: boolean;
	    treeProperties?: TreeProperties<Page>;
	}) => Promise<any>;
	export const fetchCollectionRecord: (screenDefinition: ScreenBaseDefinition, nestedFields: NestedField<ScreenBase, NestedFieldTypes, any, any>[], nodeName: NodePropertyType, recordId: string) => Promise<any>;
	export const formatNavigationPanelResponse: (navigationPanelResponse: NodeCollectionResult) => any[];
	export const fetchNavigationPanelData: (screenId: string, screenDefinition: ScreenBaseDefinition, tableDecoratorProperties: TableDecoratorProperties, orderBy?: OrderByType, filter?: GraphQLFilter, first?: number, nodeTypes?: Dict<FormattedNodeDetails>, optionMenuItem?: OptionsMenuItem) => Promise<any[]>;
	export interface FetchReferenceFieldSuggestionsInput<T extends metadataService = any> {
	    after?: string;
	    contextNode?: NodePropertyType;
	    exactMatch?: boolean;
	    fieldId: string;
	    fieldProperties: Omit<ReferenceProperties<ScreenBase, T>, 'parent'>;
	    filterValue?: string;
	    isFilterLimitedToDataset?: boolean;
	    level?: number;
	    locale?: string;
	    parentElementId?: string;
	    recordContext?: Dict<any>;
	    screenId: string;
	}
	export const fetchReferenceFieldSuggestions: <T extends metadataService = any>({ after, contextNode, exactMatch, fieldId, fieldProperties, filterValue, isFilterLimitedToDataset, level, locale, parentElementId, recordContext, screenId, }: FetchReferenceFieldSuggestionsInput<T>) => Promise<T[]>;
	export const fetchReferenceFieldData: <T extends metadataService = any>({ after, axiosCancelToken, contextNode, elementId, fieldProperties, filter, group, isFilterLimitedToDataset, level, orderBy, pageSize, parentElementId, recordContext, screenId, valueField, }: {
	    after?: string;
	    axiosCancelToken?: CancelToken;
	    contextNode?: NodePropertyType;
	    elementId: string;
	    fieldProperties: Omit<ReferenceProperties<ScreenBase, T>, 'parent'>;
	    filter?: GraphQLFilter<T>;
	    group?: {
	        key: string;
	        value?: string;
	    };
	    isFilterLimitedToDataset?: boolean;
	    level?: number;
	    orderBy?: OrderByType<T>;
	    pageSize?: number;
	    parentElementId?: string;
	    recordContext?: Dict<any>;
	    screenId: string;
	    valueField?: any;
	}) => Promise<NodeCollectionResult<T>>;
	export const fetchReferenceFieldDataById: <T extends metadataService = any>({ _id, contextNode, elementId, fieldProperties, level, parentElementId, recordContext, screenId, valueField, }: {
	    _id: string;
	    contextNode?: NodePropertyType;
	    elementId: string;
	    fieldProperties: Omit<ReferenceProperties<ScreenBase, T>, 'parent'>;
	    level?: number;
	    parentElementId?: string;
	    recordContext?: Dict<any>;
	    screenId: string;
	    valueField?: any;
	}) => Promise<any>;
	export const fetchRecordData: (screenId: string, recordId: string, screenDefinition: ScreenBaseDefinition) => Promise<any>;
	export const fetchField: (screenDefinition: ScreenBaseDefinition, fieldProperties: ReadonlyFieldProperties, recordId: string, elementId: string, plugins: Dict<XtremUiPlugin>, nodeTypes: Dict<FormattedNodeDetails>, nodeName?: string, keepPageInfo?: boolean) => Promise<any>;
	export interface InitialData {
	    navigationPanel: any[];
	    values: ScreenBaseDefinition['values'];
	}
	export const fetchInitialData: (pageDefinition: PageDefinition, recordId?: string, path?: string, applicationContext?: ApplicationContext, nodeTypes?: Dict<FormattedNodeDetails>, dataTypes?: Dict<DataTypeDetails>, values?: Dict<any>, isDuplicate?: boolean) => Promise<InitialData>;
	export const fetchNestedDefaultValues: ({ screenId, elementId, isNewRow, recordId, nestedElementId, level, data, }: {
	    screenId: string;
	    elementId: string;
	    isNewRow?: boolean;
	    recordId?: string;
	    nestedElementId?: string;
	    level?: number;
	    data?: any;
	}) => Promise<{
	    pageDefaults?: Dict<any>;
	    nestedDefaults?: Dict<any>;
	}>;
	export const fetchDefaultValues: (screenDefinition: ScreenBaseDefinition, rootNode: string, requestedFieldIds?: string[], clean?: boolean, nodeTypes?: Dict<FormattedNodeDetails>) => Promise<Dict<any>>;
	export const fetchWorkflowNodes: () => Promise<WorkflowNode[]>;
	//# sourceMappingURL=graphql-service.d.ts.map
}
declare module 'lib/component/field/collection-value-field' {
	import type { ClientNode } from '@sage/xtrem-client';
	import { CollectionValue } from 'lib/service/collection-data-service';
	import type { AggregationMethod } from 'lib/service/collection-data-types';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { NestedRecordId, ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import { ReadonlyFieldControlObject } from 'lib/component/readonly-field-control-object';
	import type { CollectionValueFieldKey, FieldControlObjectConstructorProps, OrderByType, PartialCollectionValue, PartialCollectionValueWithIds } from 'lib/component/types';
	import type { HasFilter, ServerRecordMapperFunction } from 'lib/component/field/traits';
	export interface CollectionValueFieldProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends HasFilter<CT, NestedRecordType>, ReadonlyFieldProperties<CT> {
	    /** Selected records identifiers */
	    selectedRecords?: NestedRecordId[];
	    /** The GraphQL node that the table represents, needed for filtering */
	    node?: keyof ScreenBaseGenericType<CT>;
	    /** The column or the set of columns which the table should be sorted by */
	    orderBy?: OrderByType<NestedRecordType>;
	    /** Number of lines displayed by default in the table, if not defined it defaults to 20 */
	    pageSize?: number;
	    /** Whether the records of the table can be selected or not. Defaults to true */
	    canSelect?: boolean;
	    /** Allows changing record values before those are rendered to the screen. This function is invoked whenever new entities are fetched from the server. */
	    mapServerRecord?: ServerRecordMapperFunction<CT, NestedRecordType>;
	    /** Indicate additional warning message, rendered as tooltip and blue border. */
	    infoMessage?: ValueOrCallbackWithFieldValue<CT, string, any, NestedRecordType>;
	    /** Indicate additional information, rendered as tooltip and orange border. */
	    warningMessage?: ValueOrCallbackWithFieldValue<CT, string, any, NestedRecordType>;
	}
	export abstract class CollectionValueControlObject<FT extends CollectionValueFieldKey, NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase, AvailableNestedFieldTypes extends NestedFieldTypes = NestedFieldTypes, FieldProps extends CollectionValueFieldProperties<CT, NestedRecordType> = CollectionValueFieldProperties<CT, NestedRecordType>> extends ReadonlyFieldControlObject<CT, CollectionValueFieldKey, FieldProps, NestedRecordType> {
	    protected readonly _isFieldDirty: (screenId: string, elementId: string) => boolean;
	    protected _setFieldDirty: (screenId: string, elementId: string) => void;
	    protected _setFieldClean: (screenId: string, elementId: string) => void;
	    constructor(properties: FieldControlObjectConstructorProps<FT>);
	    private readonly createCollectionValue;
	    ensureFieldHasValue(): CollectionValue<NestedRecordType>;
	    /** Graphql filter that will restrict the records displayed in the table */
	    get filter(): GraphQLFilter<NestedRecordType> | undefined;
	    /** Graphql filter that will restrict the records displayed in the table */
	    set filter(filter: GraphQLFilter<NestedRecordType> | undefined);
	    /** Number of lines displayed by default in the table, if not defined it defaults to 20 */
	    pageSize?: number;
	    /** Whether the records of this table can be selected or not */
	    canSelect?: boolean;
	    get isDirty(): boolean;
	    set isDirty(newValue: boolean);
	    /**
	     * Indicate additional warning message, rendered as tooltip and blue border.
	     */
	    get infoMessage(): string | undefined;
	    /**
	     * Indicate additional warning message, rendered as tooltip and blue border.
	     */
	    set infoMessage(infoMessage: string | undefined);
	    /**
	     * Indicate additional information, rendered as tooltip and orange border
	     */
	    get warningMessage(): string | undefined;
	    /**
	     * Indicate additional information, rendered as tooltip and orange border
	     */
	    set warningMessage(warningMessage: string | undefined);
	    /**
	     * Return all table records known to the client, it does not include records which were not previously fetched by some
	     * user interaction such as pagination
	     * */
	    get value(): PartialCollectionValueWithIds<NestedRecordType>[];
	    /**
	     * Resets the value of the table, all pending changes are be overridden and all cached records are discarded
	     * */
	    set value(newValue: PartialCollectionValueWithIds<NestedRecordType>[]);
	    revalidate(fn: (record: PartialCollectionValueWithIds<NestedRecordType>) => boolean): Promise<void>;
	    /** Update the value of a single record in the collection */
	    setRecordValue(recordData: PartialCollectionValueWithIds<NestedRecordType>): void;
	    /** Return a single record that is already known to the client */
	    getRecordValue(recordId: string): PartialCollectionValueWithIds<NestedRecordType> | null;
	    /** Return a single record that is already known to the client along with all its internal properties */
	    getInternalRowValue(recordId: string): PartialCollectionValueWithIds<NestedRecordType> | null;
	    /** Add a single record in the table and in its dataset */
	    addRecord(recordData: PartialCollectionValue<NestedRecordType>): PartialCollectionValueWithIds<NestedRecordType>;
	    /** Add a single record in the table and in its dataset with default values coming from the server */
	    addRecordWithDefaults(recordData?: PartialCollectionValue<NestedRecordType>): Promise<PartialCollectionValueWithIds<NestedRecordType>>;
	    /** Add or update record in the table depending of the existence of the ID field */
	    addOrUpdateRecordValue(recordData: PartialCollectionValue<NestedRecordType>): PartialCollectionValueWithIds<NestedRecordType>;
	    /** Remove a single record from the table and its dataset */
	    removeRecord(recordId: NestedRecordId): void;
	    /** Gets a record by a given field and value */
	    getRecordByFieldValue(fieldName: keyof NestedRecordType, fieldValue: any): PartialCollectionValue<NestedRecordType> | null;
	    /** Selected records identifiers */
	    get selectedRecords(): NestedRecordId[];
	    /** Selected records identifiers */
	    set selectedRecords(recordIds: NestedRecordId[]);
	    /** Adds the record identifier to the set of selected items */
	    selectRecord(recordId: NestedRecordId): void;
	    /** Removes the record identifier from the set of selected items */
	    unselectRecord(recordId: NestedRecordId): void;
	    /** Unselects all items in the collection */
	    unselectAllRecords(): void;
	    /** Returns an auto-generated ID that can be used for a new record */
	    generateRecordId(): string;
	    refresh(keepModifications?: boolean): Promise<void>;
	    /**
	     * Triggers the field validation rules. Since the validation rules might be asynchronous,
	     * this method returns a promise that must be awaited to get the validation result
	     */
	    validate(): Promise<string[]>;
	    /**
	     * Triggers the field validation rules. Since the validation rules might be asynchronous,
	     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
	     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
	     */
	    validateWithDetails(): Promise<ValidationResult[]>;
	    refreshRecord(recordId: string, skipUpdate?: boolean): Promise<PartialCollectionValueWithIds<NestedRecordType>>;
	    /**
	     * Calculate aggregated values ('min' | 'max' | 'sum' | 'avg' | 'count').
	     * Returns Number.NaN if not all records have been fetched from the server.
	     */
	    calculateAggregatedValue({ aggregationKey, aggregationMethod, level, parentId, }: {
	        aggregationMethod: AggregationMethod;
	        aggregationKey: string;
	        level?: number | null;
	        parentId?: string | null;
	    }): number;
	}
	//# sourceMappingURL=collection-value-field.d.ts.map
}
declare module 'lib/service/collection-data-types' {
	import type { ClientNode, ExtractEdgesPartial } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { Merge } from 'ts-essentials';
	import type { CollectionValueFieldProperties } from 'lib/component/field/collection-value-field';
	import type { Level } from 'lib/component/field/nested-grid/nested-grid-component-types';
	import type { HasDynamicLookupSuggestions } from 'lib/component/field/traits';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { OrderByType, PartialCollectionValue, PartialCollectionValueWithIds } from 'lib/component/types';
	import type { ScreenExtension } from 'lib/types';
	import type { AggFunc } from 'lib/service/collection-data-utils';
	import type { QueryArguments } from 'lib/service/graphql-utils';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	export enum RecordActionType {
	    MODIFIED = "update",
	    ADDED = "create",
	    REMOVED = "delete",
	    TEMPORARY = "temporary"
	}
	export enum CollectionFieldTypes {
	    DESKTOP_TABLE = "desktop table",
	    MOBILE_TABLE = "mobile table",
	    NESTED_GRID = "nested grid",
	    TREE = "tree",
	    LOOKUP_DIALOG = "lookup dialog",
	    GRID_ROW = "grid row",
	    POD = "pod",
	    CALENDAR = "calendar",
	    NAVIGATION_PANEL = "navigation panel",
	    MULTI_FILE_DEPOSIT = "multi file deposit"
	}
	/** It represents all validation errors in a collection sorted by level, then column */
	export type CollectionGlobalValidationState = Dict<ValidationResult[]>[];
	export type ValueChangeSubscriptionCallback = (type: RecordActionType, rowValue: any) => void;
	export type ValidityChangeSubscriptionCallback = ({ globalValidationState, recordValidationState, recordId, recordLevel, }: {
	    globalValidationState: CollectionGlobalValidationState;
	    recordValidationState: Dict<ValidationResult>;
	    recordId: string;
	    recordLevel?: number;
	}) => void;
	export type FetchNestedGridArgs<N extends ClientNode = any> = {
	    rootNode: string;
	    selectedRecordId: string;
	    level: number;
	    levelProps: Level<any, N>;
	    queryArguments: QueryArguments;
	    childProperty: string;
	};
	export interface CollectionValueFieldPropertiesWithAdditionalRecords<CT extends ScreenExtension<CT> = ScreenBase> extends CollectionValueFieldProperties<CT>, HasDynamicLookupSuggestions<CT> {
	    columns?: NestedField<any, NestedFieldTypes>[];
	}
	type BaseCollectionValueType = {
	    __action?: RecordActionType;
	    __compositeKey?: string;
	    __dirty?: boolean;
	    __dirtyColumns?: Set<string>;
	    __isGroup?: boolean;
	    __forceRowUpdate?: boolean;
	    __aggFunc?: AggFunc;
	    __groupCount?: number;
	    __level?: number;
	    __parentId?: string;
	    __phantom?: boolean;
	    __validationState?: Dict<ValidationResult>;
	    __uncommitted?: boolean;
	    __path?: string;
	    _id: string;
	    /**
	     * This flag is used to indicate a record that we know exists but have not been been fully loaded yet, such as records we know exist from validation
	     * error results, but the user have not requested them from the server yet. These records should be excluded from all queries other than validation related ones.
	     *  */
	    __unloaded?: boolean;
	    __cursor?: string;
	};
	export type CollectionValueType<T extends BaseCollectionValueType = BaseCollectionValueType> = T & {
	    __groupKey?: keyof T & string;
	};
	export type InternalValue<T extends ClientNode> = Merge<PartialCollectionValue<T>, CollectionValueType>;
	export type AggregationMethod = 'min' | 'max' | 'sum' | 'avg' | 'count';
	export interface NormalizedCollection<T extends ClientNode = any> {
	    addRecord(args: {
	        beforeInsert?: (d: PartialCollectionValue<T> | Omit<PartialCollectionValue<T>, '_id'>) => Partial<InternalValue<T>>;
	        afterInsert?: (args: {
	            record: Partial<InternalValue<T>>;
	            action: RecordActionType;
	        }) => void;
	        data: PartialCollectionValue<T> | Omit<PartialCollectionValue<T>, '_id'>;
	        level?: number;
	        cleanMetadata?: boolean;
	        dirty?: boolean;
	        action?: RecordActionType | 'none';
	        parentId?: string;
	        isUncommitted?: boolean;
	    }): InternalValue<T>;
	    calculateAggregatedValue(args: {
	        aggregationMethod: AggregationMethod;
	        aggregationKey: string;
	        level?: number | null;
	        parentId?: string | null;
	        where?: LokiQuery<InternalValue<T> & LokiObj>;
	        includeUnloaded?: boolean;
	        includePhantom?: boolean;
	        isUncommitted?: boolean;
	    }): number;
	    clear(): void;
	    createRecord(args: {
	        beforeCreate?: (d: PartialCollectionValue<T> | Omit<PartialCollectionValue<T>, '_id'>) => Partial<InternalValue<T>>;
	        data: PartialCollectionValue<T> | Omit<PartialCollectionValue<T>, '_id'>;
	        level?: number;
	        dirty?: boolean;
	        action?: RecordActionType | 'none';
	        parentId?: string;
	        isUncommitted?: boolean;
	    }): InternalValue<T>;
	    exportDataForServerProcessing(): any[];
	    filter(args: {
	        where?: LokiQuery<InternalValue<T>>;
	        groupByKey?: string;
	    }): this;
	    findAll(args: {
	        level?: number | null;
	        parentId?: string | null;
	        where?: LokiQuery<InternalValue<T> & LokiObj>;
	        includeUnloaded?: boolean;
	        includePhantom?: boolean;
	        isUncommitted?: boolean;
	    }): this;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: undefined;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): PartialCollectionValueWithIds<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: true;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): PartialCollectionValueWithIds<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: false;
	        unloaded?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: boolean;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T> | PartialCollectionValueWithIds<T>;
	    findOne(args: {
	        id?: string;
	        level?: number | null;
	        parentId?: string;
	        where?: LokiQuery<InternalValue<T>>;
	        cleanMetadata?: boolean;
	        includeUnloaded?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T> | PartialCollectionValueWithIds<T>;
	    getAncestorIds(args: {
	        id: string;
	        level?: number;
	    }): string[];
	    getIdPathToRecordByIdAndLevel(args: {
	        id: string;
	        level?: number;
	    }): string[];
	    getValidationStateByColumn(levels: number): CollectionGlobalValidationState;
	    generateIndex(): string;
	    /** Queries the database to return the current validation state of the content, it does not run the validations.  */
	    isCollectionValid(): boolean;
	    isCollectionDirty(): boolean;
	    remove(args: {
	        data: InternalValue<T>;
	        beforeRemove?: () => void;
	        afterRemove?: () => void;
	    }): this;
	    skip(offset: number): this;
	    sort(args: {
	        orderBy?: OrderByType<T>;
	        columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[];
	    }): this;
	    take(limit: number): this;
	    update(args: {
	        data: InternalValue<T>;
	        beforeUpdate?: (data: Partial<InternalValue<T>>) => any;
	        afterUpdate?: (record: Partial<InternalValue<T>>) => void;
	        cleanMetadata?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T>;
	    value({ cleanMetadata, }: {
	        cleanMetadata: true;
	        cleanDatabaseMeta?: boolean;
	        isUncommitted?: boolean;
	    }): PartialCollectionValueWithIds<T>[];
	    value({ cleanMetadata, }: {
	        cleanMetadata: false;
	        cleanDatabaseMeta?: boolean;
	        isUncommitted?: boolean;
	    }): InternalValue<T>[];
	    value({ cleanMetadata, }: {
	        cleanMetadata?: boolean;
	        cleanDatabaseMeta?: boolean;
	        isUncommitted?: boolean;
	    }): PartialCollectionValueWithIds<T>[];
	    value(): PartialCollectionValueWithIds<T>[];
	    value(args: {
	        cleanMetadata?: boolean;
	        cleanDatabaseMeta?: boolean;
	        isUncommitted?: boolean;
	    }): any[];
	    where(fun: (data: InternalValue<T> & LokiObj) => boolean): this;
	    withTemporaryRecords<B>(body: (db: NormalizedCollection<T>) => B, temporaryRecords: ExtractEdgesPartial<T>[]): B;
	    startRecordTransaction(args: {
	        recordId: string;
	        recordLevel?: number;
	    }): void;
	    commitRecord(args: {
	        recordId: string;
	        recordLevel?: number;
	    }): boolean;
	    cancelRecordTransaction(args: {
	        recordId: string;
	        recordLevel?: number;
	    }): void;
	}
	export {};
	//# sourceMappingURL=collection-data-types.d.ts.map
}
declare module 'lib/service/value-serializer-service' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from 'lib/service/metadata-types';
	/**
	 * Formats any data to a GraphQL input based on provided node type definition.
	 * It checks the expected GraphQL input type and converts the value to it wherever it is possible. In case of nested structures in
	 * converts the properties deeply by following the graph definitions.
	 *
	 * Whenever a client side value cannot be converted to the server defined type (e.g. boolean to an object), an exception is thrown
	 *
	 * @param param0
	 * @returns
	 */
	export const formatInputProperty: ({ isRequestingDefaults, isTopLevel, nodeTypes, property, value, }: {
	    property: FormattedNodeDetailsProperty;
	    value: any;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    isRequestingDefaults?: boolean;
	    isTopLevel?: boolean;
	}) => any;
	export interface SerializePageDataParams {
	    values: Dict<any>;
	    uiComponentProperties: Dict<ReadonlyFieldProperties>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    targetNode: string;
	    isRequestingDefaults?: boolean;
	}
	/**
	 * Builds the mutation `data` payload from the values and properties, first it normalizes the value structure and filters out the
	 * non saveable fields, then format the values to match the input value.
	 */
	export const serializePageData: ({ values, uiComponentProperties, isRequestingDefaults, nodeTypes, targetNode, }: SerializePageDataParams) => any;
	//# sourceMappingURL=value-serializer-service.d.ts.map
}
declare module 'lib/service/collection-data-utils' {
	import type { ClientNode } from '@sage/xtrem-client';
	import * as xtremDecimal from '@sage/xtrem-decimal';
	import type { Dict } from '@sage/xtrem-shared';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { OrderByType } from 'lib/component/types';
	import type { DateAggregation } from 'lib/redux/state';
	import type { InternalValue } from 'lib/service/collection-data-types';
	import { RecordActionType } from 'lib/service/collection-data-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { ScreenBase } from 'lib/service/screen-base';
	export const isNumeric: (value: any) => boolean;
	export type AggFunc = DateAggregation;
	export const formatValueForSorting: (object: any, path: string, type?: NestedFieldTypes) => {
	    value: string | xtremDecimal.Decimal;
	    isDecimal: boolean;
	};
	export const caseInsensitiveSorting: (sortProperties: [string, boolean][], columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[]) => (obj1: any, obj2: any) => number;
	export function transformFilterForCollectionValue(outerInput: any): any;
	/**
	 * Sorts a referenced ResultSet based on the received orderBy sequence
	 * @param resultSet - lokijs ResultSet instance
	 * @param [orderBy] - sequence of property name / sorting type (1 for asc, -1 for desc) pairs
	 * @returns ResultSet
	 */
	export const sortResultSet: ({ resultSet, orderBy, columnDefinitions, }: {
	    resultSet: Resultset<any>;
	    orderBy?: OrderByType;
	    columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[];
	}) => Resultset<any>;
	export function getGroupKey(groupKey?: string): string;
	export const getGroupFilterValue: ({ group, mode, }: {
	    group?: {
	        key: string;
	        value?: string;
	        aggFunc?: AggFunc;
	    };
	    mode: 'server' | 'client';
	}) => any;
	export class CollectionDataRow<T extends ClientNode> {
	    private readonly input;
	    private readonly columnDefinitions;
	    private readonly nodes;
	    private readonly nodeTypes;
	    private readonly options?;
	    private result;
	    private readonly includeActions;
	    private readonly removeNegativeId;
	    private readonly isRequestingDefaults;
	    private readonly cleanInputTypes;
	    constructor(input: InternalValue<T>, columnDefinitions: Array<NestedField<ScreenBase, NestedFieldTypes, any>[]>, nodes: string[], nodeTypes: Dict<FormattedNodeDetails>, options?: {
	        includeActions?: boolean | undefined;
	        removeNegativeId?: boolean | undefined;
	        isRequestingDefaults?: boolean | undefined;
	        cleanInputTypes?: boolean | undefined;
	        isTree?: boolean | undefined;
	    } | undefined);
	    protected getLevel(): number;
	    protected getDirtyColumns(): Set<string> | undefined;
	    protected getAction(): RecordActionType | undefined;
	    protected isRemoved(): boolean;
	    protected removeTransientColumns(): this;
	    protected removeComputedColumns(): this;
	    protected cleanupRemoved(): this;
	    protected cleanMetadataFromRecord(): this;
	    protected removeNonInputTypes(): this;
	    protected extractDirty(): this;
	    protected cloneAction(): this;
	    protected deleteNegativeId(): this;
	    protected removeNullOnlyLeaves(): this;
	    protected splitValueToMergedValue(): this;
	    getChangeset(): any;
	    private readonly getNode;
	    private readonly getColumnDefinitions;
	}
	//# sourceMappingURL=collection-data-utils.d.ts.map
}
declare module 'lib/component/field/table/table-component-types' {
	import type { GridApi } from '@ag-grid-community/core';
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
	import React from 'react';
	import type { FocusPosition, OnTelemetryEventFunction, ReduxResponsive, TableView, TableViewGrouping, TableViewSortedColumn } from 'lib/redux/state';
	import type { CollectionValue } from 'lib/service/collection-data-service';
	import type { AggFunc } from 'lib/service/collection-data-utils';
	import type { GraphQLApi } from 'lib/service/graphql-api';
	import type { GraphQLFilter } from 'lib/service/graphql-utils';
	import type { DataTypeDetails, FormattedNodeDetails } from 'lib/service/metadata-types';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ContextType, NestedRecordId, NodePropertyType, ScreenExtension } from 'lib/types';
	import type { OverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { ColumnCompareType } from 'lib/utils/table-component-utils';
	import type { ValueOrCallback, ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { BlockControlObject, BulkAction, CollectionValueFieldProperties, IPageAction, MenuSeparatorType, OptionsMenuItem, PageActionControlObject, SectionControlObject, TableOptionsMenuType } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { GridNestedFieldTypes, NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { NestedExtensionField } from 'lib/component/nested-fields-extensions';
	import type { NestedOverrideField } from 'lib/component/nested-fields-overrides';
	import type { SidebarDefinitionDecorator } from 'lib/component/table-sidebar/table-sidebar-types';
	import type { CollectionItem, FieldControlObjectInstance, PartialCollectionValueWithIds, TableDisplayMode } from 'lib/component/types';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { CollectionItemAction, CollectionItemActionGroup, InlineCollectionItemAction } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import type { AdditionalFieldAction } from 'lib/component/field/field-actions-component';
	import type { FieldComponentExternalProperties } from 'lib/component/field/field-base-component-types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { CanBeReadOnly, CanFetchDefaults, Clickable, ExtensionField, HasCalendarConfigurationOptions, HasCollectionAdditionEventHandler, HasCollectionSelectionEventHandlers, HasCollectionSelectionEventHandlersAfter, HasColumns, HasDynamicLookupSuggestions, HasFieldActions, HasOptionsMenu, HasParent, HasRowChangeIndicators, HasSound } from 'lib/component/field/traits';
	export interface TableProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends CollectionValueFieldProperties<CT, NestedRecordType>, HasRowChangeIndicators, HasColumns<CT, NestedRecordType>, HasFieldActions<CT>, CanBeReadOnly<CT, NestedRecordType>, HasOptionsMenu<CT>, HasSound<CT> {
	    /**
	     * Whether new rows can be added or not.
	     * If set to true infinite scroll will be enabled and a new "phantom row" will appear at the bottom of the table.
	     * Additionally an "add" action button will be added to the table.
	     * Defaults to false
	     * */
	    canAddNewLine?: boolean;
	    /**
	     * Whether the "phantom row" will be displayed or not.
	     * If set to true the "add" action button will be also removed from the table.
	     * Defaults to false.
	     */
	    isPhantomRowDisabled?: boolean;
	    /** Whether the rows of the table can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	    /** Whether the user can decide which table columns to display. Defaults to true */
	    canUserHideColumns?: boolean;
	    /** Determines how the table rows are displayed. Defaults to "comfortable" */
	    displayMode?: TableDisplayMode;
	    /** Whether in mobile devices a search box should be displayed or not */
	    hasSearchBoxMobile?: boolean;
	    /** The property that will be used to identify a record when showing validation errors. Defaults to "_id". */
	    mainField?: PropertyValueType<NestedRecordType> & string;
	    /** The definitions of the nested fields used to represent the table rows in mobile devices.
	     * If no value is provided, the first four columns are used by default */
	    mobileCard?: CardDefinition<CT, NestedRecordType>;
	    /** Actions that are rendered at the end of the table as inline buttons **/
	    inlineActions?: Array<InlineCollectionItemAction<any>>;
	    /** Actions that are rendered at the end of the table as a drop-down menu */
	    dropdownActions?: Array<CollectionItemAction<CT> | CollectionItemActionGroup<CT> | MenuSeparatorType>;
	    /** Selected rows identifiers */
	    selectedRecords?: NestedRecordId[];
	    /** The GraphQL node that the table represents, needed for filtering */
	    cardView?: boolean;
	    /** Table can be exported to .XLSX or CSV files */
	    canExport?: boolean;
	    /** Whether all table columns can be resized or not. Defaults to false. */
	    canResizeColumns?: boolean;
	    /** Provides a custom function to sort columns */
	    sortColumns?: (this: CT, firstColumn: ColumnCompareType, secondColumn: ColumnCompareType) => number;
	    /** Actions that are rendered on the top of the field, in the title line */
	    headerBusinessActions?: ValueOrCallback<CT, PageActionControlObject | PageActionControlObject[]>;
	    /** These actions are added in the add items dropdown, the actions are only rendered if the user can add lines to the table */
	    addItemActions?: ValueOrCallback<CT, PageActionControlObject[]>;
	    sidebar?: SidebarDefinitionDecorator<CT, NestedRecordType>;
	    /** Displays line numbers in front of each line. The line numbers are static and not related to the data */
	    hasLineNumbers?: boolean;
	}
	export interface PageAction<CT extends ScreenExtension<CT>> extends IPageAction<CT> {
	    icon: string;
	}
	export interface TableDecoratorProperties<CT extends ScreenBase = ScreenBase, NestedRecordType extends ClientNode = any> extends TableProperties<CT, NestedRecordType>, Clickable<CT>, HasFieldActions<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT> | SectionControlObject<CT>>, HasCollectionSelectionEventHandlers<CT, NestedRecordType>, HasCollectionAdditionEventHandler<CT, NestedRecordType>, CanFetchDefaults, HasCalendarConfigurationOptions<CT, NestedRecordType>, CanBeReadOnly<CT, NestedRecordType> {
	    /** Function to be executed when the table field's value changes */
	    onChange?: (this: CT, recordId: NestedRecordId, column: string, rowItem: NestedRecordType) => void;
	    /** Function to be executed when any part of a row is clicked */
	    onRowClick?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType, isModifierKeyPushed?: boolean) => void;
	    /** Actions that are rendered at the end of the table as inline buttons */
	    inlineActions?: Array<InlineCollectionItemAction<CT, NestedRecordType>>;
	    /** Actions that are rendered at the end of the table as a drop-down menu */
	    dropdownActions?: Array<CollectionItemAction<CT, NestedRecordType> | CollectionItemActionGroup<CT, NestedRecordType> | MenuSeparatorType>;
	    /** Sets a text when no data is available in the table */
	    emptyStateText?: string;
	    /** Sets a complementary text link when no data is available in the table  */
	    emptyStateClickableText?: string;
	    /** Function to be executed when the clickable text is clicked */
	    onEmptyStateLinkClick?: (this: CT) => void;
	}
	type BaseTableExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase, NestedRecordType extends ClientNode = any> = HasCollectionSelectionEventHandlersAfter<CT, NestedRecordType> & {
	    /** Function to be executed when the table field's value changes after base onChange*/
	    onChangeAfter?: (this: CT, recordId: NestedRecordId, column: string, rowItem: NestedRecordType) => void;
	    /** Function to be executed when any part of a row is clicked after onRowClick */
	    onRowClickAfter?: (this: CT, recordId: NestedRecordId, rowItem: NestedRecordType) => void;
	};
	export interface TableExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> extends BaseTableExtensionDecoratorProperties<Extend<CT>>, OverrideDecoratorProperties<TableDecoratorProperties<Extend<CT>, ReferencedItemType>> {
	    /** The definitions of the nested fields used to represent the table rows */
	    columns?: NestedExtensionField<CT, GridNestedFieldTypes, ReferencedItemType>[];
	    /** Allows overriding existing column properties in the base page's columns */
	    columnOverrides?: NestedOverrideField<CT, GridNestedFieldTypes, ReferencedItemType>[];
	}
	export interface InternalTableProperties<CT extends ScreenExtension<CT> = ScreenBase, NRT extends ClientNode = any> extends TableProperties<CT, NRT>, HasDynamicLookupSuggestions<CT, NRT>, HasCalendarConfigurationOptions<CT, NRT> {
	    activeUserFilter?: GraphQLFilter;
	    emptyStateClickableText?: string;
	    emptyStateText?: string;
	    hiddenColumns?: string[];
	    isAutoSelectEnabled?: boolean;
	    isNewEnabled?: boolean;
	    isReadOnly?: ValueOrCallbackWithFieldValue<CT, boolean, any, NRT>;
	    isSelectAllChecked?: boolean;
	    onEmptyStateLinkClick?: (this: CT, recordId?: string, level?: number) => void;
	    onRowClick?: (this: CT, recordId: NestedRecordId, rowItem: NRT) => void;
	    optionsMenu?: ValueOrCallback<CT, OptionsMenuItem[]>;
	    optionsMenuType?: TableOptionsMenuType;
	    valueField?: string;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    tableViewMode?: TableViewMode;
	    additionalFieldActions?: AdditionalFieldAction[];
	}
	export interface TableComponentExternalProps extends FieldComponentExternalProperties {
	    bulkActions?: BulkAction[];
	    mobilePerformInitialLoadTableData?: boolean;
	    searchText?: string;
	    errorMessage?: string;
	    isParentDisabled?: boolean;
	    lookupSelectionMode?: 'single' | 'multiple';
	}
	export type OnRowClickFunction = (recordId: NestedRecordId, newRecord?: CollectionItem, isModifierKeyPushed?: boolean) => () => void;
	export interface TableInternalComponentProps<CT extends ScreenExtension<CT> = ScreenBase, FieldProperties extends EditableFieldProperties = InternalTableProperties<CT>> {
	    accessBindings: AccessBindings;
	    additionalLookupRecords?: () => PartialCollectionValueWithIds<any>[];
	    activeLookupDialog?: FocusPosition | null;
	    api?: GridApi;
	    bulkActions?: BulkAction[];
	    canDragCard?: boolean;
	    contextType?: ContextType;
	    dataTypes: Dict<DataTypeDetails>;
	    elementId: string;
	    emptyStateClickableText?: string;
	    emptyStateText?: string;
	    enumTypes: Dict<string[]>;
	    errorMessage?: string;
	    fieldProperties: FieldProperties;
	    filterModel?: any;
	    fixedHeight?: number;
	    graphApi?: GraphQLApi<any>;
	    groupByField?: PropertyValueType;
	    groupTitle?: string;
	    isAutoSelectEnabled?: boolean;
	    isInFocus?: boolean;
	    isNavPanel?: boolean;
	    isParentDisabled?: boolean;
	    isReadOnly?: ValueOrCallbackWithFieldValue<CT, boolean>;
	    isUsingInfiniteScroll?: boolean;
	    locale: LocalizeLocale;
	    lookupSelectionMode?: 'single' | 'multiple';
	    nodeTypes: Dict<FormattedNodeDetails>;
	    numberOfVisibleRows?: number;
	    onEmptyStateClickableText?: () => void;
	    onFocus?: (screenId: string, elementId: string, row: string, nestedField: string) => void;
	    onRowClick?: OnRowClickFunction;
	    recordContext?: any;
	    openedRecordId?: string | number | null;
	    pageNode?: NodePropertyType;
	    screenId: string;
	    searchText?: string;
	    selectedRecordId?: string | number | boolean;
	    selectedOptionsMenuItem?: OptionsMenuItem;
	    setFieldProperties?: (elementId: string, properties: InternalTableProperties<ScreenBase>) => void;
	    setGlobalLoading?: (setGlobalLoading: boolean) => void;
	    setTableViewColumnHidden?: (level: number, columnHidden?: Dict<boolean>) => void;
	    setTableViewColumnOrder?: (level: number, columnOrder?: string[]) => void;
	    setTableViewFilter?: (level: number, filter?: any) => void;
	    setTableViewGrouping?: (level: number, grouping?: TableViewGrouping) => void;
	    setTableViewOptionsMenuItem?: (level: number, optionsMenuItem?: OptionsMenuItem) => void;
	    setTableViewSearchText?: (level: number, searchText: string) => void;
	    setTableViewSortOrder?: (level: number, sortOrder?: TableViewSortedColumn[]) => void;
	    setTableViewOptionsMenuItemAndViewFilter?: (level: number, optionsMenuItem?: OptionsMenuItem, filter?: any) => void;
	    tableViews?: Dict<TableView>;
	    username?: string;
	    validationErrors: ValidationResult[];
	    value: CollectionValue;
	    onTelemetryEvent?: OnTelemetryEventFunction;
	}
	export interface TableComponentProps extends TableComponentExternalProps {
	    accessBindings: AccessBindings;
	    additionalLookupRecords?: () => PartialCollectionValueWithIds<any>[];
	    browser: ReduxResponsive;
	    bulkActions?: BulkAction[];
	    canDragCard?: boolean;
	    contextType?: ContextType;
	    dataTypes: Dict<DataTypeDetails>;
	    enableMobileLoadMore?: boolean;
	    ensureFieldHasValue?: () => CollectionValue;
	    enumTypes: Dict<string[]>;
	    fieldProperties: InternalTableProperties<ScreenBase>;
	    groupByField?: PropertyValueType;
	    groupKey?: string;
	    isAutoSelectEnabled?: boolean;
	    isLoading?: boolean;
	    isUsingInfiniteScroll?: boolean;
	    locale: LocalizeLocale;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    numberOfVisibleRows?: number;
	    onEmptyStateClickableText?: () => void;
	    onFocus?: (screenId: string, elementId: string, row: string, nestedField: string) => void;
	    onRowClick?: (rowValue: CollectionItem, isModifierKeyPushed: boolean) => void;
	    recordContext?: any;
	    setFieldProperties?: (elementId: string, properties: InternalTableProperties<ScreenBase>) => void;
	    setGlobalLoading?: (setGlobalLoading: boolean) => void;
	    tableViews: Dict<TableView>;
	    username?: string;
	    validate?: (elementId: string, value: CollectionValue) => Promise<ValidationResult[] | undefined>;
	    validationErrors: ValidationResult[];
	    value: CollectionValue;
	}
	export interface ColumnsData<T extends NestedFieldTypes = NestedFieldTypes> {
	    columnDefinition: NestedField<ScreenBase, T>;
	    bind: string;
	    elementId: string;
	}
	export type FilterModel = any;
	export type TableViewMode = 'table' | 'calendar';
	export enum GroupState {
	    FULL_SELECTED = "fullSelected",
	    PARTIAL_SELECTED = "partialSelected",
	    NOT_SELECTED = "notSelected"
	}
	export interface GroupStateType {
	    total: number;
	    currentSelected?: number;
	    state?: GroupState;
	    aggFunc?: AggFunc;
	}
	export interface SelectedGroupState {
	    [key: string]: {
	        [key: string]: GroupStateType;
	    };
	}
	export abstract class AgGridCellEditorComponent<P = {}, S = {}, ValueType extends any = string> extends React.Component<P, S> {
	    abstract getValue(): ValueType | null;
	}
	export {};
	//# sourceMappingURL=table-component-types.d.ts.map
}
declare module 'lib/utils/nested-field-utils' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { CalendarProperties, PodCollectionDecoratorProperties, TableProperties } from 'lib/component/control-objects';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { GridLodable } from 'lib/service/collection-data-service';
	import type { ScreenBase } from 'lib/service/screen-base';
	export const isNestedField: (maybeNestedField: any) => boolean;
	export type NestedFieldPropertyType = GridLodable | TableProperties | InternalTableProperties | CalendarProperties | PodCollectionDecoratorProperties;
	export const getNestedFieldsFromProperties: <T extends ClientNode = any>(properties: NestedFieldPropertyType) => NestedField<any, any, T>[];
	/**
	 * Resolve title field from a card definition to a display string value.
	 */
	export const getImagePlaceholderValue: (record: any, titleField: NestedField<ScreenBase, NestedFieldTypes>) => string | undefined;
	/**
	 * Turn nested bind property reference object to dot-notion reference. For example, it converts `{this:{is:{a:{nested:{bind:true}}}}}`
	 * to `this.is.a.nested.bind`.
	 * @param path string or deep bind object
	 * @returns dot notion deep reference string
	 */
	export const convertDeepBindToPath: (path?: string | PropertyValueType | boolean) => string | null;
	/**
	 * Same as convertDeepBindToPath, but throws an error if the value is null or undefined.
	 * @param path
	 */
	export const convertDeepBindToPathNotNull: (path?: string | PropertyValueType | boolean) => string;
	/**
	 * Returns to first component of a nested bind property For example, it converts `hi`, `hi.there` and `{hi:{there:true}}` to `hi`.
	 * @param path
	 * @returns top level property name
	 */
	export const getTopLevelBindFromNestedBindNotNull: (path?: string | PropertyValueType) => string;
	/**
	 * Returns to first component of a nested bind property For example, it converts `hi`, `hi.there` and `{hi:{there:true}}` to `hi`.
	 * @param path
	 * @returns top level property name
	 */
	export function getTopLevelBindFromNestedBind(path: string | PropertyValueType): string;
	export function getTopLevelBindFromNestedBind(path: undefined | PropertyValueType): undefined;
	//# sourceMappingURL=nested-field-utils.d.ts.map
}
declare module 'lib/component/container/section/section-control-object' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import type { ScreenExtension } from 'lib/types';
	import type { ContainerProperties } from 'lib/component/abstract-container';
	import { AbstractContainer } from 'lib/component/abstract-container';
	import type { ContainerComponentProps, ContainerControlObjectConstructorProps } from 'lib/component/types';
	import { ContainerKey } from 'lib/component/types';
	export interface SectionProperties<CT extends ScreenBase = ScreenBase> extends ContainerProperties<CT> {
	    /** Whether the helper panel can be extracted into a separate window or not. Defaults to false */
	    isExtendable?: boolean;
	    /** Whether the section is open (uncollapsed) or not. Defaults to true */
	    isOpen?: boolean;
	    /** The display mode of the section. In accordion mode all blocks are displayed full width, regardless to their width configuration */
	    mode?: 'normal' | 'accordion';
	}
	export interface ISectionControlObject extends ContainerControlObjectConstructorProps<ContainerKey.Section> {
	    dispatchSectionValidation: () => Promise<{
	        allErrors: ValidationResult[];
	        blockingErrors: ValidationResult[];
	    }>;
	}
	/**
	 * [Container]{@link AbstractContainer} that holds any number of [blocks]{@link BlockControlObject}
	 */
	export class SectionControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.Section, ContainerComponentProps<ContainerKey.Section>> {
	    insertBefore?: ContainerControlObjectConstructorProps<ContainerKey.Section>['insertBefore'];
	    private readonly _dispatchSectionValidation;
	    static readonly defaultUiProperties: Partial<SectionProperties>;
	    constructor(properties: ISectionControlObject);
	    /** Whether the section is collapsed (isOpen = false) or not (isOpen = true) */
	    isOpen?: boolean;
	    /**
	     * Whether the section can be extended into a separate window (extendable = true)
	     * or not (extendable = false)
	     */
	    isExtendable?: boolean;
	    /**
	     * Triggers the validation rules of all the fields of the section. Since the validation rules
	     * might be asynchronous, this method returns a promise that must be awaited to get
	     * the validation result
	     */
	    validate(): Promise<string[]>;
	    /**
	     * Triggers the field validation rules. Since the validation rules might be asynchronous,
	     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
	     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
	     */
	    validateWithDetails(partition: true): Promise<{
	        allErrors: ValidationResult[];
	        blockingErrors: ValidationResult[];
	    }>;
	    validateWithDetails(partition: false): Promise<ValidationResult[]>;
	    validateWithDetails(): Promise<ValidationResult[]>;
	}
	//# sourceMappingURL=section-control-object.d.ts.map
}
declare module 'lib/utils/duplication-utils' {
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { PageMetadata } from 'lib/service/page-metadata';
	/**
	 * Replaces the page's business actions with the duplicate actions
	 * It mutates the pageDefinition object
	 * */
	export function applyDuplicationBusinessActions(pageDefinition: PageDefinition): void;
	/**
	 * Replaces the page's layout with a single section that contains only the fields which are required for duplication
	 * It mutates the pageDefinition object
	 * */
	export function applyDuplicationLayoutStructure(pageDefinition: PageDefinition): void;
	/**
	 * Add a section and a block control object to the page definition
	 * @param pageMetadata
	 * @returns
	 */
	export function addDuplicationLayoutContainers(pageMetadata: PageMetadata): void;
	//# sourceMappingURL=duplication-utils.d.ts.map
}
declare module 'lib/service/page-definition' {
	import type { AccessStatus, Dict } from '@sage/xtrem-shared';
	import type { Constructible } from 'lib/types';
	import type { Page } from 'lib/service/page';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { QueryParameters } from 'lib/utils/types';
	export type AccessBindings = Dict<Dict<AccessStatus>>;
	export interface PageDefinition extends ScreenBaseDefinition {
	    activeSection: string | null;
	    is360ViewOn?: boolean;
	    isInDialog: boolean;
	    isMainPage: boolean;
	    isReady: boolean;
	    page: Page;
	    path: string;
	    queryParameters: QueryParameters;
	    selectedRecordId: string | null;
	}
	export const getNewPageDefinition: () => Partial<PageDefinition>;
	export const getPageDefinition: (pageConstructor: Constructible<Page>, path: string, isMainPage: boolean, isDuplicate?: boolean) => PageDefinition;
	//# sourceMappingURL=page-definition.d.ts.map
}
declare module 'lib/service/graphql-api' {
	import { Graph } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { OmitProperties } from 'ts-essentials';
	import type { ComponentKey } from 'lib/component/types';
	import type { ScreenBase } from 'lib/service/screen-base';
	export const nonSavableFieldType: ComponentKey[];
	interface DeletionArguments<K> {
	    nodeName?: K;
	    _id?: string | number;
	}
	interface DuplicationArguments<K> {
	    nodeName?: K;
	    _id?: string | number;
	    values?: Dict<any>;
	}
	interface CreationArguments<K> extends DeletionArguments<K> {
	    values?: Dict<any>;
	    fieldsToReturn?: string[];
	}
	type ModificationArguments<K> = CreationArguments<K>;
	type QueryOrReadExtractor<T> = {
	    [K in keyof T]: K extends 'query' | 'read' | 'aggregate' ? T[K] : never;
	};
	type QueryOrRead<T> = OmitProperties<QueryOrReadExtractor<T>, never>;
	export class ReadOnlyGraphQLApi<TGraphqlApi> {
	    readonly graph: Graph<TGraphqlApi>;
	    constructor();
	    node<K extends keyof TGraphqlApi>(nodeName: K): QueryOrRead<TGraphqlApi[K]>;
	    raw(query: string, isMetaDataQuery?: boolean): Promise<any>;
	}
	export class GraphQLApi<TGraphqlApi> {
	    protected readonly screenBase: ScreenBase;
	    readonly graph: Graph<TGraphqlApi>;
	    constructor(screenBase: ScreenBase);
	    private getQueryParameters;
	    node<K extends keyof TGraphqlApi>(nodeName: K): TGraphqlApi[K];
	    /**
	     * Executes a raw GraphQL query string against the server endpoint.
	     * @param query the query string
	     * @param skipErrorProcessing if this property is set to true, the framework will not try to intercept the error and
	     * @returns
	     */
	    raw(query: string, skipErrorProcessing?: boolean, isMetaDataQuery?: boolean): Promise<any>;
	    private nodeName;
	    private applyUpdateToValue;
	    private getNonTransientFieldsQuery;
	    create<K extends keyof TGraphqlApi>(args?: CreationArguments<K>): Promise<void>;
	    update<K extends keyof TGraphqlApi>(args?: ModificationArguments<K>, skipUpdate?: boolean): Promise<void>;
	    delete<K extends keyof TGraphqlApi>(args?: DeletionArguments<K>): Promise<void>;
	    duplicate<K extends keyof TGraphqlApi>(args?: DuplicationArguments<K>): Promise<string | null>;
	}
	export {};
	//# sourceMappingURL=graphql-api.d.ts.map
}
declare module 'lib/utils/server-error-transformer' {
	import React from 'react';
	import type { ClientError, ErrorDetail } from '@sage/xtrem-client';
	import type { Dict } from '@sage/xtrem-shared';
	import type { PodCollectionDecoratorProperties } from 'lib/component/control-objects';
	import type { DetailListDecoratorProperties, NestedGridDecoratorProperties, PodDecoratorProperties, TableDecoratorProperties, VitalPodDecoratorProperties } from 'lib/component/decorators';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	export interface TransformedServerError {
	    validationErrors: Dict<ValidationResult[]>;
	    globalError?: Error;
	}
	type NestedFieldDecoratorProperties = TableDecoratorProperties | NestedGridDecoratorProperties | PodCollectionDecoratorProperties | PodDecoratorProperties<any, any> | VitalPodDecoratorProperties<any, any> | DetailListDecoratorProperties;
	export const findNestedFieldProperties: (screenId: string, columnId: string, fieldProperties: NestedFieldDecoratorProperties, level?: number) => string;
	export const transformServerErrorToToast: (error: ClientError, screenBase: ScreenBase) => Promise<TransformedServerError>;
	export class ServerError extends Error {
	    readonly toastContent: React.ReactNode;
	    readonly errors: ErrorDetail[];
	    constructor(message: string, toastContent: React.ReactNode, errors: ErrorDetail[]);
	}
	export {};
	//# sourceMappingURL=server-error-transformer.d.ts.map
}
declare module 'lib/utils/events' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { HasGenericErrorHandler } from 'lib/component/field/traits';
	import type { NestedFieldsProperties } from 'lib/component/nested-fields';
	import type { Events } from 'lib/component/types';
	type NestedFieldComponentProperties = NestedFieldsProperties<any> & HasGenericErrorHandler<any>;
	type HandledEventContainer = {
	    onClick: Function;
	    onError?: Function;
	    onClickAfter?: Array<Function>;
	    delegateErrorToCaller?: boolean;
	};
	type ForScreen<Rest extends unknown[]> = (screenId: string, ...args: Rest) => Promise<void>;
	type ForField<Rest extends unknown[]> = (screenId: string, elementId: string, ...args: Rest) => Promise<void>;
	type ForNestedField<Rest extends unknown[]> = (screenId: string, elementId: string, nestedDef: NestedFieldComponentProperties, ...args: Rest) => Promise<void>;
	type TriggerEventForScreen = ForScreen<[eventName: Extract<Events, 'onLoad' | 'onOpen'>] | [eventName: Extract<Events, 'onClose'>, isWizardFinished?: boolean] | [eventName: Extract<Events, 'onDirtyStateUpdated' | 'on360ViewSwitched'>, state: boolean]>;
	type TriggerEventForField = ForField<[eventName: Extract<Events, 'onActive' | 'onInactive' | 'onAllDataLoaded' | 'onDataLoaded'>] | [eventName: Extract<Events, 'onChange'>] | [eventName: Extract<Events, 'onClick'>] | [eventName: Extract<Events, 'onReady'>] | [eventName: Extract<Events, 'onHeaderValueChanged' | 'onFooterValueChanged'>, newValue?: string] | [eventName: Extract<Events, 'onEmptyStateLinkClick'>] | [eventName: Extract<Events, 'onEmptyStateLinkClick'>, parentId?: string, level?: number] | [eventName: Extract<Events, 'onClick'>, rowId: string, rowData: Dict<any>, level?: number, ancestorIds?: string[]] | [
	    eventName: Extract<Events, 'onChange' | 'onRecordAdded' | 'onRecordClick' | 'onRecordRemoved' | 'onRowAdded' | 'onRowActivated' | 'onRowClick' | 'onRowDeactivated' | 'onRowSelected' | 'onRowUnselected'>,
	    rowId: string,
	    rowData: Dict<any>,
	    level?: number,
	    ancestorIds?: string[]
	] | [eventName: Extract<Events, 'onRecordClick'>, rowData: Dict<any>] | [
	    eventName: Extract<Events, 'onEventClick'>,
	    eventId: string,
	    event: Dict<any> | null,
	    isModifierKeyPushed: boolean
	] | [eventName: Extract<Events, 'onDayClick'>, date: Date] | [eventName: Extract<Events, 'onInputValueChange'>, inputValue: string] | [eventName: Extract<Events, 'onFileInfo'>, mimetype: string, length: number, fileName: string] | [
	    eventName: Extract<Events, 'onCloseReferenceDialog' | 'onOpenReferenceDialog' | 'onCloseMultiReferenceDialog' | 'onOpenMultiReferenceDialog' | 'onCloseFilterSelectDialog' | 'onOpenFilterSelectDialog'>
	]>;
	type TriggerEventForNestedField = ForNestedField<[eventName: Extract<Events, 'onClick'>, rowId: string, rowData: Dict<any>, level?: number, ancestorIds?: string[]] | [
	    eventName: Extract<Events, 'onChange'>,
	    columnId: string,
	    rowData: Dict<any>,
	    level?: number,
	    ancestorIds?: string[]
	]>;
	type ForHandledEventContainer<Rest extends unknown[]> = (screenId: string, elementId: string, handledEventContainer: HandledEventContainer, ...args: Rest) => Promise<void>;
	type TriggerHandledEvent = ForHandledEventContainer<[
	] | [rowId: string, rowData: Dict<any>] | [rowId: string, rowData: Dict<any>, level: number, ancestorIds: string[]]>;
	export const triggerScreenEvent: TriggerEventForScreen;
	export const triggerFieldEvent: TriggerEventForField;
	export const triggerNestedFieldEvent: TriggerEventForNestedField;
	export const triggerHandledEvent: TriggerHandledEvent;
	export const isBulkChange: (s1: string, s2: string) => boolean;
	export const executeCallbackInScreenContext: (callback: Function, screenId: string, ...args: any[]) => void;
	export {};
	//# sourceMappingURL=events.d.ts.map
}
declare module 'lib/component/field/carbon-helpers' {
	/// <reference types="react" />
	import type { ValidationResult } from 'lib/service/screen-base-definition';
	import { ContextType } from 'lib/types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { UiComponentProperties } from 'lib/component/abstract-ui-control-object';
	import type { PageProperties } from 'lib/component/container/container-properties';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { NestedFieldHandlersArguments } from 'lib/component/nested-fields';
	import type { ReadonlyFieldProperties } from 'lib/component/readonly-field-control-object';
	import type { EditableFieldComponentProperties, FieldComponentExternalProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	export type FieldProps = EditableFieldComponentProperties<any, any> & FieldComponentExternalProperties & NestedFieldsAdditionalProperties;
	export const getLabelTitle: (screenId: string, fieldProperties: EditableFieldProperties, rowValue: any) => string | undefined;
	export const generateFieldId: ({ contextType, elementId, fieldProperties, isNested, parentElementId, screenId, }: {
	    contextType?: ContextType;
	    elementId: string;
	    fieldProperties: any;
	    isNested: boolean;
	    parentElementId?: string;
	    screenId: string;
	}) => string;
	export const isFieldReadOnly: (screenId: string, fieldProperties: EditableFieldProperties, fieldValue: any, rowValue: any, contextType?: ContextType) => boolean;
	interface GetFieldIndicatorStatusArgs {
	    screenId: string;
	    value?: any;
	    validationErrors?: ValidationResult[];
	    fieldProperties: {
	        warningMessage?: ValueOrCallbackWithFieldValue<any, string>;
	        infoMessage?: ValueOrCallbackWithFieldValue<any, string>;
	    };
	    handlersArguments?: NestedFieldHandlersArguments;
	    isParentDisabled?: boolean;
	    isParentHidden?: boolean;
	}
	export const getFieldIndicatorStatus: ({ validationErrors, screenId, value: fieldValue, fieldProperties, handlersArguments, isParentDisabled, isParentHidden, }: GetFieldIndicatorStatusArgs) => {
	    error?: string;
	    info?: string;
	    warning?: string;
	};
	export const isFieldDisabled: (screenId: string, fieldProperties: EditableFieldProperties, fieldValue: any, rowValue: any) => boolean;
	export const getFieldTitle: (screenId: string, fieldProperties: UiComponentProperties, rowValue: any) => string;
	export const isFieldHidden: (screenId: string, fieldProperties: UiComponentProperties, rowValue: any) => boolean;
	export const isFieldTitleHidden: (screenId: string, fieldProperties: UiComponentProperties, rowValue: any) => boolean;
	export const getFieldHelperText: (screenId: string, fieldProperties: ReadonlyFieldProperties, rowValue: any) => string;
	export const isFieldHelperTextHidden: (screenId: string, fieldProperties: ReadonlyFieldProperties, rowValue: any) => string;
	export const getPageSubtitle: (screenId: string, fieldProperties: PageProperties, rowValue: any) => string | null;
	export const onBlurHandler: (props: FieldProps) => void;
	export const onFocusHandler: (props: FieldProps) => void;
	export const getCommonCarbonComponentProperties: (props: FieldProps, children?: JSX.Element) => any;
	export {};
	//# sourceMappingURL=carbon-helpers.d.ts.map
}
declare module 'lib/service/dialog-service' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { Store } from 'redux';
	import * as xtremRedux from 'lib/redux';
	import type { CustomDialogContentType, CustomDialogOptions, DialogButton, DialogButtonOptions, DialogContentType, DialogLevel, DialogOptions, DialogType, IDialogControl, PageDialogOptions } from 'lib/types/dialogs';
	import type { QueryParameters } from 'lib/utils/types';
	/** For unit tests only */
	export const resetDialogIds: () => void;
	export class DialogControl implements IDialogControl {
	    [Symbol.toStringTag]: string;
	    readonly id: number;
	    protected readonly dialogPromise: Promise<void>;
	    private rejectPromise;
	    private resolvePromise;
	    constructor({ dialogId, screenId, level, title, content, getButtons, options, isSticker, isDirtyCheck, subtitle, type, }: {
	        dialogId: number;
	        screenId: string | null;
	        level: DialogLevel;
	        title: string | undefined;
	        content: DialogContentType;
	        getButtons: (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>;
	        options?: PageDialogOptions & CustomDialogOptions;
	        isSticker?: boolean;
	        isDirtyCheck: boolean;
	        subtitle?: string;
	        readonly type?: DialogType;
	    });
	    cancel(): void;
	    catch(callback: (dialogId: number) => any): Promise<any>;
	    then<TResult1 = any, TResult2 = any>(onFulfilled?: ((value: any) => TResult1 | PromiseLike<TResult1>) | undefined | null, onRejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
	    finally(onFinally?: (() => void) | null | undefined): Promise<any>;
	    resolve(value: Dict<any>): void;
	}
	export class PageDialogControl extends DialogControl {
	    [Symbol.toStringTag]: string;
	    constructor(dialogId: number, options?: PageDialogOptions);
	    resolve(value: Dict<any>): void;
	    finally(onFinally?: (() => void) | null | undefined): Promise<any>;
	    get promise(): Promise<void>;
	}
	export const closeDialog: (dialogId: number, result?: any, isWizardCompleted?: boolean) => Promise<void>;
	export const createDialog: <T extends DialogOptions = DialogOptions>(screenId: string, level: DialogLevel, title: string | undefined, content: DialogContentType, getButtons: (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>, options?: T, isSticker?: boolean, type?: DialogType) => DialogControl;
	export const createStickerDialog: (store: Store<xtremRedux.XtremAppState, xtremRedux.AppAction>, screenId: string, level: DialogLevel, title: string | undefined, content: DialogContentType, options?: CustomDialogOptions) => DialogControl;
	export const getDialogButton: (dialogId: number, callback: (value: any) => void, defaultText: string, buttonConfiguration?: DialogButtonOptions) => DialogButton;
	export const getAcceptButton: (dialogId: number, resolve: (value?: any) => void, buttonConfiguration?: DialogButtonOptions) => DialogButton;
	export const getCancelButton: (dialogId: number, callback: (reason?: any) => void, buttonConfiguration?: DialogButtonOptions) => DialogButton;
	export const getConfirmationButtons: (options?: DialogOptions) => (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>;
	export const errorDialog: (screenId: string, title: string, error: Error) => void;
	export const confirmationDialog: (screenId: string, level: DialogLevel, title: string, message: string, options?: DialogOptions) => DialogControl;
	export const messageDialog: (screenId: string, level: DialogLevel, title: string | undefined, message: string, options?: DialogOptions) => DialogControl;
	export const customDialog: (screenId: string, level: DialogLevel, content: CustomDialogContentType, options?: CustomDialogOptions) => DialogControl;
	export function resolvePageDialog(resolutionValue: any): void;
	export const pageDialog: <T>(store: Store<xtremRedux.XtremAppState, xtremRedux.AppAction>, path: string, queryParameters?: QueryParameters, options?: PageDialogOptions) => Promise<void | T>;
	export const openPageDialog: <T>(path: string, queryParameters?: QueryParameters, options?: PageDialogOptions) => Promise<void | T>;
	//# sourceMappingURL=dialog-service.d.ts.map
}
declare module 'lib/types/dialogs' {
	import type { BlockControlObject, PageControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { DialogControl } from 'lib/service/dialog-service';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { Dict } from '@sage/xtrem-shared';
	import type * as React from 'react';
	import type { QueryParameters } from 'lib/utils/types';
	export type DialogLevel = 'info' | 'success' | 'error' | 'warn';
	export type DialogContentType = string | Array<SectionControlObject | BlockControlObject> | SectionControlObject | BlockControlObject | Error | PageControlObject | null;
	export type DialogSize = 'extra-small' | 'small' | 'medium-small' | 'medium' | 'medium-large' | 'large' | 'extra-large';
	export interface DialogBodyContentProps<T extends BaseDialogOptions = BaseDialogOptions> {
	    dialog: DialogDescription<T>;
	    screenDefinition?: ScreenBaseDefinition;
	    availableColumns: number;
	    defaultFocusRef?: React.RefObject<any>;
	    selectedSection?: string | null;
	    noHeader?: boolean;
	    onStepOneSection: (direction: 1 | -1) => void;
	    isFirstSection: boolean;
	    isLastSection: boolean;
	}
	export interface DialogButtonOptions {
	    className?: string;
	    isDisabled?: boolean;
	    isHidden?: boolean;
	    isNegative?: boolean;
	    text?: string;
	}
	export interface BaseDialogOptions {
	    rightAligned?: boolean;
	    fullScreen?: boolean;
	    size?: DialogSize;
	    resolveOnCancel?: boolean;
	    reverseButtons?: boolean;
	    mdContent?: boolean;
	    isDirtyCheck?: boolean;
	    height?: number;
	}
	export interface PageDialogOptions extends BaseDialogOptions {
	    /** When this option is set, no warning is displayed if the user closes the dialog with unsaved content. */
	    skipDirtyCheck?: boolean;
	    /** Initial value of the dialog. When the value is set, the field values of the page dialog are automatically populated. */
	    values?: Dict<any>;
	    /** Set to true to duplicate the page */
	    isDuplicate?: boolean;
	    /** Optional title for the dialog */
	    title?: string;
	    /** Optional subtitle for the dialog */
	    subtitle?: string;
	}
	export interface CustomDialogOptions extends DialogOptions {
	    dialogTitle?: string;
	}
	export interface DialogOptions extends BaseDialogOptions {
	    acceptButton?: DialogButtonOptions;
	    cancelButton?: DialogButtonOptions;
	}
	export interface DialogButton {
	    className?: string;
	    isDisabled?: boolean;
	    isHidden?: boolean;
	    onClick: (value?: any) => void;
	    text: string;
	    isNegative?: boolean;
	}
	export type DialogType = 'page' | 'custom' | 'message' | 'confirmation' | 'error' | 'unknown';
	export interface DialogDescription<T extends BaseDialogOptions = BaseDialogOptions> {
	    dialogId: number;
	    isSticker: boolean;
	    isDirtyCheck?: boolean;
	    buttons: Dict<DialogButton>;
	    content: DialogContentType;
	    level: DialogLevel;
	    options: T;
	    screenId: string | null;
	    title?: string;
	    subtitle?: string;
	    dialogControl: DialogControl;
	    type?: DialogType;
	}
	export interface IDialogControl extends Promise<any> {
	    cancel: () => void;
	    finally(onFinally?: (() => void) | undefined | null): Promise<any>;
	    then<TResult1 = any, TResult2 = any>(onFulfilled?: ((value: any) => TResult1 | PromiseLike<TResult1>) | undefined | null, onRejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
	    catch<TResult = any>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<any | TResult>;
	}
	export type CustomDialogContentType = SectionControlObject | BlockControlObject | Array<SectionControlObject> | Array<BlockControlObject>;
	export interface IDialogApi {
	    confirmation: (level: DialogLevel, title: string, message: string, options?: DialogOptions) => IDialogControl;
	    message: (level: DialogLevel, title: string, message: string, options?: DialogOptions) => IDialogControl;
	    custom: (level: DialogLevel, content: CustomDialogContentType, options?: CustomDialogOptions) => IDialogControl;
	    page: (path: string, queryParameters?: QueryParameters, options?: PageDialogOptions) => Promise<any>;
	}
	//# sourceMappingURL=dialogs.d.ts.map
}
declare module 'lib/redux/reducer/active-dialogs' {
	import type { DialogDescription } from 'lib/types/dialogs';
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const activeDialogs: (state: Dict<DialogDescription<import("../../types/dialogs").BaseDialogOptions>> | undefined, action: AppAction) => Dict<DialogDescription>;
	//# sourceMappingURL=active-dialogs.d.ts.map
}
declare module 'lib/redux/reducer/current-lookup-dialog' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { FocusPosition } from 'lib/redux/state';
	export const activeLookupDialog: (state: FocusPosition | null | undefined, action: AppAction) => FocusPosition | null;
	//# sourceMappingURL=current-lookup-dialog.d.ts.map
}
declare module 'lib/redux/reducer/application-context' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { ApplicationContext } from 'lib/redux/state';
	export const applicationContext: (state: ApplicationContext | null | undefined, action: AppAction) => ApplicationContext | null;
	//# sourceMappingURL=application-context.d.ts.map
}
declare module 'lib/redux/reducer/application-packages' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const applicationPackages: (state: Dict<string> | null | undefined, action: AppAction) => Dict<string> | null;
	//# sourceMappingURL=application-packages.d.ts.map
}
declare module 'lib/redux/reducer/browser' {
	import type { Reducer } from 'redux';
	import type { IBrowser } from 'redux-responsive';
	import type { Breakpoints } from 'lib/render/responsive-breakpoints';
	export const browser: Reducer<IBrowser<Breakpoints>>;
	//# sourceMappingURL=browser.d.ts.map
}
declare module 'lib/redux/reducer/customization-wizard-page' {
	import type { AppAction } from 'lib/redux/action-types';
	export const customizationWizardPage: (state: string | null | undefined, action: AppAction) => string | null;
	//# sourceMappingURL=customization-wizard-page.d.ts.map
}
declare module 'lib/redux/reducer/dashboard-group' {
	import { type Dict } from '@sage/xtrem-shared';
	import type { UiDashboard } from 'lib/dashboard/dashboard-types';
	import type { WidgetDefinition } from 'lib/dashboard/widgets/abstract-widget';
	import type { AppAction } from 'lib/redux/action-types';
	import type { DashboardListItem } from 'lib/redux/state';
	export const dashboards: (state: Dict<UiDashboard> | undefined, action: AppAction) => Dict<UiDashboard>;
	export const widgets: (state: Dict<WidgetDefinition<{}>> | undefined, action: AppAction) => Dict<WidgetDefinition>;
	export const availableDashboards: (state: DashboardListItem[] | undefined, action: AppAction) => DashboardListItem[];
	//# sourceMappingURL=dashboard-group.d.ts.map
}
declare module 'lib/redux/reducer/dashboard-editor' {
	import type { Dashboard } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	import type { DashboardEditorState } from 'lib/redux/state';
	import type { Reducer } from 'redux';
	export const isOpen: (state: boolean | undefined, action: AppAction) => boolean;
	export const history: (state: Dashboard[] | undefined, action: AppAction) => Dashboard[];
	export const currentHistoryIndex: (state: number | undefined, action: AppAction) => number;
	export const currentDashboardDefinition: (state: Dashboard | undefined, action: AppAction) => Dashboard;
	export const isDirty: (state: boolean | undefined, action: AppAction) => boolean;
	export const dashboardEditor: Reducer<DashboardEditorState, AppAction>;
	//# sourceMappingURL=dashboard-editor.d.ts.map
}
declare module 'lib/redux/reducer/widget-editor' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { UserWidgetDefinition, WidgetEditorState } from 'lib/redux/state';
	import type { Reducer } from 'redux';
	export const isOpen: (state: boolean | undefined, action: AppAction) => boolean;
	export const isDirty: (state: boolean | undefined, action: AppAction) => boolean;
	export const widgetDefinition: (state: {} | undefined, action: AppAction) => UserWidgetDefinition;
	export const widgetId: (state: string | undefined, action: AppAction) => string;
	export const widgetEditor: Reducer<WidgetEditorState, AppAction>;
	//# sourceMappingURL=widget-editor.d.ts.map
}
declare module 'lib/redux/reducer/dashboard' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { DashboardGroupState, DashboardState } from 'lib/redux/state';
	import type { Reducer } from 'redux';
	import type { Dict } from '@sage/xtrem-shared';
	export const nodeNames: (state: {} | undefined, action: AppAction) => Dict<string>;
	export const widgetCategories: (state: {} | undefined, action: AppAction) => Dict<string>;
	export const canEditDashboards: (state: boolean | undefined, action: AppAction) => boolean;
	export const dashboardGroups: (state: Dict<DashboardGroupState> | undefined, action: AppAction) => Dict<DashboardGroupState>;
	export const dashboard: Reducer<DashboardState, AppAction>;
	//# sourceMappingURL=dashboard.d.ts.map
}
declare module 'lib/redux/reducer/data-types' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	import type { DataTypeDetails } from 'lib/service/metadata-types';
	export const dataTypes: (state: Dict<DataTypeDetails> | undefined, action: AppAction) => Dict<DataTypeDetails>;
	//# sourceMappingURL=data-types.d.ts.map
}
declare module 'lib/redux/reducer/enum-types' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const enumTypes: (state: Dict<string[]> | undefined, action: AppAction) => Dict<string[]>;
	//# sourceMappingURL=enum-types.d.ts.map
}
declare module 'lib/redux/reducer/export-configuration-page' {
	import type { AppAction } from 'lib/redux/action-types';
	export const exportConfigurationPage: (state: string | null | undefined, action: AppAction) => string | null;
	//# sourceMappingURL=export-configuration-page.d.ts.map
}
declare module 'lib/redux/reducer/focus-position' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { FocusPosition } from 'lib/redux/state';
	export const focusPosition: (state: FocusPosition | null | undefined, action: AppAction) => FocusPosition | null;
	//# sourceMappingURL=focus-position.d.ts.map
}
declare module 'lib/redux/reducer/is-keyboard-shortcuts-enabled' {
	import type { AppAction } from 'lib/redux/action-types';
	export const isKeyboardShortcutsEnabled: (state: boolean | undefined, action: AppAction) => boolean;
	//# sourceMappingURL=is-keyboard-shortcuts-enabled.d.ts.map
}
declare module 'lib/redux/reducer/loading' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { LoadingState } from 'lib/redux/state';
	export const loading: (state: LoadingState | undefined, action: AppAction) => LoadingState;
	//# sourceMappingURL=loading.d.ts.map
}
declare module 'lib/redux/reducer/menu-items' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { Menu } from 'lib/redux/state';
	export const formatBadgeContent: (badgeContent?: string) => string;
	export const menuItems: (state: Menu[] | undefined, action: AppAction) => Menu[];
	//# sourceMappingURL=menu-items.d.ts.map
}
declare module 'lib/redux/reducer/node-type' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	import type { FormattedNodeDetails } from 'lib/service/metadata-types';
	export const nodeTypes: (state: Dict<FormattedNodeDetails> | undefined, action: AppAction) => Dict<FormattedNodeDetails>;
	//# sourceMappingURL=node-type.d.ts.map
}
declare module 'lib/redux/reducer/path' {
	import type { AppAction } from 'lib/redux/action-types';
	export const path: (state: string | null | undefined, action: AppAction) => string | null;
	//# sourceMappingURL=path.d.ts.map
}
declare module 'lib/redux/reducer/plugins' {
	import type { XtremUiPlugin } from 'lib/service/plugin-service';
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const plugins: (state: Dict<XtremUiPlugin<any, any>> | undefined, action: AppAction) => Dict<XtremUiPlugin<any, any>>;
	//# sourceMappingURL=plugins.d.ts.map
}
declare module 'lib/redux/reducer/printing-settings' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { PrintingSettings } from 'lib/redux/state';
	export const printingSettings: (state: PrintingSettings | null | undefined, action: AppAction) => PrintingSettings | null;
	//# sourceMappingURL=printing-settings.d.ts.map
}
declare module 'lib/redux/reducer/screen-definitions' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { AppAction } from 'lib/redux/action-types';
	export const screenDefinitions: (state: Dict<ScreenBaseDefinition<any>> | undefined, action: AppAction) => Dict<ScreenBaseDefinition>;
	//# sourceMappingURL=screen-definitions.d.ts.map
}
declare module 'lib/redux/reducer/service-options' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const serviceOptions: (state: Dict<boolean> | undefined, action: AppAction) => Dict<boolean>;
	//# sourceMappingURL=service-options.d.ts.map
}
declare module 'lib/redux/reducer/sidebar' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { SidebarState } from 'lib/redux/state';
	export const sidebar: (state: SidebarState | null | undefined, action: AppAction) => SidebarState | null;
	//# sourceMappingURL=sidebar.d.ts.map
}
declare module 'lib/redux/reducer/toasts' {
	import type { Toast } from 'lib/service/toast-service';
	import type { AppAction } from 'lib/redux/action-types';
	export const toasts: (state: Toast[] | undefined, action: AppAction) => Toast[];
	//# sourceMappingURL=toasts.d.ts.map
}
declare module 'lib/redux/reducer/translations' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const translations: (state: Dict<Dict<string>> | undefined, action: AppAction) => Dict<Dict<string>>;
	//# sourceMappingURL=translations.d.ts.map
}
declare module 'lib/redux/reducer/user-customizations' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { AppAction } from 'lib/redux/action-types';
	export const userCustomizations: (state: Dict<Dict<any>> | undefined, action: AppAction) => Dict<Dict<any>>;
	//# sourceMappingURL=user-customizations.d.ts.map
}
declare module 'lib/redux/reducer/workflow-nodes' {
	import type { AppAction } from 'lib/redux/action-types';
	import type { WorkflowNode } from '@sage/xtrem-shared';
	export const workflowNodes: (state: null | undefined, action: AppAction) => WorkflowNode[] | null;
	//# sourceMappingURL=workflow-nodes.d.ts.map
}
declare module 'lib/redux/reducer/index' {
	import type { Reducer } from 'redux';
	import type { AppAction } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state'; const rootReducer: Reducer<XtremAppState, AppAction>;
	export default rootReducer;
	//# sourceMappingURL=index.d.ts.map
}
declare module 'lib/redux/store' {
	import type { Store } from 'redux';
	import type { AppAction } from 'lib/redux/action-types';
	import type { XtremAppState } from 'lib/redux/state';
	export const getStore: () => Store<XtremAppState, AppAction>;
	//# sourceMappingURL=store.d.ts.map
}
declare module 'lib/utils/node-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from 'lib/service/metadata-types';
	/**
	 * Finds a node property type details from the list of known node types by doing an deep search in the graph structure.
	 * @param targetNode
	 * @param targetProperty
	 * @param nodeTypes
	 * @returns
	 */
	export const findDeepPropertyDetails: (targetNode?: string, targetProperty?: PropertyValueType, nodeTypes?: Dict<FormattedNodeDetails>, forFiltering?: boolean) => (FormattedNodeDetailsProperty & {
	    parentNode: string;
	}) | null;
	/**
	 * Finds a node property type from the list of known node types by doing an deep search in the graph structure
	 * @param targetNode
	 * @param targetProperty
	 * @param nodeTypes
	 * @param defaultValue optionally can be called with a defaultValue which is returned if no type definition is found
	 * @returns
	 */
	export function findDeepPropertyType(targetNode: string | undefined, targetProperty: PropertyValueType | undefined, nodeTypes: Dict<FormattedNodeDetails>): FormattedNodeDetailsProperty | null;
	export function findDeepPropertyType(targetNode: string | undefined, targetProperty: PropertyValueType | undefined, nodeTypes: Dict<FormattedNodeDetails>, forFiltering?: boolean): FormattedNodeDetailsProperty | null;
	export const getDataTypeName: (node: string) => string;
	//# sourceMappingURL=node-utils.d.ts.map
}
declare module 'lib/utils/data-type-utils' {
	import { type Dict } from '@sage/xtrem-shared';
	import type { ComponentProperties } from 'lib/component/base-control-object';
	import type { HasColumns, HasHelperTextField, HasImageField, HasMaxMin, HasMaxMinLength, HasNode, HasOptionType, HasScale, HasValueField } from 'lib/component/field/traits';
	import * as nestedFields from 'lib/component/nested-fields';
	import type { DataTypeDetails, DataTypeProperty, FormattedNodeDetails, NodeDetailsProperty } from 'lib/service/metadata-types';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { NestedFieldTypes } from 'lib/component/nested-fields';
	import type { CardDefinition } from 'lib/component/ui/card/card-component';
	import type { TableProperties } from 'lib/component/field/field-properties';
	import type { MarkOptional } from 'ts-essentials';
	export interface AutomaticFieldConfigurationArgs<T> {
	    propertyDetails: NodeDetailsProperty;
	    dataType: DataTypeDetails;
	    properties: T;
	}
	export interface AutomaticFieldConfigurationArgsWithSchemaInfo<T> extends AutomaticFieldConfigurationArgs<T> {
	    nodeTypes: Dict<FormattedNodeDetails>;
	    dataTypes: Dict<DataTypeDetails>;
	}
	export function getCardDefinitionFromReferenceDataType({ dataType, dataTypes, nodeTypes, contextNode, }: {
	    nodeTypes: Dict<FormattedNodeDetails>;
	    dataTypes: Dict<DataTypeDetails>;
	    dataType: DataTypeDetails;
	    contextNode: string;
	}): CardDefinition<any>;
	export function applyDefaultValuesOnNestedField(nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, field?: nestedFields.NestedField<any, NestedFieldTypes>, contextNode?: string): void;
	export function createNestedFieldFromDataTypeProperty(prop: DataTypeProperty, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, contextNode: string): nestedFields.NestedField<any, any>;
	export function addTitleToProperties({ propertyDetails, properties, }: Omit<AutomaticFieldConfigurationArgs<{
	    title?: ValueOrCallbackWithFieldValue<any, string>;
	}>, 'dataType'>): void;
	export function addIsTransientInput({ propertyDetails, properties, }: AutomaticFieldConfigurationArgs<{
	    isTransientInput?: boolean;
	}>): void;
	export function addMaxLengthToProperties({ dataType, properties, }: AutomaticFieldConfigurationArgs<HasMaxMinLength<any>>): void;
	export function addOptionTypeToProperties({ propertyDetails, properties, }: AutomaticFieldConfigurationArgs<HasOptionType>): void;
	export function addScaleToProperties({ dataType, properties, }: AutomaticFieldConfigurationArgs<HasScale<any, any>>): void;
	export function addMaxMinToProperties({ dataType, properties }: AutomaticFieldConfigurationArgs<HasMaxMin<any>>): void;
	export function addNodeToProperties({ propertyDetails, properties, }: AutomaticFieldConfigurationArgs<HasNode<any>>): void;
	export function addTunnelPageToProperties({ dataType, properties, }: AutomaticFieldConfigurationArgs<{
	    tunnelPage?: string;
	}>): void;
	export function addDisabledToProperties({ propertyDetails, properties, }: MarkOptional<AutomaticFieldConfigurationArgs<ComponentProperties<any>>, 'propertyDetails' | 'dataType'>): void;
	export function addColumnsToProperties({ dataType, propertyDetails, properties, nodeTypes, dataTypes, }: AutomaticFieldConfigurationArgsWithSchemaInfo<Partial<HasColumns<any, any, nestedFields.NestedFieldTypes>>>, ignoreCardDefinition?: boolean): void;
	export function addMobileCardDefinitionToProperties({ dataType, propertyDetails, properties, nodeTypes, dataTypes, }: AutomaticFieldConfigurationArgsWithSchemaInfo<Partial<TableProperties<any>>>): void;
	export function addValueFieldToProperties({ dataType, propertyDetails, properties, }: AutomaticFieldConfigurationArgs<Partial<HasValueField<any>>>): void;
	export function addHelperTextFieldToProperties({ dataType, propertyDetails, properties, }: AutomaticFieldConfigurationArgs<Partial<HasHelperTextField<any>>>): void;
	export function addImageFieldToProperties({ dataType, propertyDetails, properties, }: AutomaticFieldConfigurationArgs<Partial<HasImageField<any>>>): void;
	export function createDynamicPodReferenceField({ column, nodeTypes, dataTypes, }: {
	    column: nestedFields.NestedField<any, any>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    dataTypes: Dict<DataTypeDetails>;
	}): nestedFields.NestedField<any, any>;
	//# sourceMappingURL=data-type-utils.d.ts.map
}
declare module 'lib/component/field/filter-select/filter-select-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 */
	import type { ClientNode } from '@sage/xtrem-client';
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { FilterSelectDecoratorProperties, FilterSelectExtensionDecoratorProperties } from 'lib/component/field/filter-select/filter-select-types';
	export enum FilterSelectDecoratorPropertiesKeys {
	    onCloseFilterSelectDialog = "onCloseFilterSelectDialog",
	    onOpenFilterSelectDialog = "onOpenFilterSelectDialog"
	}
	/**
	 * Initializes the decorated member as a [FilterSelect]{@link FilterSelectControlObject} field with the provided properties.
	 *
	 * @param properties The properties that the [FilterSelect]{@link FilterSelectControlObject} field will be initialized with.
	 */
	export function filterSelectField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: FilterSelectDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
	export function filterSelectFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: FilterSelectExtensionDecoratorProperties<T, ReferencedItemType>): (target: T, name: string) => void;
	//# sourceMappingURL=filter-select-decorator.d.ts.map
}
declare module 'lib/component/field/filter-select/filter-select-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasDynamicLookupSuggestions, HasInputValueChangeListener, HasLookupDialogTitle, HasParent, HasSound, Nested, NestedChangeable, NestedValidatable, Sizable, Validatable, HasColumns, HasFilter, HasIcon, HasPlaceholder, HasMaxMinLength, HasValueField, NestedHasLookupDialogTitle } from 'lib/component/field/traits';
	import type { ChangeableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import type { BlockControlObject } from 'lib/component/control-objects';
	import type { FieldControlObjectInstance, ReferenceRecursiveOrderBy } from 'lib/component/types';
	import type { FilterSelectDecoratorPropertiesKeys } from 'lib/component/field/filter-select/filter-select-decorator';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType, ScreenExtension } from 'lib/types';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { Extend } from 'lib/service/page-extension';
	export interface FilterSelectProperties<CT extends ScreenExtension<CT> = ScreenBase, ReferencedItemType extends ClientNode = any, NodeType = any> extends EditableFieldProperties<CT, NodeType>, Partial<HasColumns<CT, ReferencedItemType>>, HasFilter<CT, ReferencedItemType>, HasIcon, HasPlaceholder, HasMaxMinLength<CT>, HasSound<CT>, HasValueField<ReferencedItemType>, Sizable {
	    /** Whether the rows of the filter select lookup can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	    /** Indicator, whether field's lookup dialog is currently open */
	    isFilterSelectDialogOpen?: boolean;
	    /** Indicator, whether field can generate value for to be created node */
	    isNewEnabled?: boolean;
	    /** Minimum number of characters to trigger server lookup. If `0` supplied, the first page of suggestions will be fetched on focus. Defaults to 3 */
	    minLookupCharacters?: number;
	    /** The GraphQL node that the field suggestions will be fetched from */
	    node: keyof ScreenBaseGenericType<CT>;
	    /** The column or the set of columns which the table should be sorted by */
	    orderBy?: ReferenceRecursiveOrderBy<ReferencedItemType>;
	}
	export interface FilterSelectDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<FilterSelectProperties<CT, ReferencedItemType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, HasInputValueChangeListener<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, HasDynamicLookupSuggestions<CT, ReferencedItemType>, HasLookupDialogTitle<CT>, Sizable, Validatable<CT, string>, HasSound<CT> {
	    /** Function to be executed when the filter select's dialog is closed. */
	    [FilterSelectDecoratorPropertiesKeys.onCloseFilterSelectDialog]?: (this: CT, _id: any) => void;
	    /** Function to be executed when the filter select's dialog is opened. */
	    [FilterSelectDecoratorPropertiesKeys.onOpenFilterSelectDialog]?: (this: CT, _id: any) => void;
	}
	export interface NestedFilterSelectProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any, ReferencedNode extends ClientNode = any> extends Omit<FilterSelectProperties<CT, ReferencedNode, ContextNodeType>, 'bind'>, NestedChangeable<CT>, Nested<ContextNodeType>, Sizable, NestedHasLookupDialogTitle<CT, ContextNodeType>, NestedValidatable<CT, string, ContextNodeType> {
	}
	type BaseFilterSelectExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase> = {
	    onCloseFilterSelectDialogAfter?: (this: CT, _id: any) => void;
	    onOpenFilterSelectDialogAfter?: (this: CT, _id: any) => void;
	};
	export type FilterSelectExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> = BaseFilterSelectExtensionDecoratorProperties<Extend<CT>> & ChangeableOverrideDecoratorProperties<FilterSelectDecoratorProperties<Extend<CT>, ReferencedItemType>, CT>;
	export type FilterSelectComponentProps<T extends ClientNode = any> = BaseEditableComponentProperties<FilterSelectProperties<any, T>, string, NestedFieldsAdditionalProperties>;
	export interface FilterSelectState {
	    id: string;
	}
	export {};
	//# sourceMappingURL=filter-select-types.d.ts.map
}
declare module 'lib/component/field/label/label-decorator' {
	/**
	 * @packageDocumentation
	 * @module root
	 * */
	import type { Extend } from 'lib/service/page-extension';
	import type { ScreenExtension } from 'lib/types';
	import type { ClickableOverrideDecoratorProperties } from 'lib/utils/decorator-utils';
	import { LabelDecoratorProperties, NestedLabelProperties } from 'lib/component/field/label/label-types';
	/**
	 * Initializes the decorated member as a [Label]{@link LabelControlObject} field with the provided properties
	 *
	 * @param properties The properties that the [Label]{@link LabelControlObject} field will be initialized with
	 */
	export function labelField<T extends ScreenExtension<T>>(properties: LabelDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
	export function labelFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<LabelDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
	export { LabelDecoratorProperties, NestedLabelProperties };
	//# sourceMappingURL=label-decorator.d.ts.map
}
declare module 'lib/component/field/technical/technical-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType } from 'lib/types';
	import type { NestedField, NestedFieldTypes } from 'lib/component/nested-fields';
	import type { FieldKey } from 'lib/component/types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	export interface NestedTechnicalProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any, ReferenceNode extends ClientNode = any> {
	    bind: PropertyValueType<NodeType>;
	    node?: keyof ScreenBaseGenericType<CT>;
	    nestedFields?: NestedField<ScreenBase, NestedFieldTypes, ReferenceNode>[];
	    isTransient?: boolean;
	    isTransientInput?: boolean;
	    _controlObjectType: FieldKey;
	}
	//# sourceMappingURL=technical-types.d.ts.map
}
declare module 'lib/component/nested-fields-properties' {
	import type { NestedAggregateProperties } from 'lib/component/field/aggregate/aggregate-types';
	import type { NestedCheckboxProperties } from 'lib/component/field/checkbox/checkbox-types';
	import type { NestedCountProperties } from 'lib/component/field/count/count-types';
	import type { NestedDateProperties } from 'lib/component/field/date/date-types';
	import type { NestedDropdownListProperties } from 'lib/component/field/dropdown-list/dropdown-list-types';
	import type { NestedFilterSelectProperties } from 'lib/component/field/filter-select/filter-select-types';
	import type { NestedIconProperties } from 'lib/component/field/icon/icon-types';
	import type { NestedImageProperties } from 'lib/component/field/image/image-types';
	import type { NestedLabelProperties } from 'lib/component/field/label/label-decorator';
	import type { NestedLinkProperties } from 'lib/component/field/link/link-types';
	import type { NestedMultiDropdownProperties } from 'lib/component/field/multi-dropdown/multi-dropdown-types';
	import type { NestedMultiReferenceProperties } from 'lib/component/field/multi-reference/multi-reference-types';
	import type { NestedNumericProperties } from 'lib/component/field/numeric/numeric-types';
	import type { NestedProgressProperties } from 'lib/component/field/progress/progress-types';
	import type { NestedReferenceProperties } from 'lib/component/field/reference/reference-types';
	import type { NestedRelativeDateProperties } from 'lib/component/field/relative-date/relative-date-types';
	import type { NestedSelectProperties } from 'lib/component/field/select/select-types';
	import type { NestedSwitchProperties } from 'lib/component/field/switch/switch-decorator';
	import type { NestedTechnicalProperties } from 'lib/component/field/technical/technical-types';
	import type { NestedTextAreaProperties } from 'lib/component/field/text-area/text-area-types';
	import type { NestedTextProperties } from 'lib/component/field/text/text-types';
	export { NestedAggregateProperties, NestedCheckboxProperties, NestedCountProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLabelProperties, NestedLinkProperties, NestedMultiDropdownProperties, NestedMultiReferenceProperties, NestedNumericProperties, NestedProgressProperties, NestedReferenceProperties, NestedRelativeDateProperties, NestedSelectProperties, NestedSwitchProperties, NestedTechnicalProperties, NestedTextAreaProperties, NestedTextProperties, };
	//# sourceMappingURL=nested-fields-properties.d.ts.map
}
declare module 'lib/component/field/checkbox/checkbox-cell-renderer' {
	import * as React from 'react';
	import type { NestedCheckboxProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const CheckboxCellRenderer: React.NamedExoticComponent<CellParams<NestedCheckboxProperties<import("../../../service/screen-base").ScreenBase<any, any>, any>, boolean>>;
	//# sourceMappingURL=checkbox-cell-renderer.d.ts.map
}
declare module 'lib/component/field/count/count-cell-renderer' {
	import React from 'react';
	import type { NestedCountProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const CountCellRenderer: React.FC<CellParams<NestedCountProperties, {
	    query?: {
	        totalCount: number;
	    };
	}>>;
	//# sourceMappingURL=count-cell-renderer.d.ts.map
}
declare module 'lib/component/field/date/date-cell-editor' {
	import type { LocalizeLocale } from '@sage/xtrem-shared';
	import React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { NestedDateProperties } from 'lib/component/field/date/date-types';
	type EventTargetOnDateChange = {
	    value: {
	        formattedValue: string;
	        rawValue: string;
	    };
	};
	interface DateEditorState {
	    value: string;
	    highlightOnFocus: boolean;
	    rawValue: string;
	    locale: LocalizeLocale;
	}
	export default class DateCellEditor extends React.Component<CellParams<NestedDateProperties>, DateEditorState> {
	    constructor(props: CellParams<NestedDateProperties>);
	    componentDidMount(): void;
	    handleChange(event: React.ChangeEvent<EventTargetOnDateChange>): void;
	    onKeyDown(event: React.KeyboardEvent): void;
	    getFormattedDate: () => string;
	    getCarbonProps: () => any;
	    createInitialState(props: CellParams<NestedDateProperties>): DateEditorState;
	    render(): React.ReactNode;
	}
	export {};
	//# sourceMappingURL=date-cell-editor.d.ts.map
}
declare module 'lib/component/field/select/select-cell-editor' {
	import React from 'react';
	import type { SelectEditorProps } from 'lib/component/field/select/select-types';
	export const SelectCellEditor: React.FC<SelectEditorProps>;
	//# sourceMappingURL=select-cell-editor.d.ts.map
}
declare module 'lib/component/field/dropdown-list/dropdown-list-cell-editor' {
	import type { SelectEditorProps } from 'lib/component/field/select/select-types';
	import React from 'react';
	export const DropdownListCellEditor: React.FC<SelectEditorProps>;
	//# sourceMappingURL=dropdown-list-cell-editor.d.ts.map
}
declare module 'lib/component/field/dropdown-list/dropdown-list-cell-renderer' {
	import React from 'react';
	import type { DropdownListCellEditorProperties } from 'lib/component/field/dropdown-list/dropdown-list-types';
	export const DropdownListCellRenderer: React.FC<DropdownListCellEditorProperties>;
	//# sourceMappingURL=dropdown-list-cell-renderer.d.ts.map
}
declare module 'lib/component/field/filter-select/filter-select-cell-editor' {
	import type { UseComboboxStateChangeTypes } from 'downshift';
	import React from 'react';
	import type { CollectionItem } from 'lib/component/types';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import type { FilterSelectCellEditorProps } from 'lib/component/field/select/select-types';
	interface FilterSelectEditorState {
	    id: string;
	    highlightOnFocus: boolean;
	    isLookupPanelOpen: boolean;
	    selectedRecord?: SelectItem;
	    startValue: string;
	}
	export default class FilterSelectCellEditor extends React.Component<FilterSelectCellEditorProps, FilterSelectEditorState> {
	    private readonly selectRef;
	    constructor(props: FilterSelectCellEditorProps);
	    componentDidMount(): void;
	    getItems: (filterValue: string) => Promise<SelectItem[]>;
	    onSelected: (selectedRecord?: SelectItem | null, selectionType?: UseComboboxStateChangeTypes) => void;
	    isLookupDialogOpen: () => boolean;
	    onLookupDialogSelectionFinished: ([collectionItem]?: CollectionItem[]) => void;
	    closeLookupDialog: () => void;
	    openLookupDialog: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>) => void;
	    getLocalizedSuffix: () => string;
	    getNewItem: (value: string) => SelectItem;
	    createInitialState(props: FilterSelectCellEditorProps): FilterSelectEditorState;
	    render(): React.ReactNode;
	}
	export {};
	//# sourceMappingURL=filter-select-cell-editor.d.ts.map
}
declare module 'lib/component/field/filter-select/filter-select-cell-renderer' {
	import React from 'react';
	import type { NestedFilterSelectProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const FilterSelectRenderer: React.FC<CellParams<NestedFilterSelectProperties>>;
	//# sourceMappingURL=filter-select-cell-renderer.d.ts.map
}
declare module 'lib/component/field/icon/icon-cell-renderer' {
	import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
	import * as React from 'react';
	import type { NestedIconProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const IconCellRenderer: React.FC<CellParams<NestedIconProperties, IconType>>;
	//# sourceMappingURL=icon-cell-renderer.d.ts.map
}
declare module 'lib/component/field/image/image-cell-renderer' {
	import * as React from 'react';
	import type { NestedImageProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const ImageCellRenderer: React.FC<CellParams<NestedImageProperties, {
	    value: string;
	}>>;
	//# sourceMappingURL=image-cell-renderer.d.ts.map
}
declare module 'lib/component/field/label/label-cell-renderer' {
	import * as React from 'react';
	import type { NestedLabelProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const LabelCellRenderer: React.FC<CellParams<NestedLabelProperties>>;
	//# sourceMappingURL=label-cell-renderer.d.ts.map
}
declare module 'lib/component/field/link/link-cell-renderer' {
	import * as React from 'react';
	import type { NestedLinkProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const LinkCellRenderer: React.FC<CellParams<NestedLinkProperties>>;
	//# sourceMappingURL=link-cell-renderer.d.ts.map
}
declare module 'lib/component/field/numeric/numeric-cell-utils' {
	/// <reference types="react" />
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	export function onNumericInputKeyDown({ event, scale: scaleProperty, screenId, fieldValue, rowValue, }: {
	    event: React.KeyboardEvent<HTMLInputElement>;
	    screenId: string;
	    fieldValue?: any;
	    rowValue?: any;
	    scale: ValueOrCallbackWithFieldValue<ScreenBase, number, number, any>;
	}): void;
	export function isInputLimitedByScale({ event, scale: scaleProperty, screenId, fieldValue, rowValue, }: {
	    event: React.KeyboardEvent<HTMLInputElement>;
	    screenId: string;
	    fieldValue?: any;
	    rowValue?: any;
	    scale: ValueOrCallbackWithFieldValue<ScreenBase, number, number, any>;
	}): boolean;
	//# sourceMappingURL=numeric-cell-utils.d.ts.map
}
declare module 'lib/component/field/numeric/numeric-cell-editor' {
	import React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { NestedNumericProperties } from 'lib/component/nested-fields-properties';
	interface NumericEditorState {
	    value: string;
	    highlightOnFocus: boolean;
	}
	export default class NumericEditor extends React.Component<CellParams<NestedNumericProperties>, NumericEditorState> {
	    private readonly input;
	    constructor(props: CellParams<NestedNumericProperties>);
	    componentDidMount(): void;
	    componentWillUnmount(): void;
	    handleChange(event: React.ChangeEvent<HTMLInputElement>): void;
	    onKeyDown(event: React.KeyboardEvent<HTMLInputElement>): void;
	    render(): React.ReactNode;
	}
	export {};
	//# sourceMappingURL=numeric-cell-editor.d.ts.map
}
declare module 'lib/component/field/progress/progress-cell-renderer' {
	import * as React from 'react';
	import type { NestedProgressProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const ProgressCellRenderer: React.FC<CellParams<NestedProgressProperties, number>>;
	//# sourceMappingURL=progress-cell-renderer.d.ts.map
}
declare module 'lib/component/field/reference/reference-cell-editor' {
	import type { UseComboboxStateChangeTypes } from 'downshift';
	import React from 'react';
	import type { CollectionItem } from 'lib/component/types';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import type { ReferenceCellEditorProps, ReferenceCellEditorState } from 'lib/component/field/reference/reference-types';
	export default class ReferenceCellEditor extends React.Component<ReferenceCellEditorProps, ReferenceCellEditorState> {
	    private selectRef;
	    constructor(props: ReferenceCellEditorProps);
	    componentDidMount(): void;
	    getItems: (filterValue: string) => Promise<SelectItem[]>;
	    getWidth(): string;
	    onSelected: (selectedItem: SelectItem | null | undefined, selectionType?: UseComboboxStateChangeTypes) => void;
	    isLookupDialogOpen: () => boolean;
	    onLookupDialogSelectionFinished: ([collectionItem]?: CollectionItem[]) => void;
	    closeLookupDialog: () => void;
	    openLookupDialog: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement, MouseEvent>) => void;
	    onOpenTunnel: (isNew?: boolean) => Promise<void>;
	    handleOnCreateNewItemLinkClick: () => void;
	    createInitialState(props: ReferenceCellEditorProps): ReferenceCellEditorState;
	    render(): React.ReactNode;
	}
	//# sourceMappingURL=reference-cell-editor.d.ts.map
}
declare module 'lib/component/field/reference/reference-cell-renderer' {
	import React from 'react';
	import type { CarbonLinkEvent } from 'lib/utils/types';
	import type { NestedReferenceProperties } from 'lib/component/decorators';
	import type { ReferenceCellRendererProps } from 'lib/component/field/reference/reference-types';
	import type { ImageValue } from 'lib/component/field/image/image-types';
	export class ReferenceCellRenderer extends React.Component<ReferenceCellRendererProps> {
	    private readonly linkRef;
	    componentDidMount(): void;
	    shouldComponentUpdate(nextProps: ReferenceCellRendererProps): boolean;
	    componentWillUnmount(): void;
	    private readonly onFocus;
	    /**
	     * Searches for the reference field image from the row using the the dot path, first using the bind path of the reference column, then the path of the `imageField`;
	     * @returns
	     */
	    getImageFromProps: () => ImageValue | undefined;
	    private getTunnelPageLink;
	    private readonly shouldRenderTunnelPageLink;
	    private readonly isReadOnly;
	    onTunnelLinkClick: (ev: CarbonLinkEvent) => Promise<void>;
	    render(): React.ReactNode;
	}
	export const ConnectedReferenceCellRenderer: import("react-redux").ConnectedComponent<typeof ReferenceCellRenderer, {
	    key?: React.Key | null | undefined;
	    ref?: React.LegacyRef<ReferenceCellRenderer> | undefined;
	    colDef: Omit<import("../../../utils/ag-grid/ag-grid-utility-types").AgGridColumnConfigWithScreenIdAndColDef, "cellRendererParams"> & Required<Pick<Omit<import("../../../utils/ag-grid/ag-grid-utility-types").AgGridColumnConfigWithScreenIdAndColDef, "cellRendererParams">, "field">> & {
	        cellRendererParams: import("../../../utils/ag-grid/ag-grid-column-config").CellProps<NestedReferenceProperties<import("../../../service/screen-base").ScreenBase<any, any>, any, any>>;
	    };
	    value: string;
	    node: import("@ag-grid-community/core").RowNode<any>;
	    column: import("@ag-grid-community/core").Column<any>;
	    data: any;
	    valueFormatted: string | null | undefined;
	    fullWidth?: boolean | undefined;
	    pinned?: "left" | "right" | null | undefined;
	    eGridCell: HTMLElement;
	    eParentOfValue: HTMLElement;
	    getValue?: (() => any) | undefined;
	    setValue?: ((value: any) => void) | undefined;
	    formatValue?: ((value: any) => string) | undefined;
	    refreshCell?: (() => void) | undefined;
	    registerRowDragger: (rowDraggerElement: HTMLElement, dragStartPixels?: number | undefined, value?: string | undefined, suppressVisibilityChange?: boolean | undefined) => void;
	    setTooltip: (value: string, shouldDisplayTooltip?: (() => boolean) | undefined) => void;
	    api: import("@ag-grid-community/core").GridApi<any>;
	    context: any;
	    eventKey: string | null;
	    initialValue: any;
	    onValueChange: (value: any) => void;
	    stopEditing: (suppressNavigateAfterEdit?: boolean | undefined) => void;
	    columnId: string;
	    contextNode?: string | number | symbol | undefined;
	    elementId: string;
	    fieldProperties: import("../../../utils/ag-grid/ag-grid-column-config").WithNestedWrapper<NestedReferenceProperties<import("../../../service/screen-base").ScreenBase<any, any>, any, any>>;
	    screenId: string;
	    tableElementId: string;
	    isEditing?: boolean | undefined;
	    isParentFieldDisabled: boolean;
	    isTableReadOnly?: import("../../../utils/types").ValueOrCallbackWithFieldValue<import("../../../service/screen-base").ScreenBase<any, any>, boolean> | undefined;
	    isTree: boolean;
	    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
	}>;
	export default ConnectedReferenceCellRenderer;
	//# sourceMappingURL=reference-cell-renderer.d.ts.map
}
declare module 'lib/component/ui/relative-date/relative-date-component' {
	import React from 'react';
	import type { RelativeDateScope } from 'lib/component/field/relative-date/relative-date-utils';
	import type { DatePropertyValue } from 'lib/utils/types';
	type RelativeDateProps = {
	    value: DatePropertyValue;
	    scope?: RelativeDateScope;
	};
	export function RelativeDate({ value, scope }: RelativeDateProps): React.ReactElement | null;
	export {};
	//# sourceMappingURL=relative-date-component.d.ts.map
}
declare module 'lib/component/field/relative-date/relative-date-cell-renderer' {
	import * as React from 'react';
	import type { NestedRelativeDateProperties } from 'lib/component/nested-fields-properties';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export function RelativeDateCellRenderer(props: CellParams<NestedRelativeDateProperties> & {
	    colDef: {
	        cellRendererParams: {
	            relativeDateScope: 'date' | 'datetime';
	        };
	    };
	}): React.ReactElement | null;
	//# sourceMappingURL=relative-date-cell-renderer.d.ts.map
}
declare module 'lib/component/field/select/select-cell-renderer' {
	import React from 'react';
	import type { SelectEditorProps } from 'lib/component/field/select/select-types';
	export const SelectRenderer: React.FC<SelectEditorProps>;
	//# sourceMappingURL=select-cell-renderer.d.ts.map
}
declare module 'lib/component/field/switch/switch-cell-renderer' {
	import React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { NestedSwitchProperties } from 'lib/component/field/switch/switch-types';
	export const SwitchRenderer: React.FC<CellParams<NestedSwitchProperties, boolean> & {
	    onChange: (value: boolean) => void;
	}>;
	//# sourceMappingURL=switch-cell-renderer.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/checkbox-cell' {
	import React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export function CheckboxCell({ node, data }: CellParams): React.ReactNode;
	//# sourceMappingURL=checkbox-cell.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/default-cell-editor' {
	import React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	interface DefaultCellEditorState {
	    highlightOnFocus: boolean;
	    value: string;
	}
	type DefaultCellEditorProps = CellParams<any>;
	export class DefaultCellEditor extends React.Component<DefaultCellEditorProps, DefaultCellEditorState> {
	    private inputRef;
	    constructor(props: DefaultCellEditorProps);
	    componentDidMount(): void;
	    handleChange(event: React.ChangeEvent<HTMLInputElement>): void;
	    render(): React.ReactNode;
	}
	export {};
	//# sourceMappingURL=default-cell-editor.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/default-cell-renderer' {
	import React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export const DefaultCellRenderer: React.FC<CellParams>;
	//# sourceMappingURL=default-cell-renderer.d.ts.map
}
declare module 'lib/component/ui/table-shared/cell/table-validation-cell-renderer' {
	import * as React from 'react';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	export function ValidationCellRenderer(props: CellParams<any>): React.ReactElement | null;
	//# sourceMappingURL=table-validation-cell-renderer.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/boolean/boolean-filter' {
	import React from 'react';
	import { FieldKey, SET } from 'lib/component/types';
	export function BooleanFilter({ controlObjectType, model, onModelChange, }: {
	    controlObjectType: FieldKey.Checkbox | FieldKey.Switch;
	    model: {
	        filterType: typeof SET;
	        values: [boolean] | [];
	    } | null;
	    onModelChange: (model: {
	        filterType: typeof SET;
	        values: [boolean] | [];
	    } | null) => void;
	}): React.ReactNode;
	//# sourceMappingURL=boolean-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/clear/clear-floating-filter' {
	import * as React from 'react';
	import type { GridApi } from '@ag-grid-community/core';
	/**
	 * This floating filter component is used to clear all the currently selected filters.
	 */
	export function ClearFloatingFilter(props: {
	    api: GridApi;
	    elementId: string;
	}): React.ReactElement;
	export namespace ClearFloatingFilter {
	    var displayName: string;
	}
	export default ClearFloatingFilter;
	//# sourceMappingURL=clear-floating-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/date/date-filter-types' {
	import type { Column } from '@ag-grid-community/core';
	import type { EQUALS } from '@sage/xtrem-shared';
	export type EventTargetOnDateChange = {
	    value: {
	        formattedValue: string;
	        rawValue: string;
	    };
	};
	export interface DateState {
	    rawValue: string;
	    formattedValue: string;
	    rawValueTo?: string;
	    formattedValueTo?: string;
	    type: string;
	}
	export interface SimpleDateModel {
	    filterType: 'date';
	    dateFrom: string;
	    dateTo?: string;
	    type: string;
	    formattedValue: string;
	    formattedValueTo?: string;
	}
	export interface ComplexDateModel {
	    condition1: SimpleDateModel;
	    filterType: 'date';
	}
	export interface SimpleDateEqualModel {
	    filterType: typeof EQUALS;
	    rawValue: string;
	    formattedValue: string;
	}
	export type DateModel = SimpleDateModel | ComplexDateModel | SimpleDateEqualModel;
	export interface DateFilterProps {
	    model: DateModel | null;
	    onModelChange: (model: DateModel | null) => void;
	    column: Column;
	}
	//# sourceMappingURL=date-filter-types.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/date/date-filter-utils' {
	import type { ComplexDateModel, DateModel, DateState, SimpleDateModel } from 'lib/component/ui/table-shared/filters/date/date-filter-types';
	export const isSimpleDateFilter: (filter: DateModel) => filter is SimpleDateModel;
	export const isComplexDateFilter: (filter: DateModel) => filter is ComplexDateModel;
	export const defaultDateState: () => DateState;
	export const getModelFromDateState: (dateState: DateState) => SimpleDateModel;
	export function getDateStateFromModel(model: DateModel | null): DateState;
	//# sourceMappingURL=date-filter-utils.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/filter-type-select-component' {
	/// <reference types="react" />
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	export interface FilterBySelectorProps {
	    onChange: (item: SelectItem) => void;
	    value: string;
	}
	/**
	 * Component that shows a selector with the options to filter by
	 *  */
	export function FilterTypeSelect(props: FilterBySelectorProps): JSX.Element;
	//# sourceMappingURL=filter-type-select-component.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/date/date-filter' {
	import React from 'react';
	import type { DateFilterProps } from 'lib/component/ui/table-shared/filters/date/date-filter-types';
	export default function DateFilter({ model, onModelChange }: DateFilterProps): React.ReactNode;
	//# sourceMappingURL=date-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/date/date-floating-filter' {
	import React from 'react';
	import type { DateFilterProps } from 'lib/component/ui/table-shared/filters/date/date-filter-types'; function DateFloatingFilter({ column, onModelChange, model }: DateFilterProps): React.ReactNode;
	export default DateFloatingFilter;
	//# sourceMappingURL=date-floating-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/numeric/numeric-filter-types' {
	import type { Column } from '@ag-grid-community/core';
	import type { EQUALS, GREATER_THAN, GREATER_THAN_EQUAL, LESS_THAN, LESS_THAN_EQUAL, NOT_EQUALS, RANGE } from 'lib/component/types';
	export type NumericFilterTypes = typeof LESS_THAN | typeof LESS_THAN_EQUAL | typeof EQUALS | typeof NOT_EQUALS | typeof GREATER_THAN | typeof GREATER_THAN_EQUAL | typeof RANGE;
	export interface NumericFilterModel {
	    filterType: 'number';
	    type: NumericFilterTypes;
	    filter: number | null;
	    filterTo?: number | null;
	}
	export interface NumericFloatingFilterProps {
	    model: NumericFilterModel | null;
	    onModelChange: (model: NumericFilterModel | null) => void;
	    column: Column;
	}
	export interface NumericFilterProps {
	    model: NumericFilterModel | null;
	    onModelChange: (model: NumericFilterModel | null) => void;
	    column: Column;
	}
	export interface NumericFilterValueState {
	    value?: number;
	    valueTo?: number;
	    type: NumericFilterTypes;
	}
	export interface NumericFilterInputProps {
	    value: number | null;
	    onChange: (value: number | null) => void;
	    scale: any;
	    screenId: string;
	    'data-testid'?: string;
	}
	//# sourceMappingURL=numeric-filter-types.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/numeric/numeric-filter-utils' {
	import type { NumericFilterModel, NumericFilterValueState } from 'lib/component/ui/table-shared/filters/numeric/numeric-filter-types';
	export const defaultNumericFilterState: () => NumericFilterValueState;
	export const getModelFromNumericFilterState: (dateState: NumericFilterValueState) => NumericFilterModel | null;
	export function getNumericFilterStateFromModel(model: NumericFilterModel | null): NumericFilterValueState;
	//# sourceMappingURL=numeric-filter-utils.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/numeric/numeric-filter-input' {
	import React from 'react';
	import type { NumericFilterInputProps } from 'lib/component/ui/table-shared/filters/numeric/numeric-filter-types';
	export function NumericFilterInput({ value: externalValue, onChange: setExternalValue, scale, screenId, 'data-testid': dataTestId, }: NumericFilterInputProps): React.ReactNode;
	//# sourceMappingURL=numeric-filter-input.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/numeric/numeric-filter' {
	import React from 'react';
	import type { NumericFilterProps } from 'lib/component/ui/table-shared/filters/numeric/numeric-filter-types';
	export default function NumericFilter({ model, onModelChange, column }: NumericFilterProps): React.ReactNode;
	//# sourceMappingURL=numeric-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/numeric/numeric-floating-filter' {
	import React from 'react';
	import type { NumericFloatingFilterProps } from 'lib/component/ui/table-shared/filters/numeric/numeric-filter-types';
	export default function NumericFloatingFilter({ model, onModelChange, column, }: NumericFloatingFilterProps): React.ReactNode;
	//# sourceMappingURL=numeric-floating-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/reference/reference-filter' {
	import * as React from 'react';
	import type { AgGridColumnConfigWithScreenIdAndColDef } from 'lib/utils/ag-grid/ag-grid-utility-types';
	type FilterModel = {
	    filterType: string;
	    values: string[];
	    /**
	     * By default, the filtering applied to the value field text value, so we need to pass this flag to indicate that
	     * the records should be filtered by their ID values
	     *  */
	    filterById: boolean;
	    displayValues: string[];
	};
	export interface ReferenceFilterProps {
	    colDef: AgGridColumnConfigWithScreenIdAndColDef;
	    onModelChange: (model: FilterModel | null) => void;
	    model?: FilterModel | null;
	}
	/**
	 * Custom filter component for AG-Grid, handling references.
	 *
	 * Not implemented:
	 * - Support for nested grids
	 * - "Select All" functionality
	 */
	export function ReferenceFilter({ colDef, onModelChange, model }: ReferenceFilterProps): React.ReactNode;
	export namespace ReferenceFilter {
	    var displayName: string;
	}
	export default ReferenceFilter;
	//# sourceMappingURL=reference-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/filters/reference/reference-floating-filter' {
	import * as React from 'react';
	/**
	 * This floating filter component is used to display the currently selected items for reference fields in the header using a comma separated list.
	 */
	export const ReferenceFloatingFilter: React.ForwardRefExoticComponent<Omit<any, "ref"> & React.RefAttributes<any>>;
	export default ReferenceFloatingFilter;
	//# sourceMappingURL=reference-floating-filter.d.ts.map
}
declare module 'lib/component/ui/table-shared/table-row-selection-header' {
	import type { IHeaderParams } from '@ag-grid-community/core';
	import React from 'react';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	import type { TableOptionsMenuItem } from 'lib/component/control-objects';
	interface TableRowSelectionHeaderProps extends IHeaderParams {
	    screenId: string;
	    elementId: string;
	    node: string;
	    fieldProperties: Omit<InternalTableProperties, 'selectedRecords'>;
	    activeOptionsMenuItem?: TableOptionsMenuItem;
	}
	export function TableRowSelectionHeader({ api, screenId, elementId, eGridHeader, node, fieldProperties, activeOptionsMenuItem, }: TableRowSelectionHeaderProps): React.ReactElement;
	export {};
	//# sourceMappingURL=table-row-selection-header.d.ts.map
}
declare module 'lib/utils/ag-grid/ag-grid-column-config' {
	/// <reference types="react" />
	import type { ColDef, Column, ICellRendererParams, RowNode, ValueFormatterParams, ValueGetterParams, ValueSetterParams } from '@ag-grid-community/core';
	import { type Dict, type LocalizeLocale } from '@sage/xtrem-shared';
	import type { MarkRequired } from 'ts-essentials';
	import { type OptionsMenuItem } from 'lib/component/control-objects';
	import type { NestedCheckboxProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLinkProperties, NestedProgressProperties, NestedReferenceProperties, NestedRelativeDateProperties, NestedSelectProperties, NestedSwitchProperties } from 'lib/component/decorators';
	import type { NestedCountProperties } from 'lib/component/field/count/count-types';
	import type { InternalNestedGridProperties } from 'lib/component/field/field-control-objects';
	import type { NestedLabelProperties } from 'lib/component/field/label/label-decorator';
	import type { NestedNumericProperties } from 'lib/component/field/numeric/numeric-types';
	import type { InternalTableProperties } from 'lib/component/field/table/table-component-types';
	import type { NestedTextProperties } from 'lib/component/field/text/text-types';
	import type { Nested } from 'lib/component/field/traits';
	import type { NestedField, NestedFieldTypesWithoutTechnical, NestedFieldsProperties } from 'lib/component/nested-fields';
	import type { GridRowActionType } from 'lib/component/types';
	import type { CellWrapperProps } from 'lib/component/ui/table-shared/cell/cell-wrapper';
	import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from 'lib/service/metadata-types';
	import type { AccessBindings } from 'lib/service/page-definition';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenBaseGenericType } from 'lib/types';
	import { ContextType } from 'lib/types';
	import type { Merge, SetRequired, ValueOrCallbackWithFieldValue } from 'lib/utils/types';
	import type { AgGridColumnConfigWithAllColumns, AgGridColumnConfigWithScreenIdAndColDef } from 'lib/utils/ag-grid/ag-grid-utility-types';
	interface CellEditorProps extends Omit<ICellRendererParams, 'value'> {
	    eventKey: string | null;
	    initialValue: any;
	    onValueChange: (value: any) => void;
	    stopEditing: (suppressNavigateAfterEdit?: boolean) => void;
	    value: string;
	}
	export interface CellParams<T extends Nested<any> = Nested, V = string> extends Omit<CellEditorProps, 'colDef' | 'value'>, CellProps<T> {
	    colDef: MarkRequired<Omit<AgGridColumnConfigWithScreenIdAndColDef, 'cellRendererParams'>, 'field'> & {
	        cellRendererParams: CellProps<T>;
	    };
	    value: V;
	    node: RowNode;
	    column: Column;
	}
	export interface CellProps<T> {
	    columnId: string;
	    contextNode?: keyof ScreenBaseGenericType<ScreenBase>;
	    elementId: string;
	    fieldProperties: WithNestedWrapper<T>;
	    screenId: string;
	    tableElementId: string;
	    isEditing?: boolean;
	    isParentFieldDisabled: boolean;
	    isTableReadOnly?: ValueOrCallbackWithFieldValue<ScreenBase, boolean>;
	    isTree: boolean;
	}
	type ICellParams<T extends Nested<any>> = CellProps<T> | ((p: any) => CellProps<T>);
	type ColumnProps<T extends Nested<any>> = Merge<SetRequired<ColDef, 'cellRenderer'>, {
	    cellRendererParams: ICellParams<T>;
	    cellEditorParams?: ICellParams<T>;
	}>;
	export interface ColumnConfigurationProperties<T extends Nested<any>> {
	    columnId: string;
	    columnProperties: T;
	    enumTypes: Dict<string[]>;
	    nodeTypes: Dict<FormattedNodeDetails>;
	    hasFloatingFilters: boolean;
	    isParentFieldDisabled: boolean;
	    level: number;
	    locale: LocalizeLocale;
	    screenId: string;
	    tableElementId: string;
	    tableProperties: InternalTableProperties<ScreenBase> | InternalNestedGridProperties<ScreenBase>;
	    isReadOnly: ValueOrCallbackWithFieldValue<ScreenBase, boolean> | undefined;
	    propertyGraphType: FormattedNodeDetailsProperty | null;
	}
	export type NestedProperties = NestedReferenceProperties | NestedLabelProperties | NestedCheckboxProperties | NestedDateProperties | NestedTextProperties | NestedProgressProperties | NestedNumericProperties | NestedFilterSelectProperties | NestedDropdownListProperties | NestedSelectProperties | NestedSwitchProperties;
	export const defaultValueGetter: (params: Pick<ValueGetterParams, 'colDef' | 'data'>, screenId: string, columnProperties: NestedFieldsProperties<NestedFieldTypesWithoutTechnical, ScreenBase>) => (mapper?: (value: any) => any) => any;
	export const defaultValueSetter: (params: ValueSetterParams) => boolean;
	export const getReferenceFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedReferenceProperties>) => ColumnProps<NestedReferenceProperties>;
	export const getImageFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedImageProperties>) => ColumnProps<NestedImageProperties>;
	export const getLabelFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedLabelProperties>) => ColumnProps<NestedLabelProperties>;
	export const getIconFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedIconProperties>) => ColumnProps<NestedIconProperties>;
	export const getCountFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedCountProperties>) => ColumnProps<NestedCountProperties>;
	export const getCheckboxFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedCheckboxProperties>) => ColumnProps<NestedCheckboxProperties>;
	export const getDateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDateProperties>) => ColumnProps<NestedDateProperties>;
	export const getValueFormatter: (screenId: string, columnProperties: NestedTextProperties | NestedNumericProperties) => (params: ValueFormatterParams) => string;
	export const getTextFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedTextProperties>) => ColumnProps<NestedTextProperties>;
	export const getLinkFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedLinkProperties>) => ColumnProps<NestedLinkProperties>;
	export const getRelativeDateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedRelativeDateProperties>) => ColumnProps<NestedRelativeDateProperties>;
	export const getProgressFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedProgressProperties>) => ColumnProps<NestedLinkProperties>;
	export const getNumericFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedNumericProperties>) => ColumnProps<NestedNumericProperties>;
	export const getAggregateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedNumericProperties>) => ColumnProps<NestedNumericProperties>;
	export const getFilterSelectFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedFilterSelectProperties>) => ColumnProps<NestedFilterSelectProperties>;
	export const getDropdownListFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDropdownListProperties>) => ColumnProps<NestedDropdownListProperties>;
	export const getSelectFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedSelectProperties>) => ColumnProps<NestedSelectProperties>;
	export const getSwitchFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedSwitchProperties>) => ColumnProps<NestedSwitchProperties>;
	export const COLUMN_ID_ROW_SELECTION = "__select";
	export const getRowSelectColumnConfiguration: ({ screenId, isParentFieldDisabled, tableElementId, node, fieldProperties, contextType, activeOptionsMenuItem, }: {
	    tableElementId: string;
	    screenId: string;
	    isParentFieldDisabled: boolean;
	    node: string;
	    fieldProperties: Omit<InternalTableProperties, 'selectedRecords'>;
	    contextType?: ContextType;
	    activeOptionsMenuItem?: OptionsMenuItem;
	}) => AgGridColumnConfigWithScreenIdAndColDef;
	export const COLUMN_ID_LINE_NUMBER = "__line_number";
	export const getLineNumberColumnConfiguration: (screenId: string) => AgGridColumnConfigWithScreenIdAndColDef;
	export const COLUMN_ID_VALIDATIONS = "__validation";
	export const getValidationColumnConfiguration: (screenId: string, getColumns: () => NestedField<any, any>[]) => AgGridColumnConfigWithAllColumns;
	export const COLUMN_ID_AUTO_COLUMN = "ag-Grid-AutoColumn";
	export const COLUMN_ID_ROW_ACTIONS = "__actions";
	export const COLUMN_CELLCLASS_ROW_ACTIONS = "e-table-field-dropdown-actions-cell";
	export const FOCUSED_BUT_BORDERLESS = "e-ag-cell-focus--no-border";
	export const getDropdownActionsColumnConfiguration: (screenId: string, tableElementId: string, level: number, wrapper: WithNestedWrapper<any>['wrapper'], isParentFieldDisabled: boolean, inlineActions: GridRowActionType, dropdownActions: GridRowActionType, hasFloatingFilters: boolean) => AgGridColumnConfigWithScreenIdAndColDef;
	export const frameworkComponents: Dict<any>;
	export type WithNestedWrapper<T> = T & {
	    wrapper: React.FC<CellWrapperProps>;
	};
	export function getTooltipMessage(props: CellParams<any, any>): string | undefined;
	export function getTextAlignment(props: CellParams<any>): 'left' | 'right' | 'center';
	export function getCellProps<T extends Nested<any>>({ columnProperties, tableProperties, tableElementId, columnId, screenId, isParentFieldDisabled, level, isReadOnly, }: ColumnConfigurationProperties<T>): CellProps<T>;
	export interface AddStaticColumnsArgs {
	    screenId: string;
	    fieldProperties: Omit<InternalTableProperties, 'selectedRecords'>;
	    columns?: AgGridColumnConfigWithScreenIdAndColDef[];
	    lookupSelectionMode?: 'single' | 'multiple';
	    tableElementId: string;
	    level: number;
	    isParentFieldDisabled: boolean;
	    contextType?: ContextType;
	    hasFloatingFilters: boolean;
	    activeOptionsMenuItem?: OptionsMenuItem;
	    accessBindings: AccessBindings;
	}
	export const addStaticColumns: ({ accessBindings, activeOptionsMenuItem, columns, contextType, fieldProperties, hasFloatingFilters, isParentFieldDisabled, level, lookupSelectionMode, screenId, tableElementId, }: AddStaticColumnsArgs) => void;
	export const INTERNAL_COLUMN_IDS: string[];
	export {};
	//# sourceMappingURL=ag-grid-column-config.d.ts.map
}
declare module 'lib/component/field/reference/reference-types' {
	import type { ClientNode } from '@sage/xtrem-client';
	import type { IsStrictlyAny } from '@sage/xtrem-shared';
	import type { ScreenBase } from 'lib/service/screen-base';
	import type { ScreenExtension } from 'lib/types';
	import type { CellParams } from 'lib/utils/ag-grid/ag-grid-column-config';
	import type { BlockControlObject, TileControlObject } from 'lib/component/control-objects';
	import type { EditableFieldProperties } from 'lib/component/editable-field-control-object';
	import type { GridNestedFieldTypes, NestedField } from 'lib/component/nested-fields';
	import type { ClientCollectionRecursiveBind, FieldControlObjectInstance, Id, PropertyRecursiveBind, ReferenceRecursiveBind, ReferenceRecursiveOrderBy } from 'lib/component/types';
	import type { SelectItem } from 'lib/component/ui/select/select-component';
	import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from 'lib/component/field/field-base-component-types';
	import type { Changeable, Clickable, ExtensionField, HasDynamicLookupSuggestions, HasFilter, HasHelperTextField, HasIcon, HasImageField, HasInputValueChangeListener, HasLookupDialogTitle, HasNestedFilter, HasNode, HasParent, HasSound, HasValueField, Nested, NestedChangeable, NestedClickable, NestedGroupAggregations, NestedHasLookupDialogTitle, NestedValidatable, Sizable, Validatable } from 'lib/component/field/traits';
	export type PropertyValueType<T extends ClientNode = any> = IsStrictlyAny<T> extends true ? any : (keyof T & string) | Id<PropertyRecursiveBind<T>>;
	export type ClientCollectionValueType<T extends ClientNode = any> = IsStrictlyAny<T> extends true ? any : (keyof T & string) | Id<ClientCollectionRecursiveBind<T>>;
	export type ReferenceValueType<T extends ClientNode = any> = IsStrictlyAny<T> extends true ? any : (keyof T & string) | Id<ReferenceRecursiveBind<T>>;
	export interface ReferenceProperties<CT extends ScreenExtension<CT> = ScreenBase, ReferencedItemType extends ClientNode = any, ContextNodeType = any> extends EditableFieldProperties<CT, ContextNodeType>, HasDynamicLookupSuggestions<CT, ReferencedItemType>, HasFilter<CT, ReferencedItemType>, HasIcon, HasSound<CT>, HasNode<CT>, HasValueField<ReferencedItemType>, HasHelperTextField<ReferencedItemType>, HasImageField<ReferencedItemType>, Sizable {
	    /** Whether the rows of the reference lookup can be filtered or not. Defaults to true */
	    canFilter?: boolean;
	    /** Column definitions for the lookup dialog */
	    columns?: NestedField<CT, GridNestedFieldTypes, ReferencedItemType>[];
	    /** Minimum number of characters to trigger server lookup. If `0` supplied, the first page of suggestions will be fetched on focus. Defaults to 3 */
	    minLookupCharacters?: number;
	    /** The column or the set of columns which the table should be sorted by */
	    orderBy?: ReferenceRecursiveOrderBy<ReferencedItemType>;
	    /** Placeholder to be displayed in the field body */
	    placeholder?: string;
	    /** Auto-select item if search matches only one element */
	    isReferenceDialogOpen?: boolean;
	    /** Auto-select item if search matches only one element */
	    isAutoSelectEnabled?: boolean;
	    /** Should auto select and suggestion be based on all known columns? */
	    shouldSuggestionsIncludeColumns?: boolean;
	    /** Button label for the create new button at the end of the dropdown list and the top of the lookup button. */
	    createTunnelLinkText?: string;
	    tunnelPageIdField?: PropertyValueType<ReferencedItemType>;
	    /** Path reference to an other page. The user can use this page to view the details or modify the selected record.
	     * When no value is selected, the user can create a new record using this page.
	     * */
	    tunnelPage?: string;
	}
	export interface ReferenceDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<ReferenceProperties<CT, ReferencedItemType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, HasInputValueChangeListener<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasLookupDialogTitle<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasSound<CT>, Sizable, Validatable<CT, ReferencedItemType> {
	    /** Function to be executed when the reference's dialog is opened */
	    onOpenReferenceDialog?: (this: CT) => void;
	    /** Function to be executed when the reference's dialog is closed */
	    onCloseReferenceDialog?: (this: CT) => void;
	    /** Minimum number of characters to trigger server lookup */
	    minLookupCharacters?: number;
	    /** Whether the dropdown is disabled or not. If disabled the lookup dialog will be forcefully enabled. */
	    isDropdownDisabled?: boolean;
	}
	export interface NestedReferenceProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any, ReferencedNode extends ClientNode = any> extends Omit<ReferenceProperties<CT, ReferencedNode, ContextNodeType>, 'bind' | 'filter'>, NestedChangeable<CT>, NestedClickable<CT>, Nested<ContextNodeType, ReferenceValueType<ContextNodeType>>, NestedGroupAggregations<'distinctCount'>, Sizable, NestedHasLookupDialogTitle<CT, ContextNodeType>, HasNestedFilter<CT, ContextNodeType, ReferencedNode>, NestedValidatable<CT, ReferencedNode, ContextNodeType> {
	    /** Minimum number of characters to trigger server lookup */
	    minLookupCharacters?: number;
	    /** Whether the dropdown is disabled or not. If disabled the lookup dialog will be set to true. */
	    isDropdownDisabled?: boolean;
	    /** Limit the values to the ones used in the existing dataset */
	    isFilterLimitedToDataset?: boolean;
	    /** Path reference to an other page. The user can use this page to view the details or modify the selected record.
	     * When no value is selected, the user can create a new record using this page.
	     * */
	    tunnelPage?: string;
	    /** Function to be executed when the reference's dialog is opened */
	    onOpenReferenceDialog?: (this: CT, _id: string) => void;
	    /** Function to be executed when the reference's dialog is closed */
	    onCloseReferenceDialog?: (this: CT, _id: string) => void;
	}
	export type BaseReferenceExtensionDecoratorProperties<CT extends ScreenBase = ScreenBase> = {
	    onCloseReferenceDialogAfter?: (this: CT, _id: any) => void;
	    onOpenReferenceDialogAfter?: (this: CT, _id: any) => void;
	    onInputValueChangeAfter?: (this: CT, inputValue: string, isBulkChange: boolean) => void;
	};
	export type ReferenceComponentProps<T extends ClientNode = any> = BaseEditableComponentProperties<ReferenceDecoratorProperties<any, T>, T, NestedFieldsAdditionalProperties>;
	export interface ConnectedReferenceComponentProps<T extends ClientNode = any> extends ReferenceComponentProps<T> {
	    hasAccessToTunnelPage: boolean;
	    openTunnel: (fieldProperties: ReferenceDecoratorProperties, value: any) => Promise<any | null>;
	}
	export interface ReferenceComponentState {
	    id: string;
	    isNestedLookupDialogOpen?: boolean;
	}
	export interface ReferenceCellEditorState {
	    id: string;
	    highlightOnFocus: boolean;
	    isLookupPanelOpen: boolean;
	    selectedRecord?: SelectItem;
	    startValue: string;
	}
	export interface ReferenceCellEditorProps extends CellParams<NestedReferenceProperties, any> {
	}
	export type ReferenceCellRendererExternalProps = CellParams<NestedReferenceProperties>;
	export interface ReferenceCellRendererProps extends ReferenceCellRendererExternalProps {
	    hasAccessToTunnelPage: boolean;
	    openTunnel: (fieldProperties: ReferenceDecoratorProperties, value: any) => Promise<any | null>;
	}
	//# sourceMappingURL=reference-types.d.ts.map
}
declare module 'lib/component/table-sidebar/table-sidebar-types' {
	import type { ClientNode, Dict } from '@sage/xtrem-client';
	import type { ScreenExtension } from 'lib/types';
	import type { ValueOrCallback } from 'lib/utils/types';
	import type { MenuSeparatorType } from 'lib/component/container/page/page-types';
	import type { PropertyValueType } from 'lib/component/field/reference/reference-types';
	import type { CollectionItemAction, CollectionItemActionGroup } from 'lib/component/ui/table-shared/table-dropdown-actions/table-dropdown-action-types';
	import type { FieldControlObjectInstance, FieldKey } from 'lib/component/types';
	export interface SidebarFieldBinding {
	    fieldId: string;
	    isNested: boolean;
	}
	export type SidebarFieldDefinition<ReferencedItemType extends ClientNode = any> = PropertyValueType<ReferencedItemType> | FieldControlObjectInstance<FieldKey>;
	export interface SidebarBlockDefinition<CT extends ScreenExtension<CT> = any, ReferencedItemType extends ClientNode = any> {
	    title?: string;
	    fields: SidebarFieldDefinition<ReferencedItemType>[];
	    isHidden?: (this: CT, _id: string, recordValue?: ReferencedItemType) => boolean;
	}
	export interface SidebarSectionDefinition<CT extends ScreenExtension<CT> = any, ReferencedItemType extends ClientNode = any> {
	    title: string;
	    blocks: Dict<SidebarBlockDefinition<CT, ReferencedItemType>>;
	    isHidden?: (this: CT, _id: string, recordValue?: ReferencedItemType) => boolean;
	}
	export interface SidebarDefinitionDecorator<CT extends ScreenExtension<CT> = any, ReferencedItemType extends ClientNode = any> {
	    title?: string | ((this: CT, _id: string, recordValue?: ReferencedItemType) => string);
	    isReadOnly?: (this: CT, _id: string, recordValue?: ReferencedItemType) => boolean;
	    onRecordOpened?: (this: CT, _id: string, recordValue?: ReferencedItemType) => Promise<void>;
	    onRecordConfirmed?: (this: CT, _id: string, recordValue?: ReferencedItemType) => Promise<void>;
	    onRecordDiscarded?: (this: CT, _id: string, recordValue?: ReferencedItemType) => Promise<void>;
	    layout: ValueOrCallback<CT, Dict<SidebarSectionDefinition<CT, ReferencedItemType>>>;
	    headerDropdownActions?: Array<CollectionItemAction<CT, ReferencedItemType> | CollectionItemActionGroup<CT, ReferencedItemType> | MenuSeparatorType>;
	    headerQuickActions?: Array<CollectionItemAction<CT, ReferencedItemType>>;
	}
	//# sourceMappingURL=table-sidebar-types.d.ts.map
}
declare module 'lib/utils/state-utils' {
	import type { Dict } from '@sage/xtrem-shared';
	import type { PageNavigationPanel, PageProperties } from 'lib/component/container/page/page-types';
	import type { PageControlObject, TableProperties } from 'lib/component/control-objects';
	import { AbstractUiControlObject, SectionControlObject } from 'lib/component/control-objects';
	import type { PageDecoratorProperties, TableDecoratorProperties } from 'lib/component/decorator-properties';
	import type { SidebarSectionDefinition } from 'lib/component/table-sidebar/table-sidebar-types';
	import * as xtremRedux from 'lib/redux';
	import type { NavigationPanelState, XtremAppState } from 'lib/redux/state';
	import type { Page } from 'lib/service/page';
	import type { PageDefinition } from 'lib/service/page-definition';
	import type { ScreenBaseDefinition } from 'lib/service/screen-base-definition';
	import type { MakeRequired } from 'lib/utils/types';
	export const isScreenDefinitionDirty: (screenDefinition: ScreenBaseDefinition) => boolean;
	export const hasAnyDirtyScreenDefinitions: (state: XtremAppState) => boolean;
	export const getPageDefinitionFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageDefinition;
	export const getPageDefinition: (screenId: string, state?: xtremRedux.XtremAppState) => PageDefinition | undefined;
	export const getMainPageDefinitionFromState: (state?: xtremRedux.XtremAppState) => PageDefinition | undefined;
	export const getPagePropertiesFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageProperties & PageDecoratorProperties<Page>;
	export const getPageControlObjectFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageControlObject | null;
	export const getPagePropertiesFromPageDefinition: (pageDefinition: PageDefinition) => PageProperties & PageDecoratorProperties<Page>;
	export const getNavigationPanelState: (screenId: string, state?: xtremRedux.XtremAppState) => NavigationPanelState | null;
	export const getNavigationPanelDefinitionFromState: (screenId: string, state?: xtremRedux.XtremAppState) => PageNavigationPanel<any> | null;
	export const getNavigationPanelTablePropertiesFromPageDefinition: (pageDefinition: PageDefinition) => TableDecoratorProperties;
	export const checkIfPageIsLoaded: (screenId: string, state?: xtremRedux.XtremAppState) => void;
	export const arePlatformLiteralsMissing: (state?: xtremRedux.XtremAppState, locale?: string) => boolean;
	export const getSidebarTableProperties: ({ elementId, pageDefinition, level, }: {
	    pageDefinition: PageDefinition;
	    level?: number;
	    elementId: string;
	}) => MakeRequired<TableProperties, 'sidebar'>;
	export const getSidebarLayoutDefinitionFromState: (state?: xtremRedux.XtremAppState) => Dict<SidebarSectionDefinition>;
	export const getSidebarNormalFields: (state?: xtremRedux.XtremAppState) => AbstractUiControlObject[];
	export const getSidebarNestedFields: (state?: xtremRedux.XtremAppState) => string[];
	export const isSidebarDirty: (state?: xtremRedux.XtremAppState) => boolean;
	export const getVisibleSectionsFromPage: (screenId: string, screenDefinition?: ScreenBaseDefinition) => SectionControlObject[];
	//# sourceMappingURL=state-utils.d.ts.map
}
declare module 'lib/redux/actions/transaction-actions' {
	import type { XtremUiTransaction as transactionActions } from 'lib/service/transactions-service';
	import type { AppAction } from 'lib/redux/action-types';
	export const commitTransaction: (screenId: string, transaction: transactionActions) => AppAction;
	//# sourceMappingURL=transaction-actions.d.ts.map
}
declare module 'lib/service/transactions-service' {
	import type { ComponentKey, ControlObjectProps, FieldInternalValue, FieldKey } from 'lib/component/types';
	import type { Dict } from '@sage/xtrem-shared';
	type UCPType<T extends ComponentKey> = ControlObjectProps<T> extends {
	    getUiComponentProperties: (...args: any[]) => infer U;
	} ? U : any;
	export interface XtremUiTransactionEntry {
	    value: any;
	    hasChangedInTransaction: boolean;
	}
	export interface XtremUiTransaction {
	    values: Dict<XtremUiTransactionEntry>;
	    uiComponentProperties: Dict<XtremUiTransactionEntry>;
	}
	export const commitTransaction: (screenId: string) => void;
	export const rollbackTransaction: (screenId: string) => void;
	export const isTransactionInProgress: (screenId: string) => boolean;
	export const getFieldValue: <T extends FieldKey>(screenId: string, elementId: string) => FieldInternalValue<T>;
	export const setFieldValue: <T extends FieldKey>(screenId: string, elementId: string, newValue: FieldInternalValue<T>) => void;
	export const getUiComponentProperties: <T extends ComponentKey>(screenId: string, elementId: string) => UCPType<T>;
	export const setUiComponentProperties: <T extends ComponentKey>(screenId: string, elementId: string, newValue: Partial<ControlObjectProps<T>>) => void;
	export const executeInReadOnlyTransaction: (callback: ()