import React from 'react';
import type { ClientError, ErrorDetail } from '@sage/xtrem-client';
import type { Dict } from '@sage/xtrem-shared';
import type { PodCollectionDecoratorProperties } from '../component/control-objects';
import type { DetailListDecoratorProperties, NestedGridDecoratorProperties, PodDecoratorProperties, TableDecoratorProperties, VitalPodDecoratorProperties } from '../component/decorators';
import type { ScreenBase } from '../service/screen-base';
import type { ValidationResult } from '../service/screen-base-definition';
export interface TransformedServerError {
    validationErrors: Dict<ValidationResult[]>;
    globalError?: Error;
}
type NestedFieldDecoratorProperties = TableDecoratorProperties | NestedGridDecoratorProperties | PodCollectionDecoratorProperties | PodDecoratorProperties<any, any> | VitalPodDecoratorProperties<any, any> | DetailListDecoratorProperties;
export declare const findNestedFieldProperties: (screenId: string, columnId: string, fieldProperties: NestedFieldDecoratorProperties, level?: number) => string;
export declare const transformServerErrorToToast: (error: ClientError, screenBase: ScreenBase) => Promise<TransformedServerError>;
export declare class ServerError extends Error {
    readonly toastContent: React.ReactNode;
    readonly errors: ErrorDetail[];
    constructor(message: string, toastContent: React.ReactNode, errors: ErrorDetail[]);
}
export {};
//# sourceMappingURL=server-error-transformer.d.ts.map