import { set } from 'lodash';
import { getIdFieldValue } from './id-field-utils';
import { resolveByRecordValue } from './resolve-value-utils';
export function getHeaderTitles({ idFieldValue, isRecordCreationPage, objectTypePlural, objectTypeSingular, subtitle, title, }) {
    const isObjectTypeDefined = !!objectTypePlural && !!objectTypeSingular;
    if (isObjectTypeDefined) {
        if (isRecordCreationPage) {
            return { subtitle: undefined, title: objectTypeSingular };
        }
        return idFieldValue
            ? { subtitle: undefined, title: `${objectTypeSingular} ${idFieldValue}` }
            : { subtitle: undefined, title: `${objectTypePlural}` };
    }
    return { subtitle, title };
}
export const getPageTitlesFromPageDefinition = (pageDefinition, locale) => {
    const idFieldValue = getIdFieldValue(pageDefinition, locale);
    const screenId = pageDefinition.metadata.screenId;
    const pageDecoratorProps = pageDefinition.metadata.uiComponentProperties[screenId];
    return getHeaderTitles({
        title: resolveByRecordValue({
            propertyValue: pageDecoratorProps.title,
            screenId,
            rowValue: null,
            skipHexFormat: true,
        }),
        subtitle: resolveByRecordValue({
            propertyValue: pageDecoratorProps.subtitle,
            screenId,
            rowValue: null,
            skipHexFormat: true,
        }),
        idFieldValue,
        isRecordCreationPage: false,
        objectTypePlural: resolveByRecordValue({
            propertyValue: pageDecoratorProps.objectTypePlural,
            screenId,
            rowValue: null,
            skipHexFormat: true,
        }),
        objectTypeSingular: resolveByRecordValue({
            propertyValue: pageDecoratorProps.objectTypeSingular,
            screenId,
            rowValue: null,
            skipHexFormat: true,
        }),
    });
};
/**
 * Mutates PageMetadata to inject the provided onLoad function to be executed after the page fragment or page extension has been loaded
 */
export const injectOnloadAfterIntoPageMetadata = (pageMetadata, onLoad) => {
    if (pageMetadata.uiComponentProperties?.[pageMetadata.screenId]?.onLoadAfter) {
        pageMetadata.uiComponentProperties[pageMetadata.screenId].onLoadAfter.push(onLoad);
        pageMetadata.defaultUiComponentProperties[pageMetadata.screenId].onLoadAfter.push(onLoad);
    }
    else {
        set(pageMetadata, ['uiComponentProperties', pageMetadata.screenId, 'onLoadAfter'], [onLoad]);
        set(pageMetadata, ['defaultUiComponentProperties', pageMetadata.screenId, 'onLoadAfter'], [onLoad]);
    }
};
//# sourceMappingURL=page-utils.js.map