import { isEqual, isObject, transform } from 'lodash';
export function deepFreeze(object) {
    if (isObject(object) && Object.isFrozen(object)) {
        return object;
    }
    // Retrieve the property names defined on object
    const propNames = Object.getOwnPropertyNames(object);
    // Freeze properties before freezing self
    // eslint-disable-next-line no-restricted-syntax
    for (const name of propNames) {
        const value = object[name];
        object[name] = value && typeof value === 'object' ? deepFreeze(value) : value;
    }
    return Object.freeze(object);
}
export function containsValueDeep(object, value, strict = true) {
    // eslint-disable-next-line eqeqeq
    if (!strict && object == value) {
        return true;
    }
    if (object === value) {
        return true;
    }
    if (!object) {
        return false;
    }
    if (object instanceof Array) {
        return object.findIndex(k => containsValueDeep(k, value, strict)) !== -1;
    }
    if (typeof object === 'object') {
        return Object.keys(object).findIndex(k => containsValueDeep(object[k], value, strict)) !== -1;
    }
    return false;
}
export function differenceBetweenObjects(object, base) {
    return transform(object, (result, value, key) => {
        if (!isEqual(value, base[key])) {
            result[key] =
                isObject(value) && isObject(base[key]) ? differenceBetweenObjects(value, base[key]) : value;
        }
    });
}
/** Deep search an object structure by a property name. It returns a unique set of results. */
export const deepFindPropertyValues = (propertyName, target, callback = () => true) => {
    const result = [];
    const deepFind = (currentTarget) => {
        if (Array.isArray(currentTarget)) {
            currentTarget.forEach(deepFind);
        }
        else if (typeof currentTarget === 'object' && currentTarget !== null) {
            Object.keys(currentTarget).forEach(currentKey => {
                if (currentKey === propertyName) {
                    if (callback(currentTarget)) {
                        result.push(currentTarget[currentKey]);
                    }
                }
                else {
                    deepFind(currentTarget[currentKey]);
                }
            });
        }
    };
    deepFind(target);
    return Array.from(new Set(result));
};
//# sourceMappingURL=common-util.js.map