import arSa from 'date-fns/locale/ar-SA';
import deDe from 'date-fns/locale/de';
import enGb from 'date-fns/locale/en-GB';
import enUs from 'date-fns/locale/en-US';
import esEs from 'date-fns/locale/es';
import frFr from 'date-fns/locale/fr';
import itIT from 'date-fns/locale/it';
import plPl from 'date-fns/locale/pl';
import ptPt from 'date-fns/locale/pt';
import ptBr from 'date-fns/locale/pt-BR';
import zhCn from 'date-fns/locale/zh-CN';
import { memoize } from 'lodash';
import { localize } from '../service/i18n-service';
const dateLocales = {
    'en-GB': enGb,
    'en-US': enUs,
    'es-ES': esEs,
    'pl-PL': plPl,
    'zh-CN': zhCn,
    'fr-FR': frFr,
    'pt-PT': ptPt,
    'pt-BR': ptBr,
    'ar-SA': arSa,
    'de-DE': deDe,
    'it-IT': itIT,
};
export const isSingular = (count) => parseInt(count, 10) === 1;
export const carbonLocale = memoize((selectedLocale) => ({
    locale: () => selectedLocale,
    actions: {
        edit: () => localize('@sage/xtrem-ui/action-edit', 'Edit'),
        delete: () => localize('@sage/xtrem-ui/action-delete', 'Delete'),
    },
    actionPopover: {
        ariaLabel: () => 'actions',
    },
    batchSelection: {
        selected: (count) => localize('@sage/xtrem-ui/action-tool-bar-items-selected', 'Items selected: {{count}}', { count }),
    },
    confirm: {
        no: () => localize('@sage/xtrem-ui/generic-no', 'No'),
        yes: () => localize('@sage/xtrem-ui/generic-yes', 'Yes'),
    },
    date: {
        dateFnsLocale: () => dateLocales[selectedLocale] || dateLocales['en-US'],
        ariaLabels: {
            previousMonthButton: () => localize('@sage/xtrem-ui/previous-month', 'Previous'),
            nextMonthButton: () => localize('@sage/xtrem-ui/next-month', 'Next'),
        },
    },
    errors: {
        messages: {
            formSummary: () => null,
        },
    },
    message: {
        closeButtonAriaLabel: () => localize('@sage/xtrem-ui/action-close', 'Close'),
    },
    numeralDate: {
        validation: {
            day: () => localize('@sage/xtrem-ui/date-error-day-range', 'Day should be a number within a 1-31 range.'),
            month: () => localize('@sage/xtrem-ui/date-error-month-range', 'Month should be a number within a 1-12 range.'),
            year: () => localize('@sage/xtrem-ui/date-error-year-range', 'Year should be a number within a 1800-2200 range.'),
        },
        labels: {
            day: () => localize('@sage/xtrem-ui/calendar-view-day', 'Day'),
            month: () => localize('@sage/xtrem-ui/calendar-view-month', 'Month'),
            year: () => localize('@sage/xtrem-ui/calendar-view-year', 'Year'),
        },
    },
    pager: {
        show: () => localize('@sage/xtrem-ui/table-show', 'Show'),
        records: (count, showNumber = true) => {
            const noun = isSingular(count) ? 'item' : 'items';
            return showNumber ? `${count} ${noun}` : noun;
        },
        first: () => localize('@sage/xtrem-ui/table-first', 'First'),
        last: () => localize('@sage/xtrem-ui/table-last', 'Last'),
        next: () => localize('@sage/xtrem-ui/table-next', 'Next'),
        previous: () => localize('@sage/xtrem-ui/table-previous', 'Previous'),
        pageX: () => 'Page',
        ofY: (count) => `of ${count}`,
    },
    select: {
        actionButtonText: () => 'Add an item',
        placeholder: () => localize('@sage/xtrem-ui/please-select-placeholder', 'Please Select...'),
        noResultsForTerm: (term) => `No results for "${term}"`,
    },
    switch: {
        on: () => localize('@sage/xtrem-ui/switch-on-caps', 'ON'),
        off: () => localize('@sage/xtrem-ui/switch-off-caps', 'OFF'),
    },
    textEditor: {
        tooltipMessages: {
            bold: () => localize('@sage/xtrem-ui/text-format-capital-bold', 'Bold'),
            italic: () => localize('@sage/xtrem-ui/text-format-capital-italic', 'Italic'),
            bulletList: () => localize('@sage/xtrem-ui/text-format-capital-bullet-list', 'Bullet List'),
            numberList: () => localize('@sage/xtrem-ui/text-format-capital-number-list', 'Number List'),
        },
        ariaLabels: {
            bold: () => 'bold',
            italic: () => 'italic',
            bulletList: () => 'bullet-list',
            numberList: () => 'number-list',
        },
    },
}));
//# sourceMappingURL=carbon-locale.js.map