import { block } from '../component/container/block/block-decorator';
import { multiFileDepositField } from '../component/field/multi-file-deposit/multi-file-deposit-decorator';
import { attachmentsMimeTypes } from '@sage/xtrem-shared';
import { schemaTypeNameFromNodeName } from './transformers';
import { findDeepPropertyType } from './node-utils';
import { ATTACHMENTS_ELEMENT_ID, ATTACHMENTS_PROPERTY_NAME } from './constants';
import { localize } from '../service/i18n-service';
export const getAttachmentInformation = (nodeName, nodeTypes) => {
    const node = schemaTypeNameFromNodeName(nodeName);
    if (!nodeTypes[node]?.hasAttachments) {
        return null;
    }
    const attachmentAssociationNode = findDeepPropertyType(node, ATTACHMENTS_PROPERTY_NAME, nodeTypes)?.targetNode;
    const attachmentFileNode = findDeepPropertyType(node, `${ATTACHMENTS_PROPERTY_NAME}.attachment`, nodeTypes)?.targetNode;
    if (attachmentAssociationNode && attachmentFileNode) {
        return {
            attachmentAssociationNode,
            attachmentFileNode,
        };
    }
    return null;
};
export function addAttachmentElements(pageMetadata, attachmentInformation) {
    if (!pageMetadata?.target) {
        return;
    }
    block({
        isTitleHidden: true,
    })(pageMetadata.target, '$attachmentBlock');
    multiFileDepositField({
        parent() {
            return this.$attachmentBlock;
        },
        isTitleHidden: true,
        bind: ATTACHMENTS_PROPERTY_NAME,
        title: localize('@sage/xtrem-ui/attachments', 'Attachments'),
        node: attachmentInformation.attachmentAssociationNode,
        attachmentNode: attachmentInformation.attachmentFileNode,
        canUserHideColumns: true,
        fileTypes: attachmentsMimeTypes.join(', '),
    })(pageMetadata.target, ATTACHMENTS_ELEMENT_ID);
}
//# sourceMappingURL=attachment-utils.js.map