export const asyncForEach = async (array, callback) => {
    for (let index = 0; index < array.length; index += 1) {
        // eslint-disable-next-line no-await-in-loop
        await callback(array[index], index, array);
    }
};
/**
 *  Makes a promise cancelable/abortable without libraries or subclassing
 */
export const cancelable = (promise) => {
    const controller = new AbortController();
    const signal = controller.signal;
    let handler;
    return [
        () => {
            controller.abort();
        },
        Promise.race([
            new Promise((_, reject) => {
                handler = () => {
                    reject(new DOMException('AbortError', 'AbortError'));
                };
                signal.addEventListener('abort', handler);
            }),
            promise,
        ]).finally(() => signal.removeEventListener('abort', handler)),
    ];
};
/**
 *  Takes only last promise call by cancelling the previous ones, avoids race conditions.
 */
export const takeLatest = () => {
    let cancel = null;
    let latestPromise = null;
    return (promise) => {
        if (latestPromise && cancel) {
            cancel();
        }
        [cancel, latestPromise] = cancelable(promise);
        return latestPromise;
    };
};
//# sourceMappingURL=async.js.map