import { memoize } from 'lodash';
import { localize } from '../../service/i18n-service';
export const localeText = memoize(() => ({
    // Set Filter
    selectAll: localize('@sage/xtrem-ui/table-selectAll', 'Select All'),
    selectAllSearchResults: localize('@sage/xtrem-ui/table-selectAllSearchResults', 'Select All Search Results'),
    searchOoo: localize('@sage/xtrem-ui/table-searchOoo', 'Search...'),
    blanks: localize('@sage/xtrem-ui/table-blanks', 'Blanks'),
    noMatches: localize('@sage/xtrem-ui/table-noMatches', 'No matches.'),
    // Number Filter & Text Filter
    filterOoo: localize('@sage/xtrem-ui/table-filterOoo', 'Filter...'),
    equals: localize('@sage/xtrem-ui/table-equals', 'Equals'),
    notEqual: localize('@sage/xtrem-ui/table-notEqual', 'Not equal'),
    // Number Filter
    lessThan: localize('@sage/xtrem-ui/table-lessThan', 'Less than'),
    greaterThan: localize('@sage/xtrem-ui/table-greaterThan', 'Greater than'),
    lessThanOrEqual: localize('@sage/xtrem-ui/table-lessThanOrEqual', 'Less than or equal'),
    greaterThanOrEqual: localize('@sage/xtrem-ui/table-greaterThanOrEqual', 'Greater than or equal'),
    inRange: localize('@sage/xtrem-ui/table-inRange', 'In range'),
    inRangeStart: localize('@sage/xtrem-ui/table-inRangeStart', 'From'),
    inRangeEnd: localize('@sage/xtrem-ui/table-inRangeEnd', 'To'),
    // Text Filter
    contains: localize('@sage/xtrem-ui/table-contains', 'Contains'),
    notContains: localize('@sage/xtrem-ui/table-notContains', 'Not contains'),
    startsWith: localize('@sage/xtrem-ui/table-startsWith', 'Starts with'),
    endsWith: localize('@sage/xtrem-ui/table-endsWith', 'Ends with'),
    // Date Filter
    dateFormatOoo: localize('@sage/xtrem-ui/table-dateFormatOoo', 'YYYY-MM-DD'),
    // Filter Conditions
    andCondition: localize('@sage/xtrem-ui/table-andCondition', 'AND'),
    orCondition: localize('@sage/xtrem-ui/table-orCondition', 'OR'),
    // Filter Buttons
    applyFilter: localize('@sage/xtrem-ui/table-applyFilter', 'Apply'),
    resetFilter: localize('@sage/xtrem-ui/table-resetFilter', 'Reset'),
    clearFilter: localize('@sage/xtrem-ui/table-clearFilter', 'Clear'),
    cancelFilter: localize('@sage/xtrem-ui/table-cancelFilter', 'Cancel'),
    // Side Bar
    columns: localize('@sage/xtrem-ui/table-columns', 'Columns'),
    filters: localize('@sage/xtrem-ui/table-filters', 'Filters'),
    // columns tool panel
    pivotMode: localize('@sage/xtrem-ui/table-pivotMode', 'Pivot Mode'),
    groups: localize('@sage/xtrem-ui/table-groups', 'Row Groups'),
    rowGroupColumnsEmptyMessage: localize('@sage/xtrem-ui/table-rowGroupColumnsEmptyMessage', 'Drag here to set row groups'),
    values: localize('@sage/xtrem-ui/table-values', 'Values'),
    valueColumnsEmptyMessage: localize('@sage/xtrem-ui/table-valueColumnsEmptyMessage', 'Drag here to aggregate'),
    pivots: localize('@sage/xtrem-ui/table-pivots', 'Column Labels'),
    pivotColumnsEmptyMessage: localize('@sage/xtrem-ui/table-pivotColumnsEmptyMessage', 'Drag here to set column labels'),
    // Header of the Default Group Column
    group: localize('@sage/xtrem-ui/table-group', 'Group'),
    // Other
    loadingOoo: localize('@sage/xtrem-ui/table-loadingOoo', 'Loading...'),
    noRowsToShow: localize('@sage/xtrem-ui/table-noRowsToShow', 'No Rows To Show'),
    enabled: localize('@sage/xtrem-ui/table-enabled', 'Enabled'),
    // Menu
    pinColumn: localize('@sage/xtrem-ui/table-pinColumn', 'Pin Column'),
    pinLeft: localize('@sage/xtrem-ui/table-pinLeft', 'Pin Left'),
    pinRight: localize('@sage/xtrem-ui/table-pinRight', 'Pin Right'),
    noPin: localize('@sage/xtrem-ui/table-noPin', 'No Pin'),
    valueAggregation: localize('@sage/xtrem-ui/table-valueAggregation', 'Value Aggregation'),
    autosizeThisColumn: localize('@sage/xtrem-ui/table-autosizeThiscolumn', 'Autosize This Column'),
    autosizeAllColumns: localize('@sage/xtrem-ui/table-autosizeAllColumns', 'Autosize All Columns'),
    groupBy: localize('@sage/xtrem-ui/table-groupBy', 'Group by'),
    ungroupBy: localize('@sage/xtrem-ui/table-ungroupBy', 'Un-Group by'),
    resetColumns: localize('@sage/xtrem-ui/table-resetColumns', 'Reset Columns'),
    expandAll: localize('@sage/xtrem-ui/table-expandAll', 'Expand All'),
    collapseAll: localize('@sage/xtrem-ui/table-collapseAll', 'Close All'),
    copy: localize('@sage/xtrem-ui/table-copy', 'Copy'),
    ctrlC: localize('@sage/xtrem-ui/table-ctrlC', 'Ctrl+C'),
    copyWithHeaders: localize('@sage/xtrem-ui/table-copyWithHeaders', 'Copy With Headers'),
    paste: localize('@sage/xtrem-ui/table-paste', 'Paste'),
    ctrlV: localize('@sage/xtrem-ui/table-ctrlV', 'Ctrl+V'),
    export: localize('@sage/xtrem-ui/table-export', 'Export'),
    csvExport: localize('@sage/xtrem-ui/table-csvExport', 'CSV Export'),
    excelExport: localize('@sage/xtrem-ui/table-excelExport', 'Excel Export (.xlsx)'),
    excelXmlExport: localize('@sage/xtrem-ui/table-excelXmlExport', 'Excel Export (.xml)'),
    // Enterprise Menu Aggregation and Status Bar
    sum: localize('@sage/xtrem-ui/table-sum', 'Sum'),
    min: localize('@sage/xtrem-ui/table-min', 'Min'),
    max: localize('@sage/xtrem-ui/table-max', 'Max'),
    none: localize('@sage/xtrem-ui/table-none', 'None'),
    count: localize('@sage/xtrem-ui/table-count', 'Count'),
    avg: localize('@sage/xtrem-ui/table-avg', 'Average'),
    filteredRows: localize('@sage/xtrem-ui/table-filteredRows', 'Filtered'),
    selectedRows: localize('@sage/xtrem-ui/table-selectedRows', 'Selected'),
    totalRows: localize('@sage/xtrem-ui/table-totalRows', 'Total Rows'),
    totalAndFilteredRows: localize('@sage/xtrem-ui/table-totalAndFilteredRows', 'Rows'),
    page: localize('@sage/xtrem-ui/table-page', 'Page'),
    more: localize('@sage/xtrem-ui/table-more', 'More'),
    to: localize('@sage/xtrem-ui/table-to', 'To'),
    of: localize('@sage/xtrem-ui/table-of', 'Of'),
    next: localize('@sage/xtrem-ui/table-next', 'Next'),
    last: localize('@sage/xtrem-ui/table-last', 'Last'),
    first: localize('@sage/xtrem-ui/table-first', 'First'),
    previous: localize('@sage/xtrem-ui/table-previous', 'Previous'),
    // Enterprise Menu (Charts)
    pivotChartAndPivotMode: localize('@sage/xtrem-ui/table-pivotChartAndPivotMode', 'Pivot Chart & Pivot Mode'),
    pivotChart: localize('@sage/xtrem-ui/table-pivotChart', 'Pivot Chart'),
    chartRange: localize('@sage/xtrem-ui/table-chartRange', 'Chart Range'),
    columnChart: localize('@sage/xtrem-ui/table-columnChart', 'Column'),
    groupedColumn: localize('@sage/xtrem-ui/table-groupedColumn', 'Grouped'),
    stackedColumn: localize('@sage/xtrem-ui/table-stackedColumn', 'Stacked'),
    normalizedColumn: localize('@sage/xtrem-ui/table-normalizedColumn', '100% Stacked'),
    barChart: localize('@sage/xtrem-ui/table-barChart', 'Bar'),
    groupedBar: localize('@sage/xtrem-ui/table-groupedBar', 'Grouped'),
    stackedBar: localize('@sage/xtrem-ui/table-stackedBar', 'Stacked'),
    normalizedBar: localize('@sage/xtrem-ui/table-normalizedBar', '100% Stacked'),
    pieChart: localize('@sage/xtrem-ui/table-pieChart', 'Pie'),
    pie: localize('@sage/xtrem-ui/table-pie', 'Pie'),
    doughnut: localize('@sage/xtrem-ui/table-doughnut', 'Doughnut'),
    line: localize('@sage/xtrem-ui/table-line', 'Line'),
    xyChart: localize('@sage/xtrem-ui/table-xyChart', 'X Y (Scatter)'),
    scatter: localize('@sage/xtrem-ui/table-scatter', 'Scatter'),
    bubble: localize('@sage/xtrem-ui/table-bubble', 'Bubble'),
    areaChart: localize('@sage/xtrem-ui/table-areaChart', 'Area'),
    area: localize('@sage/xtrem-ui/table-area', 'Area'),
    stackedArea: localize('@sage/xtrem-ui/table-stackedArea', 'Stacked'),
    normalizedArea: localize('@sage/xtrem-ui/table-normalizedArea', '100% Stacked'),
    histogramChart: localize('@sage/xtrem-ui/table-histogramChart', 'Histogram'),
    // Charts
    pivotChartTitle: localize('@sage/xtrem-ui/table-pivotChartTitle', 'Pivot Chart'),
    rangeChartTitle: localize('@sage/xtrem-ui/table-rangeChartTitle', 'Range Chart'),
    settings: localize('@sage/xtrem-ui/table-settings', 'Settings'),
    data: localize('@sage/xtrem-ui/table-data', 'Data'),
    format: localize('@sage/xtrem-ui/table-format', 'Format'),
    categories: localize('@sage/xtrem-ui/table-categories', 'Categories'),
    defaultCategory: localize('@sage/xtrem-ui/table-defaultCategory', '(None)'),
    series: localize('@sage/xtrem-ui/table-series', 'Series'),
    xyValues: localize('@sage/xtrem-ui/table-xyValues', 'X Y Values'),
    paired: localize('@sage/xtrem-ui/table-paired', 'Paired Mode'),
    axis: localize('@sage/xtrem-ui/table-axis', 'Axis'),
    navigator: localize('@sage/xtrem-ui/table-navigator', 'Navigator'),
    color: localize('@sage/xtrem-ui/table-color', 'Color'),
    thickness: localize('@sage/xtrem-ui/table-thickness', 'Thickness'),
    xType: localize('@sage/xtrem-ui/table-xType', 'X Type'),
    automatic: localize('@sage/xtrem-ui/table-automatic', 'Automatic'),
    category: localize('@sage/xtrem-ui/table-category', 'Category'),
    number: localize('@sage/xtrem-ui/table-number', 'Number'),
    time: localize('@sage/xtrem-ui/table-time', 'Time'),
    xRotation: localize('@sage/xtrem-ui/table-xRotation', 'X Rotation'),
    yRotation: localize('@sage/xtrem-ui/table-yRotation', 'Y Rotation'),
    ticks: localize('@sage/xtrem-ui/table-ticks', 'Ticks'),
    width: localize('@sage/xtrem-ui/table-width', 'Width'),
    height: localize('@sage/xtrem-ui/table-height', 'Height'),
    length: localize('@sage/xtrem-ui/table-length', 'Length'),
    padding: localize('@sage/xtrem-ui/table-padding', 'Padding'),
    spacing: localize('@sage/xtrem-ui/table-spacing', 'Spacing'),
    chart: localize('@sage/xtrem-ui/table-chart', 'Chart'),
    title: localize('@sage/xtrem-ui/table-title', 'Title'),
    titlePlaceholder: localize('@sage/xtrem-ui/table-titlePlaceholder', 'Chart title - double click to edit'),
    background: localize('@sage/xtrem-ui/table-background', 'Background'),
    font: localize('@sage/xtrem-ui/table-font', 'Font'),
    top: localize('@sage/xtrem-ui/table-top', 'Top'),
    right: localize('@sage/xtrem-ui/table-right', 'Right'),
    bottom: localize('@sage/xtrem-ui/table-bottom', 'Bottom'),
    left: localize('@sage/xtrem-ui/table-left', 'Left'),
    labels: localize('@sage/xtrem-ui/table-labels', 'Labels'),
    size: localize('@sage/xtrem-ui/table-size', 'Size'),
    minSize: localize('@sage/xtrem-ui/table-minSize', 'Minimum Size'),
    maxSize: localize('@sage/xtrem-ui/table-maxSize', 'Maximum Size'),
    legend: localize('@sage/xtrem-ui/table-legend', 'Legend'),
    position: localize('@sage/xtrem-ui/table-position', 'Position'),
    markerSize: localize('@sage/xtrem-ui/table-markerSize', 'Marker Size'),
    markerStroke: localize('@sage/xtrem-ui/table-markerStroke', 'Marker Stroke'),
    markerPadding: localize('@sage/xtrem-ui/table-markerPadding', 'Marker Padding'),
    itemSpacing: localize('@sage/xtrem-ui/table-itemSpacing', 'Item Spacing'),
    itemPaddingX: localize('@sage/xtrem-ui/table-itemPaddingX', 'Item Padding X'),
    itemPaddingY: localize('@sage/xtrem-ui/table-itemPaddingY', 'Item Padding Y'),
    layoutHorizontalSpacing: localize('@sage/xtrem-ui/table-layoutHorizontalSpacing', 'Horizontal Spacing'),
    layoutVerticalSpacing: localize('@sage/xtrem-ui/table-layoutVerticalSpacing', 'Vertical Spacing'),
    strokeWidth: localize('@sage/xtrem-ui/table-strokeWidth', 'Stroke Width'),
    offset: localize('@sage/xtrem-ui/table-offset', 'Offset'),
    offsets: localize('@sage/xtrem-ui/table-offsets', 'Offsets'),
    tooltips: localize('@sage/xtrem-ui/table-tooltips', 'Tooltips'),
    callout: localize('@sage/xtrem-ui/table-callout', 'Callout'),
    markers: localize('@sage/xtrem-ui/table-markers', 'Markers'),
    shadow: localize('@sage/xtrem-ui/table-shadow', 'Shadow'),
    blur: localize('@sage/xtrem-ui/table-blur', 'Blur'),
    xOffset: localize('@sage/xtrem-ui/table-xOffset', 'X Offset'),
    yOffset: localize('@sage/xtrem-ui/table-yOffset', 'Y Offset'),
    lineWidth: localize('@sage/xtrem-ui/table-lineWidth', 'Line Width'),
    normal: localize('@sage/xtrem-ui/table-normal', 'Normal'),
    bold: localize('@sage/xtrem-ui/table-bold', 'Bold'),
    italic: localize('@sage/xtrem-ui/table-italic', 'Italic'),
    boldItalic: localize('@sage/xtrem-ui/table-boldItalic', 'Bold Italic'),
    predefined: localize('@sage/xtrem-ui/table-predefined', 'Predefined'),
    fillOpacity: localize('@sage/xtrem-ui/table-fillOpacity', 'Fill Opacity'),
    strokeOpacity: localize('@sage/xtrem-ui/table-strokeOpacity', 'Line Opacity'),
    histogramBinCount: localize('@sage/xtrem-ui/table-histogramBinCount', 'Bin count'),
    columnGroup: localize('@sage/xtrem-ui/table-columnGroup', 'Column'),
    barGroup: localize('@sage/xtrem-ui/table-barGroup', 'Bar'),
    pieGroup: localize('@sage/xtrem-ui/table-pieGroup', 'Pie'),
    lineGroup: localize('@sage/xtrem-ui/table-lineGroup', 'Line'),
    scatterGroup: localize('@sage/xtrem-ui/table-scatterGroup', 'X Y (Scatter)'),
    areaGroup: localize('@sage/xtrem-ui/table-areaGroup', 'Area'),
    histogramGroup: localize('@sage/xtrem-ui/table-histogramGroup', 'Histogram'),
    groupedColumnTooltip: localize('@sage/xtrem-ui/table-groupedColumnTooltip', 'Grouped'),
    stackedColumnTooltip: localize('@sage/xtrem-ui/table-stackedColumnTooltip', 'Stacked'),
    normalizedColumnTooltip: localize('@sage/xtrem-ui/table-normalizedColumnTooltip', '100% Stacked'),
    groupedBarTooltip: localize('@sage/xtrem-ui/table-groupedBarTooltip', 'Grouped'),
    stackedBarTooltip: localize('@sage/xtrem-ui/table-stackedBarTooltip', 'Stacked'),
    normalizedBarTooltip: localize('@sage/xtrem-ui/table-normalizedBarTooltip', '100% Stacked'),
    pieTooltip: localize('@sage/xtrem-ui/table-pieTooltip', 'Pie'),
    doughnutTooltip: localize('@sage/xtrem-ui/table-doughnutTooltip', 'Doughnut'),
    lineTooltip: localize('@sage/xtrem-ui/table-lineTooltip', 'Line'),
    groupedAreaTooltip: localize('@sage/xtrem-ui/table-groupedAreaTooltip', 'Area'),
    stackedAreaTooltip: localize('@sage/xtrem-ui/table-stackedAreaTooltip', 'Stacked'),
    normalizedAreaTooltip: localize('@sage/xtrem-ui/table-normalizedAreaTooltip', '100% Stacked'),
    scatterTooltip: localize('@sage/xtrem-ui/table-scatterTooltip', 'Scatter'),
    bubbleTooltip: localize('@sage/xtrem-ui/table-bubbleTooltip', 'Bubble'),
    histogramTooltip: localize('@sage/xtrem-ui/table-histogramTooltip', 'Histogram'),
    noDataToChart: localize('@sage/xtrem-ui/table-noDataToChart', 'No data available to be charted.'),
    pivotChartRequiresPivotMode: localize('@sage/xtrem-ui/table-pivotChartRequiresPivotMode', 'Pivot Chart requires Pivot Mode enabled.'),
}));
export default localeText;
//# sourceMappingURL=ag-grid-strings.js.map