/// <reference types="react" />
import type { ColDef, Column, ICellRendererParams, RowNode, ValueFormatterParams, ValueGetterParams, ValueSetterParams } from '@ag-grid-community/core';
import { type Dict, type LocalizeLocale } from '@sage/xtrem-shared';
import type { MarkRequired } from 'ts-essentials';
import { type OptionsMenuItem } from '../../component/control-objects';
import type { NestedCheckboxProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLinkProperties, NestedProgressProperties, NestedReferenceProperties, NestedRelativeDateProperties, NestedSelectProperties, NestedSwitchProperties } from '../../component/decorators';
import type { NestedCountProperties } from '../../component/field/count/count-types';
import type { InternalNestedGridProperties } from '../../component/field/field-control-objects';
import type { NestedLabelProperties } from '../../component/field/label/label-decorator';
import type { NestedNumericProperties } from '../../component/field/numeric/numeric-types';
import type { InternalTableProperties } from '../../component/field/table/table-component-types';
import type { NestedTextProperties } from '../../component/field/text/text-types';
import type { Nested } from '../../component/field/traits';
import type { NestedField, NestedFieldTypesWithoutTechnical, NestedFieldsProperties } from '../../component/nested-fields';
import type { GridRowActionType } from '../../component/types';
import type { CellWrapperProps } from '../../component/ui/table-shared/cell/cell-wrapper';
import type { FormattedNodeDetails, FormattedNodeDetailsProperty } from '../../service/metadata-types';
import type { AccessBindings } from '../../service/page-definition';
import type { ScreenBase } from '../../service/screen-base';
import type { ScreenBaseGenericType } from '../../types';
import { ContextType } from '../../types';
import type { Merge, SetRequired, ValueOrCallbackWithFieldValue } from '../types';
import type { AgGridColumnConfigWithAllColumns, AgGridColumnConfigWithScreenIdAndColDef } from './ag-grid-utility-types';
interface CellEditorProps extends Omit<ICellRendererParams, 'value'> {
    eventKey: string | null;
    initialValue: any;
    onValueChange: (value: any) => void;
    stopEditing: (suppressNavigateAfterEdit?: boolean) => void;
    value: string;
}
export interface CellParams<T extends Nested<any> = Nested, V = string> extends Omit<CellEditorProps, 'colDef' | 'value'>, CellProps<T> {
    colDef: MarkRequired<Omit<AgGridColumnConfigWithScreenIdAndColDef, 'cellRendererParams'>, 'field'> & {
        cellRendererParams: CellProps<T>;
    };
    value: V;
    node: RowNode;
    column: Column;
}
export interface CellProps<T> {
    columnId: string;
    contextNode?: keyof ScreenBaseGenericType<ScreenBase>;
    elementId: string;
    fieldProperties: WithNestedWrapper<T>;
    screenId: string;
    tableElementId: string;
    isEditing?: boolean;
    isParentFieldDisabled: boolean;
    isTableReadOnly?: ValueOrCallbackWithFieldValue<ScreenBase, boolean>;
    isTree: boolean;
}
type ICellParams<T extends Nested<any>> = CellProps<T> | ((p: any) => CellProps<T>);
type ColumnProps<T extends Nested<any>> = Merge<SetRequired<ColDef, 'cellRenderer'>, {
    cellRendererParams: ICellParams<T>;
    cellEditorParams?: ICellParams<T>;
}>;
export interface ColumnConfigurationProperties<T extends Nested<any>> {
    columnId: string;
    columnProperties: T;
    enumTypes: Dict<string[]>;
    nodeTypes: Dict<FormattedNodeDetails>;
    hasFloatingFilters: boolean;
    isParentFieldDisabled: boolean;
    level: number;
    locale: LocalizeLocale;
    screenId: string;
    tableElementId: string;
    tableProperties: InternalTableProperties<ScreenBase> | InternalNestedGridProperties<ScreenBase>;
    isReadOnly: ValueOrCallbackWithFieldValue<ScreenBase, boolean> | undefined;
    propertyGraphType: FormattedNodeDetailsProperty | null;
}
export type NestedProperties = NestedReferenceProperties | NestedLabelProperties | NestedCheckboxProperties | NestedDateProperties | NestedTextProperties | NestedProgressProperties | NestedNumericProperties | NestedFilterSelectProperties | NestedDropdownListProperties | NestedSelectProperties | NestedSwitchProperties;
export declare const defaultValueGetter: (params: Pick<ValueGetterParams, 'colDef' | 'data'>, screenId: string, columnProperties: NestedFieldsProperties<NestedFieldTypesWithoutTechnical, ScreenBase>) => (mapper?: (value: any) => any) => any;
export declare const defaultValueSetter: (params: ValueSetterParams) => boolean;
export declare const getReferenceFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedReferenceProperties>) => ColumnProps<NestedReferenceProperties>;
export declare const getImageFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedImageProperties>) => ColumnProps<NestedImageProperties>;
export declare const getLabelFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedLabelProperties>) => ColumnProps<NestedLabelProperties>;
export declare const getIconFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedIconProperties>) => ColumnProps<NestedIconProperties>;
export declare const getCountFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedCountProperties>) => ColumnProps<NestedCountProperties>;
export declare const getCheckboxFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedCheckboxProperties>) => ColumnProps<NestedCheckboxProperties>;
export declare const getDateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDateProperties>) => ColumnProps<NestedDateProperties>;
export declare const getValueFormatter: (screenId: string, columnProperties: NestedTextProperties | NestedNumericProperties) => (params: ValueFormatterParams) => string;
export declare const getTextFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedTextProperties>) => ColumnProps<NestedTextProperties>;
export declare const getLinkFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedLinkProperties>) => ColumnProps<NestedLinkProperties>;
export declare const getRelativeDateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedRelativeDateProperties>) => ColumnProps<NestedRelativeDateProperties>;
export declare const getProgressFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedProgressProperties>) => ColumnProps<NestedLinkProperties>;
export declare const getNumericFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedNumericProperties>) => ColumnProps<NestedNumericProperties>;
export declare const getAggregateFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedNumericProperties>) => ColumnProps<NestedNumericProperties>;
export declare const getFilterSelectFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedFilterSelectProperties>) => ColumnProps<NestedFilterSelectProperties>;
export declare const getDropdownListFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedDropdownListProperties>) => ColumnProps<NestedDropdownListProperties>;
export declare const getSelectFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedSelectProperties>) => ColumnProps<NestedSelectProperties>;
export declare const getSwitchFieldColumnConfiguration: (props: ColumnConfigurationProperties<NestedSwitchProperties>) => ColumnProps<NestedSwitchProperties>;
export declare const COLUMN_ID_ROW_SELECTION = "__select";
export declare const getRowSelectColumnConfiguration: ({ screenId, isParentFieldDisabled, tableElementId, node, fieldProperties, contextType, activeOptionsMenuItem, }: {
    tableElementId: string;
    screenId: string;
    isParentFieldDisabled: boolean;
    node: string;
    fieldProperties: Omit<InternalTableProperties, 'selectedRecords'>;
    contextType?: ContextType;
    activeOptionsMenuItem?: OptionsMenuItem;
}) => AgGridColumnConfigWithScreenIdAndColDef;
export declare const COLUMN_ID_LINE_NUMBER = "__line_number";
export declare const getLineNumberColumnConfiguration: (screenId: string) => AgGridColumnConfigWithScreenIdAndColDef;
export declare const COLUMN_ID_VALIDATIONS = "__validation";
export declare const getValidationColumnConfiguration: (screenId: string, getColumns: () => NestedField<any, any>[]) => AgGridColumnConfigWithAllColumns;
export declare const COLUMN_ID_AUTO_COLUMN = "ag-Grid-AutoColumn";
export declare const COLUMN_ID_ROW_ACTIONS = "__actions";
export declare const COLUMN_CELLCLASS_ROW_ACTIONS = "e-table-field-dropdown-actions-cell";
export declare const FOCUSED_BUT_BORDERLESS = "e-ag-cell-focus--no-border";
export declare const getDropdownActionsColumnConfiguration: (screenId: string, tableElementId: string, level: number, wrapper: WithNestedWrapper<any>['wrapper'], isParentFieldDisabled: boolean, inlineActions: GridRowActionType, dropdownActions: GridRowActionType, hasFloatingFilters: boolean) => AgGridColumnConfigWithScreenIdAndColDef;
export declare const frameworkComponents: Dict<any>;
export type WithNestedWrapper<T> = T & {
    wrapper: React.FC<CellWrapperProps>;
};
export declare function getTooltipMessage(props: CellParams<any, any>): string | undefined;
export declare function getTextAlignment(props: CellParams<any>): 'left' | 'right' | 'center';
export declare function getCellProps<T extends Nested<any>>({ columnProperties, tableProperties, tableElementId, columnId, screenId, isParentFieldDisabled, level, isReadOnly, }: ColumnConfigurationProperties<T>): CellProps<T>;
export interface AddStaticColumnsArgs {
    screenId: string;
    fieldProperties: Omit<InternalTableProperties, 'selectedRecords'>;
    columns?: AgGridColumnConfigWithScreenIdAndColDef[];
    lookupSelectionMode?: 'single' | 'multiple';
    tableElementId: string;
    level: number;
    isParentFieldDisabled: boolean;
    contextType?: ContextType;
    hasFloatingFilters: boolean;
    activeOptionsMenuItem?: OptionsMenuItem;
    accessBindings: AccessBindings;
}
export declare const addStaticColumns: ({ accessBindings, activeOptionsMenuItem, columns, contextType, fieldProperties, hasFloatingFilters, isParentFieldDisabled, level, lookupSelectionMode, screenId, tableElementId, }: AddStaticColumnsArgs) => void;
export declare const INTERNAL_COLUMN_IDS: string[];
export {};
//# sourceMappingURL=ag-grid-column-config.d.ts.map