import type { AccessStatus, Dict } from '@sage/xtrem-shared';
import type { CollectionActionAccessConfiguration, HasAccessRights } from '../component/field/traits';
import type { ReadonlyFieldProperties } from '../component/readonly-field-control-object';
import type { AccessBindings } from '../service/page-definition';
import type { NodePropertyType } from '../types';
import type { DataTypeDetails, FormattedNodeDetails } from '../service/metadata-types';
export interface AccessStatusProps {
    accessBindings: AccessBindings;
    bind: any;
    elementProperties: ReadonlyFieldProperties | HasAccessRights;
    contextNode?: NodePropertyType;
    nodeTypes: Dict<FormattedNodeDetails>;
    dataTypes: Dict<DataTypeDetails>;
}
export declare const getElementAccessStatus: ({ accessBindings, bind, elementProperties, contextNode, nodeTypes, }: AccessStatusProps) => AccessStatus | undefined;
export declare const getElementAccessStatusWithoutId: (accessBindings: AccessBindings, access?: CollectionActionAccessConfiguration) => AccessStatus;
//# sourceMappingURL=access-utils.d.ts.map