import type { BlockControlObject, PageControlObject, SectionControlObject } from '../component/control-objects';
import type { DialogControl } from '../service/dialog-service';
import type { ScreenBaseDefinition } from '../service/screen-base-definition';
import type { Dict } from '@sage/xtrem-shared';
import type * as React from 'react';
import type { QueryParameters } from '../utils/types';
export type DialogLevel = 'info' | 'success' | 'error' | 'warn';
export type DialogContentType = string | Array<SectionControlObject | BlockControlObject> | SectionControlObject | BlockControlObject | Error | PageControlObject | null;
export type DialogSize = 'extra-small' | 'small' | 'medium-small' | 'medium' | 'medium-large' | 'large' | 'extra-large';
export interface DialogBodyContentProps<T extends BaseDialogOptions = BaseDialogOptions> {
    dialog: DialogDescription<T>;
    screenDefinition?: ScreenBaseDefinition;
    availableColumns: number;
    defaultFocusRef?: React.RefObject<any>;
    selectedSection?: string | null;
    noHeader?: boolean;
    onStepOneSection: (direction: 1 | -1) => void;
    isFirstSection: boolean;
    isLastSection: boolean;
}
export interface DialogButtonOptions {
    className?: string;
    isDisabled?: boolean;
    isHidden?: boolean;
    isNegative?: boolean;
    text?: string;
}
export interface BaseDialogOptions {
    rightAligned?: boolean;
    fullScreen?: boolean;
    size?: DialogSize;
    resolveOnCancel?: boolean;
    reverseButtons?: boolean;
    mdContent?: boolean;
    isDirtyCheck?: boolean;
    height?: number;
}
export interface PageDialogOptions extends BaseDialogOptions {
    /** When this option is set, no warning is displayed if the user closes the dialog with unsaved content. */
    skipDirtyCheck?: boolean;
    /** Initial value of the dialog. When the value is set, the field values of the page dialog are automatically populated. */
    values?: Dict<any>;
    /** Set to true to duplicate the page */
    isDuplicate?: boolean;
    /** Optional title for the dialog */
    title?: string;
    /** Optional subtitle for the dialog */
    subtitle?: string;
}
export interface CustomDialogOptions extends DialogOptions {
    dialogTitle?: string;
}
export interface DialogOptions extends BaseDialogOptions {
    acceptButton?: DialogButtonOptions;
    cancelButton?: DialogButtonOptions;
}
export interface DialogButton {
    className?: string;
    isDisabled?: boolean;
    isHidden?: boolean;
    onClick: (value?: any) => void;
    text: string;
    isNegative?: boolean;
}
export type DialogType = 'page' | 'custom' | 'message' | 'confirmation' | 'error' | 'unknown';
export interface DialogDescription<T extends BaseDialogOptions = BaseDialogOptions> {
    dialogId: number;
    isSticker: boolean;
    isDirtyCheck?: boolean;
    buttons: Dict<DialogButton>;
    content: DialogContentType;
    level: DialogLevel;
    options: T;
    screenId: string | null;
    title?: string;
    subtitle?: string;
    dialogControl: DialogControl;
    type?: DialogType;
}
export interface IDialogControl extends Promise<any> {
    cancel: () => void;
    finally(onFinally?: (() => void) | undefined | null): Promise<any>;
    then<TResult1 = any, TResult2 = any>(onFulfilled?: ((value: any) => TResult1 | PromiseLike<TResult1>) | undefined | null, onRejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    catch<TResult = any>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): Promise<any | TResult>;
}
export type CustomDialogContentType = SectionControlObject | BlockControlObject | Array<SectionControlObject> | Array<BlockControlObject>;
export interface IDialogApi {
    confirmation: (level: DialogLevel, title: string, message: string, options?: DialogOptions) => IDialogControl;
    message: (level: DialogLevel, title: string, message: string, options?: DialogOptions) => IDialogControl;
    custom: (level: DialogLevel, content: CustomDialogContentType, options?: CustomDialogOptions) => IDialogControl;
    page: (path: string, queryParameters?: QueryParameters, options?: PageDialogOptions) => Promise<any>;
}
//# sourceMappingURL=dialogs.d.ts.map