export interface FieldLocator {
    screenId: string;
    elementId: string;
    recordId?: string;
    title?: string;
    nestedElementId?: string;
    level?: number;
}
/**
 * This interface should be implemented by the native mobile application. It contains a set
 * of event handlers which are required for the communication between the mobile and the native apps.
 */
export interface WrapperMobileAppInterface {
    /** Called when the mobile app recognizes the presence of the mobile wrapper and it registered its global communication interface */
    onLoad?: () => void;
    /**
     * Called when a scannable field gets focussed and the scanner button can be displayed.
     * @param fieldLocator unique field identifier
     */
    onFocus?: (fieldLocator: FieldLocator) => void;
    /**
     * Called when a scannable field loses focus and and the scanner button should be hidden.
     * @param fieldLocator unique field identifier
     */
    onBlur?: (fieldLocator?: FieldLocator) => void;
    /**
     * Called when the mobile app initiates scanning
     */
    captureData?: (fieldLocator: FieldLocator) => void;
}
/**
 * This interface should be implemented by the web app. These events are called by the mobile app to notify the web app about certain events.
 * */
export interface WrapperWebAppInterface {
    /** Notifies the web app that the scanner activity was successfully opened. */
    startScanning: (fieldLocator: FieldLocator) => void;
    /** Notifies the web app that the scanner successfully scanned some value and the scanner was closed. */
    setRawData: (fieldLocator: FieldLocator, rawValue: string) => void;
}
/**
 * Initiate scanning from the web application.
 * This method is called by the web app to request the opening of the scanner activity.
 * It also takes a callback which is invoked by the native app if the scanning is successful.
 */
export declare const captureData: (fieldLocator: FieldLocator, callback: (rawValue: string) => void) => void;
/**
 * Update the native app about the currently focussed field.
 * This method is called by the web app to notify the native app that the focus moved to a new field which is ready for scanning.
 * It also takes a callback which is invoked by the native app if the scanning is successful.
 **/
export declare const onFocus: (fieldLocator: FieldLocator, callback: (rawValue: string) => void) => void;
/**
 * Update the native app about the currently focussed field.
 * This method is called by the web app to notify the native app that the focus was removed from a field and it should hide the
 * scanner button.
 */
export declare const onBlur: (fieldLocator?: FieldLocator) => void;
//# sourceMappingURL=wrapper-service.d.ts.map