import type { Dict } from '@sage/xtrem-shared';
import type { UiComponentProperties } from '../component/abstract-ui-control-object';
import type { DateDecoratorProperties, MultiDropdownDecoratorProperties, NumericDecoratorProperties, TextAreaDecoratorProperties, TextDecoratorProperties } from '../component/decorators';
import type { EditableFieldProperties } from '../component/editable-field-control-object';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { XtremAppState } from '../redux';
import type { NodePropertyType } from '../types';
import type { AccessBindings } from './page-definition';
import type { ScreenBase } from './screen-base';
import type { ValidationResult } from './screen-base-definition';
import type { DataTypeDetails, FormattedNodeDetails } from './metadata-types';
type ExtendedFieldProperties = EditableFieldProperties & TextDecoratorProperties & TextAreaDecoratorProperties & NumericDecoratorProperties & DateDecoratorProperties & MultiDropdownDecoratorProperties;
export declare const CHILDREN_VALIDATION_ERROR_MESSAGE: () => string;
export declare const CHILDREN_VALIDATION_RULE: () => string;
export declare const executeValidationRulesOnField: ({ screenId, elementId, fieldProperties, value, rowValue: inputRowValue, columnId, recordId, }: {
    screenId: string;
    elementId: string;
    fieldProperties?: ExtendedFieldProperties;
    value: any;
    rowValue?: Dict<any>;
    columnId?: string;
    recordId?: string;
}) => Promise<ValidationResult[]>;
export declare const checkNestedRecordValidationStatus: ({ rowValue, columnDefinitions, columnsToValidate, screenId, elementId, recordId, }: {
    screenId: string;
    elementId: string;
    rowValue: Dict<any>;
    columnDefinitions: NestedField<ScreenBase, NestedFieldTypes>[];
    columnsToValidate: Set<string>;
    recordId: string;
}) => Promise<Dict<ValidationResult>>;
/**
 * The function checks all validation rules.
 *
 * @param screenElement
 * @param elementId
 * @param componentProperties
 * @param value
 */
export declare const checkValidationStatus: (screenElement: ScreenBase, elementId: string, componentProperties: Dict<UiComponentProperties>, value: any, accessBindings: AccessBindings, nodeTypes: Dict<FormattedNodeDetails>, dataTypes: Dict<DataTypeDetails>, contextNode?: NodePropertyType) => Promise<ValidationResult[]>;
export declare const getSectionValidationMessage: (screenId: string, sectionId: string, state: XtremAppState) => string | null;
export declare const getValidationState: (screenId: string, elementId: string, state?: XtremAppState) => boolean;
export {};
//# sourceMappingURL=validation-service.d.ts.map